/*
 * Copyright 1998-2009 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2009 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#ifndef __VIA_COMMON_H__
#define __VIA_COMMON_H__

#include "via_driver.h"

typedef struct  _IoReg
{
    CARD16    index;
    CARD8     mask;
    CARD8     value;
}ViaIoReg, *ViaIoRegPtr;

typedef struct _IoBit
{
    CARD16     ioAddr;
    CARD8      startBit;
    CARD8      endBit;
}ViaIoBit, *ViaIoBitPtr;

/*Subchip IO data structure*/
typedef struct _IoData {
    unsigned char   index;
    unsigned char   mask;
    unsigned char   data;
}ViaIoData, *ViaIoDataPtr;

/*Bit Defination*/
#ifndef BIT0
#define BIT0        0x00000001
#endif

#ifndef BIT1
#define BIT1        0x00000002
#endif

#ifndef BIT2
#define BIT2        0x00000004
#endif

#ifndef BIT3
#define BIT3        0x00000008
#endif

#ifndef BIT4
#define BIT4        0x00000010
#endif

#ifndef BIT5
#define BIT5        0x00000020
#endif

#ifndef BIT6
#define BIT6        0x00000040
#endif

#ifndef BIT7
#define BIT7        0x00000080
#endif

#ifndef BIT8
#define BIT8        0x00000100
#endif

#ifndef BIT9
#define BIT9        0x00000200
#endif

#ifndef BIT10
#define BIT10       0x00000400
#endif

#ifndef BIT11
#define BIT11       0x00000800
#endif

#ifndef BIT12
#define BIT12       0x00001000
#endif

#ifndef BIT13
#define BIT13       0x00002000
#endif

#ifndef BIT14
#define BIT14       0x00004000
#endif

#ifndef BIT15
#define BIT15       0x00008000
#endif

#ifndef BIT16
#define BIT16       0x00010000
#endif

#ifndef BIT17
#define BIT17       0x00020000
#endif

#ifndef BIT18
#define BIT18       0x00040000
#endif

#ifndef BIT19
#define BIT19       0x00080000
#endif

#ifndef BIT20
#define BIT20       0x00100000
#endif

#ifndef BIT21
#define BIT21       0x00200000
#endif

#ifndef BIT22
#define BIT22       0x00400000
#endif

#ifndef BIT23
#define BIT23       0x00800000
#endif

#ifndef BIT24
#define BIT24       0x01000000
#endif

#ifndef BIT25
#define BIT25       0x02000000
#endif

#ifndef BIT26
#define BIT26       0x04000000
#endif

#define REG_ZCR      0x3D4
#define REG_ZSR      0x3C4
#define REG_ZGR      0x3CE
#define REG_ZAR      0x3C0
#define REG_RMISC    0x3CC
#define REG_WMISC    0x3C2
#define REG_STATUS   0x3DA
#define REG_PEL      0x3C8

#define IS_ZSR       0x0100
#define REG_INDEX_MASK  0xff
#define VGAIO_BASE   0x8000


/* Sequencer Registers */
#define REG_SR00         0x0100
#define REG_SR01         0x0101
#define REG_SR02         0x0102
#define REG_SR03         0x0103
#define REG_SR04         0x0104
#define REG_SR05         0x0105
#define REG_SR06         0x0106
#define REG_SR07         0x0107
#define REG_SR08         0x0108
#define REG_SR09         0x0109
#define REG_SR10         0x0110
#define REG_SR11         0x0111
#define REG_SR12         0x0112
#define REG_SR13         0x0113
#define REG_SR14         0x0114
#define REG_SR15         0x0115
#define REG_SR16         0x0116
#define REG_SR17         0x0117
#define REG_SR18         0x0118
#define REG_SR19         0x0119
#define REG_SR1A         0x011A
#define REG_SR1B         0x011B
#define REG_SR1C         0x011C
#define REG_SR1D         0x011D
#define REG_SR1E         0x011E
#define REG_SR1F         0x011F
#define REG_SR20         0x0120
#define REG_SR21         0x0121
#define REG_SR22         0x0122
#define REG_SR23         0x0123
#define REG_SR24         0x0124
#define REG_SR25         0x0125
#define REG_SR26         0x0126
#define REG_SR27         0x0127
#define REG_SR28         0x0128
#define REG_SR29         0x0129
#define REG_SR2A         0x012A
#define REG_SR2B         0x012B
#define REG_SR2C         0x012C
#define REG_SR2D         0x012D
#define REG_SR2E         0x012E
#define REG_SR2F         0x012F
#define REG_SR30         0x0130
#define REG_SR31         0x0131
#define REG_SR32         0x0132
#define REG_SR33         0x0133
#define REG_SR34         0x0134
#define REG_SR35         0x0135
#define REG_SR36         0x0136
#define REG_SR37         0x0137
#define REG_SR38         0x0138
#define REG_SR39         0x0139
#define REG_SR3A         0x013A
#define REG_SR3B         0x013B
#define REG_SR3C         0x013C
#define REG_SR3D         0x013D
#define REG_SR3E         0x013E
#define REG_SR3F         0x013F
#define REG_SR40         0x0140
#define REG_SR41         0x0141
#define REG_SR42         0x0142
#define REG_SR43         0x0143
#define REG_SR44         0x0144
#define REG_SR45         0x0145
#define REG_SR46         0x0146
#define REG_SR47         0x0147
#define REG_SR48         0x0148
#define REG_SR49         0x0149
#define REG_SR4A         0x014A
#define REG_SR4B         0x014B
#define REG_SR4C         0x014C
#define REG_SR4D         0x014D
#define REG_SR4F         0x014F
#define REG_SR50         0x0150
#define REG_SR51         0x0151
#define REG_SR52         0x0152
#define REG_SR57         0x0157
#define REG_SR58         0x0158
#define REG_SR59         0x0159
#define REG_SR5E         0x015E
#define REG_SR5D         0x015D
#define REG_SR63         0x0163
#define REG_SR65         0x0165
#define REG_SR66         0x0166
#define REG_SR67         0x0167
#define REG_SR69         0x0169
#define REG_SR70         0x0170
#define REG_SR71         0x0171
#define REG_SR72         0x0172
#define REG_SR73         0x0173
#define REG_SR74         0x0174
#define REG_SR75         0x0175
#define REG_SR78         0x0178
#define REG_SR79         0x0179
#define REG_SR7A         0x017A

/* CRT Controller Registers */
#define REG_CR00         0x0000
#define REG_CR01         0x0001
#define REG_CR02         0x0002
#define REG_CR03         0x0003
#define REG_CR04         0x0004
#define REG_CR05         0x0005
#define REG_CR06         0x0006
#define REG_CR07         0x0007
#define REG_CR08         0x0008
#define REG_CR09         0x0009
#define REG_CR0A         0x000A
#define REG_CR0B         0x000B
#define REG_CR0C         0x000C
#define REG_CR0D         0x000D
#define REG_CR0E         0x000E
#define REG_CR0F         0x000F
#define REG_CR10         0x0010
#define REG_CR11         0x0011
#define REG_CR12         0x0012
#define REG_CR13         0x0013
#define REG_CR14         0x0014
#define REG_CR15         0x0015
#define REG_CR16         0x0016
#define REG_CR17         0x0017
#define REG_CR18         0x0018

/* Extend REG_CRT Controller Registers */
#define REG_CR30         0x0030
#define REG_CR31         0x0031
#define REG_CR32         0x0032
#define REG_CR33         0x0033
#define REG_CR34         0x0034
#define REG_CR35         0x0035
#define REG_CR36         0x0036
#define REG_CR37         0x0037
#define REG_CR38         0x0038
#define REG_CR39         0x0039
#define REG_CR3A         0x003A
#define REG_CR3B         0x003B
#define REG_CR3C         0x003C
#define REG_CR3D         0x003D
#define REG_CR3E         0x003E
#define REG_CR3F         0x003F
#define REG_CR40         0x0040
#define REG_CR41         0x0041
#define REG_CR42         0x0042
#define REG_CR43         0x0043
#define REG_CR44         0x0044
#define REG_CR45         0x0045
#define REG_CR46         0x0046
#define REG_CR47         0x0047
#define REG_CR48         0x0048
#define REG_CR49         0x0049
#define REG_CR4A         0x004A
#define REG_CR4B         0x004B
#define REG_CR4C         0x004C
#define REG_CR4D         0x004D
#define REG_CR4E         0x004E
#define REG_CR4F         0x004F
#define REG_CR50         0x0050
#define REG_CR51         0x0051
#define REG_CR52         0x0052
#define REG_CR53         0x0053
#define REG_CR54         0x0054
#define REG_CR55         0x0055
#define REG_CR56         0x0056
#define REG_CR57         0x0057
#define REG_CR58         0x0058
#define REG_CR59         0x0059
#define REG_CR5A         0x005A
#define REG_CR5B         0x005B
#define REG_CR5C         0x005C
#define REG_CR5D         0x005D
#define REG_CR5E         0x005E
#define REG_CR5F         0x005F
#define REG_CR60         0x0060
#define REG_CR61         0x0061
#define REG_CR62         0x0062
#define REG_CR63         0x0063
#define REG_CR64         0x0064
#define REG_CR65         0x0065
#define REG_CR66         0x0066
#define REG_CR67         0x0067
#define REG_CR68         0x0068
#define REG_CR69         0x0069
#define REG_CR6A         0x006A
#define REG_CR6B         0x006B
#define REG_CR6C         0x006C
#define REG_CR6D         0x006D
#define REG_CR6E         0x006E
#define REG_CR6F         0x006F
#define REG_CR70         0x0070
#define REG_CR71         0x0071
#define REG_CR72         0x0072
#define REG_CR73         0x0073
#define REG_CR74         0x0074
#define REG_CR75         0x0075
#define REG_CR76         0x0076
#define REG_CR77         0x0077
#define REG_CR78         0x0078
#define REG_CR79         0x0079
#define REG_CR7A         0x007A
#define REG_CR7B         0x007B
#define REG_CR7C         0x007C
#define REG_CR7D         0x007D
#define REG_CR7E         0x007E
#define REG_CR7F         0x007F
#define REG_CR80         0x0080
#define REG_CR81         0x0081
#define REG_CR82         0x0082
#define REG_CR83         0x0083
#define REG_CR84         0x0084
#define REG_CR85         0x0085
#define REG_CR86         0x0086
#define REG_CR87         0x0087
#define REG_CR88         0x0088
#define REG_CR89         0x0089
#define REG_CR8A         0x008A
#define REG_CR8B         0x008B
#define REG_CR8C         0x008C
#define REG_CR8D         0x008D
#define REG_CR8E         0x008E
#define REG_CR8F         0x008F
#define REG_CR90         0x0090
#define REG_CR91         0x0091
#define REG_CR92         0x0092
#define REG_CR93         0x0093
#define REG_CR94         0x0094
#define REG_CR95         0x0095
#define REG_CR96         0x0096
#define REG_CR97         0x0097
#define REG_CR98         0x0098
#define REG_CR99         0x0099
#define REG_CR9A         0x009A
#define REG_CR9B         0x009B
#define REG_CR9C         0x009C
#define REG_CR9D         0x009D
#define REG_CR9E         0x009E
#define REG_CR9F         0x009F
#define REG_CRA0         0x00A0
#define REG_CRA1         0x00A1
#define REG_CRA2         0x00A2
#define REG_CRA3         0x00A3
#define REG_CRA4         0x00A4
#define REG_CRA5         0x00A5
#define REG_CRA6         0x00A6
#define REG_CRA7         0x00A7
#define REG_CRA8         0x00A8
#define REG_CRA9         0x00A9
#define REG_CRAA         0x00AA
#define REG_CRAB         0x00AB
#define REG_CRAC         0x00AC
#define REG_CRD0         0x00D0
#define REG_CRD1         0x00D1
#define REG_CRD2         0x00D2
#define REG_CRD3         0x00D3
#define REG_CRD4         0x00D4
#define REG_CRD5         0x00D5
#define REG_CRD6         0x00D6
#define REG_CRD7         0x00D7
#define REG_CRDD         0x00DD
#define REG_CRE8         0x00E8
#define REG_CREC         0x00EC
#define REG_CRED         0x00ED
#define REG_CREE         0x00EE
#define REG_CREF         0x00EF
#define REG_CRF0         0x00F0
#define REG_CRF1         0x00F1
#define REG_CRF2         0x00F2
#define REG_CRF3         0x00F3
#define REG_CRF4         0x00F4
#define REG_CRF5         0x00F5
#define REG_CRF6         0x00F6
#define REG_CRF7         0x00F7
#define REG_CRF8         0x00F8
#define REG_CRF9         0x00F9
#define REG_CRFA         0x00FA
#define REG_CRFB         0x00FB
#define REG_CRFC         0x00FC
#define REG_CRFD         0x00FD
#define REG_CRFE         0x00FE
#define REG_CRFF         0x00FF

static ViaIoReg InitialRegTable_CN700[] =
{
    {REG_SR10,0xFF,0x01},
    {REG_SR15,0x02,0x02},
    {REG_SR16,0xBF,0x08},
    {REG_SR17,0xFF,0x1F},
    {REG_SR18,0xFF,0x4E},
    {REG_SR1A,0xFB,0x82},
    {REG_SR1B,0xFF,0xF0},
    {REG_SR1F,0xFF,0x00},
    {REG_SR1E,0xF7,0x01},
    {REG_SR22,0xFF,0x1F},
    {REG_SR2E,0xFF,0xFF},
    {REG_SR3F,0xFF,0xFF},
    {REG_SR40,0xF7,0x00},  
    {REG_CR09,0xFF,0x00},            /* Initial CR09=0 */
    {REG_CR11,0x8F,0x00},            /* IGA1 initial  Vertical end */ 
    {REG_CR17,0x7F,0x00},            /* IGA1 CRT Mode control init */
    {REG_CR30,0xFF,0x04},
    {REG_CR32,0xFF,0x00},
    {REG_CR33,0x7F,0x00},
    {REG_CR34,0xFF,0x00},
    {REG_CR35,0xFF,0x00},
    {REG_CR36,0xFF,0x31},
    {REG_CR41,0xFF,0x80},
    {REG_CR42,0xFF,0x00},
    {REG_CR55,0x80,0x00},
    {REG_CR5D,0x80,0x00},            /*Horizontal Retrace Start bit[11] should be 0*/ 
    {REG_CR68,0xFF,0x67},            /* Default FIFO For IGA2 */ 
    {REG_CR69,0xFF,0x00},
    {REG_CR6A,0xFD,0x60},
    {REG_CR6B,0xFF,0x00},
    {REG_CR6C,0xFF,0x00},  
    {REG_CR77,0xFF,0x00},            /* LCD scaling Factor      */ 
    {REG_CR78,0xFF,0x00},            /* LCD scaling Factor      */ 
    {REG_CR79,0xFF,0x00},            /* LCD scaling Factor      */ 
    {REG_CR9F,0x03,0x00},            /* LCD scaling Factor      */ 
    {REG_CR7A,0xFF,0x01},            /* LCD Scaling Parameter 1 */ 
    {REG_CR7B,0xFF,0x02},            /* LCD Scaling Parameter 2*/ 
    {REG_CR7C,0xFF,0x03},            /* LCD Scaling Parameter 3 */ 
    {REG_CR7D,0xFF,0x04},            /* LCD Scaling Parameter 4*/ 
    {REG_CR7E,0xFF,0x07},            /* LCD Scaling Parameter 5*/ 
    {REG_CR7F,0xFF,0x0A},            /* LCD Scaling Parameter 6*/ 
    {REG_CR80,0xFF,0x0D},            /* LCD Scaling Parameter 7*/ 
    {REG_CR81,0xFF,0x13},            /* LCD Scaling Parameter 8*/ 
    {REG_CR82,0xFF,0x16},            /* LCD Scaling Parameter 9*/
    {REG_CR83,0xFF,0x19},            /* LCD Scaling Parameter 10*/ 
    {REG_CR84,0xFF,0x1C},            /* LCD Scaling Parameter 11*/ 
    {REG_CR85,0xFF,0x1D},            /* LCD Scaling Parameter 12*/ 
    {REG_CR86,0xFF,0x1E},            /* LCD Scaling Parameter 13*/ 
    {REG_CR87,0xFF,0x1F},            /* LCD Scaling Parameter 14*/ 
    {REG_CR88,0xFF,0x40},            /* LCD Panel Type */ 
    {REG_CR89,0xFF,0x00},            /* LCD Timing Control 0 */ 
    {REG_CR8A,0xFF,0x88},            /* LCD Timing Control 1*/ 
    {REG_CR8B,0xFF,0x5D},            /* LCD Power Sequence Control 0*/ 
    {REG_CR8C,0xFF,0x2B},            /* LCD Power Sequence Control 1*/ 
    {REG_CR8D,0xFF,0x6F},            /* LCD Power Sequence Control 2*/ 
    {REG_CR8E,0xFF,0x2B},            /* LCD Power Sequence Control 3*/ 
    {REG_CR8F,0xFF,0x01},            /* LCD Power Sequence Control 4*/ 
    {REG_CR90,0xFF,0x01},            /* LCD Power Sequence Control 5*/ 
    {REG_CR91,0xFF,0xA0},            /* 24/12 bit LVDS Data off*/ 
    {REG_CR96,0xFF,0x00},
    {REG_CR97,0xFF,0x00},
    {REG_CR99,0xFF,0x00},
    {REG_CR9B,0xFF,0x00},
    {REG_CR9D,0xFF,0x80},
    {REG_CR9E,0xFF,0x80}

};
#define NUM_TOTAL_CN700_INIT_REG_TBL CMDISP_ARRAYSIZE(InitialRegTable_CN700)


static ViaIoReg InitialRegTable_CX700[] = 
{
    {REG_SR10, 0xFF, 0x01},
    {REG_SR15, 0x02, 0x02},
    {REG_SR16, 0xBF, 0x08},
    {REG_SR17, 0xFF, 0x1F},
    {REG_SR18, 0xFF, 0x4E},
    {REG_SR1A, 0xFB, 0x08},
    {REG_SR1B, 0xFF, 0xF0},
    {REG_SR1E, 0x07, 0x01},
    {REG_SR2A, 0xF0, 0x00},
    {REG_SR2D, 0xFF, 0xFF},          /* VCK and LCK PLL power on.           */ 
    {REG_CR09, 0xFF, 0x00},          /* Initial CR09=0			           */
    {REG_CR11, 0x8F, 0x00},		    /* IGA1 initial  Vertical end          */
    {REG_CR17, 0x7F, 0x00}, 		    /* IGA1 CRT Mode control init          */
    {REG_CR0A, 0xFF, 0x1E},          /* Cursor Start                        */ 
    {REG_CR0B, 0xFF, 0x00},          /* Cursor End                          */ 
    {REG_CR0E, 0xFF, 0x00},          /* Cursor Location High                */ 
    {REG_CR0F, 0xFF, 0x00},          /* Cursor Localtion Low                */ 
    {REG_CR32, 0xFF, 0x00},
    {REG_CR33, 0x7F, 0x00},
    {REG_CR34, 0xFF, 0x00},
    {REG_CR35, 0xFF, 0x00},
    {REG_CR36, 0x38, 0x30},
    {REG_CR69, 0xFF, 0x00},
    {REG_CR6A, 0xFD, 0x60},
    {REG_CR6B, 0xFF, 0x00},
    {REG_CR6C, 0xFF, 0x00},
    {REG_CR7A, 0xFF, 0x01},          /* LCD Scaling Parameter 1             */ 
    {REG_CR7B, 0xFF, 0x02},          /* LCD Scaling Parameter 2             */ 
    {REG_CR7C, 0xFF, 0x03},          /* LCD Scaling Parameter 3             */ 
    {REG_CR7D, 0xFF, 0x04},          /* LCD Scaling Parameter 4             */ 
    {REG_CR7E, 0xFF, 0x07},          /* LCD Scaling Parameter 5             */ 
    {REG_CR7F, 0xFF, 0x0A},          /* LCD Scaling Parameter 6             */ 
    {REG_CR80, 0xFF, 0x0D},          /* LCD Scaling Parameter 7             */ 
    {REG_CR81, 0xFF, 0x13},          /* LCD Scaling Parameter 8             */ 
    {REG_CR82, 0xFF, 0x16},          /* LCD Scaling Parameter 9             */ 
    {REG_CR83, 0xFF, 0x19},          /* LCD Scaling Parameter 10            */ 
    {REG_CR84, 0xFF, 0x1C},          /* LCD Scaling Parameter 11            */ 
    {REG_CR85, 0xFF, 0x1D},          /* LCD Scaling Parameter 12            */ 
    {REG_CR86, 0xFF, 0x1E},          /* LCD Scaling Parameter 13            */ 
    {REG_CR87, 0xFF, 0x1F},          /* LCD Scaling Parameter 14            */ 
    {REG_CR88, 0xFF, 0x40},          /* LCD Panel Type                      */ 
    {REG_CR89, 0xFF, 0x00},          /* LCD Timing Control 0                */ 
    {REG_CR8A, 0xFF, 0x88},          /* LCD Timing Control 1                */ 
    {REG_CRD4, 0xFF, 0x81},          /* Second power sequence control       */ 
    {REG_CR91, 0xFF, 0x80},          /* 24/12 bit LVDS Data off             */ 
    {REG_CR96, 0xFF, 0x00},
    {REG_CR97, 0xFF, 0x00},
    {REG_CR99, 0xFF, 0x00},
    {REG_CR9B, 0xFF, 0x00},
    {REG_CRD2, 0xFF, 0xFF}           /* TMDS/LVDS control register.         */

};
#define NUM_TOTAL_CX700_INIT_REG_TBL CMDISP_ARRAYSIZE(InitialRegTable_CX700)


static ViaIoReg InitialRegTable_VX855[] =
{
    {REG_SR10, 0xFF, 0x01},
    {REG_SR15, 0x02, 0x02},
    {REG_SR16, 0xBF, 0x08},
    {REG_SR17, 0xFF, 0x1F},
    {REG_SR18, 0xFF, 0x4E},
    {REG_SR1A, 0xFB, 0x08},
    {REG_SR1B, 0xFF, 0xF0},
    {REG_SR1E, 0x07, 0x01},
    {REG_SR2A, 0xF0, 0x00},
    {REG_SR58, 0xFF, 0x00},
    {REG_SR59, 0xFF, 0x00},
    {REG_SR2D, 0xFF, 0xFF},          /* VCK and LCK PLL power on.   */ 
    {REG_CR09, 0xFF, 0x00},          /* Initial CR09=0              */
    {REG_CR11, 0x8F, 0x00},			/* IGA1 initial  Vertical end  */
    {REG_CR17, 0x7F, 0x00}, 			/* IGA1 CRT Mode control init  */
    {REG_CR0A, 0xFF, 0x1E},          /* Cursor Start                */ 
    {REG_CR0B, 0xFF, 0x00},          /* Cursor End                  */ 
    {REG_CR0E, 0xFF, 0x00},          /* Cursor Location High        */ 
    {REG_CR0F, 0xFF, 0x00},          /* Cursor Localtion Low        */ 
    {REG_CR32, 0xFF, 0x00},
    {REG_CR33, 0x7F, 0x00},
    {REG_CR34, 0xFF, 0x00},
    {REG_CR35, 0xFF, 0x00},
    {REG_CR36, 0x38, 0x30},
    {REG_CR69, 0xFF, 0x00},
    {REG_CR6A, 0xFD, 0x60},
    {REG_CR6B, 0xFF, 0x00},
    {REG_CR6C, 0xFF, 0x00},
    {REG_CR7A, 0xFF, 0x01},          /* LCD Scaling Parameter 1     */ 
    {REG_CR7B, 0xFF, 0x02},          /* LCD Scaling Parameter 2     */ 
    {REG_CR7C, 0xFF, 0x03},          /* LCD Scaling Parameter 3     */ 
    {REG_CR7D, 0xFF, 0x04},          /* LCD Scaling Parameter 4     */ 
    {REG_CR7E, 0xFF, 0x07},          /* LCD Scaling Parameter 5     */ 
    {REG_CR7F, 0xFF, 0x0A},          /* LCD Scaling Parameter 6     */ 
    {REG_CR80, 0xFF, 0x0D},          /* LCD Scaling Parameter 7     */ 
    {REG_CR81, 0xFF, 0x13},          /* LCD Scaling Parameter 8     */ 
    {REG_CR82, 0xFF, 0x16},          /* LCD Scaling Parameter 9     */ 
    {REG_CR83, 0xFF, 0x19},          /* LCD Scaling Parameter 10    */ 
    {REG_CR84, 0xFF, 0x1C},          /* LCD Scaling Parameter 11    */ 
    {REG_CR85, 0xFF, 0x1D},          /* LCD Scaling Parameter 12    */ 
    {REG_CR86, 0xFF, 0x1E},          /* LCD Scaling Parameter 13    */ 
    {REG_CR87, 0xFF, 0x1F},          /* LCD Scaling Parameter 14    */ 
    {REG_CR88, 0xFF, 0x40},          /* LCD Panel Type              */ 
    {REG_CR89, 0xFF, 0x00},          /* LCD Timing Control 0        */ 
    {REG_CR8A, 0xFF, 0x88},          /* LCD Timing Control 1        */ 
    {REG_CRD4, 0xFF, 0x81},          /* Second power sequence control */ 
    {REG_CR91, 0xFF, 0x80},          /* 24/12 bit LVDS Data off     */ 
    {REG_CR96, 0xFF, 0x00},
    {REG_CR97, 0xFF, 0x00},
    {REG_CR99, 0xFF, 0x00},
    {REG_CR9B, 0xFF, 0x00},
    {REG_CRD2, 0xFF, 0xFF}           /* TMDS/LVDS control register. */

};
#define NUM_TOTAL_VX855_INIT_REG_TBL CMDISP_ARRAYSIZE(InitialRegTable_VX855)

#define PANEL_TD_TIMING_REG_AMOUNT        2
#define PANEL_TD_TIMING_AMOUNT            4 

/*Power sequence relations*/
typedef struct _TdTimerInfo
{
    CARD32 tdTimer0;
    CARD32 tdTimer1;
    CARD32 tdTimer2;
    CARD32 tdTimer3;
}TdTimerInfo, *TdTimerInfoPtr;

static TdTimerInfo PanelTdTimer = {500, 50, 0, 510};

typedef struct _TdTimer
{
    ViaIoBit tdRegs[PANEL_TD_TIMING_REG_AMOUNT];
}TdTimer, *TdTimerPtr;

static TdTimer TdTimerRegs[] = 
{
    {{ {REG_CR8B,0,7}, {REG_CR8F,0,3} }},    /* TDTimer0 */
    {{ {REG_CR8C,0,7}, {REG_CR8F,4,7} }},    /* TDTimer1 */
    {{ {REG_CR8D,0,7}, {REG_CR90,0,3} }},    /* TDTimer2 */
    {{ {REG_CR8E,0,7}, {REG_CR90,4,7} }}     /* TDTimer3 */
};

/*for detect EDID*/
#define MON_NAME_MAX_LEN    32      /*EDID1: the max monitor name length is 13 bytes
                                      				EDID2: the max monitor name length is 32 bytes*/
/* MISC */
#define CMDISP_ARRAYSIZE(x)   (sizeof(x) / sizeof(*(x)))
#define HIGH_BYTE_OF_WORD(x)    (CARD8)((x) >> 8)
#define LOW_BYTE_OF_WORD(x)     (CARD8)((x) & 0x00FF)
#define CMDISP_ALIGN_TO(val,al) (((val) + ((al) - 1)) & ~((al) - 1))

/*temply use globle variable MMIOMapBase, we should refine it laterly*/
#define MMIO_WR8(address,data)              *((volatile CARD8*)((address))) = (data)
#define MMIO_WR16(address,data)             *((volatile CARD16*)((address))) = (data)
#define MMIO_WR32(address,data)             *((volatile CARD32*)( (address))) = (data)
#define MMIO_WRBits8(address,data,mask)     *((volatile CARD8*)( (address))) = ((data) & (mask))
#define MMIO_WRBits16(address,data,mask)    *((volatile CARD16*)((address))) = ((data) & (mask))
#define MMIO_WRBits32(address,data,mask)    *((volatile CARD32*)( (address))) = ((data) & (mask))
#define MMIO_RD8(address)                   *((volatile CARD8*)( (address)))
#define MMIO_RD16(address)                  *((volatile CARD16*)((address)))
#define MMIO_RD32(address)                  *((volatile CARD32*)((address)))
#define STANDVGA_R8(address)                MMIO_RD8(MMIOMapBase + address)
#define STANDVGA_W8(address,data)           MMIO_WR8(MMIOMapBase + address,data)
#define REG_R32(address)                    MMIO_RD32(pVia->MapBase + address)
#define REG_W32(address,data)               MMIO_WR32(pVia->MapBase + address,data)


CARD8   viaReadVgaIo(CARD16 ioName);
__inline__ CARD8   viaReadMiscIo(void);
__inline__ CARD32 	viaWriteMiscIo(CARD8 data);
CARD32 	viaWriteVgaIo(CARD16 ioName, CARD8 data);
CARD32 	viaWriteVgaIoBits(CARD16 ioName, CARD8 data, CARD8 bitsMask);
CARD32 	viaWriteVgaIoMultiBits(ViaIoReg regTable[], CARD32 itemNum);

void	viaLoadRegs(CARD32 regValue, CARD32 regAmount, ViaIoBitPtr pRegBit);
__inline__ void viaUnlockCrtc(void);
__inline__ void viaLockCrtc(void);
void viaMemSet(void* pStart, CARD32 lengthInBytes);

#endif

