/*
 * Copyright 1998-2009 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2009 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __VIA_DISPLCD_H__
#define __VIA_DISPLCD_H__

#include "xf86Crtc.h"

/**********************************************/
/*LCD set SW  powersequence needed structure*/
/**********************************************/

#define LCD_POWER_SEQUENCE_TD0  200
#define LCD_POWER_SEQUENCE_TD1  25
#define LCD_POWER_SEQUENCE_TD2  0
#define LCD_POWER_SEQUENCE_TD3  250

/**********************************************/
/*VT1636 initial table*/
/**********************************************/
static ViaIoData INIT_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x10, 0xC0, 0x00},     /* Set panel power sequence timing */
    {0x0B, 0xFF, 0x40},     /* T1: VDD on - Data on. Each increment is 1 ms. 
                                                    (50ms = 031h)*/
    {0x0C, 0xFF, 0x31},     /* T2: Data on - Backlight on. Each increment is 2 ms.
                                                    (210ms = 068h) */
    {0x0D, 0xFF, 0x31},     /* T3: Backlight off - Data off. Each increment is 2 ms.
                                                    (210ms = 068h) */
    {0x0E, 0xFF, 0x68},     /* T4: Data off - VDD off. Each increment is 1 ms.
                                                    (50ms = 031h) */
    {0x0F, 0xFF, 0x68},     /* T5: VDD off - VDD on. Each increment is 100 ms.
                                                    (500ms = 04h) */
    {0x09, 0xA0, 0xA0},     /* LVDS output power up */
    {0x10, 0x33, 0x13}      /* turn on back light */
};


/**********************************************/
/*VIA support LCD panel*/
/**********************************************/
typedef struct _PanelMatrix {
	CARD32 PanelSizeIndex;
	CARD32 Width;
	CARD32 Height;
}PanelMatrix,*PanelMatrixPtr;

static PanelMatrix ViaSupportLCDPanel[] = {
	/*PanelSizeIndex, 			Width, 		Height*/
    {VIA_480X640,      	    480,    	640},
    {VIA_640X480,          	640,    	480},
	{VIA_800X480,			800,		480},
    {VIA_800X600,          	800,    	600},
	{VIA_1024X600, 			1024,		600},
    {VIA_1024X768,         	1024,    	768},
    {VIA_1280X768,         	1280,    	768},
	{VIA_1280X800, 			1280,		800},
    {VIA_1280X1024,        	1280,    	1024},
	{VIA_1360X768,			1360,		768},
	{VIA_1366X768,			1366,		768},
    {VIA_1400X1050,        	1400,    	1050},
    {VIA_1440X900,         	1440,    	900},
	{VIA_1600X1200,			1600,		1200},
};
#define NUM_VIA_SUPPORT_PANEL CMDISP_ARRAYSIZE(ViaSupportLCDPanel)

/* LCD Center/Expand Properties */
static Atom lcd_centering_atom;
static Atom lcd_centering_name_atoms[2];
static char *lcd_centering_names[] = {
    "Expand",
	"Center",
};
#define LCD_CENTERING_NUM   2
#define LCD_CENTERING_NAME  "Feature"


/**********************************************/
/*Lcd scaling factor register*/
/**********************************************/
#define LCD_HOR_SCALING_REG_NUM  3   /* location: {CR9F,0,1},{CR77,0,7},{CR79,4,5}  */
#define LCD_VER_SCALING_REG_NUM  3   /* location: {CR79,3,3},{CR78,0,7},{CR79,6,7}  */

typedef struct _HorScalingRegs {
    CARD8 RegNum;
    ViaIoBit Reg[LCD_HOR_SCALING_REG_NUM];
}HorScalingRegs, *HorScalingRegsPtr;

typedef struct _VerScalingRegs {
    CARD8 RegNum;
    ViaIoBit Reg[LCD_VER_SCALING_REG_NUM];
}VerScalingRegs, *VerScalingRegsPtr;

typedef struct _LcdScalingRegs {
    HorScalingRegs HorRegs;
    VerScalingRegs VerRegs;
}LcdScalingRegs, *LcdScalingRegsPtr;

static LcdScalingRegs VIALcdScalingRegs = {
    /* Hor Scaling Register */
    {LCD_HOR_SCALING_REG_NUM, {{REG_CR9F,0,1},{REG_CR77,0,7},{REG_CR79,4,5}}},
    {LCD_VER_SCALING_REG_NUM, {{REG_CR79,3,3},{REG_CR78,0,7},{REG_CR79,6,7}}}
};


/*******************************************************************/
/*Function declaration*/
/*******************************************************************/
void viaDelayIn_usec(VIAPtr pVia, int usec);
Bool viaDelay_Nmsec(VIAPtr pVia, CARD32 dwCounter);
void viaSWPowerSequenceOFF(VIAPtr pVia, unsigned long diPort, unsigned long panelSizeId);
void viaSWPowerSequenceON(VIAPtr pVia, unsigned long diPort, unsigned long panelSizeId);
void disableInternalLvds(VIAPtr pVia, unsigned long diPort, unsigned long panelSizeId, BOOL dualChannel);
void enableInternalLvds(VIAPtr pVia, unsigned long diPort, unsigned long panelSizeId, BOOL dualChannel);
void enableLcdViaVt1636(unsigned long serialPort);
void disableLcdViaVt1636(unsigned long serialPort);
void ttlLcdPowerSequenceOn(VIAPtr pVia);
void ttlLCDPowerSequenceOff(VIAPtr pVia);
DisplayModePtr viaGetPanelModeRecord(ScrnInfoPtr pScrn, CARD32 panelID);
void initVt1636(ViaLcdPrivateInfoPtr lcdPriv);
void initLVDS(ViaLcdPrivateInfoPtr lcdPriv);
ViaTimingTablePtr getDriverTiming(CARD32 devModeTableIndex, unsigned long modeIndex);
Bool fillModeByDriverTiming(ViaTimingTablePtr pTimingTable, DisplayModePtr mode);
void centeringTiming(DisplayModePtr mode, DisplayModePtr adjusted_mode);
void loadScaleFactorRegs(CARD32 mode, CARD32 panel, Bool isHorizontal);
Bool isPanelSizeValid(CARD32 width, CARD32 height);
Bool viaGetPanelModeLine(xf86OutputPtr output);

#endif

