/*
 * Copyright (C) Thomas Hellstrom (2005) 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef VIA_DMABUFFER_H
#define VIA_DMABUFFER_H
#include "xf86str.h"
#include "via_3d_reg.h"

 /*For High performace run XaaPci+3DAGP path,not using AGP way even Drm module running*/
#define XAAChosePciPath 1

/* A Flag of enable the AGP Banch buffer path for (EXA) Command Manager */
#define VIA_APPLY_AGP_BRANCH  1

typedef struct _ViaCommandBuffer
{
    ScrnInfoPtr pScrn;
    CARD32 *buf;
    CARD32 waitFlags;
    unsigned pos;
    unsigned bufSize;
    int mode;
    int header_start;
    int rindex;
    Bool has3dState;
    Bool needFire;     /*for 2D blt*/
    void (*beginFunc)(struct _ViaCommandBuffer * cb, \
        unsigned headType, unsigned regIndex);
    void (*finishFunc)(struct _ViaCommandBuffer * cb);
    void (*flushFunc) (struct _ViaCommandBuffer * cb);
} ViaCommandBuffer;

#define VIA_DMASIZE    (128 * 1024)    /* size of each AGP cmd flush to kernel mode DRM */
#define VIA_CMDBUFSIZE (128 * 1024)    /* size of usermode normal AGP cmd buffer */
#define VIA_SAFESIZE   (1024)          /* size of free buffer in AGP cmd buffer for safe */

#define H1_ADDR(val) (((val) >> 2) | EXA_HC_ACMD_H1)
#define WAITFLAGS(flags)			\
    (cb)->waitFlags |= (flags)

 /*Detecting if buf is enough for the following cmd size*/
#define BEGIN_RING(size)					                        \
    do {								                            \
	if (cb->flushFunc && (cb->pos > (cb->bufSize -VIA_SAFESIZE -(size)))) {	\
	    cb->flushFunc(cb);					                        \
	}								                                \
    } while(0)
/**************Cmd load Begin*************************/
/*for H5/6 2D cmd load(Two value :cmd with address)***/
#define OUT_RING_QW(val1, val2)			    \
    do {						            \
	(cb)->buf[(cb)->pos++] = (val1);		\
	(cb)->buf[(cb)->pos++] = (val2);		\
    } while (0)

/*for normal cmd load*/
#define OUT_RING(val)               \
    do{	                            \
	(cb)->buf[(cb)->pos++] = (val);	\
    } while(0)
/*for 3D     cmd load*/
#define OUT_RING_SubA(val1, val2)   \
  OUT_RING(((val1) << EXA_HC_SubA_SHIFT) | ((val2) & EXA_HC_Para_MASK))

/***************H2 header Begin**************************/
/*1 H2 2D header (header with Two value : cmd & address)*/

#define BEGIN_HEAD1_2D(val1, val2) \
  OUT_RING_QW(H1_ADDR(val1), val2)
/*2 H2 Header2 3D header (every time with paraType setting)*/
/*
 a)h2size is cmd num,and buffer unit 32bit;
 b)following 3D cmd is 32bit size eachcmd;
 c)H2 Head take up 2x32,and need 2x32 algin. 
 So worst condtion need space  ((h2size)+3)
*/
#define BEGIN_HEAD2_3D(paraType, h2size)			\
  do{							                    \
    BEGIN_RING((h2size)+3);				            \
    if (cb->mode == 2 && (paraType) == cb->rindex)	\
      break;						                \
    if (cb->pos & 1)					            \
      OUT_RING(EXA_HC_DUMMY);				        \
    cb->header_start = cb->pos;				        \
    cb->rindex = paraType;				            \
    cb->mode = 2;					                \
    OUT_RING(EXA_HALCYON_HEADER2);				    \
    OUT_RING((paraType) << 16);						\
    if (!cb->has3dState && ((paraType) != EXA_HC_ParaType_CmdVdata)) {	\
      cb->has3dState = TRUE;						\
    }									            \
  } while(0);
/*3 H2 vieo header*/
/***********H5/6 AGP header Begin***********************/
/*4 H5/6 Header0 2D header */
/*
    a)h2size is cmd num,and buffer unit 32bit;
    b)following 2D cmd is 2x32bit size eachcmd;
    c)H5 Head take up 4x32,and need 4x32 algin. 
    So worst condtion need space  ((h2size*2)+7)
*/
#define BEGIN_HEADER0_2D_H5(h2size)			\
  do{							            \
    BEGIN_RING((h2size*2)+7);				\
    while(cb->pos & 0x3) 			        \
		OUT_RING(0xCC000000); 	            \
    cb->header_start = cb->pos;				\
    cb->rindex = 0xFFFFFFFF;				\
    cb->mode = 2;					        \
    OUT_RING(INV_AGPHeader0);				\
    OUT_RING(h2size);				        \
    OUT_RING(0);						    \
    OUT_RING(0xCC000000);					\
  } while(0);
/*5 H5/6 Header2 3D header (every time with paraType setting)*/
/*
    a)h2size is cmd num,and buffer unit 32bit;
    b)following 3D cmd is 32bit size eachcmd;
    c)H5 Head take up 4x32,and need 4x32 algin. 
    So worst condtion need space  ((h2size)+7)
*/
#define BEGIN_HEADER2_3D_H5(paraType, h2size)			\
  do{							                        \
    BEGIN_RING((h2size)+7);				                \
    if (cb->mode == 2 && (paraType) == cb->rindex)	    \
      break;						                    \
    while(cb->pos & 0x3) 			                    \
		OUT_RING(0xCC000000);                           \
    cb->header_start = cb->pos;				            \
    cb->rindex = paraType;				                \
    cb->mode = 2;					                    \
    OUT_RING(INV_AGPHeader2 | EXA_HC_REG_BASE | EXA_HC_REG_TRANS_SPACE);	\
    OUT_RING(EXA_HC_REG_BASE | EXA_HC_REG_TRANS_SET);				        \
    OUT_RING(paraType);						                                \
    OUT_RING(0xCC000000);						                            \
    if (!cb->has3dState && ((paraType) != EXA_HC_ParaType_CmdVdata)) {	    \
      cb->has3dState = TRUE;						                        \
    }									                                    \
  } while(0);
/*6 H5/6 vieo header*/
/*7 H2/H5/H6 blt writeBase*/
/*H2 2D Header1 blt writeBase*/
#define BEGIN_HEADER4_2D_BLT( h2size, dwAddr);          \
do{				                                    	\
    while(cb->pos & 0x3) 			                    \
		OUT_RING(0xCC000000); 	                        \
        cb->header_start = cb->pos;				        \
        cb->rindex = 0xFFFFFFFF;				        \
        cb->mode = 2;					                \
    OUT_RING((EXA_HC_ACMD_H4)|(((h2size)<< 9) & 0x1FFFE00)|((dwAddr) & 0x1FF));\
}while(0);
/*H5/6 2D Header1 blt writeBase*/
#define BEGIN_HEADER1_2D_BLT_H5( h2size, dwAddr);       \
do{				                                    	\
    while(cb->pos & 0x3) 			                    \
		OUT_RING(0xCC000000); 	                        \
        cb->header_start = cb->pos;				        \
        cb->rindex = 0xFFFFFFFF;				        \
        cb->mode = 2;					                \
    OUT_RING(INV_AGPHeader1 | (dwAddr));				\
    OUT_RING(h2size);				                    \
    OUT_RING(0);						                \
    OUT_RING(0xCC000000);						        \
}while(0);
/*Align buf H2*/
#define ALIGN_H2_DATAOF2(_null)                           \
do {                                                      \
    if (cb->pos & 1)					                  \
      OUT_RING(EXA_HC_DUMMY);				              \
      cb->header_start = cb->pos;				          \
      cb->rindex = 0xFFFFFFFF;				              \
      cb->mode = 2;					                      \
}while(0)
/*Align buf H5/6*/
#define ALIGN_H5_DATAOF4(_null)                         \
do {                                                    \
    while(cb->pos & 0x3) 			                    \
	OUT_RING(0xCC000000); 	                            \
    cb->header_start = cb->pos;				            \
    cb->rindex = 0xFFFFFFFF;				            \
    cb->mode = 2;					                    \
}while(0)
#define BEGIN_HEADER_2D_BLT_H2(size, DestBase)                                   \
do{                                                                              \
            BEGIN_HEADER4_2D_BLT(size, 0);                                       \
            ALIGN_H2_DATAOF2(0);                                                 \
            DestBase =(unsigned char *)&((cb)->buf[(cb)->pos]); 		         \
	        (cb)->pos=(cb)->pos+size;					                         \
}while(0)                                                                        
#define BEGIN_HEADER_2D_BLT_H5(size, DestBase)                                   \
do{                                                                              \
            BEGIN_HEADER1_2D_BLT_H5(size, 0);                                    \
            ALIGN_H5_DATAOF4(0);                                                 \
            DestBase = (unsigned char *)&((cb)->buf[(cb)->pos]);                 \
	        (cb)->pos= (cb)->pos+size;						                     \
}while(0)

/* Note:   H2 video AGP is almost the same as H5/H6 video AGP  
           H2 agp header 5 <=> H5/H6 agp header 4
           H2 agp header 6 <=> H5/H6 agp header 5
    Here we named it uniformly according to the new chips H5/H6.
*/
/*
    a)size is cmd num,and buffer unit 32bit;
    b)following DVD cmd is 2x32bit size eachcmd;
    c)H5 Head take up 4x32,and need 4x32 algin. 
    So worst condtion need space  ((sizex2)+7)
*/
#define BEGIN_HEADER5_VIDEOAGP(size)         \
    do{							             \
        BEGIN_RING((size*2)+7);			     \
        if(cb->mode == 4)                    \
            cb->finishFunc(cb);              \
        if (cb->mode == 5)	                 \
            break;                           \
        cb->beginFunc(cb, 5, 0);             \
    } while(0)
#define BEGIN_HEADER4_VIDEOAGP(size, reg)    \
    do{							             \
        BEGIN_RING((size)+7);			     \
        if(cb->mode == 5)                    \
            cb->finishFunc(cb);              \
        if (cb->mode == 4)	                 \
            break;                           \
        cb->beginFunc(cb, 4, reg);           \
    } while(0)

#define IN_VIDEO_HEADER4   (cb->mode == 4)
#define IN_VIDEO_HEADER5   (cb->mode == 5)

#define END_HEADER5_VIDEOAGP			     \
    do{							             \
        if (cb->mode != 5)	                 \
            break;						     \
        cb->finishFunc(cb);                  \
    } while(0)
#define END_HEADER4_VIDEOAGP			     \
    do{							             \
        if (cb->mode != 4)	                 \
            break;						     \
        cb->finishFunc(cb);                  \
    } while(0)
    
#define BEGIN_HEADER2_INVI(dwAddr, dwType)   \
{                                            \
	while (cb->pos & 0xF) {                  \
		OUT_RING(0xCC000000);                \
	}                                        \
	OUT_RING(INV_AGPHeader2 | ((dwAddr)+4)); \
	OUT_RING(dwAddr);                        \
    OUT_RING(dwType);                        \
    OUT_RING(0xCC000000);                    \
}

#define RING_VARS \
  ViaCommandBuffer *cb = &pVia->cb
#define ADVANCE_RING \
  cb->flushFunc(cb)
  
int viaSetupCBuffer(ScrnInfoPtr pScrn, ViaCommandBuffer * buf, unsigned size);
void viaTearDownCBuffer(ViaCommandBuffer * buf);
extern void viaAccelSync(ScrnInfoPtr pScrn);
void viaFlushPCI(ViaCommandBuffer * buf);
void viaFlushPCI_H5(ViaCommandBuffer * buf);
#ifdef XF86DRI
void viaFlushDRIEnabled(ViaCommandBuffer * cb);
void viaFlushDRIEnabled_H5(ViaCommandBuffer * cb);
#endif 
#endif
