 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
#ifndef _VIA_DRI_H_
#define _VIA_DRI_H_ 1

#include "xf86drm.h"
#include "drm.h"

#define  drmHandle     drm_handle_t
#define  drmContext    drm_context_t

#define VIA_MAX_DRAWABLES 256

#define VIA_VERSION_MAJOR		5
#define VIA_VERSION_MINOR		0

/*add for support H5s1(vt3336/vt3364)*/
typedef enum
{
    CHIPID_INV = 4,      
    CHIPID_H5,        
    CHIPID_H5S1,      
    CHIPID_H6S2,     
    CHIPID_LAST,  
} CHIPID_HW;

typedef enum
{
    FAMILYID_INV = 4,
    FAMILYID_LAST,
} FAMILYID_HW;

#define S3G_NR_TEX_HEAPS		2
#define S3G_NR_TEX_REGIONS		64

#define DRM_S3G_INIT                    0x0D
#define DRM_S3G_FLUSH                   0x0E
#define DRM_S3G_QUERY_BRANCH     	    0x18
#define DRM_S3G_BRANCH_BUF_REQUEST	    0x19
#define DRM_S3G_BRANCH_BUF_FLUSH	    0x1A
#define DRM_S3G_FLUSH_PCIE_CACHE        0x0C
#define VIA_NR_SAREA_CLIPRECTS		    8

typedef  enum
{
       flush_bci = 0,
       flush_bci_and_wait,
       dma_kickoff,
       flush_dma_buffer,
       flush_dma_and_wait
} dma_cmd_type_t; 


typedef struct {
    dma_cmd_type_t    dma_cmd_type;            
    int    cmd_idx;                   /* command buffer index */
    int    cmd_offset;               /* command buffer offset */
    int    cmd_size;                 /* command dword size,command always from beginning */
    unsigned long  dma_kickoff[2];   /* if use dma kick off,it is dma kick off command */
    unsigned int * usermode_dma_buf; /* user mode DMA buffer pointer */
} drm_s3g_flush_t;

/*from s3g_common.h, must be syned*/
enum S3GCHIPTAGS {
    S3G_INV = 4,
    S3G_LAST
};

enum S3GCHIPBUS {
    CHIP_PCI,
    CHIP_AGP,
    CHIP_PCIE,
};

enum S3GCHIPIDS {
    CHIP_INV = 4,       /*Innovation (H3) */
    CHIP_H5,        /*Innovation (H5) */
    CHIP_H5S1,      /*Innovation (H5S1) */
    CHIP_H6S2,      /*Innovation (H6S2) */
    CHIP_LAST       /*Maximum number of chips supported. */
};

typedef struct _PciConf {
    unsigned short      VendorID;
    unsigned short      DeviceID;
    unsigned short      Command;
    unsigned short      Status;
    unsigned int        RevisionID;
    unsigned int        ProgIf;
    unsigned int        SubClass;
    unsigned int        BaseClass;
    unsigned int        CacheLineSize;
    unsigned int        LatencyTimer;
    unsigned int        HeaderType;
    unsigned int        BIST;
    unsigned long       ulBaseAddresses[6];
    unsigned long       CardBus;
    unsigned short      SubsystemVendorID;
    unsigned short      SubSystemID;
    unsigned long       PCIConfig_Unused[4];
    unsigned long       AGPCapability;
    unsigned long       AGPStatus;
    unsigned long       AGPCommand;
    unsigned long       BusNum;
    unsigned long       SlotNum;

    unsigned long       LinkCaps;
    unsigned short      LinkStatus;

    unsigned int        bSwizzled;
    unsigned long       memoryType;
    unsigned int        pageSelect;
    unsigned int        bankSelect;
    unsigned int        bankSelectShift;
    unsigned int        bankSelectMask;
} PciConfRec, *PciConfPtr;

typedef struct _ChipConf {
    char                chipName[64];
    
    unsigned long       pciTag; /* pci bus,dev,func */
    unsigned long       pciID;
    unsigned int        chipType; /* adapter and host are all agp enabled? */
    
    unsigned int        primary; /* for Multi-Adapter and Multi-Monitor */
    unsigned int        samm;
    unsigned int        mergefb;
    
    unsigned int        bcipm; /* does enable bci power management */
    
    unsigned int        docking;
    
    int                 biosVersion;
    char                biosVerStr[16];
    unsigned int        mobilebios;

    unsigned int        noBios;

    unsigned int        swizzleOff;
    int                 pageSelect;
    int                 bankSelect;
    int                 memType;
    
    int                 oem;
    
    int                 maxIgas;
    int                 maxApts;

    PciConfRec          pciCfg;

} ChipConfRec,*ChipConfPtr;


typedef struct _AddrConf {
    /* MMIO space */
    unsigned long       mmioVirtAddr;
    unsigned long       mmioPhyAddr;
    unsigned long       mmioSize;
    
    unsigned long       bciVirtAddr;
    unsigned long       bciPhyAddr;
    unsigned long       bciSize;

    /* FB space */
    unsigned long       fbVirtAddr;
    unsigned long       fbPhyAddr;
    unsigned long       fbSize;
    int                 fbType;
    unsigned long       fbFree; /* FB subtracts those COB/HW/TV etc. */
    
    /* MISC FB usage */
    unsigned long       GARTableSize;
    unsigned long       GARTOffset;
    
    unsigned long       cobOffset;
    unsigned long       cobSize;
    unsigned long       cobEntries; /* how many entries of fifo(include on chip) */
    unsigned long       cobEntReg; /* just for set cob register */
    
    unsigned long       hwIconOffset;
    unsigned long       hwIconSize;
    
    unsigned long       cursorOffset;
    
    /* Aperture usage */
    unsigned long       aptPhyAddr[6];    
    unsigned long       aptVirtAddr[6];
    unsigned long       aptPitch[6];
    unsigned long       aptUsing[16]; /* for columbia */
} AddrConfRec,*AddrConfPtr;


typedef struct _DriConf {
    int                 drmFd;

    unsigned int        allowPageFlip;    
    unsigned int        z24;
    
    int                 agpMode;
    int                 agpVendor;
    int                 agpDevice;
    unsigned long       agpBase;
    unsigned long       agpSize;
    unsigned long       agpHandle;
    
    unsigned long       frontOffset;
    unsigned long       backOffset;
    unsigned long       depthOffset;
    
    unsigned long       backY;
    unsigned long       depthY;
    unsigned long       fbTexY;

    unsigned long       frontPhyAddr;
    unsigned long       backPhyAddr;
    unsigned long       depthPhyAddr;
    
    unsigned long       mmioHandle;
    drm_handle_t        dmaHandle;
    
    drm_handle_t        fbHandle;
    unsigned long       frontHandle;
    unsigned long       backHandle;
    unsigned long       depthHandle;

    unsigned long       fbTexOffset;
    unsigned long       fbTexSize;

    unsigned long       vmBufOffset;
    unsigned long       vmBufSize;
    
    unsigned long       dmaBufNum;
    unsigned long       dmaBufSize;
    unsigned long       dmaBufOffs; /* FB:offset,AGP:phyaddr */
    unsigned long       dmaBufAGP; /* AGP or FB */
    
    unsigned long       shadowOffset;
    unsigned long       shadowSize;
    drm_handle_t        shadowHandle;
    
    unsigned long       agpTexOffset;
    unsigned long       agpTexSize;
    drm_handle_t        agpTexHandle;

    void                *pVisualConfigs;
    void                *pDRIInfo;
} DriConfRec,*DriConfPtr;

typedef struct _ScrnConf {
    unsigned int        samm;
    unsigned int        master; /* for Single-Adapter and Multi-Screen */

    unsigned int        shadowfb;
    unsigned int        accel;
    unsigned int        video;
    unsigned int        hwcursor;
    int                 rotate;
    
    unsigned int        tiled;
    unsigned int        driEnabled;

    unsigned int        DGAActive;
    int                 DGAViewportStatus;

    int                 bpp; /* bits per pixel */
    int                 Bpp; /* bytes per pixel */

    unsigned long       virtualX; /* desktop resolution of screen */
    unsigned long       virtualY;
    
    unsigned long       scrnDelta; /* align to one tile width */
    unsigned long       scrnWit; /* screen width in tile */
    unsigned long       scrnWip; /* screen width in pixel */
    unsigned long       scrnScanline;

    unsigned long       xaaBufs; /* buffers reserved for XAA offscreen */
    unsigned long       XScanline; /* scanlines reserved for XServer */
    
    unsigned long       memDelta;
    unsigned long       memScanline;
    
    unsigned long       fbOffset; /* the starting offset of fb */
    unsigned long       fbPhyAddr; /* frame buffer physical address */    
    unsigned long       fbSize; /* fb size of this screen */

    unsigned long       linearVideoOffset[2];
    unsigned long       areaIndex;
    
    unsigned long       scrnPhyAddr; /* when linear,it is fbPhyAddr,when tiled,it is aperture[0/1] */
    unsigned long       scrnLinear; /* frame buffer virtual address */
    unsigned long       scrnTile; /* aperture mapped address */
    unsigned long       scrnStart; /* address for render */
    unsigned long       scrnPitch; /* pitch for render */
    
    unsigned long       shadowStart; /* shadow fb(sysmem) address */
    unsigned long       shadowPitch; /* shadow fb pitch */

    unsigned long       macroVision; /* macro vision trigger bit (0~3) */
    
    unsigned long       gbd;
} ScrnConfRec,*ScrnConfPtr;

typedef struct  {
    int                 isAGP;
    
    int                 chipType;
    int                 chipIndex;
    int                 chipSubIndex;
    
    int                 sareaPrivOffset;

    int                 dmaBufNum;
    int                 dmaBufSize;
    int                 dmaBufOffs;

    int                 bufGBD;
    
    int                 bufBpp;    
    int                 bufSize;
    int                 bufPitch;
    int                 bufWit;

    int                 zbufGBD;
    
    int                 zbufBpp;    
    int                 zbufSize;
    int                 zbufPitch;
    int                 zbufWit;
    
    unsigned long       frontOffset;
    unsigned long       backOffset;
    unsigned long       depthOffset;

    unsigned long       backY;
    unsigned long       depthY;

    unsigned long       mmioHandle;
    
    unsigned long       dmaHandle;    

    unsigned long       frontHandle;
    unsigned long       backHandle;
    unsigned long       depthHandle;

    unsigned long       fbTexOffset;
    unsigned long       fbTexSize;
    
    unsigned long       agpTexOffset;
    unsigned long       agpTexSize;
    unsigned long       agpTexHandle;

    unsigned long       shadowSize;
    unsigned long       shadowHandle;
    
    int                 logFbTexGran;
    int                 logAgpTexGran;

    AddrConfRec         AddrConf;
    ChipConfRec         ChipConf;
    ScrnConfRec         ScrnConf;
    DriConfRec          DriConf;
    PciConfRec          PciConf;    
    unsigned long       hostBltHandle; /*handle of host blt map*/
    unsigned long	RotateDegree;
    int			width;
    int			height;
} ServerInfoRec,*ServerInfoPtr;

typedef struct  {
	int page_flip;
	int current_page;
	unsigned int req_drawable;/* the X drawable id */
	unsigned int req_draw_buffer;/* VIA_CHROME9_FRONT or VIA_CHROME9_BACK */
	/* Last context that uploaded state */
	int ctx_owner;
} VIA_CHROME9SAREAPriv;

typedef struct {
	unsigned int dirty;
	unsigned int nbox;
	struct drm_clip_rect boxes[VIA_NR_SAREA_CLIPRECTS];
	drm_via_tex_region_t texList[VIA_NR_TEX_REGIONS + 1];
	int texAge;		/* last time texture was uploaded */
	int ctx_owner;		/* last context to upload state */
	int vertexPrim;

	/* Used by the 3d driver only at this point, for pageflipping:
	 */
	unsigned int pfCurrentOffset;
} VIASAREAPriv;

typedef struct {
    drmHandle handle;
    drmSize size;
    drmAddress map;
} viaRegion, *viaRegionPtr;

typedef struct {
    viaRegion regs, agp;
    int deviceID;
    int width;
    int height;
    int mem;
    int bytesPerPixel;
    int priv1;
    int priv2;
    int fbOffset;
    int fbSize;
    Bool drixinerama;

    int backOffset;
    int depthOffset;
    int textureOffset;
    int textureSize;
    int irqEnabled;
    unsigned int scrnX, scrnY;
    int sarea_priv_offset;
    Bool VQEnable;
    ServerInfoPtr pServerInfo;
    unsigned long RotateDegree;
    unsigned long pitch;    
} VIADRIRec, *VIADRIPtr;

typedef struct {
    int dummy;
} VIAConfigPrivRec, *VIAConfigPrivPtr;

typedef struct {
    int dummy;
} VIADRIContextRec, *VIADRIContextPtr;

typedef struct {
     int depth;
  	int class;
} VIAConfigVisualPrivRec, *VIAConfigVisualPrivPtr;

Bool VIADRIScreenInit(ScreenPtr pScreen);
void VIADRICloseScreen(ScreenPtr pScreen);
Bool VIADRIFinishScreenInit(ScreenPtr pScreen);

#endif  /* _VIA_DRI_H_ */

