/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*************************************************************************
 *
 *  File:       via_driver.c
 *  Content:    XFree86 4.0 for VIA/S3G UniChrome
 *
 ************************************************************************/
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include <linux/version.h>

#include "via_driver.h"
#include "xf86RAC.h"
#include "xf86Priv.h"
#include "shadowfb.h"
#include "mipointer.h"
#include "mipointrst.h"
#include "inputstr.h"

#include "globals.h"
#define DPMS_SERVER
#include "extensions/dpms.h"


#include "via_video.h"
#include "hw.h"
#include "via_vt1636.h"
#include "via_serial.h"
#include "debug.h"      /* for DBG_DD */
#include "via_eng_regs.h"
#include "via_Hw3DScaling.h"

#ifdef XF86DRI
#include "dri.h"
#endif
#include "via_mergedfb.h" /*for mergedfb*/

#include "via_rotate.h" /* for rotate feature.*/
#include "via_dmabuffer.h"

#include "via_exa.h"

#include "via_dvi.h"
#include "via_lcd.h"


#ifdef VIA_RANDR12_SUPPORT
#include "xf86Crtc.h"
#include "xf86RandR12.h"
#include "via_common.h"
#include "via_modedata.h"
#include "via_display.h"
#include "via_output.h"
#include "via_displcd.h"
#endif

/*
  *    fix the "Undefined Symbol:vgaHWddc1SetSpeed" problem on FC5(32/64) when starting X,
  *    replace the function vgaHWddc1SetSpeed as VIAvgaHWddc1SetSpeed.
 */
#ifdef XORG_VERSION_CURRENT
 /*
  *    fix the "Undefined Symbol:vgaHWddc1SetSpeed" problem on FC7(32/64) when starting X,
  *    assign the function Xorg 1.3.0 to Xorg 7.2.0.
  */

extern Bool    VIAnoPanoramiXExtension;

extern void VIALoadUserSetting(VIABIOSInfoPtr pBIOSInfo);
extern Bool VIALoadGammaSetting(VIABIOSInfoPtr pBIOSInfo);
extern void VIALoadUserDuoViewVideoOutputDeviceSetting(ScrnInfoPtr pScrn);
extern void UTRemoveRestartFlag(VIABIOSInfoPtr pBIOSInfo);
extern Bool VIASet3DSyncInfoParas(ScreenPtr pScreen);
extern void VIADisplayExtUnregister(ScrnInfoPtr pScrn);

extern void write_reg_mask(CARD8 index, int io_port, CARD8 data, CARD8 mask);
extern __inline__ CARD8 read_reg(int io_port, CARD8 index);

static Bool IsVidDataAllocated = FALSE; /* To prevent VidData allocated twice. */

/* for Update Cursor/Icon scaling image during switch mode */
extern void VIAHideCursor(ScrnInfoPtr pScrn);
extern void VIAShowCursor(ScrnInfoPtr pScrn);
extern void VIALoadIconImage(ScrnInfoPtr pScrn, CARD32 * src);

extern void VIAGetPanelSizeByIndex(int PanelSizeIndex, int *pSizeX, int *pSizeY);

/*
 * prototypes
 */

static void VIAIdentify(int flags);
#if XSERVER_LIBPCIACCESS
static Bool VIAPciProbe(DriverPtr drv, int entity_num, struct pci_device *dev, intptr_t data);
#else
static Bool VIAProbe(DriverPtr drv, int flags);
#endif
static Bool VIAPreInit(ScrnInfoPtr pScrn, int flags);
static Bool VIAEnterVT(int scrnIndex, int flags);
static void VIALeaveVT(int scrnIndex, int flags);
static void VIASave(ScrnInfoPtr pScrn);
static void VIARestore(ScrnInfoPtr, vgaRegPtr, VIARegPtr, int flags);
static void VIAWriteMode(ScrnInfoPtr pScrn, vgaRegPtr);
static Bool VIAModeInit(ScrnInfoPtr pScrn, DisplayModePtr mode);
static Bool VIACloseScreen(int scrnIndex, ScreenPtr pScreen);
static Bool VIASaveScreen(ScreenPtr pScreen, int mode);
static Bool VIAPMEvent(int scrnIndex, pmEvent event, Bool undo);
static void VIALoadPalette(ScrnInfoPtr pScrn, int numColors, int *indicies,
                           LOCO *colors, VisualPtr pVisual);
static Bool VIAScreenInit(int scrnIndex, ScreenPtr pScreen, int argc,
                          char **argv);
static int VIAInternalScreenInit(int scrnIndex, ScreenPtr pScreen);
static void VIAFreeScreen(int scrnIndex, int flags);
static ModeStatus VIAValidMode(int index, DisplayModePtr mode,
                               Bool verbose, int flags);
static void VIADPMS(ScrnInfoPtr pScrn, int mode, int flags);
static const OptionInfoRec * VIAAvailableOptions(int chipid, int busid);
static void VIAProbeChipset(ScrnInfoPtr pScrn, EntityInfoPtr pEnt);
static Bool VIAFilterMode(ScrnInfoPtr pScrn);
static Bool VIAProbeMonitorLimitation(ScrnInfoPtr pScrn);
static Bool VIACollectBIOSInfo(ScrnInfoPtr pScrn);

static void VIAEnableMMIO(ScrnInfoPtr pScrn);
static Bool VIAMapMMIO(ScrnInfoPtr pScrn);
static Bool VIAMapFB(ScrnInfoPtr pScrn);
static void VIAUnmapMem(ScrnInfoPtr pScrn);
Bool VIADeviceSelection(ScrnInfoPtr pScrn);
Bool VIASetDisplayPath_SAMM(ScrnInfoPtr pScrn);
void VIASetDisplayPath(ScrnInfoPtr pScrn);
void VIAFindMaxResFromEstablishedTiming(xf86MonPtr MonitorConf, int* MaxH, int* MaxV);

void VIASetStartingAddress(ScrnInfoPtr pScrn, int x, int y);

#ifdef VIA_RANDR12_SUPPORT
void viaInitDispEngine(VIAPtr pVia);
void viaInitOutputRegSet(ScrnInfoPtr pScrn);
Bool viaInitHwInfo(VIAPtr pVia);
#endif

void VIAInitialize3DEngine(ScrnInfoPtr pScrn);
Bool volatile b3DRegsInitialized = 0;

/* E X T E R N   F U N C T I O N S ------------------------------------------*/
/*fix video can't get enough space from Xserver fb manager*/
extern Bool VIADRIFBInit(ScreenPtr pScreen, VIAPtr pVia);
extern Bool VIADRIRingBufferInit(ScrnInfoPtr pScrn);
extern void VIADRIRingBufferCleanup(ScrnInfoPtr pScrn);
extern Bool VIACheckDrmAlreadyInit(ScrnInfoPtr pScrn);
extern void VIAARGBCursorInit(ScrnInfoPtr pScrn);
extern void VIAEnableVQ(ScrnInfoPtr pScrn);
extern void VIADisableVQ(ScrnInfoPtr pScrn);
extern void viaFinishInitAccel(ScreenPtr pScreen);

/* Define one global NEWVIAGRAPHICINFO structure for ddmpeg*/
/* Only used in three files:via_driver.c,via_display.c,via_utility.c*/
NEWVIAGRAPHICINFO NEWVIAGraphicInfo;

/* Only for noRandR rotate for CW and CCW, neet to swap "pScrn->virtualX/virtualY"
 * And "currentMode->HDisplay/VDisplay" for XServer to set correct XV Rotate+panning 
 *   clipping windows
 * */
static inline int swap_height_width_for_CWorCCW (ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    CARD32  tmp = 0;

    if ((pVia->RotateDegree == VIA_ROTATE_DEGREE_90) ||
        (pVia->RotateDegree == VIA_ROTATE_DEGREE_270)) {      
        tmp = pScrn->currentMode->HDisplay;
        pScrn->currentMode->HDisplay = pScrn->currentMode->VDisplay;
        pScrn->currentMode->VDisplay = tmp;          
        
        tmp = pScrn->virtualX;
        pScrn->virtualX = pScrn->virtualY;
        pScrn->virtualY = tmp;                       
    }

	return 0;
}


/*---------------------------------------------------------------------------*/

#if XSERVER_LIBPCIACCESS
static const struct pci_id_match VIAPciIdMatch[] = {
    { 0x1106, PCI_CHIP_VT3314, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0x1106, PCI_CHIP_VT3324, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0x1106, PCI_CHIP_VT3336, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0x1106, PCI_CHIP_VT3327, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0x1106, PCI_CHIP_VT3364, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0x1106, PCI_CHIP_VT3353, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0x1106, PCI_CHIP_VT3409, PCI_MATCH_ANY, PCI_MATCH_ANY, 0, 0, 0 },
    { 0, 0, 0 }
};
#endif


DriverRec VIA =
{
    VIA_VERSION,
    DRIVER_NAME,
    VIAIdentify,
#if XSERVER_LIBPCIACCESS
	NULL,
#else
	VIAProbe,
#endif
    VIAAvailableOptions,
    NULL,
    0,
    NULL,
#if XSERVER_LIBPCIACCESS
	VIAPciIdMatch,
	VIAPciProbe
#endif
};

/* Supported chipsets */

static SymTabRec VIAChipsets[] = {
    {VIA_P4M800PRO,    "P4M800PRO"},
    {VIA_CX700,    "CX700"},
    {VIA_K8M890,   "K8M890"},
    {VIA_P4M890,   "P4M890"},
    {VIA_P4M900,   "P4M900"}, 
    {VIA_VX800,    "VX800"}, 
    {VIA_VX855,    "VX855"}, 
    {-1,            NULL }
};


/* This table maps a PCI device ID to a chipset family identifier. */

static PciChipsets VIAPciChipsets[] = {
    {VIA_P4M800PRO, PCI_CHIP_VT3314,    RES_SHARED_VGA}, 
    {VIA_CX700,    PCI_CHIP_VT3324,    RES_SHARED_VGA},
    {VIA_K8M890,   PCI_CHIP_VT3336,    RES_SHARED_VGA},
    {VIA_P4M890,   PCI_CHIP_VT3327,    RES_SHARED_VGA},
    {VIA_P4M900,   PCI_CHIP_VT3364,    RES_SHARED_VGA},
    {VIA_VX800,    PCI_CHIP_VT3353,    RES_SHARED_VGA},
    {VIA_VX855,    PCI_CHIP_VT3409,    RES_SHARED_VGA },
    {-1,            -1,                RES_UNDEFINED}
};

int gVIAEntityIndex = -1;

typedef enum {
    OPTION_NOACCEL,
    
#ifdef VIA_HAVE_EXA
    OPTION_ACCELMETHOD,
    OPTION_EXA_NOCOMPOSITE,
    OPTION_EXA_SCRATCH_SIZE,
#endif    
    OPTION_DRI,
    OPTION_SWCURSOR,
    OPTION_SHADOW_FB,
    OPTION_ROTATE,
    OPTION_ROTATE_TYPE,
    OPTION_VIDEORAM,
    OPTION_VIDEORAM1,
    OPTION_TWO_LCD,
    OPTION_ACTIVEDEVICE,
    OPTION_DVI_PORT,
    OPTION_LCD_PORT,
    OPTION_LCD_BUS_WIDTH,
    OPTION_CENTER,
    OPTION_REFRESH,
    OPTION_DISABLEVQ,
    OPTION_NODDCVALUE,
    OPTION_DRIXINERAMA,
    OPTION_MERGEDFB, /*to enable mergedfb,switch to virtualscreen*/
    OPTION_NOVIAXINERAMA,/*and set screen layout*/
    OPTION_SCRN2POS,
    OPTION_EPIA_DVI,/*  for TMDS on EPIA*/
    OPTION_VideoOnDevice, /*set video to work on which device for 3314,3204 etc.in duo view mode */
    OPTION_FORCE_LCD, /* Force to enable LCD without mobile version BIOS. */
    OPTION_LCD_PANEL_SIZE, /* to simply LCD panel option. */
    OPTION_DPA_SETTING_DVP0,
    OPTION_DPA_SETTING_DVP1,
    OPTION_DPA_SETTING_DFPHIGH,
    OPTION_DPA_SETTING_DFPLOW,
    OPTION_DPA_SETTING_VT1636,
#ifndef CS_FLAG_NO_LCD_SCAL
    OPTION_LCDDISP3DScaling,  
#endif /* CS_FLAG_NO_LCD_SCAL */
    OPTION_VIDEO_COLOR_KEY,
    OPTION_GOOD_PERFORMANCE,
    OPTION_LCD_MSB_ENABLE,
    OPTION_LCD_NO_DITHERING,
    OPTION_LCD_DUAL_CHANNEL,
    OPTION_INTERLACE_MODE,
    OPTION_FN_HOTKEY,
    OPTION_TEXTUREVIDEOSUPPORT,
    OPTION_TEXTUREVIDEO3DPATH,
} VIAOpts;


static OptionInfoRec VIAOptions[] =
{
    {OPTION_NOACCEL,    "NoAccel",      OPTV_BOOLEAN, {0}, FALSE},
#ifdef VIA_HAVE_EXA
	{OPTION_ACCELMETHOD,         "AccelMethod",      OPTV_STRING,  {0}, FALSE},
    {OPTION_EXA_NOCOMPOSITE,     "ExaNoComposite",   OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_EXA_SCRATCH_SIZE,    "ExaScratchSize",   OPTV_INTEGER, {0}, FALSE},
#endif
    {OPTION_DRI,    "DRI",   OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_SWCURSOR,   "SWCursor",     OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_SHADOW_FB,  "ShadowFB",     OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_ROTATE,     "Rotate",     OPTV_ANYSTR,  {0}, FALSE},
    {OPTION_ROTATE_TYPE,"RotateType",     OPTV_ANYSTR,  {0}, FALSE},   
    {OPTION_VIDEORAM,   "VideoRAM",     OPTV_INTEGER, {0}, FALSE},
    {OPTION_VIDEORAM1,  "VideoRAM1",    OPTV_INTEGER, {0}, FALSE},
    {OPTION_TWO_LCD,    "TwoLCD",       OPTV_BOOLEAN, {0}, FALSE},    
    {OPTION_ACTIVEDEVICE,   "ActiveDevice", OPTV_ANYSTR,  {0}, FALSE},
    {OPTION_DVI_PORT,       "DVIPort",      OPTV_ANYSTR,  {0}, FALSE},
    {OPTION_LCD_PORT,       "LCDPort",      OPTV_ANYSTR, {0}, FALSE},
    {OPTION_LCD_BUS_WIDTH,  "LCDBusWidth",  OPTV_ANYSTR, {0}, FALSE},
    {OPTION_CENTER,         "Center",       OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_LCD_PANEL_SIZE, "PanelSize",    OPTV_STRING, {0}, FALSE},
    {OPTION_REFRESH,    "Refresh",      OPTV_INTEGER, {0}, FALSE},
    {OPTION_DISABLEVQ,  "DisableVQ",    OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_NODDCVALUE, "NoDDCValue",   OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_DRIXINERAMA,  "DRIXINERAMA",    OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_MERGEDFB, "MergedFB",    OPTV_BOOLEAN,  {0}, FALSE},
    {OPTION_NOVIAXINERAMA, "NoVIAXinerama",    OPTV_BOOLEAN,  {0}, FALSE},
    {OPTION_SCRN2POS,   "Scrn2Pos", OPTV_ANYSTR, {0}, FALSE},   
    {OPTION_EPIA_DVI, "EPIA_DVI",    OPTV_BOOLEAN,  {0}, FALSE},
    {OPTION_VideoOnDevice,  "VideoOnDevice",       OPTV_ANYSTR,  {0}, FALSE},
    {OPTION_FORCE_LCD, "ForceLCD", OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_DPA_SETTING_DVP0,       "DPASetting_DVP0",      OPTV_ANYSTR, {0}, FALSE},
    {OPTION_DPA_SETTING_DVP1,       "DPASetting_DVP1",      OPTV_ANYSTR, {0}, FALSE},
    {OPTION_DPA_SETTING_DFPHIGH,    "DPASetting_DFPHIGH",   OPTV_ANYSTR, {0}, FALSE},
    {OPTION_DPA_SETTING_DFPLOW,     "DPASetting_DFPLOW",    OPTV_ANYSTR, {0}, FALSE},
    {OPTION_DPA_SETTING_VT1636,     "DPASetting_VT1636",    OPTV_ANYSTR, {0}, FALSE},
#ifndef CS_FLAG_NO_LCD_SCAL
    {OPTION_LCDDISP3DScaling,       "DISPLAY_3DScaling_LCD",    OPTV_BOOLEAN, {0}, FALSE},    
#endif /* CS_FLAG_NO_LCD_SCAL */
    {OPTION_VIDEO_COLOR_KEY,        "VideoColorKey",  OPTV_INTEGER, {0}, FALSE},
    {OPTION_GOOD_PERFORMANCE,       "GoodPerformance",  OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_LCD_MSB_ENABLE,         "LCD_MSB_ENABLE",  OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_LCD_NO_DITHERING,       "NoDithering",  OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_LCD_DUAL_CHANNEL,       "DualChannel",  OPTV_STRING, {0}, FALSE},
    {OPTION_INTERLACE_MODE,         "Interlace",            OPTV_BOOLEAN, {0}, FALSE},
    {OPTION_FN_HOTKEY,              "FnHotkey",             OPTV_ANYSTR, {0}, FALSE},
    {-1,                NULL,           OPTV_NONE,    {0}, FALSE}
};

Bool via_module_loaded = FALSE;

static const char *viavideoSymbols[] = {
  "vvaUpdateOverlay",
  "vvaInitVideo",
  "vvaSyncInfo",
  "vvaGet3DScalingVideoInfo",
  NULL
};

static const char *vgaHWSymbols[] = {
    "vgaHWGetHWRec",
    "vgaHWSetMmioFuncs",
    "vgaHWSetStdFuncs",
    "vgaHWGetIOBase",
    "vgaHWSave",
    "vgaHWProtect",
    "vgaHWRestore",
    "vgaHWMapMem",
    "vgaHWUnmapMem",
    "vgaHWInit",
    "vgaHWSaveScreen",
    "vgaHWLock",
    "vgaHWUnlock",
    "vgaHWFreeHWRec",
    NULL
};


static const char *ramdacSymbols[] = {
    "xf86InitCursor",
    "xf86CreateCursorInfoRec",
    "xf86DestroyCursorInfoRec",
    NULL
};

static const char *vbeSymbols[] = {
    "VBEInit",
    "VBEGetVBEMode",
    "VBESetVBEMode",
    "vbeDoEDID",
    "vbeFree",
    NULL
};

static const char *vbeSymbols429900[] = {
    "VBEExtendedInit",
    "VBEGetVBEMode",
    "VBESetVBEMode",
    "vbeDoEDID",
    "vbeFree",
    NULL
};

static const char *ddcSymbols[] = {
    "xf86PrintEDID",
    "xf86DoEDID_DDC1",
    "xf86DoEDID_DDC2",
    "xf86SetDDCproperties",
    NULL
};


static const char *i2cSymbols[] = {
    "xf86CreateI2CBusRec",
    "xf86I2CBusInit",
    "xf86CreateI2CDevRec",
    "xf86I2CDevInit",
    "xf86I2CWriteRead",
    "xf86I2CFindDev",
    "xf86I2CProbeAddress",
    "xf86DestroyI2CDevRec",
    "xf86DestroyI2CBusRec",
    NULL
};

static const char *xaaSymbols[] = {
#ifdef X_HAVE_XAAGETROP
    "XAAGetCopyROP",
    "XAAGetCopyROP_PM",
    "XAAGetPatternROP",
#else
    "XAACopyROP",
    "XAACopyROP_PM",
    "XAAPatternROP",
#endif
    "XAACreateInfoRec",
    "XAADestroyInfoRec",
    "XAAInit",
    "XAAFillSolidRects",
    NULL
};

static const char *int10Symbols[] = {
    "xf86FreeInt10",
    "xf86InitInt10",
    NULL
};

static const char *shadowSymbols[] = {
    "ShadowFBInit",
    NULL
};


static const char *fbSymbols[] = {
    "fbScreenInit",
    "fbPictureInit",
    NULL
};


#ifdef VIA_HAVE_EXA
static const char *exaSymbols[] = {
    "exaGetVersion",
    "exaDriverInit",
    "exaDriverFini",
    "exaOffscreenAlloc",
    "exaOffscreenFree",
    "exaGetPixmapPitch",
    "exaGetPixmapOffset",
    "exaWaitSync",
#if (EXA_VERSION_MAJOR >= 2)
    "exaDriverAlloc",
#else
    "exaGetVersion",
#endif
    NULL
};
#endif
/* for Via DVD and Video support */
/*
 * No use now, for old Xserver module code use
 */

#ifdef XFree86LOADER
#ifdef XF86DRI
static const char *drmSymbols[] = {
    "drmOpen",
    "drmClose",
    "drmAddMap",
    "drmAgpAcquire",
    "drmAgpAlloc",
    "drmAgpBase",
    "drmAgpBind",
    "drmAgpEnable",
    "drmAgpFree",
    "drmAgpGetMode",
    "drmAgpRelease",
    "drmCtlInstHandler",
    "drmGetInterruptFromBusID",
    "drmMap",
    "drmUnmap",
    NULL
};

static const char *driSymbols[] = {
    "DRICloseScreen",
    "DRICreateInfoRec",
    "DRIDestroyInfoRec",
    "DRIFinishScreenInit",
    "DRIGetSAREAPrivate",
    "DRILock",
    "DRIQueryVersion",
    "DRIScreenInit",
    "DRIUnlock",
    "GlxSetVisualConfigs",
    NULL
};
#endif

static MODULESETUPPROTO(VIASetup);

static XF86ModuleVersionInfo VIAVersRec = {
    "via",
    MODULEVENDORSTRING,
    MODINFOSTRING1,
    MODINFOSTRING2,
    XF86_VERSION_CURRENT,
    VERSION_MAJOR, VERSION_MINOR, PATCHLEVEL,
    ABI_CLASS_NONE,
    ABI_VIDEODRV_VERSION,
    MOD_CLASS_VIDEODRV,
    {0, 0, 0, 0}
};

XF86ModuleData viaModuleData = {&VIAVersRec, VIASetup, NULL};

unsigned int via_xf86_version_current;


#ifdef VIA_RANDR12_SUPPORT
static Bool
via_xf86crtc_resize (ScrnInfoPtr pScrn, int width, int height)
{
    DEBUG(ErrorF("via_xf86crtc_resize, width=%d, height=%d\n", width, height));
    
    pScrn->virtualX = width;
    pScrn->virtualY = height;       
        
    pScrn->frameX1 = pScrn->virtualX;
    pScrn->frameY1 = pScrn->virtualY;
    
    return TRUE;
}

static const xf86CrtcConfigFuncsRec via_xf86crtc_config_funcs = {
    via_xf86crtc_resize
};
#endif


int GetIGAPath(VIABIOSInfoPtr pBIOSInfo)
{
    switch(pBIOSInfo->ActiveDevice)
    {
        case VIA_DEVICE_LCD:
          return pBIOSInfo->LVDSSettingInfo.IGAPath;
          
        case VIA_DEVICE_CRT1:        
          return pBIOSInfo->CRTSettingInfo.IGAPath;
          
        case VIA_DEVICE_DFP:
          return pBIOSInfo->TMDSSettingInfo.IGAPath;
          
        default:
          return IGA1;
     }
} 



void fill3DScalingInfo(VIAPtr pVia, IGASETTINGINFO  *pIGASettingInfo, HW3D_Scaling_INFO   *pgfx3DScal_info)
{ 
    VIA3DSclSCNParasPtr pDISP3DScalScreenInfo = NULL;
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    VIADISP3DSCALCTRLPtr p3DSCALCTRLInfo =&(pIGASettingInfo->DISP3DSCALCTRLInfo);
    
    xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "fill 3D Scaling info, device is %x\n", pIGASettingInfo->deviceActived);  
    switch(pIGASettingInfo->deviceActived)
    {
        case VIA_DEVICE_DFP:
            pDISP3DScalScreenInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
            break;
        case VIA_DEVICE_LCD:
            pDISP3DScalScreenInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);
            break;             
    }
      pgfx3DScal_info->gfx3DScalingEnable = TRUE;
      pgfx3DScal_info->OrigHActive = p3DSCALCTRLInfo->OrigHActive;
      pgfx3DScal_info->OrigVActive = p3DSCALCTRLInfo->OrigVActive;
      pgfx3DScal_info->RealHActive = p3DSCALCTRLInfo->RealHActive;
      pgfx3DScal_info->RealVActive = p3DSCALCTRLInfo->RealVActive;
      pgfx3DScal_info->DISP3DScalIGAPath = p3DSCALCTRLInfo->DISP3DScalIGAPath;
      pgfx3DScal_info->XSIZEOffset = pDISP3DScalScreenInfo->XSIZEOffset; 
      pgfx3DScal_info->YSIZEOffset = pDISP3DScalScreenInfo->YSIZEOffset;
      pgfx3DScal_info->XPOSITIONOffset = pDISP3DScalScreenInfo->XPOSITIONOffset;
      pgfx3DScal_info->YPOSITIONOffset = pDISP3DScalScreenInfo->YPOSITIONOffset;

      viaGfxInfo->igaInfo[pgfx3DScal_info->DISP3DScalIGAPath-1].desired_width=pBIOSInfo->CrtcHDisplay;
      viaGfxInfo->igaInfo[pgfx3DScal_info->DISP3DScalIGAPath-1].desired_height=pBIOSInfo->CrtcVDisplay;
}

/* Translate the new GfxInfo to the DDMPEG NEWVIAGRAPHICINFO.
*/
void TranslateGFXInfo(viaGfxInfoPtr viaGfxInfo, LPNEWVIAGRAPHICINFO lpNEWVIAGraphicInfo)
{
    int idx;
	int scrnIndex;
    
    DBG_DD(("  TranslateGFXInfo called: Translate the new GfxInfo to the DDMPEG NEWVIAGRAPHICINFO.\n"));

    if(viaGfxInfo->chipId != 0) {
    	lpNEWVIAGraphicInfo->dwDeviceID = viaGfxInfo->chipId;
    }

    if(viaGfxInfo->fbhandle != 0) {
    	lpNEWVIAGraphicInfo->FBhandle = viaGfxInfo->fbhandle;
    }
    if(viaGfxInfo->mmiohandle != 0) {
    	lpNEWVIAGraphicInfo->MMIOhandle = viaGfxInfo->mmiohandle;
    }

    if(viaGfxInfo->fbPhybase != 0) {
    	lpNEWVIAGraphicInfo->ScreenPhysAddr = viaGfxInfo->fbPhybase;
    }

    if(viaGfxInfo->vramsize != 0) {
    	lpNEWVIAGraphicInfo->Screen[0].TotalVRAM = viaGfxInfo->vramsize;
    	lpNEWVIAGraphicInfo->Screen[1].TotalVRAM = viaGfxInfo->vramsize;
    }
    if(viaGfxInfo->vheapbase != 0) {
    	lpNEWVIAGraphicInfo->Screen[0].VideoHeapBase = viaGfxInfo->vheapbase;
    	lpNEWVIAGraphicInfo->Screen[1].VideoHeapBase = viaGfxInfo->vheapbase;
    }
    if(viaGfxInfo->vheapend != 0) {
    	lpNEWVIAGraphicInfo->Screen[0].VideoHeapEnd = viaGfxInfo->vheapend;
    	lpNEWVIAGraphicInfo->Screen[1].VideoHeapEnd = viaGfxInfo->vheapend;
    }

    if(viaGfxInfo->drmEnabled) {
        lpNEWVIAGraphicInfo->DRMEnabled = TRUE;
    } else {
        lpNEWVIAGraphicInfo->DRMEnabled = FALSE;
    }

    lpNEWVIAGraphicInfo->xrandrEnabled = viaGfxInfo->xrandrEnabled;
    
    lpNEWVIAGraphicInfo->dwXServerEnabled = TRUE;

    lpNEWVIAGraphicInfo->IsHWCursorEnabled = viaGfxInfo->hwIconEnalbed;

    if(viaGfxInfo->screenAttr.singleview) {
        lpNEWVIAGraphicInfo->duoview = 0;
        lpNEWVIAGraphicInfo->SAMM = FALSE;
        lpNEWVIAGraphicInfo->IsExtend = FALSE;
    } else if(viaGfxInfo->screenAttr.duoview) {
        lpNEWVIAGraphicInfo->duoview = DUOVIEW_ENABLED;
        lpNEWVIAGraphicInfo->SAMM = FALSE;
        lpNEWVIAGraphicInfo->IsExtend = FALSE;
    } else if(viaGfxInfo->screenAttr.samm) {
        lpNEWVIAGraphicInfo->duoview = 0;
        lpNEWVIAGraphicInfo->SAMM = (viaGfxInfo->xrandrEnabled)? FALSE:TRUE;
        lpNEWVIAGraphicInfo->IsExtend= (viaGfxInfo->xrandrEnabled)? TRUE:FALSE;
        lpNEWVIAGraphicInfo->ExtendStatus = RELATION_NONE;
        lpNEWVIAGraphicInfo->Screen1IsAbove = 0;
        lpNEWVIAGraphicInfo->Screen1IsLeft = 0;
    }

    if(viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.extend) {
        if(viaGfxInfo->igaAttr.iga2_left)
            lpNEWVIAGraphicInfo->ExtendStatus |= RELATION_LEFT_OF;
        if(viaGfxInfo->igaAttr.iga2_above)
            lpNEWVIAGraphicInfo->ExtendStatus |= RELATION_ABOVE_OF;
        if(viaGfxInfo->igaAttr.iga2_right)
            lpNEWVIAGraphicInfo->ExtendStatus |= RELATION_RIGHT_OF;
        if(viaGfxInfo->igaAttr.iga2_below)
            lpNEWVIAGraphicInfo->ExtendStatus |= RELATION_BELOW_OF;
    } else {
        lpNEWVIAGraphicInfo->Screen1IsLeft = viaGfxInfo->igaAttr.iga2_left;
        lpNEWVIAGraphicInfo->Screen1IsAbove = viaGfxInfo->igaAttr.iga2_above;
    }
   
    lpNEWVIAGraphicInfo->Screen_IGA_Map[2] = -1;
    /*
    1. Non_RandR
      a. Single:    Screen0 - Screen_IGA_Map[0]
      b. DuoView:   Screen0 - IGA1
                    Screen1 - IGA2
      c. SAMM       Screen0 - Screen_IGA_Map[0]
                    Screen1 - Screen_IGA_Map[1]
    2. RandR
      a. Single:    Screen0 - Screen_IGA_Map[0]
      b. Clone:     Screen0 - IGA1
                    Screen1 - IGA2
      c. Extend:    Screen0 - IGA1
                    Screen1 - IGA2
    */
    for( idx = 0; idx < 2; idx++) {
        if(viaGfxInfo->igaInfo[idx].actived) {
            /* look for screen index according to IGA */                      
            for (scrnIndex = 0; scrnIndex < 2; scrnIndex++) {
                if (viaGfxInfo->screenInfo[scrnIndex].igaInuse == IGA1_IGA2) {
                    lpNEWVIAGraphicInfo->Screen_IGA_Map[0] = IGA1;
                    lpNEWVIAGraphicInfo->Screen_IGA_Map[1] = IGA2;
                    scrnIndex = idx;
                    break;
                } else if (viaGfxInfo->screenInfo[scrnIndex].igaInuse == idx+1) {
                    lpNEWVIAGraphicInfo->Screen_IGA_Map[scrnIndex] = idx+1;
                    break;
                }
            }

            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwSaveWidth = viaGfxInfo->igaInfo[idx].visible_width;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwSaveHeight = viaGfxInfo->igaInfo[idx].visible_height;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwBPP = viaGfxInfo->screenInfo[scrnIndex].bpp;

            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwWidth = viaGfxInfo->igaInfo[idx].desired_width;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwHeight = viaGfxInfo->igaInfo[idx].desired_height;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwCurWidth = viaGfxInfo->igaInfo[idx].crtc_width;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwCurHeight = viaGfxInfo->igaInfo[idx].crtc_height;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwPanelWidth = viaGfxInfo->igaInfo[idx].crtc_width;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwPanelHeight = viaGfxInfo->igaInfo[idx].crtc_height;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwRefreshRate = viaGfxInfo->igaInfo[idx].refreshrate;
            lpNEWVIAGraphicInfo->Screen[scrnIndex].dwPitch = 
                CMDISP_ALIGN_TO((viaGfxInfo->igaInfo[idx].visible_width * (viaGfxInfo->screenInfo[scrnIndex].bpp >> 3)), 32);
            lpNEWVIAGraphicInfo->offset_x[idx] = viaGfxInfo->igaInfo[idx].start_x;
            lpNEWVIAGraphicInfo->offset_y[idx] = viaGfxInfo->igaInfo[idx].start_y;
            
            if(viaGfxInfo->igaInfo[idx].activeDevice.unit) {
                lpNEWVIAGraphicInfo->Screen[scrnIndex].dwActiveDevice = viaGfxInfo->igaInfo[idx].activeDevice.unit;
            } else {
                lpNEWVIAGraphicInfo->Screen[scrnIndex].dwActiveDevice = 0;
            }
	    
            if(viaGfxInfo->igaInfo[idx].igaStatus.unit) {
                lpNEWVIAGraphicInfo->Screen[scrnIndex].dwPanning = viaGfxInfo->igaInfo[idx].igaStatus.panning;
                lpNEWVIAGraphicInfo->Screen[scrnIndex].dwExpand = viaGfxInfo->igaInfo[idx].igaStatus.expanded;
                lpNEWVIAGraphicInfo->Screen[scrnIndex].IsDownScaling = viaGfxInfo->igaInfo[idx].igaStatus.scaling_hw;
		
                if(viaGfxInfo->igaInfo[idx].igaStatus.panning)
                    lpNEWVIAGraphicInfo->IGAPanningStatus |= (!idx) ? IGA1 : IGA2;
		
                if(viaGfxInfo->igaInfo[idx].igaStatus.scaling_3d) {
                    memcpy(((!idx) ? &lpNEWVIAGraphicInfo->iga1gfx3DScal_info : 
                        &lpNEWVIAGraphicInfo->iga2gfx3DScal_info), 
                        &viaGfxInfo->igaInfo[idx].igagfx3DScaling_info, 
                        sizeof(HW3D_Scaling_INFO));
                } else {
                    memset(((!idx) ? &lpNEWVIAGraphicInfo->iga1gfx3DScal_info : &lpNEWVIAGraphicInfo->iga2gfx3DScal_info),
                        0x00, sizeof(HW3D_Scaling_INFO));
                }
            } else {
                lpNEWVIAGraphicInfo->Screen[scrnIndex].dwPanning = 0;
                lpNEWVIAGraphicInfo->Screen[scrnIndex].dwExpand = 0;
                lpNEWVIAGraphicInfo->Screen[scrnIndex].IsDownScaling = 0;
                memset(((!idx) ? &lpNEWVIAGraphicInfo->iga1gfx3DScal_info : &lpNEWVIAGraphicInfo->iga2gfx3DScal_info),
                    0x00, sizeof(HW3D_Scaling_INFO));
            }
            if(viaGfxInfo->igaInfo[idx].igaRRStatus.unit) {
                lpNEWVIAGraphicInfo->IsRotationEnabled = TRUE;
                lpNEWVIAGraphicInfo->rotate = viaGfxInfo->igaInfo[idx].igaRRStatus.unit;
                lpNEWVIAGraphicInfo->samm_rotate[idx + 1] = viaGfxInfo->igaInfo[idx].igaRRStatus.unit;
            } else {
                lpNEWVIAGraphicInfo->IsRotationEnabled = FALSE;
                lpNEWVIAGraphicInfo->rotate = 0;
                lpNEWVIAGraphicInfo->samm_rotate[idx + 1] = 0;
            }
        }
    }

    return;
}
void FillGraphicInfo_New(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

	viaGfxInfo->chipId = pVia->ChipId;
	viaGfxInfo->revisionId = pVia->ChipRev;
	viaGfxInfo->fbPhybase = pVia->FrameBufferBase;
	viaGfxInfo->vramsize = pVia->videoRambytes;
	viaGfxInfo->vheapbase = (unsigned long) pVia->FBFreeStart;
	viaGfxInfo->vheapend = (unsigned long) (pVia->FBFreeEnd - 1);
	viaGfxInfo->xrandrEnabled = TRUE;	

	/* Added to pass DRM info to V4L */
#ifdef XF86DRI
	viaGfxInfo->drmEnabled = pVia->directRenderingEnabled;
#else
    viaGfxInfo->drmEnabled = 0;
#endif
    	
    return;
}


void getDeviceOnIgaforSamm(ScrnInfoPtr pScrn)
{
    DevUnion* pPriv = xf86GetEntityPrivate(pScrn->entityList[0], gVIAEntityIndex);
    VIAEntPtr pVIAEnt = pPriv->ptr;
    VIAPtr pVia1 = VIAPTR(pScrn);
    VIAPtr pVia0 = VIAPTR(pVIAEnt->pPrimaryScrn);
    VIABIOSInfoPtr pBIOSInfo1 = pVia1->pBIOSInfo;
    VIABIOSInfoPtr pBIOSInfo0 = pVia0->pBIOSInfo;
    PVIDDATA pVidData = pVia0->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    pBIOSInfo1->PrimaryDevice = pBIOSInfo0->PrimaryDevice;    
    
    switch (pBIOSInfo0->ActiveDevice | pBIOSInfo1->ActiveDevice) {
        case (VIA_DEVICE_CRT1 | VIA_DEVICE_LCD):
            /* CRT+LCD */
            viaGfxInfo->igaInfo[IGA1-1].activeDevice.crt = 1;
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1;
            break;
            
        case (VIA_DEVICE_CRT1 | VIA_DEVICE_DFP):
            if (pBIOSInfo0->PrimaryDevice == VIA_DEVICE_DFP) {
                /* DVI+CRT */
                viaGfxInfo->igaInfo[IGA1-1].activeDevice.dvi = 1;
                viaGfxInfo->igaInfo[IGA2-1].activeDevice.crt = 1;
            } else {
                /* CRT+DVI */
                viaGfxInfo->igaInfo[IGA1-1].activeDevice.crt = 1;
                viaGfxInfo->igaInfo[IGA2-1].activeDevice.dvi = 1;
            }
            break;
            
        case (VIA_DEVICE_LCD | VIA_DEVICE_DFP):
            /* DVI+LCD */
            viaGfxInfo->igaInfo[IGA1-1].activeDevice.dvi = 1;
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1;
            break;

        case (VIA_DEVICE_LCD | VIA_DEVICE_LCD2):
            if (pBIOSInfo0->PrimaryDevice == VIA_DEVICE_LCD) {
                /* LCD+LCD2 */
                viaGfxInfo->igaInfo[IGA1-1].activeDevice.lcd = 1;
                viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd2 = 1;
            } else {
                /* LCD2+LCD */
                viaGfxInfo->igaInfo[IGA1-1].activeDevice.lcd2 = 1;
                viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1;
            }            
            break;  
            
        default:
            break;            
    }
}

void getDeviceOnIgafordouview(VIAPtr pVia)
{
    
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;

    switch (pBIOSInfo->ActiveDevice) {
        case (VIA_DEVICE_CRT1 | VIA_DEVICE_LCD):
            viaGfxInfo->igaInfo[IGA1-1].activeDevice.crt = 1;
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1;
            break;
                
        case (VIA_DEVICE_CRT1 | VIA_DEVICE_DFP):
            viaGfxInfo->igaInfo[IGA1-1].activeDevice.crt = 1;
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.dvi = 1;
            break;
                
        case (VIA_DEVICE_LCD | VIA_DEVICE_DFP):
            viaGfxInfo->igaInfo[IGA1-1].activeDevice.dvi = 1;
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1;
            break;

        case (VIA_DEVICE_LCD | VIA_DEVICE_LCD2):
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1; 
            viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd2 = 1; 
            break;
                
        default :
            viaGfxInfo->igaInfo[IGA1-1].activeDevice.crt = 1;
            break;
        }
}

void getDeviceOnIgaforSingle(VIAPtr pVia)
{
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    int idx = 0;

    for (idx=0;idx<2;idx++) {
        if(viaGfxInfo->igaInfo[idx].actived)
            break;
    }

    viaGfxInfo->igaInfo[idx].activeDevice.unit = pBIOSInfo->ActiveDevice;
}

void getDeviceOnIga(ScrnInfoPtr pScrn) 
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    
    if (pVia->IsSecondary) {
        if (pBIOSInfo->SAMM) {
            getDeviceOnIgaforSamm(pScrn);
        }
    } else if (pBIOSInfo->DuoView) {
        getDeviceOnIgafordouview(pVia);
    } else if (pBIOSInfo->ActualActiveDevice == (VIA_DEVICE_LCD & VIA_DEVICE_LCD2)) {
        viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd = 1;
        viaGfxInfo->igaInfo[IGA2-1].activeDevice.lcd2 = 1;
    } else {
        getDeviceOnIgaforSingle(pVia);
    }
}



void FillGraphicInfo(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    int igaNowUse = 0;
    DBG_DD(("  FillGraphicInfo!!\n"));
    
    /*1.fill generally info,just do once*/
    if(!pVia->IsSecondary)
    {
        viaGfxInfo->vheapbase = (unsigned long) pVia->FBFreeStart;
        viaGfxInfo->vheapend = (unsigned long) (pVia->FBFreeEnd - 1);
        viaGfxInfo->vramsize = pVia->videoRambytes;
        viaGfxInfo->revisionId = pVia->ChipRev;
        viaGfxInfo->chipId = pVia->ChipId;
        viaGfxInfo->fbPhybase = pVia->FrameBufferBase;
    }

    if(pBIOSInfo->UseIGA2)
        viaGfxInfo->preferedVideoIga = IGA2;

    viaGfxInfo->screenAttr.uint = 0;
    if(pBIOSInfo->SAMM)
        viaGfxInfo->screenAttr.uint = VIA_SAMM;
    if(pBIOSInfo->DuoView)
        viaGfxInfo->screenAttr.uint = VIA_DUOVIEW;
    
    viaGfxInfo->hwIconEnalbed = pVia->pScreensPublicInfo->UseHwCursor;

    #ifdef XF86DRI
        viaGfxInfo->drmEnabled = pVia->directRenderingEnabled 
#ifdef DRM_SAMM_VIA
                                || pVia->drmSammEnabled
#endif
                                ;
    #else
        viaGfxInfo->drmEnabled = 0;
    #endif

    /*2.fill the screen info*/
    viaGfxInfo->screenInfo[pScrn->scrnIndex].bpp = pScrn->bitsPerPixel;
    viaGfxInfo->screenInfo[pScrn->scrnIndex].fboffset_rot = pScrn->fbOffset;

    /*3.fill the iga info*/
    /*initial the iga info part*/
    if (pBIOSInfo->IGA1SettingInfo.IsActive) {
        igaNowUse = IGA1; 
        viaGfxInfo->igaInfo[IGA1-1].crtc_width = pBIOSInfo->IGA1SettingInfo.CrtcWidth;
        viaGfxInfo->igaInfo[IGA1-1].crtc_height = pBIOSInfo->IGA1SettingInfo.CrtcHeight;
        viaGfxInfo->igaInfo[IGA1-1].igaStatus.panning=pBIOSInfo->IGA1SettingInfo.IsPanning;
        viaGfxInfo->igaInfo[IGA1-1].igaStatus.scaling_hw=pBIOSInfo->IGA1SettingInfo.IsDownScaling;
    } 

    if (pBIOSInfo->IGA2SettingInfo.IsActive){
        igaNowUse = IGA2;
        viaGfxInfo->igaInfo[IGA2-1].crtc_width = pBIOSInfo->IGA2SettingInfo.CrtcWidth;
        viaGfxInfo->igaInfo[IGA2-1].crtc_height = pBIOSInfo->IGA2SettingInfo.CrtcHeight;                
        viaGfxInfo->igaInfo[IGA2-1].igaStatus.panning=pBIOSInfo->IGA2SettingInfo.IsPanning;
        viaGfxInfo->igaInfo[IGA2-1].igaStatus.scaling_hw = pBIOSInfo->IGA2SettingInfo.IsDownScaling;    
    }
    
    /*the iga1 and iga2 can shared code*/
    if (viaGfxInfo->screenAttr.duoview) {
        int i=0;
        viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse = IGA1+IGA2;
        for (i=0;i<2;i++) {
            viaGfxInfo->igaInfo[i].actived = TRUE;
            viaGfxInfo->igaInfo[i].refreshrate = (unsigned long)pBIOSInfo->FoundRefresh;
            viaGfxInfo->igaInfo[i].visible_width = pScrn->virtualX;
            viaGfxInfo->igaInfo[i].visible_height = pScrn->virtualY;
            viaGfxInfo->igaInfo[i].desired_width=pBIOSInfo->CrtcHDisplay;
            viaGfxInfo->igaInfo[i].desired_height=pBIOSInfo->CrtcVDisplay;
            viaGfxInfo->igaInfo[i].igaStatus.expanded = pBIOSInfo->scaleY;
            viaGfxInfo->igaInfo[i].igaRRStatus.unit = pVia->RotateDegree;
        }
    } else {
        if (!(viaGfxInfo->screenAttr.samm)){
            viaGfxInfo->screenAttr.uint = VIA_SINGLEVIEW;
        }
        viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse = igaNowUse;
        viaGfxInfo->igaInfo[igaNowUse-1].actived = TRUE;
        viaGfxInfo->igaInfo[igaNowUse-1].refreshrate = (unsigned long)pBIOSInfo->FoundRefresh;
        viaGfxInfo->igaInfo[igaNowUse-1].visible_width = pScrn->virtualX;
        viaGfxInfo->igaInfo[igaNowUse-1].visible_height = pScrn->virtualY;
        viaGfxInfo->igaInfo[igaNowUse-1].desired_width=pBIOSInfo->CrtcHDisplay;
        viaGfxInfo->igaInfo[igaNowUse-1].desired_height=pBIOSInfo->CrtcVDisplay;
        viaGfxInfo->igaInfo[igaNowUse-1].igaStatus.expanded = pBIOSInfo->scaleY;
        viaGfxInfo->igaInfo[igaNowUse-1].igaRRStatus.unit = pVia->RotateDegree;
    }

    /*get which device on iga*/
    getDeviceOnIga(pScrn);

    /*4. fill 3d scaling info*/
    IGASETTINGINFO *pIGASettingInfo;
    HW3D_Scaling_INFO *pgfx3DScal_info=NULL;

    if (viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse & IGA1) {
        if (pBIOSInfo->IGA1SettingInfo.IsDISP3DScaling) {
            viaGfxInfo->igaInfo[IGA1-1].igaStatus.scaling_3d = TRUE;
            pIGASettingInfo=&(pBIOSInfo->IGA1SettingInfo);
            pgfx3DScal_info=&(viaGfxInfo->igaInfo[IGA1-1].igagfx3DScaling_info);  
        
            fill3DScalingInfo(pVia, pIGASettingInfo, pgfx3DScal_info);
        } else {
            viaGfxInfo->igaInfo[IGA1-1].igaStatus.scaling_3d = FALSE;
            viaGfxInfo->igaInfo[IGA1-1].igagfx3DScaling_info.gfx3DScalingEnable = FALSE;
        }
    }

    if (viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse & IGA2) {
        if (pBIOSInfo->IGA2SettingInfo.IsDISP3DScaling) {
            viaGfxInfo->igaInfo[IGA2-1].igaStatus.scaling_3d = TRUE;
            pIGASettingInfo = &(pBIOSInfo->IGA2SettingInfo);
            pgfx3DScal_info = &(viaGfxInfo->igaInfo[IGA2-1].igagfx3DScaling_info);    
            fill3DScalingInfo(pVia, pIGASettingInfo, pgfx3DScal_info);
        } else {
            viaGfxInfo->igaInfo[IGA2-1].igaStatus.scaling_3d = FALSE;
            viaGfxInfo->igaInfo[IGA2-1].igagfx3DScaling_info.gfx3DScalingEnable = FALSE;
        }
    }


    /*5. fill video samm info*/
    memset(&(viaGfxInfo->igaAttr),0x0,sizeof(viaGfxInfo->igaAttr));
    if(xf86ConfigLayout.screens[1].screen){
        switch (xf86ConfigLayout.screens[1].where){
        case PosRightOf:
            if (viaGfxInfo->screenInfo[1].igaInuse == IGA1) {
                viaGfxInfo->igaAttr.iga2_left = 1;
            } else {
                viaGfxInfo->igaAttr.iga2_right = 1;
            }
            break;
        case PosLeftOf:
            if (viaGfxInfo->screenInfo[1].igaInuse == IGA1) {
                viaGfxInfo->igaAttr.iga2_right = 1;
            } else {
                viaGfxInfo->igaAttr.iga2_left = 1;
            }
            break;
        case PosAbove:
            if (viaGfxInfo->screenInfo[1].igaInuse == IGA1) {
                viaGfxInfo->igaAttr.iga2_below = 1;
            } else {
                viaGfxInfo->igaAttr.iga2_above = 1;
            }
            break;
        case PosBelow:
            if (viaGfxInfo->screenInfo[1].igaInuse == IGA1) {
                viaGfxInfo->igaAttr.iga2_above = 1;
            } else {
                viaGfxInfo->igaAttr.iga2_below = 1;
            }
            break;
        default:
            break;
        }
    }

    /*6.fill startx starty value video only used in SAMM case*/
    if  (viaGfxInfo->screenAttr.samm) {
        if (viaGfxInfo->igaAttr.iga2_above) {
            viaGfxInfo->igaInfo[0].start_x = 0;
            viaGfxInfo->igaInfo[0].start_y = viaGfxInfo->igaInfo[1].visible_height;
            viaGfxInfo->igaInfo[1].start_x = 0;
            viaGfxInfo->igaInfo[1].start_y = 0;
        } else if (viaGfxInfo->igaAttr.iga2_below) {
            viaGfxInfo->igaInfo[0].start_x = 0;
            viaGfxInfo->igaInfo[0].start_y = 0;
            viaGfxInfo->igaInfo[1].start_x = 0;
            viaGfxInfo->igaInfo[1].start_y = viaGfxInfo->igaInfo[0].visible_height;
        } else if (viaGfxInfo->igaAttr.iga2_left) {
            viaGfxInfo->igaInfo[0].start_x = viaGfxInfo->igaInfo[1].visible_width;
            viaGfxInfo->igaInfo[0].start_y = 0;
            viaGfxInfo->igaInfo[1].start_x = 0;
            viaGfxInfo->igaInfo[1].start_y = 0;
        } else if (viaGfxInfo->igaAttr.iga2_right) {
            viaGfxInfo->igaInfo[0].start_x = 0;
            viaGfxInfo->igaInfo[0].start_y = 0;
            viaGfxInfo->igaInfo[1].start_x = viaGfxInfo->igaInfo[0].visible_width;
            viaGfxInfo->igaInfo[1].start_y = 0;
        }
    }    
}

static pointer VIASetup(pointer module, pointer opts, int *errmaj, int *errmin)
{
    static Bool setupDone = FALSE;

	/*Only be loaded once*/
    if (!setupDone) {
        /*print addtional build string*/
        char *subversion=VIA_SUBVERSION;
        if (subversion)
           xf86Msg(X_INFO,"via driver subversion: %s\n",subversion);
        setupDone = TRUE;
		xf86AddDriver(&VIA, module, 
#if XSERVER_LIBPCIACCESS
		HaveDriverFuncs
#else
		0
#endif
		);

        /*Tell the loader that the driver module will refer to 
        the following symbols from other modules*/
        LoaderRefSymLists(vgaHWSymbols,

                          fbSymbols,

                          ramdacSymbols,
#ifdef VIA_HAVE_EXA
                          exaSymbols,
#endif
                          xaaSymbols,
                          shadowSymbols,
                          vbeSymbols,
                          i2cSymbols,
                          ddcSymbols,
#ifdef XF86DRI
                          drmSymbols,
                          driSymbols,
#endif
                          NULL);

        return (pointer) 1;
    }
    else {
        if (errmaj)
            *errmaj = LDR_ONCEONLY;

        return NULL;
    }
} /* VIASetup */

#endif /* XFree86LOADER */


static int
WaitIdle_H2Chips(VIAPtr pVia)
{
    int loop = 0;

    mem_barrier();

    while (!(VIAGETREG(VIA_REG_STATUS) & VIA_VR_QUEUE_EMPTY) && (loop++ < MAXLOOP))
        ;

    while ((VIAGETREG(VIA_REG_STATUS) &
          (VIA_CMD_RGTR_BUSY | VIA_2D_ENG_BUSY | VIA_3D_ENG_BUSY)) &&
          (loop++ < MAXLOOP));

    return loop >= MAXLOOP;
}

static int
WaitIdle_H5Chips(VIAPtr pVia)
{
    int loop = 0;

    mem_barrier();

    while ((VIAGETREG(VIA_REG_STATUS) &
          (VIA_CMD_RGTR_BUSY_H5| VIA_2D_ENG_BUSY_H5|VIA_3D_ENG_BUSY_H5)) &&
          (loop++ < MAXLOOP));

    return loop >= MAXLOOP;
}

static int
WaitIdle_H6Chips(VIAPtr pVia)
{
    int loop = 0;

    mem_barrier();

    while ((VIAGETREG(VIA_REG_STATUS) & 
           (VIA_CMD_RGTR_BUSY_M1 | VIA_2D_ENG_BUSY_M1 | VIA_3D_ENG_BUSY_M1)) &&
           (loop++ < MAXLOOP));

    return loop >= MAXLOOP;
}

static Bool VIAGetRec(ScrnInfoPtr pScrn)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAGetRec\n"));
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    Bool    isVIADriver = TRUE;
    
    if (pScrn->driverPrivate)
        return TRUE;

    /* allocate VIARec */
    pScrn->driverPrivate = xnfcalloc(sizeof(VIARec), 1);
    
    ((VIARec *)(pScrn->driverPrivate))->pBIOSInfo =
        xnfcalloc(sizeof(VIABIOSInfoRec), 1);
        
    ((VIARec *)(pScrn->driverPrivate))->pChipInfo =
        xnfcalloc(sizeof(VIAChipInfoRec), 1);

    /* initial value in VIARec */
    ((VIARec *)(pScrn->driverPrivate))->SavedReg.mode = 0xFF;
    ((VIARec *)(pScrn->driverPrivate))->pBIOSInfo->FirstInit = TRUE;
    ((VIARec *)(pScrn->driverPrivate))->HwCursorImage = NULL;
    ((VIARec *)(pScrn->driverPrivate))->HwIconImage = NULL;
    ((VIARec *)(pScrn->driverPrivate))->HIScalingPrimImage = NULL;
    ((VIARec *)(pScrn->driverPrivate))->HIScalingSecImage = NULL;

    if (!memcmp(pScrn0->name, "VIA", 3)){
        isVIADriver = TRUE;
    } else {
        isVIADriver = FALSE;
    }

    if (isVIADriver) {
        if (pScrn->scrnIndex == 0)
            ((VIARec *)(pScrn->driverPrivate))->pScreensPublicInfo = xnfcalloc(sizeof(VIAScreensPublicInfo), 1);
        else
            ((VIARec *)(pScrn->driverPrivate))->pScreensPublicInfo = ((VIARec *)(xf86Screens[0]->driverPrivate))->pScreensPublicInfo;                
    } else {
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Screen 0 is not VIA\n"));
            ((VIARec *)(pScrn->driverPrivate))->pScreensPublicInfo = xnfcalloc(sizeof(VIAScreensPublicInfo), 1);    
    }
    
    return TRUE;

} /* VIAGetRec */


static void VIAFreeRec(ScrnInfoPtr pScrn)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAFreeRec\n"));
    if (!pScrn->driverPrivate)
        return;

    if(pScrn->scrnIndex == 0){
        xfree(((VIARec *)(pScrn->driverPrivate))->pScreensPublicInfo);
        ((VIARec *)(pScrn->driverPrivate))->pScreensPublicInfo = NULL;
    }else
        ((VIARec *)(pScrn->driverPrivate))->pScreensPublicInfo = NULL;

    xfree(((VIARec *)(pScrn->driverPrivate))->pBIOSInfo);    
    xfree(((VIARec *)(pScrn->driverPrivate))->pChipInfo);    

    xfree(pScrn->driverPrivate);
    pScrn->driverPrivate = NULL;

} /* VIAFreeRec */


static const OptionInfoRec * VIAAvailableOptions(int chipid, int busid)
{

    return VIAOptions;

} /* VIAAvailableOptions */


static void VIAIdentify(int flags)
{
    xf86PrintChipsets(DRIVER_NAME,
                      "driver for VIA chipsets",
                      VIAChipsets);
} /* VIAIdentify */

#if XSERVER_LIBPCIACCESS
struct pci_device * VIAGetHostBridge(uint32_t Bus, uint32_t Device, uint32_t Function)
{
    struct pci_device_iterator	*SlotIterator = NULL;
    struct pci_device		*MatchBridge = NULL;
	
	struct pci_slot_match slot_match = {
		.domain = 0,
		.bus = Bus,
		.dev = Device,
		.func = Function,
		.match_data = 0
	};

    SlotIterator = pci_slot_match_iterator_create (&slot_match);
    MatchBridge = pci_device_next (SlotIterator);
    pci_iterator_destroy (SlotIterator);
    return MatchBridge;
}

static Bool VIAPciProbe(DriverPtr drv, int entity_num, struct pci_device *dev, intptr_t data)
{
    ScrnInfoPtr	    pScrn = NULL;
    EntityInfoPtr   pEnt;
    DevUnion	    *pPriv;
    static int      instance = 0;
    
    pScrn = xf86ConfigPciEntity(pScrn, 0, entity_num, VIAPciChipsets, 
                NULL, NULL, NULL, NULL, NULL);
    
    if (!pScrn) return FALSE;
    
    pScrn->driverVersion    = VIA_VERSION;
    pScrn->driverName       = DRIVER_NAME;
    pScrn->name             = "VIA";
    pScrn->Probe            = NULL;

    pScrn->PreInit          = VIAPreInit;
    pScrn->ScreenInit       = VIAScreenInit;
    pScrn->SwitchMode       = VIASwitchMode;
    pScrn->AdjustFrame      = VIAAdjustFrame;
    pScrn->EnterVT          = VIAEnterVT;
    pScrn->LeaveVT          = VIALeaveVT;
    pScrn->FreeScreen       = VIAFreeScreen;
    pScrn->ValidMode        = VIAValidMode;
    pScrn->PMEvent          = VIAPMEvent;

    pEnt = xf86GetEntityInfo(entity_num);

    xf86SetEntitySharable(entity_num);
    xf86SetEntityInstanceForScreen(pScrn,
                    pScrn->entityList[0], instance);

    if(gVIAEntityIndex < 0)
    {
        gVIAEntityIndex = xf86AllocateEntityPrivateIndex();
        pPriv = xf86GetEntityPrivate(pScrn->entityList[0],
                gVIAEntityIndex);

        if (!pPriv->ptr)
        {
            VIAEntPtr pVIAEnt;
            pPriv->ptr = xnfcalloc(sizeof(VIAEntRec), 1);
            pVIAEnt = pPriv->ptr;
            pVIAEnt->IsDRIEnabled = FALSE;
            pVIAEnt->BypassSecondary = FALSE;
            pVIAEnt->HasSecondary = FALSE;
            pVIAEnt->IsSecondaryRestored = FALSE;
        }
    }
    instance++;

    return TRUE;
}
#else /* XSERVER_LIBPCIACCESS */

static Bool VIAProbe(DriverPtr drv, int flags)
{
    GDevPtr *devSections;
    int     *usedChips;
    int     numDevSections;
    int     numUsed;
    Bool    foundScreen = FALSE;
    int     i;

    /* sanity checks */
    if ((numDevSections = xf86MatchDevice(DRIVER_NAME, &devSections)) <= 0)
        return FALSE;

    if (xf86GetPciVideoInfo() == NULL)
        return FALSE;

    numUsed = xf86MatchPciInstances(DRIVER_NAME,
                                    PCI_VIA_VENDOR_ID,
                                    VIAChipsets,
                                    VIAPciChipsets,
                                    devSections,
                                    numDevSections,
                                    drv,
                                    &usedChips);
    xfree(devSections);

    if (numUsed <= 0)
        return FALSE;

    if (flags & PROBE_DETECT) {
        foundScreen = TRUE;
    }
    else {
        for (i = 0; i < numUsed; i++) {
            ScrnInfoPtr pScrn = NULL;
            static int instance = 0;
            DevUnion* pPriv;

            if ((pScrn = xf86ConfigPciEntity(pScrn, 0, usedChips[i],
                 VIAPciChipsets, 0, 0, 0, 0, 0)))
            {
                pScrn->driverVersion = VIA_VERSION;
                pScrn->driverName = DRIVER_NAME;
                pScrn->name = "VIA";
                pScrn->Probe = VIAProbe;
                pScrn->PreInit = VIAPreInit;
                pScrn->ScreenInit = VIAScreenInit;
                pScrn->SwitchMode = VIASwitchMode;
                pScrn->AdjustFrame = VIAAdjustFrame;
                pScrn->EnterVT = VIAEnterVT;
                pScrn->LeaveVT = VIALeaveVT;
                pScrn->FreeScreen = VIAFreeScreen;
                pScrn->ValidMode = VIAValidMode;
                pScrn->PMEvent=VIAPMEvent;
                foundScreen = TRUE;

                xf86SetEntitySharable(usedChips[i]);
                xf86SetEntityInstanceForScreen(pScrn,
                    pScrn->entityList[0], instance);

                if(gVIAEntityIndex < 0)
                {
                    gVIAEntityIndex = xf86AllocateEntityPrivateIndex();
                    pPriv = xf86GetEntityPrivate(pScrn->entityList[0],
                            gVIAEntityIndex);

                    if (!pPriv->ptr)
                    {
                        VIAEntPtr pVIAEnt;
                        pPriv->ptr = xnfcalloc(sizeof(VIAEntRec), 1);
                        pVIAEnt = pPriv->ptr;
                        pVIAEnt->IsDRIEnabled = FALSE;
                        pVIAEnt->BypassSecondary = FALSE;
                        pVIAEnt->HasSecondary = FALSE;
                        pVIAEnt->IsSecondaryRestored = FALSE;
                    }
                }
                instance++;
	        }
        }
    }

    xfree(usedChips);

    return foundScreen;

} /* VIAProbe */
#endif /* XSERVER_LIBPCIACCESS */

static int LookupChipID(PciChipsets* pset, int ChipID)
{
    /* Is there a function to do this for me? */
    while (pset->numChipset >= 0)
    {
        if (pset->PCIid == ChipID)
            return pset->numChipset;

        pset++;
    }

    return -1;

} /* LookupChipID */


static unsigned int
VIAddc1Read(ScrnInfoPtr pScrn)
{
    register vgaHWPtr hwp = VGAHWPTR(pScrn);
    VIAPtr pVia = VIAPTR(pScrn);
    register CARD8 tmp;

    while (hwp->readST01(hwp)&0x8) {};
    while (!(hwp->readST01(hwp)&0x8)) {};

    VGAOUT8(0x3c4, 0x26);
    tmp = VGAIN8(0x3c5);
    return ((unsigned int) ((tmp & 0x08) >> 3));
}



void
VIAvgaHWddc1SetSpeed(ScrnInfoPtr pScrn, xf86ddcSpeed speed)
{
    vgaHWPtr hwp = VGAHWPTR(pScrn);
    unsigned char tmp;
    struct _vgaDdcSave* save;
    switch (speed) {
    case DDC_FAST:
        
        if (hwp->ddc != NULL) break;
        hwp->ddc = xnfcalloc(sizeof(struct _vgaDdcSave),1);
    save = (struct _vgaDdcSave *)hwp->ddc;
      /* Lightpen register disable - allow access to cr10 & 11; just in case */
    save->cr03 = hwp->readCrtc(hwp, 0x03); 
    hwp->writeCrtc(hwp,0x03,(save->cr03 |0x80));
    save->cr12 = hwp->readCrtc(hwp, 0x12); 
    hwp->writeCrtc(hwp,0x12,DISPLAY_END);
    save->cr15 = hwp->readCrtc(hwp, 0x15); 
    hwp->writeCrtc(hwp,0x15,BLANK_START);
    save->cr10 = hwp->readCrtc(hwp, 0x10); 
    hwp->writeCrtc(hwp,0x10,SYNC_START);
    save->cr11 = hwp->readCrtc(hwp, 0x11); 
    /* unprotect group 1 registers; just in case ...*/
    hwp->writeCrtc(hwp,0x11,((save->cr11 & 0x70) | SYNC_END));
    save->cr16 = hwp->readCrtc(hwp, 0x16); 
    hwp->writeCrtc(hwp,0x16,BLANK_END);
    save->cr06 = hwp->readCrtc(hwp, 0x06); 
    hwp->writeCrtc(hwp,0x06,V_TOTAL);
    /* all values have less than 8 bit - mask out 9th and 10th bits */
    save->cr09 = hwp->readCrtc(hwp, 0x09); 
    hwp->writeCrtc(hwp,0x09,(save->cr09 &0xDF));
    save->cr07 = hwp->readCrtc(hwp, 0x07); 
    hwp->writeCrtc(hwp,0x07,(save->cr07 &0x10));
    /* vsync polarity negativ & ensure a 25MHz clock */
    save->msr = hwp->readMiscOut(hwp); 
    hwp->writeMiscOut(hwp,((save->msr & 0xF3) | 0x80));
    break;
    case DDC_SLOW:
        if (hwp->ddc == NULL) break;
    save = (struct _vgaDdcSave *)hwp->ddc;
    hwp->writeMiscOut(hwp,save->msr);
    hwp->writeCrtc(hwp,0x07,save->cr07);
    tmp = hwp->readCrtc(hwp, 0x09);
    hwp->writeCrtc(hwp,0x09,((save->cr09 & 0x20) | (tmp & 0xDF)));
    hwp->writeCrtc(hwp,0x06,save->cr06);
    hwp->writeCrtc(hwp,0x16,save->cr16);
    hwp->writeCrtc(hwp,0x11,save->cr11);
    hwp->writeCrtc(hwp,0x10,save->cr10);
    hwp->writeCrtc(hwp,0x15,save->cr15);
    hwp->writeCrtc(hwp,0x12,save->cr12);
    hwp->writeCrtc(hwp,0x03,save->cr03);
    xfree(save);
    hwp->ddc = NULL;
    break;
    default:
    break;
    }
}

#else 
    #define VIAvgaHWddc1SetSpeed vgaHWddc1SetSpeed
#endif

/* Get EDID by ourself */
extern int g_DeviceI2CPort;
extern Bool i2cReadByte(VIABIOSInfoPtr pBIOSInfo, CARD8 slave_addr, CARD8 index, CARD8 *pData);

static Bool
VIAGetCRTEDID(ScrnInfoPtr pScrn, xf86MonPtr monPtr)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;    
    CARD8 edid[128];
    int i;

    g_DeviceI2CPort = PORT_INDEX_I2C_26;
        
    for (i = 0; i < 128; i++)
        i2cReadByte(pBIOSInfo, 0xA0, i, edid+i);

    if ((edid[0]==0x00) && (edid[1]==0xFF) && (edid[2]==0xFF)) {
        monPtr = xf86InterpretEDID(pScrn->scrnIndex,edid);
        xf86SetDDCproperties(pScrn,monPtr);
        return TRUE;
    }
    return FALSE;
}


static Bool
VIAddc1(int scrnIndex)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr pVia = VIAPTR(pScrn);
    xf86MonPtr pMon;
    CARD8 tmp;
    Bool success = FALSE;

    /* initialize chipset */
    VGAOUT8(0x3c4, 0x26);
    tmp = VGAIN8(0x3c5);
    VGAOUT8(0x3c4, 0x26);
    VGAOUT8(0x3c5, (tmp | 0x11));

    if ((pMon = xf86PrintEDID(
        xf86DoEDID_DDC1(scrnIndex,VIAvgaHWddc1SetSpeed,VIAddc1Read))) != NULL)
        success = TRUE;
    xf86SetDDCproperties(pScrn,pMon);

    /* undo initialization */
    VGAOUT8(0x3c4, 0x26);
    VGAOUT8(0x3c5, tmp);
    return success;
}

static Bool
VIAddc2(int scrnIndex)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr pVia = VIAPTR(pScrn);
    xf86MonPtr pMon;
    CARD8 tmp;
    Bool success = FALSE;

    VGAOUT8(0x3c4, 0x26);
    tmp = VGAIN8(0x3c5);
    pMon = xf86DoEDID_DDC2(pScrn->scrnIndex, pVia->I2C_Port1);
    if (pMon)
        success = TRUE;
    pVia->DDC1 =  pMon;
    xf86PrintEDID(pMon);
    xf86SetDDCproperties(pScrn, pMon);
    VGAOUT8(0x3c4, 0x26);
    VGAOUT8(0x3c5, tmp);

    return success;
}

static void
VIAProbeDDC(ScrnInfoPtr pScrn, int index)
{
    vbeInfoPtr pVbe;

    if (xf86LoadSubModule(pScrn, "vbe")) {
        pVbe = VBEExtendedInit(NULL,index,0);

        ConfiguredMonitor = vbeDoEDID(pVbe, NULL);
    }
}

void 
VIACheckIfUseDuoView(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIACheckIfUseDuoView\n"));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "ActiveDev: %d\n", pBIOSInfo->ActiveDevice));

    pBIOSInfo->DuoView = TRUE;
    
    /* Check device number, we only support duo view when enable 2 device. */
    /* LCD + LCD2 case only work on IGA2, so disable "Douview" flag */
    if ((pBIOSInfo->ActiveDevice == VIA_DEVICE_CRT1) ||
        (pBIOSInfo->ActiveDevice == VIA_DEVICE_LCD)  ||
        (pBIOSInfo->ActiveDevice == (VIA_DEVICE_LCD+VIA_DEVICE_LCD2)) ||
        (pBIOSInfo->ActiveDevice == VIA_DEVICE_DFP)) {
        
        pBIOSInfo->DuoView = FALSE;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, 
              "Not support DuoView because only enable one device.\n"));
    }
                    
    if (pVia->HasSecondary) {
        pBIOSInfo->DuoView = FALSE;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
              "Not support DuoView because SAMM is on.\n"));
    }
}

void 
VIACheckCursorTypeToUse(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;

    if ((pVia->ForceSWCursor) ||
        (pBIOSInfo->MergedFB) ||
        (pVia->IsMAMMEnable)) {
        /* Use SW Cursor */
        pVia->pScreensPublicInfo->UseHwCursor = FALSE;
    } else {
        if (pBIOSInfo->DuoView) {
            switch (pBIOSInfo->Chipset) {
                case VIA_CX700:
                case VIA_P4M890:
                case VIA_P4M900:
                case VIA_VX800:
                case VIA_VX855:
                    pVia->pScreensPublicInfo->UseHwCursor = TRUE;
                    break;
                default:
                    pVia->pScreensPublicInfo->UseHwCursor = FALSE;
            }
        } else {
            /* Use HW Cursor */
            pVia->pScreensPublicInfo->UseHwCursor = TRUE;
        }
    }

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Using %s cursor\n", pVia->pScreensPublicInfo->UseHwCursor ? "HW" : "SW"));
}


/* For Hotkey Timer Use. */
CARD32 
VIACheckHotkeyStatus(ScrnInfoPtr pScrn)
{            
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;           
    CARD16  deviceCount = 0;        
    CARD16  i;
    CARD16  deviceSeq[4];
    
    /* Check the change of register CR3C[0]. */
    if (read_reg(VIACR, CR3C) & BIT0) {
        /* Clear */                
        write_reg_mask(CR3C, VIACR, 0x00, BIT0);                         

        /* To count how many prefered and valid devices can be actived.*/
        for (i = 0; i < 4; i++) {
            if (pVia->deviceSequence[i]) {
                if (pVia->deviceSequence[i] == VIA_DEVICE_CRT1) {
                    if (pVia->IsForceHotkeySwitch) {
                        deviceSeq[deviceCount] = pVia->deviceSequence[i];
                        deviceCount++;                                        
                    } else if (VIASenseCRT(pScrn)) {
                        deviceSeq[deviceCount] = pVia->deviceSequence[i];
                        deviceCount++;                                        
                    }
                }                
                
                if ((pVia->deviceSequence[i] == VIA_DEVICE_DFP) &&
                    (VIASenseDVI(pBIOSInfo))) {
                    
                    deviceSeq[deviceCount] = pVia->deviceSequence[i];
                    deviceCount++;                      
                }
                
                if (pVia->deviceSequence[i] == VIA_DEVICE_LCD) {
                    deviceSeq[deviceCount] = pVia->deviceSequence[i];
                    deviceCount++;                      
                }
            }
        }                
        
        /* Only one device was conneted. */                                
        if (deviceCount == 1) {
            DeviceCounter = 0;
        /* 2 devices were input. ex: CRT, LCD */    
        } else if (deviceCount == 2) {
            if (pBIOSInfo->ActiveDevice == deviceSeq[0]) {
                DeviceCounter = 0;
            } else if (pBIOSInfo->ActiveDevice == deviceSeq[1]) {
                DeviceCounter = 1;
            }
            else if (pBIOSInfo->ActiveDevice == (deviceSeq[0] | deviceSeq[1])) {
                DeviceCounter = 2;            
            } else {
                DeviceCounter = 0;
            }
        /* 3 devices were input. ex: CRT, LCD, DVI */    
        } else if (deviceCount == 3) {
            /* Configure current state */        
            if (pBIOSInfo->ActiveDevice == deviceSeq[0]) {
                DeviceCounter = 0;
            } else if (pBIOSInfo->ActiveDevice == deviceSeq[1]) {
                DeviceCounter = 1;
            } else if (pBIOSInfo->ActiveDevice == deviceSeq[2]) {
                DeviceCounter = 2;
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[0] | deviceSeq[1])) {
                DeviceCounter = 3;            
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[0] | deviceSeq[2])) {
                DeviceCounter = 4;            
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[1] | deviceSeq[2])) {
                DeviceCounter = 5;
            } else {
                DeviceCounter = 0;
            }
        /* 4 devices were input. ex: CRT, LCD, DVI */
        } else if (deviceCount == 4) {
            /* Configure current state */        
            if (pBIOSInfo->ActiveDevice == deviceSeq[0]) {
                DeviceCounter = 0;
            } else if (pBIOSInfo->ActiveDevice == deviceSeq[1]) {
                DeviceCounter = 1;
            } else if (pBIOSInfo->ActiveDevice == deviceSeq[2]) {
                DeviceCounter = 2;
            } else if (pBIOSInfo->ActiveDevice == deviceSeq[3]) {
                DeviceCounter = 3;
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[0] | deviceSeq[1])) {
                DeviceCounter = 4;            
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[0] | deviceSeq[2])) {
                DeviceCounter = 5;            
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[0] | deviceSeq[3])) {
                DeviceCounter = 6;
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[1] | deviceSeq[2])) {
                DeviceCounter = 7;
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[1] | deviceSeq[3])) {
                DeviceCounter = 8;
            } else if (pBIOSInfo->ActiveDevice == (deviceSeq[2] | deviceSeq[3])) {
                DeviceCounter = 9;
            } else {
                DeviceCounter = 0;
            }
        }               
                                                  
        
        /* Loop to switch device */
        DeviceCounter++;        

        if (deviceCount == 1) {
            DeviceCounter = 0;   
            pBIOSInfo->ActiveDevice = deviceSeq[0];
        } else if (deviceCount == 2) {
            DeviceCounter = DeviceCounter%3;   
            switch(DeviceCounter) {
                case 0:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0];
                    break;                    
                case 1:                
                    pBIOSInfo->ActiveDevice = deviceSeq[1];
                    break;                    
                case 2:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0] | deviceSeq[1];
                    break;                       
            } 
        } else if (deviceCount == 3) {
            DeviceCounter = DeviceCounter%6; 
            switch(DeviceCounter)
            {
                case 0:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0];
                    break;
                case 1:                
                    pBIOSInfo->ActiveDevice = deviceSeq[1];
                    break;
                case 2:                
                    pBIOSInfo->ActiveDevice = deviceSeq[2];
                    break;    
                case 3:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0] | deviceSeq[1];
                    break;    
                case 4:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0] | deviceSeq[2];
                    break;    
                case 5:                
                    pBIOSInfo->ActiveDevice = deviceSeq[1] | deviceSeq[2];
                    break;                
            } 
        } else if (deviceCount == 4) {
            DeviceCounter = DeviceCounter%10;    
            switch(DeviceCounter) {
                case 0:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0];
                    break;                    
                case 1:                
                    pBIOSInfo->ActiveDevice = deviceSeq[1];
                    break;                    
                case 2:                
                    pBIOSInfo->ActiveDevice = deviceSeq[2];
                    break;   
                case 3:                
                    pBIOSInfo->ActiveDevice = deviceSeq[3];
                    break;
                case 4:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0] | deviceSeq[1];
                    break;    
                case 5:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0] | deviceSeq[2];
                    break;    
                case 6:                
                    pBIOSInfo->ActiveDevice = deviceSeq[0] | deviceSeq[3];
                    break;   
                case 7:                
                    pBIOSInfo->ActiveDevice = deviceSeq[1] | deviceSeq[2];
                    break;  
                case 8:                
                    pBIOSInfo->ActiveDevice = deviceSeq[1] | deviceSeq[3];
                    break;  
                case 9:                
                    pBIOSInfo->ActiveDevice = deviceSeq[2] | deviceSeq[3];
                    break;  
            } 
        } else {
            pBIOSInfo->ActiveDevice = VIA_DEVICE_LCD;
        }
                
        /* If there is no any device connected. Use the first device as default */
        if (!pBIOSInfo->ActiveDevice) {
            pBIOSInfo->ActiveDevice = deviceSeq[0];
        }
        VIASwitchMode(pScrn->scrnIndex, pScrn->currentMode, 0);
               
    }        

    return 1000;
}


CARD32 
VIASyncTimer(OsTimerPtr timer, CARD32 now, pointer arg)
{        
    ScrnInfoPtr pScrn = (ScrnInfoPtr) arg;
    VIAPtr pVia = VIAPTR(pScrn);

    if(pVia->pBIOSInfo->IsStableStatus) {        
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "need to do VIADISP3DScalingImageProcessing\n"));
        VIADISP3DScalingImageProcessing(pVia);
    }

    if (pVia->IsHotkeyTimerEnabled) {
        VIACheckHotkeyStatus(pScrn);
    }

    return 30;
}

static void 
VIAGetOptions_MergedFB(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    char        *strptr;
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
   
    /* collect MergedFB options */
    pBIOSInfo->MergedFB = FALSE;
    pBIOSInfo->UseVIAXinerama = TRUE;
    pBIOSInfo->Scrn2Position = viaRightOf;
    
    if (xf86ReturnOptValBool(VIAOptions, OPTION_MERGEDFB, FALSE)) {  
        pBIOSInfo->MergedFB = TRUE;
        pBIOSInfo->DuoView = TRUE;
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "MergedFB mode forced on.\n");
    } else {
        pBIOSInfo->MergedFB = FALSE;
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "MergedFB mode forced off.\n");
    }
       
    /* Do some MergedFB mode initialisation */
    if(pBIOSInfo->MergedFB) {
        strptr = (char *)xf86GetOptValString(VIAOptions, OPTION_SCRN2POS);
        if(strptr) {
            if((!strcmp(strptr,"LeftOf")) || (!strcmp(strptr,"leftof"))) {
                pBIOSInfo->Scrn2Position = viaLeftOf;
            } else if((!strcmp(strptr,"RightOf")) || (!strcmp(strptr,"rightof"))) {
                pBIOSInfo->Scrn2Position = viaRightOf;
            } else if((!strcmp(strptr,"Above")) || (!strcmp(strptr,"above"))) {
                pBIOSInfo->Scrn2Position = viaAbove;
            } else if((!strcmp(strptr,"Below")) || (!strcmp(strptr,"below"))) {
                pBIOSInfo->Scrn2Position = viaBelow;
            } else {
	            xf86DrvMsg(pScrn->scrnIndex, X_WARNING,
	                "\"%s\" is not a valid parameter for Option \"Scrn2Position\"\n", strptr);
	    	    xf86DrvMsg(pScrn->scrnIndex, X_INFO,
	                "Valid parameters are \"RightOf\", \"LeftOf\", \"Above\", or\"Below\"\n");
            }
        }

        /*don't use pseudo xinerama,but virtual screen*/
        if (xf86ReturnOptValBool(VIAOptions, OPTION_NOVIAXINERAMA, FALSE))
            pBIOSInfo->UseVIAXinerama = FALSE;
    }
}


static void 
VIAGetOptions_Cursor(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);

    /*
     * The default if neither is specified is HW.
     */
    pVia->ForceSWCursor = FALSE;
    
    if (xf86ReturnOptValBool(VIAOptions, OPTION_SWCURSOR, FALSE)) {
        pVia->ForceSWCursor = TRUE;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option SWCursor enabled.\n");
    }
}


static void 
VIAGetOptions_ActiveDevice(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    char    *pStr = NULL;
    
    pBIOSInfo->TwoLCD = FALSE;

    /*=* For Advantech Project, support two LCD MHS *=*/
    if (xf86ReturnOptValBool(VIAOptions, OPTION_TWO_LCD, FALSE)) {
        pBIOSInfo->TwoLCD = TRUE;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: Two LCD support!!\n");
    }    
    
    if(pBIOSInfo->TwoLCD) {
        /*=* For Advantech Project, support two LCD MHS.
             Always set ActiveDevice to CRT1+LCD. *=*/
        pBIOSInfo->ActiveDevice = VIA_DEVICE_LCD2 | VIA_DEVICE_LCD;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Active Device is LCD1 and LCD2.\n");
    } else {
        /* ActiveDevice Option for device selection */
        pBIOSInfo->ActiveDevice = 0x00;
        
        if ((pStr = xf86GetOptValString(VIAOptions, OPTION_ACTIVEDEVICE))) {
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Active Device is %s.\n", pStr);
            
            if(!xf86NameCmp(pStr, "CRT,LCD")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1 | VIA_DEVICE_LCD;
                pBIOSInfo->PrimaryDevice = VIA_DEVICE_CRT1;
            } else if(!xf86NameCmp(pStr, "LCD,CRT")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1 | VIA_DEVICE_LCD;
                pBIOSInfo->PrimaryDevice = VIA_DEVICE_LCD;
            } else if(!xf86NameCmp(pStr, "LCD,LCD2")) {
                if (pVia->Chipset == VIA_CX700 || pVia->Chipset == VIA_VX800 ||
                    pVia->Chipset == VIA_VX855 ) {
                    pBIOSInfo->ActiveDevice = VIA_DEVICE_LCD | VIA_DEVICE_LCD2;
                    pBIOSInfo->PrimaryDevice = VIA_DEVICE_LCD;
                } else {
                    pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1 | VIA_DEVICE_LCD;
                    pBIOSInfo->PrimaryDevice = VIA_DEVICE_CRT1;
                    pBIOSInfo->TwoLCD = TRUE;
                }
            } else if(!xf86NameCmp(pStr, "LCD2,LCD")) {
                if (pVia->Chipset == VIA_CX700 || pVia->Chipset == VIA_VX800 ||
                    pVia->Chipset == VIA_VX855) {
                    pBIOSInfo->ActiveDevice = VIA_DEVICE_LCD | VIA_DEVICE_LCD2;
                    pBIOSInfo->PrimaryDevice = VIA_DEVICE_LCD2;
                } else {
                    pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1 | VIA_DEVICE_LCD;
                    pBIOSInfo->PrimaryDevice = VIA_DEVICE_LCD;
                    pBIOSInfo->TwoLCD = TRUE;
                    pBIOSInfo->UseIGA2 = TRUE;
                }
            } else if(!xf86NameCmp(pStr, "CRT,DFP") ||!xf86NameCmp(pStr, "CRT,DVI")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1 | VIA_DEVICE_DFP;
                pBIOSInfo->PrimaryDevice = VIA_DEVICE_CRT1;
            } else if(!xf86NameCmp(pStr, "DFP,CRT") || !xf86NameCmp(pStr, "DVI,CRT")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1 | VIA_DEVICE_DFP;
                pBIOSInfo->PrimaryDevice = VIA_DEVICE_DFP;
            } else if(!xf86NameCmp(pStr, "DFP,LCD") || !xf86NameCmp(pStr, "DVI,LCD")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_DFP | VIA_DEVICE_LCD;
                pBIOSInfo->PrimaryDevice = VIA_DEVICE_DFP;
            } else if(!xf86NameCmp(pStr, "LCD,DFP") || !xf86NameCmp(pStr, "LCD,DVI")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_DFP | VIA_DEVICE_LCD;
                pBIOSInfo->PrimaryDevice = VIA_DEVICE_LCD;
            } else if(!xf86NameCmp(pStr, "CRT") || !xf86NameCmp(pStr, "CRT ONLY")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_CRT1;
            } else if(!xf86NameCmp(pStr, "LCD") || !xf86NameCmp(pStr, "LCD ONLY")) { 
                pBIOSInfo->ActiveDevice = VIA_DEVICE_LCD;
            } else if(!xf86NameCmp(pStr, "DFP") || !xf86NameCmp(pStr, "DFP ONLY") ||
                      !xf86NameCmp(pStr, "DVI") || !xf86NameCmp(pStr, "DVI ONLY")) {
                pBIOSInfo->ActiveDevice = VIA_DEVICE_DFP;
            } else {
                xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
                    "Option \"%s\" can't recognize!, Active Device by default.\n", pStr);
            }
        }
    }

    if(pBIOSInfo->TwoLCD) {
        /*=* For Advantech Project, support two LCD MHS.
             Always set Refresh Rate to 60. *=*/
        pBIOSInfo->OptRefresh = 60;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Refresh is 60.\n");
    } else {
        pBIOSInfo->OptRefresh = 0;
        if (xf86GetOptValInteger(VIAOptions, OPTION_REFRESH,
                                 &(pBIOSInfo->OptRefresh))) {
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Refresh is %d\n",
                       pBIOSInfo->OptRefresh);
        }
    }

}


int 
TranslateDIPortNameToID(char *pStr)
{
    if (!xf86NameCmp(pStr, "DFP_HIGH"))
        return VIA_DI_DFPHIGH;
    else if (!xf86NameCmp(pStr, "DFP_LOW"))
        return VIA_DI_DFPLOW;
    else if (!xf86NameCmp(pStr, "DFP_HIGHLOW"))
        return VIA_DI_DFPHIGHLOW;
    else if (!xf86NameCmp(pStr, "DVP0"))
        return VIA_DI_DVP0;
    else if (!xf86NameCmp(pStr, "DVP1"))
        return VIA_DI_DVP1;
    else if (!xf86NameCmp(pStr, "LVDS0"))
        return VIA_DI_LVDS0;
    else if (!xf86NameCmp(pStr, "LVDS1"))
        return VIA_DI_LVDS1;
    else if (!xf86NameCmp(pStr, "LVDS0LVDS1"))
        return VIA_DI_LVDS0LVDS1;    
    else if (!xf86NameCmp(pStr, "TMDS"))
        return VIA_DI_TMDS;        
    else if (!xf86NameCmp(pStr, "TTL"))
        return VIA_DI_TTL;        
    else if (!xf86NameCmp(pStr, "LVDS1DVP1"))
        return VIA_DI_LVDS1DVP1;
    else        
        return VIA_DI_NONE; /* Invalid port. */
}


static void
viaSetDefaultLCDPanelChannelInfo( VIABIOSInfoPtr pBIOSInfo)
{
    switch(pBIOSInfo->LVDSSettingInfo.PanelSizeID){
    case VIA_1280X1024:
    case VIA_1400X1050:
    case VIA_1440X900:
    case VIA_1600X1200:
        pBIOSInfo->LVDSSettingInfo.IsDualEdge=TRUE;
		pBIOSInfo->LVDSSettingInfo2.IsDualEdge=TRUE;
        break;
    default:
        pBIOSInfo->LVDSSettingInfo.IsDualEdge=FALSE;
		pBIOSInfo->LVDSSettingInfo2.IsDualEdge=FALSE;
        break;
    }
}


static void 
VIAGetOptions_LCDInfo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;    
    char    *pStr = NULL;
    
    /* Initialize LCD panel size: */
    pBIOSInfo->LVDSSettingInfo.PanelSizeID = VIA_INVALID;
    
    if (xf86ReturnOptValBool(VIAOptions, OPTION_FORCE_LCD, FALSE)) {
        pBIOSInfo->IsBiosSupportLCD = TRUE; 
        switch (pVia->Chipset) {
        case VIA_CX700:
        case VIA_VX800:
        case VIA_VX855:
            pBIOSInfo->LVDSSettingInfo.ChipID = VIA_INTEGRATED_LVDS;
            break;
        default:
            pBIOSInfo->LVDSSettingInfo.ChipID = VIA_Hardwired;
            break;
        }
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "(OPTION) Force enable LCD. \n");
    }    

    /* LCD MSB/LSB Option */
    if (xf86ReturnOptValBool(VIAOptions, OPTION_LCD_MSB_ENABLE, FALSE)) {
        pBIOSInfo->LVDSSettingInfo.MsbEnable=TRUE;
		pBIOSInfo->LVDSSettingInfo2.MsbEnable=TRUE;
    } else {
        pBIOSInfo->LVDSSettingInfo.MsbEnable=FALSE;
		pBIOSInfo->LVDSSettingInfo2.MsbEnable=FALSE;
    }

    /* Set LCD Panel Info. */
    if (pStr = xf86GetOptValString(VIAOptions, OPTION_LCD_PANEL_SIZE)) {
		char * b = strdup(pStr);
		pStr = strtok(b, "x");
        CARD32 panelWidth = (CARD32)atoi(pStr);
		pStr = strtok(NULL, "x");
		CARD32 panelHeight = (CARD32)atoi(pStr);
		/*Check if the panel size is valid*/
		if (VIAIsPanelSizeValid(panelWidth, panelHeight)) {
			pBIOSInfo->LVDSSettingInfo.PanelSizeID = 
				VIA_MAKE_ID(panelWidth, panelHeight);

            viaSetDefaultLCDPanelChannelInfo(pBIOSInfo);

			xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "LCD Panel Size is %lux%lu.\n", 
					   panelWidth, panelHeight);
		} else {
			xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "LCD Panel size %lux%lu is invalid!\n", 
        		panelWidth, panelHeight);	
		}
    }
    
    /* LCD Dithering Option */
    if (xf86ReturnOptValBool(VIAOptions, OPTION_LCD_NO_DITHERING, FALSE)) {
        pBIOSInfo->LVDSSettingInfo.IsDithering=FALSE;
		pBIOSInfo->LVDSSettingInfo2.IsDithering=FALSE;
    } else {
        pBIOSInfo->LVDSSettingInfo.IsDithering=TRUE;
		pBIOSInfo->LVDSSettingInfo2.IsDithering=TRUE;
    }

    /* LCD DualChannel Option */
    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_LCD_DUAL_CHANNEL))) {
        if ((*pStr == '\0') ||
            !xf86NameCmp(pStr, "TRUE") ||
            !xf86NameCmp(pStr, "True") ||
            !xf86NameCmp(pStr, "true")) {
            pBIOSInfo->LVDSSettingInfo.IsDualEdge = TRUE;
		    pBIOSInfo->LVDSSettingInfo2.IsDualEdge = TRUE;
        } else if (!xf86NameCmp(pStr, "FALSE") ||
                   !xf86NameCmp(pStr, "False") ||
                   !xf86NameCmp(pStr, "false")) {
            pBIOSInfo->LVDSSettingInfo.IsDualEdge = FALSE;
		    pBIOSInfo->LVDSSettingInfo2.IsDualEdge = FALSE;
        }    
    } 
    
    /* LCD Center/Expand Option */
    if (xf86ReturnOptValBool(VIAOptions, OPTION_CENTER, FALSE)) {
        pBIOSInfo->LVDSSettingInfo.Center = TRUE;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "(OPTION) LCD Center is On\n");
    } else {
        pBIOSInfo->LVDSSettingInfo.Center = FALSE;
    }

    /* Bus Width Option */
    pBIOSInfo->LVDSSettingInfo.BusWidth = VIA_DI_12BIT;

    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_LCD_BUS_WIDTH))) {
        if (!xf86NameCmp(pStr, "12BIT")) {
            pBIOSInfo->LVDSSettingInfo.BusWidth = VIA_DI_12BIT;
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "LCD Bus Width is 12BIT\n");
        } else if (!xf86NameCmp(pStr, "24BIT")) {
            pBIOSInfo->LVDSSettingInfo.BusWidth = VIA_DI_24BIT;
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "LCD Bus Width is 24BIT\n");
        }
    }

    /* Support LCD port selection */
    pBIOSInfo->LVDSSettingInfo.DIPort = VIA_DI_NONE;
    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_LCD_PORT))) {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "LCD port set to %s.\n", pStr));
        pBIOSInfo->LVDSSettingInfo.DIPort = TranslateDIPortNameToID(pStr); 

        if (pBIOSInfo->LVDSSettingInfo.DIPort == VIA_DI_TTL) {
            if (pBIOSInfo->Chipset == VIA_VX855)           
                pBIOSInfo->LVDSSettingInfo.DIPort = (VIA_DI_LVDS0LVDS1DVP1 | VIA_DI_TTL);
            else
                pBIOSInfo->LVDSSettingInfo.DIPort = (VIA_DI_LVDS0DVP1 | VIA_DI_TTL);
        }
        
        /* For dual LCD using DVP1+LVDS1 */
        if (pBIOSInfo->ActiveDevice == (VIA_DEVICE_LCD|VIA_DEVICE_LCD2)) {
            if (pBIOSInfo->LVDSSettingInfo.DIPort == VIA_DI_LVDS1DVP1) {
                pBIOSInfo->LVDSSettingInfo.DIPort = VIA_DI_DVP1;
                pBIOSInfo->LVDSSettingInfo2.DIPort = VIA_DI_LVDS1;                
            }
        }            
    }
}



static void 
VIAGetOptions_DVIInfo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    char    *pStr = NULL;

    /* Initialize DVI panel size: */
    pBIOSInfo->TMDSSettingInfo.DFPSize = M_INVALID;

    /* DVI on EPIA: */
    pBIOSInfo->EPIA_DVI = FALSE;
    if (xf86ReturnOptValBool(VIAOptions, OPTION_EPIA_DVI, FALSE)) {
         pBIOSInfo->EPIA_DVI = TRUE;
         xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: support DVI on EPIA!!\n");
    }

    /* Support DVI port selection */
    pBIOSInfo->IsDemoBoard = TRUE;
    pBIOSInfo->DFPDIPort = VIA_DI_NONE;
    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_DVI_PORT))) {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "DVI port set to %s.\n", pStr));
        
        if (!xf86NameCmp(pStr, "DFP_HIGH")) {
            pBIOSInfo->IsDemoBoard = FALSE;
            pBIOSInfo->DFPDIPort = VIA_DI_DFPHIGH;
        } else if (!xf86NameCmp(pStr, "DFP_LOW"))
            pBIOSInfo->DFPDIPort = VIA_DI_DFPLOW;
        else if (!xf86NameCmp(pStr, "DVP0"))
            pBIOSInfo->DFPDIPort = VIA_DI_DVP0;
        else if (!xf86NameCmp(pStr, "DVP1"))
            pBIOSInfo->DFPDIPort = VIA_DI_DVP1;
    }
}


static void 
VIAParseDPAValues(char *pStr, int *pReturnedBuffer, int BufSize)
{
    char *pToken;
    int i = 0;

    pToken = strtok(pStr, ",");
    
    if (pToken) {
        *pReturnedBuffer = atoi(pToken);
        pReturnedBuffer++;
        i++;
    }

    for (; i < BufSize; i++) {
        pToken = strtok('\0', ",");

        if (pToken) {
            *pReturnedBuffer = atoi(pToken);
            pReturnedBuffer++;
        }
    }
}

static void 
VIAGetOptions_DPASettingInfo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    char    *pStr = NULL;
    int     TmpBuffer[3];

    pBIOSInfo->UserDPASettingInfo.HasUserSetting_Gfx = FALSE;

    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_DPA_SETTING_DVP0))) {
        /* The data we get should be "v1,v2,v3", they are for */
        /* "Clock Polarity/Adjust,Data Driving,Clock Driving". */
        VIAParseDPAValues(pStr, TmpBuffer, 3);
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "DVP0 DPA=%d, DataDriving=%d, ClockDriving=%d.\n", 
              TmpBuffer[0], TmpBuffer[1], TmpBuffer[2]));
        
        pBIOSInfo->UserDPASettingInfo.HasUserSetting_Gfx = TRUE;
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP0 = TmpBuffer[0] & 0x0F;
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP0DataDri_S = (TmpBuffer[1] & BIT0) << 1;     /* for SR1B[1] */
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP0DataDri_S1 = (TmpBuffer[1] & BIT1) << 4;    /* for SR2A[5] */
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP0ClockDri_S = (TmpBuffer[2] & BIT0) << 2;    /* for SR1E[2] */
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP0ClockDri_S1 = (TmpBuffer[2] & BIT1) << 3;   /* for SR2A[4] */
    }

    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_DPA_SETTING_DVP1))) {
        /* The data we get should be "v1,v2,v3", they are for */
        /* "Clock Polarity/Adjust,Data Driving,Clock Driving". */
        VIAParseDPAValues(pStr, TmpBuffer, 3);
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "DVP1 DPA=%d, DataDriving=%d, ClockDriving=%d.\n", 
              TmpBuffer[0], TmpBuffer[1], TmpBuffer[2]));

        pBIOSInfo->UserDPASettingInfo.HasUserSetting_Gfx = TRUE;
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP1 = TmpBuffer[0] & 0x0F;
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DVP1Driving = 
            ((TmpBuffer[2] & 0x03) << 2) | (TmpBuffer[1] & 0x03);
    }

    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_DPA_SETTING_DFPHIGH))) {
        /* The data we get is for "Clock Polarity/Adjust" */
        VIAParseDPAValues(pStr, TmpBuffer, 1);

        pBIOSInfo->UserDPASettingInfo.HasUserSetting_Gfx = TRUE;
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DFPHigh = TmpBuffer[0] & 0x0F;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "DFPHIGH DPA = %d.\n", 
            pBIOSInfo->UserDPASettingInfo.GfxDPA.DFPHigh));
    }

    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_DPA_SETTING_DFPLOW))) {
        /* The data we get is for "Clock Polarity/Adjust" */
        VIAParseDPAValues(pStr, TmpBuffer, 1);

        pBIOSInfo->UserDPASettingInfo.HasUserSetting_Gfx = TRUE;
        pBIOSInfo->UserDPASettingInfo.GfxDPA.DFPLow = TmpBuffer[0] & 0x0F;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "DFPLOW DPA = %d.\n", pBIOSInfo->UserDPASettingInfo.GfxDPA.DFPLow));
    }

    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_DPA_SETTING_VT1636))) {
        /* The data we get should be "v1,v2", they are for "CLK_SEL_ST1, CLK_SEL_ST2" */
        VIAParseDPAValues(pStr, TmpBuffer, 2);

        pBIOSInfo->UserDPASettingInfo.HasUserSetting_VT1636 = TRUE;        
        pBIOSInfo->UserDPASettingInfo.VT1636DPA.CLK_SEL_ST1 = TmpBuffer[0] & 0x1F;
        pBIOSInfo->UserDPASettingInfo.VT1636DPA.CLK_SEL_ST2 = TmpBuffer[1] & 0x0F;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "VT1636 DPA: CLK_SEL_ST1=%d, CLK_SEL_ST2=%d.\n", 
            pBIOSInfo->UserDPASettingInfo.VT1636DPA.CLK_SEL_ST1,
            pBIOSInfo->UserDPASettingInfo.VT1636DPA.CLK_SEL_ST2));
    } else {
        pBIOSInfo->UserDPASettingInfo.HasUserSetting_VT1636 = FALSE;
    }
}


static void 
VIAGetOptions_RotateInfo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    viaGfxInfoPtr viaGfxInfo = pVia->pVidData->viaGfxInfo;       
    CARD32 RotateType = VIA_ROTATE_TYPE_SW;
    char* s = NULL;

    viaGfxInfo->hwIconEnalbed = FALSE;
    
    /* Initilize */    
    pVia->RotateDegree = VIA_ROTATE_DEGREE_0;
    pVia->IsHWRotateEnabled = FALSE;
    
    if ((s = xf86GetOptValString(VIAOptions, OPTION_ROTATE))) {                    
        if (!xf86NameCmp(s, "CW")) {                        
            pVia->RotateDegree = VIA_ROTATE_DEGREE_90;                        
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Rotating screen clockwise.\n"));
        } else if(!xf86NameCmp(s, "CCW")) {            
            pVia->RotateDegree = VIA_ROTATE_DEGREE_270;                        
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,  "Rotating screen counter-clockwise. \n"));
        } else if(!xf86NameCmp(s, "UD")) {            
            pVia->RotateDegree = VIA_ROTATE_DEGREE_180;                                    
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,  "Rotating screen upside-down. \n"));
        } else {
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "\"%s\" is not a valid"
                       "value for Option \"Rotate\"\n", s));
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                       "Valid options are \"CW\" or \"CCW\" or \"UD\" \n"));
        }        
    }    
       
    if ((s = xf86GetOptValString(VIAOptions, OPTION_ROTATE_TYPE))) {        
        if (!xf86NameCmp(s, "SW")) {
            RotateType = VIA_ROTATE_TYPE_SW;
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Use Software Rotation - Acceleration disabled\n");
        } else if(!xf86NameCmp(s, "HW")) {            
            RotateType = VIA_ROTATE_TYPE_HW;          
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Use Hardware Rotation.\n");
        } else {
            xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "\"%s\" is not a valid"
                       "value for Option \"RotateType\"\n", s);
            xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                       "Valid options are \"SW\" or \"HW\"  \n");
        }
    }

    if (pVia->IsSecondary)
        viaGfxInfo->screenInfo[1].rotatetype = RotateType;
    else
        viaGfxInfo->screenInfo[0].rotatetype = RotateType;
    
    if (pVia->RotateDegree != VIA_ROTATE_DEGREE_0) {            
        switch (RotateType) {
            /* accel is disabled below for shadowFB */
            case VIA_ROTATE_TYPE_SW:            
                pVia->shadowFB = TRUE;
                break;
                
            case VIA_ROTATE_TYPE_HW:
                pVia->IsHWRotateEnabled = TRUE;
                break;                
        }

        viaGfxInfo->hwIconEnalbed = TRUE;
    }
}

static 
void VIAGetOptions_Video(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    viaGfxInfoPtr viaGfxInfo = pVia->pVidData->viaGfxInfo;
    int VideoColorKey;
    
    if (xf86GetOptValInteger(VIAOptions, OPTION_VIDEO_COLOR_KEY, &VideoColorKey)) {
        viaGfxInfo->preferedColorKey = VideoColorKey;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "video color key set to 0x%lx\n", 
            viaGfxInfo->preferedColorKey);
    } else {
        viaGfxInfo->preferedColorKey = (1 << pScrn->offset.red) |
                                          (1 << pScrn->offset.green) |
                                          (1 << pScrn->offset.blue);
    }
}

static void 
VIAGetOptions_general(ScrnInfoPtr pScrn)
{
    VIAPtr          pVia;
    VIABIOSInfoPtr  pBIOSInfo;
    MessageType     from = X_DEFAULT;
    char            *s = NULL;
    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;    
    
#ifdef XF86DRI
    pVia->drixinerama = FALSE;
    if (xf86IsOptionSet(VIAOptions, OPTION_DRIXINERAMA))
        pVia->drixinerama = TRUE;
#else
    if (xf86IsOptionSet(VIAOptions, OPTION_DRIXINERAMA))
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
            "Option: drixinerama ignored, no DRI support compiled into driver.\n");
#endif

    if (xf86IsOptionSet(VIAOptions, OPTION_SHADOW_FB)) {
        pVia->shadowFB = TRUE;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: ShadowFB %s.\n",
                   pVia->shadowFB ? "enabled" : "disabled");
    } else {
        pVia->shadowFB = FALSE;
    }
    
    if (!xf86ReturnOptValBool(VIAOptions, OPTION_DRI, TRUE)) {
        pVia->directRenderingEnabled = FALSE;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: DRI is disabled\n");
    } else {
        pVia->directRenderingEnabled = TRUE;
    }

#ifndef CS_FLAG_NO_LCD_SCAL
    if (xf86IsOptionSet(VIAOptions, OPTION_LCDDISP3DScaling)) {
        pVia->DISP3DScalingCaps |= DISPLAY_3D_SCALING_SUPPORT  + VIA_DEVICE_LCD; 
        pVia->NumOfDevNeed3dScl = pVia->NumOfDevNeed3dScl +1;
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: LCD Display SW scaling %s.\n",
                   (pVia->DISP3DScalingCaps&VIA_DEVICE_LCD) ? "enabled" : "disabled");
    }
#endif /* CS_FLAG_NO_LCD_SCAL */

    if (xf86IsOptionSet(VIAOptions, OPTION_GOOD_PERFORMANCE)) {
        pVia->GoodPerformance = DISPLAY_3D_SCALING_GOOD_PERFORMANCE; 
        xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: 3D scaling use good performance mode.\n");
    }

    from = X_DEFAULT;

    pScrn->videoRam = 0;
    if(xf86GetOptValInteger(VIAOptions, OPTION_VIDEORAM, &pScrn->videoRam)) {
        DEBUG(xf86DrvMsg( pScrn->scrnIndex, X_CONFIG,
                    "Option: VideoRAM %dkB\n", pScrn->videoRam));
    }

    if (xf86ReturnOptValBool(VIAOptions, OPTION_DISABLEVQ, FALSE)) {
        pVia->VQEnable = FALSE;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
                   "Option: DisableVQ -VQ Disabled\n"));
    } else {
        pVia->VQEnable = TRUE;
    }
    
    /* Get rotate option. */
    VIAGetOptions_RotateInfo(pScrn);   

    if (xf86ReturnOptValBool(VIAOptions, OPTION_NOACCEL, FALSE)) {
        pVia->NoAccel = TRUE;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
                   "Option: NoAccel -Acceleration Disabled\n"));
    } else {
        pVia->NoAccel = FALSE;
    }

    /* NoDDCValue Option */
    if (xf86ReturnOptValBool(VIAOptions, OPTION_NODDCVALUE, FALSE)) {        
        pBIOSInfo->NoDDCValue = TRUE;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG,
            "Option: Not using DDC probed value to set HorizSync & VertRefresh\n"));
    } else {       
        pBIOSInfo->NoDDCValue = FALSE;
    }

    /* Interlace Mode Option */
    if (xf86ReturnOptValBool(VIAOptions, OPTION_INTERLACE_MODE, FALSE)) {        
        pBIOSInfo->IsEnableInterlaceMode = TRUE;
       DEBUG( xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "Option: Enable Interlace Mode. \n"));
    } else {       
        pBIOSInfo->IsEnableInterlaceMode = FALSE;
    }

#ifdef VIA_HAVE_EXA
    if (!pVia->NoAccel) {
        from = X_DEFAULT;
		pVia->useEXA = FALSE;
		
        if ((s = (char *)xf86GetOptValString(VIAOptions, OPTION_ACCELMETHOD))) {
            if (!xf86NameCmp(s, "XAA")) {
                from = X_CONFIG;
                pVia->useEXA = FALSE;
            } else if (!xf86NameCmp(s, "EXA")) {
                from = X_CONFIG;
                pVia->useEXA = TRUE;
            }
        }
        xf86DrvMsg(pScrn->scrnIndex, from,
                   "Using %s acceleration architecture.\n",
                   pVia->useEXA ? "EXA" : "XAA");

        pVia->noComposite = FALSE;
        
        if (pVia->useEXA) {
            from = xf86GetOptValBool(VIAOptions, OPTION_EXA_NOCOMPOSITE,
                                     &pVia->noComposite) ? X_CONFIG : X_DEFAULT;
            xf86DrvMsg(pScrn->scrnIndex, from,
                       "EXA composite acceleration %s.\n",
                       !pVia->noComposite ? "enabled" : "disabled");
        }
    }
#endif /* VIA_HAVE_EXA */

    if (pVia->shadowFB && !pVia->NoAccel) {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_WARNING,
                   "HW acceleration not supported with \"shadowFB\".\n"));
#ifdef VIA_HAVE_EXA
        if(pVia->useEXA == TRUE) {
            pVia->NoAccel = FALSE;          /*FIXME*/
        }
        else 
#endif 
            pVia->NoAccel = TRUE;
    }    
    
    return ;
}


static void 
VIAGetOptions_Hotkey(ScrnInfoPtr pScrn)
{
    VIAPtr          pVia;
    VIABIOSInfoPtr  pBIOSInfo;    
    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;
    char    *pStr = NULL;
    char    *pTmpStr = NULL;       
    CARD32  i = 0;

    pVia->IsForceHotkeySwitch = FALSE;
    /* Hotkey triggered by a timer. */
    if ((pStr = xf86GetOptValString(VIAOptions, OPTION_FN_HOTKEY))) {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, 
            "Option: Enable a timer to active hotkey.\n"));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Device Sequence = %s\n", pStr));
 
        pTmpStr = strtok(pStr, ",");
        while (pTmpStr != NULL) {
            if (!xf86NameCmp(pTmpStr, "CRT"))
                pVia->deviceSequence[i] = VIA_DEVICE_CRT1;
            else if (!xf86NameCmp(pTmpStr, "LCD"))
                pVia->deviceSequence[i] = VIA_DEVICE_LCD;
            else if (!xf86NameCmp(pTmpStr, "DVI"))
                pVia->deviceSequence[i] = VIA_DEVICE_DFP;
            else if (!xf86NameCmp(pTmpStr, "FORCE"))
                pVia->IsForceHotkeySwitch = TRUE;
            else
                ErrorF("Unknow Option %s for hotkey used. \n", pTmpStr);
                        
            pTmpStr = strtok(NULL, ",");
            i++;
        }

        /* It should has more than one prefered device at least. */
        if (i>1)
            pVia->IsHotkeyTimerEnabled = TRUE;
        else
            pVia->IsHotkeyTimerEnabled = FALSE;
    }
}


static void 
VIAProcessCfgOptions(ScrnInfoPtr pScrn)
{
    VIAPtr          pVia;
    VIABIOSInfoPtr  pBIOSInfo;

    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;

    xf86CollectOptions(pScrn, NULL);
    xf86ProcessOptions(pScrn->scrnIndex, pScrn->options, VIAOptions);  
    
    VIAGetOptions_general(pScrn);

    VIAGetOptions_Hotkey(pScrn);
    
    /*get mergedfb options*/
    if (!pVia->IsSecondary)
        VIAGetOptions_MergedFB(pScrn);    
    
     /* Probe the capabilities about rotation. */
    ProbeRotateCaps(pScrn);   

    VIAGetOptions_ActiveDevice(pScrn);
    VIAGetOptions_LCDInfo(pScrn);  
    VIAGetOptions_DVIInfo(pScrn);
    VIAGetOptions_DPASettingInfo(pScrn);
    
    /*here add this function because  chipset id is identified just above*/ 
    VIAGetOptions_Cursor(pScrn);
    VIAGetOptions_Video(pScrn);

    return ;    
}



static void 
VIAProbeChipset(ScrnInfoPtr pScrn, EntityInfoPtr pEnt)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAProbeChipSet!\n"));
    
    VIAPtr pVia;
    VIABIOSInfoPtr pBIOSInfo;
    MessageType     from = X_DEFAULT;

    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;

    if (pEnt->device->chipset && *pEnt->device->chipset) {
        pScrn->chipset = pEnt->device->chipset;
        pVia->ChipId = pEnt->device->chipID;
        pVia->Chipset = xf86StringToToken(VIAChipsets, pScrn->chipset);
        from = X_CONFIG;
    } else if (pEnt->device->chipID >= 0) {
        pVia->ChipId = pEnt->device->chipID;
        pVia->Chipset = LookupChipID(VIAPciChipsets, pVia->ChipId);
        pScrn->chipset = (char *)xf86TokenToString(VIAChipsets,
                                                   pVia->Chipset);
        from = X_CONFIG;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "ChipID override: 0x%04X\n",
                   pEnt->device->chipID));
    } else {
        from = X_PROBED;
        pVia->ChipId = DEVICE_ID(pVia->PciInfo);
        pVia->Chipset = LookupChipID(VIAPciChipsets, pVia->ChipId);
        pScrn->chipset = (char *)xf86TokenToString(VIAChipsets,
                                                   pVia->Chipset);
    }

    if (pEnt->device->chipRev >= 0) {
        pVia->ChipRev = pEnt->device->chipRev;
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_CONFIG, "ChipRev override: %d\n",
                   pVia->ChipRev));
    } else {
        /* Read PCI bus 0, dev 0, function 0, index 0xF6 to get chip rev. */
		uint8_t ChipRev;
#if XSERVER_LIBPCIACCESS
		pci_device_cfg_read_u8(VIAGetHostBridge(0, 0, 0), &ChipRev, 0xF6);
#else
		ChipRev = pciReadByte(pciTag(0, 0, 0), 0xF6);
#endif
		pVia->ChipRev = ChipRev;
    }
    
    xf86DrvMsg(pScrn->scrnIndex, from, "Chipset: \"%s\"\n", pScrn->chipset);
    xf86DrvMsg(pScrn->scrnIndex, from, "Chipset Rev.: %d\n", pVia->ChipRev);
	
    pBIOSInfo->Chipset = pVia->Chipset;
    pBIOSInfo->ChipRev = pVia->ChipRev;
	
    /* for CLE AX/CX differential behavior.    *
     * Define UniChrome Family Project ID/Revision, for simplify    *
     * Device ID + Revision combination.                            *
     * TODO: Use uni-variable capability flag to replace this.      */
    CARD8  BondingOption;;
    switch (pVia->Chipset) {
        case VIA_P4M800PRO:
            pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3314;
            break;
        case VIA_CX700:
            /*add for get 3324A3 revision*/
            outb(VIASR, SR43);
            BondingOption = inb(VIASR + 1);
            
            if(BondingOption & 0x02)
                pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3324M2;
            else if(BondingOption & 0x40)
                pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3324M;
            else
                pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3324;
            break;
        case VIA_K8M890:
            pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3336;
            break;
        case VIA_P4M890:
            pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3327;            
            break;
        case VIA_P4M900:
            pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3364;
            break;
        case VIA_VX800:
            pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3353;
            break;
        case VIA_VX855:
            pBIOSInfo->dwProjectIDRevision = UNICHROME_VT3409;
            break;
        default:
            xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "VIABIOSInit: Unknown Device ID\n");
            break;
    }
}

static Bool VIAFilterMode(ScrnInfoPtr pScrn)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAFilterMode!\n"));
    
    ClockRangePtr   clockRanges;
    VIAPtr          pVia;
    int result;
    pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    if(!pBIOSInfo->IsAutoDectectEnable)
        /* Use this function to replace the modeline in the config file. */
        ViaModesAttachHelper(pScrn, pScrn->monitor, ViaSupportModes);        
    
     /*
     * Setup the ClockRanges, which describe what clock ranges are available,
     * and what sort of modes they can be used for.
     */

    clockRanges = xnfcalloc(sizeof(*clockRanges), 1);
    clockRanges->next = NULL;
    clockRanges->minClock = 20000;
    clockRanges->maxClock = 270000;

    clockRanges->clockIndex = -1;
    clockRanges->interlaceAllowed = TRUE;
    clockRanges->doubleScanAllowed = FALSE;
    
    /*
     * xf86ValidateModes will check that the mode HTotal and VTotal values
     * don't exceed the chipset's limit if pScrn->maxHValue and
     * pScrn->maxVValue are set.  Since our VIAValidMode() already takes
     * care of this, we don't worry about setting them here.
     */

    pScrn->xInc = 2;
    
    /* Select valid modes from those available */
    result = xf86ValidateModes(pScrn,
                          pScrn->monitor->Modes,    /* List of modes available for the monitor */
                          pScrn->display->modes,    /* List of mode names that the screen is requesting. */
                          clockRanges,              /* list of clock ranges */
                          NULL,                     /* list of line pitches */
                          256,                      /* mini line pitch */
                          3840,                     /* max line pitch for virtual screen*/
                          16 * 8,                  /* pitch increment (in bits), we just wanna 16 bytes alignment.  */
                          128,                      /* min height */
                          2880,                     /* max height edit for virtual screen*/
                          pScrn->display->virtualX, /* virtual width */
                          pScrn->display->virtualY, /* virutal height */
                          pVia->videoRambytes,      /* size of video memory */
                          LOOKUP_BEST_REFRESH);     /* lookup mode flags */    

    if (result == -1) {
        xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "xf86ValidateModes failure\n");
        return FALSE;
    }
    
    /* This function deletes modes in the modes field of the ScrnInfoRec that have been marked as invalid. */
    xf86PruneDriverModes(pScrn);

    if (result == 0 || pScrn->modes == NULL) {
        xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "No valid modes found\n");
        return FALSE;
    }

    /* This function fills in the Crtc fields for all the modes in the modes field of the ScrnInfoRec. */
    xf86SetCrtcForModes(pScrn, INTERLACE_HALVE_V);    
   
    /* Set the current mode to the first in the list */
    pScrn->currentMode = pScrn->modes;  

    /* 3D engine require the pitch should align to 32 bytes */
    int pitch = CMDISP_ALIGN_TO(pScrn->virtualX * (pScrn->bitsPerPixel >> 3), 32);
    pScrn->displayWidth = pitch / (pScrn->bitsPerPixel >> 3);
    
    /* Print the list of modes being used */    
    xf86PrintModes(pScrn);

    /* Set display resolution */
    xf86SetDpi(pScrn, 0, 0);
           
    return TRUE;
}


void VIAFindMaxResFromEstablishedTiming(xf86MonPtr MonitorConf, int* MaxH, int* MaxV)
{               
    if (MonitorConf->timings1.t1 & 0xD0) {
        *MaxH = 720;
        *MaxV = 400;
    }
    
    if (MonitorConf->timings1.t1 & 0x3D) {
        *MaxH = 640;
        *MaxV = 480;
    }

    if (MonitorConf->timings1.t1 & 0x03) {
        *MaxH = 800;
        *MaxV = 600;
    }

    if (MonitorConf->timings1.t2 & 0xD0) {
        *MaxH = 800;
        *MaxV = 600;
    }

    if (MonitorConf->timings1.t2 & 0x20) {
        *MaxH = 832;
        *MaxV = 624;
    }

    if (MonitorConf->timings1.t2 & 0x1E) {
        *MaxH = 1024;
        *MaxV = 768;
    }

    if (MonitorConf->timings1.t2 & 0x01) {
        *MaxH = 1280;
        *MaxV = 1024;
    }        
}

xf86MonPtr 
VIADoEDID(ScrnInfoPtr pScrn, pointer pDDCModule)
{
    xf86MonPtr      pMonitor = NULL;
    unsigned char   *edidBuffer = NULL; 
    VIAPtr          pVia= VIAPTR(pScrn); ;
    VIABIOSInfoPtr  pBIOSInfo=pVia->pBIOSInfo;     
    vbeInfoPtr pVbe = pVia->pVbe;
    int edidSource = 0;

    if(xf86IsEntityShared(pScrn->entityList[0])) {
        if (pVia->IsSecondary)
            edidSource = pBIOSInfo->ActiveDevice - pBIOSInfo->PrimaryDevice;    
        else
            edidSource = pBIOSInfo->PrimaryDevice;    
    } else if (pBIOSInfo->PrimaryDevice)
        edidSource = pBIOSInfo->PrimaryDevice;    
    else
        edidSource = pBIOSInfo->ActiveDevice;
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "edidSource = 0x%x\n", edidSource));       

    edidBuffer = xcalloc(1,sizeof(unsigned char) * (128));

    if (edidSource & VIA_DEVICE_LCD) {
        /* Read EDID v1.1 Block */  
        if (VIALVDSIdentify(pBIOSInfo)) {
            switch (pBIOSInfo->LVDSSettingInfo.ChipID) {
                case VIA_Hardwired:          
                    pBIOSInfo->LVDSSettingInfo.I2CPort = 0x31;
                    break;

                case VIA_INTEGRATED_LVDS: 
                    if (pBIOSInfo->Chipset == VIA_VX800)
                        pBIOSInfo->LVDSSettingInfo.I2CPort = 0x31;
                    else
                        pBIOSInfo->LVDSSettingInfo.I2CPort = 0x2C;                    
                    break;

                case VIA_VT1636:
                case VIA_VT1631: 
                    /* use the serial port which is used to sense LVDS */
                    break;      

                default:
                    pBIOSInfo->LVDSSettingInfo.I2CPort = 0x31;                    
                    break;
            }

            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                  "Use Port %#x to probe LCD EDID\n", pBIOSInfo->LVDSSettingInfo.I2CPort));

            viaSerialReadBytes(pBIOSInfo->LVDSSettingInfo.I2CPort, 0xA0, 0, edidBuffer, 128);
        }

        /* Parse the EDID block */
        pMonitor = xf86InterpretEDID(pScrn->scrnIndex,edidBuffer);    

        if (pMonitor)
            pBIOSInfo->EDIDType = VIA_DEVICE_LCD;
                
    } else if (edidSource & VIA_DEVICE_DFP) {
        /* Read EDID v1.1 Block */
        if(VIATMDSIdentify(pBIOSInfo)) {
            viaSerialReadBytes(pBIOSInfo->TMDSSettingInfo.I2CPort, 0xA0, 0, edidBuffer, 128);
        }
        
        /* Parse the EDID block */
        pMonitor = xf86InterpretEDID(pScrn->scrnIndex,edidBuffer);

        if (pMonitor) 
            pBIOSInfo->EDIDType = VIA_DEVICE_DFP;
        
    } 
    if (!pMonitor) {        
        pMonitor = vbeDoEDID(pVbe, NULL);
        pBIOSInfo->EDIDType = VIA_DEVICE_CRT1;
    }
    
    xfree(edidBuffer);
    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "EDID data is from device %#x.\n", pBIOSInfo->EDIDType));
    
    return pMonitor;
}    


static Bool 
VIAProbeMonitorLimitation(ScrnInfoPtr pScrn)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAProbeMonitorLimitation!\n"));
    VIAPtr          pVia;
    VIABIOSInfoPtr pBIOSInfo;
    int max_h = 0, max_v = 0;
    int i;
   
    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;

    /*If we set Option "NoDDCValue", then CRT's  MonitorSizeH/MonitorSizeV
        which is gotten from CRT's EDID/DDC is meaningless and should not be used to judge CRT panning
        or not. set these two value bigger than max resolution that we support is safe. now we max support
        1920x1440.*/
    if (pBIOSInfo->NoDDCValue) {               
        pBIOSInfo->CRTSettingInfo.MonitorSizeH = 4096;
        pBIOSInfo->CRTSettingInfo.MonitorSizeV = 2048;
        pBIOSInfo->CRTSettingInfo.PreferModeH = 4096;
        pBIOSInfo->CRTSettingInfo.PreferModeV = 2048;


        /* When noDDCvalue is set, xorg will set the default value 
         * to hsync and vsync
         * Hsync:28-33
         * Vsync:43-72
         * The range is too small to remain necessary modes.
         * so our driver provides a little bigger range.
         * if the range still can't fit user's modeline, one can
         * set HorizSync and VertRefresh in xorg.conf's Monitor section.
         * User must know what she is doing when adding HorizSync VertRefresh.
         */
        /* Assign a default value to indicate the limitation of monitor.
         * we set the restrictive limitation to protect devices from cooking.
         * if one has set the limitation in xorg.conf, use it. 
         */
        if (!pScrn->monitor->nHsync || !pScrn->monitor->hsync[0].hi) {
            pScrn->monitor->nHsync = 1;         /* number of hsync. */
            pScrn->monitor->hsync[0].hi = 113;  /* upper bound */
            pScrn->monitor->hsync[0].lo = 30;   /* lower bound */
        }
        
        return TRUE;
    }

    if (!xf86LoadSubModule(pScrn, "ddc")) {
        return FALSE;
    } else {
    
        xf86MonPtr pMon = NULL;
        if (pVia->IsMAMMEnable) {
            /* get EDID by ourself, use DDC module could fail to get EDID */
            if(VIAGetCRTEDID(pScrn, pMon))
                pVia->DDC1 = pMon;
        } else {            
            xf86LoaderReqSymLists(ddcSymbols, NULL);
            
            if ((pVia->pVbe) &&
                (pMon = xf86PrintEDID(VIADoEDID(pScrn, NULL)))) {
                pVia->DDC1 = pMon;
                xf86SetDDCproperties(pScrn,pMon);
            } else if (!VIAddc2(pScrn->scrnIndex)) {
                VIAddc1(pScrn->scrnIndex);
            }
        }
        
        /* Try to get monitor's max size. */
        if (pVia->DDC1) {
            /*Find max resolution from Established timing*/
            VIAFindMaxResFromEstablishedTiming(pVia->DDC1, &max_h, &max_v);

            /*Find max resolution from Standard timing*/
            for (i = 0; i < 8; i++) {
                if (pVia->DDC1->timings2[i].hsize >= max_h) {
                    if(pVia->DDC1->timings2[i].hsize == max_h) {
                        if(pVia->DDC1->timings2[i].vsize > max_v) {
                            max_h = pVia->DDC1->timings2[i].hsize;
                            max_v = pVia->DDC1->timings2[i].vsize;
                        }
                    } else {
                        max_h = pVia->DDC1->timings2[i].hsize;
                        max_v = pVia->DDC1->timings2[i].vsize;
                    } 
                }                
            }

            /*Find max resolution from Detail timing*/
            for (i = 0; i < 4; i++) {
                if ((pVia->DDC1->det_mon[i].type == DT) && 
                    (pVia->DDC1->det_mon[i].section.d_timings.h_active > max_h)) {
                    max_h = pVia->DDC1->det_mon[i].section.d_timings.h_active;
                    max_v = pVia->DDC1->det_mon[i].section.d_timings.v_active;

                    if (pVia->DDC1->det_mon[i].section.d_timings.interlaced)
                        max_v = max_v*2;
                }                
            }

            if(!(pBIOSInfo->ModeLineStatus & (MODE_LINE_TYPE_USER|MODE_LINE_TYPE_EDID))) 
                /* Correct monitor size to avoid invalid mode. */
                VIACorrectMonitorSize(&max_h, &max_v);            

            /* To prevent to get a wrong EDID data. We should assign a default value.*/
            if ((max_h == 0) || (max_v == 0)) {
                max_h = 1024;
                max_v = 768;
            }
            
            pBIOSInfo->CRTSettingInfo.MonitorSizeH = max_h;
            pBIOSInfo->CRTSettingInfo.MonitorSizeV = max_v;

			/* if LCD panel support EDID, use the EDID to set panel size */
			if (pBIOSInfo->EDIDType == VIA_DEVICE_LCD) {
				pBIOSInfo->LVDSSettingInfo.PanelSizeX = max_h;
				pBIOSInfo->LVDSSettingInfo.PanelSizeY = max_v;
			}

            /* Pull out a phyiscal size from a detailed timing if available. */
            for (i = 0; i < 4; i++) {
                if (pVia->DDC1->det_mon[i].type == DT &&
                    pVia->DDC1->det_mon[i].section.d_timings.h_size != 0 &&
                    pVia->DDC1->det_mon[i].section.d_timings.v_size != 0) {
                	/*Find the detail timing whose area is the max one of w*h*/
                	if ((pVia->DDC1->det_mon[i].section.d_timings.h_active * 
                	     pVia->DDC1->det_mon[i].section.d_timings.v_active) > 
						(pBIOSInfo->CRTSettingInfo.PreferModeH * 
						 pBIOSInfo->CRTSettingInfo.PreferModeV)) {
						 
	                    pBIOSInfo->CRTSettingInfo.PreferModeH =  pVia->DDC1->det_mon[i].section.d_timings.h_active;
	                    pBIOSInfo->CRTSettingInfo.PreferModeV =  pVia->DDC1->det_mon[i].section.d_timings.v_active;

	                    if (pVia->DDC1->det_mon[i].section.d_timings.interlaced)
	                        pBIOSInfo->CRTSettingInfo.PreferModeV *= 2;

	                    pBIOSInfo->UserSpecifiedMode.clk = pVia->DDC1->det_mon[i].section.d_timings.clock;
	                    pBIOSInfo->UserSpecifiedMode.crtc.hor_total = pVia->DDC1->det_mon[i].section.d_timings.h_active + pVia->DDC1->det_mon[i].section.d_timings.h_blanking;
	                    pBIOSInfo->UserSpecifiedMode.crtc.hor_addr = pVia->DDC1->det_mon[i].section.d_timings.h_active;
	                    pBIOSInfo->UserSpecifiedMode.crtc.hor_blank_start = pVia->DDC1->det_mon[i].section.d_timings.h_active;
	                    pBIOSInfo->UserSpecifiedMode.crtc.hor_blank_end = pVia->DDC1->det_mon[i].section.d_timings.h_blanking;
	                    pBIOSInfo->UserSpecifiedMode.crtc.hor_sync_start = pVia->DDC1->det_mon[i].section.d_timings.h_active + pVia->DDC1->det_mon[i].section.d_timings.h_sync_off;
	                    pBIOSInfo->UserSpecifiedMode.crtc.hor_sync_end = pVia->DDC1->det_mon[i].section.d_timings.h_sync_width;
	                    pBIOSInfo->UserSpecifiedMode.crtc.ver_total = pVia->DDC1->det_mon[i].section.d_timings.v_active + pVia->DDC1->det_mon[i].section.d_timings.v_blanking;
	                    pBIOSInfo->UserSpecifiedMode.crtc.ver_addr = pVia->DDC1->det_mon[i].section.d_timings.v_active;
	                    pBIOSInfo->UserSpecifiedMode.crtc.ver_blank_start = pVia->DDC1->det_mon[i].section.d_timings.v_active;
	                    pBIOSInfo->UserSpecifiedMode.crtc.ver_blank_end = pVia->DDC1->det_mon[i].section.d_timings.v_blanking;
	                    pBIOSInfo->UserSpecifiedMode.crtc.ver_sync_start = pVia->DDC1->det_mon[i].section.d_timings.v_active + pVia->DDC1->det_mon[i].section.d_timings.v_sync_off;
	                    pBIOSInfo->UserSpecifiedMode.crtc.ver_sync_end = pVia->DDC1->det_mon[i].section.d_timings.v_sync_width;                                    
                	}

                    /* If Prefer Mode BIT is set, the first detail timing is preferred mode. */
                    if (pVia->DDC1->features.msc & 0x2)                         
                        break;
                }
            }

            /* if no mm size is available from a detailed timing, check the max size field */
            if ((!pBIOSInfo->CRTSettingInfo.PreferModeH || !pBIOSInfo->CRTSettingInfo.PreferModeV) &&
                (pVia->DDC1->features.hsize &&  pVia->DDC1->features.vsize)) {
                pBIOSInfo->CRTSettingInfo.PreferModeH =  max_h;
                pBIOSInfo->CRTSettingInfo.PreferModeV =  max_v;
            }
            
        }
        else
        {
            if ((pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD)
              &&(pBIOSInfo->LVDSSettingInfo.PanelSizeID)) {
                VIAGetPanelSizeByIndex(pBIOSInfo->LVDSSettingInfo.PanelSizeID, &(pBIOSInfo->CRTSettingInfo.MonitorSizeH), &(pBIOSInfo->CRTSettingInfo.MonitorSizeV));
            } else {
                /* If DDC fail, set a default value as monitor size. */
                pBIOSInfo->CRTSettingInfo.MonitorSizeH = 1024;
                pBIOSInfo->CRTSettingInfo.MonitorSizeV = 768;
            }
            pBIOSInfo->CRTSettingInfo.PreferModeH = pBIOSInfo->CRTSettingInfo.MonitorSizeH;
            pBIOSInfo->CRTSettingInfo.PreferModeV = pBIOSInfo->CRTSettingInfo.MonitorSizeV;                    
        }

        /* If the monitor is analog but it doesn't support GTF,
           we consider that it should be a flat monitor with D-SUB. 
        */
        pBIOSInfo->CRTSettingInfo.IsFlatMonitor = FALSE;
        if(pMon != NULL) {
            if (!DIGITAL((&pMon->features)->input_type)) {            
                if (!GFT_SUPPORTED((&pMon->features)->msc)) {                
                    pBIOSInfo->CRTSettingInfo.IsFlatMonitor = TRUE;

                    /* If the monitor is a flat monitor, we can get the actual size from h_active & v_active. */
                    for (i = 0; i < 4; i++) {
                        if (pMon->det_mon[i].type == DT) {                    
                            if (pMon->det_mon[i].section.d_timings.h_active > max_h) {                        
                                pBIOSInfo->CRTSettingInfo.MonitorSizeH = pMon->det_mon[i].section.d_timings.h_active;
                                pBIOSInfo->CRTSettingInfo.MonitorSizeV = pMon->det_mon[i].section.d_timings.v_active;                            
                            }
                        }
                    }
                }
            }
        }

        xf86DrvMsg(pScrn->scrnIndex, X_PROBED, "Max Monitor H Size =  %d\n",
               pBIOSInfo->CRTSettingInfo.MonitorSizeH);
        xf86DrvMsg(pScrn->scrnIndex, X_PROBED, "Max Monitor V Size =  %d\n",
               pBIOSInfo->CRTSettingInfo.MonitorSizeV);
    }     

        
    /* Reset HorizSync & VertRefresh Rang Using DDC Value */
    if (pVia->DDC1 && !pBIOSInfo->NoDDCValue) {
        for (i = 0; i < DET_TIMINGS; i++) {
            if (pVia->DDC1->det_mon[i].type == DS_RANGES) {
                if (pVia->DDC1->det_mon[i].section.ranges.max_clock != 0)
                    pBIOSInfo->CRTSettingInfo.MaxPixelClock = pVia->DDC1->det_mon[i].section.ranges.max_clock;

				/*EDID corrupt*/
				if ((pVia->DDC1->det_mon[i].section.ranges.min_h > pVia->DDC1->det_mon[i].section.ranges.max_h)||
					(pVia->DDC1->det_mon[i].section.ranges.min_v > pVia->DDC1->det_mon[i].section.ranges.max_v)) {
					xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "Bad EDID ranges! Please check if the EDID is corrupt!!\n");
					break;
				}
            
                pScrn->monitor->hsync[pScrn->monitor->nHsync].lo
                    = pVia->DDC1->det_mon[i].section.ranges.min_h;
                pScrn->monitor->hsync[pScrn->monitor->nHsync].hi
                    = pVia->DDC1->det_mon[i].section.ranges.max_h;

                if (pScrn->monitor->nHsync == 0)
                    pScrn->monitor->nHsync++;

                pScrn->monitor->vrefresh[pScrn->monitor->nVrefresh].lo
                    = pVia->DDC1->det_mon[i].section.ranges.min_v;
                pScrn->monitor->vrefresh[pScrn->monitor->nVrefresh].hi
                    = pVia->DDC1->det_mon[i].section.ranges.max_v;

                if (pScrn->monitor->nVrefresh == 0)
                    pScrn->monitor->nVrefresh++;
                
                break;
            }
        }
    }
	/* 
  	   Sometimes we will fail to get CRT EDID,
	   just like CRT is not connected. We can't know the limitation of monitor, and
	   the screen will be set to an unexpect mode. So we should assign a default value
	   to indicate the limitation of monitor.
	*/
	if(pScrn->monitor->nHsync == 0) {
        pScrn->monitor->nHsync = 1;         /* number of hsync. */
        pScrn->monitor->hsync[0].hi = 113;  /* upper bound */
        pScrn->monitor->hsync[0].lo = 30;   /* lower bound */
    }
	if(pScrn->monitor->nVrefresh == 0) {
        pScrn->monitor->nVrefresh = 1;		/* number of vsync. */	
        pScrn->monitor->vrefresh[0].hi = 100;  /* upper bound */
        pScrn->monitor->vrefresh[0].lo = 50;   /* lower bound */		
	}     
    return TRUE;
}


static Bool 
VIACollectBIOSInfo(ScrnInfoPtr pScrn)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIACollectBIOSInfo!\n"));

    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    int tmp;

    /* Read PCI configuration space to get frame buffer size. */
    VIAGetFBSize(pScrn);

    /* Check if spread spectrum is enable */
    VGAOUT8(0x3c4, SR1E);
    if (VGAIN8(0x3c5) & BIT3) {
        pVia->pChipInfo->biosIsSpreadSpectrum = TRUE;
        pBIOSInfo->IsSpreadSpectrumEnabled = TRUE;
    } else {
        pVia->pChipInfo->biosIsSpreadSpectrum = FALSE;
        pBIOSInfo->IsSpreadSpectrumEnabled = FALSE;            
    }

    if (!pVia->IsMAMMEnable) {
        /* Get BIOS version through function call. */
        BIOS_GetBIOSVersion(pScrn);

        /* Get BIOS type and support status */
        BIOS_QueryChipInfo(pScrn);

        if (pVia->pChipInfo->biosSupportDev & VIA_DEVICE_LCD)
            pBIOSInfo->IsBiosSupportLCD = TRUE;

        /* Get BIOS date through function call. */
        BIOS_GetBIOSDate(pScrn);

        /* Get BIOS active device */
        BIOS_GetActiveDevice(pScrn);        

        /* get default LCD panel ID from scratch pad. */
        if (pBIOSInfo->LVDSSettingInfo.PanelSizeID == VIA_INVALID) {
            VGAOUT8(0x3D4, 0x3F);
            tmp = VGAIN8(0x3D5) & 0x0F;

            pVia->pChipInfo->biosPanelID = tmp;
            if(VIASetLCDPanelInfo(pBIOSInfo, tmp)) {                        
                DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                      "Get PanelID From Scratch Pad is 0x%x\n", 
                      pVia->pChipInfo->biosPanelID));
            } else {
                DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_ERROR,
                      "No Panel ID\n"));
            }
        }
    }
    
    return TRUE;
    
}

/*
*   If use VIA's ROM, return true.
*/
static Bool VIACheckROMName()
{    
    unsigned char   *pBIOS = NULL, *pRom;
    int             romSize, sum, i;
    
    /* Allocate shadow memory */
    if (!(pBIOS=xcalloc(1, 0x10000))) {
        ErrorF("Allocate memory fail !!\n");
        return FALSE;
    }
    /* Read BIOS ROM and check! */
    if (xf86ReadBIOS(0xC0000, 0, pBIOS, 0x10000) != 0x10000) {
        xfree(pBIOS);
        ErrorF("Read VGA BIOS image fail !!\n");
    } else {
        if (*((CARD16 *) pBIOS) != 0xAA55) {
            xfree(pBIOS);
            ErrorF("VGA BIOS image is wrong!!\n");
            return FALSE;
        } else {
            romSize = *((CARD8 *) (pBIOS + VIA_BIOS_SIZE_POS)) * 512;
            pRom = pBIOS;
            sum = 0;

            for (i = 0; i < romSize; i++)
                sum += *pRom++;

            if (((CARD8) sum) != 0) {
                xfree(pBIOS);
                ErrorF("VGA BIOS image is wrong!! CheckSum = %x\n", sum);
                return FALSE;
            }
        }
    }
    
    pBIOS += 0x61;  

    if(!memcmp(pBIOS, "VIA", 3))
        return TRUE;
    else
        return FALSE;
}

static Bool
VIAIsMAMM()
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];  

    if (!memcmp(pScrn0->name, "VIA", 3))
        return FALSE;
    else 
        return TRUE;            
}


/* Get the CRTC timing from xorg.conf */
void 
VIAGetModeLineTiming(ScrnInfoPtr pScrn, DisplayModePtr mode)
{
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    /* 
    case 1: user specified timing in xorg.conf, we'll use it,
        and the option "Refresh" doesn't take effect
    */
    if(mode->type == M_T_USERDEF) {
        pBIOSInfo->ModeLineStatus = MODE_LINE_TYPE_USER;
        /* 
        The secondary device will use hard code timing
        */
        if(!pBIOSInfo->SAMM) {
            if (pBIOSInfo->PrimaryDevice) /* Duoview*/
                pBIOSInfo->EDIDType = pBIOSInfo->PrimaryDevice;
            else /* Single */
                pBIOSInfo->EDIDType = pBIOSInfo->ActiveDevice;
        }
    /* 
    case 2: monitor preferred timing, we'll use it, 
        and the option "Refresh" doesn't take effect
    */    
    } else if(mode->type & M_T_PREFERRED)
        pBIOSInfo->ModeLineStatus = MODE_LINE_TYPE_EDID;
    /* 
    other case: we'll use hard code timing,
        and the option "Refresh" take effect
    */
    else
        pBIOSInfo->ModeLineStatus = 0;

    if (pBIOSInfo->ModeLineStatus & (MODE_LINE_TYPE_USER | MODE_LINE_TYPE_EDID)) {
        pBIOSInfo->UserSpecifiedMode.clk = mode->Clock * 1000;
        if (mode->Flags & V_PHSYNC) 
            pBIOSInfo->UserSpecifiedMode.h_sync_polarity = POSITIVE;
        if (mode->Flags & V_NHSYNC) 
            pBIOSInfo->UserSpecifiedMode.h_sync_polarity = NEGATIVE;
        if (mode->Flags & V_PVSYNC)
            pBIOSInfo->UserSpecifiedMode.v_sync_polarity = POSITIVE;
        if (mode->Flags & V_NVSYNC) 
            pBIOSInfo->UserSpecifiedMode.v_sync_polarity = NEGATIVE;
        
        pBIOSInfo->UserSpecifiedMode.crtc.hor_total = mode->CrtcHTotal;
        pBIOSInfo->UserSpecifiedMode.crtc.hor_addr = mode->CrtcHDisplay;
        pBIOSInfo->UserSpecifiedMode.crtc.hor_blank_start = mode->CrtcHDisplay; /* mode->CrtcHBlankStart is incorrect! */
        pBIOSInfo->UserSpecifiedMode.crtc.hor_blank_end = mode->CrtcHBlankEnd - mode->CrtcHDisplay;
        pBIOSInfo->UserSpecifiedMode.crtc.hor_sync_start = mode->CrtcHSyncStart;
        pBIOSInfo->UserSpecifiedMode.crtc.hor_sync_end = mode->CrtcHSyncEnd - mode->CrtcHSyncStart;
        pBIOSInfo->UserSpecifiedMode.crtc.ver_total = mode->CrtcVTotal;
        pBIOSInfo->UserSpecifiedMode.crtc.ver_addr = mode->CrtcVDisplay;
        pBIOSInfo->UserSpecifiedMode.crtc.ver_blank_start = mode->CrtcVBlankStart;
        pBIOSInfo->UserSpecifiedMode.crtc.ver_blank_end = mode->CrtcVBlankEnd - mode->CrtcVBlankStart;
        pBIOSInfo->UserSpecifiedMode.crtc.ver_sync_start = mode->CrtcVSyncStart;
        pBIOSInfo->UserSpecifiedMode.crtc.ver_sync_end = mode->CrtcVSyncEnd - mode->CrtcVSyncStart;    
    }

}
    
void 
VIAFindMonPreferModeLine(ScrnInfoPtr pScrn)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAFindMonPreferModeLine\n"));

    DisplayModePtr mode;

    for (mode = pScrn->modes; ; mode = mode->next) {
        if (mode->type & M_T_PREFERRED)
            VIAGetModeLineTiming(pScrn, mode);

        if (mode->next == pScrn->modes)
            break;  /* The end of mode list. */
    }
}

static Bool 
VIAPreInit(ScrnInfoPtr pScrn, int flags)
{
    EntityInfoPtr   pEnt;
    VIAPtr          pVia;
    VIABIOSInfoPtr  pBIOSInfo;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAPreInit\n"));
    DEBUG(ErrorF("XORG_VERSION_CURRENT = %d\n",XORG_VERSION_CURRENT));
#if XORG_VERSION_CURRENT < XF86_VERSION_NUMERIC(1,5,99,0,0)||XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(7,0,0,0,0)
    via_xf86_version_current = xf86GetVersion();    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "XF86_VER=%d\n,Driver Not depending on this anymore\n", via_xf86_version_current));    
#endif

    if (pScrn->numEntities > 1)
        return FALSE;

    if (flags & PROBE_DETECT)
        return FALSE;
   
    if (!xf86LoadSubModule(pScrn, "vgahw"))
        return FALSE;

    xf86LoaderReqSymLists(vgaHWSymbols, NULL);
    if (!vgaHWGetHWRec(pScrn))
        return FALSE;

    if (!VIAGetRec(pScrn)) 
        return FALSE;

    if (!xf86LoadSubModule(pScrn, "viavideo")) {
        via_module_loaded = FALSE;
        xf86DrvMsg(pScrn->scrnIndex, X_WARNING,
                   " Couldn't open viavideo\n");
    } else
        via_module_loaded = TRUE;

    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;
    pBIOSInfo->s3utility=FALSE;
    pVia->IsSuspending = FALSE;
    pVia->IsVIAModeInitRunOnceDone = FALSE;
    pVia->eventTimer=NULL;

    if(VIAIsMAMM()) {              
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "MAMM mode enable\n");
        pVia->IsMAMMEnable = TRUE;   
        pBIOSInfo->IsMAMMEnable = TRUE;
    } else {               
        pVia->IsMAMMEnable = FALSE;   
        pBIOSInfo->IsMAMMEnable = FALSE;
    }     

    /*
     *  Add VidData struct allocation & initial codes
     */
    if (!IsVidDataAllocated) {
        pVia->pVidData = (PVIDDATA) xalloc(sizeof(VIDDATA));
        memset(pVia->pVidData, 0, sizeof(VIDDATA));

        pVia->pVidData->viaGfxInfo = (viaGfxInfoPtr) xalloc(sizeof(viaGfxInfoRec));
        memset(pVia->pVidData->viaGfxInfo, 0, sizeof(viaGfxInfoRec));

        IsVidDataAllocated = TRUE;
    } else {
        /* for SAMM case - Second display */
        if (pScrn->scrnIndex == 1) {
            ScrnInfoPtr pScrn0 = xf86Screens[0];
            VIAPtr pVia0 = VIAPTR(pScrn0);
            pVia->pVidData = pVia0->pVidData;
        }
    }
    
    pVia->IsSecondary = FALSE;
    pEnt = xf86GetEntityInfo(pScrn->entityList[0]);
    if (pEnt->resources) {
        xfree(pEnt);
        VIAFreeRec(pScrn);
        return FALSE;
    }

    pVia->PciInfo = xf86GetPciInfoForEntity(pEnt->index);
#if !XSERVER_LIBPCIACCESS
    pVia->PciTag = pciTag(pVia->PciInfo->bus, pVia->PciInfo->device,
              pVia->PciInfo->func);
#endif
    if(xf86RegisterResources(pEnt->index, NULL, ResNone)) {
        xfree(pEnt);
        VIAFreeRec(pScrn);
        return FALSE;
    }

    if(xf86IsEntityShared(pScrn->entityList[0])) {
        if(xf86IsPrimInitDone(pScrn->entityList[0])) {
            DevUnion* pPriv;
            VIAEntPtr pVIAEnt;
            VIAPtr pVia1;

            pVia->IsSecondary = TRUE;
            pVia->HasSecondary = TRUE;
            pPriv = xf86GetEntityPrivate(pScrn->entityList[0],
                    gVIAEntityIndex);
            pVIAEnt = pPriv->ptr;
            if (pVIAEnt->BypassSecondary) {
                xfree(pEnt);
                VIAFreeRec(pScrn);
                return FALSE;
            }
            pVIAEnt->pSecondaryScrn = pScrn;
            pVIAEnt->HasSecondary = TRUE;
            pVia1 = VIAPTR(pVIAEnt->pPrimaryScrn);
            pVia1->HasSecondary = TRUE;
            /*  In current duoview flag seting logic(VIACheckIfUseDuoView), 
            SAMM case screen 0 's  pBIOSInfo->DuoView will be set to TRUE, so  set screen0's Duoview 
            to False when  found SAMM here*/
            pVia1->pBIOSInfo->DuoView=FALSE;
            /* If SAMM, Hot key zoom locked
             * pScrn->zoomLocked = TRUE;*/
            pVIAEnt->pSecondaryScrn->zoomLocked = TRUE;
            pVIAEnt->pPrimaryScrn->zoomLocked = TRUE;
        } else {
            DevUnion* pPriv;
            VIAEntPtr pVIAEnt;

            xf86SetPrimInitDone(pScrn->entityList[0]);
            pPriv = xf86GetEntityPrivate(pScrn->entityList[0],
                    gVIAEntityIndex);
            pVIAEnt = pPriv->ptr;
            pVIAEnt->pPrimaryScrn = pScrn;
            pVIAEnt->IsDRIEnabled = FALSE;
            pVIAEnt->BypassSecondary = FALSE;
            pVIAEnt->HasSecondary = FALSE;
            pVIAEnt->RestorePrimary = FALSE;
            pVIAEnt->IsSecondaryRestored = FALSE;
        }
    }

    /* Detect which chipset we used. */
    VIAProbeChipset(pScrn, pEnt);

    pScrn->monitor = pScrn->confScreen->monitor;

    
    /*
     * We support depths of 8, 16 and 24.
     * We support bpp of 8, 16, and 32.
     */

    if (!xf86SetDepthBpp(pScrn, 0, 0, 0, Support32bppFb)) {
        xfree(pEnt);
        VIAFreeRec(pScrn);
        return FALSE;
    } else {
        switch (pScrn->depth)
        {
            case 8:
            case 16:
            case 24:
            case 32:
                /* OK */
                break;
            default:
                xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                       "Given depth (%d) is not supported by this driver\n",
                       pScrn->depth);
                xfree(pEnt);
                VIAFreeRec(pScrn);
                return FALSE;
        }
    }

    xf86PrintDepthBpp(pScrn);

    if (pScrn->depth == 32) 
        pScrn->depth = 24;

    if (pScrn->depth > 8) {
        rgb zeros = {0, 0, 0};

        if (!xf86SetWeight(pScrn, zeros, zeros)) {
            xfree(pEnt);
            VIAFreeRec(pScrn);
            return FALSE;
        } else {
            /* TODO check weight returned is supported */
            ;
        }
    }

    if (!xf86SetDefaultVisual(pScrn, -1)) {
        return FALSE;
    } else {
        /* We don't currently support DirectColor at > 8bpp */
        if (pScrn->depth > 8 && pScrn->defaultVisual != TrueColor) {
            xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "Given default visual"
                       " (%s) is not supported at depth %d\n",
                       xf86GetVisualName(pScrn->defaultVisual), pScrn->depth);
            xfree(pEnt);
            VIAFreeRec(pScrn);
            return FALSE;
        }
    }

    /* Set the bits per RGB for 8bpp mode */
    if (pScrn->depth == 8)
        pScrn->rgbBits = 8;

    /* We use a programmable clock */
    pScrn->progClock = TRUE;

    /* If MAMM mode, we can't use int10,vbe */
    if (!pVia->IsMAMMEnable) {
        if (xf86LoadSubModule(pScrn, "int10")) {
            xf86LoaderReqSymLists(int10Symbols, NULL);
            pVia->pInt10 = xf86InitInt10(pEnt->index);
        }

        if (pVia->pInt10 && xf86LoadSubModule(pScrn, "vbe")) {
            xf86LoaderReqSymLists(vbeSymbols429900, NULL);
            pVia->pVbe = VBEExtendedInit(pVia->pInt10, pEnt->index,0);
        }    
    }

    /* Set status word positions based on chip type. */
    switch (pVia->Chipset) {
        case VIA_K8M890:
        case VIA_P4M900:        
            pVia->myWaitIdle = WaitIdle_H5Chips;
            break;
        case VIA_VX800:
        case VIA_VX855:
            pVia->myWaitIdle = WaitIdle_H6Chips;
            break;
        default:
            pVia->myWaitIdle = WaitIdle_H2Chips;
            break;
    }

    /* Because xf86Info.disableRandR is changeful, but it match the option
       "RandR" in ServerLayout section, so we store it to pVia->useRandR */
#ifdef VIA_RANDR12_SUPPORT
    pVia->useRandR = !xf86Info.disableRandR;
    /* if xorg doesn't support RandR1.2, we can only support old architecture */
#else
    pVia->useRandR = FALSE;
#endif

    /* *_* We process all config file's options in one function *_* */
    VIAProcessCfgOptions(pScrn);
    
    if (pEnt->device->videoRam != 0) {
        if (!pScrn->videoRam)
            pScrn->videoRam = pEnt->device->videoRam;
        else
            xf86DrvMsg(pScrn->scrnIndex, X_WARNING,
                       "Video Memory Size in Option is %d KB, Detect is %d KB!",
                       pScrn->videoRam, pEnt->device->videoRam);
    }

    xfree(pEnt);    

    /* FrameBufferBase always represets physical start address for the 
       whole video memory.*/
    pVia->FrameBufferBase = MEMBASE(pVia->PciInfo, 0);

    /* ScreenBase represents physical start address for each screen*/
    pVia->ScreenBase = MEMBASE(pVia->PciInfo, 0); 
    
    if (!VIAMapMMIO(pScrn)) {
        if (pVia->pVbe!=NULL)
            vbeFree(pVia->pVbe);
            return FALSE;
    }      

    /* Collect some information about Chip or CMOS setting */
    if (!VIACollectBIOSInfo(pScrn)) {
        VIAFreeRec(pScrn);
        return FALSE;
    }

    /* Initialize the colormap and this step must be done before calling xf86HandleColormaps. */
    Gamma zeros = {0.0, 0.0, 0.0};
    if (!xf86SetGamma(pScrn, zeros)) {
        VIAFreeRec(pScrn);
        vbeFree(pVia->pVbe);
        return FALSE;
    }

    pScrn->videoRam = pVia->pChipInfo->biosVideoMemSize;

    /* Split FB for SAMM */
    /* FIXME: For now, split FB into two equal sections. This should
     *        be able to be adjusted by user with a config option. */
    if (pVia->IsSecondary) {
        DevUnion* pPriv;
        VIAEntPtr pVIAEnt;
        VIAPtr    pVia0;
        int videoram1=0;

        pPriv = xf86GetEntityPrivate(pScrn->entityList[0],gVIAEntityIndex);
        pVIAEnt = pPriv->ptr;

        if(xf86GetOptValInteger(VIAOptions, OPTION_VIDEORAM1, &videoram1))
            xf86DrvMsg( pScrn->scrnIndex, X_CONFIG,
                        "Option: VideoRAM1 %dkB\n", videoram1 );
        
        if(videoram1 > 0)
            videoram1 = (videoram1 >> 10) << 10;
  
        if(videoram1 >= pScrn->videoRam - 16384)
            videoram1 = pScrn->videoRam - 16384;

        if((videoram1 <= 16384) && (videoram1 > 0))
            videoram1 = 16384;

        if(videoram1)
            pScrn->videoRam = videoram1;
        else
            pScrn->videoRam = 11 * 1024; /* Reserve 11M for second scrn, because 1920x1440x4/2^20 = 10.5M  */
        
        pVIAEnt->pPrimaryScrn->videoRam -=  pScrn->videoRam;
        pVia0 = VIAPTR(pVIAEnt->pPrimaryScrn);
        /*Rewrite pVia0->videoRambytes here*/
        pVia0->videoRambytes = pVIAEnt->pPrimaryScrn->videoRam << 10;
        pVia->ScreenBase += (pVIAEnt->pPrimaryScrn->videoRam << 10);
                   
    }


    if (!pVia->IsSecondary) {
        pVia->pScreensPublicInfo->VRamSize = pScrn->videoRam << 10;
    }

    /*Init videoRambytes to All Video Memory Size, pVia->videoRambytes may rewrite in SAMM mode*/
    pVia->videoRambytes = pScrn->videoRam << 10;

    xf86DrvMsg(pScrn->scrnIndex, X_PROBED, "videoram =  %dk\n",
               pScrn->videoRam);

    /* here load any modules that we need */    
    /* Before using DDC, we must initialize the I2C. */
    if (!xf86LoadSubModule(pScrn, "i2c")) {
        VIAFreeRec(pScrn);
        return FALSE;
    } else {
        xf86LoaderReqSymLists(i2cSymbols,NULL);
        VIAI2CInit(pScrn);
    }
    
    if (xf86LoadSubModule(pScrn, "fb") == NULL) {
        xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "Failed to load fb module");
        VIAFreeRec(pScrn);
        return FALSE;
    }

    xf86LoaderReqSymLists(fbSymbols, NULL);

    if (!pVia->NoAccel) {
#ifdef VIA_HAVE_EXA
      if (pVia->useEXA) {
#if (EXA_VERSION_MAJOR >= 2)
            XF86ModReqInfo req;
            int errmaj, errmin;

            memset(&req, 0, sizeof(req));
            req.majorversion = 2;
            req.minorversion = 0;
            if (!LoadSubModule(pScrn->module, "exa", NULL, NULL, NULL, &req,
                               &errmaj, &errmin)) {
                LoaderErrorMsg(NULL, "exa", errmaj, errmin);
                VIAFreeRec(pScrn);
                return FALSE;
            }
#else
            if (!xf86LoadSubModule(pScrn, "exa")) {
                VIAFreeRec(pScrn);
                return FALSE;
            }
#endif /* EXA_VERSION */
            xf86LoaderReqSymLists(exaSymbols, NULL);
#endif /* VIA_HAVE_EXA */
            }
            if(!xf86LoadSubModule(pScrn, "xaa")) {
                VIAFreeRec(pScrn);
                return FALSE;
            }
            xf86LoaderReqSymLists(xaaSymbols, NULL);
    }

    if (!pVia->ForceSWCursor) {
        if (!xf86LoadSubModule(pScrn, "ramdac")) {
            VIAFreeRec(pScrn);
            return FALSE;
        }
        xf86LoaderReqSymLists(ramdacSymbols, NULL);
    }

    if (pVia->shadowFB) {
        if (!xf86LoadSubModule(pScrn, "shadowfb")) {
            VIAFreeRec(pScrn);
            return FALSE;
        }
        xf86LoaderReqSymLists(shadowSymbols, NULL);
    }

#ifdef VIA_RANDR12_SUPPORT
	if (pVia->useRandR) {
	    /*Check MB and get information of what device we can support*/
	    viaInitHwInfo(pVia);
	}
#endif

    /* Before we detect LVDS and TMDS chip, we have to assign I2C port*/
    pBIOSInfo->I2C_Port1 = pVia->I2C_Port1;
    pBIOSInfo->I2C_Port2 = pVia->I2C_Port2;
   
    if (!pVia->useRandR) {
        /* Determine whether to use auto detect. */
        if(*pScrn->display->modes == NULL) {
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Auto Detect Enable!\n"));        
            pBIOSInfo->IsAutoDectectEnable = TRUE;
        } else {
            pBIOSInfo->IsAutoDectectEnable = FALSE;        
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Auto Detect Disable!\n"));        
        }    

        pBIOSInfo->isPanelModeLine = FALSE;
        pBIOSInfo->ModeLineStatus = 0;
    
        /* Use DDC to detect the capability limitation of CRT monitor. */
        if (!VIAProbeMonitorLimitation(pScrn)) {
            VIAFreeRec(pScrn);
            return FALSE;
        } 
                        
        if (!VIAFilterMode(pScrn)) {
            VIAFreeRec(pScrn);
            return FALSE;
        }    

        if (!pBIOSInfo->isPanelModeLine) {
            if (pBIOSInfo->IsAutoDectectEnable)
                VIAFindMonPreferModeLine(pScrn);
            else
                /* Save User Mode Line for timing set. */
                VIAGetModeLineTiming(pScrn, pScrn->currentMode);        
        }
    } 

	/* Check Spread Spectrum. Or it will cause garbage when we sense the external encoder.
	   Actual project: On Qunta's IL1 case, this will cause the TTL LCD appears garbage.
	*/
	if (pVia->pChipInfo->biosIsSpreadSpectrum) {		 
		/* Disable spread spectrum temporarily, we will turn it on when set mode. */
		if ((pVia->Chipset == VIA_CX700) ||
			(pVia->Chipset == VIA_VX800) ||
			(pVia->Chipset == VIA_VX855)) {
			VGAOUT8(0x3c4, SR3D);
			VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xFE);
		} else {
			VGAOUT8(0x3c4, SR2C);
			VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xFE);
		}

		VGAOUT8(0x3c4, SR1E);
		VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xF7);
	}
	
#ifdef VIA_RANDR12_SUPPORT    
    /*============= For RandR v1.2 =======================*/    
    if (pVia->useRandR) {
        int             pitch;
        /* Load DDC module for EDID. */
        xf86LoadSubModule(pScrn, "ddc");           
        
        xf86SetDpi(pScrn, 0, 0);   
        
        xf86CrtcConfigInit (pScrn, &via_xf86crtc_config_funcs);
        xf86CrtcSetSizeRange (pScrn, 320, 200, 8192, 8192);     

        via_crtc_init(pScrn, 2);    
        via_output_init(pScrn);        

        if (!xf86InitialConfiguration(pScrn, FALSE)) {        
            xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
                "No valid initial configuration found\n");   
            return FALSE;
        }     

        pitch = CMDISP_ALIGN_TO(pScrn->virtualX * (pScrn->bitsPerPixel >> 3), 32);
        pScrn->displayWidth = pitch / (pScrn->bitsPerPixel >> 3);

    }
    /*============= End RandR v1.2 =======================*/
#endif

    /* After calling xf86ValidateModes(), pScrn->virtualX(Y) will get the final value of virtual size. */
    /* At RandR v1.2, pScrn->virtualX,Y will get value after xf86InitialConfiguration */

/*Refined Rotate process code, pBIOSInfo's item:VirtualX, VirtualY only get the original value of pScrn->virtualX/virtualY
 *    And NEVER change it's value in our code. It needs because the XV panning support for setting correct Clipping Windows.
 */
    pBIOSInfo->VirtualX = pScrn->virtualX;
    pBIOSInfo->VirtualY = pScrn->virtualY;

    /* Set up screen parameters. */
    pVia->Bpp = pScrn->bitsPerPixel >> 3;
    pVia->Bpl = pScrn->displayWidth * pVia->Bpp;
 
    if (pBIOSInfo->MergedFB) {
        /*to set virtul X,Y value while mergedfb*/
        if ((pBIOSInfo->Scrn2Position==viaRightOf)||
            (pBIOSInfo->Scrn2Position==viaLeftOf))
            pScrn->virtualX += pScrn->virtualX;

        if ((pBIOSInfo->Scrn2Position==viaAbove)||
            (pBIOSInfo->Scrn2Position==viaBelow))
            pScrn->virtualY += pScrn->virtualY;

        pScrn->displayWidth = pScrn->virtualX; 
    }

    if (!pVia->useRandR) {

        /* Detect TMDS Transmiter */
        if (VIATMDSIdentify(pBIOSInfo)) {
            if (pBIOSInfo->NoDDCValue) {            
                pBIOSInfo->TMDSSettingInfo.DFPSize = VIAGetModeIndex(pScrn->virtualX, pScrn->virtualY);
                VIAGetModeSizeByIndex(pBIOSInfo->TMDSSettingInfo.DFPSize, &pBIOSInfo->TMDSSettingInfo.PanelSizeH, &pBIOSInfo->TMDSSettingInfo.PanelSizeV);                        
            } else {
                VIAGetPanelInfo(pBIOSInfo);
            }
        }

        VIAPreInit_LVDS(pBIOSInfo);

        pBIOSInfo->ConnectedDevice = VIAGetDeviceDetect(pBIOSInfo);

        VIADeviceSelection(pScrn);

        VIASetDisplayPath(pScrn);
    }
        
    /* Check what type of cursor (SW/HW) to use. */
    VIACheckCursorTypeToUse(pScrn);            
    
    VIAUnmapMem(pScrn);

    return TRUE;
}


static Bool 
VIAEnterVT(int scrnIndex, int flags)
{
    DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIAEnterVT\n"));

    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr      pVia = VIAPTR(pScrn);
    VIAPtr      pVia0 = VIAPTR(pScrn0);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    vgaHWPtr hwp = VGAHWPTR(pScrn);
    vgaRegPtr   vgaSavePtr = &hwp->SavedReg;
    VIARegPtr   viaSavePtr = &pVia->SavedReg;
    Bool        ret;
    int i;
    miPointerScreenPtr  PointPriv;
    int x, y;

    if(pBIOSInfo->Chipset == VIA_CX700) {
        /* In SAMM mode, X and VT switch, with random large times, 
        * the Screen will covered by Vertical Line Garbages.
        * Called VIASave here to reduced it's probability.
        */
        pVia->myWaitIdle(pVia);
        VIASave(pScrn); 

        /*Fix on 3324 graphic can't resume
        *Theorically, we neend't to touch 0x3c3(switch of graphic system)
        */
        if(1 != VGAIN8(0x3c3))
            VGAOUT8(0x3c3,1);
    }

    if(pVia->VQEnable && pVia->VQStart)
        VIAEnableVQ(pScrn);

    /* FIXME: Rebind AGP memory here */
    /* FIXME: Unlock DRI here */

    vgaHWUnlock(hwp);

    /* If the screen is under the rotated situation, the OS consider that current mode is a 
       rotated size. For example: 768x1024. So when the OS want to set mode, it will transfer
       a rotated size to request the driver to set this mode(768x1024). But we should set display 
       timing according to non-rotated size.(e.g. 1024x768).
       So we have to convert the rotated size to the normal size.
    */ 
    /* If we just do SW/HW noRandR rotation 90/270 degree for 2D ONLY, we don't need to do this.
	 * While, if we need XV support for Rotation, we need to swap pScrn->virtualX/pScrn->virtualY,
	 * for XV path cliping window detect.
    */ 
	swap_height_width_for_CWorCCW(pScrn);

#if XORG_VERSION_CURRENT < XF86_VERSION_NUMERIC(1,5,99,0,0)||XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(7,0,0,0,0)
    /* This is really a patch. patch for ubuntu8.04 os has garbage when resume from S3
    it seems the ubuntu os's own behavior. When os behavior right, the patch can
    be removed.And this patch take no effect on other OS like FCX whose xorg version is > 7.0.
    but this patch has side effect to xorg<7.0,like suse10.1 suse10.2, when switch console,
    the cursor disppear. so we take the condision into consideration*/
    if (pVia->pScreensPublicInfo->UseHwCursor) {
#if XORG_VERSION_CURRENT <= XF86_VERSION_NUMERIC(2,0,0,0,0) && XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(1,4,99,0,0)
        PointPriv = (miPointerScreenPtr)dixLookupPrivate(&pScrn->pScreen->devPrivates, miPointerScreenKey);
#else
        extern int miPointerScreenIndex;
        PointPriv = pScrn->pScreen->devPrivates[miPointerScreenIndex].ptr;
#endif

#if XORG_VERSION_CURRENT <= XF86_VERSION_NUMERIC(2,0,0,0,0) && XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(1,4,0,0,0)
        miPointerGetPosition(inputInfo.pointer,&x, &y);
#else
     	miPointerPosition(&x, &y);
#endif
        PointPriv->spriteFuncs->SetCursor(pScrn->pScreen, 0, x, y);
    } 
#endif

    if (!pVia->IsSecondary) {
        /* 1. Restore first or some of BIOS settings will lose. */
        /* 2. Flags=TRUE implies decrease flick. When the system resume from
              suspend mode. LCD is switch too many times, so it cause eyes
              feel flick. But We don't need to enable LCD so many times.
              LCD panel will be enabled at the following setmode function.
        */
        VIARestore(pScrn, vgaSavePtr, viaSavePtr, TRUE);

        /*Clear FB with black color to avoid garbage caused by VIARestore*/
        memset(pVia->FBBase, 0x00, ((pScrn->displayWidth * pScrn->bitsPerPixel>>3) * pScrn->virtualY));

        /*Clear 3Dscaling buffer to avoid garbage*/
        if (pVia->DISP3DScalingBufferStart)
            memset(pVia->FBBase + pVia->DISP3DScalingBufferStart, 0x00, 
                DISP_3D_SCALING_BUFFER_SIZE*DISP_3D_SCALING_BUFNUM_ONESET*pVia->NumOfDevNeed3dScl);
    } else {
        /*Clear FB with black color to avoid garbage caused by VIARestore*/
        memset(pVia->FBBase, 0x00, ((pScrn->displayWidth * pScrn->bitsPerPixel>>3) * pScrn->virtualY));
    } 

    /* VT3353 New Registers */
    if (pVia->Chipset == VIA_VX800) {
        for (i = 0; i < 10; i++) {
             VGAOUT8(0x3c4, 0x66 + i);
             VGAOUT8(0x3c5, viaSavePtr->SRRegs[0x66 + i]);
        }

        for (i = 0; i < 3; i++) {
            VGAOUT8(0x3c4, 0x79 + i);
            VGAOUT8(0x3c5, viaSavePtr->SRRegs[0x79 + i]);
        }
 
        for (i = 0; i < 6; i++) {
            VGAOUT8(0x3c4, 0x70 + i);
            VGAOUT8(0x3c5, viaSavePtr->SRRegs[0x70 + i]);
        }
    }

#ifdef XF86DRI
    if (pVia->directRenderingEnabled 
#ifdef DRM_SAMM_VIA
        || pVia->drmSammEnabled 
#endif
        ) {
        VIADRIRingBufferInit(pScrn);
    }
#endif
    
    ret = VIAModeInit(pScrn, pScrn->currentMode);    
#ifdef VIA_RANDR12_SUPPORT
	if (pVia->useRandR) {
	    /* Initialize display engine*/
	    viaInitDispEngine(pVia);
		viaInitOutputRegSet(pScrn);
	    ret = xf86SetDesiredModes(pScrn);
	}
#endif
    
    /* Patch for APM suspend resume, HWCursor has garbage */
    if (!pVia->useRandR && pVia->pScreensPublicInfo->UseHwCursor) {
        DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "Restore Cursor Image!\n"));
        if(!pVia->IsSecondary) {
            if(pVia->HwIconImage)
                memcpy(pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIBufStart, pVia->HwIconImage, VIA_CURSOR_SIZE);
            if(pVia->HIScalingPrimImage)
                memcpy(pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIPrimScalingBufStart, pVia->HIScalingPrimImage, VIA_CURSOR_SIZE);
            if(pVia->HIScalingSecImage)
                memcpy(pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HISecScalingBufStart, pVia->HIScalingSecImage, VIA_CURSOR_SIZE);
        } else {
            if(pVia->HwIconImage)
                memcpy(pVia0->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIBufStart, pVia->HwIconImage, VIA_CURSOR_SIZE);
            if(pVia->HIScalingPrimImage)
                memcpy(pVia0->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIPrimScalingBufStart, pVia->HIScalingPrimImage, VIA_CURSOR_SIZE);
            if(pVia->HIScalingSecImage)
                memcpy(pVia0->FBBase + pVia->pScreensPublicInfo->CursorInfo.HISecScalingBufStart, pVia->HIScalingSecImage, VIA_CURSOR_SIZE);
        }        
        VIASETREG(VIA_REG_CURSOR_FG, pVia->pScreensPublicInfo->CursorInfo.CursorFG);
        VIASETREG(VIA_REG_CURSOR_BG, pVia->pScreensPublicInfo->CursorInfo.CursorBG);
        VIASETREG(VIA_REG_CURSOR_MODE, pVia->pScreensPublicInfo->CursorInfo.CursorMC);
        if(pVia->HwCursorImage) {
            xfree(pVia->HwCursorImage);
            pVia->HwCursorImage = NULL;
        }
        if(pVia->HwIconImage) {
            xfree(pVia->HwIconImage);
            pVia->HwIconImage = NULL;
        }
        if(pVia->HIScalingPrimImage) {
            xfree(pVia->HIScalingPrimImage);
            pVia->HIScalingPrimImage = NULL;
        }
        if(pVia->HIScalingSecImage) {
            xfree(pVia->HIScalingSecImage);
            pVia->HIScalingSecImage = NULL;
        }
        
        /*VIALoadCursorImage(pScrn, *pVia->CursorImage);*/
    }

    /* We need to initialize related registers about hardware icon again */
    /* when system resumes, or the cursor will become garbage. */
    VIAARGBCursorInit(pScrn);
    
    /* retore video status */
    if (!pVia->IsSecondary) {
        viaRestoreHqv(pScrn);
        viaRestoreVideo(pScrn);
    }
    
    VIAAdjustFrame(scrnIndex, pScrn->frameX0, pScrn->frameY0, 0);

    /* Insert a timer */
    if  ((pBIOSInfo->Is3DScalingEnable & DISP_3D_SCALING_ENABLE) ||
        ((pVia->IsHotkeyTimerEnabled) && (!pBIOSInfo->SAMM))) {
        if(!pVia->devicesTimer) {
            pVia->devicesTimer = TimerSet(NULL, 0, 30, VIASyncTimer, pScrn);
        }
    } else {
        if(pVia->devicesTimer) {
            TimerCancel(pVia->devicesTimer);
            pVia->devicesTimer=NULL;
        }
    }

    
    pVia->IsSuspending = FALSE;    /* System has resumed. */

    /* Revert to the rotated size.(e.g. 1024x768 -> 768x1024)*/
	swap_height_width_for_CWorCCW(pScrn);

    /* Release the DRM lock, or the DRI APs will be pending forever.*/
#ifdef XF86DRI
    if (pVia->directRenderingEnabled) {
        DRIUnlock(pScrn->pScreen);
    }    
#endif

    return ret;
}


static void 
VIALeaveVT(int scrnIndex, int flags)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    vgaHWPtr    hwp = VGAHWPTR(pScrn);
    VIAPtr      pVia = VIAPTR(pScrn);
    VIAPtr      pVia0 = VIAPTR(pScrn0);
    vgaRegPtr   vgaSavePtr = &hwp->SavedReg;
    VIARegPtr   viaSavePtr = &pVia->SavedReg;
    int i;
    
	DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIALeaveVT\n"));

    /* FIXME: take the DRI lock here to avoid accidents */
    /* FIXME: unbind the AGP memory ? */
    /* Get DRM Lock to avoid DRI APs run unexpected under non-X situation */
#ifdef XF86DRI
    if ((pVia->directRenderingEnabled)&&(!pVia->MemNEnough4EXA))
        DRILock(pScrn->pScreen, 0);
#endif

    /* Unload Timer */
    if (pVia->devicesTimer)
        TimerCancel(pVia->devicesTimer);

    pVia->devicesTimer = NULL; 

    /* Wait Hardware Engine idle to exit graphicd mode */
    WaitIdle();

    if (pVia->VQEnable) {
     /* if we use VQ, disable it before we exit */
        switch( pVia->Chipset ) { 
            case VIA_P4M890: 
            case VIA_K8M890:
                VIASETREG(0x41c, 0x00100000);
                VIASETREG(0x420, 0x74301000);
                break;
            default:	 
                VIASETREG(0x43c, 0x00fe0000);
                VIASETREG(0x440, 0x00000004);
                VIASETREG(0x440, 0x40008c0f);
                VIASETREG(0x440, 0x44000000);
                VIASETREG(0x440, 0x45080c04);
                VIASETREG(0x440, 0x46800408);
                break;
        }  
    }

    /* Save video status and turn off all video activities */
    if (!pVia->IsSecondary) {
        viaSaveHqv(pScrn);
        viaSaveVideo(pScrn);
    }
    
    /* Disable CBU HW Rotate. */
    if (pVia->IsHWRotateEnabled) 
        DisableCBUrotate(pScrn);
    /*end*/

    if (!pVia->useRandR && pVia->pScreensPublicInfo->UseHwCursor) {
        pVia->HwCursorImage = (unsigned char *)xcalloc(1, VIA_CURSOR_SIZE);
        pVia->HwIconImage = (unsigned char *)xcalloc(1, VIA_CURSOR_SIZE);
        pVia->HIScalingPrimImage = (unsigned char *)xcalloc(1, VIA_CURSOR_SIZE);
        pVia->HIScalingSecImage = (unsigned char *)xcalloc(1, VIA_CURSOR_SIZE);
        if (!pVia->IsSecondary) {
            if(pVia->HwIconImage)
                memcpy(pVia->HwIconImage, pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIBufStart, VIA_CURSOR_SIZE);
            if(pVia->HIScalingPrimImage)
                memcpy(pVia->HIScalingPrimImage, pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIPrimScalingBufStart, VIA_CURSOR_SIZE);
            if(pVia->HIScalingSecImage)
                memcpy(pVia->HIScalingSecImage, pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HISecScalingBufStart, VIA_CURSOR_SIZE);
        } else {
            if(pVia->HwIconImage)
                memcpy(pVia->HwIconImage, pVia0->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIBufStart, VIA_CURSOR_SIZE);
            if(pVia->HIScalingPrimImage)
                memcpy(pVia->HIScalingPrimImage, pVia0->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIPrimScalingBufStart, VIA_CURSOR_SIZE);
            if(pVia->HIScalingSecImage)
                memcpy(pVia->HIScalingSecImage, pVia0->FBBase + pVia->pScreensPublicInfo->CursorInfo.HISecScalingBufStart, VIA_CURSOR_SIZE);
        }
        pVia->pScreensPublicInfo->CursorInfo.CursorFG = (CARD32)VIAGETREG(VIA_REG_CURSOR_FG);
        pVia->pScreensPublicInfo->CursorInfo.CursorBG = (CARD32)VIAGETREG(VIA_REG_CURSOR_BG);
        pVia->pScreensPublicInfo->CursorInfo.CursorMC = (CARD32)VIAGETREG(VIA_REG_CURSOR_MODE);
    }

    memset(pVia->FBBase, 0x00, ((pScrn->displayWidth * pScrn->bitsPerPixel>>3) * pScrn->virtualY));

    /* FIX ME: For vt3353, some registers can't be restore in DRM module, it seems that
     * these registers be modified between DRM resume function and VIAEnterVT function
     * when using "suspend" button shipped with ubuntu 8.04.
     * So we save these registers here and restore them in VIAEnterVT.
     * These registers including: SR66~SR6F, SR70~SR75, SR79~SR7B.
     */
    if (pVia->Chipset == VIA_VX800) {
        for (i = 0; i < 10; i++) {
            VGAOUT8(0x3c4, 0x66 + i);
            viaSavePtr->SRRegs[0x66 + i] = VGAIN8(0x3c5);
        }

        for (i = 0; i < 6; i++) {
            VGAOUT8(0x3c4, 0x70 + i);
            viaSavePtr->SRRegs[0x70 + i] = VGAIN8(0x3c5);
        }

        for (i = 0; i < 3; i++) {
            VGAOUT8(0x3c4, 0x79 + i);
            viaSavePtr->SRRegs[0x79 + i] = VGAIN8(0x3c5);
        }
    }

#ifdef XF86DRI
    if (pVia->directRenderingEnabled 
#ifdef DRM_SAMM_VIA
        || pVia->drmSammEnabled
#endif
        )
        VIADRIRingBufferCleanup(pScrn);
#endif

    VIARestore(pScrn, vgaSavePtr, viaSavePtr, FALSE);
        
    pVia->IsSuspending = TRUE;     /* System will suspend. */
    pVia->IsVIAModeInitRunOnceDone = FALSE;
    

    /*To fix hang issue when switch VT using 3D desktop*/
    VGAOUT8(0x3c4, 0x32);
    VGAOUT8(0x3c5, 0x00);

    vgaHWLock(hwp);
}


static void 
VIASave(ScrnInfoPtr pScrn)
{
    vgaHWPtr        hwp = VGAHWPTR(pScrn);
    vgaRegPtr       vgaSavePtr = &hwp->SavedReg;
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    VIARegPtr       save = &pVia->SavedReg;
    int             vgaCRIndex, vgaCRReg, vgaIOBase;
    int             i;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASave\n"));

    if (pVia->useRandR) {
#ifdef VIA_RANDR12_SUPPORT
        vgaHWProtect(pScrn, TRUE);
        
        if (xf86IsPrimaryPci(pVia->PciInfo)) {
            vgaHWSave(pScrn, vgaSavePtr, VGA_SR_ALL);
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                  "Primary Adapter! saving VGA_SR_ALL !!\n"));            
        } else {
            vgaHWSave(pScrn, vgaSavePtr, VGA_SR_MODE);
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                  "Non-Primary Adapter! saving VGA_SR_MODE only !!\n"));
        }

        /* Unlock Extended Regs */
        viaWriteVgaIoBits(REG_SR01, 0x01, BIT0);        
        /* Unlock CRTC register protect */
        viaWriteVgaIoBits(REG_CR47, 0x00, BIT0);

        /* Save Sequencer regs: from SR00 to SRFF */
        i = 0;
        while (1) {
            /* We have saved SR1A in VIAPreInit(). */
            if (i != 0x1A)
                save->SRRegs[i] = viaReadVgaIo(i + REG_SR00);

            if (i == 0xFF)
                break;
            else
                i++;
        }

        /* Save CRTC regs: from CR00 to CRFF */
        i = 0;
        while (1) {
            /* We have saved CR08 and CR09 in VIAPreInit(). */
            if ((i != 0x08) && (i != 0x09))
                save->CRTCRegs[i] = viaReadVgaIo(i + REG_CR00);

            if (i == 0xFF)
                break;
            else
                i++;
        }
               
        xf86CrtcConfigPtr   xf86_config = XF86_CRTC_CONFIG_PTR(pScrn);
        for (i = 0; i < xf86_config->num_output; i++) {
            xf86OutputPtr output = xf86_config->output[i];
            if (output->funcs->save)
                (*output->funcs->save)(output);
        }

        /* Saving HW Cursor state */
        save->dwCursorMode = VIAGETREG(VIA_REG_CURSOR_MODE);
        save->dwCursorPOS = VIAGETREG(VIA_REG_CURSOR_POS);
        save->dwCursorORG = VIAGETREG(VIA_REG_CURSOR_ORG);
        save->dwCursorBG = VIAGETREG(VIA_REG_CURSOR_BG);
        save->dwCursorFG = VIAGETREG(VIA_REG_CURSOR_FG);

        vgaHWProtect(pScrn, FALSE);
        
#endif
    } else {
        if(pVia->IsSecondary) {
            DevUnion* pPriv;
            VIAEntPtr pVIAEnt;
            VIAPtr   pVia1;
            vgaHWPtr hwp1;
            pPriv = xf86GetEntityPrivate(pScrn->entityList[0],
                  gVIAEntityIndex);
            pVIAEnt = pPriv->ptr;
            hwp1 = VGAHWPTR(pVIAEnt->pPrimaryScrn);
            pVia1 = VIAPTR(pVIAEnt->pPrimaryScrn);
            hwp->SavedReg = hwp1->SavedReg;
            pVia->SavedReg = pVia1->SavedReg;
        } else {
            vgaHWProtect(pScrn, TRUE);

            if (xf86IsPrimaryPci(pVia->PciInfo)) {
                vgaHWSave(pScrn, vgaSavePtr, VGA_SR_ALL);
                DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                                 "Primary Adapter! saving VGA_SR_ALL !!\n"));
            } else {
                vgaHWSave(pScrn, vgaSavePtr, VGA_SR_MODE);
                DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                                 "Non-Primary Adapter! saving VGA_SR_MODE only !!\n"));
            }

            vgaIOBase = hwp->IOBase;
            vgaCRReg = vgaIOBase + 5;
            vgaCRIndex = vgaIOBase + 4;

            /* Unlock Extended Regs */
            VGAOUT8(0x3c4, 0x10);
            VGAOUT8(0x3c5, VGAIN8(0x3c5) | 0x01);
            /* Unlock CRTC register protect */
            VGAOUT8(0x3d4, 0x47);
            VGAOUT8(0x3d5, VGAIN8(0x3d5) & ~0x01);

            /* Save Sequencer regs: from SR00 to SRFF */
            i = 0;
            
            while (1) {
                /* We have saved SR1A in VIAPreInit(). */
                if (i != 0x1A) { 
                    VGAOUT8(0x3C4, i);
                    save->SRRegs[i] = VGAIN8(0x3C5);
                }

                if (i == 0xFF)
                    break;
                else
                    i++;
            }
            
            /* Save CRTC regs: from CR00 to CRFF */
            i = 0;
            while (1) {
                /* We have saved CR08 and CR09 in VIAPreInit(). */
                if ((i != 0x08) && (i != 0x09)) {
                    VGAOUT8(vgaCRIndex, i);
                    save->CRTCRegs[i] = VGAIN8(vgaCRReg);
                }

                if (i == 0xFF)
                    break;
                else
                    i++;
            }

            /* Save for VT1636 LVDS: */
            if (pBIOSInfo->LVDSSettingInfo.ChipID == VIA_VT1636)            
                VIASaveLVDS_VT1636(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo), save);
            
            else if(pBIOSInfo->LVDSSettingInfo2.ChipID == VIA_VT1636)            
                VIASaveLVDS_VT1636(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo2), save);            

            if (!pVia->ModeStructInit) {
                vgaHWCopyReg(&hwp->ModeReg, vgaSavePtr);
                pVia->ModeStructInit = TRUE;
            }
            
            /* Saving HW Cursor state */
            save->dwCursorMode = VIAGETREG(VIA_REG_CURSOR_MODE);
            save->dwCursorPOS = VIAGETREG(VIA_REG_CURSOR_POS);
            save->dwCursorORG = VIAGETREG(VIA_REG_CURSOR_ORG);
            save->dwCursorBG = VIAGETREG(VIA_REG_CURSOR_BG);
            save->dwCursorFG = VIAGETREG(VIA_REG_CURSOR_FG);
            
            vgaHWProtect(pScrn, FALSE);
        }
    }
    return;
}

static void 
VIARestore(ScrnInfoPtr pScrn, vgaRegPtr vgaSavePtr, VIARegPtr restore, int flags)
{
	vgaHWPtr        hwp = VGAHWPTR(pScrn);
	VIAPtr          pVia = VIAPTR(pScrn);
	VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
	int             vgaCRIndex, vgaCRReg, vgaIOBase;
	int             i;
    Bool            deFlick = flags;
    
	DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIARestore\n"));
	vgaIOBase = hwp->IOBase;
	vgaCRIndex = vgaIOBase + 4;
	vgaCRReg = vgaIOBase + 5;

	if (pVia->useRandR) {
#ifdef VIA_RANDR12_SUPPORT
		xf86CrtcConfigPtr	xf86_config = XF86_CRTC_CONFIG_PTR(pScrn);
		/* Disable outputs */
		for (i = 0; i < xf86_config->num_output; i++) {
		   xf86OutputPtr   output = xf86_config->output[i];
		   output->funcs->dpms(output, DPMSModeOff);
		}
		
		/* Disable crtc */
		for (i = 0; i < xf86_config->num_crtc; i++) {
		   xf86CrtcPtr crtc = xf86_config->crtc[i];
		   crtc->funcs->dpms(crtc, DPMSModeOff);
		}
		
		vgaHWProtect(pScrn, TRUE);
		
		/* Unlock Extended Regs */
		viaWriteVgaIoBits(REG_SR01, 0x01, BIT0);
		/* Unlock CRTC register protect */
		viaWriteVgaIoBits(REG_CR47, 0x00, 0xFE);

		/*=* CR6A, CR6B, CR6C must be reset before restore
			standard vga regs, or system will be hang. *=*/
		/*=* Reset IGA2 channel before disable IGA2 channel
			or it may cause some line garbage. *=*/
		/* Modify for the sequence issue of enable and disable */
		/* second display channel. */
		viaWriteVgaIoBits(REG_CR6A, 0x00, BIT6); /* Set CR6A[6] to 0. */
		viaWriteVgaIoBits(REG_CR6A, 0x00, BIT7); /* Set CR6A[7] to 0. */
		viaWriteVgaIoBits(REG_CR6A, 0x40, BIT6); /* Set CR6A[6] to 1. */
		viaWriteVgaIoBits(REG_CR6A, 0x00, 0x3F); /* Set CR6A[5:0] to 0. */

		viaWriteVgaIoBits(REG_CR6B, 0x00, 0xFF); /* Set CR6B[7:0] to 0. */
		viaWriteVgaIoBits(REG_CR6C, 0x00, 0xFF); /* Set CR6C[7:0] to 0. */

		/* Gamma must disable before restore pallette */
		viaWriteVgaIoBits(REG_CR33, 0x00, BIT7); /* Set CR33[7] to 0. */

		/* restore the standard vga regs */
		if (xf86IsPrimaryPci(pVia->PciInfo))
		   vgaHWRestore(pScrn, vgaSavePtr, VGA_SR_ALL);
		else
		   vgaHWRestore(pScrn, vgaSavePtr, VGA_SR_MODE);

		/* restore Sequencer regs: From SR14 to SR3F  */		 
		for (i=0x14; i<0x40; i++) {
			viaWriteVgaIoBits(i+REG_SR00, restore->SRRegs[i], 0xFF);
		} 

		viaWriteVgaIoBits(REG_SR42, restore->SRRegs[0x42], 0xFF);
		viaWriteVgaIoBits(REG_SR4F, restore->SRRegs[0x4F], 0xFF);
		viaWriteVgaIoBits(REG_SR50, restore->SRRegs[0x50], 0xFF);
		viaWriteVgaIoBits(REG_SR57, restore->SRRegs[0x57], 0xFF);
		viaWriteVgaIoBits(REG_SR5D, restore->SRRegs[0x5D], 0xFF);

		/* DVP1 Clock and Data Pads Driving: */
		viaWriteVgaIoBits(REG_SR65, restore->SRRegs[0x65], 0xFF);

		/*=* restore VCK, LCDCK and ECK *=*/
		/* VCK: */
		viaWriteVgaIoBits(REG_SR44, restore->SRRegs[0x44], 0xFF);
		viaWriteVgaIoBits(REG_SR45, restore->SRRegs[0x45], 0xFF);
		viaWriteVgaIoBits(REG_SR46, restore->SRRegs[0x46], 0xFF);
		/* Reset VCK PLL */
		viaWriteVgaIoBits(REG_SR40, 0x02, BIT1);	/* Set SR40[1] to 1 */
		viaWriteVgaIoBits(REG_SR40, 0x00, BIT1);	/* Set SR40[1] to 0 */

		/* LCK: */
		viaWriteVgaIoBits(REG_SR4A, restore->SRRegs[0x4A], 0xFF);
		viaWriteVgaIoBits(REG_SR4B, restore->SRRegs[0x4B], 0xFF);
		viaWriteVgaIoBits(REG_SR4C, restore->SRRegs[0x4C], 0xFF);
		/* Reset LCK PLL */
		viaWriteVgaIoBits(REG_SR40, 0x04, BIT2);	/* Set SR40[2] to 1 */
		viaWriteVgaIoBits(REG_SR40, 0x00, BIT2);	/* Set SR40[2] to 0 */

		/* ECK: */
		viaWriteVgaIoBits(REG_SR47, restore->SRRegs[0x47], 0xFF);
		viaWriteVgaIoBits(REG_SR48, restore->SRRegs[0x48], 0xFF);
		viaWriteVgaIoBits(REG_SR49, restore->SRRegs[0x49], 0xFF);
		/* Reset ECK PLL */
		viaWriteVgaIoBits(REG_SR40, 0x01, BIT0);	/* Set SR40[0] to 1 */
		viaWriteVgaIoBits(REG_SR40, 0x00, BIT0);	/* Set SR40[0] to 0 */
		  
		/* Restore CRTC controller extended regs: */
		viaWriteVgaIoBits(REG_CR08, restore->CRTCRegs[0x08], 0xFF);
		viaWriteVgaIoBits(REG_CR09, restore->CRTCRegs[0x09], 0xFF);

		viaWriteVgaIoBits(REG_CR13, restore->CRTCRegs[0x13], 0xFF);
		viaWriteVgaIoBits(REG_CR30, restore->CRTCRegs[0x30], 0xFF);
		viaWriteVgaIoBits(REG_CR31, restore->CRTCRegs[0x31], 0xFF);
		viaWriteVgaIoBits(REG_CR32, restore->CRTCRegs[0x32], 0xFF);
		viaWriteVgaIoBits(REG_CR33, restore->CRTCRegs[0x33], 0xFF);

		/* From CR35 to CR47 */
		i = 0x35;
		while (1) {
			viaWriteVgaIoBits(i+REG_CR00, restore->CRTCRegs[i], 0xFF);
			if (i == 0x47)
			   break;
			else
			   i++;
		}

		/* Starting Address: */
		viaWriteVgaIoBits(REG_CR0C, restore->CRTCRegs[0x0C], 0xFF);
		viaWriteVgaIoBits(REG_CR0D, restore->CRTCRegs[0x0D], 0xFF);
		viaWriteVgaIoBits(REG_CR48, restore->CRTCRegs[0x48], 0xFF);
		viaWriteVgaIoBits(REG_CR34, restore->CRTCRegs[0x34], 0xFF);

		/* From CR49 to CRFF */
		for (i = 0x49; i < 0x100; i++) {
			if (i == 0x91) {
				/* 
					LCD Panel could use software power sequence, so we should resotore it 
					individually to avoid incorrect enable LCD.
				*/
			} else {
				viaWriteVgaIoBits(i+REG_CR00, restore->CRTCRegs[i], 0xFF);
			}
		}
		
		/* Restore outputs */
		for (i = 0; i < xf86_config->num_output; i++) {
			xf86OutputPtr   output = xf86_config->output[i];
			if (output->funcs->restore)
				output->funcs->restore(output);
		}
		
		/* Restore CR91 after lvds restore*/
		viaWriteVgaIoBits(REG_CR91, restore->CRTCRegs[0x91], 0xFF);

		/* Reset clock */
		viaWriteMiscIo(viaReadMiscIo());
		
		/* Restore HW Cursor state */
		VIASETREG(VIA_REG_CURSOR_MODE, restore->dwCursorMode);
		VIASETREG(VIA_REG_CURSOR_POS, restore->dwCursorPOS);
		VIASETREG(VIA_REG_CURSOR_ORG, restore->dwCursorORG);
		VIASETREG(VIA_REG_CURSOR_BG, restore->dwCursorBG);
		VIASETREG(VIA_REG_CURSOR_FG, restore->dwCursorFG);

		vgaHWProtect(pScrn, FALSE);
		return;
		
#endif		
	} else {
		/* Disable output device avoid set mode garbage */
		if (!pVia->IsSecondary) {
		    VIADisableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));

		    if (pBIOSInfo->LVDSSettingInfo2.ChipID)
		        VIADisableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo2));
		    
		    VIADisableDFP(pBIOSInfo);
		}
		
		vgaHWProtect(pScrn, TRUE);

		/* Unlock Extended Regs */
		VGAOUT8(0x3c4, 0x10);
		VGAOUT8(0x3c5, VGAIN8(0x3c5) | 0x01);
		/* Unlock CRTC register protect */
		VGAOUT8(0x3d4, 0x47);
		VGAOUT8(0x3d5, VGAIN8(0x3d5) & ~0x01);    
		  
		/*[06.07.2006] Carrie: Fix CRT showing garbage, when switch X to console on EPIA-EN
		 Solution: turn off CRT*/
		VGAOUT8(0x3d4, 0x36);
		VGAOUT8(0x3d5, VGAIN8(0x3d5) | 0x30);

		/*=* CR6A, CR6B, CR6C must be reset before restore
		    standard vga regs, or system will be hang. *=*/
		/*=* Reset IGA2 channel before disable IGA2 channel
		    or it may cause some line garbage. *=*/
		/* Modify for the sequence issue of enable and disable */
		/* second display channel. */
		VGAOUT8(0x3d4, 0x6A);
		VGAOUT8(0x3d5, VGAIN8(0x3d5) & 0xBF);   /* Set CR6A[6] to 0. */
		VGAOUT8(0x3d5, VGAIN8(0x3d5) & 0x7F);   /* Set CR6A[7] to 0. */
		VGAOUT8(0x3d5, VGAIN8(0x3d5) | 0x40);   /* Set CR6A[6] to 1. */
		VGAOUT8(0x3d5, VGAIN8(0x3d5) & 0xC0);   /* Set CR6A[5:0] to 0. */

		VGAOUT8(0x3d4, 0x6B);
		VGAOUT8(0x3d5, 0);
		VGAOUT8(0x3d4, 0x6C);
		VGAOUT8(0x3d5, 0);
   
		/* Gamma must disable before restore pallette */
		VGAOUT8(0x3d4, 0x33);
		VGAOUT8(0x3d5, VGAIN8(0x3d5) & 0x7F);


		/* restore the standard vga regs */
		if (xf86IsPrimaryPci(pVia->PciInfo))
		   vgaHWRestore(pScrn, vgaSavePtr, VGA_SR_ALL);
		else
		   vgaHWRestore(pScrn, vgaSavePtr, VGA_SR_MODE);


		/* Disable Down Scaling Function. */
		VIADisableDownScaling(pScrn);

		/* restore Sequencer regs: From SR14 to SR3F  */         
	    for (i=0x14; i<0x40; i++) {
	        VGAOUT8(0x3C4, i);
	        VGAOUT8(0x3C5, restore->SRRegs[i]);             
	    } 

		VGAOUT8(0x3C4, SR42);
		VGAOUT8(0x3C5, restore->SRRegs[0x42]);
		VGAOUT8(0x3C4, SR4F);
		VGAOUT8(0x3C5, restore->SRRegs[0x4F]);
		VGAOUT8(0x3C4, SR50);
		VGAOUT8(0x3C5, restore->SRRegs[0x50]);
		VGAOUT8(0x3C4, SR57);
		VGAOUT8(0x3C5, restore->SRRegs[0x57]);
		VGAOUT8(0x3C4, SR5D);
		VGAOUT8(0x3C5, restore->SRRegs[0x5D]);

		/* DVP1 Clock and Data Pads Driving: */
		VGAOUT8(0x3C4, SR65);
		VGAOUT8(0x3C5, restore->SRRegs[0x65]);

		/*=* restore VCK, LCDCK and ECK *=*/
		/* VCK: */
		VGAOUT8(0x3c4, SR44);
		VGAOUT8(0x3c5, restore->SRRegs[0x44]);
		VGAOUT8(0x3c4, SR45);
		VGAOUT8(0x3c5, restore->SRRegs[0x45]);
		VGAOUT8(0x3c4, SR46);
		VGAOUT8(0x3c5, restore->SRRegs[0x46]);
		/* Reset VCK PLL */
		VGAOUT8(0x3c4, SR40);
		VGAOUT8(0x3c5, VGAIN8(0x3c5) | 0x02);    /* Set SR40[1] to 1 */
		VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xFD);    /* Set SR40[1] to 0 */

		/* LCK: */
		VGAOUT8(0x3c4, SR4A);
		VGAOUT8(0x3c5, restore->SRRegs[0x4A]);
		VGAOUT8(0x3c4, SR4B);
		VGAOUT8(0x3c5, restore->SRRegs[0x4B]);
		VGAOUT8(0x3c4, SR4C);
		VGAOUT8(0x3c5, restore->SRRegs[0x4C]);
		/* Reset LCK PLL */
		VGAOUT8(0x3c4, SR40);
		VGAOUT8(0x3c5, VGAIN8(0x3c5) | 0x04);    /* Set SR40[2] to 1 */
		VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xFB);    /* Set SR40[2] to 0 */

		/* ECK: */
		VGAOUT8(0x3c4, SR47);
		VGAOUT8(0x3c5, restore->SRRegs[0x47]);
		VGAOUT8(0x3c4, SR48);
		VGAOUT8(0x3c5, restore->SRRegs[0x48]);
		VGAOUT8(0x3c4, SR49);
		VGAOUT8(0x3c5, restore->SRRegs[0x49]);
		/* Reset ECK PLL */
		VGAOUT8(0x3c4, SR40);
		VGAOUT8(0x3c5, VGAIN8(0x3c5) | 0x01);    /* Set SR40[0] to 1 */
		VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xFE);    /* Set SR40[0] to 0 */
	      
		/* Restore CRTC controller extended regs: */

		VGAOUT8(vgaCRIndex, CR08);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x08]);
		VGAOUT8(vgaCRIndex, CR09);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x09]);

		VGAOUT8(vgaCRIndex, CR13);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x13]);
		VGAOUT8(vgaCRIndex, CR30);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x30]);
		VGAOUT8(vgaCRIndex, CR31);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x31]);
		VGAOUT8(vgaCRIndex, CR32);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x32]);
		VGAOUT8(vgaCRIndex, CR33);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x33]);

		/* From CR35 to CR47 */
		i = 0x35;

		while (1) {
			VGAOUT8(vgaCRIndex, i);
			VGAOUT8(vgaCRReg, restore->CRTCRegs[i]);

			if (i == 0x47)
			   break;
			else
			   i++;
		}

		/* Starting Address: */
		VGAOUT8(vgaCRIndex, CR0C);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x0C]);
		VGAOUT8(vgaCRIndex, CR0D);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x0D]);
		VGAOUT8(vgaCRIndex, CR48);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x48]);
		VGAOUT8(vgaCRIndex, CR34);
		VGAOUT8(vgaCRReg, restore->CRTCRegs[0x34]);

		/* From CR49 to CRFF */
		for (i = 0x49; i < 0x100; i++) {
			if (i == 0x91) {
			    /* 
			        LCD Panel could use software power sequence, so we should resotore it 
			        individually to avoid incorrect enable LCD.
			    */
			} else {
				VGAOUT8(vgaCRIndex, i);
				VGAOUT8(vgaCRReg, restore->CRTCRegs[i]);
			}
		}
	   
		/* Restore for VT1636 LVDS: */
		if (pBIOSInfo->LVDSSettingInfo.ChipID == VIA_VT1636)           
			VIARestoreLVDS_VT1636(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo), restore);           
		else if(pBIOSInfo->LVDSSettingInfo2.ChipID == VIA_VT1636)           
			VIARestoreLVDS_VT1636(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo2), restore);           

		if (pVia->pChipInfo->biosActiveDev & VIA_DEVICE_LCD) {

            if (!deFlick) {
                /* To do this will affect the original CMOS settings for LVDS. */
                /* I think there is no need to do this for Integrated LVDS because it seems no sequence */
                /* issue for this transmitter. */
                if (pBIOSInfo->LVDSSettingInfo.ChipID != VIA_INTEGRATED_LVDS)
                    VIAEnableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));
                else
                    VIASWPowerSequenceON(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));
            }
            
			/* Patch for the problem: When BIOS enable Spread Spectrum, */
			/* Spectrum IO selected bit (SR2C[0]) should be enabled, too, or the screen will scramble. */
			if (pVia->pChipInfo->biosIsSpreadSpectrum) {
			    if ((pBIOSInfo->Chipset == VIA_CX700) ||
			        (pBIOSInfo->Chipset == VIA_VX800) ||
			        (pBIOSInfo->Chipset == VIA_VX855)) {
			        VGAOUT8(0x3c4, SR3D);
			        VGAOUT8(0x3c5, VGAIN8(0x3c5) | BIT0);
			        VGAOUT8(0x3c4, SR1E);
			        VGAOUT8(0x3c5, VGAIN8(0x3c5) | BIT3);
			    } else {
			        VGAOUT8(0x3c4, SR2C);
			        VGAOUT8(0x3c5, VGAIN8(0x3c5) | BIT0);
			        VGAOUT8(0x3c4, SR1E);
			        VGAOUT8(0x3c5, VGAIN8(0x3c5) | BIT3);
			    }        
			}
		}

        if (!deFlick) {
            /* Use Software power-sequence to turn on TTL-LCD. */
            if (pBIOSInfo->Chipset >= VIA_VX800 &&
               (pBIOSInfo->LVDSSettingInfo.DIPort & VIA_DI_TTL) &&
                ((restore->CRTCRegs[0x91] & 0x13) == 0x13))
                VIAEnableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));
            else {
                VGAOUT8(vgaCRIndex, CR91);
                VGAOUT8(vgaCRReg, restore->CRTCRegs[CR91]);
            }
        }
        
		/* Reset clock */
		VGAOUT8(0x3c2, VGAIN8(0x3cc));
   
		/* Restore HW Cursor state */
		VIASETREG(VIA_REG_CURSOR_MODE, restore->dwCursorMode);
		VIASETREG(VIA_REG_CURSOR_POS, restore->dwCursorPOS);
		VIASETREG(VIA_REG_CURSOR_ORG, restore->dwCursorORG);
		VIASETREG(VIA_REG_CURSOR_BG, restore->dwCursorBG);
		VIASETREG(VIA_REG_CURSOR_FG, restore->dwCursorFG);

		/*[06.7.2006] Carrie: Fix CRT showing garbage, when switch X to console on EPIA-EN
		Solution: turn on CRT*/
		if (pVia->pChipInfo->biosActiveDev & VIA_DEVICE_CRT1) {
			VGAOUT8(0x3d4, 0x36);
			VGAOUT8(0x3d5, VGAIN8(0x3d5) & 0xCF);
		}

		vgaHWProtect(pScrn, FALSE);
		return;
	}  
}


static void VIAWriteMode(ScrnInfoPtr pScrn, vgaRegPtr vgaSavePtr)
{
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAWriteMode\n"));
	
    /* Set up the mode.  Don't clear video RAM. */
    if (pVia->IsSecondary)
        VIASetModeForMHS(pBIOSInfo);
    else
        VIASetMode(pBIOSInfo);   

    if((pBIOSInfo->s3utility==TRUE)&&(pBIOSInfo->SAMM)) {
        if(pVia->ActiveDevice & VIA_DEVICE_CRT1)
            VIACRTEnable();
                    
        if(pVia->ActiveDevice & VIA_DEVICE_DFP)
            VIAEnableDFP(pBIOSInfo);

        if(pVia->ActiveDevice & VIA_DEVICE_LCD)
            VIAEnableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));
    }

    /* Enable down scaling function. */
    if (pBIOSInfo->IsDownScaleEnable) {
        if (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD)
            VIASetDownScalingEngineReg(pScrn, pBIOSInfo->LVDSSettingInfo.IGAPath);
        else if (pBIOSInfo->ActiveDevice & VIA_DEVICE_DFP)
            VIASetDownScalingEngineReg(pScrn, pBIOSInfo->TMDSSettingInfo.IGAPath);
    } 
    else {
        if(!pVia->IsSecondary)
            /* When we switch device from DVI only to CRT only, the down-scaling function have to be disabled. */
            VIADisableDownScaling(pScrn);
    }
        
    /* Restore the DAC.*/
    if (pBIOSInfo->FirstInit )
        vgaHWRestore(pScrn, vgaSavePtr, VGA_SR_CMAP);

    /* 2D, 3D Engine only need to initial once. */
    if (pBIOSInfo->FirstInit) {
        /* Enable the graphics engine. */
        if (!pVia->NoAccel)
            VIAInitialize2DEngine(pScrn);

#ifdef XF86DRI
        VIAInitialize3DEngine(pScrn);
#endif        
    }

    pBIOSInfo->s3utility=FALSE;
    pBIOSInfo->FirstInit = FALSE;
    
    return;
}


static Bool VIAMapMMIO(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    vgaHWPtr hwp;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAMapMMIO\n"));
	/*3353A0 and 3353A1 MMIO use Bar2*/
	if ((pVia->Chipset == VIA_VX800) && 
		(VIAGetRevisionOfVX800() == REVISION_VX800_A))
    	pVia->MmioBase = MEMBASE(pVia->PciInfo, 2);
	else
	    pVia->MmioBase = MEMBASE(pVia->PciInfo, 1);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_PROBED,
               "mapping MMIO @ 0x%lx with size 0x%x\n",
               pVia->MmioBase, VIA_MMIO_REGSIZE));

    /*Notice: pci_device_map_range will return error if there is already a map region
                which base and size are the same as what you want to map. So in
                SAMM case, just map these regions only once.*/
    /*Map MMIO*/                
#if XSERVER_LIBPCIACCESS
    pci_device_map_range (pVia->PciInfo,
                          pVia->MmioBase,
                          VIA_MMIO_REGSIZE,
                          PCI_DEV_MAP_FLAG_WRITABLE,
                          (void **) &pVia->MapBase);
#else
    pVia->MapBase = xf86MapPciMem(pScrn->scrnIndex,
                                  VIDMEM_MMIO,
                                  pVia->PciTag,
                                  pVia->MmioBase,
                                  VIA_MMIO_REGSIZE);
#endif
    pBIOSInfo->MapBase = pVia->MapBase;

    /*Map Blit space*/
    MMIOMapBase = pVia->MapBase + 0x8000;
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_PROBED,
               "mapping BitBlt MMIO @ 0x%lx with size 0x%x\n",
               pVia->MmioBase + VIA_MMIO_BLTBASE, VIA_MMIO_BLTSIZE));

#if XSERVER_LIBPCIACCESS
    pci_device_map_range (pVia->PciInfo,
                   pVia->MmioBase + VIA_MMIO_BLTBASE,
                   VIA_MMIO_BLTSIZE,
                   PCI_DEV_MAP_FLAG_WRITABLE,
                   (void **) &pVia->BltBase);
#else
    pVia->BltBase = xf86MapPciMem(pScrn->scrnIndex, VIDMEM_MMIO, pVia->PciTag,
                                  pVia->MmioBase + VIA_MMIO_BLTBASE,
                                  VIA_MMIO_BLTSIZE);
#endif

    if (!pVia->MapBase || !pVia->BltBase) {
        xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
                   "Internal error: cound not map registers\n");
        return FALSE;
    }

    /* Memory mapped IO for Video Engine */
    pVia->VidMapBase = pVia->MapBase + 0x200;
    
    VIAEnableMMIO(pScrn);
    hwp = VGAHWPTR(pScrn);
    vgaHWGetIOBase(hwp);

    if (!vgaHWMapMem(pScrn))
        return FALSE;

    return TRUE;
}


static Bool 
VIAMapFB(ScrnInfoPtr pScrn)
{
    DevUnion* pPriv;
    VIAEntPtr pVIAEnt;
    VIAPtr    pVia, pVia0;
    pPriv =xf86GetEntityPrivate(pScrn->entityList[0],gVIAEntityIndex);
    pVIAEnt = pPriv->ptr;
    pVia0 = VIAPTR(xf86Screens[0]);
    pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAMapFB\n"));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_PROBED,
               "mapping framebuffer @ 0x%lx with size 0x%lx\n",
               pVia->ScreenBase, pVia->videoRambytes));

    if (!pVia->IsSecondary) {
        if (pVia->videoRambytes) {
#if XSERVER_LIBPCIACCESS
            /*Call PCI Map for Graphic Only ONE Time*/
		    pci_device_map_range(pVia->PciInfo, pVia->ScreenBase, pVia->pScreensPublicInfo->VRamSize,
			                     PCI_DEV_MAP_FLAG_WRITABLE | PCI_DEV_MAP_FLAG_WRITE_COMBINE,
					             (void **)&pVia->FBBase);
#else
		    pVia->FBBase = xf86MapPciMem(pScrn->scrnIndex, VIDMEM_FRAMEBUFFER,
			                             pVia->PciTag, pVia->ScreenBase,
									     pVia->pScreensPublicInfo->VRamSize);
#endif
		    pBIOSInfo->FBBase = pVia->FBBase;
		    pBIOSInfo->videoRambytes = pVia->videoRambytes;

            if (!pVia->FBBase) {
                xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
                           "Internal error: could not map framebuffer\n");
                return FALSE;
            }

            pVia->FBFreeStart = (pScrn->displayWidth * pScrn->bitsPerPixel >> 3) * pScrn->virtualY;        
            pVia->FBFreeEnd = pVia->videoRambytes;
    
            pScrn->fbOffset = 0;

            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_PROBED,
                   "Frame buffer start: %p, free start: 0x%x end: 0x%x\n",
                   pVia->FBBase, pVia->FBFreeStart, pVia->FBFreeEnd));
        }
    }
    else {   /*pVia->IsSecondary*/
        /*Get PCI Map correct Offset for Screen 1*/
        pVia->FBBase = pVia0->FBBase + pVia0->videoRambytes;
        pBIOSInfo->FBBase = pVia0->FBBase + pVia0->videoRambytes;
        pBIOSInfo->videoRambytes = pVia->videoRambytes;

        pVia->FBFreeStart = (pScrn->displayWidth * pScrn->bitsPerPixel >> 3) * pScrn->virtualY;
        pVia->FBFreeEnd = pVia->videoRambytes;         
            
        pScrn->fbOffset = pVIAEnt->pPrimaryScrn->videoRam << 10;
    }

    pScrn->memPhysBase = MEMBASE(pVia->PciInfo, 0);

    return TRUE;
}


static void 
VIAUnmapMem(ScrnInfoPtr pScrn)
{
    VIAPtr pVia;

    pVia = VIAPTR(pScrn);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAUnmapMem\n"));

    if (pVia->MapBase) {
#if XSERVER_LIBPCIACCESS
		pci_device_unmap_range (pVia->PciInfo, pVia->MapBase, 
						VIA_MMIO_REGSIZE);
#else
		xf86UnMapVidMem(pScrn->scrnIndex, (pointer)pVia->MapBase,
						VIA_MMIO_REGSIZE);
#endif
		pVia->MapBase = NULL;
    }

    if (pVia->BltBase) {
#if XSERVER_LIBPCIACCESS
		pci_device_unmap_range (pVia->PciInfo, pVia->BltBase, 
						VIA_MMIO_BLTSIZE);
#else
		xf86UnMapVidMem(pScrn->scrnIndex, (pointer)pVia->BltBase,
						VIA_MMIO_BLTSIZE);
#endif
		pVia->BltBase = NULL;
    }

    if (pVia->FBBase) {
#if XSERVER_LIBPCIACCESS
		pci_device_unmap_range (pVia->PciInfo, pVia->FBBase, 
						 pVia->pScreensPublicInfo->VRamSize);
#else
		xf86UnMapVidMem(pScrn->scrnIndex, (pointer)pVia->FBBase,
						pVia->pScreensPublicInfo->VRamSize);
#endif
		pVia->FBBase = NULL;
    }
    
    return;
}

 
static int 
VIAHWCursorSpaceAllocate(ScreenPtr pScreen)
{	
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    VIAPtr pVia = VIAPTR(pScrn);
    unsigned int addr = 0;

    if(!pVia->IsSecondary) {
        if(pVia->useRandR) {
			if (!pVia->ForceSWCursor) {
			#ifdef VIA_RANDR12_SUPPORT
				int i;
	            pVia->FBFreeStart = (pVia->FBFreeStart+ 0x3FF) & (~0x3FF);
				for (i = 0; i < 2; i++) {
		            addr = viaFBAlloctor(pScrn, VIA_CURSOR_SIZE, SEQUENCE, "RandR HW Icon Buf");
		            if (addr) {
		                pVia->HiStartBuf[i] = addr;
		            } else {
		                return -1;
		            }
				}
			#endif
			}
		} else if (pVia->pScreensPublicInfo->UseHwCursor || pVia->pBIOSInfo->SAMM) {
			/*Note:
			We must allocate the address in 64M,so we can't allocate the address from FBFreeEnd
			Graphic Hardware Cursor Mode Control 0x2D0 use bits [25:8] define 32x32x2 pattern base address,
			use bits [25:10] define 64x64x2 pattern base address, so we make pVia->FBFreeStart align base
			address with bit10. */
            addr = viaFBAlloctor(pScrn, VIA_CURSOR_SIZE, SEQUENCE, "noRandR HW Icon Buf");
            if (addr) {
                pVia->pScreensPublicInfo->CursorInfo.HIBufStart = addr;
            } else {
                return -1;
            }

            addr = viaFBAlloctor(pScrn, VIA_CURSOR_SIZE, SEQUENCE, "noRandR HW Primary Scaling Buf");
            if (addr) {
                pVia->pScreensPublicInfo->CursorInfo.HIPrimScalingBufStart = addr; 
            } else {
                return -1;
            }

            addr = viaFBAlloctor(pScrn, VIA_CURSOR_SIZE, SEQUENCE, "noRandR HW Second Scaling Buf");
            if (addr) {
                pVia->pScreensPublicInfo->CursorInfo.HISecScalingBufStart = addr;
            } else { 
                return -1;
            }
		}
	}
    return 0;
}


static Bool 
VIAScreenInit(int scrnIndex, ScreenPtr pScreen,
                          int argc, char **argv)
{
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn);
    VIAPtr pVia0 = VIAPTR(pScrn0);	
    vgaHWPtr hwp = VGAHWPTR(pScrn);	
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    PVIDDATA pVidData = pVia->pVidData;
    int ret;
    unsigned int TmpSwapValue;
	unsigned int addr;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAScreenInit\n"));    
/*version usingdef */
#ifdef XORG_VERSION_CURRENT
	DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "XF86_VER=%d\n, Not using in driver Now.\n", via_xf86_version_current));
#if XORG_VERSION_CURRENT <= XF86_VERSION_NUMERIC(2,0,0,0,0)&& XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(1,0,0,0,0)
	DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "XORG_VER=%d\n, Now driver depending only on this.\n", XORG_VERSION_CURRENT));    
#else
	DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "WARNING!!XORG_VER Out of (2,0,0,0,0)and(1,0,0,0,0),if =7.0~2,will ok,or Old version driver no surpport.\n"));    
#endif
#else
	DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "WARNING!!XORG_VER=%d\n,Not Exist,flow may wrong  Now.\n", XORG_VERSION_CURRENT));    
#endif
/*version using define*/

    /* For MAMM*/
    if (!pVia->IsMAMMEnable)
        vgaHWUnlock(hwp);
      
    if (!VIAMapFB(pScrn))
        return FALSE;

	/*Notice: SAMM, both two screens share the same MMIO space, so just need to map once.*/
	if (!pVia->IsSecondary)	{
    	if (!VIAMapMMIO(pScrn))
        	return FALSE;
	} else {
		/*Copy the first screen's MMIO map address to the second screen*/
		/*MMIO*/
		pVia->MapBase = pVia0->MapBase;
		pBIOSInfo->MapBase = pVia->MapBase;
		/*BitBlt MMIO*/
		pVia->BltBase = pVia0->BltBase;
		/*Video MMIO*/
		pVia->VidMapBase = pVia0->VidMapBase;
		VIAEnableMMIO(pScrn);
		vgaHWGetIOBase(hwp);
		/*For what?*/
		if (!vgaHWMapMem(pScrn))
			return FALSE;
	}

    /*modified the variable type,and change the function of this variable*/
    /*in SAMM, maybe have a issue, study in laterly*/
    if(pVia->DISP3DScalingCaps & DISPLAY_3D_SCALING_SUPPORT )
        Reserve3DScalingMemory(pScrn);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Mem Mapped\n"));

#ifdef XF86DRI
    if (pVia->directRenderingEnabled == TRUE) {
        pVia->directRenderingEnabled = VIADRIScreenInit(pScreen);
    }
#endif

    VIASave(pScrn);

#ifdef VIA_RANDR12_SUPPORT
	if (pVia->useRandR) {
        /*Clear FB with black color to avoid garbage*/
        memset(pVia->FBBase, 0x00, ((pScrn->displayWidth * pScrn->bitsPerPixel>>3) * pScrn->virtualY));
	
	    /* Initialize display engine, must after VIASave() and before VIAModeInit() */
	    viaInitDispEngine(pVia);
		viaInitOutputRegSet(pScrn);
	}
#endif

    /* Even we had disable the spread spectrum at PreInit.
       But we still disable it again for safty.
    */
    if (pVia->pChipInfo->biosIsSpreadSpectrum) {                 
        /* Disable spread spectrum temporarily, we will turn it on when set mode. */
        VGAOUT8(0x3c4, SR3D);
        VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xFE);

        VGAOUT8(0x3c4, SR1E);
        VGAOUT8(0x3c5, VGAIN8(0x3c5) & 0xF7);        
    }

    vgaHWBlankScreen(pScrn, FALSE);   


    if (!VIAModeInit(pScrn, pScrn->currentMode))
        return FALSE;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- State saved\n"));

    /* Darken the screen for aesthetic reasons and set the viewport */
    VIASaveScreen(pScreen, SCREEN_SAVER_ON);
    pScrn->AdjustFrame(scrnIndex, pScrn->frameX0, pScrn->frameY0, 0);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Blanked\n"));

    miClearVisualTypes();

    if (pScrn->bitsPerPixel > 8 && !pVia->IsSecondary) {
        if (!miSetVisualTypes(pScrn->depth, TrueColorMask,
                              pScrn->rgbBits, pScrn->defaultVisual))
            return FALSE;
        if (!miSetPixmapDepths())
            return FALSE;
    } else {
        if (!miSetVisualTypes(pScrn->depth, miGetDefaultVisualMask(pScrn->depth),
                              pScrn->rgbBits, pScrn->defaultVisual))
            return FALSE;
        if (!miSetPixmapDepths())
            return FALSE;
    }

#ifdef VIA_RANDR12_SUPPORT    
    if (pVia->useRandR) {
        /* Reserverd a big enough space for rotation use. */    
        pVia->NumOfShadowInUse = 0x0;
    }
#endif

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Visuals set up\n"));

    ret = VIAInternalScreenInit(scrnIndex, pScreen);

    if (!ret)
        return FALSE;

    xf86SetBlackWhitePixels(pScreen);
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- B & W\n"));

    if (pScrn->bitsPerPixel > 8) {
        VisualPtr visual;

        visual = pScreen->visuals + pScreen->numVisuals;
        while (--visual >= pScreen->visuals) {
            if ((visual->class | DynamicClass) == DirectColor) {
                visual->offsetRed = pScrn->offset.red;
                visual->offsetGreen = pScrn->offset.green;
                visual->offsetBlue = pScrn->offset.blue;
                visual->redMask = pScrn->mask.red;
                visual->greenMask = pScrn->mask.green;
                visual->blueMask = pScrn->mask.blue;
            }
        }
    }

    /* must be after RGB ordering fixed */
    fbPictureInit(pScreen, 0, 0);

    /*for 2D accel fail*/
    if (!pVia->NoAccel){
        if(FALSE==VIAInitAccel(pScreen))
	    return FALSE;
    }
  if(pVia->NoAccel) {
        /* No Accel path :
           Init the 3D pipeline API for the uniform 3D texture blting interface */
        viaExa3DInit(pScreen);
        viaExa2DInit(pScreen);
        /* Init Command Buffer for the uniform 3D texture blting interface */
        viaSetupCBuffer(pScrn, &pVia->cb, 0);
        /* Sync marker space. */
        addr = viaFBAlloctor( pScrn, 32, INVERT_SEQ, "EXA Sync Marker");
        if(addr) { 
        pVia->markerOffset = addr;
        }
        else {
        return FALSE;    
        }
        pVia->markerOffset = ( pVia->markerOffset + 31) & ~31;
        pVia->markerBuf = (volatile CARD32 *) ((char *)pVia->FBBase + pVia->markerOffset);
        *pVia->markerBuf = 0;
        pVia->curMarker = 0;
        pVia->lastMarkerRead = 0;
    }

    ret = VIAHWCursorSpaceAllocate(pScreen);
    if(ret != 0) {
        return FALSE; 
    }

#ifdef XF86DRI
    /*for VIDEO play memory overlap PIXEL_MAP_CACHE*/
    if (pVia->directRenderingEnabled 
#ifdef DRM_SAMM_VIA
        || pVia->drmSammEnabled
#endif
        ) {
	    if (!(VIADRIFBInit(pScreen, pVia))) {
	        VIADRICloseScreen(pScreen);
	        xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "[dri] frame buffer initialize failed .\n" );
	        pVia->directRenderingEnabled = FALSE;
	    }
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "[dri] frame buffer initialized done.\n" );
    }
#endif

    miInitializeBackingStore(pScreen);
    xf86SetBackingStore(pScreen);
    xf86SetSilkenMouse(pScreen);
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Backing store set up\n"));

    if( (!pVia->useRandR) &&(!pVia->shadowFB) && (!pVia->RotateDegree))        /* hardware cursor needs to wrap this layer */
        VIADGAInit(pScreen);

    miDCInitialize(pScreen, xf86GetPointerScreenFuncs());
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- SW cursor set up\n"));

	
    if (!pVia->useRandR) {
        if (!pVia->ForceSWCursor) {
            if (!VIAHWCursorInit(pScreen))
                xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
                           "Hardware cursor initialization failed\n");
        }
    } else {
#ifdef VIA_RANDR12_SUPPORT                 
        if (!pVia->ForceSWCursor) {
			/*Disable HW cursor 0x2D0[0]*/
			CARD32 regCursorMode = VIAGETREG(VIA_REG_CURSOR_MODE);
            VIASETREG(VIA_REG_CURSOR_MODE, regCursorMode & 0xFFFFFFFE);                        
			/*Init HW Icon*/
			VIAARGBCursorInit(pScrn);
            if(!xf86_cursors_init(pScreen, MAX_CURS, MAX_CURS,
                   (HARDWARE_CURSOR_SOURCE_MASK_INTERLEAVE_64 |
                    HARDWARE_CURSOR_AND_SOURCE_WITH_MASK |
                    HARDWARE_CURSOR_TRUECOLOR_AT_8BPP |
                    HARDWARE_CURSOR_INVERT_MASK |
                    HARDWARE_CURSOR_BIT_ORDER_MSBFIRST |                                              
                    HARDWARE_CURSOR_ARGB | 0)))
                DEBUG(ErrorF("Fail to initial xf86_cursors_init()\n"));
        }
#endif        
    }

    if (pVia->shadowFB) {
        RefreshAreaFuncPtr refreshArea = VIARefreshArea;
        
        if(pVia->RotateDegree) {            
            switch(pScrn->bitsPerPixel) {
                case 8:
                    refreshArea = VIARefreshArea8;
                    break;
                case 16:
                    refreshArea = VIARefreshArea16;
                    break;
                case 32:                
                    refreshArea = VIARefreshArea32;
                    break;
            }           
        }
        ShadowFBInit(pScreen, refreshArea);
    }    
    
#ifdef VIA_RANDR12_SUPPORT    
    if (pVia->useRandR) {
        /* For RandR v1.2 */
        if (!xf86CrtcScreenInit(pScreen)) {
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "xf86CrtcScreenInit Fail\n"));
            return FALSE;
        }    
    }
#endif

    if (!miCreateDefColormap(pScreen))
        return FALSE;
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Def Color map set up\n"));

    /* only 3123Ax IGA2 use 6-Bit LUT, others chipset IGA2 use 8-Bit LUT */
    /* So, except 3123Ax, we use 8-Bit LUT as default. */
    pScrn->rgbBits = 8;
    VGAOUT8(0x3C4, SR15);
    VGAOUT8(0x3C5, VGAIN8(0x3C5) | 0x80);
    if (!xf86HandleColormaps(pScreen, 256, 8, VIALoadPalette, NULL,
                             CMAP_RELOAD_ON_MODE_SWITCH | CMAP_PALETTED_TRUECOLOR))
        return FALSE;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Palette loaded\n"));

    /* Remove restart flag file for utility */
    UTRemoveRestartFlag(pBIOSInfo);

	if (!pVia->useRandR) {
	    /* For Qunta IL1's case, Disable LCD back-light to avoid garbage. */
	    if ((pBIOSInfo->Chipset >= VIA_VX800) &&
	        (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD) &&
	        (pBIOSInfo->LVDSSettingInfo.DIPort & VIA_DI_TTL)) {
	        /* IGA2 Screen Off */
	        VGAOUT8(0x3D4, 0x6B);
	        VGAOUT8(0x3D5, VGAIN8(0x3D5) | 0x04); 
	    }
	   
	    if (pScrn->bitsPerPixel != 8) {
	    	/* Single/DuoView or secondary screen(SAMM), set gamma */
			if(!pBIOSInfo->HasSecondary ||
				pBIOSInfo->IsSecondary) {
				/* Load user utility Gamma setting */
				if (VIALoadGammaSetting(pBIOSInfo))
					VIARestoreGamma(pScrn, pBIOSInfo->colors);
			}
	    }

	    /* For Qunta IL1's case, Disable LCD back-light to avoid garbage. */
	    if ((pBIOSInfo->Chipset >= VIA_VX800) &&
	        (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD) &&
	        (pBIOSInfo->LVDSSettingInfo.DIPort & VIA_DI_TTL)) {
	        /* IGA2 Screen ON */
	        VGAOUT8(0x3D4, 0x6B);
	        VGAOUT8(0x3D5, VGAIN8(0x3D5) & 0x0B);
	    }
	}
    vgaHWBlankScreen(pScrn, TRUE);

    pVia->CloseScreen = pScreen->CloseScreen;
    pScreen->SaveScreen = VIASaveScreen;    
    pScreen->CloseScreen = VIACloseScreen;

    xf86DPMSInit(pScreen, VIADPMS, 0);
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- DPMS set up\n"));

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Color maps etc. set up\n"));

#ifdef XF86DRI
    if (pVia->directRenderingEnabled 
#ifdef DRM_SAMM_VIA
       || pVia->drmSammEnabled
#endif
       ) 
        pVia->directRenderingEnabled = VIADRIFinishScreenInit(pScreen);

    if (pVia->directRenderingEnabled) {
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "direct rendering enabled\n");
        VIASet3DSyncInfoParas(pScreen);
    } else {
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "direct rendering disabled\n");
    }
#endif

    if (!pVia->NoAccel)
        viaFinishInitAccel(pScreen);
	
    /* Init the XFree86 video memory management for Non-Dri and Non-Exa case */
#ifdef XF86DRI
    if (!pVia->directRenderingEnabled) 
#endif
    {
        if(pVia->NoAccel) {
            /*
            * This is needed because xf86InitFBManagerLinear in VIAInitLinear
            * needs xf86InitFBManager to have been initialized, and
            * xf86InitFBManager needs at least one line of free memory to
            * work. This is only for Xv in Noaccel part, and since Xv is in some
            * sense accelerated, it might be a better idea to disable it
            * altogether.
            */
            
            BoxRec AvailFBArea;
            Bool ret;
            
            AvailFBArea.x1 = 0;
            AvailFBArea.y1 = 0;
            AvailFBArea.x2 = pScrn->displayWidth;
            AvailFBArea.y2 = pScrn->virtualY + 1;
            /*
            * Update FBFreeStart also for other memory managers, since
            * we steal one line to make xf86InitFBManager work.
            *
            * In no DRI, No Accel path, HW Cursor mem is allocated before
            * xf86InitFBManager
            */
            if(!viaFBAlloctor(pScrn, pVia->Bpl, SEQUENCE, "NoACCEL Offscreen")) {
                return FALSE;
            }
            ret = xf86InitFBManager(pScreen, &AvailFBArea);
            if (ret != TRUE) {
                xf86DrvMsg(pScrn->scrnIndex, X_ERROR,"VIAScreenInit xf86InitFBManager init failed\n");
                return FALSE;
            }
        }
#ifdef VIA_HAVE_EXA
        if (!(pVia->useEXA))
#endif
            VIAInitLinear(pScreen);
    }

     /* Initial VIA Video Driver */
    if(pVia->useRandR) {
    #ifdef VIA_RANDR12_SUPPORT
       FillGraphicInfo_New(pScrn);
    #endif
    } else {
        FillGraphicInfo(pScrn);
    }

#ifdef VIA_RANDR12_SUPPORT 
    if (pVia->useRandR) {
    	/*added for RANDR12 static rotate , because of the xorg's randr12 has bug, at which point pScrn->pScreen is not set but the 
    	xf86SetDesiredModes will use it, so we just manually assign it before the function, we only need to do this manually in 
    	xorg-1.4.0.90,in xorg-1.4.99.905 is fix, we do not need to assign it manully*/
		ScrnInfoPtr pTemp = pScrn;
		pScrn->pScreen = screenInfo.screens[pScrn->scrnIndex];
        
		if (!xf86SetDesiredModes(pScrn))
			return FALSE;                

		pScrn->pScreen = pTemp->pScreen;  
    }
#endif

    /* Mark we have already use all memory */
    /* pVia->FBFreeStart = pVia->FBFreeEnd; */
    if (via_module_loaded) {
	    /*When the first time we use the structure, we initialize it*/
        if (!(pVia->IsSecondary)) {
    	    memset((void*)&NEWVIAGraphicInfo,0x0,sizeof(NEWVIAGRAPHICINFO));
        }
        TranslateGFXInfo(viaGfxInfo, &NEWVIAGraphicInfo);
        vvaInitVideo(pVia->FBBase, pVia->MapBase,&NEWVIAGraphicInfo);
        
	    if(FALSE == vvaSyncInfo(NULL, VIA_XSERVERON))
      	    return FALSE;
    }

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "libddmpeg: Heap Begin 0x%lx,End 0x%lx\n", 
            viaGfxInfo->vheapbase, viaGfxInfo->vheapend));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "DRMEnabled: 0x%x\n", 
            viaGfxInfo->drmEnabled));
    if (viaGfxInfo->igaInfo[IGA1-1].actived) {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA1 dwWidth: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA1-1].desired_width));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA1 dwHeight: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA1-1].desired_height));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA1 dwRefreshRate: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA1-1].refreshrate));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA1 dwExpand: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA1-1].igaStatus.expanded));
    }
    if (viaGfxInfo->igaInfo[IGA2-1].actived) {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA2 dwWidth: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA2-1].desired_width));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA2 dwSaveWidth: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA2-1].desired_height));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA2 dwBPP: 0x%lx\n", 
                viaGfxInfo->screenInfo[IGA2-1].bpp));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA2 dwRefreshRate: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA2-1].refreshrate));
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "using IGA2 dwExpand: 0x%lx\n", 
                viaGfxInfo->igaInfo[IGA2-1].igaStatus.expanded));
    }

    /*  Init video structure, video flags & HW difference flags */
    vidInitVideoInfo(pVidData );
    
    viaInitVideo(pScreen);

    if(pBIOSInfo->MergedFB) {
        /* Psuedo xinerama */
        if(pBIOSInfo->UseVIAXinerama) {
            VIAnoPanoramiXExtension = FALSE;
            VIAXineramaExtensionInit(pScrn);
        }
    } 
    
    /* Create a extension handler to receive the request of s3utility. */
    /* XV path and Xext path is co-exists now.*/
    VIADisplayExtensionInit(pScrn);    

    /* For XV Rotate+panning support, set the correct Clipping window.
     * 
     * In NoRandR rotate for 2D, we don't need to swap virtualX/Y, 
     * while XV Rotate+panning in noRandR need it.
     * */
    if ((pVia->RotateDegree == VIA_ROTATE_DEGREE_90) ||
        (pVia->RotateDegree == VIA_ROTATE_DEGREE_270)) {
        TmpSwapValue = pScrn->currentMode->HDisplay;
        pScrn->currentMode->HDisplay = pScrn->currentMode->VDisplay;
        pScrn->currentMode->VDisplay = TmpSwapValue;
    }

    if (serverGeneration == 1)
        xf86ShowUnusedOptions(pScrn->scrnIndex, pScrn->options);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "- Done\n"));
    return TRUE;
}

static int 
VIAInternalScreenInit(int scrnIndex, ScreenPtr pScreen)
{
    ScrnInfoPtr     pScrn;
    VIAPtr          pVia;
    VIABIOSInfoPtr  pBIOSInfo;
    int             width, height, displayWidth, shadowHeight;
    unsigned char   *FBStart;
    int             ret = TRUE;

    xf86DrvMsg(scrnIndex, X_INFO, "VIAInternalScreenInit\n");

    pScrn = xf86Screens[pScreen->myNum];
    pVia = VIAPTR(pScrn);
    pBIOSInfo = pVia->pBIOSInfo;

    displayWidth = pScrn->displayWidth;

    if ((pVia->RotateDegree == VIA_ROTATE_DEGREE_90)||
        (pVia->RotateDegree == VIA_ROTATE_DEGREE_270)) {
        height = pScrn->virtualX;
        width = pScrn->virtualY;
		
        /* For XV Rotate+panning support, set the correct Clipping window.
         * 
         * In NoRandR rotate for 2D, we don't need to swap virtualX/Y, 
         * while XV Rotate+panning in noRandR need it.
         * */
        pScrn->virtualX = width;
        pScrn->virtualY = height;
    } else {
        width = pScrn->virtualX;
        height = pScrn->virtualY;        
    }

    shadowHeight = height;
    
    if (pVia->shadowFB) {
        pVia->ShadowPitch = BitmapBytePad(pScrn->bitsPerPixel * width);
        pVia->ShadowPtr = xalloc(pVia->ShadowPitch * shadowHeight);
        displayWidth = pVia->ShadowPitch / (pScrn->bitsPerPixel >> 3);
        FBStart = pVia->ShadowPtr;
    } else {
        pVia->ShadowPtr = NULL;
        FBStart = pVia->FBBase;
    }    
    
    /* 
    *   Use Direct Access Window Rotate. 
    *   When screen will be rotated, we must report a rotated size to OS
    *   to generate a rotated screen data. 
    */
    if(pVia->IsHWRotateEnabled) {
        switch (pVia->RotateDegree) {
        case VIA_ROTATE_DEGREE_90:
        case VIA_ROTATE_DEGREE_270:
             displayWidth = width;
        break;
        }
    }
   
    ret = fbScreenInit(pScreen, FBStart, width, height,
                       pScrn->xDpi, pScrn->yDpi, displayWidth,
                       pScrn->bitsPerPixel);

    return ret;
}


static ModeStatus 
VIAValidMode(int scrnIndex, DisplayModePtr mode, Bool verbose, int flags)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr      pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    
    DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIAValidMode\n"));

    if (!memcmp(mode->name, "PanelMode", 9)) {
        mode->type = M_T_USERDEF;        
        VIAGetModeLineTiming(pScrn, mode);
        pBIOSInfo->EDIDType = VIA_DEVICE_LCD;
        pBIOSInfo->LVDSSettingInfo.PanelSizeID =
            VIA_MAKE_ID(mode->HDisplay, mode->VDisplay);
        pBIOSInfo->isPanelModeLine = TRUE;
        return MODE_OK;
    }

    if(!pBIOSInfo->NoDDCValue) {
    	/*1.if user don't set modes in config file, we want to use PreferMode, so we use PreferModeH  PreferModeV to valid modes.
    	   2.if user set modes in config file, we use EDID can support maxH, maxV to valid modes*/ 
        if(pBIOSInfo->IsAutoDectectEnable == TRUE) {
            if ((mode->CrtcHDisplay > pBIOSInfo->CRTSettingInfo.PreferModeH) || 
       		    (mode->CrtcVDisplay > pBIOSInfo->CRTSettingInfo.PreferModeV))    
                return MODE_BAD_VVALUE;
    	} else {
			if ((mode->CrtcHDisplay > pBIOSInfo->CRTSettingInfo.MonitorSizeH) || 
			    (mode->CrtcVDisplay > pBIOSInfo->CRTSettingInfo.MonitorSizeV))
				return MODE_BAD_VVALUE;
		}
    }

    /* If the modeline is added by user, pass it. */
    if (( mode->type == M_T_USERDEF) || (mode->type == 0))
        return MODE_OK;

    /* If the modeline is added by monitor, pass it. */
    switch (mode->type) {
        case M_T_DRIVER:                                /* Monitor EDID */
        case M_T_DRIVER | M_T_USERDEF:                  /* Monitor EDID + Auto-detection */
        case M_T_DRIVER | M_T_PREFERRED:                /* Monitor EDID + Monitor Preferred Mode */
        case M_T_DRIVER | M_T_USERDEF | M_T_PREFERRED:  /* Monitor EDID + Auto-detection + Monitor Preferred Mode */
            return MODE_OK;
            break;
    }    
     
    /* check modes */
    switch (mode->CrtcHDisplay) {
        case 480:
            if (mode->CrtcVDisplay == 640)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 640:
            if (mode->CrtcVDisplay == 480)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 720:
            if (mode->CrtcVDisplay == 480 || mode->CrtcVDisplay == 576)

                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 800:
            if (mode->CrtcVDisplay == 600 || mode->CrtcVDisplay == 480)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 848:
            if (mode->CrtcVDisplay == 480)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 856:
            if (mode->CrtcVDisplay == 480)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 960:
            if (mode->CrtcVDisplay == 600)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1000:
            if (mode->CrtcVDisplay == 600)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1088:
            if (mode->CrtcVDisplay == 612)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1024:
            if (mode->CrtcVDisplay == 512 || mode->CrtcVDisplay == 576 ||
                mode->CrtcVDisplay == 768  || mode->CrtcVDisplay == 600)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
                
        case 1152:
            if ((mode->CrtcVDisplay == 864) || (mode->CrtcVDisplay == 720))
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1200:
            if (mode->CrtcVDisplay == 720)
                 return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1280:
            if (mode->CrtcVDisplay == 720 || mode->CrtcVDisplay == 768 || mode->CrtcVDisplay == 800 ||
                mode->CrtcVDisplay == 960 || mode->CrtcVDisplay == 1024 || mode->CrtcVDisplay == 600)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1366:
            if (mode->CrtcVDisplay == 768)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1360:
            if (mode->CrtcVDisplay == 768)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1400:
            if (mode->CrtcVDisplay == 1050)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1440:
            if ((mode->CrtcVDisplay == 1050) || (mode->CrtcVDisplay == 900))
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1600:
            if ((mode->CrtcVDisplay == 1200) || (mode->CrtcVDisplay == 900) || 
                (mode->CrtcVDisplay == 1024))
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1680:
            if ((mode->CrtcVDisplay == 1050) || (mode->CrtcVDisplay == 600))
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1792:
            if (mode->CrtcVDisplay == 1344)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1856:
            if (mode->CrtcVDisplay == 1392)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 1920:
            if ((mode->CrtcVDisplay == 1440) || 
                 (mode->CrtcVDisplay == 1080) ||
                 (mode->CrtcVDisplay == 1200))
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
            
        case 2048:
            if (mode->CrtcVDisplay == 1536)
                return MODE_OK;
            else
                return MODE_BAD_VVALUE;
            break;
    }

    return MODE_BAD_HVALUE;
}


static void 
VIABIOSInit(VIAPtr pVia, ScrnInfoPtr pScrn, DisplayModePtr pMode)
{
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIABIOSInit begin\n"));

    pBIOSInfo->bitsPerPixel = pScrn->bitsPerPixel;
    pBIOSInfo->displayWidth = pScrn->displayWidth;
    pBIOSInfo->scrnIndex = pScrn->scrnIndex;
    pBIOSInfo->IGA1SettingInfo.IsActive = FALSE;
    pBIOSInfo->IGA2SettingInfo.IsActive = FALSE;

    pBIOSInfo->Clock = pMode->Clock;
    pBIOSInfo->HTotal = pMode->HTotal;
    pBIOSInfo->VTotal = pMode->VTotal;
    pBIOSInfo->HDisplay = pMode->HDisplay;
    pBIOSInfo->VDisplay = pMode->VDisplay;
    pBIOSInfo->CrtcHDisplay = pMode->CrtcHDisplay;
    pBIOSInfo->CrtcVDisplay = pMode->CrtcVDisplay;

    if (pBIOSInfo->FirstInit) {
        pBIOSInfo->SaveframeX1 = pScrn->frameX1;
        pBIOSInfo->SaveframeY1 = pScrn->frameY1;
        pBIOSInfo->SaveHDisplay = pMode->HDisplay;
        pBIOSInfo->SaveVDisplay = pMode->VDisplay;
        pBIOSInfo->SaveCrtcHDisplay = pMode->CrtcHDisplay;
        pBIOSInfo->SaveCrtcVDisplay = pMode->CrtcVDisplay;
        pBIOSInfo->SaveVirtualX = pScrn->virtualX;
        pBIOSInfo->SaveVirtualY = pScrn->virtualY;
    }

    pBIOSInfo->IsSecondary = pVia->IsSecondary;
    pBIOSInfo->HasSecondary = pVia->HasSecondary;
    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "pBIOSInfo:bitsPerPixel=%d,displayWidth=%d,frameX1=%d,frameY1=%d\n",pBIOSInfo->bitsPerPixel,pBIOSInfo->displayWidth,pBIOSInfo->frameX1,pBIOSInfo->frameY1));     
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "pMode:HTotal=%d,VTotal=%d,HDisplay=%d,VDisplay=%d\n",pMode->HTotal,pMode->VTotal,pMode->HDisplay,pMode->VDisplay));     
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "pMode:,CrtcHDisplay=%d,CrtcVDisplay=%d\n",pMode->CrtcHDisplay,pMode->CrtcVDisplay)); 
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIABIOSInit exit\n"));    
}


static void 
VIAPostFindMode(VIAPtr pVia, ScrnInfoPtr pScrn, DisplayModePtr pMode)
{
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    int tmp = 0;
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAPostFindMode begin\n"));
	/* For LCD panning Case */
	pScrn->frameX1 = pBIOSInfo->frameX1;   
    pScrn->frameY1 = pBIOSInfo->frameY1;
    
	/* FAKE as RanR12 for XV noRandR rotation, exchange frameX1 and frameY1*/
    if ((pVia->RotateDegree == VIA_ROTATE_DEGREE_90) ||
        (pVia->RotateDegree == VIA_ROTATE_DEGREE_270) ) {
        tmp = pScrn->frameX1;
        pScrn->frameX1 = pScrn->frameY1;
        pScrn->frameY1 = tmp;
    }

    if (pBIOSInfo->ActualDesktopSizeX > pBIOSInfo->HDisplay)
        pMode->HDisplay = pBIOSInfo->HDisplay;
    else
        pMode->HDisplay = pBIOSInfo->ActualDesktopSizeX;

    if (pBIOSInfo->ActualDesktopSizeY > pBIOSInfo->VDisplay)
        pMode->VDisplay = pBIOSInfo->VDisplay;
    else
        pMode->VDisplay = pBIOSInfo->ActualDesktopSizeY;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "pBIOSInfo: offsetWidthByQWord=%d,countWidthByQWord=%d\n",pBIOSInfo->offsetWidthByQWord,pBIOSInfo->countWidthByQWord));     
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "pBIOSInfo:,frameX1=%d,frameY1=%d,HDisplay=%d,VDisplay=%d\n",pBIOSInfo->frameX1,pBIOSInfo->frameY1,pBIOSInfo->HDisplay,pBIOSInfo->VDisplay)); 
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "pBIOSInfo:,ActualDesktopSizeX=%d,ActualDesktopSizeY=%d\n",pBIOSInfo->ActualDesktopSizeX,pBIOSInfo->ActualDesktopSizeY)); 
    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAPostFindMode exit\n"));    
}


void 
VIACorrectModeList(ScrnInfoPtr pScrn)
{
    DisplayModePtr mode;

    for (mode = pScrn->modes; ; mode = mode->next) {
        VIAGetModeSizeByName(mode->name, &mode->HDisplay, &mode->VDisplay);

        if (mode->next == pScrn->modes)
            break;  /* The end of mode list. */
    }
}


void 
VIAModeInitRunOnce(ScrnInfoPtr pScrn)
{
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    /* All the things can be added here if they just need to initialize once */
    /* until the system suspends or logout. */
    VIATMDSRegInit(pBIOSInfo);
}


static Bool 
VIAModeInit(ScrnInfoPtr pScrn, DisplayModePtr mode)
{
    vgaHWPtr        hwp = VGAHWPTR(pScrn);
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    vgaRegPtr       vganew = &hwp->ModeReg;
    
    xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAModeInit\n");
    
    /* Because we may update HDisplay/VDisplay of some mode for */
    /* panning issue in the previous mode setting, so we'd better restore them to fit */
    /* the real mode size first, or it may cause problems when that mode is not in use, */
    /* especially when the mode setting is called by RandR. */
    /* For example, CRT+DVI (panel size is 1280x1024), when we set to 1920x1080, this mode */
    /* will be dropped from RandR's mode list until we re-login X. */
    if (!pBIOSInfo->ModeLineStatus)
        VIACorrectModeList(pScrn);

    if (!vgaHWInit(pScrn, mode)) {
        vgaHWBlankScreen(pScrn, TRUE);
        return FALSE;
    }

    pScrn->vtSema = TRUE;

    if (!pVia->IsVIAModeInitRunOnceDone) {
    	if (!pVia->useRandR)
        	VIAModeInitRunOnce(pScrn);

        /* Just run once. */
        pVia->IsVIAModeInitRunOnceDone = TRUE;
    }

    VIABIOSInit(pVia, pScrn, mode);
    
    /* load utility user active device setting */
    /* We also need to load user settings in SAMM case, */
    /* so I move this call to here. */
    VIALoadUserSetting(pBIOSInfo);
    
    /*modified the variable type,and change the function of this variable*/      
    if (pVia->DISP3DScalingCaps & DISPLAY_3D_SCALING_SUPPORT) {
        pBIOSInfo->Is3DScalingEnable = (pVia->DISP3DScalingCaps & pBIOSInfo->ActiveDevice);
    }
    
    if (!pBIOSInfo->SAMM) {        
        VIASetDisplayPath(pScrn);

        /* Check what type of cursor (SW/HW) to use. */
        VIACheckCursorTypeToUse(pScrn);
    } 
    
    /* Set DuoView Video Output Device of S3Utility setting*/
    VIALoadUserDuoViewVideoOutputDeviceSetting(pScrn);      

    if (!VIAFindModeUseBIOSTable(pScrn)) {
        vgaHWBlankScreen(pScrn, TRUE);
        return FALSE;
    }     

    VIAPostFindMode(pVia, pScrn, mode);

    pBIOSInfo->IsStableStatus=FALSE;
    /*modified the variable type,and change the function of this variable*/    
    if( pVia->DISP3DScalingCaps & DISPLAY_3D_SCALING_SUPPORT) {
        if (pBIOSInfo->Is3DScalingEnable)
            VIADISP3DScalingParasSetting(pScrn); 
    }        
   
    /* Enable CBU HW Rotate. */
    if (pVia->IsHWRotateEnabled)
        EnableCBUrotate(pScrn);

	if (!pVia->useRandR) 
		/*Caused by VIARestore in VIAEnterVT, If we switch VT or 
		do suspend/resume with shrink enable, there is garbage on IGA which shrink used.*/
		VIASetStartingAddress(pScrn, pScrn->frameX0, pScrn->frameY0);

    /* FIXME - need DRI lock for this bit */
    /* do it! */
	if (!pVia->useRandR)
	    VIAWriteMode(pScrn, vganew);
	else {
	    pBIOSInfo->FirstInit = FALSE;
	    /* Enable the graphics engine. */
	    if (!pVia->NoAccel)
	        VIAInitialize2DEngine(pScrn);

#ifdef XF86DRI
	    VIAInitialize3DEngine(pScrn);
#endif        
	}
  
    pBIOSInfo->IsStableStatus=TRUE;

    /* pass graphic info to via_v4l kernel module */
    /* Coz mode changes, some member in VIAGraphicInfo need to modify */
    if(pVia->useRandR) {
        FillGraphicInfo_New(pScrn);
    } else {
        FillGraphicInfo(pScrn);
    }

    if(via_module_loaded) {
        TranslateGFXInfo(pVia->pVidData->viaGfxInfo, &NEWVIAGraphicInfo);
        vvaInitVideo(pVia->FBBase, pVia->MapBase,&NEWVIAGraphicInfo);
        
	    if(FALSE == vvaSyncInfo(&NEWVIAGraphicInfo, VIA_SET_2D_INFO))
	        return FALSE;
    }

    VIAAdjustFrame(pScrn->scrnIndex, pScrn->frameX0, pScrn->frameY0, 0);    
    /* Insert a timer */
    if  ((pBIOSInfo->Is3DScalingEnable & DISP_3D_SCALING_ENABLE) ||
        ((pVia->IsHotkeyTimerEnabled) && (!pBIOSInfo->SAMM))) {
        if(!pVia->devicesTimer)
            pVia->devicesTimer = TimerSet(NULL, 0, 30, VIASyncTimer, pScrn);
    } else {
        if(pVia->devicesTimer) {
            TimerCancel(pVia->devicesTimer);
            pVia->devicesTimer=NULL;
        }
    }        
    
    return TRUE;
}


static
Bool VIACloseScreen(int scrnIndex, ScreenPtr pScreen)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    vgaHWPtr    hwp = VGAHWPTR(pScrn);
    VIAPtr      pVia = VIAPTR(pScrn);
    vgaRegPtr   vgaSavePtr = &hwp->SavedReg;
    VIARegPtr   viaSavePtr = &pVia->SavedReg;
    CARD32      dwCursorMode;
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    if (pVia->devicesTimer)
        TimerCancel(pVia->devicesTimer);

    pVia->devicesTimer = NULL;
    
    /*when log out X, if DRI is enabled, the DRI resource should be cleaned up*/
    if (pVia->directRenderingEnabled
#ifdef DRM_SAMM_VIA
        || pVia->drmSammEnabled
#endif
      ) {
        VIADRICloseScreen(pScreen);
    }

    xf86DrvMsg(scrnIndex, X_INFO, "VIACloseScreen\n");

    /* Disable CBU HW rotate*/
    if (pVia->IsHWRotateEnabled)
        DisableCBUrotate(pScrn);
    
    /* For utility api */
    VIADisplayExtUnregister(pScrn);

    /*Turn off color cursor here*/
    VIASETREG(PRIM_HI_CTRL, 0);
    VIASETREG(HI_CONTROL, 0);
    /*=* 
         When you open two X-Window and use "kill PID" to kill secondary X-Window process.
         Then system will hang after few seconds. So patch for above situation.
         If not really exit X-Window, do this patch *=*/ 
    if (pScrn->vtSema) {
        /* Move exit video here if exitvideo after restore SR1A (PCI reset)
         * the V3 command fire may stick and caused system hang when playing video
         * Turn off all video activities */
        viaExitVideo(pScrn);
    }

    if (!pVia->IsSecondary) {
        if(via_module_loaded) {
            TranslateGFXInfo(viaGfxInfo, &NEWVIAGraphicInfo);
            if(FALSE ==  vvaSyncInfo(&NEWVIAGraphicInfo, VIA_XSERVEROFF))
                return FALSE;
        }

        /* clean viddata structure*/
        int i;

        /* Reset panning mode parameter */
        /*Modified for SAMM, Panning for Video XV rotate*/
        for (i = 0; i < 2; i ++) {
            pVidData->panning_x[i] = 0;
            pVidData->panning_y[i] = 0;
        }

        DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIACloseScreen, NEWVIAGraphicInfo->dwXServerEnabled = FALSE\n"));       
        viaGfxInfo->drmEnabled = FALSE;

        /* Diable Hardware Cursor */
        dwCursorMode = VIAGETREG(VIA_REG_CURSOR_MODE);
        VIASETREG(VIA_REG_CURSOR_MODE, dwCursorMode & 0xFFFFFFFE);
    }

    /* Wait Hardware Engine idle to exit graphic mode */
    WaitIdle();

    if ((pVia->VQEnable)&&(pScrn->vtSema)) {
        /* if we use VQ, disable it before we exit */
        xf86DrvMsg(scrnIndex, X_INFO, "VIACloseScreen, VQ, disable \n");
        VIADisableVQ(pScrn);
    }

    if(pVia->HwCursorImage) {
        xfree(pVia->HwCursorImage);
        pVia->HwCursorImage = NULL;
    }
    
    if(pVia->HwIconImage) {
        xfree(pVia->HwIconImage);
        pVia->HwIconImage = NULL;
    }
    
    if(pVia->HIScalingPrimImage) {
        xfree(pVia->HIScalingPrimImage);
        pVia->HIScalingPrimImage = NULL;
    }
    
    if(pVia->HIScalingSecImage) {
        xfree(pVia->HIScalingSecImage);
        pVia->HIScalingSecImage = NULL;
    }
    
    if (pVia->AccelInfoRec) {
        XAADestroyInfoRec(pVia->AccelInfoRec);
        pVia->AccelInfoRec = NULL;
    }
    
    if (pVia->CursorInfoRec) {
        xf86DestroyCursorInfoRec(pVia->CursorInfoRec);
        pVia->CursorInfoRec = NULL;
    }
    
    if (pVia->ShadowPtr) {
        xfree(pVia->ShadowPtr);
        pVia->ShadowPtr = NULL;
    }
    
    if (pVia->DGAModes) {
        xfree(pVia->DGAModes);
        pVia->DGAModes = NULL;
    }
    
    viaExitAccel(pScreen);
    
    if (pScrn->vtSema) {    
        DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIACloseScreen, pScrn->vtSema is true \n"));            
        /* Clear Memory to avoid garbage */
        memset(pVia->pBIOSInfo->FBBase, 0x00, pVia->pBIOSInfo->videoRambytes - VIA_FB_CURSOR_SIZE);                
        
        if (!pVia->IsSecondary)
            VIARestore(pScrn, vgaSavePtr, viaSavePtr, FALSE);

        vgaHWLock(hwp);
        /*SAMM case, make sure MMIO only unmap once!*/
        if (!pVia->IsSecondary)
            VIAUnmapMem(pScrn);
        else {
            if (pVia->FBBase) {
                pVia->FBBase = NULL;
            }
        }
        vgaHWUnmapMem(pScrn);
    }

    /* For MAMM*/
    if (!pVia->IsMAMMEnable) {
        if (pVia->pInt10) {
            xf86FreeInt10(pVia->pInt10);
            pVia->pInt10 = NULL;
        }
    }

    if (!pVia->IsSecondary) {
        /* delete the memory of VidData */
        if(pVia->pVidData) {
            if(pVia->pVidData->viaGfxInfo){
                xfree((void *)pVia->pVidData->viaGfxInfo);
                pVia->pVidData->viaGfxInfo = NULL;
            }
            xfree((void *)pVia->pVidData);
            pVia->pVidData = NULL;
        }
    } else {
        pVia->pVidData = NULL;
    }
    
    pVia->IsVIAModeInitRunOnceDone = FALSE;
    pScrn->vtSema = FALSE;
    pScreen->CloseScreen = pVia->CloseScreen;

    return (*pScreen->CloseScreen)(scrnIndex, pScreen);
}

/*
 * This only gets called when a screen is being deleted.  It does not
 * get called routinely at the end of a server generation.
 */
static void 
VIAFreeScreen(int scrnIndex, int flags)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];    
    VIAPtr      pVia = VIAPTR(pScrn);
    
    xf86DrvMsg(scrnIndex, X_INFO, "VIAFreeScreen\n");
    
    if (xf86LoaderCheckSymbol("vgaHWFreeHWRec"))
    vgaHWFreeHWRec(pScrn);
	
	/*SAMM case, make sure MMIO only unmap once!*/
    if (!pVia->IsSecondary) {
        /* delete the memory of VidData */
        if (pVia->pVidData) {
            if(pVia->pVidData->viaGfxInfo){
                xfree((void *)pVia->pVidData->viaGfxInfo);
                pVia->pVidData->viaGfxInfo = NULL;
            }
            xfree((void *)pVia->pVidData);
            pVia->pVidData = NULL;
        }
        VIAUnmapMem(pScrn);
    } else {
        pVia->pVidData = NULL;

        if (pVia->FBBase) {
			pVia->FBBase = NULL;
		}
	}
	
    VIAFreeRec(pScrn);
}

static Bool 
VIASaveScreen(ScreenPtr pScreen, int mode)
{
    return vgaHWSaveScreen(pScreen, mode);
}

int 
VIAGetIGAInUse(VIABIOSInfoPtr pBIOSInfo)
{
    switch (pBIOSInfo->ActiveDevice) {
        case VIA_DEVICE_CRT1:
            return pBIOSInfo->CRTSettingInfo.IGAPath;

        case VIA_DEVICE_LCD:
            return pBIOSInfo->LVDSSettingInfo.IGAPath;

        case VIA_DEVICE_DFP:
            return pBIOSInfo->TMDSSettingInfo.IGAPath;

        default:
            /* Wrong Device ID! */
            return 0;
    }
}


/* This function for tuning XY position in xorg to position in on_screen.
   Only rotation need to care about this.*/
static void 
TuneXYToOnScreenXY(ScrnInfoPtr pScrn, int *x, int *y)
{
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    int tmpx = *x, tmpy = *y;

    /* All the rotation cases need to be coverd here.Maybe not all the cases have been coverd, 
       one can add some cases if necessary */
    if(!pVia->RotateDegree)
        return ;

    /* rotation exist. to calculate the x y position according to the position in xorg.*/
    if(pVia->RotateDegree == VIA_ROTATE_DEGREE_90) {
        /* ex: 1600x1200 at 1680x1050 monitor */
        if ((pBIOSInfo->VirtualX < pBIOSInfo->HDisplay) &&  
            (pBIOSInfo->VirtualY > pBIOSInfo->VDisplay)) {            
            *x = 0;   
            *y = tmpx;
        } else {
            *x = pBIOSInfo->VirtualX - tmpy - pBIOSInfo->HDisplay;        
            *y = tmpx;
        }
    } else if(pVia->RotateDegree == VIA_ROTATE_DEGREE_270) {
        /* ex:1920x1080 at 1600x1200 monitor */
        if ((pBIOSInfo->VirtualX > pBIOSInfo->HDisplay) &&
            (pBIOSInfo->VirtualY < pBIOSInfo->VDisplay)) {
           *x = tmpy;
           *y = 0; 
        } else {        
            *x = tmpy;
            *y = pBIOSInfo->VirtualY - tmpx - pBIOSInfo->VDisplay;
        }                
    } else if(pVia->RotateDegree == VIA_ROTATE_DEGREE_180) {
        /* ex: 1600x1200 at 1680x1050 monitor */
        if ((pBIOSInfo->VirtualX < pBIOSInfo->HDisplay) && 
            (pBIOSInfo->VirtualY > pBIOSInfo->VDisplay)) {
            *x = 0;
            *y = pBIOSInfo->VirtualY - tmpy - pBIOSInfo->VDisplay; 
        /* ex:1920x1080 at 1600x1200 monitor */   
        } else if ((pBIOSInfo->VirtualX > pBIOSInfo->HDisplay) &&
                   (pBIOSInfo->VirtualY < pBIOSInfo->VDisplay)) {
            *x = pBIOSInfo->VirtualX - tmpx - pBIOSInfo->HDisplay;
            *y = 0; 
        } else {        
            *x = pBIOSInfo->VirtualX - tmpx - pBIOSInfo->HDisplay;
            *y = pBIOSInfo->VirtualY - tmpy - pBIOSInfo->VDisplay;  
        }
    }
    return ;    
}


void 
VIASetStartingAddress(ScrnInfoPtr pScrn, int x, int y)
{
    vgaHWPtr        hwp = VGAHWPTR(pScrn);
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    int             vgaCRIndex, vgaCRReg, vgaIOBase;
    CARD32          tmp, Base, tmpBase;
    Bool            bAdjustPrimaryStartAddr, bAdjustSecondaryStartAddr;
    unsigned long HalfScreen;
    int HalfLine;
    vgaIOBase = hwp->IOBase;
    vgaCRIndex = vgaIOBase + 4;
    vgaCRReg = vgaIOBase + 5;

    /* For rotation used. */
    TuneXYToOnScreenXY(pScrn, &x, &y);

    Base = (y * pScrn->displayWidth + x) * (pScrn->bitsPerPixel / 8);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetStartingAddress begin\n"));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetStartingAddress:pScrn->fbOffset=%lu,Base=%lu\n",pScrn->fbOffset,Base));

    if (pBIOSInfo->IsExtend)
        return;

    if(pBIOSInfo->UseIGA2 && pBIOSInfo->TwoLCD) {
        if (!pVia->IsSecondary) {
            Base = Base >> 1;
            VGAOUT8(vgaCRIndex, CR62);
            tmp = VGAIN8(vgaCRReg) & 0x01;
            tmp |= (Base & 0x7F) << 1;
            VGAOUT8(vgaCRReg, tmp);
            VGAOUT8(vgaCRIndex, CR63);
            VGAOUT8(vgaCRReg, ((Base & 0x7F80) >> 7));
            VGAOUT8(vgaCRIndex, CR64);
            VGAOUT8(vgaCRReg, ((Base & 0x7F8000) >> 15));
            VGAOUT8(vgaCRIndex, CRA3);
            VGAOUT8(vgaCRReg, ((Base & 0x03800000) >> 23));
        } else {
            Base = (Base + pScrn->fbOffset) >> 1;
            VGAOUT16(vgaCRIndex, (Base & 0x00ff00) | CR0C);
            VGAOUT16(vgaCRIndex, ((Base & 0x00ff) << 8) | CR0D);            
            VGAOUT16(vgaCRIndex, ((Base & 0xff000000) >> 16) | CR48);
            /* CR34 are fire bits. Must be writed after CR0C CR0D CR48. */
            VGAOUT16(vgaCRIndex, ((Base & 0xff0000) >> 8) | CR34);
        }
    } else {
        /* Check which starting should be updated: */
        if (pBIOSInfo->UseIGA2) {
            bAdjustPrimaryStartAddr = FALSE;
            bAdjustSecondaryStartAddr = TRUE;
        } else if (!pBIOSInfo->DuoView || pBIOSInfo->SAMM) {
            /* For single and SAMM case: */
            if (VIAGetIGAInUse(pBIOSInfo) == IGA1) {                
                bAdjustPrimaryStartAddr = TRUE;
                bAdjustSecondaryStartAddr = FALSE;
            } else {                
                bAdjustPrimaryStartAddr = FALSE;
                bAdjustSecondaryStartAddr = TRUE;
            }
        } else {
            /* We will set starting address when set mode or panning. */
            if (pBIOSInfo->IGA1SettingInfo.SetStartingAddrFirstTime) {
                bAdjustPrimaryStartAddr = TRUE;
                pBIOSInfo->IGA1SettingInfo.SetStartingAddrFirstTime = FALSE;
            } else {
                bAdjustPrimaryStartAddr = pBIOSInfo->IGA1SettingInfo.IsPanning;
            }

            if (pBIOSInfo->IGA2SettingInfo.SetStartingAddrFirstTime) {
                bAdjustSecondaryStartAddr = TRUE;
                pBIOSInfo->IGA2SettingInfo.SetStartingAddrFirstTime = FALSE;
            } else {
                bAdjustSecondaryStartAddr = pBIOSInfo->IGA2SettingInfo.IsPanning;
            }
        }

        /* Decide which image (primary or secondary) to show: */
        /* We will show primary image except the secondary device in SAMM case.  */
        if (pBIOSInfo->SAMM && (pBIOSInfo->ActiveDevice != pBIOSInfo->PrimaryDevice))
            Base = Base + pScrn->fbOffset;

        if (bAdjustPrimaryStartAddr) {
            /* On duoview & rotation & one device panning's situation. We only have one x,y
               and we will set it to IGA1 and IGA2. But only one IGA is panning. So the specified
               screen will be incorrect. We have to avoid this situation, so I set the starting
               address as 0.
            */
            if ((!pBIOSInfo->IGA1SettingInfo.IsPanning) && (!pBIOSInfo->SAMM))
                tmpBase = 0;
            else
                tmpBase = Base >> 1;
            
            if (pBIOSInfo->MergedFB) {
                /* set IGA1 start address while mergedfb*/
                if ((pBIOSInfo->Scrn2Position == viaRightOf) ||
                    (pBIOSInfo->Scrn2Position == viaBelow)) {
                    VGAOUT16(vgaCRIndex,  0 | CR0C);
                    VGAOUT16(vgaCRIndex,  0 | CR0D);
                    VGAOUT16(vgaCRIndex,  0 | CR34);
                } else if (pBIOSInfo->Scrn2Position == viaLeftOf) {
                    HalfLine = pBIOSInfo->HalfLine*2;  
                    VGAOUT16(vgaCRIndex, (HalfLine & 0x00FF00) | CR0C);
                    VGAOUT16(vgaCRIndex, ((HalfLine& 0x0000FF) << 8) | CR0D);
                    VGAOUT16(vgaCRIndex, ((HalfLine & 0xFF0000) >> 8) | CR34);
                } else if(pBIOSInfo->Scrn2Position == viaAbove) {
                    HalfScreen = pBIOSInfo->HalfScreen*2;  
                    VGAOUT16(vgaCRIndex, (HalfScreen & 0x00FF00) | CR0C);
                    VGAOUT16(vgaCRIndex, ((HalfScreen& 0x0000FF) << 8) | CR0D);                    
                    VGAOUT16(vgaCRIndex, ((HalfScreen & 0x03000000) >> 16) | CR48);
                    /* CR34 are fire bits. Must be writed after CR0C CR0D CR48.  */
                    VGAOUT16(vgaCRIndex, ((HalfScreen & 0xFF0000) >> 8) | CR34);
                }
            } else {
                VGAOUT16(vgaCRIndex, (tmpBase & 0x00ff00) | CR0C);
                VGAOUT16(vgaCRIndex, ((tmpBase & 0x00ff) << 8) | CR0D);               
                VGAOUT16(vgaCRIndex, ((tmpBase & 0x1f000000) >> 16) | CR48);
                /* CR34 are fire bits. Must be writed after CR0C CR0D CR48.  */
                VGAOUT16(vgaCRIndex, ((tmpBase & 0xff0000) >> 8) | CR34);
            }
        }
        
        if (bAdjustSecondaryStartAddr) {
            /* On duoview & rotation & one device panning's situation. We only have one x,y
               and we will set it to IGA1 and IGA2. But only one IGA is panning. So the specified
               screen will be incorrect. We have to avoid this situation, so I set the starting
               address as 0.
            */
            if ((!pBIOSInfo->IGA2SettingInfo.IsPanning) && (!pBIOSInfo->SAMM))
                tmpBase = 0;
            else
                tmpBase = Base >> 3;
            
            VGAOUT8(vgaCRIndex, CR62);

            /* patch VT3259 unknow panning bug temporary */
            if ((pBIOSInfo->Chipset == VIA_P4M800PRO) || 
                (pBIOSInfo->Chipset == VIA_K8M890) || 
                (pBIOSInfo->Chipset == VIA_P4M890)) {
                tmp = VGAIN8(vgaCRReg) & 0x01;
                tmp |= (tmpBase & 0x7E) << 1;
            } else {
                tmp = VGAIN8(vgaCRReg) & 0x01;
                tmp |= (tmpBase & 0x7F) << 1;
            }
            
            if (pBIOSInfo->MergedFB) {
                /* set IGA2 start address while mergedfb*/
                if (pBIOSInfo->Scrn2Position == viaRightOf) {
                    HalfLine =  pBIOSInfo->HalfLine;      
                    VGAOUT8(vgaCRReg, HalfLine & 0xFF);
                    VGAOUT8(vgaCRIndex, CR63);
                    VGAOUT8(vgaCRReg, ((HalfLine & 0xFF00) >>8));
                    VGAOUT8(vgaCRIndex, CR64);
                    VGAOUT8(vgaCRReg, ((HalfLine & 0xFF0000) >> 16));
                } else if (pBIOSInfo->Scrn2Position == viaBelow) {        
                    HalfScreen =  pBIOSInfo->HalfScreen;  
                    VGAOUT8(vgaCRReg, HalfScreen & 0xFF);
                    VGAOUT8(vgaCRIndex, CR63);
                    VGAOUT8(vgaCRReg, ((HalfScreen & 0xFF00) >>8));
                    VGAOUT8(vgaCRIndex, CR64);
                    VGAOUT8(vgaCRReg, ((HalfScreen & 0xFF0000) >> 16));
                    VGAOUT8(vgaCRIndex, CRA3);
                    VGAOUT8(vgaCRReg, ((HalfScreen & 0xFF000000) >> 24));
                } else if ((pBIOSInfo->Scrn2Position == viaAbove) || 
                           (pBIOSInfo->Scrn2Position == viaLeftOf)) {
                    VGAOUT8(vgaCRReg, 0);
                    VGAOUT8(vgaCRIndex, CR63);
                    VGAOUT8(vgaCRReg, 0);
                    VGAOUT8(vgaCRIndex, CR64);
                    VGAOUT8(vgaCRReg, 0);
                }
            } else {
                VGAOUT8(vgaCRReg, tmp);
                VGAOUT8(vgaCRIndex, CR63);
                VGAOUT8(vgaCRReg, ((tmpBase & 0x7F80) >> 7));
                VGAOUT8(vgaCRIndex, CR64);
                VGAOUT8(vgaCRReg, ((tmpBase & 0x7F8000) >> 15));
                VGAOUT8(vgaCRIndex, CRA3);
                VGAOUT8(vgaCRReg, ((tmpBase & 0x03800000) >> 23));
            }
        }        
    } 

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetStartingAddress:pScrn->fbOffset=%lu, Base=%lu\n", 
          pScrn->fbOffset,Base));
    if (pBIOSInfo->Is3DScalingEnable & DISP_3D_SCALING_ENABLE) {
		/* Unlock Extended Regs */
		VGAOUT8(0x3c4, 0x10);
		VGAOUT8(0x3c5, VGAIN8(0x3c5) | 0x01);
		/* Unlock CRTC register protect */
		VGAOUT8(0x3d4, 0x47);
		VGAOUT8(0x3d5, VGAIN8(0x3d5) & ~0x01);	
    
        if (pBIOSInfo ->IGA1SettingInfo.IsDISP3DScaling) {
            tmp = pVia->iga1DISP3DScalingBufferStart;
            pBIOSInfo->IGA1SettingInfo.DISP3DSCALCTRLInfo.DISP3DScalingBufIndex = 0;
            VIASETREG(0x214, tmp>>1);
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, 
                  "VIASetStartingAddress on IGA1 for SCALING: pVia->iga1DISP3DScalingBufferStart=%X\n",
                  pVia->iga1DISP3DScalingBufferStart));
        }
        
        if (pBIOSInfo ->IGA2SettingInfo.IsDISP3DScaling) {
            tmp = pVia->iga2DISP3DScalingBufferStart;
            pBIOSInfo->IGA2SettingInfo.DISP3DSCALCTRLInfo.DISP3DScalingBufIndex = 0;
            VIASETREG(0x218, tmp);
            DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, 
                  "VIASetStartingAddress on IGA2 for SCALING: pVia->iga2DISP3DScalingBufferStart=%X\n",
                  pVia->iga2DISP3DScalingBufferStart));
        }        
      
    }
}


void 
VIARandR12UpdataOverlay(int scrnIndex, int x, int y, int flags)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;    
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
 
    int i = 0;
    int ret;
    viaPortPrivPtr pPriv = NULL;
    DBG_DD(("Enter Function : %s\n",__FUNCTION__));    

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    for (i = 0; i < XV_PORT_NUM_OVERLAY; i++) {        
        if (pVia->pPriv[i] != NULL) {
            pPriv = pVia->pPriv[i];
            if (pPriv->videoFlag & VIDEO_ACTIVE) {
                viaDetermineOvlDisplayPath(pScrn, pPriv, 
                    pPriv->src_x, pPriv->src_y, pPriv->drw_x, pPriv->drw_y, 
                    pPriv->src_w, pPriv->src_h, pPriv->drw_w, pPriv->drw_h);
                
                ret = viaRebuildOvlDisplayPath(pScrn, pPriv);
                if(ret == FALSE) {
                    if(!pPriv->redirected) {
                        viaDestroyXvSurface(pScrn, pPriv);
                        pPriv->redirected = TRUE;
                        viaCreateXvSurface(pScrn, pPriv, pPriv->fourCC, pPriv->width, pPriv->height);
                        viaUploadToXVSurface(pScrn, pPriv, pPriv->fourCC, pPriv->buf, \
                        pPriv->pXvSurface, pPriv->width, pPriv->height);
                    }
                } else {
                    if(pPriv->redirected) {
                        viaDestroyXvSurface(pScrn, pPriv);
                        pPriv->redirected = FALSE;
                        viaCreateXvSurface(pScrn, pPriv, pPriv->fourCC, pPriv->width, pPriv->height);
                        viaUploadToXVSurface(pScrn, pPriv, pPriv->fourCC, pPriv->buf, \
                        pPriv->pXvSurface, pPriv->width, pPriv->height);
                    }
                }                
                if(pPriv->redirected) {
                    viaDisplayTexturedVideo(pScrn, pPriv);
                } else {
                    pPriv->updateOvlPath = TRUE;
                    viaDisplayOvlDisplayPath(pScrn, pPriv);
                }
            }
        }
    }
#else
    for (i = XV_PORT_NUM_OVERLAY -1 ; i >= 0; i--) {        
        if (pVia->pPriv[i] != NULL) {
            if(pVia->pPriv[i]->curIGA != 0){
                pPriv = pVia->pPriv[i];
                
                if(pPriv->scrnAttr != viaGfxInfo->screenAttr.uint){
                    pPriv->forceEngReAlloc = TRUE;
                    if(pPriv->videoFlag & VIDEO_ACTIVE) {
                        viaPutImageG(pScrn, pPriv->src_x, pPriv->src_y, 
                                    pPriv->drw_x, pPriv->drw_y, pPriv->src_w,
                                    pPriv->src_h, pPriv->drw_w, pPriv->drw_h,
                                    pPriv->fourCC, pPriv->buf, pPriv->width, pPriv->height,
                                    pPriv->sync, &pPriv->clip, pPriv, pPriv->pDraw);
                    }
                }        
            }
        }
    } 
#endif

    if(via_module_loaded)
	    vvaUpdateOverlay(scrnIndex, x, y);
 
    return;
}


void 
VIAAdjustFrame(int scrnIndex, int x, int y, int flags)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr      pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    viaPortPrivPtr pPriv;
    int i = 0;
    int ret;

    DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIAAdjustFrame\n"));

    if(x < 0 || y <0)
        return;

    if (!pVia->useRandR)
	    /* now program the start address registers*/
	    VIASetStartingAddress(pScrn, x, y); 

    /* Patch for Duoview panning cases:
       The panning_x[], panning_y[] are indexed by Iga Index. */
    /* Unifiy the process of panning_x[], panning_y[] for all case: single, duoview and samm. */
    if (viaGfxInfo->screenInfo[scrnIndex].igaInuse & IGA1) {
        if (viaGfxInfo->igaInfo[0].igaStatus.panning) {
            viaGfxInfo->igaInfo[0].start_x = x;
            viaGfxInfo->igaInfo[0].start_y = y;
            /* Restrict the patch for non-randr samm path only. */
            if (!viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.samm) {
                if (viaGfxInfo->igaAttr.iga2_left) {
                    viaGfxInfo->igaInfo[0].start_x = viaGfxInfo->igaInfo[1].visible_width + x;
                }
                if (viaGfxInfo->igaAttr.iga2_above) {
                    viaGfxInfo->igaInfo[0].start_y = viaGfxInfo->igaInfo[1].visible_height + y;   
                }
            }
            pVidData->panning_x[0] = x;
            pVidData->panning_y[0] = y;
        }
    }

    if (viaGfxInfo->screenInfo[scrnIndex].igaInuse & IGA2) {
        if(viaGfxInfo->igaInfo[1].igaStatus.panning){
            viaGfxInfo->igaInfo[1].start_x = x;
            viaGfxInfo->igaInfo[1].start_y = y;
            /* Restrict the patch for non-randr samm path only. */
            if (!viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.samm) {
                if (viaGfxInfo->igaAttr.iga2_right) {
                    viaGfxInfo->igaInfo[1].start_x = viaGfxInfo->igaInfo[0].visible_width + x;
                }
                if (viaGfxInfo->igaAttr.iga2_below) {
                    viaGfxInfo->igaInfo[1].start_y = viaGfxInfo->igaInfo[0].visible_height + y;   
                }
            }
            pVidData->panning_x[1] = x;
            pVidData->panning_y[1] = y;
        }
    }

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    for (i = 0; i < XV_PORT_NUM_OVERLAY; i++) {        
        if (pVia->pPriv[i] != NULL) {
            pPriv = pVia->pPriv[i];
            if (pPriv->videoFlag & VIDEO_ACTIVE) {
                viaDetermineOvlDisplayPath(pScrn, pPriv, 
                    pPriv->src_x, pPriv->src_y, pPriv->drw_x, pPriv->drw_y, 
                    pPriv->src_w, pPriv->src_h, pPriv->drw_w, pPriv->drw_h);
                
                ret = viaRebuildOvlDisplayPath(pScrn, pPriv);
                if(ret == FALSE) {
                    if(!pPriv->redirected) {
                        viaDestroyXvSurface(pScrn, pPriv);
                        pPriv->redirected = TRUE;
                        viaCreateXvSurface(pScrn, pPriv, pPriv->fourCC, pPriv->width, pPriv->height);
                        viaUploadToXVSurface(pScrn, pPriv, pPriv->fourCC, pPriv->buf, \
                        pPriv->pXvSurface, pPriv->width, pPriv->height);
                    }
                } else {
                    if(pPriv->redirected) {
                        viaDestroyXvSurface(pScrn, pPriv);
                        pPriv->redirected = FALSE;
                        viaCreateXvSurface(pScrn, pPriv, pPriv->fourCC, pPriv->width, pPriv->height);
                        viaUploadToXVSurface(pScrn, pPriv, pPriv->fourCC, pPriv->buf, \
                        pPriv->pXvSurface, pPriv->width, pPriv->height);
                    }
                }
                if(pPriv->redirected) {
                    viaDisplayTexturedVideo(pScrn, pPriv);
                } else {
                    pPriv->updateOvlPath = TRUE;
                    viaDisplayOvlDisplayPath(pScrn, pPriv);
                }
            }
        }
    }
#else
    for (i = XV_PORT_NUM_OVERLAY -1 ; i >= 0; i--) {        
        if (pVia->pPriv[i] != NULL) {
            if(pVia->pPriv[i]->curIGA != 0){
                pPriv = pVia->pPriv[i];
                
                if(pPriv->videoFlag & VIDEO_ACTIVE) {
                    viaPutImageG(pScrn, pPriv->src_x, pPriv->src_y, 
                                pPriv->drw_x, pPriv->drw_y, pPriv->src_w,
                                pPriv->src_h, pPriv->drw_w, pPriv->drw_h,
                                pPriv->fourCC, pPriv->buf, pPriv->width, pPriv->height,
                                pPriv->sync, &pPriv->clip, pPriv, pPriv->pDraw);
                }
            }
        }
    } 
#endif

    if(via_module_loaded)
        vvaUpdateOverlay(scrnIndex, x, y);

    return;
}


Bool 
VIASwitchMode(int scrnIndex, DisplayModePtr mode, int flags)
{   
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr      pVia = VIAPTR(pScrn);
    ServerInfoPtr pServerInfo = pVia->pServerInfo;
    int width,height;
    
    width	= mode->HDisplay;
    height	= mode->VDisplay;

    if (!pVia->useRandR) {
        Bool        result;
        
        /* Load mode line timing */
        VIAGetModeLineTiming(pScrn, mode);

        DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIASwitchMode\n"));

        /* If the screen is under the rotated situation, the OS consider that current mode is a 
           rotated size. For example: 768x1024. So when the OS want to set mode, it will transfer
           a rotated size to request the driver to set this mode(768x1024). But we should set display 
           timing according to non-rotated size.(e.g. 1024x768).
           So we have to convert the rotated size to the normal size.
        */
    /* If we just do SW/HW noRandR rotation 90/270 degree for 2D ONLY, we don't need to do this.
	 * While, if we need XV support for Rotation, we need to swap pScrn->virtualX/pScrn->virtualY,
	 * for XV path cliping window detect.
    */ 
		swap_height_width_for_CWorCCW(pScrn);

        /* Wait Hardware Engine idle to switch graphicd mode */
        WaitIdle();

        if (pVia->VQEnable) { 	
           /* if we use VQ, disable it before we exit */
            switch (pVia->Chipset) {
                case VIA_P4M890:             
                case VIA_K8M890:
                    VIASETREG(0x41c, 0x00100000);
                    VIASETREG(0x420, 0x74301000);
                    break;
                default:  
                    VIASETREG(0x43c, 0x00fe0000);
                    VIASETREG(0x440, 0x00000004);
                    VIASETREG(0x440, 0x40008c0f);
                    VIASETREG(0x440, 0x44000000);
                    VIASETREG(0x440, 0x45080c04);
                    VIASETREG(0x440, 0x46800408);
                    break;
            }
        }

        result = VIAModeInit(xf86Screens[scrnIndex], mode);
      
        /*used for H5-3D to get the screen info after change mode*/
        if (pServerInfo) {
            if (result && (H5_UMA_CHIPID||H6_UMA_CHIPID)) {
                pServerInfo->width = width;
                pServerInfo->height = height;
            }         
        }

        if(!pVia->useRandR && pVia->pScreensPublicInfo->UseHwCursor) {
            VIAHideCursor(pScrn);
            VIALoadIconImage(pScrn, (CARD32 *)(pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIBufStart));
            VIAShowCursor(pScrn);
        }

        /* Revert to the rotated size.(e.g. 1024x768 -> 768x1024)*/
		swap_height_width_for_CWorCCW(pScrn);
	
        return result;
    } else {
#ifdef VIA_RANDR12_SUPPORT        
        DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "VIASwitchMode\n"));
        DEBUG(xf86DrvMsg(scrnIndex, X_INFO, "xf86SetSingleMode\n"));

        return xf86SetSingleMode(pScrn, mode, RR_Rotate_0);
#endif        
    }
}



static void 
VIAPreSaveReg(ScrnInfoPtr pScrn)
{
    static int  IsSaved = FALSE;
    VIAPtr      pVia = VIAPTR(pScrn);
    VIARegPtr   save = &pVia->SavedReg; 

    /* To fix the problem: In SAMM, the system will hang when suspends.
       (On VT3364) In VIAEnableMMIO(), it will enable software reset of 
       SR1A, so the value of SR1A we saved is not the original value set 
       by BIOS, and we found that it will cause system hang when restore
       registers in VIALeaveVT(). In order to keep the original value set
       by BIOS, we should save SR1A before doing VIAEnableMMIO() to avoid
       this problem. So, we move the saving code from VIASave() to here.
    */
    if (!IsSaved) {
        VGAOUT8(0x3d4, CR08);
        save->CRTCRegs[0x08] = VGAIN8(0x3d5);
        VGAOUT8(0x3d4, CR09);
        save->CRTCRegs[0x09] = VGAIN8(0x3d5);
        VGAOUT8(0x3C4, SR1A);
        save->SRRegs[0x1A] = VGAIN8(0x3C5);   

        IsSaved  = TRUE;
    }
}


void 
VIAEnableMMIO(ScrnInfoPtr pScrn)
{
    vgaHWPtr hwp = VGAHWPTR(pScrn);
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    unsigned char val;

    /* If we are primary card, we still use std vga port. If we use
     * MMIO, system will hang in vgaHWSave when our card used in
     * PLE and KLE (integrated Trident MVP4)
     */
    if (xf86IsPrimaryPci(pVia->PciInfo)) {
        vgaHWSetStdFuncs(hwp);
    }
    else {
        vgaHWSetMmioFuncs(hwp, pVia->MapBase, 0x8000);
    }

    val = VGAIN8(0x3c3);
    VGAOUT8(0x3c3, val | 0x01);
    val = VGAIN8(VGA_MISC_OUT_R);
    VGAOUT8(VGA_MISC_OUT_W, val | 0x01);

    /* Unlock Extended IO Space */
    VGAOUT8(0x3c4, 0x10);
    VGAOUT8(0x3c5, 0x01);
    /* Unlock CRTC register protect */
    VGAOUT8(0x3d4, 0x47);
    VGAOUT8(0x3d5, VGAIN8(0x3d5) & ~0x01);

    /* Save some important register before we change its value */
    VIAPreSaveReg(pScrn);

    /* Enable MMIO */
    if (pVia->IsSecondary || pBIOSInfo->UseIGA2) {
        VGAOUT8(0x3c4, 0x1a);
        val = VGAIN8(0x3c5);
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "secondary val = %x\n", val));
        VGAOUT8(0x3c5, val | 0x38);
    } 
    return;
}


void 
VIALoadPalette(ScrnInfoPtr pScrn, int numColors, int *indicies,
                    LOCO *colors, VisualPtr pVisual)
{
    VIAPtr pVia = VIAPTR(pScrn);
    if (pVia->useRandR) {
#ifdef VIA_RANDR12_SUPPORT  
        xf86CrtcConfigPtr   xf86_config = XF86_CRTC_CONFIG_PTR(pScrn);
        int i,j,index,k;
        unsigned short lut_r[256], lut_g[256], lut_b[256];
        
        for (k = 0; k < xf86_config->num_crtc; k++) {
            xf86CrtcPtr    crtc = xf86_config->crtc[k];
            VIACrtcPrivatePtr viaCrtc = VIACrtcPrivate(crtc);
    
            /* Initialize to the old lookup table values. */
            for (i = 0; i < 256; i++) {
                    lut_r[i] = viaCrtc->colors[i].red<< 8;
                    lut_g[i] = viaCrtc->colors[i].green << 8;
                    lut_b[i] = viaCrtc->colors[i].blue<< 8;
            }
    
            switch (pScrn->depth) {
                case 15:
                    for (i = 0; i < numColors; i++) {
                        index = indicies[i];
                        for (j = 0; j < 8; j++) {
                            lut_r[index * 8 + j] = colors[index].red << 8;
                            lut_g[index * 8 + j] = colors[index].green << 8;
                            lut_b[index * 8 + j] = colors[index].blue << 8;
                        }
                    }
                    break;
                case 16:
                    for (i = 0; i < numColors; i++) {
                        index = indicies[i];
        
                        if (index <= 31) {
                            for (j = 0; j < 8; j++) {
                                lut_r[index * 8 + j] = colors[index].red << 8;
                                lut_b[index * 8 + j] = colors[index].blue << 8;
                            }
                        }
        
                        for (j = 0; j < 4; j++) {
                            lut_g[index * 4 + j] = colors[index].green << 8;
                        }
                    }
                    break;
                default:
                    for (i = 0; i < numColors; i++) {
                        index = indicies[i];
                        lut_r[index] = colors[index].red << 8;
                        lut_g[index] = colors[index].green << 8;
                        lut_b[index] = colors[index].blue << 8;
                    }
                    break;
            }
            
        /* Make the change through RandR */
#ifdef RANDR_12_INTERFACE
            RRCrtcGammaSet(crtc->randr_crtc, lut_r, lut_g, lut_b);
#else /*RANDR_12_INTERFACE*/
            crtc->funcs->gamma_set(crtc, lut_r, lut_g, lut_b, 256);
#endif
        }
#endif /*VIA_RANDR12_SUPPORT*/
    } else {
        int i, index;
        int sr1a, sr1b, cr67, cr6a;

        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIALoadPalette\n"));    
        
        if (pScrn->bitsPerPixel != 8)
            return;
        
        VGAOUT8(0x3C4, SR1A);
        sr1a = VGAIN8(0x3C5);
        VGAOUT8(0x3C4, SR1B);
        sr1b = VGAIN8(0x3C5);
        VGAOUT8(0x3D4, CR67);
        cr67 = VGAIN8(0x3D5);
        VGAOUT8(0x3D4, CR6A);
        cr6a = VGAIN8(0x3D5);

        /* We should initialize the values of both LUT, or sometimes */
        /* the display color on IGA2 may be incorrect. */

        /* Prepare for IGA2's LUT initialization: */
        VGAOUT8(0x3C4, SR1A);
        VGAOUT8(0x3C5, sr1a | 0x01);    /* Change Shadow to Secondary Display's LUT. */
        
        VGAOUT8(0x3C4, SR1B);    
        VGAOUT8(0x3C5, sr1b | 0x80);    /* Enable Secondary Display Engine. */
        
        VGAOUT8(0x3D4, CR67);
        VGAOUT8(0x3D5, cr67 & 0x3F);    /* Second Display Color Depth should be 8bpp. */

        /* If secondary display had been enable, we don't need to enable it again.
           Otherwise, the integrated TV's screen maybe incorrect which is caused by sync problem. */
        VGAOUT8(0x3D4, CR6A);           
        if (!(VGAIN8(0x3D5) & 0x80)) {
            /* Enable Second Display Channel. Please keep the setting sequence. */
            VGAOUT8(0x3D5, VGAIN8(0x3D5) & 0xBF);   /* Set CR6A[6] to 0. */
            VGAOUT8(0x3D5, VGAIN8(0x3D5) | 0x80);   /* Set CR6A[7] to 1. */
            VGAOUT8(0x3D5, VGAIN8(0x3D5) | 0x40);   /* Set CR6A[6] to 1. */
        }

        /* Fill in IGA2's LUT. */
        for (i = 0; i < numColors; i++) {
            index = indicies[i];
            VGAOUT8(0x3c8, index);
            VGAOUT8(0x3c9, colors[index].red);
            VGAOUT8(0x3c9, colors[index].green);
            VGAOUT8(0x3c9, colors[index].blue);
        }
        
        /* Prepare for initialize IGA1's LUT: */
        VGAOUT8(0x3C4, SR1A);
        VGAOUT8(0x3C5, sr1a); /* Change to Primary Display's LUT. */
        VGAOUT8(0x3C4, SR1B);
        VGAOUT8(0x3C5, sr1b);
        VGAOUT8(0x3D4, CR67);
        VGAOUT8(0x3D5, cr67);
        VGAOUT8(0x3D4, CR6A);
        VGAOUT8(0x3D5, cr6a);

        /* Fill in IGA1's LUT. */
        for (i = 0; i < numColors; i++) {
            index = indicies[i];
            VGAOUT8(0x3c8, index);
            VGAOUT8(0x3c9, colors[index].red);
            VGAOUT8(0x3c9, colors[index].green);
            VGAOUT8(0x3c9, colors[index].blue);
        }
    }
}


static void 
VIADPMS(ScrnInfoPtr pScrn, int mode, int flags)
{
    VIAPtr          pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    CARD8           cr36;

    /* RandR12 will take care of this by itself. */
    if (pVia->useRandR)
        return;
    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIADPMS\n"));    

    /* Clear DPMS setting */
    VGAOUT8(0x3d4, 0x36);
    cr36 = VGAIN8(0x3d5) & ~0x30;

    switch (mode) {
        case DPMSModeOn:
            if (pBIOSInfo->ActiveDevice & VIA_DEVICE_CRT1) {
                VGAOUT(0x3d4, 0x36);
                VGAOUT(0x3d5, cr36);
            }
            if (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD)
                VIAEnableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));
            
            if (pBIOSInfo->ActiveDevice & VIA_DEVICE_DFP)
                VIAEnableDFP(pBIOSInfo);

            break;
        
        case DPMSModeStandby:
        case DPMSModeSuspend:
        case DPMSModeOff:
            if (pBIOSInfo->ActiveDevice & VIA_DEVICE_CRT1) {
                VGAOUT(0x3d4, 0x36);
                VGAOUT(0x3d5, cr36 | 0x30);
            }
            
            if (pBIOSInfo->ActiveDevice & (VIA_DEVICE_DFP | VIA_DEVICE_LCD))
                VIADisableLCD(pBIOSInfo, &(pBIOSInfo->LVDSSettingInfo));

            if (pBIOSInfo->ActiveDevice & VIA_DEVICE_DFP)
                VIADisableDFP(pBIOSInfo);
            
            break;
        
        default:
            xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
                   "Invalid DPMS mode %d\n", mode);
            break;
    }

    return;
}



/* Active Device according connected status */
Bool 
VIADeviceSelection(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    /*unsigned int  i;
    unsigned char   numDevice;*/
    pBIOSInfo->SAMM = FALSE;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIADeviceSelection\n"));
        
    /* if Option "ActiveDevice" hasn't set, active device according CMOS */
    if (!pBIOSInfo->ActiveDevice)
        pBIOSInfo->ActiveDevice = pVia->pChipInfo->biosActiveDev;
    /* if xorg.conf set SAMM, and only active one device, active device according CMOS */
    else if (pVia->IsSecondary &&
            (pBIOSInfo->ActiveDevice == VIA_DEVICE_CRT1 ||
             pBIOSInfo->ActiveDevice == VIA_DEVICE_LCD  ||
             pBIOSInfo->ActiveDevice == VIA_DEVICE_DFP  ))
        pBIOSInfo->ActiveDevice = BIOS_GetActiveDevice(pScrn);
    
    if (((pBIOSInfo->ActiveDevice & pBIOSInfo->ConnectedDevice) == pBIOSInfo->ActiveDevice)
         && (pVia->IsSecondary))
        pBIOSInfo->SAMM = TRUE;
    
    pBIOSInfo->ActiveDevice &= pBIOSInfo->ConnectedDevice;
    pVia->ActiveDevice = pBIOSInfo->ActiveDevice;
    
    /* To keep the actual active device no matter it is in SAMM or Duoview. */
    pBIOSInfo->ActualActiveDevice = pVia->ActiveDevice;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                    "Actual Connected Device is 0x%x\n",
                    pBIOSInfo->ConnectedDevice));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                    "Actual Active Device is 0x%x\n",
                    pBIOSInfo->ActiveDevice));

    return TRUE;
}


/* SAMM device dispatch */
Bool 
VIASetDisplayPath_SAMM(ScrnInfoPtr pScrn)
{
    DevUnion* pPriv = xf86GetEntityPrivate(pScrn->entityList[0], gVIAEntityIndex);
    VIAEntPtr pVIAEnt = pPriv->ptr;
    VIAPtr pVia1 = VIAPTR(pScrn);
    VIAPtr pVia0 = VIAPTR(pVIAEnt->pPrimaryScrn);
    VIABIOSInfoPtr pBIOSInfo1 = pVia1->pBIOSInfo;
    VIABIOSInfoPtr pBIOSInfo0 = pVia0->pBIOSInfo;

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetDisplayPath_SAMM\n"));
    pBIOSInfo0->SAMM = TRUE;
    pBIOSInfo1->PrimaryDevice = pBIOSInfo0->PrimaryDevice;    
    
    switch (pBIOSInfo1->ActiveDevice) {
        case (VIA_DEVICE_CRT1 | VIA_DEVICE_LCD):
            if (pBIOSInfo0->PrimaryDevice == VIA_DEVICE_LCD) {
                /* LCD+CRT */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_LCD;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_CRT1;                
                pBIOSInfo0->LVDSSettingInfo.IGAPath = IGA2;
                pBIOSInfo1->CRTSettingInfo.IGAPath = IGA1;
            } else {
                /* CRT+LCD */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_CRT1;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_LCD;
                pBIOSInfo0->CRTSettingInfo.IGAPath = IGA1;
                pBIOSInfo1->LVDSSettingInfo.IGAPath = IGA2;
            }
            break;
            
        case (VIA_DEVICE_CRT1 | VIA_DEVICE_DFP):
            if (pBIOSInfo0->PrimaryDevice == VIA_DEVICE_DFP) {
                /* DVI+CRT */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_DFP;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_CRT1;
                pBIOSInfo0->TMDSSettingInfo.IGAPath = IGA1;
                pBIOSInfo1->CRTSettingInfo.IGAPath = IGA2;
            } else {
                /* CRT+DVI */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_CRT1;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_DFP;
                pBIOSInfo0->CRTSettingInfo.IGAPath = IGA1;
                pBIOSInfo1->TMDSSettingInfo.IGAPath = IGA2;
            }
            break;
            
        case (VIA_DEVICE_LCD | VIA_DEVICE_DFP):
            if (pBIOSInfo0->PrimaryDevice == VIA_DEVICE_DFP) {
                /* DVI+LCD */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_DFP;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_LCD;
                pBIOSInfo0->TMDSSettingInfo.IGAPath = IGA1;
                pBIOSInfo1->LVDSSettingInfo.IGAPath = IGA2;
            } else {
                /* LCD+DVI */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_LCD;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_DFP;
                pBIOSInfo0->LVDSSettingInfo.IGAPath = IGA2;
                pBIOSInfo1->TMDSSettingInfo.IGAPath = IGA1;
            }
            break;

        case (VIA_DEVICE_LCD | VIA_DEVICE_LCD2):
            if (pBIOSInfo0->PrimaryDevice == VIA_DEVICE_LCD) {
                /* LCD+LCD2 */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_LCD;
                pBIOSInfo0->LVDSSettingInfo.IGAPath = IGA1;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_LCD2;
                pBIOSInfo1->LVDSSettingInfo2.IGAPath = IGA2;
            } else {
                /* LCD2+LCD */
                pBIOSInfo0->ActiveDevice = VIA_DEVICE_LCD2;                
                pBIOSInfo0->LVDSSettingInfo2.IGAPath = IGA1;
                pBIOSInfo1->ActiveDevice = VIA_DEVICE_LCD;
                pBIOSInfo1->LVDSSettingInfo.IGAPath = IGA2;
            }            
            break;
            
        default:
            return FALSE;            
    }

    DEBUG(xf86DrvMsg(pVIAEnt->pPrimaryScrn->scrnIndex, X_INFO,
          "Scrn0: Active Device is 0x%x\n", pBIOSInfo0->ActiveDevice));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "Scrn1: Active Device is 0x%x\n", pBIOSInfo1->ActiveDevice));
    DEBUG(xf86DrvMsg(pVIAEnt->pPrimaryScrn->scrnIndex,  X_INFO,
          "Primary: CRT=%d, DFP=%d, LCD=%d\n",
          pBIOSInfo0->CRTSettingInfo.IGAPath,
          pBIOSInfo0->TMDSSettingInfo.IGAPath,
          pBIOSInfo0->LVDSSettingInfo.IGAPath));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "Secondary: CRT=%d,DFP=%d, LCD=%d\n",
          pBIOSInfo1->CRTSettingInfo.IGAPath,
          pBIOSInfo1->TMDSSettingInfo.IGAPath,
          pBIOSInfo1->LVDSSettingInfo.IGAPath));

    return TRUE;
}


void 
VIASetDisplayPath(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    VIACheckIfUseDuoView(pScrn);    

    if (pVia->IsSecondary) {
        /* SAMM: */
        if (pBIOSInfo->SAMM) {
            xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetDisplayPath is SAMM\n");        
            VIASetDisplayPath_SAMM(pScrn);
        }
    } else if (pBIOSInfo->DuoView) {
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetDisplayPath is DuoView\n"); 
        /* DuoView: */
        switch (pBIOSInfo->ActiveDevice) {
            case (VIA_DEVICE_CRT1 | VIA_DEVICE_LCD):
                pBIOSInfo->CRTSettingInfo.IGAPath = IGA1;
                pBIOSInfo->LVDSSettingInfo.IGAPath = IGA2;
                break;
                
            case (VIA_DEVICE_CRT1 | VIA_DEVICE_DFP):
                pBIOSInfo->CRTSettingInfo.IGAPath = IGA1;
                pBIOSInfo->TMDSSettingInfo.IGAPath = IGA2;
                break;
                
            case (VIA_DEVICE_LCD | VIA_DEVICE_DFP):
                pBIOSInfo->TMDSSettingInfo.IGAPath = IGA1;
                pBIOSInfo->LVDSSettingInfo.IGAPath = IGA2;
                break;

            case (VIA_DEVICE_LCD | VIA_DEVICE_LCD2):
                pBIOSInfo->LVDSSettingInfo.IGAPath = IGA2;
                pBIOSInfo->LVDSSettingInfo2.IGAPath = IGA2;
                break;
                
                
            default :
                pBIOSInfo->CRTSettingInfo.IGAPath = IGA1;
                break;
        }
    } else {
        xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIASetDisplayPath is Single\n"); 
        /* Simultaneous: */
        pBIOSInfo->CRTSettingInfo.IGAPath = IGA1;
        pBIOSInfo->TMDSSettingInfo.IGAPath = IGA1;
        pBIOSInfo->LVDSSettingInfo.IGAPath = IGA2;              
    }
                                                
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Active Device is 0x%x\n",
          pBIOSInfo->ActiveDevice));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "IGA: CRT=%d, DFP=%d, LCD=%d \n", 
          pBIOSInfo->CRTSettingInfo.IGAPath,
          pBIOSInfo->TMDSSettingInfo.IGAPath,
          pBIOSInfo->LVDSSettingInfo.IGAPath));
}

void 
VIADebugBreak()
{
    /* use int3 to set breakpoint */
    __asm __volatile("int $3");
}


void
VIAInitialize3DEngine(ScrnInfoPtr pScrn)
{
#ifndef CS_FLAG_NO_3D_SCAL
    VIAPtr  pVia = VIAPTR(pScrn);
    int i;
    DWORD StageOfTexture;
    WaitIdle();
    /*
     * read CR32 for the suspend or resume information
     * Bit 7:1 work from suspend
     *       0 work normally
     */
    xf86DrvMsg(pScrn->scrnIndex, X_INFO,"into 3D initial...3Dinitial? %d\n",b3DRegsInitialized);
    if (H5_UMA_CHIPID) {
        if (!b3DRegsInitialized || !VIACheckDrmAlreadyInit(pScrn)) {
        
            VIASETREG(0x43C, 0x00010000);
        
            for (i = 0; i <= 0x8A; i++)
                VIASETREG(0x440, (CARD32) i << 24);
            
            /* Initial Texture Stage Setting*/
            for (StageOfTexture = 0; StageOfTexture < 0xf; StageOfTexture++) {
                VIASETREG(0x43C, (0x00020000 | 0x00000000 | (StageOfTexture & 0xf)<<24));
                for (i = 0 ; i <= 0x30 ; i++ )
                    VIASETREG(0x440, (CARD32) i << 24);
            }
            
            /* Initial Texture Sampler Setting*/
            for (StageOfTexture = 0; StageOfTexture < 0xf; StageOfTexture++) {
                VIASETREG(0x43C, (0x00020000 | 0x00020000 | (StageOfTexture & 0xf)<<24));
                for (i = 0 ; i <= 0x30 ; i++ )
                    VIASETREG(0x440, (CARD32) i << 24);
            }

            VIASETREG(0x43C, (0x00020000 | 0xfe000000));
            for (i = 0 ; i <= 0x13 ; i++ )
                VIASETREG(0x440, (CARD32) i << 24);

            /* Initial Gamma Table Setting*/
            /* Initial Gamma Table Setting*/
            /* 5 + 4 = 9 (12) dwords*/
            /* sRGB texture is not directly support by H3 hardware.*/
            /* We have to set the deGamma table for texture sampling.*/

            /* degamma table*/
            VIASETREG(0x43C, ( 0x00030000 | 0x15000000));
            VIASETREG(0x440, (0x40000000 | (30 << 20) | (15 << 10) | (5)));
            VIASETREG(0x440, ((119 << 20) | (81 << 10) | (52)));
            VIASETREG(0x440, ((283 << 20) | (219 << 10) | (165)));
            VIASETREG(0x440, ((535 << 20) | (441 << 10) | (357)));
            VIASETREG(0x440, ((119 << 20) | (884 << 20) | (757 << 10) | (640)));

            /* gamma table*/
            VIASETREG(0x43C, ( 0x00030000 | 0x17000000));
            VIASETREG(0x440, (0x40000000 | (13 << 20) | (13 << 10) | (13)));
            VIASETREG(0x440, (0x40000000 | (26 << 20) | (26 << 10) | (26)));
            VIASETREG(0x440, (0x40000000 | (39 << 20) | (39 << 10) | (39)));
            VIASETREG(0x440, ((51 << 20) | (51 << 10) | (51)));
            VIASETREG(0x440, ((71 << 20) | (71 << 10) | (71)));
            VIASETREG(0x440, (87 << 20) | (87 << 10) | (87));
            VIASETREG(0x440, (113 << 20) | (113 << 10) | (113));
            VIASETREG(0x440, (135 << 20) | (135 << 10) | (135));
            VIASETREG(0x440, (170 << 20) | (170 << 10) | (170));
            VIASETREG(0x440, (199 << 20) | (199 << 10) | (199));
            VIASETREG(0x440, (246 << 20) | (246 << 10) | (246));
            VIASETREG(0x440, (284 << 20) | (284 << 10) | (284));
            VIASETREG(0x440, (317 << 20) | (317 << 10) | (317));
            VIASETREG(0x440, (347 << 20) | (347 << 10) | (347));
            VIASETREG(0x440, (373 << 20) | (373 << 10) | (373));
            VIASETREG(0x440, (398 << 20) | (398 << 10) | (398));
            VIASETREG(0x440, (442 << 20) | (442 << 10) | (442));
            VIASETREG(0x440, (481 << 20) | (481 << 10) | (481));
            VIASETREG(0x440, (517 << 20) | (517 << 10) | (517));
            VIASETREG(0x440, (550 << 20) | (550 << 10) | (550));
            VIASETREG(0x440, (609 << 20) | (609 << 10) | (609));
            VIASETREG(0x440, (662 << 20) | (662 << 10) | (662));
            VIASETREG(0x440, (709 << 20) | (709 << 10) | (709));
            VIASETREG(0x440, (753 << 20) | (753 << 10) | (753));
            VIASETREG(0x440, (794 << 20) | (794 << 10) | (794));
            VIASETREG(0x440, (832 << 20) | (832 << 10) | (832));
            VIASETREG(0x440, (868 << 20) | (868 << 10) | (868));
            VIASETREG(0x440, (902 << 20) | (902 << 10) | (902));
            VIASETREG(0x440, (934 << 20) | (934 << 10) | (934));
            VIASETREG(0x440, (966 << 20) | (966 << 10) | (966));
            VIASETREG(0x440, (996 << 20) | (996 << 10) | (996));
            
            
            /* For Interrupt Restore only
               All types of write through regsiters should be write header data to
               hardware at least before it can restore. H/W will automatically record
               the header to write through state buffer for resture usage.
               By Jaren:
               HParaType = 8'h03, HParaSubType = 8'h00
                                                 8'h11
                                                 8'h12
                                                 8'h14
                                                 8'h15
                                                 8'h17
               HParaSubType 8'h12, 8'h15 is initialized.
              [HWLimit]
               1. All these write through registers can't be partial update.
               2. All these write through must be AGP command
               16 entries : 4 128-bit data */

    	 /* Initialize INV_ParaSubType_TexPal  	 */
    	    VIASETREG(0x43C, ( 0x00030000 | 0x00000000));
            for (i = 0; i < 16; i++)
                VIASETREG(0x440, 0x00000000);

            /* Initialize INV_ParaSubType_4X4Cof */
            /* 32 entries : 8 128-bit data */
            VIASETREG(0x43C, ( 0x00030000 | 0x11000000)); 
            for (i = 0; i < 32; i++)
                VIASETREG(0x440, 0x00000000);

            /* Initialize INV_ParaSubType_StipPal */
            /* 5 entries : 2 128-bit data */
            VIASETREG(0x43C, ( 0x00030000 | 0x14000000)); 
            for (i = 0; i < (5+3); i++)
                VIASETREG(0x440, 0x00000000);

            /* primitive setting & vertex format*/
            VIASETREG(0x43C, ( 0x00040000 |0x14000000));
            for( i = 0; i<52; i++)
                VIASETREG(0x440, ((DWORD) i << 24));
#if 1            
            VIASETREG(0x43C, 0x00fe0000);
            VIASETREG(0x440, 0x4000840f);
            VIASETREG(0x440, 0x47000400);
            VIASETREG(0x440, 0x44000000);
            VIASETREG(0x440, 0x46000000); 
#endif
            b3DRegsInitialized = 1;
            xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                "H5 3D Engine has been initilized.\n");
        }            
        /* setting Misconfig*/
        VIASETREG(0x43C, 0x00fe0000); 
        VIASETREG(0x440, 0x00001004);
        VIASETREG(0x440, 0x0800004b);
        VIASETREG(0x440, 0x0a000049);
        VIASETREG(0x440, 0x0b0000fb);
        VIASETREG(0x440, 0x0c000001);
        VIASETREG(0x440, 0x0d0000cb);
        VIASETREG(0x440, 0x0e000009);
        VIASETREG(0x440, 0x10000000);
        VIASETREG(0x440, 0x110000ff);
        VIASETREG(0x440, 0x12000000);
        VIASETREG(0x440, 0x130000db);
        VIASETREG(0x440, 0x14000000);
        VIASETREG(0x440, 0x15000000);
        VIASETREG(0x440, 0x16000000);
        VIASETREG(0x440, 0x17000000);
        VIASETREG(0x440, 0x18000000);
        VIASETREG(0x440, 0x19000000);
        VIASETREG(0x440, 0x20000000);
    } else if(H6_UMA_CHIPID) {
        if (!b3DRegsInitialized || !VIACheckDrmAlreadyInit(pScrn)) {
        
            VIASETREG(0x43C, 0x00010000);
            for (i = 0; i <= 0x9A; i++)
                VIASETREG(0x440, (CARD32) i << 24);
            
            /* Initial Texture Stage Setting*/
            for (StageOfTexture = 0; StageOfTexture <= 0xf; StageOfTexture++) {
                VIASETREG(0x43C, (0x00020000 | 0x00000000 | (StageOfTexture & 0xf)<<24));
                for (i = 0 ; i <= 0x30 ; i++ )
                     VIASETREG(0x440, (CARD32) i << 24);
            }
            
            /* Initial Texture Sampler Setting*/
            for (StageOfTexture = 0; StageOfTexture <= 0xf; StageOfTexture++) {
                VIASETREG(0x43C, (0x00020000 | 0x20000000 | (StageOfTexture & 0xf)<<24));
                for ( i = 0 ; i <= 0x36 ; i++ )
                    VIASETREG(0x440, (CARD32) i << 24);
            }

            VIASETREG(0x43C, (0x00020000 | 0xfe000000));
            for ( i = 0 ; i <= 0x13 ; i++ )
                VIASETREG(0x440, (CARD32) i << 24);

            /* Initial Gamma Table Setting*/
            /* Initial Gamma Table Setting*/
            /* 5 + 4 = 9 (12) dwords*/
            /* sRGB texture is not directly support by H3 hardware.*/
            /* We have to set the deGamma table for texture sampling.*/

            /* degamma table*/
            VIASETREG(0x43C, ( 0x00030000 | 0x15000000));
            VIASETREG(0x440, (0x40000000 | (30 << 20) | (15 << 10) | (5)));
            VIASETREG(0x440, ((119 << 20) | (81 << 10) | (52)));
            VIASETREG(0x440, ((283 << 20) | (219 << 10) | (165)));
            VIASETREG(0x440, ((535 << 20) | (441 << 10) | (357)));
            VIASETREG(0x440, ((119 << 20) | (884 << 20) | (757 << 10) | (640)));

            /* gamma table*/
            VIASETREG(0x43C, ( 0x00030000 | 0x17000000));
            VIASETREG(0x440, (0x40000000 | (13 << 20) | (13 << 10) | (13)));
            VIASETREG(0x440, (0x40000000 | (26 << 20) | (26 << 10) | (26)));
            VIASETREG(0x440, (0x40000000 | (39 << 20) | (39 << 10) | (39)));
            VIASETREG(0x440, ((51 << 20) | (51 << 10) | (51)));
            VIASETREG(0x440, ((71 << 20) | (71 << 10) | (71)));
            VIASETREG(0x440, (87 << 20) | (87 << 10) | (87));
            VIASETREG(0x440, (113 << 20) | (113 << 10) | (113));
            VIASETREG(0x440, (135 << 20) | (135 << 10) | (135));
            VIASETREG(0x440, (170 << 20) | (170 << 10) | (170));
            VIASETREG(0x440, (199 << 20) | (199 << 10) | (199));
            VIASETREG(0x440, (246 << 20) | (246 << 10) | (246));
            VIASETREG(0x440, (284 << 20) | (284 << 10) | (284));
            VIASETREG(0x440, (317 << 20) | (317 << 10) | (317));
            VIASETREG(0x440, (347 << 20) | (347 << 10) | (347));
            VIASETREG(0x440, (373 << 20) | (373 << 10) | (373));
            VIASETREG(0x440, (398 << 20) | (398 << 10) | (398));
            VIASETREG(0x440, (442 << 20) | (442 << 10) | (442));
            VIASETREG(0x440, (481 << 20) | (481 << 10) | (481));
            VIASETREG(0x440, (517 << 20) | (517 << 10) | (517));
            VIASETREG(0x440, (550 << 20) | (550 << 10) | (550));
            VIASETREG(0x440, (609 << 20) | (609 << 10) | (609));
            VIASETREG(0x440, (662 << 20) | (662 << 10) | (662));
            VIASETREG(0x440, (709 << 20) | (709 << 10) | (709));
            VIASETREG(0x440, (753 << 20) | (753 << 10) | (753));
            VIASETREG(0x440, (794 << 20) | (794 << 10) | (794));
            VIASETREG(0x440, (832 << 20) | (832 << 10) | (832));
            VIASETREG(0x440, (868 << 20) | (868 << 10) | (868));
            VIASETREG(0x440, (902 << 20) | (902 << 10) | (902));
            VIASETREG(0x440, (934 << 20) | (934 << 10) | (934));
            VIASETREG(0x440, (966 << 20) | (966 << 10) | (966));
            VIASETREG(0x440, (996 << 20) | (996 << 10) | (996));
            
            
            /* For Interrupt Restore only
               All types of write through regsiters should be write header data to
               hardware at least before it can restore. H/W will automatically record
               the header to write through state buffer for resture usage.
               By Jaren:
               HParaType = 8'h03, HParaSubType = 8'h00
                                                 8'h11
                                                 8'h12
                                                 8'h14
                                                 8'h15
                                                 8'h17
               HParaSubType 8'h12, 8'h15 is initialized.
              [HWLimit]
               1. All these write through registers can't be partial update.
               2. All these write through must be AGP command
               16 entries : 4 128-bit data */

    	 /* Initialize INV_ParaSubType_TexPal  	 */
    	    VIASETREG(0x43C, ( 0x00030000 | 0x00000000));
            for (i = 0; i < 16; i++)
                VIASETREG(0x440, 0x00000000);

            /* Initialize INV_ParaSubType_4X4Cof */
            /* 32 entries : 8 128-bit data */
            VIASETREG(0x43C, ( 0x00030000 | 0x11000000)); 
            for (i = 0; i < 32; i++)
                VIASETREG(0x440, 0x00000000);

            /* Initialize INV_ParaSubType_StipPal */
            /* 5 entries : 2 128-bit data */
            VIASETREG(0x43C, ( 0x00030000 | 0x14000000)); 
            for (i = 0; i < (5+3); i++)
                 VIASETREG(0x440, 0x00000000);

            /* primitive setting & vertex format*/
            VIASETREG(0x43C, ( 0x00040000));
            for( i = 0; i<=0x62; i++)
                 VIASETREG(0x440, ((DWORD) i << 24));

            /*ParaType 0xFE - Configure and Misc Setting*/
			VIASETREG(0x43C, ( 0x00fe0000));
            for( i = 0; i<=0x47; i++)
                 VIASETREG(0x440, ((DWORD) i << 24));

            /*ParaType 0x11 - Frame Buffer Auto-Swapping and 
            Command Regulator Misc*/
			VIASETREG(0x43C, ( 0x00110000));
            for( i = 0; i<=0x20; i++)
                 VIASETREG(0x440, ((DWORD) i << 24));

#if 1            
            VIASETREG(0x43C, 0x00fe0000);
            VIASETREG(0x440, 0x4000840f);
            VIASETREG(0x440, 0x47000404);
            VIASETREG(0x440, 0x44000000);
            VIASETREG(0x440, 0x46000005); 
#endif
            b3DRegsInitialized = 1;
            xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                "H6 3D Engine has been initilized.\n");
        }            
        /* setting Misconfig*/
        VIASETREG(0x43C, 0x00fe0000); 
        VIASETREG(0x440, 0x00001004);
        VIASETREG(0x440, 0x08000249);
        VIASETREG(0x440, 0x0a0002c9);
        VIASETREG(0x440, 0x0b0002fb);
        VIASETREG(0x440, 0x0c000000);
        VIASETREG(0x440, 0x0d0002cb);
        VIASETREG(0x440, 0x0e000009);
        VIASETREG(0x440, 0x10000049);
        VIASETREG(0x440, 0x110002ff);
        VIASETREG(0x440, 0x12000008);
        VIASETREG(0x440, 0x130002db);
    } else {
        if (!b3DRegsInitialized || !VIACheckDrmAlreadyInit(pScrn)) {
            VIASETREG(0x43C, 0x00010000);
            for (i = 0; i <= 0x7D; i++)
                VIASETREG(0x440, (CARD32) i << 24);
        
            VIASETREG(0x43C, 0x00020000);
            for (i = 0; i <= 0x94; i++)
                VIASETREG(0x440, (CARD32) i << 24);
        
            VIASETREG(0x440, 0x82400000);
            VIASETREG(0x43C, 0x01020000);
            for (i = 0; i <= 0x94; i++)
                VIASETREG(0x440, (CARD32) i << 24);
        
            VIASETREG(0x440, 0x82400000);
            VIASETREG(0x43C, 0xfe020000);
            for (i = 0; i <= 0x03; i++)
                VIASETREG(0x440, (CARD32) i << 24);
        
            VIASETREG(0x43C, 0x00030000);
            for (i = 0; i <= 0xff; i++)
                VIASETREG(0x440, 0);

            VIASETREG(0x43C, 0x00100000);
            VIASETREG(0x440, 0x00333004);
            VIASETREG(0x440, 0x10000002);
            VIASETREG(0x440, 0x60000000);
            VIASETREG(0x440, 0x61000000);
            VIASETREG(0x440, 0x62000000);
            VIASETREG(0x440, 0x63000000);
            VIASETREG(0x440, 0x64000000);
            
            VIASETREG(0x43C, 0x00fe0000);
        
            if (pVia->ChipRev >= 3 )
                VIASETREG(0x440,0x40008c0f);
            else
                VIASETREG(0x440,0x4000800f);
        
            VIASETREG(0x440,0x44000000);
            VIASETREG(0x440,0x45080C04);
            VIASETREG(0x440,0x46800408);
            VIASETREG(0x440,0x50000000);
            VIASETREG(0x440,0x51000000);
            VIASETREG(0x440,0x52000000);
            VIASETREG(0x440,0x53000000);
        
            b3DRegsInitialized = 1;
            xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                "H2 3D Engine has been initilized.\n");
        }
        
        VIASETREG(0x43C,0x00fe0000);
        VIASETREG(0x440,0x08000001);
        VIASETREG(0x440,0x0A000183);
        VIASETREG(0x440,0x0B00019F);
        VIASETREG(0x440,0x0C00018B);
        VIASETREG(0x440,0x0D00019B);
        VIASETREG(0x440,0x0E000000);
        VIASETREG(0x440,0x0F000000);
        VIASETREG(0x440,0x10000000);
        VIASETREG(0x440,0x11000000);
        VIASETREG(0x440,0x20000000); 
    
    }    
#endif /* CS_FLAG_NO_3D_SCAL */
}


/*
 * This function is only required if we need to do anything related to power managemant
 * and via private event handling.
 */
static Bool 
VIAPMEvent(int scrnIndex, pmEvent event, Bool undo)
{
    ScrnInfoPtr pScrn = xf86Screens[scrnIndex];
    VIAPtr pVia = VIAPTR(pScrn);
     
    xf86DrvMsg(X_INFO,pScrn->scrnIndex,"enter pm event\n");
    ErrorF("VIAPMEvent: received APM event %d\n", event);

    switch (event) {
        case XF86_APM_SYS_SUSPEND:
        case XF86_APM_CRITICAL_SUSPEND: /*do we want to delay a critical suspend?*/
        case XF86_APM_USER_SUSPEND:
        case XF86_APM_SYS_STANDBY:
        case XF86_APM_USER_STANDBY:
            if (!undo && !pVia->IsSuspending) {
                pScrn->LeaveVT(scrnIndex, 0);
                pVia->IsSuspending = TRUE;
                sleep(50);
                pScrn->EnterVT(scrnIndex, 0);
            } else if (undo && pVia->IsSuspending) {
                sleep(1);
                pScrn->EnterVT(scrnIndex, 0);
                pVia->IsSuspending = FALSE;
            }
            break;
        case XF86_APM_STANDBY_RESUME:
        case XF86_APM_NORMAL_RESUME:
        case XF86_APM_CRITICAL_RESUME:
            if (pVia->IsSuspending) {
                sleep(1);
                pScrn->EnterVT(scrnIndex, 0);
                pVia->IsSuspending = FALSE;
            }
            break;
        case XF86_APM_CAPABILITY_CHANGED:
            if (pVia->IsSecondary)
                return TRUE;
        default:
            ErrorF("VIAPMEvent: received APM event %d\n", event);
            return TRUE;
    }
    return TRUE;
}


#ifdef VIA_RANDR12_SUPPORT
void 
viaInitHwDisplayCaps(VIAPtr pVia)
{
	/*Get graphic chip display caps*/
	switch (pVia->Chipset) {
		case VIA_CX700:		/* VT3324 */
			pVia->GfxDispCaps = INTERNAL_LVDS | INTERNAL_TMDS;
			break;
		case VIA_VX800:		/* VT3353 */
		    pVia->GfxDispCaps = INTERNAL_LVDS | INTERNAL_TMDS;
			break;
		case VIA_VX855:		/* VT3409*/
			pVia->GfxDispCaps = INTERNAL_LVDS;
			break;
		default:
			break;
	}
	return;
}


void 
viaCheckMbStrapping(VIAPtr pVia)
{
    unsigned char sr12Date = 0;
    sr12Date = viaReadVgaIo(REG_SR12);

    pVia->MbDiPortUsedInfo = 0;

    switch (pVia->Chipset) {
        case VIA_CX700:
        case VIA_VX800:
            /* First, remove the DFP port support*/
            /*Note that the port is used, in fact no such port*/
            pVia->MbDiPortUsedInfo |= DISP_DI_DFP; 

            if (MB_DVP0_ENABLE & sr12Date) {
                /*Enable the ports*/
                pVia->MbDiPortUsedInfo &= ~(DISP_DI_DVP0 ); 
                /* IF SR12[6]=1, board supported all devices defualt */
                pVia->MbDvp0Device = DISP_DEV_CRT | DISP_DEV_DVI | DISP_DEV_LCD;            
            } else {
                /*Note that the port is used, in fact no such port*/
                pVia->MbDiPortUsedInfo  |= DISP_DI_DVP0; 
                pVia->MbDvp0Device = DISP_DEV_NONE;
            }         
            break;     

        case VIA_VX855:
            /* Remove one 24-bit DFP port support,
               VT3409 doesn't support DVP0,
               VT3409 only support LVDS0, so DFP_HIGH can't be used */
            pVia->MbDiPortUsedInfo |= DISP_DI_DFP | DISP_DI_DVP0 | DISP_DI_DFPH; 
            break;
            
        case VIA_P4M800PRO:
        case VIA_P4M890:
        case VIA_P4M900:
        case VIA_K8M890:
        default:
            /*BIT4 is "1", DFP is one 24bit DFP port, so no DFPH/DFPL*/
            if (MB_DFP_24BIT & sr12Date) {
                /*Note that the port is used, in fact no such port*/
                pVia->MbDiPortUsedInfo  |= DISP_DI_DFPH | DISP_DI_DFPL; 
            /* two 12 bit port, no DFP port*/
            } else {
                /*Note that the port is used, in fact no such port*/
                pVia->MbDiPortUsedInfo  |= DISP_DI_DFP; 
            }
            
            /* After test, DVP0 support crt,lcd,dvi whatever the value SR12[5] is */
            pVia->MbDiPortUsedInfo &= ~DISP_DI_DVP0;
            pVia->MbDvp0Device = DISP_DEV_CRT | DISP_DEV_DVI | DISP_DEV_LCD;
           
            break;
    }
    
    return;
}

Bool 
viaInitHwInfo(VIAPtr pVia)
{
	/*1. Get graphic chip display caps*/
	viaInitHwDisplayCaps(pVia);

	/*2. Get the MB HW straping info*/
	viaCheckMbStrapping(pVia);
	
	return TRUE;
}


/*
    Function Name:  LoadFixedCrtcRegs
    Description: Load fixed CRTC timing registers
*/
static void 
LoadFixedCrtcRegs(void)
{
    viaUnlockCrtc();
    
    viaWriteVgaIoBits(REG_CR03, 0x80, BIT7);       /* always set to 1 */
    viaWriteVgaIo(REG_CR18, 0xFF);                 /* line compare should set all bits = 1 (extend modes) */
    viaWriteVgaIoBits(REG_CR07, 0x10, BIT4);
    viaWriteVgaIoBits(REG_CR09, 0x40, 0xFF);
    viaWriteVgaIoBits(REG_CR35, 0x10, BIT4);
    viaWriteVgaIoBits(REG_CR33, 0x05, BIT0+BIT1+BIT2);
    viaWriteVgaIo(REG_CR17, 0xE3);                 /* extend mode always set to e3h */
    viaWriteVgaIo(REG_CR08, 0x00);                     /* extend mode always set to 0h */
    viaWriteVgaIo(REG_CR14, 0x00);                     /* extend mode always set to 0h */

    viaLockCrtc(); 
}

/*
    Function Name:  LoadFixedCrtcRegs
    Description: Init TD timing register (power sequence)
*/
static void 
InitTdTimingRegs(VIAPtr pVia)
{
    unsigned int TdTimer[PANEL_TD_TIMING_AMOUNT]; 
    unsigned int i;

    /* Calculate TD Timer, every step is 572.1uSec */
    TdTimer[0] = PanelTdTimer.tdTimer0*10000/5721;
    TdTimer[1] = PanelTdTimer.tdTimer1*10000/5721;
    TdTimer[2] = PanelTdTimer.tdTimer2*10000/5721;
    TdTimer[3] = PanelTdTimer.tdTimer3*10000/5721;

    /* Fill primary power sequence */
    for (i = 0; i < PANEL_TD_TIMING_AMOUNT; i++) {
        viaLoadRegs(TdTimer[i], PANEL_TD_TIMING_REG_AMOUNT, TdTimerRegs[i].tdRegs);
    }

    /*Note: VT3293, VT3324, VT3353 have two hardware power sequences
    other chips only have one hardware power sequence*/
    switch (pVia->Chipset) { 
        case VIA_CX700:
        case VIA_VX800:
            /* set CRD4[0] to "1" to select 2nd LCD power sequence. */ 
            viaWriteVgaIoBits(REG_CRD4, 0x01, 0x01);

        /* Fill secondary power sequence */
        for (i = 0; i < PANEL_TD_TIMING_AMOUNT; i++) {
            viaLoadRegs(TdTimer[i], PANEL_TD_TIMING_REG_AMOUNT, TdTimerRegs[i].tdRegs);
        }
        break;
    default:
        break;
    }
}



void
viaInitDispEngine(VIAPtr pVia)
{
    /*1. Write Common Setting for Video Mode */
    switch(pVia->Chipset) {   
        case VIA_P4M800PRO:
        case VIA_K8M890:
        case VIA_P4M890:
        case VIA_P4M900:
            viaWriteVgaIoMultiBits(InitialRegTable_CN700, NUM_TOTAL_CN700_INIT_REG_TBL);
            break;
        case VIA_CX700:
        case VIA_VX800:
            viaWriteVgaIoMultiBits(InitialRegTable_CX700, NUM_TOTAL_CX700_INIT_REG_TBL);
            break;
        case VIA_VX855:
            viaWriteVgaIoMultiBits(InitialRegTable_VX855, NUM_TOTAL_VX855_INIT_REG_TBL);
            break;
    }

    /*2. load fixed CRTC timing registers*/
    LoadFixedCrtcRegs();

    /*3. Init TD timing register (power sequence)*/
    InitTdTimingRegs(pVia);

    /*4. I/O address bit to be 1 */
    /*Enables access to frame buffer at A0000-BFFFFh*/
    viaWriteMiscIo(viaReadMiscIo() | 0x01);

}

/* Set register CRD2 according to internal device setting */
static void
setChannel4InternalDev(VIAPtr pVia)
{
    if (pVia->numOfEmbDvi == 0 && pVia->numOfEmbLcd == 0)
        return;

    /*One Dual LVDS Channel (High Resolution Pannel)*/
    if (pVia->dualChannelEmbLcdExist) {
        viaWriteVgaIoBits(REG_CRD2, BIT5, BIT4+BIT5);
    } else if (pVia->numOfEmbDvi && pVia->numOfEmbLcd) {
    	/*One single channel LVDS and one single channel TMDS*/
        viaWriteVgaIoBits(REG_CRD2, BIT4, BIT4+BIT5);
    } else if (pVia->numOfEmbDvi && !pVia->numOfEmbLcd) {
    	/*Single Channel TMDS*/
        viaWriteVgaIoBits(REG_CRD2, BIT4+BIT5, BIT4+BIT5);
    } else {
		/*LVDS1 Channel + LVDS2 Channel*/ 
        viaWriteVgaIoBits(REG_CRD2, 0x00, BIT4+BIT5);
    }
}

void
viaInitOutputRegSet(ScrnInfoPtr pScrn)
{
	VIAPtr pVia = VIAPTR(pScrn);
	xf86CrtcConfigPtr xf86_config = XF86_CRTC_CONFIG_PTR(pScrn);
	int i = 0;

	setChannel4InternalDev(pVia);
	
	for (i = 0; i < xf86_config->num_output; i++) {
		 if ((!strcmp(xf86_config->output[i]->name, "LCD"))||
		 	 (!strcmp(xf86_config->output[i]->name, "LCD-2"))) {
		 	ViaLcdPrivateInfoPtr viaLcdInfo = xf86_config->output[i]->driver_private;	
			/*Init subchip*/
			initLVDS(viaLcdInfo);
		 }
	}
}
#endif
