/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#ifndef _VIA_DRIVER_H_
#define _VIA_DRIVER_H_ 1

/*#define DEBUG_PRINT*/
#ifdef DEBUG_PRINT
#define DEBUG(x) x
#else
#define DEBUG(x)
#endif

#ifdef HAVE_CONFIG_H            
#include "config_via.h"
#else 
#include "via_subversion.h"
#endif

#include <stdint.h>
#include "vgaHW.h"
#include "via_include.h"
#include "xf86Pci.h"
#include "xf86PciInfo.h"
#include "xf86Cursor.h"
#include "mipointer.h"
#include "micmap.h"

#ifdef XSERVER_LIBPCIACCESS
#include <pciaccess.h>
#endif


#include "fb.h"
#include "xf86cmap.h"
#include "vbe.h"
#include "xaa.h"
#include "macros.h"
/*
 * resolve undefined type in /usr/include/xf86drm.h xf86mm.h
 * via_bios.h need mm.h
 */
#include "drm.h"

#include "via_regs.h"
#include "via_bios.h"
#include "via_gpioi2c.h"

#ifdef XF86DRI
#define _XF86DRI_SERVER_
#include "sarea.h"
#include "dri.h"
#include "GL/glxint.h"
#include "via_dri.h"
#include "dristruct.h"
#endif

#include <X11/extensions/randr.h>

/* A Flag of enable the Xv Overlay AGP path */
#define VIA_APPLY_XVOVERLAY_AGP  1
/* A Flag of enable the uniform 2D Blt path */
#define VIA_APPLY_UNIFORM_2DBLT 0

/*Flag for DRM+Xinerama support*/
#define DRM_SAMM_VIA


#include "via_dmabuffer.h"
#include "via_3d.h"
#include "via_video.h"
#include "via_swov.h"

#define DRIVER_NAME     "via"
#define DRIVER_VERSION  "5.74.33"
#define VERSION_MAJOR   5       /* Linux Driver number */
#define VERSION_MINOR   74      /* Xorg Version supported max version number*/
#define VERSION_OS      33      /* 3D Family, H2: 31 / H5: 32, Trunk both H2/H5: 33 */
#define PATCHLEVEL      0xff    /* Driver sub version number, Trunk: 0xff*/
#define VIA_VERSION     ((VERSION_MAJOR<<24) | (VERSION_MINOR<<16) | PATCHLEVEL)    


/* For RandR v1.2 */
#if XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(1,0,0,0,0)
#if XORG_VERSION_CURRENT <= XF86_VERSION_NUMERIC(2,0,0,0,0)
#include "randrstr.h"
#endif
#endif

#ifdef RANDR_12_INTERFACE
#define VIA_RANDR12_SUPPORT 1
#endif

#ifdef VIA_HAVE_EXA
#include "exa.h"
#define VIA_AGP_UPL_SIZE    (1024*1024)
#define VIA_DMA_DL_SIZE     (1024*128)

/* Pixmap sizes below which we don't try to do hw accel.*/

#define VIA_MIN_COMPOSITE   400
#define VIA_MIN_UPLOAD 4000
#define VIA_MIN_TEX_UPLOAD 200
#define VIA_MIN_DOWNLOAD 200
#endif

#define VGAIN8(addr)        MMIO_IN8(pVia->MapBase+0x8000, addr)
#define VGAIN16(addr)       MMIO_IN16(pVia->MapBase+0x8000, addr)
#define VGAIN(addr)         MMIO_IN32(pVia->MapBase+0x8000, addr)

#define VGAOUT8(addr, val)  MMIO_OUT8(pVia->MapBase+0x8000, addr, val)
#define VGAOUT16(addr, val) MMIO_OUT16(pVia->MapBase+0x8000, addr, val)
#define VGAOUT(addr, val)   MMIO_OUT32(pVia->MapBase+0x8000, addr, val)

#define INREG(addr)         MMIO_IN32(pVia->MapBase, addr)
#define OUTREG(addr, val)   MMIO_OUT32(pVia->MapBase, addr, val)
#define INREG16(addr)       MMIO_IN16(pVia->MapBase, addr)
#define OUTREG16(addr, val) MMIO_OUT16(pVia->MapBase, addr, val)

/*Libpciaccess api changed*/
#if XSERVER_LIBPCIACCESS
#define MEMBASE(p,n)      (p)->regions[(n)].base_addr
#define VENDOR_ID(p)      (p)->vendor_id
#define DEVICE_ID(p)      (p)->device_id
#define SUBVENDOR_ID(p)	  (p)->subvendor_id
#define SUBSYS_ID(p)      (p)->subdevice_id
#define CHIP_REVISION(p)  (p)->revision
#else
#define MEMBASE(p,n)      (p)->memBase[n]
#define VENDOR_ID(p)      (p)->vendor
#define DEVICE_ID(p)      (p)->chipType
#define SUBVENDOR_ID(p)	  (p)->subsysVendor
#define SUBSYS_ID(p)      (p)->subsysCard
#define CHIP_REVISION(p)  (p)->chipRev
#endif


#define VIA_PIXMAP_CACHE_SIZE       (2048 * 1024)
#define VIA_CURSOR_SIZE             (16 * 1024)
#define VIA_FB_CURSOR_SIZE          (8 * 1024)      /* reserve for frame buffer device driver */
#define VIA_VQ_SIZE                 (256 * 1024)
#define VIA_DOWN_SCALE_BUFFER_SIZE  (8 * 1024 * 1024)   /* 8MB, we need 3 buffer size */
#define	VIA_AGP_CMD_BUFFER_SIZE     (128 * 1024)
#define VIA_XV_EXA_NODRI_SIZE       (10 * (1 << 20))    /* 10MB, for XV on EXA path without DRI */
#define VIA_XV_XAA_NODRI_SIZE       (10 * (1 << 20))    /* 10MB, for XV on XAA path without DRI */

/* used by get video memory size */
/* device ID */
/* support VT3314 chipset */
#define CN700_FUNCTION2     0x2314
#define CN700_FUNCTION3     0x3208
/* VT3324 chipset */
#define CX700_FUNCTION2     0x2324
#define CX700_FUNCTION3     0x3324
/* VT3336 chipset*/
#define KM890_FUNCTION3     0x3336
/* VT3327 chipset*/
#define P4M890_FUNCTION3    0x3327
/* VT3364 chipset*/
#define P4M900_FUNCTION3    0x3364
/* VT3353 chipset*/
#define VX800_FUNCTION3     0x3353
/* VT3409 chipset*/
#define VX855_FUNCTION3     0x3409

/*for vt3336/vt3364/vt3293/vt3353(h5s1) 3D support*/
#define H2_UMA_CHIPID (pVia->ChipId==PCI_CHIP_VT3314 || pVia->ChipId == PCI_CHIP_VT3324 )
#define H5_UMA_CHIPID (pVia->ChipId==PCI_CHIP_VT3336 || pVia->ChipId == PCI_CHIP_VT3364 )
#define H6_UMA_CHIPID (pVia->ChipId == PCI_CHIP_VT3353 || pVia->ChipId == PCI_CHIP_VT3409)

/*add to fix the "Undefined Symbol:vgaHWddc1SetSpeed" problem on FC5(32/64)
  used by function :VIAvgaHWddc1SetSpeed()*/
/* vertical timings */
#define DISPLAY_END 0x04
#define BLANK_START DISPLAY_END
#define SYNC_START  BLANK_START
#define SYNC_END    0x09
#define BLANK_END   SYNC_END
#define V_TOTAL     BLANK_END

#define MAX_CURS 64

/*for 3D scaling function used for multi-device*/
#define DISPLAY_3D_SCALING_SUPPORT                 0x8000
#define DISPLAY_3D_SCALING_GOOD_PERFORMANCE        0x0001

#define RELATION_NONE       0
#define RELATION_LEFT_OF    1
#define RELATION_ABOVE_OF   2
#define RELATION_RIGHT_OF   3
#define RELATION_BELOW_OF   4
#define RELATION_SAME_OF    5
#define RELATION_OVERLAP_OF 6

#define MODE_LINE_TYPE_XORG     0x1
#define MODE_LINE_TYPE_DRIVER   0x2
#define MODE_LINE_TYPE_EDID     0x4
#define MODE_LINE_TYPE_USER     0x8

/* The old xorg doesn't define the following constant */
#ifndef M_T_DRIVER
#define M_T_DRIVER 0x40
#endif

#ifndef M_T_USERDEF
#define M_T_USERDEF 0x20
#endif

#ifndef M_T_DEFAULT
#define M_T_DEFAULT 0x10
#endif

#ifndef M_T_PREFERRED
#define M_T_PREFERRED   0x08
#endif


#define BIOS_TYPE_MOBILE    0x1
#define BIOS_TYPE_EMBED     0x2
#define BIOS_TYPE_DESKTOP   0x3


struct ViaModePriv {
    char   id[12]; /* "via" */
};

static struct ViaModePriv ViaModePrivate = {
    { 'v', 'i', 'a', 0, 0, 0, 0, 0, 0, 0, 0, 0 },
};
#define MODEPREFIX(name) NULL, NULL, name, 0, M_T_DRIVER | M_T_DEFAULT
#define MODESUFFIX       0,0, 0,0,0,0,0,0,0, 0,0,0,0,0,0,FALSE,FALSE,\
    sizeof(struct ViaModePriv),(void *)&ViaModePrivate,0,0.0,0.0

/* Information of modeline. */
static DisplayModeRec ViaSupportModes[] = {
    /*  60 Hz */
    { MODEPREFIX("480x640"),     24820,   480,  504,  552,  624, 0,   640,  641,  644,  663, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("720x480"),     26700,   720,  736,  808,  896, 0,   480,  481,  484,  497, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },    
    { MODEPREFIX("720x576"),     32700,   720,  744,  816,  912, 0,   576,  577,  580,  597, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("800x480"),     40000,   800,  832,  960, 1056, 0,   480,  541,  545,  628, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("848x480"),     31500,   848,  864,  952, 1056, 0,   480,  481,  484,  497, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("852x480"),     31750,   856,  880,  960, 1064, 0,   480,  483,  493,  500, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("856x480"),     31700,   856,  872,  960, 1064, 0,   480,  481,  484,  497, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("960x600"),     45980,   960, 1000, 1096, 1232, 0,   600,  601,  604,  622, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1000x600"),    48070,  1000, 1040, 1144, 1288, 0,   600,  601,  604,  622, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1024x512"),    41300,  1024, 1056, 1160, 1296, 0,   512,  513,  516,  531, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1024x576"),    46500,  1024, 1064, 1160, 1296, 0,   576,  579,  584,  599, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1024x600"),    48960,  1024, 1064, 1168, 1312, 0,   600,  601,  604,  622, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1088x612"),    52950,  1088, 1128, 1240, 1392, 0,   612,  613,  616,  634, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1152x720"),    67320,  1152, 1208, 1328, 1504, 0,   720,  721,  724,  746, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1152x864"),    81750,  1152, 1216, 1336, 1520, 0,   864,  867,  871,  897, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1200x720"),    70180,  1200, 1256, 1384, 1568, 0,   720,  721,  724,  746, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x600"),    61500,  1280, 1336, 1464, 1648, 0,   600,  601,  604,  622, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x720"),    74600,  1280, 1341, 1474, 1688, 0,   720,  721,  724,  746, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x768"),    80100,  1280, 1344, 1480, 1680, 0,   768,  769,  772,  795, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x800"),    83460,  1280, 1344, 1480, 1680, 0,   800,  801,  804,  838, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1280x960"),   101250,  1280, 1360, 1488, 1696, 0,   960,  963,  967,  996, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1360x768"),    85500,  1360, 1392, 1712, 1744, 0,   768,  783,  791,  807, 0, V_PHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1366x768"),    85860,  1366, 1440, 1584, 1800, 0,   768,  769,  772,  795, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1368x768"),    85250,  1368, 1440, 1576, 1784, 0,   768,  771,  781,  798, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1440x900"),   106470,  1440, 1520, 1672, 1904, 0,   900,  901,  904,  932, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1440x1050"),  126200,  1440, 1536, 1688, 1936, 0,  1050, 1051, 1054, 1087, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1600x900"),   119000,  1600, 1696, 1864, 2128, 0,   900,  901,  904,  932, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1600x1024"),  136360,  1600, 1704, 1872, 2144, 0,  1024, 1025, 1028, 1060, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1680x1050"),  146250,  1680, 1784, 1960, 2240, 0,  1050, 1053, 1059, 1089, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1792x1344"),  202970,  1792, 1920, 2112, 2432, 0,  1344, 1345, 1348, 1391, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1856x1392"),  218570,  1856, 1992, 2192, 2528, 0,  1392, 1393, 1396, 1441, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1920x1080"),  172900,  1920, 2043, 2249, 2578, 0,  1080, 1081, 1084, 1118, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("1920x1200"),  193250,  1920, 2056, 2256, 2592, 0,  1200, 1203, 1209, 1245, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },
    { MODEPREFIX("2048x1536"),  266950,  2048, 2200, 2424, 2800, 0,  1536, 1537, 1540, 1589, 0, V_NHSYNC | V_PVSYNC, MODESUFFIX },                      
    { MODEPREFIX(NULL), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, MODESUFFIX },
};

#ifdef VIA_RANDR12_SUPPORT
/* Define VIA Graphic Chip Display support caps */
#define     INTERNAL_LVDS        BIT0        /* Support the internal LVDS */
#define     INTERNAL_TMDS        BIT1        /* Support the internal TMDS */
/* Define VIA Graphic MB HW strapping settings for chip before VT3324 */
#define     MB_DFP_24BIT         BIT4        /*BIT4 is "1", DFP is used as one 24bit DFP port, or else, two 12bit DI port */
#define     MB_DVP0_ENABLE       BIT6        /*BIT6 is "1", DVP0 Port is enable */

/*Define the device bits*/
#define DISP_DEV_NONE           0x00000000
#define DISP_DEV_CRT            0x00000001
#define DISP_DEV_LCD            0x00000002
#define DISP_DEV_DVI            0x00000008
#define DISP_DEV_GENERAL        0x0000003F
#define DISP_DEV_LCD2           0x00000200
#define DISP_DEV_DVI2           0x00000800




/* DI Port define */
#define DISP_DI_NONE            0x0000
#define DISP_DI_DVP0            BIT0
#define DISP_DI_DVP1            BIT1
#define DISP_DI_DFPL            BIT2
#define DISP_DI_DFPH            BIT3
#define DISP_DI_DFP             BIT4
#define DISP_DI_DAC             BIT5
#define DISP_DI_ALL             DISP_DI_DVP0+DISP_DI_DVP1+DISP_DI_DFPL+DISP_DI_DFPH+DISP_DI_DFP+DISP_DI_DAC

/* Device type define */
#define DISP_TYPE_INTERNAL      BIT0
#define DISP_TYPE_EXTERNAL      BIT1
#define DISP_TYPE_HARDWIRED     BIT2
#define DISP_TYPE_TTL			BIT3


/*MB HW strapping
  SR12[6:4] Setting for chip except vt3324/293/353 */
#define DISP_DICONFIG_DFP       BIT4 /* 12bit or 24 bit */
#define DISP_DICONFIG_DVPDEV    BIT5 /* DVP0/1 connect to external DVI  (Need to check)*/
#define DISP_DICONFIG_DVPSTAT   BIT6 /* DVP enable or disable*/

/* DISPlay info Default setting*/
#define DISP_DEFAULT_SETTING    0xffff
#define DISP_INITIAL_SETTING    0x0000


/* Serial/DDC port setting*/
/*
;; serial port/ DDC port: 
;;      0xffff: default setting(General rule)
;;      0x0000: needn't such port
;;      0x0025: Port 0x25
;;      0x0026: Port 0x26
;;      0x002C: Port 0x2c
;;      0x0031: Port 0x31
;;      0x003D: Port 0x3D
*/
#define DISP_SERIALP_NONE       0x0000
#define DISP_SERIALP_25         0x0025
#define DISP_SERIALP_26         0x0026
#define DISP_SERIALP_2C         0x002C
#define DISP_SERIALP_31         0x0031
#define DISP_SERIALP_3D         0x003D


/****************/
/*Sub Chip Index*/
/****************/
#define NONE_SUBCHIP                    0x00000000

/* Definition TMDS Trasmitter Index */
#define SUBCHIP_VT1632                  0x00000100
#define SUBCHIP_INTEGRATED_TMDS         0x00000400
#define SUBCHIP_HARDWIRED_TMDS          0x00000800
#define SUBCHIP_TMDS_ALL_MASK           0x00000F00

/* Definition LVDS Trasmitter Index */
#define SUBCHIP_VT1631                  0x00010000
#define SUBCHIP_VT1636                  0x00020000
#define SUBCHIP_INTEGRATED_LVDS         0x00040000
#define SUBCHIP_HARDWIRED_LVDS			0x00080000
#define SUBCHIP_TTL						0x00100000
#define SUBCHIP_LVDS_ALL_MASK           0x000F0000


/********************/
/*Sub Chip SlaveAddr*/
/********************/
#define NONE_SUBCHIP_SLAVE_ADDR         0x00


/* Definition TMDS Trasmitter Slave Address */
#define SUBCHIP_VT1632_VERSION_REG_NUM   2
#define SUBCHIP_VT1632_SLAVE_ADDR       0x10
#define SUBCHIP_VT1632_VERSION_LOW_REG  0x02
#define SUBCHIP_VT1632_VERSION_HI_REG   0x03
#define SUBCHIP_VT1632_VERSION_LOW      0x92
#define SUBCHIP_VT1632_VERSION_HI       0x31


/* Definition LVDS Trasmitter Slave Address */
#define SUBCHIP_VT1631_SLAVE_ADDR       0x70
#define SUBCHIP_VT3271_SLAVE_ADDR       0x80

#define SUBCHIP_VT1636_VERSION_REG_NUM   2
#define SUBCHIP_VT1636_SLAVE_ADDR       0x80
#define SUBCHIP_VT1636_VERSION_LOW_REG	0x02
#define SUBCHIP_VT1636_VERSION_HI_REG	0x03
#define SUBCHIP_VT1636_VERSION_LOW      0x45
#define SUBCHIP_VT1636_VERSION_HI       0x33

#endif /*VIA_RANDR12_SUPPORT*/

struct _vgaDdcSave {
    unsigned char cr03;
    unsigned char cr06;
    unsigned char cr07;
    unsigned char cr09;
    unsigned char cr10;
    unsigned char cr11;
    unsigned char cr12;
    unsigned char cr15;
    unsigned char cr16;
    unsigned char msr;
};


typedef struct {
    unsigned int    mode, refresh;
    int             countWidthByQWord;
    int             offsetWidthByQWord;

    unsigned char   Clock;

    /* Sequencer registers */
    unsigned char   SRRegs[256];
    
    /* CRTC registers */
    unsigned char   CRTCRegs[256];
    unsigned char   VT1636Regs[9];      /* We will save from Tx08 to Tx10. */
    /* unsigned char   LCDRegs[0x40];*/
    
    /* HW Cursor registers */
    CARD32          dwCursorMode, dwCursorPOS, dwCursorORG, dwCursorBG, dwCursorFG;

} VIARegRec, *VIARegPtr;

typedef struct{
    int width;
    int height;
    int hotx;
    int hoty;
    CARD32 HwCursorBufStart;
    CARD32 HIBufStart;
    CARD32 HIPrimScalingBufStart;
    CARD32 HISecScalingBufStart;
    CARD32 CursorBG;
    CARD32 CursorFG;
    CARD32 CursorMC;
}VIACursorInfo, *VIACursorInfoPtr;


/*
  Create this structure to be shared by multi screens.
  Multi Screens may have some same infomation which needn't
  multi screens all have one copy by theirselves.
 */
typedef struct {
    Bool UseHwCursor;
    VIACursorInfo CursorInfo;
    /*64x64x4 Temp buf for Cursor Image, HW Icon need it*/
    unsigned char Image_buf[16384]; 
    /* Record All the Physical Video Memory Size,  
     * pVia->videoRambytes record different screen Video memory size
     */
    unsigned long VRamSize;          
                              
} VIAScreensPublicInfo, *VIAScreensPublicInfoPtr;

#define     EXPAND_BUF_CNT     2

typedef struct _twodContext {
    CARD32 mode;
    CARD32 cmd;
    CARD32 fgColor;
    CARD32 bgColor;
    CARD32 pattern0;
    CARD32 pattern1;
    CARD32 patternAddr;
    CARD32 keyControl;
    unsigned srcOffset;
    unsigned srcPitch;
    unsigned Bpp;
    unsigned bytesPPShift;
    Bool clipping;
    Bool dashed;
    int clipX1;
    int clipX2;
    int clipY1;
    int clipY2;
    CARD32 Savedtrans_color; /*xaa wrapper*/
    Bool (* setModeHelper)(int , struct _twodContext * );
    Bool (* planeMaskHelper)(struct _twodContext *, CARD32);
    void (* transparentHelper)(struct _twodContext *, ViaCommandBuffer *,
                          CARD32 keyControl, CARD32, Bool);
    void (* copyHelper)(ViaCommandBuffer *, 
        int, int, int, int, int, int, 
        unsigned, unsigned, CARD32, 
        unsigned, unsigned, CARD32);
    void (* solidHelper)(ViaCommandBuffer *, 
        int, int, int, int, unsigned, CARD32, unsigned, 
        CARD32, CARD32);
} ViaTwodContext;

/*============================================*/

typedef struct {
    unsigned long branch_buf_enabled;
    unsigned long branch_buf_freenum;
    unsigned long branch_buf_num;
    unsigned long branch_buf_size;       /* in unit of byte */
    unsigned long agpTexHandle;          /* not used in XServer */
    unsigned long agpTexSize;            /* not used in XServer */
}drm_umd_branch_query_t;

typedef enum buf_status {
    prepared,
    allocated,
    flushed,
    uninitialized,
}drm_buf_status_t;

typedef struct {
    unsigned long id;
    drm_buf_status_t status;
    unsigned long offset;         /* in unit of byte */
    unsigned long size;           /* in unit of byte */
    void *user_virtual;
    unsigned long cmd_size;       /* in unit of dword */	
}drm_umd_branch_buf_t;

/*============================================*/

typedef struct {
    unsigned long offset;  /* in unit of byte */   
    unsigned long size;    /* in unit of byte */
}drm_umd_cflush_pages_t;

#define LOC_SL  0x0  /* system local framebuffer*/ 
#define LOC_SF  0x1  /* system dynamic buffer   */
#define LOC_SM  0x2  /* system memory           */ 
#define LOC_LL  0x3  /* local memory local frame buffer*/ 

/*============================================*/

typedef struct {
    unsigned long   biosType;
    unsigned long   biosSupportDev;
    unsigned int    biosVerMajorNum;
    unsigned int    biosVerMinorNum;
    unsigned char   biosDateYear;
    unsigned char   biosDateMonth;
    unsigned char   biosDateDay;
    unsigned int    biosPanelID;
    unsigned int    biosActiveDev;
    unsigned int    biosVideoMemSize;
    unsigned int    biosIsSpreadSpectrum;
} VIAChipInfoRec, *VIAChipInfoPtr;


typedef struct _VIA {
    VIARegRec           SavedReg;
    VIAScreensPublicInfoPtr      pScreensPublicInfo;
    xf86CursorInfoPtr   CursorInfoRec;
    Bool                ModeStructInit;
    int                 Bpp, Bpl, ScissB;

    unsigned long       videoRambytes;

    int                 FBFreeStart;
    int                 FBFreeEnd;
    int                 VQStart;
    int                 VQEnd;

    /* These are physical addresses. */
    unsigned long       FrameBufferBase;/*start address for the whole video memory */
    unsigned long       MmioBase;
    unsigned long       ScreenBase; /*start address for each screen*/
    /* These are linear addresses. */
    unsigned char*      MapBase;
    unsigned char*      VidMapBase;
    unsigned char*      BltBase;
    unsigned char*      FBBase;
    /*unsigned char*      FBStart;*/   /*deprecated*/

    /* Here are all the Options */
    Bool                VQEnable;
    Bool                ForceSWCursor;
    Bool                NoAccel;
    Bool                shadowFB;  

#if XSERVER_LIBPCIACCESS
    struct pci_device *PciInfo;
#else
    pciVideoPtr PciInfo;
    PCITAG PciTag;
#endif

    CloseScreenProcPtr  CloseScreen;
    int                 Chipset;
    int                 ChipId;
    int                 ChipRev;
    vbeInfoPtr          pVbe;

    VIAChipInfoPtr      pChipInfo;   

    /* Determine old architecture or RandR path */
    Bool                useRandR;
#ifdef VIA_RANDR12_SUPPORT
    /*Graphic feature*/
    unsigned long       GfxDispCaps;
    /*Main board DI Port status*/
    unsigned long       MbDiPortUsedInfo;
    unsigned long       MbDvp0Device;
	unsigned long		HiStartBuf[2];

    /* Use for setting CRD2 register */
	unsigned int        numOfEmbLcd;
	unsigned int        numOfEmbDvi;
	Bool                dualChannelEmbLcdExist;   

    /* Used to solve the EDID conflict between LCD and DVI */
	unsigned int        ddcPortOfDvi;

    /* Flag whether first output is created successfully or not,
       If fail, we don't consider creating the second congener output */
    Bool                crt1Created;
    Bool                lcd1Created;
    Bool                dvi1Created;
	
#endif

    /* Support for shadowFB and rotation */
    unsigned char*      ShadowPtr;
    int                 ShadowPitch;

    /* For RandR v1.2 Rotation */
    int                 RotateShadowOffset[2];
    int                 NumOfShadowInUse;
    
    /* Support for XAA acceleration */
    XAAInfoRecPtr       AccelInfoRec;
        
    ViaTwodContext      td;
    ViaCommandBuffer    cb;
    Via3DState          v3d;
    Via3DState          *lastToUpload;
    Bool                nPOT[VIA_NUM_TEXUNITS];
   /* Support for EXA acceleration */
#ifdef VIA_HAVE_EXA
    ExaDriverPtr        exaDriverPtr;
    ExaOffscreenArea   *exa_scratch;
    unsigned int        exa_scratch_next;
    Bool                useEXA;
    void               *maskP;
    CARD32              maskFormat;
    Bool                componentAlpha;
    void               *srcP;
    CARD32              srcFormat;

    ExaOffscreenArea   *texFBBuffer;
    
    Bool                noComposite;

    int                 accelMarker;
    CARD32              markerOffset;
    volatile CARD32    *markerBuf;
    CARD32              curMarker;
    CARD32              lastMarkerRead;
    
#ifdef XF86DRI
    drm_via_mem_t       scratchAGPBuffer;
    drm_via_mem_t       texAGPBuffer;
    unsigned            texOffset;
    char *              texAddr;
    char *              dBounce;
#endif
#endif

    /* Support for Int10 processing */
    xf86Int10InfoPtr    pInt10;

    /* BIOS Info Ptr */
    VIABIOSInfoPtr      pBIOSInfo;

    Bool                IsSuspending;
    Bool                IsVIAModeInitRunOnceDone;
    
    /* Support for DGA */
    int                 numDGAModes;
    DGAModePtr          DGAModes;
    Bool                DGAactive;
    int                 DGAViewportStatus;

    /* The various wait handlers. */
    int                 (*myWaitIdle)(struct _VIA*);

    /* I2C & DDC */
    I2CBusPtr           I2C_Port1;
    I2CBusPtr           I2C_Port2;
    xf86MonPtr          DDC1;
    xf86MonPtr          DDC2;

    /* MHS */
    Bool                IsSecondary;
    Bool                HasSecondary;

#ifdef XF86DRI
    Bool directRenderingEnabled;
#ifdef DRM_SAMM_VIA
    Bool drmSammEnabled;                /*Add for DRM + Xinerama support*/
#endif
    Bool useAgp;
    DRIInfoPtr pDRIInfo;
    int drmFD;
    int numVisualConfigs;
    __GLXvisualConfig* pVisualConfigs;
    VIAConfigPrivPtr pVisualConfigsPriv;
    drm_handle_t  agpHandle;
    drm_handle_t agpTexHandle;
    drm_handle_t registerHandle;
/*For AMD64*/
#ifndef __x86_64__
    CARD32 agpAddr;
#else
    CARD64 agpAddr;
#endif
    unsigned char *agpBase;
    drmAddress  agpMappedAddr;
    drmAddress agpTexMappedAddr;
    unsigned int agpSize;
    unsigned int agpTexBaseOffset;
    unsigned int agpTexSize;
    Bool IsPCI;
    Bool drixinerama;

    drm_umd_branch_query_t umdBranchQuery;
    drm_umd_branch_buf_t umdBranchBuf;
#endif

    CARD16  ActiveDevice;   /* if SAMM, non-equal pBIOSInfo->ActiveDevice */
    unsigned char       *HwCursorImage;
    unsigned char       *HwIconImage;
    unsigned char       *HIScalingPrimImage;
    unsigned char       *HIScalingSecImage;
    PVIDDATA pVidData;


    /*agp flush drm*/
    unsigned long agp_handle;/*map public agp  area*/

    /* Rotation */
    Bool    IsHWRotateEnabled;  /* For Hardware rotation */
    int     RotateDegree;       /* Rotate degree  */

    int     RotateFBStart;
    
    /* Display 3D engine scaling*/
    /* modified the variable type,and change the function of this variable*/
    int    DISP3DScalingCaps; /*Report the caps of the DISP3DScaling function*/
    int    NumOfDevNeed3dScl;/*the max number should be 2, so when you add more device need this function, please check the number*/
    int     DISP3DScalingBufferStart;
    int     iga1DISP3DScalingBufferStart;
    int     iga2DISP3DScalingBufferStart;
    int     Cursor3DScalingBufferStart;
    Bool  GoodPerformance;

    /* For MAMM case, VIA as secondary display device. */
    Bool    IsMAMMEnable; 

    /*for vt3336(h5s1) 3d support*/
    AddrConfPtr pAddrConf;
    ChipConfPtr pChipConf;
    DriConfPtr pDriConf;
    ScrnConfPtr pScrnConf;
    ServerInfoPtr pServerInfo;
    PciConfPtr pPciConf;
    drm_handle_t hostBltHandle;    /*2d host bitblt map handle*/

    OsTimerPtr devicesTimer;
    OsTimerPtr eventTimer;      /* Add for checking pmevent */

    /* For hotkey timer */
    Bool       IsHotkeyTimerEnabled;
    OsTimerPtr hotkeyTimer;    
    CARD32     deviceSequence[4];
    Bool       IsForceHotkeySwitch;
    
    /* For Down Scale Used */
    int     DownScaleBufferStartAddr;
    
    /* For RandR12 Used */
    Bool    EnableRandR12;

    video_via_regs VidEngSaved;
    hqv_via_regs  HqvSaved[2];

    /* For updateOverlay in AdjustFrame and RandR path */
    viaPortPrivPtr pPriv[XV_PORT_NUM_OVERLAY];
    /*For Mem not enough for EXA ,safe exit for LeaveVT Flag*/
    Bool MemNEnough4EXA;
} VIARec, *VIAPtr;

#ifdef VIA_RANDR12_SUPPORT
typedef struct _VIACrtcPrivateRec {
	int iga;
	LOCO colors[256];
	int enabled;
    int rotateShadowOffset;
    ViaMemRec  rotateMem;
    int igastatus; /*for record the iga is downscaling, s3scaling or upscaling*/
} VIACrtcPrivateRec, *VIACrtcPrivatePtr;
#define VIACrtcPrivate(c) ((VIACrtcPrivatePtr) (c)->driver_private)

#define VIA_PANNING (1<<0)
#define VIA_SCALING_HW (1<<1)
#define VIA_SCALING_3D (1<<2)
#define VIA_EXPAND (1<<3) 
#endif

typedef struct
{
    Bool IsDRIEnabled;

    Bool HasSecondary;
    Bool BypassSecondary;
    /*These two registers are used to make sure the CRTC2 is
      retored before CRTC_EXT, otherwise it could lead to blank screen.*/
    Bool IsSecondaryRestored;
    Bool RestorePrimary;

    ScrnInfoPtr pSecondaryScrn;
    ScrnInfoPtr pPrimaryScrn;
}VIAEntRec, *VIAEntPtr;

/*
 * structure for passing information to UpdateOverlay fn
 */
typedef struct _RECTL
{
    long     left;
    long     top;
    long     right;
    long     bottom;
} RECTL, *RECTLPtr;

/* Shortcuts.  These depend on a local symbol "pVia". */

#define WaitIdle()      pVia->myWaitIdle(pVia)
#define VIAPTR(p)       ((VIAPtr)((p)->driverPrivate))

/******* Variable *******/
static int DeviceCounter = 0;


/* Prototypes. */
void VIARandR12UpdataOverlay(int scrnIndex, int x, int y, int flags);
void VIAAdjustFrame(int scrnIndex, int y, int x, int flags);
Bool VIASwitchMode(int scrnIndex, DisplayModePtr mode, int flags);
void VIADebugBreak(void);


/* In via_cursor.c. */
Bool VIAHWCursorInit(ScreenPtr pScreen);
void VIAShowCursor(ScrnInfoPtr);
void VIAHideCursor(ScrnInfoPtr);


/* In via_accel.c. */
Bool VIAInitAccel(ScreenPtr);
void VIAInitialize2DEngine(ScrnInfoPtr);
void VIAAccelSync(ScrnInfoPtr);
void viaExitAccel(ScreenPtr pScreen);

/* In via_shadow.c */
void VIAPointerMoved(int index, int x, int y);
void VIARefreshArea(ScrnInfoPtr pScrn, int num, BoxPtr pbox);
void VIARefreshArea8(ScrnInfoPtr pScrn, int num, BoxPtr pbox);
void VIARefreshArea16(ScrnInfoPtr pScrn, int num, BoxPtr pbox);
void VIARefreshArea24(ScrnInfoPtr pScrn, int num, BoxPtr pbox);
void VIARefreshArea32(ScrnInfoPtr pScrn, int num, BoxPtr pbox);


/* In via_bios.c */
Bool VIAPrimarySetMode(ScrnInfoPtr pScrn);


/* In via_dga.c */
Bool VIADGAInit(ScreenPtr);

/* In via_i2c.c */
Bool VIAI2CInit(ScrnInfoPtr pScrn);

/* In via_gpioi2c.c */
Bool GPIOI2C_Write(VIABIOSInfoPtr pBIOSInfo, int SubAddress, CARD8 Data);
Bool GPIOI2C_Read(VIABIOSInfoPtr pBIOSInfo, int SubAddress, CARD8 *Buffer, int BufferLen);
Bool GPIOI2C_ReadByte(VIABIOSInfoPtr pBIOSInfo, int SubAddress, CARD8 *Buffer);
Bool GPIOI2C_Initial(VIABIOSInfoPtr pBIOSInfo, CARD8 SlaveDevice);

/*In via_video.c*/
void viaInitVideo(ScreenPtr pScreen);
void viaExitVideo(ScrnInfoPtr pScrn);
void viaResetVideo(ScrnInfoPtr pScrn);
void viaSaveVideo(ScrnInfoPtr pScrn);
void viaRestoreVideo(ScrnInfoPtr pScrn);
void viaSaveHqv(ScrnInfoPtr pScrn);
void viaRestoreHqv(ScrnInfoPtr pScrn);

/* In Hw.c */
void VIADIPortPadOn(int DIPort);
void VIADIPortPadOff(int DIPort);

void VIAGetModeLineTiming(ScrnInfoPtr pScrn, DisplayModePtr mode);


/* For utility interface */
void VIADisplayExtensionInit(ScrnInfoPtr pScrn);

void hw3d_CursorPositionUpdate(VIABIOSInfoPtr pBIOSInfo);
void hw3d_ARGBCursorImageAdjust(VIAPtr pVia, VIADISP3DSCALCTRLPtr p3DSCALCTRLInfo, CARD32 srcAddr, CARD32 dstAddr, RECTL rSrc, CARD32 lSrcPitch, CARD32 dwSrcWidth,CARD32 dwSrcHeight);
/* Global Variables */
CARD8   *MMIOMapBase;

/*
 * DRM_LOCK/DRM_UNLOCK can not be called nestedly with the same Lock context, So Don't use them directly.
 * Just use DRILock()/DRIUnLock() insteadly for safe.
 */

#ifdef XF86DRI
/* Lock the hardware and validate our state.  
 */
#define viaLOCK_HARDWARE(p3DSCALCTRLInfo)                                	\
	DRM_LOCK(p3DSCALCTRLInfo->drmFD, ((XF86DRISAREAPtr)p3DSCALCTRLInfo->plock), p3DSCALCTRLInfo->xcontext, 0);	

/* Release the kernel lock.
 */
#define viaUNLOCK_HARDWARE(p3DSCALCTRLInfo)                                  	\
	DRM_UNLOCK(p3DSCALCTRLInfo->drmFD, ((XF86DRISAREAPtr)p3DSCALCTRLInfo->plock), p3DSCALCTRLInfo->xcontext);	
#endif

#endif  /* _VIA_DRIVER_H_ */
