/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_DRM_H_
#define _VIA_DRM_H_

#include "drm.h"
/* WARNING: These defines must be the same as what the Xserver uses.
 * if you change them, you must change the defines in the Xserver.
 */

#ifndef _VIA_DEFINES_
#define _VIA_DEFINES_

#define VIA_DMA_BUF_ORDER		12
#define VIA_DMA_BUF_SZ 		        (1 << VIA_DMA_BUF_ORDER)
#define VIA_DMA_BUF_NR 			256
#define VIA_NR_SAREA_CLIPRECTS 		8

/* Each region is a minimum of 64k, and there are at most 64 of them.
 */
#define VIA_NR_TEX_REGIONS 64
#define VIA_LOG_MIN_TEX_REGION_SIZE 16
#endif

#define VIA_UPLOAD_TEX0IMAGE  0x1 /* handled clientside */
#define VIA_UPLOAD_TEX1IMAGE  0x2 /* handled clientside */
#define VIA_UPLOAD_CTX        0x4
#define VIA_UPLOAD_BUFFERS    0x8
#define VIA_UPLOAD_TEX0       0x10
#define VIA_UPLOAD_TEX1       0x20
#define VIA_UPLOAD_CLIPRECTS  0x40
#define VIA_UPLOAD_ALL        0xff

/* Indices into buf.Setup where various bits of state are mirrored per
 * context and per buffer.  These can be fired at the card as a unit,
 * or in a piecewise fashion as required.
 */
 
#define VIA_TEX_SETUP_SIZE 8

/* Flags for clear ioctl
 */
#define VIA_FRONT   0x1
#define VIA_BACK    0x2
#define VIA_DEPTH   0x4
#define VIA_STENCIL 0x8

#define VIA_MEM_VIDEO   0	/* matches drm constant */
#define VIA_MEM_AGP     1	/* matches drm constant */
#define VIA_MEM_SYSTEM  2
#define VIA_MEM_MIXED   3
#define VIA_MEM_UNKNOWN 4

#define VIDEO 0
#define AGP 1
typedef struct {
    unsigned int offset;
    unsigned int size;
} drm_via_agp_t;    

typedef struct {
    unsigned int offset;
    unsigned int size;
} drm_via_fb_t;    

typedef struct {
    unsigned int context;
    unsigned int type;
    unsigned int size;
    unsigned long index;
    unsigned long offset;
} drm_via_mem_t;    

typedef struct {
    unsigned int offset;    /* This value should be set to the offset get from drm ioctl */
    unsigned int cmd_size;  /* Video cmd size */
    unsigned int buffer_size; /* Whole agp buffer size */
} drm_via_video_agp_cmd_t;
/*initialize AGP ring buffer in 2D driver*/
typedef struct _drm_via_dma_init {
	enum {
		VIA_INIT_DMA = 0x01,
		VIA_CLEANUP_DMA = 0x02,
                VIA_DMA_INITIALIZED = 0x03
	} func;
	unsigned long offset;
	unsigned long size;
	unsigned long reg_pause_addr;
} drm_via_dma_init_t;

#define DRM_COMMAND_BASE 0x40

/* VIA specific ioctls */
#define DRM_VIA_ALLOCMEM	0x00
#define DRM_VIA_FREEMEM	        0x01
#define DRM_VIA_AGP_INIT	0x02
#define DRM_VIA_FB_INIT	        0x03
#define DRM_VIA_MAP_INIT	0x04
#define DRM_VIA_DEC_FUTEX       0x05
#define NOT_USED
#define DRM_VIA_DMA_INIT	0x07
#define DRM_VIA_CMDBUFFER	0x08
#define DRM_VIA_FLUSH	        0x09
#define DRM_VIA_PCICMD	        0x0a
#define DRM_VIA_CMDBUF_SIZE	0x0b
#define NOT_USED
#define DRM_VIA_WAIT_IRQ        0x0d
#define DRM_VIA_DMA_BLIT        0x0e
#define DRM_VIA_BLIT_SYNC       0x0f
#define DRM_VIA_FLUSH_VIDEO 0x12
#define DRM_VIA_INIT_JUDGE  0x16
#define DRM_VIA_RING_BUFFER 0x17

typedef struct _drm_via_cmdbuffer {
     	char *buf;
        unsigned long size;
} drm_via_cmdbuffer_t;

typedef struct _drm_via_init {
    enum {
	VIA_INIT_MAP = 0x01,
	VIA_CLEANUP_MAP = 0x02
    } func;

    unsigned long sarea_priv_offset;
    unsigned long fb_offset;
    unsigned long mmio_offset;
    unsigned long agpAddr;
 /*agp flush drm*/
 unsigned long agp_offset;
 /*for setting AGP buffer type*/
     enum 
     {
         H2_AGP_RING_BUFFER,
         H2_AGP_DOUBLE_BUFFER,
         H2_AGP_DISABLED
     }agp_type;
} drm_via_init_t;

/*agp flush drm*/
typedef struct _drm_via_info{
	unsigned long AgpHandle;
	unsigned long AgpSize;
	unsigned long RegHandle;
	unsigned long RegSize;
}drm_via_info_t;

/* Warning: If you change the SAREA structure you must change the Xserver
 * structure as well */

typedef struct _drm_via_tex_region {
    unsigned char next, prev;	/* indices to form a circular LRU  */
    unsigned char inUse;	/* owned by a client, or free? */
    int age;			/* tracked by clients to update local LRU's */
} drm_via_tex_region_t;

typedef struct _drm_via_sarea {
    unsigned int dirty;
    unsigned int nbox;
    drm_clip_rect_t boxes[VIA_NR_SAREA_CLIPRECTS];   
    drm_via_tex_region_t texList[VIA_NR_TEX_REGIONS + 1]; 
    int texAge;			/* last time texture was uploaded */
    int ctxOwner;		/* last context to upload state */
    int vertexPrim;
} drm_via_sarea_t;

typedef struct _drm_via_flush_agp {
    unsigned int offset;
    unsigned int size;
/*For AMD64*/
#ifndef __x86_64__
    unsigned int index;		
#else
    unsigned long index;		
#endif
    int discard;	/* client is finished with the buffer? */
 /*agp flush drm*/
 	unsigned int buffer_offset;
 	unsigned int buffer_end;
} drm_via_flush_agp_t;

typedef struct _drm_via_flush_sys {
    unsigned int offset;
    unsigned int size;
    unsigned long index;		
    int discard;	/* client is finished with the buffer? */
} drm_via_flush_sys_t;

/* VIA specific ioctls */
#define DRM_IOCTL_VIA_ALLOCMEM	DRM_IOWR(0x40, drm_via_mem_t)
#define DRM_IOCTL_VIA_FREEMEM	DRM_IOW(0x41, drm_via_mem_t)
#define DRM_IOCTL_VIA_AGP_INIT	DRM_IOWR(0x42, drm_via_agp_t)
#define DRM_IOCTL_VIA_FB_INIT	DRM_IOWR(0x43, drm_via_fb_t)
#define DRM_IOCTL_VIA_MAP_INIT	DRM_IOWR(0x44, drm_via_init_t)
#define DRM_IOCTL_VIA_CMDBUFFER	  DRM_IOW( DRM_COMMAND_BASE + DRM_VIA_CMDBUFFER, drm_via_cmdbuffer_t)
#define DRM_IOCTL_VIA_FLUSH_VIDEO DRM_IOW(DRM_COMMAND_BASE + DRM_VIA_FLUSH_VIDEO, drm_via_video_agp_cmd_t)
#define DRM_IOCTL_VIA_CHROME9_DMA_INIT   DRM_IOW(DRM_COMMAND_BASE + DRM_VIA_RING_BUFFER, int)

/*add agp flush*/
/*
#define DRM_IOCTL_VIA_AGP_FLUSH DRM_IOW(0x46, drm_via_flush_agp_t)
*/
#define DRM_IOCTL_VIA_GET_INFO DRM_IOR(0x46, drm_via_info_t)

/*for non-root access issue*/
#define DRM_IOCTL_VIA_AUTH_MAGIC  DRM_IOW(0x51, drm_auth_t)
#define DRM_IOCTL_VIA_GET_PCI_ID  DRM_IOWR(0x52, drm_get_pci_id_t)

#endif /* _VIA_DRM_H_ */
