/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include "via_driver.h"
#include "via_eng_fops.h"
#include "via_eng_regs.h"
#include "debug.h"
#include "via_rotate.h"
#include "via_eng_reg_fops.h"
#undef min
#undef max
#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max(a, b) (((a) > (b)) ? (a) : (b))

/* INLINE */
__inline void vidWaitSUBFlip(unsigned long EngIndex,unsigned char* vbase)
{  
    unsigned long volatile *pdwState;
    
    if(EngIndex == HQV_0){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL);
    }else if(EngIndex == HQV_1){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL+REG_HQV1_INDEX);        
    }   
    
    while ((*pdwState & HQV_SUB_FLIP) );
}


__inline void vidWaitVideoCommandFire(unsigned long EngIndex,unsigned char* vbase)
{
    unsigned long volatile *pdwState = (unsigned long volatile *) (vbase+V_COMPOSE_MODE);

    if(EngIndex == VIDEO_1){
        while ((*pdwState & V1_COMMAND_FIRE));
    }else if(EngIndex == VIDEO_3){
        while ((*pdwState & V3_COMMAND_FIRE));
    }
}


__inline void vidWaitHQVFIFOEmpty(unsigned long EngIndex, unsigned char* vbase)
{
    unsigned long volatile *pdwState;

    if(EngIndex == HQV_0){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL);
    }else if(EngIndex == HQV_1){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL+REG_HQV1_INDEX);        
    }   
    
    while ((*pdwState & HQV_FIFO_STATUS) );
}


__inline void vidWaitHQVDone(unsigned long EngIndex, unsigned char* vbase)
{
    unsigned long volatile *pdwState;

    if(EngIndex == HQV_0){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL);
    }else if(EngIndex == HQV_1){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL+REG_HQV1_INDEX);        
    }  

    while ((*pdwState & HQV_SW_FLIP) );
}


__inline void vidWaitHQVFinish(unsigned long EngIndex, unsigned char* vbase)
{
    unsigned long volatile *pdwState;

    if(EngIndex == HQV_0){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL);
    }else if(EngIndex == HQV_1){
        pdwState = (unsigned long volatile *) (vbase+HQV_CONTROL+REG_HQV1_INDEX);        
    }  

    while (!(*pdwState & HQV_FLIP_STATUS) );
}


__inline void vidWait3DIdle(unsigned char* vbase)
{
    unsigned long volatile *pdwState = (unsigned long volatile *) (vbase+0x400);

    while ((*pdwState & 0x83) );
}


__inline void vidWaitVirtualQueueEmpty(unsigned char* vbase)
{
    unsigned long volatile *pdwState = (unsigned long volatile *) (vbase+REG_VQ_STATUS_CME);

    while ((*pdwState & VAL_VQ_NOT_EMPTY) );
}


unsigned long vidCalcMiniFactor(unsigned long dwSrc,unsigned long dwDst)
{
    unsigned long i=0;
    while((dwSrc>>i)>=dwDst)
    { 
        i++;
    }
    return i;
}


unsigned long vidSetZoomParam(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,PZOOMPARAM pZoomParam)
{   
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    unsigned long ovDstWidth,ovDstHeight,scalingWidth,scalingHeight;
    ViaXvRectRec curSrcRect = pOverlayRecord->dwOverlaySrcRect;

    ovDstWidth = pOverlayRecord->dwOverlayDestRect.right - pOverlayRecord->dwOverlayDestRect.left;
    ovDstHeight = pOverlayRecord->dwOverlayDestRect.bottom - pOverlayRecord->dwOverlayDestRect.top;
    scalingWidth = pOverlayRecord->dwScalingDestRect.right - pOverlayRecord->dwScalingDestRect.left;
    scalingHeight = pOverlayRecord->dwScalingDestRect.bottom - pOverlayRecord->dwScalingDestRect.top;

    pZoomParam->dwSrcWidth = curSrcRect.right - curSrcRect.left;
    pZoomParam->dwSrcHeight= curSrcRect.bottom - curSrcRect.top;

    if (viaGfxInfo->igaInfo[pPriv->curIGA-1].igagfx3DScaling_info.gfx3DScalingEnable ){
        if (scalingWidth <=ovDstWidth ) {
            pZoomParam->dwDstWidth = scalingWidth;
        } else {
            pZoomParam->dwDstWidth = ovDstWidth;
        }
        
        if (scalingHeight <= ovDstHeight){
            pZoomParam->dwDstHeight = scalingHeight;
        }
        else{
            pZoomParam->dwDstHeight = ovDstHeight;
        }
    }else {
        pZoomParam->dwDstWidth = ovDstWidth;
        pZoomParam->dwDstHeight = ovDstHeight;
    }

    pZoomParam->dwCtlHQVflag =pVidData->VidCtl.dwCtlHQVflag; 

    /*in video field-based flip, SrcHeight is set to 1/2 of original value
     *for zoom calculation
     */
    if (!(*pVideoFlag & VIDEO_HQV_INUSE) &&(pOverlayRecord->dwDeinterlaceMode & DDOVER_INTERLEAVED))
    {   
        pZoomParam->dwSrcHeight /=2;
    }
 
    DBG_DD(("Zoom Param Src WH:%ld,%ld,Dest WH:%ld,%ld\n",pZoomParam->dwSrcWidth,pZoomParam->dwSrcHeight,\
                pZoomParam->dwDstWidth,pZoomParam->dwDstHeight));
    return TRUE;
}


/* 
 * Set the HQV Dest addr.
 */
unsigned long vidSetHQVEngineDstAddr(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;    
    LPVIDEOHWINFO lphwinfo  = &pPriv->vidHWinfo;

    int i = 0;
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){ 
       
        for(i=0;i<XV_HQVSURFACE_NUM;i++){
            lphwinfo->dwHQVDstAddr[i] = pPriv->pHqvSurface[pPriv->curIGA-1]->offset[i];
        }
    }

    return TRUE;
}


unsigned long vidSetHQVEngineOffset(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;      
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;

    DBG_DD(("%s\n",__FUNCTION__));
    
    /* Changing HQV's src address settings while HQV is 
     * still busy processing current frames will easily cause HQV hang.This 
     * happens a lot in the case of HQV scaling-up enabled and desktop 
     * panning condition.
     * So We skip calculating HQV Engine offset and let it be 0,which means
     * HQV engines always get a whole frame from SW buf and process it
     * from the beginning, HQV Zoom out from the topest and leftest:(0,0)   
     */
    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){         
         lphwinfo->dwHQVOffset = 0;  
    }

    DBG_DD(("HQV Engine Offset:%lx\n",lphwinfo->dwHQVOffset));
    
    return TRUE;
}

 
unsigned long vidSetHQVEngineSrcFetch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;      

    unsigned long *pVideoFlag = &pPriv->videoFlag;
    unsigned long dwCtlHQVflag = pVidData->VidCtl.dwCtlHQVflag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;

    unsigned long hqvsrcFetch = 0;
    unsigned long tmpHQVSrcFetch = 0;  
    unsigned long width = pPriv->pXvSurface->width;
    unsigned long height = pPriv->pXvSurface->height;    
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){      

        if (pPriv->pXvSurface->formatType & DDPF_FOURCC){
            switch (pPriv->pXvSurface->format){
                case FOURCC_YV12:  
                case FOURCC_NV12:
                    if (*pVideoFlag & VIDEO_HQV_INUSE){
                        if ((dwCtlHQVflag&CTL_HQV_CSC_ENABLE_CME)&&
                            (dwCtlHQVflag&CTL_HQV_CSC_RGB32_CME))                     
                            hqvsrcFetch = width<<1;
                        else
                            hqvsrcFetch = width;           
                    }
                    break;

                case FOURCC_YUY2:
                    hqvsrcFetch = width<<1;                    
                    break;
                    
                default :
                    DBG_DD((" Invalid FOURCC format :(%lx)!\n", pPriv->pXvSurface->format));
                    break;
            }
        }else if (pPriv->pXvSurface->formatType & DDPF_RGB){
            switch (pPriv->pXvSurface->format){
                case RGB15:
                case RGB16:
                    hqvsrcFetch = width<<1;
                    break;
                case RGB32:
                    hqvsrcFetch = width<<2;
                   break;
        
                default :
                    DBG_DD((" Invalid RGB format\n"));
                    break;
            }
        }

        /* in any cases, field flip or not
         * HQV's src fetch count and vertical line doesn't change
         * because we always set 0x3d0[18:17]=[1:1] in field flip case
         * and [0:0] in frame flip case
         */
        lphwinfo->dwHQVSrcCountWH =((hqvsrcFetch-1)<<16)|(height-1);

        /* Patch for HQV source fetch count
         * We can't set the HQV source fetch count less than 8 pixels.
         * We set the value to 31 bytes for worse case with RGB32 format.
         */  
        tmpHQVSrcFetch = ((lphwinfo->dwHQVSrcCountWH & MASK_HQV_SRC_FETCH)>>16);
        if(tmpHQVSrcFetch < 32){
            lphwinfo->dwHQVSrcCountWH = 
                (lphwinfo->dwHQVSrcCountWH&(~MASK_HQV_SRC_FETCH))|VAL_HQV_SRC_FETCH_31;
        } 
    }
    
    return TRUE;
}


/* 
 * In the condition of HQV scalling up enabled, the pitch should be calculated
 * according to destination overlay's width. 
 */
unsigned long vidSetHQVEngineDstPitch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;     
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;    
        
    DBG_DD(("%s\n",__FUNCTION__));

    lphwinfo->dwHQVDstPitch = pPriv->pHqvSurface[pPriv->curIGA-1]->pitch;

    DBG_DD(("HQV Dst Pitch :%ld\n",lphwinfo->dwHQVDstPitch));  
    
    return TRUE;
}

unsigned long vidSetVideoEngineCtrl(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    unsigned long hqvCtrlflag = pVidData->VidCtl.dwCtlHQVflag;    
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;
    unsigned long *pVidCtrl = &lphwinfo->dwVidCtl; 
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    unsigned long dwDeinterlaceMode = pOverlayRecord->dwDeinterlaceMode;
    unsigned long format = 0;
    unsigned long formatType = 0;

    *pVidCtrl = 0;
     
    DBG_DD(("%s\n",__FUNCTION__));
 
    if(((pPriv->vidEngUpdate == VIDEO_1) && (*pVideoFlag & VIDEO_1_HIDE)) ||
        ((pPriv->vidEngUpdate == VIDEO_3) && (*pVideoFlag & VIDEO_3_HIDE))){
         if (pPriv->vidEngUpdate == VIDEO_1){
             *pVidCtrl &= ~VAL_VIDEO_ENABLE_CME;
         }else if (pPriv->vidEngUpdate == VIDEO_3){            
             *pVidCtrl &= ~VAL_VIDEO_ENABLE_CME;
         }
     }else if(((pPriv->vidEngUpdate == VIDEO_1) && (*pVideoFlag & VIDEO_1_SHOW)) ||
        ((pPriv->vidEngUpdate == VIDEO_3) && (*pVideoFlag & VIDEO_3_SHOW))){    
         if(pPriv->vidEngUpdate == VIDEO_1){
             *pVidCtrl &= ~(VAL_VIDEO_STREAM_FORMAT_MASK |
                             VAL_VIDEO_FLIP_CONTROL_MASK|VAL_VIDEO_REQ_EXPIRE_NUM_MASK);
         }else if(pPriv->vidEngUpdate == VIDEO_3){
             *pVidCtrl &= ~(VAL_VIDEO_STREAM_FORMAT_MASK |
                             VAL_VIDEO_FLIP_CONTROL_MASK|VAL_VIDEO_REQ_EXPIRE_NUM_MASK);
         }

        if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL){
             format     = pPriv->pRotSurface[pPriv->curIGA-1]->format;            
             formatType = pPriv->pRotSurface[pPriv->curIGA-1]->formatType; 
        }else{
            format     = pPriv->pHqvSurface[pPriv->curIGA-1]->format;            
            formatType = pPriv->pHqvSurface[pPriv->curIGA-1]->formatType;
        }        
 
         if (formatType & DDPF_FOURCC){        
             switch (format){
                 case FOURCC_YUY2:
                     if (*pVideoFlag & VIDEO_HQV_INUSE){
                             *pVidCtrl |= VAL_VIDEO_FORMAT_YUV422_CME|VAL_VIDEO_SWAP_HW_HQV_CME;
                     }else{
                         *pVidCtrl |= VAL_VIDEO_FORMAT_YUV422_CME;
                     }                   
                     DBG_DD(("Video Format YUY2\n"));
                     break;
                     
                 default :
                     DBG_DD((" Invalid FOURCC format :(%lx)!\n",format));
                     break;
             }
         }else if (formatType & DDPF_RGB){        
             switch (format){
                 case RGB15:
                     if (*pVideoFlag & VIDEO_HQV_INUSE){
                         *pVidCtrl |= VAL_VIDEO_FORMAT_RGB16_CME|VAL_VIDEO_SWAP_HW_HQV_CME;
                     }else{
                         *pVidCtrl |= VAL_VIDEO_FORMAT_RGB15_CME;
                     }
                     break;
 
                 case RGB16:
                     if (*pVideoFlag & VIDEO_HQV_INUSE){
                         *pVidCtrl |= VAL_VIDEO_FORMAT_RGB16_CME|VAL_VIDEO_SWAP_HW_HQV_CME;
                     }else{
                         *pVidCtrl |= VAL_VIDEO_FORMAT_RGB16_CME;
                     }
                     DBG_DD(("Video Format RGB16\n"));
                     break;
 
                 case RGB32:
                     if (*pVideoFlag & VIDEO_HQV_INUSE){
                         *pVidCtrl |= VAL_VIDEO_FORMAT_RGB32_CME|VAL_VIDEO_SWAP_HW_HQV_CME;
                     }else{
                         *pVidCtrl |= VAL_VIDEO_FORMAT_RGB32_CME;
                     }
                     break;
 
                 default :
                     DBG_DD((" Invalid FOURCC format :(%lx)!\n",format));
                     break;
             }
         }

        if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL){
             *pVidCtrl &= ~VAL_VIDEO_SWAP_HW_HQV_CME;
        }

        if(*pVideoFlag & VIDEO_ON_IGA2){
            lphwinfo->dwVidCtl |= VAL_VIDEO_ON_SND_DISPLAY ;
        }else{
            lphwinfo->dwVidCtl &= ~VAL_VIDEO_ON_SND_DISPLAY ;
        }
 
         if (*pVideoFlag & VIDEO_YUV_BYPASS){
             *pVidCtrl &= ~VAL_VIDEO_COLORSPACE_SIGN_CME;      
             *pVidCtrl |= VAL_VIDEO_COLORSPACE_DISABLE_CME;  
         }else{
             *pVidCtrl |= VAL_VIDEO_COLORSPACE_SIGN_CME;      
             *pVidCtrl &= ~VAL_VIDEO_COLORSPACE_DISABLE_CME;  
         }

         if(lpVideoHWDifference->dwNeedV3Prefetch || lpVideoHWDifference->dwNeedV1Prefetch){
             *pVidCtrl |= (VAL_VIDEO_EXPIRE_NUM_16_CME| VAL_VIDEO_PREFETCH_ON);
         }else{
             *pVidCtrl |= VAL_VIDEO_EXPIRE_NUM_CME;
         }
 
         /* SW path deinterlace setting for video engine.
          * HW path is handled in every flip action.
          * Either HQV or video enigne takes care of deinterlacing, one of them*/
         if (pOverlayRecord->dwDeinterlaceMode & DDOVER_INTERLEAVED){
             if(!(*pVideoFlag & VIDEO_HQV_INUSE)){
                 /*For testing video engine field-flip,comment the line below */
                 *pVidCtrl |= VAL_VIDEO_FRAME_BASE;
                  
                 if (dwDeinterlaceMode & DDOVER_BOB){
                     *pVidCtrl |= VAL_VIDEO_BOB_ENABLE;
                 }
             }
         }      
 
         *pVidCtrl |= VAL_VIDEO_ENABLE_CME;  
         DBG_DD(("Video Control %lx \n",*pVidCtrl));
     }
    return TRUE; 
}


/*
 * In/Out:  pData video source data structure pointer
 * Ret:
 * Desc:   calculate the starting address offset of video engine source data.
 */
unsigned long getVideoEngineSrcStartAddr(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{

    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;

    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;   
    ViaXvRectRec rSrc = pOverlayRecord->dwOverlaySrcRect;
    ViaXvRectRec rDest = pOverlayRecord->dwOverlayDestRect;
    unsigned long dwVideoFlag  = *pVideoFlag;
    unsigned long dwPitch = 0;
    unsigned long* lpdwOffset = &pOverlayRecord->dwOffset;    
    unsigned long dwAlign = ~3;
    unsigned long dwSrcTopOffset=0;
    unsigned long dwSrcLeftOffset=0;   
    unsigned long srcWidth = 0;                        
    unsigned long srcHeight = 0;  
    unsigned long dstWidth = 0;                        
    unsigned long dstHeight = 0;
    unsigned long scalingWidth=0,scalingHeight=0;
    unsigned long imageWidth = 0;    
    unsigned long imageHeight = 0;
    unsigned long rotate = viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL;
    unsigned long reflection = viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_REFLECT_ALL;


    if (!rotate){ 
        dwPitch = pPriv->pHqvSurface[pPriv->curIGA-1]->pitch;
    }else{
        dwPitch = pPriv->pRotSurface[pPriv->curIGA-1]->pitch;
    }

    DBG_DD(("rSrc X(%ld,%ld),Y(%ld,%ld)\n",rSrc.left,rSrc.right,rSrc.top,rSrc.bottom));
    DBG_DD(("rDst X(%ld,%ld),Y(%ld,%ld)\n",rDest.left,rDest.right,rDest.top,rDest.bottom));

    srcWidth = rSrc.right - rSrc.left;
    srcHeight = rSrc.bottom - rSrc.top;
    dstWidth = rDest.right - rDest.left; 
    dstHeight = rDest.bottom - rDest.top; 
    scalingWidth = pOverlayRecord->dwScalingDestRect.right - pOverlayRecord->dwScalingDestRect.left;
    scalingHeight = pOverlayRecord->dwScalingDestRect.bottom-pOverlayRecord->dwScalingDestRect.top;
    imageWidth = pPriv->pXvSurface->width;    
    imageHeight = pPriv->pXvSurface->height;    

    if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igagfx3DScaling_info.gfx3DScalingEnable)
    {
       /*rDest cooridinates are the smallest ones among src ,scalining and dst rectangle*/
        unsigned long tmp;
        tmp = (scalingWidth <= dstWidth)?scalingWidth:dstWidth;
        dstWidth = (srcWidth<= tmp)?srcWidth:tmp;
        tmp = (scalingHeight <=dstHeight)?scalingHeight:dstHeight;
        dstHeight =(srcHeight < tmp)?srcHeight:tmp;
    }


    DBG_DD(("hqvflag H_DOWN_SCALE?:%lx,V_DOWN_SCALE?%lx\n",
                pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME,pPriv->hqvEngFlag&VAL_HQV_V_DOWN_SCALE_CME));
    DBG_DD(("srcimage:WH:%ld,%ld\n",imageWidth,imageHeight));
    DBG_DD(("srcWidth:%ld,srcHeight:%ld\n",srcWidth,srcHeight));
    DBG_DD(("dstWidth:%ld,dstHeight:%ld\n",dstWidth,dstHeight));
    /*calculate start offset*/
    if (dwVideoFlag & VIDEO_HQV_INUSE){
       switch(rotate){
            case VIA_ROTATE_DEGREE_90:
                switch (reflection){
                    case VIA_ROTATE_REFLECT_X:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcTopOffset = (imageWidth-rSrc.right) 
                                              * dstWidth/srcWidth;
                        }else{
                            dwSrcTopOffset = imageWidth-rSrc.right;
                        }
                        
                        /*RGB16 if rotate, or YUY2 if not rotate, they all 2 bytes per pixel*/
                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcLeftOffset = ((imageHeight-rSrc.bottom)<<1) 
                                               * dstHeight/srcHeight;
                        }else{
                            dwSrcLeftOffset = (imageHeight-rSrc.bottom)<<1;
                        }
                        break;
                    case VIA_ROTATE_REFLECT_Y:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcTopOffset = rSrc.left*dstWidth/srcWidth;
                        }else{
                            dwSrcTopOffset = rSrc.left;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcLeftOffset = (rSrc.top<<1)*dstHeight/srcHeight;
                        }else{
                            dwSrcLeftOffset = rSrc.top<<1;
                        }
                        break;
                    default: 
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = ((imageHeight - rSrc.bottom)<<1) 
                                                *dstHeight/srcHeight;
                        }else{
                            dwSrcLeftOffset = (imageHeight- rSrc.bottom)<<1;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                           dwSrcTopOffset = rSrc.left * dstWidth/srcWidth;

                        }else{
                           dwSrcTopOffset = rSrc.left;
                        }
                        break;
                }
                break;
            case VIA_ROTATE_DEGREE_270:
                 switch (reflection){
                    case VIA_ROTATE_REFLECT_X:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcTopOffset = rSrc.left*dstWidth/srcWidth;
                        }else{
                            dwSrcTopOffset = rSrc.left;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcLeftOffset = (rSrc.top<<1) * dstHeight/srcHeight;
                        }else{
                            dwSrcLeftOffset = rSrc.top<<1;
                        }
                        break;
                    case VIA_ROTATE_REFLECT_Y:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcTopOffset = (imageWidth-rSrc.right)*dstWidth/srcWidth;
                        }else{
                            dwSrcTopOffset = imageWidth-rSrc.right;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcLeftOffset = ((imageHeight-rSrc.bottom)<<1) 
                                               *dstHeight/srcHeight;
                        }else{
                            dwSrcLeftOffset = (imageHeight-rSrc.bottom)<<1;
                        }
                        break;
                    default:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcTopOffset = (imageWidth-rSrc.right)*dstWidth/srcWidth;
                        }else{
                            dwSrcTopOffset = imageWidth-rSrc.right;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcLeftOffset = (rSrc.top<<1)*dstHeight/srcHeight;
                        }else{
                            dwSrcLeftOffset = rSrc.top<<1;
                        }
                        break;
                 }
                 break;
            case VIA_ROTATE_DEGREE_180:
                 switch (reflection){
                    case VIA_ROTATE_REFLECT_X:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = (rSrc.left<<1)*dstWidth/srcWidth;
                        }else{
                            dwSrcLeftOffset = rSrc.left<<1;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcTopOffset = (imageHeight-rSrc.bottom)*dstHeight/srcHeight;
                        }else{
                            dwSrcTopOffset = imageHeight-rSrc.bottom;
                        }
                        break;
                    case VIA_ROTATE_REFLECT_Y:
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = ((imageWidth-rSrc.right)<<1)
                                                *dstWidth/srcWidth;
                        }else{
                            dwSrcLeftOffset = (imageWidth-rSrc.right)<<1;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcTopOffset = rSrc.top*dstHeight/srcHeight;
                        }else{
                            dwSrcTopOffset = rSrc.top;
                        }
                        break;
                    default: 
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = ((imageWidth-rSrc.right)<<1)
                                                *dstWidth/srcWidth;
                        }else{
                            dwSrcLeftOffset = (imageWidth-rSrc.right)<<1;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcTopOffset = (imageHeight-rSrc.bottom)*dstHeight/srcHeight;
                        }else{
                            dwSrcTopOffset = imageHeight-rSrc.bottom;
                        }                        
                        break;
                 }
                 break;
            default: /*VIA_ROTATE_DEGREE_0*/
                switch (reflection){
                    case VIA_ROTATE_REFLECT_X:                        
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = ((imageWidth-rSrc.right)<<1) 
                                                * dstWidth/srcWidth;
                        }else{
                            dwSrcLeftOffset = (imageWidth-rSrc.right)<<1;
                        }
                        
                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcTopOffset = rSrc.top * dstHeight/srcHeight;
                        }else{
                            dwSrcTopOffset = rSrc.top;
                        }
                        break;
                    case VIA_ROTATE_REFLECT_Y:                        
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = (rSrc.left<<1) * dstWidth/srcWidth;
                        }else{
                            dwSrcLeftOffset = rSrc.left<<1;
                        }
                        
                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcTopOffset = (imageHeight-rSrc.bottom) 
                                               * dstHeight/srcHeight;
                        }else{
                            dwSrcTopOffset = imageHeight-rSrc.bottom;
                        }
                        break;
                    default: 
                        if(pPriv->hqvEngFlag & VAL_HQV_H_DOWN_SCALE_CME){
                            dwSrcLeftOffset = (rSrc.left<<1) * dstWidth/srcWidth;
                        }else{
                            dwSrcLeftOffset = rSrc.left<<1;
                        }

                        if(pPriv->hqvEngFlag & VAL_HQV_V_DOWN_SCALE_CME){
                            dwSrcTopOffset = rSrc.top * dstHeight/srcHeight;
                        }else{
                            dwSrcTopOffset = rSrc.top;
                        }
                        break;
                }
                break;
        }
    }
    
    DBG_DD(("SrcTopOffset:%ld,SrcLeftOffset:%ld\n", dwSrcTopOffset,dwSrcLeftOffset));
    
    *lpdwOffset=(dwSrcTopOffset*dwPitch+dwSrcLeftOffset)&dwAlign;        
 
    return TRUE;
}


unsigned long vidSetVideoEngineStartAddr(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;   
    unsigned long dwOffset  = 0;

    int ret = TRUE;

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){ 
        getVideoEngineSrcStartAddr(pScrn, pPriv);

        dwOffset = pOverlayRecord->dwOffset;
        
        if(*pVideoFlag& VIDEO_HQV_INUSE){   
            if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit){
                if (pPriv->pRotSurface[pPriv->curIGA-1]->cur_idx == 0){
                    lphwinfo->dwVSrcAddr[0] = pPriv->pRotSurface[pPriv->curIGA-1]->offset[0]+dwOffset;
                    lphwinfo->dwVSrcAddr[1] = pPriv->pRotSurface[pPriv->curIGA-1]->offset[0]+dwOffset;
                    lphwinfo->dwVSrcAddr[2] = pPriv->pRotSurface[pPriv->curIGA-1]->offset[0]+dwOffset;
                }else {
                    lphwinfo->dwVSrcAddr[0] = pPriv->pRotSurface[pPriv->curIGA-1]->offset[1]+dwOffset;
                    lphwinfo->dwVSrcAddr[1] = pPriv->pRotSurface[pPriv->curIGA-1]->offset[1]+dwOffset;
                    lphwinfo->dwVSrcAddr[2] = pPriv->pRotSurface[pPriv->curIGA-1]->offset[1]+dwOffset;
                }
            }else{    
                lphwinfo->dwVSrcAddr[0] = pPriv->pHqvSurface[pPriv->curIGA-1]->offset[0]+dwOffset;
                lphwinfo->dwVSrcAddr[1] = pPriv->pHqvSurface[pPriv->curIGA-1]->offset[1]+dwOffset;
                lphwinfo->dwVSrcAddr[2] = pPriv->pHqvSurface[pPriv->curIGA-1]->offset[2]+dwOffset;
            }                
        }
    }
              
    DBG_DD(("Video Start Offset :%lx\n",lphwinfo->dwVSrcAddr[0]));
    return TRUE;
}

unsigned long vidSetVideoEngineFetch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    ViaXvRectRec rDest = pOverlayRecord->dwOverlayDestRect; 
    ViaXvRectRec rSrc = pOverlayRecord->dwOverlaySrcRect; 
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;
    unsigned long format = 0;
    unsigned long formatType = 0;   
    unsigned long dwFetchSrc=0,dwShift;

    DBG_DD(("%s\n",__FUNCTION__));   

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL){
            format     = pPriv->pRotSurface[pPriv->curIGA-1]->format;            
            formatType = pPriv->pRotSurface[pPriv->curIGA-1]->formatType;        
        }else{
            format     = pPriv->pHqvSurface[pPriv->curIGA-1]->format;            
            formatType = pPriv->pHqvSurface[pPriv->curIGA-1]->formatType;
        }              
        

        switch(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL)
        {
             case VIA_ROTATE_DEGREE_90:
             case VIA_ROTATE_DEGREE_270:
                  dwFetchSrc = min((rSrc.bottom - rSrc.top),(rDest.bottom - rDest.top));
                  break;
             case VIA_ROTATE_DEGREE_180:
             default:
                  dwFetchSrc = min((rSrc.right - rSrc.left),(rDest.right - rDest.left));
                 break;
             }
            /*setup shift value*/
        if (formatType & DDPF_FOURCC){
            switch(format){
                case FOURCC_YUY2:
                    dwShift = 1;
                    break;
                case FOURCC_NV12:
                case FOURCC_YV12:
                    dwShift = 0;
                    break;
                default:
                    DBG_DD((" Unsupported YUV format!\n"));
                    break;
             }            
        }else if (formatType & DDPF_RGB){
            switch(format){
                case RGB15:
                case RGB16:
                    dwShift = 1;
                    break;
                case RGB32:
                    dwShift = 2;
                    break;
                default:
                    DBG_DD((" Unsupported RGB format!\n"));
                    break;
            }
        }  
            
        DBG_DD(("dwShift:%ld\n",dwShift));
        
        /*calculate fetch count */
        lphwinfo->dwFetch =((((dwFetchSrc<<dwShift)+V1_FETCHCOUNT_ALIGNMENT)\
                    & ~V1_FETCHCOUNT_ALIGNMENT) >> V1_FETCHCOUNT_UNIT)+1;  
    
       /* Fix plannar mode problem */
       if (lphwinfo->dwFetch <4)
            lphwinfo->dwFetch = 4;
       
        lphwinfo->dwFetch = lphwinfo->dwFetch << 20;

        DBG_DD(("Video Src Fetch:%lx\n",lphwinfo->dwFetch));  
    }
    return TRUE;
}


/* 
 * In the condition of HQV scalling up enabled, the pitch should be calculated
 * according to destination overlay's width.
 */
unsigned long vidSetVideoEngineSrcPitch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;    

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){

        if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit & \
            (VIA_ROTATE_DEGREE_ALL |VIA_ROTATE_REFLECT_ALL)){
            lphwinfo->dwVPitch = pPriv->pRotSurface[pPriv->curIGA-1]->pitch;
        }else{
            lphwinfo->dwVPitch = pPriv->pHqvSurface[pPriv->curIGA-1]->pitch;
        }
    }
    
    DBG_DD(("Video Src Pitch:%ld\n",lphwinfo->dwVPitch));
    return TRUE;
}


unsigned long vidSetVideoEngineDstStart(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDEOHWINFO lphwinfo  = &pPriv->vidHWinfo; 
    ViaXvRectRec rSrc  = pOverlayRecord->dwOverlaySrcRect;
    ViaXvRectRec rDest = pOverlayRecord->dwOverlayDestRect;  
    ViaXvRectRec expandDstRect = pOverlayRecord->dwExpandDestRect;
    ViaXvRectRec scalingDstRect = pOverlayRecord->dwScalingDestRect;
    ViaXvRectRec rDest_rot;
    unsigned long reflection = viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit& VIA_ROTATE_REFLECT_ALL;   
    unsigned long swap;

    unsigned long scrnWidth = viaGfxInfo->igaInfo[pPriv->curIGA-1].desired_width;
    unsigned long scrnHeight = viaGfxInfo->igaInfo[pPriv->curIGA-1].desired_height;
     DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        
        DBG_DD(("rSrc  X (%ld,%ld) Y (%ld,%ld)\n",
                rSrc.left, rSrc.right,rSrc.top, rSrc.bottom));
        DBG_DD(("rDest  X (%ld,%ld) Y (%ld,%ld)\n",
                rDest.left, rDest.right,rDest.top, rDest.bottom));

        switch(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL)
        {
            case VIA_ROTATE_DEGREE_90:
                rDest_rot.left = scrnWidth - rDest.bottom;
                rDest_rot.top = rDest.left;
                rDest_rot.right = scrnWidth - rDest.top;
                rDest_rot.bottom = rDest.right;
                /*check reflection*/
                if (reflection & VIA_ROTATE_REFLECT_X){
                    swap = rDest_rot.top;
                    rDest_rot.top = scrnHeight-rDest_rot.bottom;
                    rDest_rot.bottom = scrnHeight-swap;
                }
                if (reflection & VIA_ROTATE_REFLECT_Y){
                    swap = rDest_rot.left;
                    rDest_rot.left = scrnWidth - rDest_rot.right;
                    rDest_rot.right = scrnWidth - swap; 
                }

                lphwinfo->dwWinStartXY = ((rDest_rot.left<<16) + rDest_rot.top);
                lphwinfo->dwWinEndXY= (((rDest_rot.right-1)<<16) + (rDest_rot.bottom - 1));
                DBG_DD(("90 degree rDest_rot  X (%ld,%ld) Y (%ld,%ld)\n",
                        rDest_rot.left, rDest_rot.right,rDest_rot.top, rDest_rot.bottom));
                break;
            case VIA_ROTATE_DEGREE_270:
                rDest_rot.left=rDest.top;
                rDest_rot.top=scrnHeight-rDest.right;
                rDest_rot.right=rDest.bottom;
                rDest_rot.bottom=scrnHeight-rDest.left;
                /*check reflection*/
                if (reflection & VIA_ROTATE_REFLECT_X){
                    swap = rDest_rot.top;
                    rDest_rot.top = scrnHeight-rDest_rot.bottom;
                    rDest_rot.bottom = scrnHeight-swap;
                }
                if (reflection & VIA_ROTATE_REFLECT_Y){
                    swap = rDest_rot.left;
                    rDest_rot.left = scrnWidth - rDest_rot.right;
                    rDest_rot.right = scrnWidth - swap; 
                }
                lphwinfo->dwWinStartXY = ((rDest_rot.left<<16) + rDest_rot.top);
                lphwinfo->dwWinEndXY= (((rDest_rot.right-1)<<16) + (rDest_rot.bottom - 1));
                DBG_DD(("270 degree rDest_rot  X (%ld,%ld) Y (%ld,%ld)\n",
                        rDest_rot.left, rDest_rot.right,rDest_rot.top, rDest_rot.bottom));

                break;
            case VIA_ROTATE_DEGREE_180:
                rDest_rot.left=scrnWidth-rDest.right;
                rDest_rot.top=scrnHeight-rDest.bottom;
                rDest_rot.right=scrnWidth-rDest.left;
                rDest_rot.bottom=scrnHeight-rDest.top;
                
                /* Patch for the issue of :
                   an abnormal line on top of video when fullscreen in RandR rotate inverted path */
                if((rDest.bottom - rDest.top) == (long)scrnHeight)  // Fullscreen condition check
                    rDest_rot.bottom--;
                
                /*check reflection*/
                if (reflection & VIA_ROTATE_REFLECT_X){
                    swap = rDest_rot.left;
                    rDest_rot.left = scrnWidth-rDest_rot.right;
                    rDest_rot.right = scrnWidth-swap; 
                }
                if (reflection & VIA_ROTATE_REFLECT_Y){
                    swap = rDest_rot.top;
                    rDest_rot.top = scrnHeight-rDest_rot.bottom;
                    rDest_rot.bottom = scrnHeight-swap;
                }
                lphwinfo->dwWinStartXY = ((rDest_rot.left<<16) + rDest_rot.top);
                lphwinfo->dwWinEndXY= (((rDest_rot.right-1)<<16) + (rDest_rot.bottom - 1));
                DBG_DD(("180 degree rDest_rot  X (%ld,%ld) Y (%ld,%ld)\n",
                        rDest_rot.left, rDest_rot.right,rDest_rot.top, rDest_rot.bottom));
                break;
            default: /*VIA_ROTATE_DEGREE_0*/
                if (viaGfxInfo->igaInfo[pPriv->curIGA-1].igagfx3DScaling_info.gfx3DScalingEnable)
                    rDest_rot = scalingDstRect;
                else rDest_rot = rDest;
                /*check reflection*/
                if (reflection & VIA_ROTATE_REFLECT_X){
                    swap = rDest_rot.left;
                    rDest_rot.left = scrnWidth-rDest_rot.right;
                    rDest_rot.right = scrnWidth-swap; 
                }
                if (reflection & VIA_ROTATE_REFLECT_Y){
                    swap = rDest_rot.top;
                    rDest_rot.top = scrnHeight-rDest_rot.bottom;
                    rDest_rot.bottom = scrnHeight-swap;
                }
                
                DBG_DD(("0 degree rDest_rot  X (%ld,%ld) Y (%ld,%ld)\n",
                        rDest_rot.left, rDest_rot.right,rDest_rot.top, rDest_rot.bottom));
                
               /*patch for LCD expansion cases.
                 *There's one more keycolor line on top of the video*/    
                if (viaGfxInfo->igaInfo[pPriv->curIGA-1].igaStatus.expanded)
                {
                    lphwinfo->dwWinStartXY = 
                        ((rDest_rot.left<<16) + (rDest_rot.top-((rDest_rot.top>0)?1:0)));
                }else{
                    lphwinfo->dwWinStartXY = ((rDest_rot.left<<16) + rDest_rot.top);
                }
                
                lphwinfo->dwWinEndXY= (((rDest_rot.right-1)<<16) + (rDest_rot.bottom - 1));   
                break;
        }   
    } 
   
    return TRUE;
}


unsigned long vidSetVideoEngineDstWidthandHeight(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;    
    ViaXvRectRec curSrcRect = pOverlayRecord->dwOverlaySrcRect;
    ViaXvRectRec curDstRect = pOverlayRecord->dwOverlayDestRect;
    ViaXvRectRec expandDstRect = pOverlayRecord->dwExpandDestRect; 

    unsigned long dwCtlHQVflag      = pVidData->VidCtl.dwCtlHQVflag;
    LPVIDEOHWINFO lphwinfo          = &pPriv->vidHWinfo;
    
    unsigned long dwSrcWidth      =0, dwDstWidth = 0;
    unsigned long dwSrcHeight   =0, dwDstHeight = 0;
   
    dwSrcWidth = curSrcRect.right - curSrcRect.left;
    dwSrcHeight= curSrcRect.bottom - curSrcRect.top;
    dwDstWidth = curDstRect.right - curDstRect.left;
    dwDstHeight= curDstRect.bottom - curDstRect.top;
    
    DBG_DD(("Actual Src(%ld,%ld),Dst(%ld,%ld)\n",dwSrcWidth,dwSrcHeight,dwDstWidth,dwDstHeight)); 
    if((*pVideoFlag & VIDEO_BYPASS_HOR_EXPAND)
        &&(*pVideoFlag & VIDEO_ON_IGA2)){        
            dwDstWidth = expandDstRect.right - expandDstRect.left;     
    }

    if((*pVideoFlag & VIDEO_BYPASS_VER_EXPAND)
        &&(*pVideoFlag & VIDEO_ON_IGA2)){        
            dwDstHeight= expandDstRect.bottom - expandDstRect.top;    
    }

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){   

        switch(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL)
        {
                case VIA_ROTATE_DEGREE_90:
                case VIA_ROTATE_DEGREE_270:
                    lphwinfo->dwVDisplayCount = dwDstWidth<<16|dwDstHeight-1;
                    break;
                case VIA_ROTATE_DEGREE_180:
                    lphwinfo->dwVDisplayCount = dwDstHeight<<16|dwDstWidth-1;
                    break;
                case VIA_ROTATE_DEGREE_0:
                    lphwinfo->dwVDisplayCount=((dwDstHeight<dwSrcHeight)?dwDstHeight:dwSrcHeight)<<16
                            |((dwDstWidth<dwSrcWidth)?dwDstWidth:dwSrcWidth)-1;
                    break;
                default:
                    break;
        }  
    }
    DBG_DD(("dwVDisplayCount:%lx\n",lphwinfo->dwVDisplayCount)); 
    return TRUE;
}


unsigned long vidSetVideoEngineColorKey(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  

    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;

    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 

    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;   
    unsigned long dwColorKeyOn = pOverlayRecord->dwColorKeyOn;    
    unsigned long dwKeyLow = pOverlayRecord->dwKeyLow;
    unsigned long *IGA_Video_Map = pVidData->IGA_Video_Map;
    
    DBG_DD(("pPriv->vidEngUpdate= %lx,*pVideoFlag=%lx \n",pPriv->vidEngUpdate,*pVideoFlag));
    
    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){  
        lphwinfo->dwPriDispColorKey    = 0;
        lphwinfo->dwSndDispColorKey    = 0;
        lphwinfo->dwPriDispSndColorKey = 0;
        
        if (dwColorKeyOn){
            dwKeyLow = pOverlayRecord->dwKeyLow ;
            dwKeyLow &= VAL_VIDEO_COLOR_KEY_MASK;
        
            DBG_DD(("Overlay colorkey=%08lx\n", dwKeyLow));         

           switch(viaGfxInfo->chipId)
           {
                /*v3 exist*/
                case VIA_DEVICE_VT3314:    
                    if(IGA_Video_Map[IGA1] & VIDEO_3){
                        lphwinfo->dwPriDispColorKey = dwKeyLow;
                    }else if(IGA_Video_Map[IGA2] & VIDEO_3){
                        lphwinfo->dwSndDispColorKey = dwKeyLow;
                    }
                    break; 
                                       
                /* v1 exist*/ 
                case VIA_DEVICE_VT3336:
                case VIA_DEVICE_VT3327:
                case VIA_DEVICE_VT3364:    
                    if(IGA_Video_Map[IGA1] & VIDEO_1){
                        lphwinfo->dwPriDispColorKey = dwKeyLow;
                    }else if(IGA_Video_Map[IGA2] & VIDEO_1){
                        lphwinfo->dwSndDispColorKey = dwKeyLow;
                    }
                    break;
                                    
                /*v1 v3 both exist*/
                case VIA_DEVICE_VT3324:
                case VIA_DEVICE_VT3353:
                case VIA_DEVICE_VT3409:    
                    if(IGA_Video_Map[IGA1] & VIDEO_1){
                        lphwinfo->dwPriDispColorKey = dwKeyLow|VAL_VIDEO_COLOR_KEY_ENABLE_CME;
                    }else if(IGA_Video_Map[IGA2] & VIDEO_1){
                        lphwinfo->dwSndDispColorKey = dwKeyLow|VAL_VIDEO_COLOR_KEY_ENABLE_CME;
                    }

                    if(IGA_Video_Map[IGA1] & VIDEO_3){
                        lphwinfo->dwPriDispSndColorKey = dwKeyLow|VAL_VIDEO_COLOR_KEY_ENABLE_CME;                
                    }else if(IGA_Video_Map[IGA2] & VIDEO_3){
                        lphwinfo->dwPriDispSndColorKey = VAL_VIDEO_COLOR_KEY_ENABLE_CME;
                    }
                    break;
                                
                default:                    
                    break;    
            }            
        }
    }
    return TRUE;
}


unsigned long vidSetVideoEngineChromaKey(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;

    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 

    LPVIDEOHWINFO lphwinfo       = &pPriv->vidHWinfo;   
    unsigned long dwChromaKeyOn  = pOverlayRecord->dwChromaKeyOn;
    unsigned long dwChromaLow    = pOverlayRecord->dwChromaLow;
    unsigned long dwChromaHigh   = pOverlayRecord->dwChromaHigh;   
    unsigned long format;
    unsigned long formatType;

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){  
        if (dwChromaKeyOn){
            DBG_DD(("Overlay Chromakey=%08lx %08lx\n",dwChromaLow,dwChromaHigh));
        
            dwChromaLow  &= CHROMA_KEY_LOW;
            dwChromaHigh &= CHROMA_KEY_HIGH;
        
            dwChromaLow  |= (VIDInD(V_CHROMAKEY_LOW)&(~CHROMA_KEY_LOW));
            dwChromaHigh |= (VIDInD(V_CHROMAKEY_HIGH)&(~CHROMA_KEY_HIGH));

            if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL){
                format     = pPriv->pRotSurface[pPriv->curIGA-1]->format;            
                formatType = pPriv->pRotSurface[pPriv->curIGA-1]->formatType;        
            }else{
                format     = pPriv->pHqvSurface[pPriv->curIGA-1]->format;            
                formatType = pPriv->pHqvSurface[pPriv->curIGA-1]->formatType;
            } 
            
            /*  for Chroma Key */
            if (formatType & DDPF_FOURCC){
                switch (format){
                    case FOURCC_YV12:
                        /* to be continued... */
                        break;
                    case FOURCC_YUY2:
                    case FOURCC_NV12:
                        /* to be continued... */
                        break;
                    default:
                        break;
                }
            }else if (formatType & DDPF_RGB){
                unsigned long dwtmpLowR;
                unsigned long dwtmpLowG;
                unsigned long dwtmpLowB;
                unsigned long dwtmpChromaLow;
                unsigned long dwtmpHighR;
                unsigned long dwtmpHighG;
                unsigned long dwtmpHighB;
                unsigned long dwtmpChromaHigh;
        
                switch (format){
                    case RGB15:
                        dwtmpLowR = (((dwChromaLow >> 10) << 3) | ((dwChromaLow >> 12) & 0x07)) & 0xFF;
                        dwtmpLowG = (((dwChromaLow >> 5) << 3) | ((dwChromaLow >> 7) & 0x07)) & 0xFF;
                        dwtmpLowB = (((dwChromaLow << 3) | (dwChromaLow >> 2)) & 0x07) & 0xFF;
                        dwtmpChromaLow = (dwtmpLowG << 16) | (dwtmpLowR << 8) | dwtmpLowB;
                        dwChromaLow = ((dwChromaLow >> 24) << 24) | dwtmpChromaLow;
        
                        dwtmpHighR = (((dwChromaHigh >> 10) << 3) | ((dwChromaHigh >> 12) & 0x07)) & 0xFF;
                        dwtmpHighG = (((dwChromaHigh >> 5) << 3) | ((dwChromaHigh >> 7) & 0x07)) & 0xFF;       
                        dwtmpHighB = (((dwChromaHigh << 3) | (dwChromaHigh >> 2)) & 0x07) & 0xFF;
                        dwtmpChromaHigh = (dwtmpHighG << 16) | (dwtmpHighR << 8) | dwtmpHighB;
                        dwChromaHigh = ((dwChromaHigh >> 24) << 24) | dwtmpChromaHigh;
                        break;                       

                    case RGB16:
                        dwtmpLowR = (((dwChromaLow >> 11) << 3) | ((dwChromaLow >> 13) & 0x07)) & 0xFF;
                        dwtmpLowG = (((dwChromaLow >> 5) << 2) | ((dwChromaLow >> 9) & 0x03)) & 0xFF;
                        dwtmpLowB = (((dwChromaLow << 3) | (dwChromaLow >> 2)) & 0x07) & 0xFF;
                        dwtmpChromaLow = (dwtmpLowG << 16) | (dwtmpLowR << 8) | dwtmpLowB;
                        dwChromaLow = ((dwChromaLow >> 24) << 24) | dwtmpChromaLow;
  
                        dwtmpHighR = (((dwChromaHigh >> 11) << 3) | ((dwChromaHigh >> 13) & 0x07)) & 0xFF;
                        dwtmpHighG = (((dwChromaHigh >> 5) << 2) | ((dwChromaHigh >> 9) & 0x03)) & 0xFF;     
                        dwtmpHighB = (((dwChromaHigh << 3) | (dwChromaHigh >> 2)) & 0x07) & 0xFF;
                        dwtmpChromaHigh = (dwtmpHighG << 16) | (dwtmpHighR << 8) | dwtmpHighB;
                        dwChromaHigh = ((dwChromaHigh >> 24) << 24) | dwtmpChromaHigh;
                        break;  
       
                    case RGB32: /* 32 bit RGB */
                        dwtmpLowR = (dwChromaLow >> 16) & 0xFF;
                        dwtmpLowG = (dwChromaLow >> 8) & 0xFF;
                        dwtmpLowB = dwChromaLow & 0xFF;
                        dwtmpChromaLow = (dwtmpLowG << 16) | (dwtmpLowR << 8) | dwtmpLowB;
                        dwChromaLow = ((dwChromaLow >> 24) << 24) | dwtmpChromaLow;
        
                        dwtmpHighR = (dwChromaHigh >> 16) & 0xFF;
                        dwtmpHighG = (dwChromaHigh >> 8) & 0xFF;
                        dwtmpHighB = dwChromaHigh & 0xFF;
                        dwtmpChromaHigh = (dwtmpHighG << 16) | (dwtmpHighR << 8) | dwtmpHighB;
                        dwChromaHigh = ((dwChromaHigh >> 24) << 24) | dwtmpChromaHigh;
                        break;
        
                    default:
                        break;
                }
            }/* End of DDPF_FOURCC */
        
            lphwinfo->dwChromaKeyHigh = dwChromaHigh;
            if (pPriv->vidEngUpdate == VIDEO_1){
                lphwinfo->dwChromaKeyLow = 
                        (dwChromaLow&(~V_CHROMAKEY_V3))|VAL_VIDEO_CHROMA_KEY_ENABLE_CME;
            }else{
                lphwinfo->dwChromaKeyLow = 
                    dwChromaLow|V_CHROMAKEY_V3|VAL_VIDEO_CHROMA_KEY_ENABLE_CME;
            }
        }
    }
    return TRUE;
}

void vidSetVideoColor(VIAPtr pVia, long Hue, long Saturation, long Brightness, long Contrast)
{   
    PVIDDATA pVidData = pVia->pVidData;

    float fA,fB1,fC1,fD,fB2,fC2,fB3,fC3;
    float fPI,fContrast,fSaturation,fHue,fBrightness;
    unsigned long dwA,dwB1,dwC1,dwD,dwB2,dwC2,dwB3,dwC3,dwS,dwColor1,dwColor2;
    unsigned long dwD_Int,dwD_Dec;
    int intD;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    if (!pVidData->IsSupportedColorSpaceChange)
    {
        return;
    }
    
    fPI = (float)(PI/180);

    if((Hue == 0)&&(Saturation == 10000)&&(Brightness == 5000)&&(Contrast == 10000))  /*Default*/
    {
        pVidData->ColorSpaceChanged = FALSE;

        switch(viaGfxInfo->chipId)
        {
            case VIA_DEVICE_VT3324:
            case VIA_DEVICE_VT3353: 
            case VIA_DEVICE_VT3409:     
                VIDOutD(ColorSpaceReg_1, ColorSpaceValue_1_3123C0);
                VIDOutD(ColorSpaceReg_2, ColorSpaceValue_2_3123C0);
                VIDOutD(V3_ColorSpaceReg_1, ColorSpaceValue_1_3123C0);
                VIDOutD(V3_ColorSpaceReg_2, ColorSpaceValue_2_3123C0);
                DBG_DD(("00000284 %08x\n",ColorSpaceValue_1_3123C0));
                DBG_DD(("00000288 %08x\n",ColorSpaceValue_2_3123C0));
                DBG_DD(("000002C4 %08x\n",ColorSpaceValue_1_3123C0));
                DBG_DD(("000002C8 %08x\n",ColorSpaceValue_2_3123C0));
                break;
            case VIA_DEVICE_VT3327:
            case VIA_DEVICE_VT3336:
            case VIA_DEVICE_VT3364:    
                VIDOutD(ColorSpaceReg_1, ColorSpaceValue_1_3123C0);
                VIDOutD(ColorSpaceReg_2, ColorSpaceValue_2_3123C0);   
                DBG_DD(("00000284 %08x\n",ColorSpaceValue_1_3123C0));
                DBG_DD(("00000288 %08x\n",ColorSpaceValue_2_3123C0));         
                break;
            case VIA_DEVICE_VT3314:
                VIDOutD(V3_ColorSpaceReg_1, ColorSpaceValue_1_32045);
                VIDOutD(V3_ColorSpaceReg_2, ColorSpaceValue_2_32045);
                DBG_DD(("000002C4 %08x\n",ColorSpaceValue_1_32045));
                DBG_DD(("000002C8 %08x\n",ColorSpaceValue_2_32045));

                pVidData->ColorSpaceValue1 = ColorSpaceValue_1_32045;
                pVidData->ColorSpaceValue2 = ColorSpaceValue_2_32045;
                break;
            default:
                DBG_DD((" Unknow Device ID \n"));
                break;
        }
    }
    else
    {
        pVidData->ColorSpaceChanged = TRUE;

        fBrightness = (float)Brightness;
        if (fBrightness == 5000) fBrightness = 5120;
        else if (fBrightness > 5000) fBrightness = 5120*(1+(fBrightness-5000)/4370);
        else fBrightness = 5120*((fBrightness)/5000);
        fBrightness = (float)(-125.9656+251.0721*(fBrightness/10000.));
        fContrast = (float)(Contrast/20000.*1.6645);
        fSaturation = (float)(Saturation/10000.);
        fHue = (float)Hue;

        switch(viaGfxInfo->chipId)
        {
            case VIA_DEVICE_VT3324:
            case VIA_DEVICE_VT3327:
            case VIA_DEVICE_VT3336:
            case VIA_DEVICE_VT3364:    
            case VIA_DEVICE_VT3353:
            case VIA_DEVICE_VT3409:
                fA  = (float)(1.1875*fContrast);
                fB1 = (float)(-1.625*fContrast*fSaturation*sin(fHue*fPI));
                fC1 = (float)(1.625*fContrast*fSaturation*cos(fHue*fPI));
                fD  = (float)(1.1875*(fBrightness-16));
                fB2 = (float)((0.875*sin(fHue*fPI)-0.375*cos(fHue*fPI))*fContrast*fSaturation);
                fC2 = (float)(-(0.875*cos(fHue*fPI)+0.375*sin(fHue*fPI))*fContrast*fSaturation);
                fB3 = (float)(2.0*fContrast*fSaturation*cos(fHue*fPI));
                fC3 = (float)(2.0*fContrast*fSaturation*sin(fHue*fPI));

                if (fA <= 0)
                    fA = 0;

                if (fA >= 1.9375)
                    fA = 1.9375;

                dwA     = ((unsigned long)(fA*32+1))>>1;
                if (dwA >= 0x1f)
                {
                    dwA = 0x1f;
                }
                else
                {
                    dwA &=0x1f;
                }

                if (fB1 >= 2.125)
                    fB1 = 2.125;

                if (fB1 <= -2.125)
                    fB1 = -2.125;

                if (fB1>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fB1 = -fB1;
                }

                dwB1    = ((unsigned long)(fB1*16+1))>>1;
                if (dwB1>=0x1f)
                {
                    dwB1 = 0x1f|(dwS<<5);
                }
                else
                {
                    dwB1 = (dwB1&0x1f)|(dwS<<5);
                }

                if (fC1<= -2.125)
                    fC1= -2.125;
                if (fC1>= 2.125)
                    fC1= 2.125;


                if (fC1>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fC1 = -fC1;
                }

                dwC1    = ((unsigned long)(fC1*16+1))>>1;
                if (dwB1>=0x1f)
                {
                    dwB1 = 0x1f|(dwS<<5);
                }
                else
                {
                    dwB1 = (dwB1&0x1f)|(dwS<<5);
                }

                if (fD>=0)
                {
                    intD=(int)fD;
                    if (intD>127)
                        intD = 127;
                    dwD_Int = ((unsigned long)intD)&0xff;
                    dwD = ((unsigned long)(fD*16+1))>>1;
                    dwD_Dec= dwD&0x7;
                }
                else
                {
                    intD=(int)fD;
                    if (intD< -128)
                      intD = -128;
                    intD = intD+256;
                    dwD_Int = ((unsigned long)intD)&0xff;
                    fD = -fD;
                    dwD = ((unsigned long)(fD*16+1))>>1;
                    dwD_Dec= dwD&0x7;
                }

                if (fB2>= 1.875)
                    fB2= 1.875;

                if (fB2<= -1.875)
                    fB2= -1.875;

                if (fB2>=0)
                {
                    dwS = 0;
                }
                else
                {
                   dwS = 1;
                   fB2 = -fB2;
                }

                dwB2    = ((unsigned long)(fB2*16+1))>>1;

                if (dwB2>=0xf)
                {
                    dwB2 = 0xf|(dwS<<4);
                }
                else
                {
                    dwB2 = (dwB2&0xf)|(dwS<<4);
                }

                if (fC2>= 1.875)
                    fC2= 1.875;

                if (fC2<= -1.875)
                    fC2= -1.875;

                if (fC2>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fC2 = -fC2;
                }
                dwC2    = ((unsigned long)(fC2*16+1))>>1;

                if (dwC2>=0xf)
                {
                    dwC2 = 0xf|(dwS<<4);
                }
                else
                {
                    dwC2 = (dwC2&0xf)|(dwS<<4);
                }

                if (fB3>= 3.875)
                    fB3= 3.875;

                if (fB3<= -3.875)
                    fB3= -3.875;

                if (fB3>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fB3 = -fB3;
                }
                dwB3    = ((unsigned long)(fB3*16+1))>>1;

                if (dwB3>=0x1f)
                {
                    dwB3 = 0x1f|(dwS<<5);
                }
                else
                {
                    dwB3 = (dwB3&0x1f)|(dwS<<5);
                }

                if (fC3>= 3.875)
                    fC3= 3.875;

                if (fC3<= -3.875)
                    fC3= -3.875;

                if (fC3>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fC3 = -fC3;
                }

                dwC3    = ((unsigned long)(fC3*16+1))>>1;
                if (dwC3 >= 0x1f)
                {
                    dwC3 = 0x1f |(dwS<<5);
                }
                else
                {
                    dwC3 = (dwC3&0x1f)|(dwS<<5);
                }

                dwColor1 = (dwA<<24)|(dwB1<<16)|(dwC1<<8)|dwD_Int;
                dwColor2 = (dwD_Dec<<29|dwB2<<24)|(dwC2<<16)|(dwB3<<8)|(dwC3);

                VIDOutD(ColorSpaceReg_1, dwColor1);
                VIDOutD(ColorSpaceReg_2, dwColor2);
                VIDOutD(V3_ColorSpaceReg_1, dwColor1);
                VIDOutD(V3_ColorSpaceReg_2, dwColor2);

                DBG_DD(("00000284 %08lx\n",dwColor1));
                DBG_DD(("00000288 %08lx\n",dwColor2));
                DBG_DD(("000002C4 %08lx\n",dwColor1));
                DBG_DD(("000002C8 %08lx\n",dwColor2));

                pVidData->ColorSpaceValue1 = dwColor1;
                pVidData->ColorSpaceValue2 = dwColor2;
                break;
            case VIA_DEVICE_VT3314:
                fA  = (float)(1.1875*fContrast);
                fB1 = (float)(-1.625*fContrast*fSaturation*sin(fHue*fPI));
                fC1 = (float)(1.625*fContrast*fSaturation*cos(fHue*fPI));
                fD  = (float)(1.1875*(fBrightness-16));
                fB2 = (float)((0.875*sin(fHue*fPI)-0.375*cos(fHue*fPI))*fContrast*fSaturation);
                fC2 = (float)(-(0.875*cos(fHue*fPI)+0.375*sin(fHue*fPI))*fContrast*fSaturation);
                fB3 = (float)(2.0*fContrast*fSaturation*cos(fHue*fPI));
                fC3 = (float)(2.0*fContrast*fSaturation*sin(fHue*fPI));

                if (fA <= 0)
                fA = 0;

                if (fA >= 1.9375)
                    fA = 1.9375;

                dwA     = ((unsigned long)(fA*32+1))>>1;
                if (dwA >= 0x1f)
                {
                    dwA = 0x1f;
                }
                else
                {
                    dwA &=0x1f;
                }

                if (fB1 >= 2.125)
                   fB1 = 2.125;

                if (fB1 <= -2.125)
                    fB1 = -2.125;

                if (fB1>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fB1 = -fB1;
                }

                dwB1    = ((unsigned long)(fB1*16+1))>>1;
                if (dwB1>=0x1f)
                {
                    dwB1 = 0x1f|(dwS<<5);
                }
                else
                {
                    dwB1 = (dwB1&0x1f)|(dwS<<5);
                }

                if (fC1<= -2.125)
                    fC1= -2.125;
                if (fC1>= 2.125)
                    fC1= 2.125;

                if (fC1>=0)
                {
                            dwS = 0;
                        }
                        else
                        {
                            dwS = 1;
                    fC1 = -fC1;
                }

                dwC1    = ((unsigned long)(fC1*16+1))>>1;
                if (dwB1>=0x1f)
                {
                    dwB1 = 0x1f|(dwS<<5);
                }
                else
                {
                    dwB1 = (dwB1&0x1f)|(dwS<<5);
                }

                if (fD>=0)
                {
                    intD=(int)fD;
                    if (intD>127)
                        intD = 127;
                    dwD_Int = ((unsigned long)intD)&0xff;
                    dwD = ((unsigned long)(fD*16+1))>>1;
                    dwD_Dec= dwD&0x7;
                }
                else
                {
                    intD=(int)fD;
                    if (intD< -128)
                    intD = -128;
                    intD = intD+256;
                    dwD_Int = ((unsigned long)intD)&0xff;
                    fD = -fD;
                    dwD = ((unsigned long)(fD*16+1))>>1;
                    dwD_Dec= dwD&0x7;
                }

                if (fB2>= 1.875)
                    fB2= 1.875;

                if (fB2<= -1.875)
                   fB2= -1.875;

                if (fB2>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fB2 = -fB2;
                }

                dwB2    = ((unsigned long)(fB2*16+1))>>1;

                if (dwB2>=0xf)
                {
                    dwB2 = 0xf|(dwS<<4);
                }
                else
                {
                    dwB2 = (dwB2&0xf)|(dwS<<4);
                }

                if (fC2>= 1.875)
                    fC2= 1.875;

                if (fC2<= -1.875)
                    fC2= -1.875;

                if (fC2>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fC2 = -fC2;
                }
                dwC2    = ((unsigned long)(fC2*16+1))>>1;

                if (dwC2>=0xf)
                {
                    dwC2 = 0xf|(dwS<<4);
                }
                else
                {
                    dwC2 = (dwC2&0xf)|(dwS<<4);
                }

                if (fB3>= 3.875)
                    fB3= 3.875;

                if (fB3<= -3.875)
                    fB3= -3.875;

                if (fB3>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fB3 = -fB3;
                }
                dwB3    = ((unsigned long)(fB3*16+1))>>1;

                if (dwB3>=0x1f)
                {
                    dwB3 = 0x1f|(dwS<<5);
                }
                else
                {
                    dwB3 = (dwB3&0x1f)|(dwS<<5);
                }

                if (fC3>= 3.875)
                    fC3= 3.875;

                if (fC3<= -3.875)
                    fC3= -3.875;

                if (fC3>=0)
                {
                    dwS = 0;
                }
                else
                {
                    dwS = 1;
                    fC3 = -fC3;
                }

                dwC3    = ((unsigned long)(fC3*16+1))>>1;
                if (dwC3 >= 0x1f)
                {
                    dwC3 = 0x1f |(dwS<<5);
                }
                else
                {
                    dwC3 = (dwC3&0x1f)|(dwS<<5);
                }

                dwColor1 = (dwA<<24)|(dwB1<<16)|(dwC1<<8)|dwD_Int;
                dwColor2 = (dwD_Dec<<29|dwB2<<24)|(dwC2<<16)|(dwB3<<8)|(dwC3);

                VIDOutD(V3_ColorSpaceReg_1, dwColor1);
                VIDOutD(V3_ColorSpaceReg_2, dwColor2);
                DBG_DD(("000002C4 %08lx\n",dwColor1));
                DBG_DD(("000002C8 %08lx\n",dwColor2));

                pVidData->ColorSpaceValue1 = dwColor1;
                pVidData->ColorSpaceValue2 = dwColor2;
                break;
            default:
                DBG_DD((" Unknow Device ID \n"));
                break;
        }/*switch*/
    }/*if else*/
}

void vidEnableVideoVirtualQueue(VIAPtr pVia, unsigned long dwVideoFlag, unsigned long dwVideoVQ_Offset,unsigned long dwVQ_Size)
{
    unsigned long   dwLen, dwstL, dwendL, dwst_endH;
    unsigned long   dwSetting;

    DBG_DD(("%s\n",__FUNCTION__));

    /* Set I/O address to "FE" 0x00fe0000; */
    VIDOutD( GE_TRANS_SET, 0x00fe0000);
    /*DBG_DD(("%08x %08x\n",GE_TRANS_SET,0x00fe0000));*/


    /* Set Video VQ start address Lower 3 bytes [23:0]. Reg:0x60 */
    dwstL  = HVCMDQstL_Header |(dwVideoVQ_Offset & 0x00FFFFFF) ;
    /* Set Video VQ end address Lower 3 bytes [23:0]. Reg:0x61 */
    dwendL = HVCMDQendL_Header|((dwVideoVQ_Offset + dwVQ_Size - 8 ) & 0x00FFFFFF) ;
    /* Set Video VQ start and end addresses Highest byte [31:24]. Reg:0x62 */
    dwst_endH = HVCMDQstendH_Header | (dwVideoVQ_Offset & 0xFF000000)>>24|
                (((dwVideoVQ_Offset + dwVQ_Size - 8) & 0xFF000000) >>16) ;

    /* Set Video VQ size. Reg:0x63 */
    dwLen = HVCMDQLen_Header | ((unsigned long) (dwVQ_Size>>3) & 0x00FFFFFF) ;
    /* Set Video VQ enable setting. Reg:0x64 */
    if (dwVideoFlag&VIDEO_AGP_INUSE)
    {
        /* Temperarily disable VQ buffer. */
        dwSetting = HVCMDQSetting_Header|0x001010C4; /* AGP */
        /* dwSetting = HVCMDQSetting_Header|0x001010C4|HW_ENABLE_VIDEO_VQ;  */
        /* dwSetting = HVCMDQSetting_Header|0x001010C0|HW_ENABLE_VIDEO_VQ;  */
    }
    else
    {
        dwSetting = HVCMDQSetting_Header|0x001010C0|HW_ENABLE_VIDEO_VQ; /* PCI */
    }

    VIDOutD( GE_Hpara0, dwendL);   /* Reg:0x61 */
    DBG_DD(("%08x %08lx\n",GE_Hpara0,dwendL));
    VIDOutD( GE_Hpara0, dwst_endH);/* Reg:0x62 */
    DBG_DD(("%08x %08lx\n",GE_Hpara0,dwst_endH));
    VIDOutD( GE_Hpara0, dwstL );   /* Reg:0x60 */
    DBG_DD(("%08x %08lx\n",GE_Hpara0,dwstL));
    VIDOutD( GE_Hpara0, dwLen);    /* Reg:0x63 */
    DBG_DD(("%08x %08lx\n",GE_Hpara0,dwLen));

    /* 0x43c,hardware bug */
    VIDOutD( GE_TRANS_SET, 0x00fe0000);
    DBG_DD(("%08x %08x\n",GE_TRANS_SET,0x00fe0000));
    /* 0x64 */
    VIDOutD( GE_Hpara0, dwSetting);
    DBG_DD(("%08x %08lx\n",GE_Hpara0,dwSetting));
}

void vidDisableVideoVirtualQueue(VIAPtr pVia)
{
    unsigned long   dwSetting=0;

    DBG_DD(("%s\n",__FUNCTION__));
    dwSetting = HVCMDQSetting_Header|0x00001000;

    /* 0x43c */
    VIDOutD( GE_TRANS_SET, 0x00fe0000);
    /* 0x64 */
    VIDOutD( GE_Hpara0, dwSetting);

}

