/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __VIDENGFOPS__
#define __VIDENGFOPS__ 1

#include "via_video.h"
#include "via_swov.h"

/* Data structure for setting HQV zoom control */
typedef struct _ZOOMPARAM
{
    unsigned long  dwCtlHQVflag;
    unsigned long  dwSrcWidth; 
    unsigned long  dwSrcHeight;
    unsigned long  dwDstWidth;
    unsigned long  dwDstHeight;
}ZOOMPARAM,*PZOOMPARAM;


__inline void vidWaitSUBFlip(unsigned long EngIndex,unsigned char* vbase);
__inline void vidWaitVideoCommandFire(unsigned long EngIndex,unsigned char* vbase);
__inline void vidWaitHQVFIFOEmpty(unsigned long EngIndex, unsigned char* vbase);
__inline void vidWaitHQVDone(unsigned long EngIndex, unsigned char* vbase);
__inline void vidWaitHQVFinish(unsigned long EngIndex, unsigned char* vbase);
__inline void vidWait3DIdle(unsigned char* vbase);
__inline void vidWaitVirtualQueueEmpty(unsigned char* vbase);

unsigned long vidCalcMiniFactor(unsigned long dwSrc,unsigned long dwDst);
unsigned long vidSetZoomParam(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,PZOOMPARAM pZoomParam);

unsigned long vidSetHQVEngineDstAddr(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetHQVEngineOffset(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetHQVEngineSrcFetch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetHQVEngineDstPitch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

unsigned long vidSetVideoEngineCtrl(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineStartAddr(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineFetch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineSrcPitch(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineDstStart(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineDstWidthandHeight(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineColorKey(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vidSetVideoEngineChromaKey(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

void vidEnableVideoVirtualQueue(VIAPtr pVia, unsigned long dwVideoFlag,unsigned long dwVideoVQ_Offset,unsigned long dwVQ_Size);
void vidDisableVideoVirtualQueue(VIAPtr pVia);
void vidSetVideoColor(VIAPtr pVia, long Hue, long Saturation, long Brightness, long Contrast);
#endif  /*__VIDENGFOPS__*/

