/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

/* I N C L U D E S ------------------------------------------------------------ */
#include "debug.h"
#include "via_eng_fops_cle.h"
#include "via_eng_regs.h"
#include "via_rotate.h"
#include "via_eng_reg_fops.h"


/* FUNCTION */
unsigned long vidSetHQVEngineSrcAddr_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
   
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;
    unsigned long yaddr[XV_SURFACE_NUM];
    unsigned long craddr[XV_SURFACE_NUM];
    unsigned long cbaddr[XV_SURFACE_NUM];
    unsigned long addrMask = 0;
    unsigned long frameIndex = 0;
    int i = 0;

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        
        for(i=0;i<XV_SURFACE_NUM;i++){
            yaddr[i] = pPriv->pXvSurface->offset[i];
            craddr[i] = yaddr[i] + ((pPriv->pXvSurface->pitch)*(pPriv->pXvSurface->height));
            cbaddr[i] = craddr[i] + ((pPriv->pXvSurface->pitch>>1) * (pPriv->pXvSurface->height>>1));
        }  
        
        addrMask = 0xFFFFFFF8 ;  
        frameIndex = pPriv->pXvSurface->cur_idx;
        switch(pPriv->pXvSurface->format){
            case FOURCC_YUY2:
                lphwinfo->dwHQVSrcAddr[0] = yaddr[frameIndex] & addrMask;
                break;
            case FOURCC_NV12:
            case FOURCC_YV12:
            default:
                lphwinfo->dwHQVSrcAddr[0] = yaddr[frameIndex] & addrMask;
                lphwinfo->dwHQVSrcAddr[1] = cbaddr[frameIndex] & addrMask;
                lphwinfo->dwHQVSrcAddr[2] = craddr[frameIndex] & addrMask;
                break;
        }

    } 
   
    return TRUE;  
}


/* 
 * Set HQV filter control
 */
unsigned long vidSetHQVAdvanceControl_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;   
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        lphwinfo->reg_3e4.dwHQVFilterCtl = HQV_H_FILTER_DEFAULT|HQV_V_FILTER_DEFAULT;       
    }  
    
    return TRUE;
}


unsigned long vidSetHQVEngineCtrl_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;
    unsigned long hqvIndex = 0;
    DBG_DD(("%s\n",__FUNCTION__));

    if(pPriv->hqvEngUpdate == HQV_1){
        hqvIndex = REG_HQV1_INDEX;
    }
    
    if(((pPriv->vidEngUpdate == VIDEO_1) && (*pVideoFlag & VIDEO_1_HIDE)) ||
        ((pPriv->vidEngUpdate == VIDEO_3) && (*pVideoFlag & VIDEO_3_HIDE))){
        
        lphwinfo->dwHQVSPCtl_Pitch=vfCMHQVR(SUBP_CONTROL_STRIDE|hqvIndex, pScrn, pPriv)&(~SUBP_HQV_ENABLE);
        lphwinfo->dwHQVCtl[pPriv->curIGA-1] = vfCMHQVR(HQV_CONTROL|hqvIndex, pScrn, pPriv) & (~HQV_ENABLE);
        
    }else if(((pPriv->vidEngUpdate == VIDEO_1) && (*pVideoFlag & VIDEO_1_SHOW)) ||
        ((pPriv->vidEngUpdate == VIDEO_3) && (*pVideoFlag & VIDEO_3_SHOW))){

        if (pPriv->pXvSurface->formatType & DDPF_FOURCC){
            switch (pPriv->pXvSurface->format){
                case FOURCC_YUY2:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_YUV422|HQV_ENABLE|HQV_TRIPLE_BUFF;
                    break;

                case FOURCC_YV12:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_YUV420|HQV_ENABLE;
                    break;
                 
                default :
                    DBG_DD((" Invalid FOURCC format :(%lx)!\n",pPriv->pXvSurface->format));
                    break;
            }
        }else if (pPriv->pXvSurface->formatType & DDPF_RGB){
            switch (pPriv->pXvSurface->format){
                case RGB15:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_ENABLE|HQV_RGB15;
                    break;
                case RGB16:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_ENABLE|HQV_RGB16;
                    break;
         
                case RGB32:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_RGB32|HQV_ENABLE;
                    break;
                default :
                    DBG_DD((" Invalid RGB format\n"));
                    break;

            }
        }
    
        lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_TRIPLE_BUFF;            

        lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_ENABLE;

    }
    
    return TRUE;   
}


/* 
 * This register only exist after 353
 */
unsigned long vidSetHQVEngineSrcDataOffset_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    return TRUE;
}


unsigned long vidSetHQVEngineSrcPitch_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    unsigned long *pVideoFlag = &pPriv->videoFlag;   
    LPVIDEOHWINFO lphwinfo      = &pPriv->vidHWinfo;    
    
    unsigned long dwSrcPitch = pPriv->pXvSurface->pitch;
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
                    
        lphwinfo->dwHQVSrcPitch = dwSrcPitch;

        if(viaGfxInfo->chipId != VIA_DEVICE_VT3314)     
        {
            lphwinfo->dwHQVSrcPitch |= VAL_HQV_FLIP_FIFODEPTH_1_BACK_DROP_CME;
            lphwinfo->dwHQVSrcPitch |= VAL_HQV_SW_FLIP_QUEUE_ENABLE_CME;
        }else{
            /* 3314 also needs to set UV frame buffer unit
             * It is in bit19-27, but it needs 8 bytes alignment, so just << 16
             */            
            lphwinfo->dwHQVSrcPitch |= (dwSrcPitch >> 1) << 16;
        }
    }
    return TRUE;
}


unsigned long vidSetHQVEngineZoomFactor_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;    
    
    ZOOMPARAM hqvZoomInput;
    unsigned long dwTmp;
    unsigned long dwMiniFactor=0;

    DBG_DD(("%s\n",__FUNCTION__));
    
    lphwinfo->dwHQVScaleCtlH = 0;
    lphwinfo->dwHQVScaleCtlV = 0;
    lphwinfo->dwHQVMiniZoomCtl = 0;
    lphwinfo->reg_3e4.dwHQVFilterCtl = 0 ;
    pPriv->hqvEngFlag = 0;
    pOverlayRecord->dwHQVzoomflagV = pOverlayRecord->dwHQVzoomflagH = 0; 
    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW))
    {         
        /*setup hqvCalcZoom input data field*/
        vidSetZoomParam(pScrn, pPriv, &hqvZoomInput);

        if (hqvZoomInput.dwSrcWidth > hqvZoomInput.dwDstWidth){     
            pPriv->hqvEngFlag |= VAL_HQV_H_DOWN_SCALE_CME;
            pOverlayRecord->dwHQVzoomflagH |= VAL_HQV_H_DOWN_SCALE_CME;
        }

        if (hqvZoomInput.dwSrcHeight > hqvZoomInput.dwDstHeight){
            pPriv->hqvEngFlag |= VAL_HQV_V_DOWN_SCALE_CME;            
            pOverlayRecord->dwHQVzoomflagV |= VAL_HQV_V_DOWN_SCALE_CME;
        }       
                      
        /*calculate x zoom factor*/        
        /* 314 not have scalling-up engines, So set HQVFilter first and calculate zoom-out factor*/
         dwMiniFactor = vidCalcMiniFactor(hqvZoomInput.dwSrcWidth,hqvZoomInput.dwDstWidth);
         switch (dwMiniFactor){
            case 0:
                lphwinfo->reg_3e4.dwHQVFilterCtl |= HQV_H_FILTER_DEFAULT;
                break;
            case 1:
            case 2:
            case 3:
                lphwinfo->reg_3e4.dwHQVFilterCtl |= HQV_H_TAP4_121;
                break;
             default:
                lphwinfo->reg_3e4.dwHQVFilterCtl |= HQV_H_TAP8_12221;
                break;
         }  
         /*zoom-out*/         
         if (hqvZoomInput.dwSrcWidth > hqvZoomInput.dwDstWidth){   
             dwTmp = hqvZoomInput.dwDstWidth*0x0800/hqvZoomInput.dwSrcWidth;
             /*rouding patch*/
             dwTmp = dwTmp + ((dwTmp *0x400 & 0x3ff)?1:0);        
             dwTmp = (dwTmp & 0x7FF)| HQV_H_MINIFY_ENABLE;
             lphwinfo->dwHQVMiniZoomCtl = dwTmp;     
        }         
        DBG_DD(("HQV miniCtl:%lx\n",lphwinfo->dwHQVMiniZoomCtl));
        DBG_DD(("HQV FilterCtl:%lx\n",lphwinfo->reg_3e4.dwHQVFilterCtl));
         
        /*calculate y zoom factor*/
        dwMiniFactor = vidCalcMiniFactor(hqvZoomInput.dwSrcHeight,hqvZoomInput.dwDstHeight);
        switch (dwMiniFactor){
            case 0:
            case 1:
            case 2:
                lphwinfo->reg_3e4.dwHQVFilterCtl |= HQV_V_TAP4_121;
                 break;
            default:
                lphwinfo->reg_3e4.dwHQVFilterCtl |= HQV_V_TAP8_12221;
                 break;
        }
        /*zoom-out*/
        if (hqvZoomInput.dwSrcHeight > hqvZoomInput.dwDstHeight){    
            dwTmp = hqvZoomInput.dwDstHeight*0x800/hqvZoomInput.dwSrcHeight;
            dwTmp=dwTmp+((dwTmp * 0x400 &0x3ff)?1:0);
            lphwinfo->dwHQVMiniZoomCtl |= ((dwTmp& 0x7FF)<<16)|HQV_V_MINIFY_ENABLE;
        }             
        DBG_DD(("HQV miniCtl:%lx\n",lphwinfo->dwHQVMiniZoomCtl));
        DBG_DD(("HQV FilterCtl:%lx\n",lphwinfo->reg_3e4.dwHQVFilterCtl)); 
    }
    return TRUE;
}

void updYInterpolationFlag_CLE
(
    PVIDDATA pVidData, 
    unsigned long dwSrcWidth, 
    unsigned long dwVideoFlag, 
    unsigned long *pdwMiniCtl, 
    unsigned long *pdwCompose, viaPortPrivPtr pPriv
)
{
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    if (dwSrcWidth >= 800){
            if(viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.clone||
                !viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.duoview)
        {
            /* Fixed Me!! */
            /* It's better to set "Interpolation FIFO clock select (Vid298[25:24])" to */
            /* "V1 HDTV" or "V3 HDTV", however, we don't know why we can't write the */
            /* two bits correctly in DuoView mode, so disable vertical interpolation */
            /* temporarily. We will find the root cause later. */
            *pdwMiniCtl &= ~(V1_Y_INTERPOLY | V3_Y_INTERPOLY);
        }
        else
        {
            *pdwMiniCtl |= (V1_Y_INTERPOLY | V1_YCBCR_INTERPOLY);

            if (pPriv->vidEngUpdate == VIDEO_1)
            {
                *pdwCompose |= VAL_V1HDTV_CME;
            }
            else
            {
                *pdwCompose |= VAL_V3HDTV_CME;
            }
        }               
        *pdwMiniCtl &= ~(V3_Y_INTERPOLY | V3_YCBCR_INTERPOLY);
        *pdwCompose &= ~(VAL_V1HDTV_CME|VAL_V3HDTV_CME);
    }
    else
    {
        *pdwMiniCtl |= (V1_Y_INTERPOLY | V1_YCBCR_INTERPOLY);
    }
}

unsigned long vidSetVideoEngineZoomFactor_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 

    LPVIDEOHWINFO lphwinfo  = &pPriv->vidHWinfo;
    unsigned long dwChromaKeyOn = pOverlayRecord->dwChromaKeyOn;  
    ViaXvRectRec curSrcRect = pOverlayRecord->dwOverlaySrcRect;
    ViaXvRectRec curDstRect = pOverlayRecord->dwOverlayDestRect;
    ViaXvRectRec expandDstRect = pOverlayRecord->dwExpandDestRect;     
    ViaXvRectRec scalingDstRect = pOverlayRecord->dwScalingDestRect;
    unsigned long dstWidth = 0,dstHeight = 0;
    unsigned long srcWidth = 0,srcHeight = 0;
    unsigned long expandWidth = 0,expandHeight=0;
    unsigned long scalingWidth=0,scalingHeight = 0;
    unsigned long tmp = 0;

    lphwinfo->dwzoomCtl = 0;
    lphwinfo->dwminiCtl = 0;

    DBG_DD(("%s\n",__FUNCTION__));
    
    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){

        srcWidth = curSrcRect.right - curSrcRect.left;
        srcHeight = curSrcRect.bottom - curSrcRect.top;
        dstWidth = curDstRect.right - curDstRect.left;
        dstHeight = curDstRect.bottom - curDstRect.top;
        expandWidth = expandDstRect.right -expandDstRect.left;
        expandHeight = expandDstRect.bottom - expandDstRect.top;
        scalingWidth = scalingDstRect.right - scalingDstRect.left;
        scalingHeight = scalingDstRect.bottom - scalingDstRect.top;

        
        /*only consider LCD expansion*/
        if((*pVideoFlag & VIDEO_BYPASS_HOR_EXPAND)
            &&(*pVideoFlag & VIDEO_ON_IGA2))
        {
            /*if dest width<src width.We use HQV to scale down.But the if LCD
             *expansion is enabled, we still need video engine to maginfy video to the proper size.
             *That's what we call IGA scaling bypass 
             */
            DBG_DD(("bypass horizontal"));
           if((viaGfxInfo->igaInfo[pPriv->curIGA -1].igaRRStatus.rotate_90)||
               (viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.rotate_270))
           {
                /*rotate 90/270 means the actual expansion direction we need to deal with is 
                 *the other direction.
                 */
                    if ((srcHeight >=dstHeight) && (dstHeight < expandHeight)) 
                       srcHeight = dstHeight;
                    dstHeight =  expandHeight;
            }
            else{
                if ((srcWidth >= dstWidth)&&(dstWidth < expandWidth)) 
                    srcWidth = dstWidth;
                dstWidth = expandWidth; 
            }
        }

    if((*pVideoFlag & VIDEO_BYPASS_VER_EXPAND)
        &&(*pVideoFlag & VIDEO_ON_IGA2))
        {
            DBG_DD(("bypass vertical\n"));
            if((viaGfxInfo->igaInfo[pPriv->curIGA -1].igaRRStatus.rotate_90)||
               (viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.rotate_270))
            {
                /*rotate 90/270 means the actual expansion direction we need to deal with is 
                 *the other direction.
                 */
                    if ((srcWidth >= dstWidth)&&(dstWidth < expandWidth)) 
                        srcWidth = dstWidth;
                    dstWidth = expandWidth; 
            }
            else{
                 if ((srcHeight >=dstHeight) && (dstHeight < expandHeight)) 
                    srcHeight = dstHeight;
                dstHeight= expandHeight;
                
                }
        }    
        /*LCD 3D scaling case
         * zoom-in/out process for image on LCD is first processed HQV and 
         * then video, in the last by 3D.
         */
       if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igagfx3DScaling_info.gfx3DScalingEnable)
        {
            /*the src value is the smallet one in src,scaling and dst rectange*/
            tmp = (scalingWidth <= dstWidth)?scalingWidth:dstWidth;
            srcWidth = (srcWidth<tmp)?srcWidth:tmp;
            tmp = (scalingHeight <=dstHeight)?scalingHeight:dstHeight;
            srcHeight =(srcHeight < tmp)?srcHeight:tmp;

            dstWidth = scalingWidth;
            dstHeight = scalingHeight;
        }
        
           switch(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit & VIA_ROTATE_DEGREE_ALL)
          {
            case VIA_ROTATE_DEGREE_90:
            case VIA_ROTATE_DEGREE_270:
                /* If rotated, in 3D dst buffer, all data are rotated, rotRec.Height 
                 * are actually width in rSrc, rotRec.width are actually height in rSrc.*/
                tmp = srcWidth;
                srcWidth =  srcHeight;
                srcHeight = tmp;

                tmp = dstWidth;
                dstWidth = dstHeight;
                dstHeight = tmp;                
                break;
            default:
                break;
        }

        DBG_DD(("final:Src(W:%ld,H:%ld),Dst(W:%ld,H:%ld)\n",srcWidth,srcHeight,dstWidth,dstHeight));
                  
        if (srcWidth == dstWidth){
            lphwinfo->dwzoomCtl &=~ V1_X_ZOOM_ENABLE;
        }else if(srcWidth < dstWidth){
            lphwinfo->dwzoomCtl &= 0xffff;                    
            lphwinfo->dwzoomCtl |= (((srcWidth*0x800/dstWidth)
                                    &0x7ff)<<16)|V1_X_ZOOM_ENABLE;
        }
        
        if(srcHeight == dstHeight){
            lphwinfo->dwzoomCtl &= ~V1_Y_ZOOM_ENABLE;
        }else if(srcHeight < dstHeight){
            lphwinfo->dwzoomCtl &= 0xffff0000;                    
            lphwinfo->dwzoomCtl |= ((srcHeight*0x400/dstHeight)
                                    &0x3ff)|V1_Y_ZOOM_ENABLE; 
        }
        
        /*we have none-rotation video interpolation source line <800 limit, pay attention to that*/
        if (*pVideoFlag & VIDEO_HQV_INUSE) 

        updYInterpolationFlag_CLE(pVidData, srcWidth, \
                    *pVideoFlag, &lphwinfo->dwminiCtl, &lphwinfo->dwCompose, pPriv);

        if (dwChromaKeyOn){             
            /* Temporarily solve the H/W Interpolation error when using Chroma Key */
            lphwinfo->dwminiCtl = lphwinfo->dwminiCtl & 0xFFFFFFF8;
        }
    }
    return TRUE;
}


unsigned long vidSetVideoEngineFIFO_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){ 
        if (pPriv->vidEngUpdate == VIDEO_1){
            if(lpVideoHWDifference->dwNeedV1Prefetch){
                lphwinfo->dwV1FIFO = V1_FIFO_DEPTH122 | V1_FIFO_RRETHRESHOLD113| V1_FIFO_THRESHOLD113;
            }else{
                lphwinfo->dwV1FIFO = V1_FIFO_DEPTH64 | V1_FIFO_PRETHRESHOLD61 | V1_FIFO_THRESHOLD61;
            }
                    
            if(viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.clone||
                !viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.duoview)
            {
                lphwinfo->dwV3FIFO = (VIDInD(ALPHA_V3_FIFO_CONTROL)&ALPHA_FIFO_MASK)|
                                                V3_FIFO_DEPTH64 | V3_FIFO_THRESHOLD61;
        
                lphwinfo->dwV3PreFIFO = (V3_FIFO_THRESHOLD61>>8) |
                        (VIDInD(ALPHA_V3_PREFIFO_CONTROL)& (~V3_FIFO_MASK));       

            }
        }else{
            lphwinfo->dwV3FIFO = (VIDInD(ALPHA_V3_FIFO_CONTROL)&ALPHA_FIFO_MASK)|
                                         V3_FIFO_DEPTH64 | V3_FIFO_THRESHOLD61;
            lphwinfo->dwV3PreFIFO = (V3_FIFO_THRESHOLD61>>8) |
                            (VIDInD(ALPHA_V3_PREFIFO_CONTROL)& (~V3_FIFO_MASK_3324));
        }
    }
    return TRUE;
}


unsigned long vidSetVideoEngineComposeMode_CLE(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    LPVIDEOHWINFO lphwinfo  = &pPriv->vidHWinfo;   
    unsigned long dwColorKeyOn  = pOverlayRecord->dwColorKeyOn;
    unsigned long *IGA_Video_Map = pVidData->IGA_Video_Map;

    DBG_DD(("%s\n",__FUNCTION__));

    if((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        if (dwColorKeyOn){

            if(IGA_Video_Map[IGA1] & VIDEO_3){
                lphwinfo->dwCompose |= PRIMARY_DISPLAY_COLOR_KEY_ENABLE;
            }else if(IGA_Video_Map[IGA2] & VIDEO_3){
                lphwinfo->dwCompose |= SECOND_DISPLAY_COLOR_KEY_ENABLE;
            }     
        }

        /* VT3314 only have V3, but the enable bit also is defined as bit30 */
        if (pPriv->vidEngUpdate == VIDEO_1){
            lphwinfo->dwCompose |= V_COMMAND_LOAD_VBI;
        }else{
            lphwinfo->dwCompose |= V_COMMAND_LOAD_VBI/*V3_COMMAND_LOAD_VBI*/;
        }

        /* we use Video's vertical
         * upscaling instead of LCD's when the IGA2 expand operation is in use.
         */ 
        if (*pVideoFlag & VIDEO_BYPASS_VER_EXPAND){
            lphwinfo->dwCompose |= VAL_DISABLE_LCD_VERTICAL_SCALING_CME;
        }else{
            lphwinfo->dwCompose &= ~VAL_DISABLE_LCD_VERTICAL_SCALING_CME;
        }
            
        if (*pVideoFlag & VIDEO_BYPASS_HOR_EXPAND){            
            lphwinfo->dwCompose |= VAL_DISABLE_LCD_HORIZONTAL_SCALING_CME;
        }else{
            lphwinfo->dwCompose &= ~VAL_DISABLE_LCD_HORIZONTAL_SCALING_CME;
        }

         /* In DuoView, COMPOSE_V3_V1 should be set to fix 3324 hw bug */
         if(viaGfxInfo->xrandrEnabled && !viaGfxInfo->screenAttr.clone||
            !viaGfxInfo->xrandrEnabled && !viaGfxInfo->screenAttr.duoview){
             if (pPriv->vidEngUpdate == VIDEO_1){  
                 /* Fix hardware bug, or it will show image on IGA1
                  * if move V3 onto IGA2 in SAMM
                  */                               
                 if(*pVideoFlag & VIDEO_ON_IGA2){
                     lphwinfo->dwCompose |= COMPOSE_V3_V1;
                 }else {
                     lphwinfo->dwCompose &= ~COMPOSE_V3_V1;
                 }               
            }else if(pPriv->vidEngUpdate == VIDEO_3){
                /* Fix hardware issue, or it will show image on IGA1
                 * if move V1 onto IGA2 in SAMM 
                 */   
                if(*pVideoFlag & VIDEO_ON_IGA2){
                     lphwinfo->dwCompose &= ~COMPOSE_V3_V1;
                }else{
                     lphwinfo->dwCompose |= COMPOSE_V3_V1;
                }                    
            }
        }else{
             if (pPriv->vidEngUpdate == VIDEO_1){                  
                 if(*pVideoFlag & VIDEO_ON_IGA2){
                      lphwinfo->dwCompose |= COMPOSE_V3_V1;
                 }else {
                     lphwinfo->dwCompose &= ~COMPOSE_V3_V1;
                 }
             }
         }   
    }    
    return TRUE;
}

