/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

/* I N C L U D E S ------------------------------------------------------------ */
#include "via_eng_fops_cme.h"
#include "via_eng_regs.h"
#include "debug.h"
#include "via_rotate.h"
#include "via_eng_reg_fops.h"


/* FUNCTION */
unsigned long vidSetHQVEngineSrcAddr_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
   
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;
    unsigned long yaddr[XV_SURFACE_NUM];
    unsigned long craddr[XV_SURFACE_NUM];
    unsigned long cbaddr[XV_SURFACE_NUM];
    unsigned long addrMask = 0;    
    unsigned long frameIndex = 0;
    int i = 0;

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        
        for(i=0;i<XV_SURFACE_NUM;i++){
            yaddr[i] = pPriv->pXvSurface->offset[i];
            craddr[i] = yaddr[i] + ((pPriv->pXvSurface->pitch)*(pPriv->pXvSurface->height));
            cbaddr[i] = craddr[i] + ((pPriv->pXvSurface->pitch>>1) * (pPriv->pXvSurface->height>>1));
        } 

        addrMask = 0xFFFFFFF0 ;
        frameIndex = pPriv->pXvSurface->cur_idx;
        switch(pPriv->pXvSurface->format){
            case FOURCC_YUY2:
                lphwinfo->dwHQVSrcAddr[0] = yaddr[frameIndex] & addrMask;
                break;
            case FOURCC_NV12:
            case FOURCC_YV12:
            default:
                lphwinfo->dwHQVSrcAddr[0] = yaddr[frameIndex] & addrMask;
                lphwinfo->dwHQVSrcAddr[1] = craddr[frameIndex] & addrMask;
                break;
        }

    } 
   
    return TRUE;  
}


/* 
 * Set HQVtile mode&color space conversioin, deinterlace control
 */
unsigned long vidSetHQVAdvanceControl_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;   
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        
        unsigned long hqvCtrlFlag = pVidData->VidCtl.dwCtlHQVflag;    

        LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
        unsigned long srcWidth = pOverlayRecord->dwOriSrcWidth;
        unsigned long srcHeight= pOverlayRecord->dwOriSrcHeight;  
        
        DBG_DD(("%s\n",__FUNCTION__));
        
        hqvCtrlFlag &= ~CTL_HQV_TILEMODE_ENABLE_CME;
        
        lphwinfo->dwHQVTCGDCtl =0;
        lphwinfo->dwHQVExtCtrl = 0;
        memset(lphwinfo->dwHQVCAC, 0, 8*sizeof(unsigned long));
        lphwinfo->dwSRFStride &= 0x7ff;
        lphwinfo->reg_3e4.dwHQVDeinterlaceCtl = 0;
            
        /* Set HQV Color Space Conversion mode, only YUV source need it*/
        if (pPriv->pXvSurface->formatType & DDPF_FOURCC){
           if(pPriv->pHqvSurface[pPriv->curIGA-1]->formatType & DDPF_RGB)
                hqvCtrlFlag |=CTL_HQV_CSC_ENABLE_CME|CTL_HQV_CSC_RGB16_CME;
            
            if (hqvCtrlFlag & CTL_HQV_CSC_ENABLE_CME){
                if (hqvCtrlFlag&CTL_HQV_CSC_RGB32_CME){
                    lphwinfo->dwHQVTCGDCtl |= VAL_HQV_CSC_ENABLE_CME|VAL_HQV_CSC_RGB32_CME;
                }else{
                    lphwinfo->dwHQVTCGDCtl |= VAL_HQV_CSC_ENABLE_CME|VAL_HQV_CSC_RGB16_CME;            
                }
                if (pVia->ChipId == VIA_DEVICE_VT3409){
                    lphwinfo->dwHQVCAC[0] = (VAL_HQV_CSC_D1<<17)|VAL_HQV_CSC_C1;
                    lphwinfo->dwHQVCAC[1] = (VAL_HQV_CSC_D2<<17)|VAL_HQV_CSC_C2;
                    lphwinfo->dwHQVCAC[2] = (VAL_HQV_CSC_D3<<17)|VAL_HQV_CSC_C3;
                    lphwinfo->dwHQVCAC[3] =  VAL_HQV_CSC_B1;
                    lphwinfo->dwHQVCAC[4] =  VAL_HQV_CSC_B3;
                    lphwinfo->dwHQVCAC[5] =  VAL_HQV_CSC_A1;
                    lphwinfo->dwHQVCAC[6] =  VAL_HQV_CSC_A2;
                    lphwinfo->dwHQVCAC[7] =  VAL_HQV_CSC_A3;
                    lphwinfo->dwSRFStride |= VAL_HQV_CSC_B2<<15;
                    lphwinfo->dwHQVExtCtrl  = VAL_HQV_COLOR_FORMAT_DEFAULT|VAL_HQV_COLOR_FORMAT_ADJUST_ENABLE;
                }
           }
        }
        
        /* Setting HQV Tile mode */
        if (hqvCtrlFlag & CTL_HQV_TILEMODE_ENABLE_CME){
            if (hqvCtrlFlag&CTL_HQV_TILEMODE_512BITS_CME){
                lphwinfo->dwHQVTCGDCtl |= VAL_HQV_TILEMODE_512BITS_CME;
            }else{
                lphwinfo->dwHQVTCGDCtl |= VAL_HQV_TILEMODE_256BITS_CME;            
            }
        }
        
        if (hqvCtrlFlag & CTL_HQV_DEINTERLACE_ENABLE_CME){
            lphwinfo->dwHQVTCGDCtl |= ((srcWidth * srcHeight)>>10) & MASK_HQV_IMAGE_SIZE_CME;
        }

        
        if (hqvCtrlFlag & CTL_HQV_TVFIELDSYNC_ENABLE){
            lphwinfo->dwHQVTCGDCtl |= VAL_HQV_TVFIELDSYNC_ENABLE;
        
            if (hqvCtrlFlag & CTL_HQV_TV_ON_ADD_BUS){
                lphwinfo->dwHQVTCGDCtl |= VAL_HQV_TV_ON_ADD_BUS;            
            }else{
                lphwinfo->dwHQVTCGDCtl &= ~VAL_HQV_TV_ON_ADD_BUS;                      
            }
        }else{
            lphwinfo->dwHQVTCGDCtl &= ~(VAL_HQV_TVFIELDSYNC_ENABLE|VAL_HQV_TV_ON_ADD_BUS);
        }
        
           if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit)
        {
            lphwinfo->dwHQVTCGDCtl |= VAL_HQV_CSC_ENABLE_CME|VAL_HQV_CSC_RGB16_CME; 
        }         
    }  
    return TRUE;
}


unsigned long vidSetHQVEngineCtrl_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;
    unsigned long hqvIndex = 0;
    DBG_DD(("%s\n",__FUNCTION__));

    if(pPriv->hqvEngUpdate == HQV_1){
        hqvIndex = REG_HQV1_INDEX;
    }
    /*Clear the value to 0*/
    lphwinfo->dwHQVCtl[pPriv->curIGA-1] = 0;
    
    if(((pPriv->vidEngUpdate == VIDEO_1) && (*pVideoFlag & VIDEO_1_HIDE)) ||
        ((pPriv->vidEngUpdate == VIDEO_3) && (*pVideoFlag & VIDEO_3_HIDE))){
        
        lphwinfo->dwHQVSPCtl_Pitch=vfCMHQVR(SUBP_CONTROL_STRIDE|hqvIndex, pScrn, pPriv)&(~SUBP_HQV_ENABLE);
        lphwinfo->dwHQVCtl[pPriv->curIGA-1] = vfCMHQVR(HQV_CONTROL|hqvIndex, pScrn, pPriv) & (~HQV_ENABLE);
        
    }else if(((pPriv->vidEngUpdate == VIDEO_1) && (*pVideoFlag & VIDEO_1_SHOW)) ||
        ((pPriv->vidEngUpdate == VIDEO_3) && (*pVideoFlag & VIDEO_3_SHOW))){

        if (pPriv->pXvSurface->formatType & DDPF_FOURCC){
            switch (pPriv->pXvSurface->format){
                case FOURCC_YUY2:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_YUV422|HQV_ENABLE|HQV_TRIPLE_BUFF;
                    break;

                case FOURCC_NV12:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_YUV420|HQV_ENABLE|HQV_TRIPLE_BUFF;
                    break;
                 
                default :
                    DBG_DD((" Invalid FOURCC format :(%lx)!\n",(pPriv->pXvSurface->format)));
                    break;
            }
        }else if (pPriv->pXvSurface->formatType & DDPF_RGB){
            switch (pPriv->pXvSurface->format){
                case RGB15:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_ENABLE|HQV_TRIPLE_BUFF|HQV_RGB15;
                    break;
                
                case RGB16:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_ENABLE|HQV_TRIPLE_BUFF|HQV_RGB16;
                    break;
                
                case RGB32:
                    lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_SRC_SW|HQV_RGB32|HQV_ENABLE|HQV_TRIPLE_BUFF;
                    break;
                
                default :
                    DBG_DD((" Invalid RGB format \n"));
                    break;
            }
        }

        lphwinfo->dwHQVCtl[pPriv->curIGA-1] |= HQV_ENABLE;

    }
    
    return TRUE;   
}


unsigned long vidSetHQVEngineSrcDataOffset_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;   

    unsigned long srcWidth = pOverlayRecord->dwOriSrcWidth;
    unsigned long srcHeight = pOverlayRecord->dwOriSrcHeight;
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        if(viaGfxInfo->chipId== VIA_DEVICE_VT3353){
            /* Get HQV Source Data Offset: */
            
            /* HQV380: Should be set to 0. */
            lphwinfo->dwHQVSrcDataOffsetStart = 0;
        
            /* HQV388[26:16]: Horizontal offset of end point for video location in destination picture. */
            /* HQV388[10:0]: Vertical offset of end point for video location in destination picture. */    
            /* Zero base, so need to minus 1 for end position. */
            lphwinfo->dwHQVSrcDataOffsetEnd = (srcWidth-1) << 16 | (srcHeight-1);
            
        }else if(viaGfxInfo->chipId == VIA_DEVICE_VT3409){
        
            /*Set HQV 3 data offset register*/
            lphwinfo->dwHQVSrcDataOffsetStart = 0;
            lphwinfo->dwHQVSrcDataOffsetEnd = ((srcWidth-1)<<16) | (srcHeight-1);
            lphwinfo->dwHQVBgOffset = ((srcWidth-1)<<16) | (srcHeight-1);
            
            /*For VT3409,we also need to set destination data offset.Fortunately,
            the values are equal to source data offset*/
            lphwinfo->dwHQVDstDataOffsetStart = lphwinfo->dwHQVSrcDataOffsetStart;
            lphwinfo->dwHQVDstDataOffsetEnd = lphwinfo->dwHQVSrcDataOffsetEnd;
        }
    }

    return TRUE;
}


unsigned long vidSetHQVEngineSrcPitch_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
   viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    unsigned long *pVideoFlag = &pPriv->videoFlag;   
    LPVIDEOHWINFO lphwinfo      = &pPriv->vidHWinfo;    
    
    unsigned long dwSrcPitch = pPriv->pXvSurface->pitch;
    
    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
                    
        lphwinfo->dwHQVSrcPitch = dwSrcPitch;

        if(viaGfxInfo->chipId != VIA_DEVICE_VT3314)
        {     
            
            lphwinfo->dwHQVSrcPitch |= VAL_HQV_FLIP_FIFODEPTH_1_BACK_DROP_CME;
            lphwinfo->dwHQVSrcPitch |= VAL_HQV_SW_FLIP_QUEUE_ENABLE_CME;
        }else{
            /* 3314 also needs to set UV frame buffer unit
             * It is in bit19-27, but it needs 8 bytes alignment, so just << 16
             */            
            lphwinfo->dwHQVSrcPitch |= (dwSrcPitch >> 1) << 16;
        }
    }
   
    return TRUE;
}


unsigned long vidSetHQVEngineZoomFactor_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
   viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;    
    
    ZOOMPARAM hqvZoomInput;    
    unsigned long dwTmp;    
    unsigned long miniFactor = 0;

    DBG_DD(("%s\n",__FUNCTION__));
    
    lphwinfo->dwHQVScaleCtlH = 0;
    lphwinfo->dwHQVScaleCtlV = 0;
    lphwinfo->dwHQVMiniZoomCtl = 0;
    lphwinfo->reg_3e4.dwHQVFilterCtl = 0 ;
    pPriv->hqvEngFlag = 0;
    pOverlayRecord->dwHQVzoomflagV = pOverlayRecord->dwHQVzoomflagH = 0; 
    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){         
        /*setup hqvCalcZoom input data field*/
        vidSetZoomParam(pScrn, pPriv, &hqvZoomInput);

        if (hqvZoomInput.dwSrcWidth > hqvZoomInput.dwDstWidth){     
            pPriv->hqvEngFlag |= VAL_HQV_H_DOWN_SCALE_CME;
            pOverlayRecord->dwHQVzoomflagH |= VAL_HQV_H_DOWN_SCALE_CME;
        }

        if (hqvZoomInput.dwSrcHeight > hqvZoomInput.dwDstHeight){
            pPriv->hqvEngFlag |= VAL_HQV_V_DOWN_SCALE_CME;            
            pOverlayRecord->dwHQVzoomflagV |= VAL_HQV_V_DOWN_SCALE_CME;
        }       

        if(viaGfxInfo->chipId ==VIA_DEVICE_VT3353||
            viaGfxInfo->chipId ==VIA_DEVICE_VT3409){  
            /*HQV engines does not involve in any magnification*/
            if (hqvZoomInput.dwSrcWidth > hqvZoomInput.dwDstWidth){
                if(hqvZoomInput.dwSrcWidth > (hqvZoomInput.dwDstWidth<<3)){
                    /*<1/8*/
                    /*FIXME!*/
                    if(hqvZoomInput.dwDstWidth <= 32){
                        hqvZoomInput.dwDstWidth = 33;
                    }
                    if(hqvZoomInput.dwSrcWidth > (hqvZoomInput.dwDstWidth<<5)){
                        dwTmp = 1*0x1000/31;
                    }else{
                        dwTmp=(hqvZoomInput.dwDstWidth *0x1000)/hqvZoomInput.dwSrcWidth;
                    }
                    
                    lphwinfo->dwHQVScaleCtlH = HQV_H_SCALE_DOWN_UNDER_EIGHTH;
                }else if(hqvZoomInput.dwSrcWidth == (hqvZoomInput.dwDstWidth<<3)){
                    /*1/8*/
                    dwTmp=((hqvZoomInput.dwDstWidth-1) *0x1000)/hqvZoomInput.dwSrcWidth;
                    lphwinfo->dwHQVScaleCtlH = HQV_H_SCALE_DOWN_UNDER_EIGHTH;
                }else if(hqvZoomInput.dwSrcWidth > (hqvZoomInput.dwDstWidth<<2)){
                    /*1/4 -1/8 zoom-out*/
                    dwTmp=(hqvZoomInput.dwSrcWidth *0x1000)/hqvZoomInput.dwDstWidth;
                    lphwinfo->dwHQVScaleCtlH = HQV_H_SCALE_DOWN_FOURTH_TO_EIGHTH;
                }else{
                    /*1-1/4 zoom-out*/
                    /*setting :src/(destination+0.5)*/
                    dwTmp=(hqvZoomInput.dwSrcWidth *0x2000)/((hqvZoomInput.dwDstWidth<<1)+1);
                    lphwinfo->dwHQVScaleCtlH = HQV_H_SCALE_DOWN_FOURTH_TO_1;
                }
                
                /*rounding to nearest interger*/
                dwTmp+=(((dwTmp * 0x1000)&0xfff) > 1)?1:0;
                lphwinfo->dwHQVScaleCtlH |= (dwTmp & 0x7FFF) | HQV_H_SCALE_ENABLE;
            }
            
            /*calculate y zoom factor*/         
            if  (hqvZoomInput.dwSrcHeight > hqvZoomInput.dwDstHeight){               
                /*setting :src/(destination+0.5)*/
                dwTmp = hqvZoomInput.dwSrcHeight * 0x2000/((hqvZoomInput.dwDstHeight<<1)+1);
                dwTmp += (((dwTmp * 0x1000)&0xfff) > 1)?1:0;                
                if((dwTmp&0x1ffff)==0){
                    dwTmp = 0x1ffff;
                }
                                
                lphwinfo->dwHQVScaleCtlV = (dwTmp & 0x1ffff)|HQV_V_SCALE_ENABLE|HQV_V_SCALE_DOWN;
            }            
        }else{
                   
            /*HQV engines does not involve in any magnification*/
            if (hqvZoomInput.dwSrcWidth>hqvZoomInput.dwDstWidth)
            {   /*zoom-out*/
                dwTmp = hqvZoomInput.dwDstWidth*0x0800/hqvZoomInput.dwSrcWidth;
                /*rouding patch*/
                dwTmp = dwTmp + ((dwTmp *0x400 & 0x3ff)?1:0);        
                dwTmp = (dwTmp & 0x7FF)| HQV_H_MINIFY_ENABLE|VAL_HQV_H_DOWN_SCALE_CME;
                lphwinfo->dwHQVMiniZoomCtl = dwTmp;
            }
            DBG_DD(("HQV miniCtl:%lx\n",lphwinfo->dwHQVMiniZoomCtl));
             
            /*calculate y zoom factor*/
            if (hqvZoomInput.dwSrcHeight > hqvZoomInput.dwDstHeight)
            {   /*zoom-out*/
                dwTmp = hqvZoomInput.dwDstHeight*0x800/hqvZoomInput.dwSrcHeight;
                dwTmp = dwTmp+((dwTmp * 0x400 &0x3ff)?1:0);
                lphwinfo->dwHQVMiniZoomCtl |= ((dwTmp& 0x7FF)<<16)|HQV_V_MINIFY_ENABLE\
                                                |VAL_HQV_V_DOWN_SCALE_CME;
            }
            DBG_DD(("HQV miniCtl:%lx\n",lphwinfo->dwHQVMiniZoomCtl));
        }  
    }     
    return TRUE;
}

void updYInterpolationFlag_CME
(
    PVIDDATA pVidData, 
    unsigned long dwSrcWidth, 
    unsigned long dwVideoFlag, 
    unsigned long *pdwMiniCtl, 
    unsigned long *pdwCompose, viaPortPrivPtr pPriv
)
{
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;

    if (dwSrcWidth >= 800)
    {
        if ((viaGfxInfo->chipId== VIA_DEVICE_VT3327) ||
            (viaGfxInfo->chipId== VIA_DEVICE_VT3336) ||
            (viaGfxInfo->chipId== VIA_DEVICE_VT3364))
        {
            /* Disable vertical interpolation because the size of line buffer (limited to 800) is */
            /* too small to do interpolation. */
            *pdwMiniCtl &= ~(V1_Y_INTERPOLY);
        }
        else
        {
            if(viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.clone||
                !viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.duoview)
            {
                /* Fixed Me!! */
                /* It's better to set "Interpolation FIFO clock select (Vid298[25:24])" to */
                /* "V1 HDTV" or "V3 HDTV", however, we don't know why we can't write the */
                /* two bits correctly in DuoView mode, so disable vertical interpolation */
                /* temporarily. We will find the root cause later. */
                *pdwMiniCtl &= ~(V1_Y_INTERPOLY | V3_Y_INTERPOLY);
            }
            else
            {
                *pdwMiniCtl |= (V1_Y_INTERPOLY | V1_YCBCR_INTERPOLY);

                if (pPriv->vidEngUpdate == VIDEO_1)
                {
                    *pdwCompose |= VAL_V1HDTV_CME;
                }
                else
                {
                    *pdwCompose |= VAL_V3HDTV_CME;
                }
            }
        }
    }
    else
    {
        *pdwMiniCtl |= (V1_Y_INTERPOLY | V1_YCBCR_INTERPOLY);
    }

}


unsigned long vidSetVideoEngineZoomFactor_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  

    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 

    LPVIDEOHWINFO lphwinfo  = &pPriv->vidHWinfo;
    unsigned long dwChromaKeyOn = pOverlayRecord->dwChromaKeyOn;  
    ViaXvRectRec curSrcRect = pOverlayRecord->dwOverlaySrcRect;
    ViaXvRectRec curDstRect = pOverlayRecord->dwOverlayDestRect;
    ViaXvRectRec expandDstRect = pOverlayRecord->dwExpandDestRect;     
    ViaXvRectRec scalingDstRect = pOverlayRecord->dwScalingDestRect;
    unsigned long dstWidth = 0,dstHeight = 0;
    unsigned long srcWidth = 0,srcHeight = 0;
    unsigned long expandWidth = 0,expandHeight=0;
    unsigned long scalingWidth=0,scalingHeight = 0;
    unsigned long tmp = 0;
    lphwinfo->dwzoomCtl = 0;
    lphwinfo->dwminiCtl = 0;

    DBG_DD(("%s\n",__FUNCTION__));
    
    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){

        srcWidth = curSrcRect.right - curSrcRect.left;
        srcHeight = curSrcRect.bottom - curSrcRect.top;
        dstWidth = curDstRect.right - curDstRect.left;
        dstHeight = curDstRect.bottom - curDstRect.top;
        expandWidth = expandDstRect.right -expandDstRect.left;
        expandHeight = expandDstRect.bottom - expandDstRect.top;
        scalingWidth = scalingDstRect.right - scalingDstRect.left;
        scalingHeight = scalingDstRect.bottom - scalingDstRect.top;
        DBG_DD(("Src(W:%ld,H:%ld),Dst(W:%ld,H:%ld),Expand(%ld,%ld),Scaling(%ld,%ld)\n",
                    srcWidth,srcHeight,dstWidth,dstHeight,expandWidth,expandHeight,
                    scalingWidth,scalingHeight));
        
        /*LCD expansion*/
        if((*pVideoFlag & VIDEO_BYPASS_HOR_EXPAND)
            &&(*pVideoFlag & VIDEO_ON_IGA2)
            &&pVidData->IGA_Video_Map[pPriv->curIGA]==VIDEO_1)       
        { 
            /*if dest width<src width.We use HQV to scale down.But the if LCD
             *expansion is enabled, we still need video engine to maginfy video to the proper size.
             *That's what we call IGA scaling bypass 
             */
            DBG_DD(("bypass horizontal"));
            if((viaGfxInfo->igaInfo[pPriv->curIGA -1].igaRRStatus.rotate_90)||
               (viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.rotate_270))
            {
                /*rotate 90/270 means the actual expansion direction we need to deal with is 
                 *the other direction.
                 */
                    if ((srcHeight >=dstHeight) && (dstHeight < expandHeight)) 
                       srcHeight = dstHeight;
                    dstHeight =  expandHeight;
            }
            else{
                if ((srcWidth >= dstWidth)&&(dstWidth < expandWidth)) 
                    srcWidth = dstWidth;
                dstWidth = expandWidth; 
            }
        }

        if((*pVideoFlag & VIDEO_BYPASS_VER_EXPAND)
            &&(*pVideoFlag & VIDEO_ON_IGA2)
            &&pVidData->IGA_Video_Map[pPriv->curIGA]==VIDEO_1)
        {       
            DBG_DD(("bypass vertical\n"));
            if((viaGfxInfo->igaInfo[pPriv->curIGA -1].igaRRStatus.rotate_90)||
               (viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.rotate_270))
            {
                /*rotate 90/270 means the actual expansion direction we need to deal with is 
                 *the other direction.
                 */
                    if ((srcWidth >= dstWidth)&&(dstWidth < expandWidth)) 
                        srcWidth = dstWidth;
                    dstWidth = expandWidth; 
            }
            else{
                 if ((srcHeight >=dstHeight) && (dstHeight < expandHeight)) 
                    srcHeight = dstHeight;
                dstHeight= expandHeight;
                
                }
        }    
        /*LCD 3D scaling case
         * zoom-in/out process for image on LCD is first processed HQV and 
         * then video, in the last by 3D.
         */
       if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igagfx3DScaling_info.gfx3DScalingEnable)
        {
            /*the src value is the smallet one in src,scaling and dst rectange*/
            tmp = (scalingWidth <= dstWidth)?scalingWidth:dstWidth;
            srcWidth = (srcWidth<tmp)?srcWidth:tmp;
            tmp = (scalingHeight <=dstHeight)?scalingHeight:dstHeight;
            srcHeight =(srcHeight < tmp)?srcHeight:tmp;

            dstWidth = scalingWidth;
            dstHeight = scalingHeight;
        }

           switch(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit & VIA_ROTATE_DEGREE_ALL)
           {
            case VIA_ROTATE_DEGREE_90:
            case VIA_ROTATE_DEGREE_270:
                /* If rotated, in 3D dst buffer, all data are rotated, rotRec.Height 
                 * are actually width in rSrc, rotRec.width are actually height in rSrc.*/
                tmp = srcWidth;
                srcWidth =  srcHeight;
                srcHeight = tmp;

                tmp = dstWidth;
                dstWidth = dstHeight;
                dstHeight = tmp;          
                
                break;
            default:
                break;
        }

        DBG_DD(("final:Src(W:%ld,H:%ld),Dst(W:%ld,H:%ld)\n",srcWidth,srcHeight,dstWidth,dstHeight));
                  
        if (srcWidth == dstWidth){
            lphwinfo->dwzoomCtl &=~ V1_X_ZOOM_ENABLE;
        }else if(srcWidth < dstWidth){
            lphwinfo->dwzoomCtl &= 0xffff;                    
            lphwinfo->dwzoomCtl |= (((srcWidth*0x800/dstWidth)
                                    &0x7ff)<<16)|V1_X_ZOOM_ENABLE;
        }
        
        if(srcHeight == dstHeight){
            lphwinfo->dwzoomCtl &= ~V1_Y_ZOOM_ENABLE;
        }else if(srcHeight < dstHeight){
            lphwinfo->dwzoomCtl &= 0xffff0000;                    
            lphwinfo->dwzoomCtl |= ((srcHeight*0x400/dstHeight)
                                    &0x3ff)|V1_Y_ZOOM_ENABLE; 
        }
        DBG_DD(("dwZoomCtL:%08lx\n",lphwinfo->dwzoomCtl)); 
        /*we have none-rotation video interpolation source line <800 limit, pay attention to that*/
        if (*pVideoFlag & VIDEO_HQV_INUSE) 


        updYInterpolationFlag_CME(pVidData, srcWidth, \
                              *pVideoFlag, &lphwinfo->dwminiCtl, &lphwinfo->dwCompose, pPriv);
        
        if (dwChromaKeyOn){             
            /* Temporarily solve the H/W Interpolation error when using Chroma Key */
            lphwinfo->dwminiCtl = lphwinfo->dwminiCtl & 0xFFFFFFF8;
        }
    }

    return TRUE;
}


unsigned long vidSetVideoEngineFIFO_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    LPVIDEOHWINFO lphwinfo = &pPriv->vidHWinfo;

    DBG_DD(("%s\n",__FUNCTION__));

    if ((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){ 
        if (pPriv->vidEngUpdate == VIDEO_1){
            if(lpVideoHWDifference->dwNeedV1Prefetch){
                lphwinfo->dwV1FIFO = V1_FIFO_DEPTH122 | V1_FIFO_RRETHRESHOLD113| V1_FIFO_THRESHOLD113;
            }else{
                lphwinfo->dwV1FIFO = V1_FIFO_DEPTH64 | V1_FIFO_PRETHRESHOLD61 | V1_FIFO_THRESHOLD61;
            }
            if(viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.clone||
                !viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.duoview)
            {
                lphwinfo->dwV3FIFO = (VIDInD(ALPHA_V3_FIFO_CONTROL)&ALPHA_FIFO_MASK)|
                                                V3_FIFO_DEPTH64 | V3_FIFO_THRESHOLD61;
        
                /*3324 has different fifomask */
                if ((viaGfxInfo->chipId== VIA_DEVICE_VT3324)\
                    ||(viaGfxInfo->chipId== VIA_DEVICE_VT3353))
                {
                    lphwinfo->dwV3PreFIFO = (V3_FIFO_THRESHOLD61>>8) |
                        (VIDInD(ALPHA_V3_PREFIFO_CONTROL)& (~V3_FIFO_MASK_3324)); 
                }else{
                    lphwinfo->dwV3PreFIFO = (V3_FIFO_THRESHOLD61>>8) |
                            (VIDInD(ALPHA_V3_PREFIFO_CONTROL)& (~V3_FIFO_MASK));       
                }    
            }
        }else{
            lphwinfo->dwV3FIFO = (VIDInD(ALPHA_V3_FIFO_CONTROL)&ALPHA_FIFO_MASK)|
                                         V3_FIFO_DEPTH64 | V3_FIFO_THRESHOLD61;
            /*3324 has different fifomask*/
                if ((viaGfxInfo->chipId== VIA_DEVICE_VT3324)\
                    ||(viaGfxInfo->chipId== VIA_DEVICE_VT3353))
            {
                lphwinfo->dwV3PreFIFO = (V3_FIFO_THRESHOLD61>>8) |
                                (VIDInD(ALPHA_V3_PREFIFO_CONTROL)& (~V3_FIFO_MASK));
            }else{   /*3314 has the same v3 fifo mask with 3324.So we don't use a extra if condition*/
                lphwinfo->dwV3PreFIFO = (V3_FIFO_THRESHOLD61>>8) |
                                (VIDInD(ALPHA_V3_PREFIFO_CONTROL)& (~V3_FIFO_MASK_3324));
            }
        }
    }

    return TRUE;
}


unsigned long vidSetVideoEngineComposeMode_CME(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    LPOVERLAYRECORD pOverlayRecord = &pPriv->ovlInfo[pPriv->curIGA-1]; 
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    LPVIDEOHWINFO lphwinfo  = &pPriv->vidHWinfo;   
    unsigned long dwColorKeyOn  = pOverlayRecord->dwColorKeyOn;
    unsigned long *IGA_Video_Map = pVidData->IGA_Video_Map;
     unsigned long tmp;
    DBG_DD(("%s\n",__FUNCTION__));

    if((*pVideoFlag & VIDEO_1_SHOW) || (*pVideoFlag & VIDEO_3_SHOW)){
        if (dwColorKeyOn){
            /*The setting is different between only 1 video engine and 2 video engine*/
            switch(viaGfxInfo->chipId)
            {
                /* v1 exist*/ 
                case VIA_DEVICE_VT3336:
                case VIA_DEVICE_VT3327:
                case VIA_DEVICE_VT3364:                   
                    if(IGA_Video_Map[IGA1] & VIDEO_1){
                        lphwinfo->dwCompose |= PRIMARY_DISPLAY_COLOR_KEY_ENABLE;
                    }else if(IGA_Video_Map[IGA2] & VIDEO_1){
                        lphwinfo->dwCompose |= SECOND_DISPLAY_COLOR_KEY_ENABLE;
                    }
                    break;                
                default: 
                    /*It is set in 0x220/264/280 register*/
                    break;    
            }
        }
        /* we use Video's vertical
         * upscaling instead of LCD's when the IGA2 expand operation is in use.
         */ 
        if (*pVideoFlag & VIDEO_BYPASS_VER_EXPAND){
            lphwinfo->dwCompose |= VAL_DISABLE_LCD_VERTICAL_SCALING_CME;
        }else{
            lphwinfo->dwCompose &= ~VAL_DISABLE_LCD_VERTICAL_SCALING_CME;
        }
            
        if (*pVideoFlag & VIDEO_BYPASS_HOR_EXPAND){            
            lphwinfo->dwCompose |= VAL_DISABLE_LCD_HORIZONTAL_SCALING_CME;
        }else{
            lphwinfo->dwCompose &= ~VAL_DISABLE_LCD_HORIZONTAL_SCALING_CME;
        }
        /* In DuoView, COMPOSE_V3_V1 should be set to fix 3324 hw bug */
        if(viaGfxInfo->xrandrEnabled && !viaGfxInfo->screenAttr.clone||
            !viaGfxInfo->xrandrEnabled && !viaGfxInfo->screenAttr.duoview)
        {
            if (pPriv->vidEngUpdate == VIDEO_1){ 	
                /* Fix hardware bug, or it will show image on IGA1
                 * if move V3 onto IGA2 in SAMM
                 */  
                if(*pVideoFlag & VIDEO_ON_IGA2)
                {
                    lphwinfo->dwCompose |= COMPOSE_V3_V1;
                }else {
                    if (*pVideoFlag& VIDEO_SHOW_TOP){
                        lphwinfo->dwCompose &= ~COMPOSE_V3_V1;
                    }
                    else {
                        tmp=(VIDInD(V_COMPOSE_MODE)&COMPOSE_V3_V1)>>20;
                        lphwinfo->dwCompose &=~COMPOSE_V3_V1;
                        lphwinfo->dwCompose |= tmp<<20;
                        }
                }
           }else if(pPriv->vidEngUpdate == VIDEO_3){
               /* Fix hardware issue, or it will show image on IGA1
                * if move V1 onto IGA2 in SAMM 
                */   
                if(*pVideoFlag & VIDEO_ON_IGA2)
               {
                    lphwinfo->dwCompose &= ~COMPOSE_V3_V1;
               }else{
                    if (*pVideoFlag& VIDEO_SHOW_TOP){
                        lphwinfo->dwCompose |= COMPOSE_V3_V1;
                    }
                    else {
                       tmp=(VIDInD(V_COMPOSE_MODE)&COMPOSE_V3_V1)>>20;
                        lphwinfo->dwCompose &=~COMPOSE_V3_V1;
                        lphwinfo->dwCompose |= tmp<<20;
                        }
               }                    
           }
       }else{
            if (pPriv->vidEngUpdate == VIDEO_1){ 	                
                if(*pVideoFlag & VIDEO_ON_IGA2)
                {
                     lphwinfo->dwCompose |= COMPOSE_V3_V1;
                }else {
                    lphwinfo->dwCompose &= ~COMPOSE_V3_V1;
                }
            }
        }
    }    
    return TRUE;
}


