/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*  Macros for Video MMIO  */
#define VIDInB(port)            *((volatile unsigned char *)(pVia->MapBase + (port)))
#define VIDInW(port)            *((volatile unsigned short *)(pVia->MapBase + (port)))
#define VIDInD(port)            *((volatile CARD32 *)(pVia->MapBase + (port)))
#define VIDOutB(port, data)     *((volatile unsigned char *)(pVia->MapBase + (port))) = (data)
#define VIDOutW(port, data)     *((volatile unsigned short *)(pVia->MapBase + (port))) = (data)
#define VIDOutD(port, data)     *((volatile CARD32 *)(pVia->MapBase + (port))) = (data)

void vfCMHQVW(unsigned long dwIndex,unsigned long dwData, ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
unsigned long vfCMHQVR(unsigned long dwIndex,ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
void vfHM(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, unsigned long dwFunSel);
void vfCM(unsigned long dwIndex,unsigned long dwData,ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

unsigned long vidWriteHQVandVideoCmd(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
