/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_H
#define _VIA_H


/* Video status flag (VideoFlag) */
#define VIDEO_HIDE              0x01000000  /*Video off*/
#define VIDEO_SHOW              0x80000000  /*Video on*/
#define VIDEO_SHOW_TOP          0x08000000
#define VIDEO_KEY_DEST          0x00000400  /*Video KeyDst command*/
#define VIDEO_VQ_INUSE          0x40000000  /* Video is used with Virtural Queue */
#define VIDEO_AGP_INUSE         0x20000000  /* Video is used with AGP command */
#define VIDEO_ACTIVE            0x10000000  /*Video active*/
#define VIDEO_HQV_INUSE         0x04000000  /*Video is used with HQV*/
#define VIDEO_1_INUSE           0x00004000  /*Video 1 is used */
#define VIDEO_3_INUSE           0x00008000  /*Video 3 is used */
#define HQV_0_INUSE             0x00001000  /*HQV  0 is used*/
#define HQV_1_INUSE             0x00002000  /*HQV  1 is used*/
#define VIDEO_YUV_BYPASS        0x00800000  /* definition for YVU bypass */
#define VIDEO_ON                0x00100000
#define VIDEO_1_ON_SND          0x00400000  /* added for duo view*/
#define VIDEO_ON_SND_IGA        0x00000001
#define VIDEO_ON_SND_SCRN       0x00000002
#define VIDEO_BYPASS_HOR_EXPAND 0x00000010
#define VIDEO_BYPASS_VER_EXPAND 0x00000020
#define VIDEO_ON_IGA2           0x00000040
#define VIDEO_INIT_FINISH       0x00000100
#define VIDEO_1_SHOW            0x00010000
#define VIDEO_3_SHOW            0x00020000
#define VIDEO_1_HIDE            0x00040000
#define VIDEO_3_HIDE            0x00080000

#define SCRN_ATTR_SINGLE_VIEW       0x00000001
#define SCRN_ATTR_DUO_CLONE_VIEW    0x00000002
#define SCRN_ATTR_SAMM_EXTEND_VIEW  0x00000004 

/*****************************************************************************
 *     CLE HQV Control status(lpOverlayRecord->dwHQVon)                      *
 *                                                                           *
 *****************************************************************************/
#define HQV_USE_ENABLE          0x00000001  /* HQV is in USE */
#define HQV_USE_DISABLE         0x00000000  /* HQV is not USE */

/*for lpVIAGraphicInfo->duoview*/
#define DUOVIEW_ENABLED         0x0001
#define DUOVIEW_V3_ON_IGA2      0x0002
#define DUOVIEW_VIDEOOPTION     0x8000
#define DUOVIEW_VIDEOONTV       0x4000
#define DUOVIEW_VIDEOONDVI      0x2000
#define DUOVIEW_VIDEOONLCD      0x1000
#define DUOVIEW_VIDEOONCRT      0x0800


/*****************************************************************************
 *     H/W registers for 3D                                                  *
 *                                                                           *
 *****************************************************************************/
#define GE_TRANS_SET            0x43c   /* Transmission Setting */
#define GE_Hpara0               0x440   /* Transmission Space */

/*****************************************************************************
 *     H/W registers for NULL command                                                  *
 *                                                                           *
 *****************************************************************************/
 #define RegAddr_NULLCMD 0xCA4
 
/*****************************************************************************
 *     H/W registers for Video Engine                                        *
 *                                                                           *
 *****************************************************************************/
#define V_FLAGS                 0x200
#define V_FLIP_STATUS           0x204
#define V_ALPHA_WIN_START       0x208
#define V_Vertical_Count        0x208
#define V_ALPHA_WIN_END         0x20C
#define V_ALPHA_CONTROL         0x210
#define V_CRT_STARTADDR         0x214
#define V_CRT_STARTADDR_2       0x218
#define V_ALPHA_STRIDE          0x21C
#define V_COLOR_KEY             0x220
#define V_ALPHA_STARTADDR       0x224
#define V_CHROMAKEY_LOW         0x228
#define V_CHROMAKEY_HIGH        0x22C
#define V1_CONTROL              0x230
#define V12_QWORD_PER_LINE      0x234
#define V1_STARTADDR1           0x238
#define V1_STRIDE               0x23C
#define V1_WIN_START_X_Y        0x240
#define V1_WIN_END_X_Y          0x244
#define V1_STARTADDR2           0x248
#define V1_ZOOM_CONTROL         0x24C
#define V1_MINI_CONTROL         0x250
#define V1_STARTADDR0           0x254
#define V_FIFO_CONTROL          0x258
#define V1_STARTADDR3           0x25C
#define SND_COLOR_KEY           0x264
#define ALPHA_V3_PREFIFO_CONTROL   0x268
#define V1_DISPLAY_COUNT        0x26C
#define V_DISPLAY_TEMP          0x274  /* No use */
#define ALPHA_V3_FIFO_CONTROL   0x278
#define V3_DISPLAY_COUNT        0x27C
#define V3_COLOR_KEY            0x280
#define ColorSpaceReg_1         0x284
#define ColorSpaceReg_2         0x288
#define V1_STARTADDR0_U         0x28C
#define V1_OPAQUE_CONTROL       0x290  /* To be deleted */
#define V3_OPAQUE_CONTROL       0x294  /* To be deleted */
#define V_COMPOSE_MODE          0x298
#define V3_STARTADDR_2          0x29C
#define V3_CONTROL              0x2A0
#define V3_STARTADDR_0          0x2A4
#define V3_STARTADDR_1          0x2A8
#define V3_STRIDE               0x2AC
#define V3_WIN_START_X_Y        0x2B0
#define V3_WIN_END_X_Y          0x2B4
#define V3_ALPHA_FETCH_COUNT    0x2B8
#define V3_ZOOM_CONTROL         0x2BC
#define V3_MINI_CONTROL         0x2C0
#define V3_ColorSpaceReg_1      0x2C4
#define V3_ColorSpaceReg_2      0x2C8
#define V3_DISPLAY_TEMP         0x2CC  /* No use */
#define V1_STARTADDR1_U         0x2E4
#define V1_STARTADDR2_U         0x2E8
#define V1_STARTADDR3_U         0x2EC
#define V1_STARTADDR0_V         0x2F0
#define V1_STARTADDR1_V         0x2F4
#define V1_STARTADDR2_V         0x2F8
#define V1_STARTADDR3_V         0x2FC
/*CN400 and older Hardware Icon engine register*/
#define HI_POSSTART             0x208
#define HI_CENTEROFFSET         0x20C
#define HI_FBOFFSET             0x224
#define HI_CONTROL              0x260
#define HI_TRANSPARENT_COLOR    0x270
#define HI_INVTCOLOR            0x274
/* VT3324 primary Hardware Icon engine register */
#define PRIM_HI_POSEND          0x290
#define V327_HI_INVTCOLOR       0x2E4
#define PRIM_HI_FIFO            0x2E8
#define PRIM_HI_TRANSCOLOR      0x2EC
#define PRIM_HI_CTRL            0x2F0
#define PRIM_HI_FBOFFSET        0x2F4
#define PRIM_HI_POSSTART        0x2F8
#define PRIM_HI_CENTEROFFSET    0x2FC
#define PRIM_HI_INVTCOLOR       0x120C


/*****************************************************************************
 *     H/W registers for HQV Engine and subpicture                           *
 *                                                                           *
 *****************************************************************************/

/* new added registers for VT3409.For some registers have different meanings 
 * but the same address,we add postfix _409 to distinguish */
#define HQV_COLOR_ADJUSTMENT_PRE_CTRL1          0x360
#define HQV_COLOR_ADJUSTMENT_PRE_CTRL2          0x364
#define HQV_COLOR_ADJUSTMENT_PRE_CTRL3          0x368
#define HQV_COLOR_ADJUSTMENT_PRE_CTRL4          0x36C
#define HQV_SRC_DATA_OFFSET_CTRL1_409           0x370 
#define HQV_SRC_DATA_OFFSET_CTRL2_409           0x374  
#define HQV_SRC_DATA_OFFSET_CTRL3_409           0x378  
#define HQV_SRC_DATA_OFFSET_CTRL4_409           0x37C  
#define HQV_DST_DATA_OFFSET_CTRL1_409           0x380
#define HQV_DST_DATA_OFFSET_CTRL2_409           0x384  
#define HQV_DST_DATA_OFFSET_CTRL3_409           0x388  
#define HQV_DST_DATA_OFFSET_CTRL4_409           0x38C 
#define HQV_RESIDUE_PIXEL_FRAME_STARTADDR_409   0x3BC
#define HQV_BACKGROUND_DATA_OFFSET_409          0x3CC
#define HQV_SUBP_HSCALE_CTRL                    0x3E0
#define HQV_SUBP_VSCALE_CTRL                    0x3E8

/* Add new HQV Registers for VT3353 */
#define HQV_SRC_DATA_OFFSET_CONTROL1            0x380
#define HQV_SRC_DATA_OFFSET_CONTROL2            0x384
#define HQV_SRC_DATA_OFFSET_CONTROL3            0x388
#define HQV_SRC_DATA_OFFSET_CONTROL4            0x38C
#define HQV_HW_TUNING_PERFORMANCE               0x390
#define HQV_EXTENDED_CONTROL                    0x394
#define HQV_STATIC_RECORD_FB_STARTADDR          0x398
#define HQV_STATIC_RECORD_FB_STRIDE             0x39C
#define HQV_COLOR_ADJUSTMENT_CTRL1              0x3A0
#define HQV_COLOR_ADJUSTMENT_CTRL2              0x3A4
#define HQV_COLOR_ADJUSTMENT_CTRL3              0x3A8
#define HQV_COLOR_ADJUSTMENT_CTRL4              0x3AC
#define HQV_DEFAULT_VIDEO_COLOR                 0x3B8

#define HQV_H_SCALE_CONTROL     0x3B0
#define HQV_V_SCALE_CONTROL     0x3B4

/* SUBPICTURE */
#define SUBP_CONTROL_STRIDE     0x3C0
#define SUBP_STARTADDR          0x3C4
#define RAM_TABLE_CONTROL       0x3C8
#define RAM_TABLE_READ          0x3CC
#define DEBOLCKING_FACTOR       0x3BC

/* HQV Registers */
#define HQV_SRC_OFFSET          0x3CC
#define HQV_CONTROL             0x3D0
#define HQV_SRC_STARTADDR_Y     0x3D4
#define HQV_SRC_STARTADDR_U     0x3D8
#define HQV_SRC_STARTADDR_V     0x3DC
#define HQV_TILE_CSC_CONTROL    0x3DC
#define HQV_SRC_FETCH_LINE      0x3E0
#define HQV_FILTER_CONTROL      0x3E4
#define HQV_DEINTERLACE_CONTROL 0x3E4

#define HQV_MINI_CONTROL        0x3E8
#define HQV_DST_STARTADDR0      0x3EC
#define HQV_DST_STARTADDR1      0x3F0
#define HQV_DST_STRIDE          0x3F4
#define HQV_SRC_STRIDE          0x3F8
#define HQV_DST_STARTADDR2      0x3FC  /* HQV_DST_STARTADDR2_32045, HQV_DST_STARTADDR2_3123C0 */

/*****************************************************************************
 *     H/W registers detail information  for Video Engine and HQV Engine     *
 *                                                                           *
 *****************************************************************************/ 
/* #define V_FLAGS         0x200 */
#define INT_EN                      (1<<31) /* interrupt enable */
#define DVP1_SENSE_INT_EN           (1<<30) /* for hotplug interrupt on vt3353 */
#define DVP1_SENSE_INT_STS          (1<<27) /* for hotplug interrupt on vt3353 */
#define HQV0_ACTIVE_END_INT_EN      (1<<25) /* After CN400 project */
#define DMA1_TRANS_END_INT_EN       (1<<23)
#define DMA1_ENTRY_END_INT_EN       (1<<22)
#define DMA0_TRANS_END_INT_EN       (1<<21)
#define DMA0_ENTRY_END_INT_EN       (1<<20)
#define IGA1_VSYNC_INT_EN           (1<<19)
#define MPEG_MC_END_INT_EN          (1<<18)
#define IGA2_VSYNC_INT_EN           (1<<17)
#define DVO0_SENSE_INT_EN           (1<<16)
#define TMDS_SENSE_INT_EN           (1<<16)
#define IGA2_VSYNC_INT_STS          (1<<15) /* IGA2 Vsync interrupt status */
#define HQV1_ACTIVE_END_INT_EN      (1<<11) /* After CN400 project */
#define HQV1_ACTIVE_END_INT_STS     (1<<10) /* After CN400 project */
#define HQV0_ACTIVE_END_INT_STS     (1<<9)  /* After CN400 project */
#define DMA1_TRANS_END_INT_STS      (1<<7)
#define DMA1_ENTRY_END_INT_STS      (1<<6)
#define DMA0_TRANS_END_INT_STS      (1<<5)
#define DMA0_ENTRY_END_INT_STS      (1<<4)
#define IGA1_VSYNC_INT_STS          (1<<3)
#define MPEG_MC_END_INT_STS         (1<<2)
#define IGA1_VBLANK_STS             (1<<1)
#define TMDS_SENSE_INT_STS          1
 
 
/* #define V_FLIP_STATUS           0x204 */
#define V3_STARTADDR_UPDSTATUS          0x00000008


/* #define V_ALPHA_CONTROL         0x210 */
#define ALPHA_WIN_EXPIRENUMBER_4        0x00040000
#define ALPHA_WIN_CONSTANT_FACTOR_4     0x00004000
#define ALPHA_WIN_CONSTANT_FACTOR_12    0x0000c000
#define ALPHA_WIN_BLENDING_CONSTANT     0x00000000
#define ALPHA_WIN_BLENDING_ALPHA        0x00000001
#define ALPHA_WIN_BLENDING_GRAPHIC      0x00000002
#define ALPHA_WIN_PREFIFO_THRESHOLD_12  0x000c0000
#define ALPHA_WIN_FIFO_THRESHOLD_8      0x000c0000
#define ALPHA_WIN_FIFO_DEPTH_16         0x00100000

/* V_CHROMAKEY_LOW         0x228 */
#define V_CHROMAKEY_V3          0x80000000

/* V1/V3_CONTROL                   0x230,0x2a0 */
#define VAL_VIDEO_GAMMA_ENABLE_CME      0x20000000
#define VAL_VIDEO_SWAP_SW_CME           0x00000000
#define VAL_VIDEO_SWAP_HW_HQV_CME       0x02000000
#define VAL_VIDEO_SWAP_HW_CAPTURE0_CME  0x04000000
#define VAL_VIDEO_SWAP_HW_CAPTURE1_CME  0x06000000
#define VAL_VIDEO_TILE_MODE             0x08000000
#define VAL_VIDEO_EXPIRE_NUM_CME        0x00040000
#define VAL_VIDEO_EXPIRE_NUM_16_CME     0x00100000
#define VAL_VIDEO_EXPIRE_NUM_F_CME      0x000F0000
#define VAL_VIDEO_COLORSPACE_SIGN_CME   0x00000080
#define VAL_VIDEO_COLORSPACE_DISABLE_CME   0x00000100
#define VAL_VIDEO_FORMAT_YUV422_CME     0x00000000
#define VAL_VIDEO_FORMAT_RGB32_CME      0x00000004
#define VAL_VIDEO_FORMAT_RGB15_CME      0x00000008
#define VAL_VIDEO_FORMAT_RGB16_CME      0x0000000C
#define VAL_VIDEO_FORMAT_v410_CME2      0x00000010
#define VAL_VIDEO_FORMAT_RGB10_CME2     0x00000014
#define VAL_VIDEO_ENABLE_CME            0x00000001
#define VAL_VIDEO_STREAM_FORMAT_MASK    0x0000001C
#define VAL_VIDEO_FLIP_CONTROL_MASK     0x06000000
#define VAL_VIDEO_REQ_EXPIRE_NUM_MASK   0x001F0000
#define VAL_VIDEO_BOB_ENABLE            0x00400000
#define VAL_VIDEO_FRAME_BASE            0x01000000
#define VAL_VIDEO_PREFETCH_ON           0x40000000
#define VAL_VIDEO_ON_SND_DISPLAY        0x80000000

/* V12_QWORD_PER_LINE           0x234 */
#define V1_FETCH_COUNT          0x3ff00000
#define V1_FETCHCOUNT_ALIGNMENT 0x0000000f
#define V1_FETCHCOUNT_UNIT      0x00000004   /* Doubld QWORD */

/* V1_STRIDE */
#define V1_STRIDE_YMASK         0x00001fff
#define V1_STRIDE_UVMASK        0x1ff00000

/* V1_ZOOM_CONTROL              0x24C */
#define V1_X_ZOOM_ENABLE        0x80000000
#define V1_Y_ZOOM_ENABLE        0x00008000

/* V1_MINI_CONTROL              0x250 */
#define V1_X_INTERPOLY          0x00000002
#define V1_Y_INTERPOLY          0x00000001
#define V1_YCBCR_INTERPOLY      0x00000004  
#define V1_X_DIV_2              0x01000000
#define V1_X_DIV_4              0x03000000
#define V1_X_DIV_8              0x05000000
#define V1_X_DIV_16             0x07000000
#define V1_Y_DIV_2              0x00010000
#define V1_Y_DIV_4              0x00030000
#define V1_Y_DIV_8              0x00050000
#define V1_Y_DIV_16             0x00070000

/* V1_STARTADDR0               0x254 */
#define SW_FLIP_ODD             0x08000000

/* V_FIFO_CONTROL               0x258
 * IA2 has 32 level FIFO for packet mode video format
 *         32 level FIFO for planar mode video YV12. with extension reg 230 bit 21 enable
 *         16 level FIFO for planar mode video YV12. with extension reg 230 bit 21 disable
 * BCos of 128 bits. 1 level in IA2 = 2 level in VT3122
 */
#define V1_FIFO_DEPTH12         0x0000000B
#define V1_FIFO_DEPTH16         0x0000000F
#define V1_FIFO_DEPTH32         0x0000001F
#define V1_FIFO_DEPTH48         0x0000002F
#define V1_FIFO_DEPTH64         0x0000003F   
#define V1_FIFO_DEPTH122        0x00000079
#define V1_FIFO_THRESHOLD6      0x00000600
#define V1_FIFO_THRESHOLD8      0x00000800
#define V1_FIFO_THRESHOLD12     0x00000C00
#define V1_FIFO_THRESHOLD16     0x00001000
#define V1_FIFO_THRESHOLD24     0x00001800
#define V1_FIFO_THRESHOLD32     0x00002000
#define V1_FIFO_THRESHOLD40     0x00002800  
#define V1_FIFO_THRESHOLD48     0x00003000   
#define V1_FIFO_THRESHOLD56     0x00003800  
#define V1_FIFO_THRESHOLD61     0x00003D00  
#define V1_FIFO_THRESHOLD113    0x00007000
#define V1_FIFO_PRETHRESHOLD10  0x0A000000
#define V1_FIFO_PRETHRESHOLD12  0x0C000000
#define V1_FIFO_PRETHRESHOLD29  0x1d000000
#define V1_FIFO_PRETHRESHOLD40  0x28000000  
#define V1_FIFO_PRETHRESHOLD44  0x2c000000
#define V1_FIFO_PRETHRESHOLD56  0x38000000   
#define V1_FIFO_PRETHRESHOLD61  0x3D000000   
#define V1_FIFO_RRETHRESHOLD113 0x70000000

/*#define HI_CONTROL              0x260*/
#define V4_PREFETCH_ON_3204     0x40000000
#define V4_DISPLAY_PATH		    0x80000000	   /* 0: IGA1, 1: IGA2 */

/* ALPHA_V3_FIFO_CONTROL        0x278
 * IA2 has 32 level FIFO for packet mode video format
 *         32 level FIFO for planar mode video YV12. with extension reg 230 bit 21 enable
 *         16 level FIFO for planar mode video YV12. with extension reg 230 bit 21 disable
 *          8 level FIFO for ALPHA
 * BCos of 128 bits. 1 level in IA2 = 2 level in VT3122
 */
#define V3_FIFO_DEPTH16         0x0000000F
#define V3_FIFO_DEPTH24         0x00000017
#define V3_FIFO_DEPTH32         0x0000001F
#define V3_FIFO_DEPTH48         0x0000002F
#define V3_FIFO_DEPTH64         0x0000003F   
#define V3_FIFO_DEPTH100        0x00000063   
#define V3_FIFO_THRESHOLD8      0x00000800
#define V3_FIFO_THRESHOLD12     0x00000C00
#define V3_FIFO_THRESHOLD16     0x00001000
#define V3_FIFO_THRESHOLD24     0x00001800
#define V3_FIFO_THRESHOLD29     0x00001D00 
#define V3_FIFO_THRESHOLD32     0x00002000
#define V3_FIFO_THRESHOLD40     0x00002800  
#define V3_FIFO_THRESHOLD48     0x00003000   
#define V3_FIFO_THRESHOLD56     0x00003800   
#define V3_FIFO_THRESHOLD61     0x00003D00   
#define V3_FIFO_THRESHOLD63     0x00003F00
#define V3_FIFO_THRESHOLD88     0x00005800
#define V3_FIFO_THRESHOLD89     0x00005900
#define V3_FIFO_PRETHRESHOLD10  0x0000000A
#define V3_FIFO_PRETHRESHOLD12  0x0000000C
#define V3_FIFO_PRETHRESHOLD29  0x0000001d
#define V3_FIFO_PRETHRESHOLD40  0x00000028  
#define V3_FIFO_PRETHRESHOLD44  0x0000002c
#define V3_FIFO_PRETHRESHOLD56  0x00000038   
#define V3_FIFO_PRETHRESHOLD61  0x0000003D   
#define V3_FIFO_PRETHRESHOLD63  0x0000003F
#define V3_FIFO_PRETHRESHOLD88  0x00000058
#define V3_FIFO_PRETHRESHOLD89  0x00000059
#define V3_FIFO_MASK            0x0000007F
#define V3_FIFO_MASK_3314       0x000000FF
#define V3_FIFO_MASK_3324       0x000000FF
#define ALPHA_FIFO_DEPTH8       0x00070000
#define ALPHA_FIFO_DEPTH16      0x000f0000
#define ALPHA_FIFO_THRESHOLD4   0x04000000
#define ALPHA_FIFO_MASK         0xffff0000
#define ALPHA_FIFO_PRETHRESHOLD4 0x00040000

#define ColorSpaceValue_1_3123C0      0x13000DED
#define ColorSpaceValue_2_3123C0      0x13171000
#define ColorSpaceValue_1_32045       0x13000DED 
#define ColorSpaceValue_2_32045       0x13171000 

/* V_COMPOSE_MODE               0x298 */
#define SELECT_VIDEO_IF_COLOR_KEY     0x00000001  /* select video if (color key),otherwise select graphics */
#define SELECT_VIDEO3_IF_COLOR_KEY    0x00000020  /* For 3123C0, select video3 if (color key),otherwise select graphics */
#define SELECT_VIDEO_IF_CHROMA_KEY    0x00000002  /* select video if (chroma key ),otherwise select graphics */
#define ALWAYS_SELECT_VIDEO           0x00000000  /* always select video,Chroma key and Color key disable */
#define CHROMA_KEY_INVERSE_CONTROL    0x00000008  /* 0: display video if chroma key not match ,1: display video if chroma key match */
#define COMPOSE_V1_V3                 0x00000000  /* V1 on top of V3 */
#define COMPOSE_V3_V1                 0x00100000  /* V3 on top of V1 */
#define COMPOSE_V1_TOP                0x00000000
#define COMPOSE_V3_TOP                0x00100000
#define V1_COMMAND_FIRE               0x80000000  /* V1 commands fire */
#define V3_COMMAND_FIRE               0x40000000  /* V3 commands fire */
#define V_COMMAND_LOAD                0x20000000  /* Video register always loaded */
#define V_COMMAND_LOAD_VBI            0x10000000  /* Video register always loaded at vbi without waiting source flip */
#define V3_COMMAND_LOAD               0x08000000  /* CLE_C0 Video3 register always loaded */
#define V3_COMMAND_LOAD_VBI           0x00000100  /* CLE_C0 Video3 register always loaded at vbi without waiting source flip */
#define PRIMARY_DISPLAY_COLOR_KEY_ENABLE  0x00000001
#define SECOND_DISPLAY_COLOR_KEY_ENABLE   0x00010000

/* #define V3_STARTADDR_0       0x2A4 */
#define PLAY_ODD_FIELD          0x08000000
#define PLAY_EVEN_FIELD         0x00000000

/* V3_ALPHA_FETCH_COUNT         0x2B8 */
#define V3_FETCH_COUNT          0x3ff00000
#define ALPHA_FETCH_COUNT       0x000003ff

/* V3_ZOOM_CONTROL              0x2bc */
#define V3_X_ZOOM_ENABLE        0x80000000
#define V3_Y_ZOOM_ENABLE        0x00008000

/* V3_MINI_CONTROL              0x2c0 */
#define V3_X_INTERPOLY          0x00000002  
#define V3_Y_INTERPOLY          0x00000001  
#define V3_YCBCR_INTERPOLY      0x00000004
#define V3_X_DIV_2              0x01000000
#define V3_X_DIV_4              0x03000000
#define V3_X_DIV_8              0x05000000
#define V3_X_DIV_16             0x07000000
#define V3_Y_DIV_2              0x00010000
#define V3_Y_DIV_4              0x00030000
#define V3_Y_DIV_8              0x00050000
#define V3_Y_DIV_16             0x00070000

/* SUBP_CONTROL_STRIDE          0x3c0 */
#define SUBP_HQV_ENABLE         0x00010000
#define SUBP_IA44               0x00020000
#define SUBP_AI44               0x00000000
#define SUBP_STRIDE_MASK        0x00001fff
#define SUBP_CONTROL_MASK       0x00070000

/* RAM_TABLE_CONTROL            0x3c8 */
#define RAM_TABLE_RGB_ENABLE    0x00000007

/* HQV_CONTROL             0x3D0 */
#define HQV_RGB32           0x00000000
#define HQV_RGB16           0x20000000
#define HQV_RGB15           0x30000000
#define HQV_YUV422          0x80000000
#define HQV_YUV420          0xC0000000
#define HQV_ENABLE          0x08000000
#define HQV_SRC_SW          0x00000000
#define HQV_SRC_MC          0x01000000
#define HQV_FLIP_EVEN       0x00000000
#define HQV_FLIP_ODD        0x00000020
#define HQV_SW_FLIP         0x00000010   /* Write 1 to flip HQV buffer */
#define HQV_END_OF_FRAME    0x00000001
#define HQV_INT_ENABLE      0x00000080
#define HQV_DEINTERLACE     0x00010000   /* First line of odd field will be repeated 3 times */
#define HQV_FIELD_2_FRAME   0x00020000   /* Src is field. Display each line 2 times */
#define HQV_FRAME_2_FIELD   0x00040000   /* Src is field. Display field */
#define HQV_MOTION_ADAPTIVE_ENABLE      0x00800000
#define HQV_V_484_LOWPASS_FILTER        0x00400000
#define HQV_V_2122_LOWPASS_FILTER       0x00200000
#define HQV_FRAME_UV        0x00000000   /* Src is Non-interleaved */
#define HQV_FIELD_UV        0x00100000   /* Src is interleaved */
#define HQV_IDLE            0x00000008   
#define HQV_FLIP_STATUS     0x00000001   
#define HQV_DOUBLE_BUFF     0x00000000
#define HQV_TRIPLE_BUFF     0x04000000
#define HQV_SINGLE_BUF      0x00000040   //HQV Single Buffer
#define HQV_SUB_FLIP        0x00008000
#define HQV_FIFO_STATUS     0x00001000  

/* HQV_FILTER_CONTROL      0x3E4 */
#define HQV_H_LOWPASS_2TAP      0x00000001
#define HQV_H_LOWPASS_4TAP      0x00000002
#define HQV_H_LOWPASS_8TAP1     0x00000003   /* To be deleted */
#define HQV_H_LOWPASS_8TAP2     0x00000004   /* To be deleted */
#define HQV_H_HIGH_PASS         0x00000008
#define HQV_H_LOW_PASS          0x00000000
#define HQV_V_LOWPASS_2TAP      0x00010000
#define HQV_V_LOWPASS_4TAP      0x00020000
#define HQV_V_LOWPASS_8TAP1     0x00030000
#define HQV_V_LOWPASS_8TAP2     0x00040000
#define HQV_V_HIGH_PASS         0x00080000
#define HQV_V_LOW_PASS          0x00000000
#define HQV_H_HIPASS_F1_DEFAULT 0x00000040
#define HQV_H_HIPASS_F2_DEFAULT 0x00000000
#define HQV_V_HIPASS_F1_DEFAULT 0x00400000
#define HQV_V_HIPASS_F2_DEFAULT 0x00000000
#define HQV_H_HIPASS_F1_2TAP    0x00000050
#define HQV_H_HIPASS_F2_2TAP    0x00000100
#define HQV_V_HIPASS_F1_2TAP    0x00500000
#define HQV_V_HIPASS_F2_2TAP    0x01000000
#define HQV_H_HIPASS_F1_4TAP    0x00000060
#define HQV_H_HIPASS_F2_4TAP    0x00000200
#define HQV_V_HIPASS_F1_4TAP    0x00600000
#define HQV_V_HIPASS_F2_4TAP    0x02000000
#define HQV_H_HIPASS_F1_8TAP    0x00000080
#define HQV_H_HIPASS_F2_8TAP    0x00000400
#define HQV_V_HIPASS_F1_8TAP    0x00800000
#define HQV_V_HIPASS_F2_8TAP    0x04000000
/* IA2 NEW */
#define HQV_V_FILTER2           0x00080000
#define HQV_H_FILTER2           0x00000008
#define HQV_H_TAP2_11           0x00000041
#define HQV_H_TAP4_121          0x00000042
#define HQV_H_TAP4_1111         0x00000401
#define HQV_H_TAP8_1331         0x00000221
#define HQV_H_TAP8_12221        0x00000402
#define HQV_H_TAP16_1991        0x00000159
#define HQV_H_TAP16_141041      0x0000026A
#define HQV_H_TAP32             0x0000015A
#define HQV_V_TAP2_11           0x00410000
#define HQV_V_TAP4_121          0x00420000
#define HQV_V_TAP4_1111         0x04010000
#define HQV_V_TAP8_1331         0x02210000
#define HQV_V_TAP8_12221        0x04020000
#define HQV_V_TAP16_1991        0x01590000
#define HQV_V_TAP16_141041      0x026A0000
#define HQV_V_TAP32             0x015A0000
#define HQV_V_FILTER_DEFAULT    0x00420000
#define HQV_H_FILTER_DEFAULT    0x00000040

/* HQV_MINI_CONTROL        0x3E8 */
#define HQV_H_MINIFY_ENABLE     0x00000800
#define HQV_V_MINIFY_ENABLE     0x08000000
#define HQV_VDEBLOCK_FILTER     0x80000000
#define HQV_HDEBLOCK_FILTER     0x00008000

/* HQV_SRC_STRIDE          0x3F8 */
#define HQV_FIFO_DEPTH_1        0x00010000
#define HQV_FIFO_DEPTH_3        0x00030000

/* HQV Default Vodeo Color 0x3B8 */
#define HQV_FIX_COLOR           0x0643212c 

/* S3Chromo-De-blocking setting */
#define VAL_HQV_DEBLOCKING_ENABLE          0x08000000
#define VAL_HQV_TVFIELDSYNC_ENABLE         0x00004000
#define VAL_HQV_TV_ON_ADD_BUS              0x00000800

/* Add for VT3293 HQV Scale*/
#define HQV_H_SCALE_ENABLE                 0x80000000
#define HQV_H_SCALE_UP                     0x00000000  
#define HQV_H_SCALE_DOWN_FOURTH_TO_1       0x10000000 
#define HQV_H_SCALE_DOWN_FOURTH_TO_EIGHTH  0x20000000 
#define HQV_H_SCALE_DOWN_UNDER_EIGHTH      0x30000000 
  
#define HQV_V_SCALE_ENABLE 0x80000000
#define HQV_V_SCALE_UP     0x00000000
#define HQV_V_SCALE_DOWN   0x10000000


/* HQV engine value */
/* for VT3259 Video Rotation */
#define VAL_HQV_SINGLE_BUFF_CME         0x00000040
#define VAL_HQV_TILEMODE_512BITS_CME    0xc0000000
#define VAL_HQV_TILEMODE_256BITS_CME    0x80000000
#define VAL_HQV_CSC_ENABLE_CME          0x10000000
#define VAL_HQV_CSC_RGB32_CME           0x20000000
#define VAL_HQV_CSC_RGB16_CME           0x00000000
/*VT3409 colorspace adjustment control coefficient*/
#define VAL_HQV_CSC_A1         0x12A
#define VAL_HQV_CSC_A2         0x12A
#define VAL_HQV_CSC_A3         0x12A
#define VAL_HQV_CSC_B1         0x0
#define VAL_HQV_CSC_B2         0x1FFC9
#define VAL_HQV_CSC_B3         0x21D
#define VAL_HQV_CSC_C1         0x1CB
#define VAL_HQV_CSC_C2         0x1FF78
#define VAL_HQV_CSC_C3         0x0
#define VAL_HQV_CSC_D1         0x60F
#define VAL_HQV_CSC_D2         0x99
#define VAL_HQV_CSC_D3         0x5BD
#define VAL_HQV_COLOR_FORMAT_DEFAULT        0x00000000  
#define VAL_HQV_COLOR_FORMAT_METHOD2        0x00000001
#define VAL_HQV_COLOR_FORMAT_YUV444         0x00000020
#define VAL_HQV_COLOR_FORMAT_ADJUST_ENABLE  0x00000080
#define VAL_HQV_COLOR_FORMAT_CONSTRICTION   0x00000300
#define VAL_HQV_EDGEDETECT_CLOSE_THRESHOLD  0x40000000
#define VAL_HQV_EDGEDETECT_THRESHOLD        0x02000000


#define VAL_HQV_GAMMA_ENABLE_CME            0x02000000
#define VAL_HQV_H_DOWN_SCALE_CME            0x00001000
#define VAL_HQV_H_UP_SCALE_CME              0x00000800
#define VAL_HQV_V_DOWN_SCALE_CME            0x10000000
#define VAL_HQV_V_UP_SCALE_CME              0x08000000
#define VAL_HQV_CSC_RGB101010_CME2          0x80000000
#define VAL_HQV_OUTPUT_TILE_CME2            0x40000000
#define VAL_HQV_USE_V3_CSC_CME2             0x80000000

/* NEW HQV DE-INTERLACE DEFINITIONS */
#define VAL_PULL_DOWN_2_2_ENABLE_CME                        0x80000000
#define VAL_PULL_DOWN_INTER_FIELD_THRESHOLD_16_CME          0x40000000
#define VAL_PULL_DOWN_3_2_ENABLE_CME                        0x08000000
#define VAL_PULL_DOWN_INTRA_FIELD_THRESHOLD_FACTOR_2_CME    0x06000000
#define VAL_PULL_DOWN_FACTOR2_4_8_CME                       0x00040000
#define VAL_PULL_DOWN_FACTOR1_2_8_CME                       0x00000000
#define VAL_PULL_DOWN_MIN_THRESHOLD_2_CME                   0x00008000
#define VAL_HQV_MOTION_DETECTION_ENABLE_CME                 0x00001000
#define VAL_HQV_MOTION_THRESHOLD_16_CME                     0x00000800
#define VAL_HQV_EDGE_DETECTION_THRESHOLD_16_CME             0x00000010
#define VAL_HQV_EDGE_DETECTION_ENABLE_CME                   0x00000001
#define VAL_HQV_MOTIONADAPTIVE_ENABLE_CME                   0x00800000
#define VAL_HQV_V_2122_LOWPASS_FILTER_CME                   0x00200000
#define VAL_HQV_V_484_LOWPASS_FILTER_CME                    0x00400000
#define VAL_HQV_V_NO_LOWPASS_FILTER_CME                     0x00000000
#define VAL_HQV_OUTFIFO_THRESHOLD_32_CME                    0x00000000
#define VAL_HQV_FLIP_FIFODEPTH_1_CME                        0x00010000
#define VAL_HQV_FLIP_FIFODEPTH_1_BACK_DROP_CME              0x00030000
#define VAL_HQV_SW_FLIP_QUEUE_ENABLE_CME                    0x00100000
/* De-blocking */
#define VAL_DEBLOCK_ENABLE_CME                              0x08000000
#define VAL_DEBLOCK_LOWPASSFILTER_ENABLE_CME                0x04000000
#define VAL_DEBLOCK_MAX_62_CME                              0x000f0000


/*****************************************************************************
 *     VT3259 Video Control status                                           *
 *                                                                           *
 *****************************************************************************/

#define VAL_VIDEO_COLOR_KEY_ENABLE_CME      0x40000000
#define VAL_VIDEO_COLOR_KEY_INVERSE_CME     0x20000000
#define VAL_VIDEO_CHROMA_KEY_ENABLE_CME     0x40000000
#define VAL_VIDEO_CHROMA_KEY_INVERSE_CME    0x20000000
#define VAL_VIDEO_USE_V1_CHROMA_KEY_CME     0x00000000
#define VAL_VIDEO_USE_V3_CHROMA_KEY_CME     0x80000000

#define VAL_HM_WAIT_V1_FIRE                 0x00000010
#define VAL_HM_WAIT_V1_ADDRESS_LOAD         0x00000020
#define VAL_HM_WAIT_V1_HQV_FLIP_FIFO        0x00000008
#define VAL_HM_WAIT_V1_SUBFLIP              0x00000004
#define VAL_HM_WAIT_V1_HQV_SW_FLIP          0x00000002
#define VAL_HM_WAIT_V1_HQV_DONE             0x00000001
#define VAL_HM_WAIT_V3_FIRE                 0x00100000
#define VAL_HM_WAIT_V3_ADDRESS_LOAD         0x00200000
#define VAL_HM_WAIT_V3_HQV_FLIP_FIFO        0x00080000
#define VAL_HM_WAIT_V3_SUBFLIP              0x00040000
#define VAL_HM_WAIT_V3_HQV_SW_FLIP          0x00020000
#define VAL_HM_WAIT_V3_HQV_DONE             0x00010000
#define VAL_HM_WAIT_2D3D                0xc0000000

/*****************************************************************************
 *     HW wait register, VQ offset 0x2000 will be added in vfCM              *
 *                                                                           *
 *****************************************************************************/
#define REG_HW_WAIT_2D3D_CME          0x0000006c
#define REG_HW_WAIT_VID_CME             0x0000126c

#define REG_2D3D_SYNCCTL                    0x00000060
#define REG_VID_SYNCCTL                     0x00001260
/* Only 3 bits are available in 0x3260[26:24]  0xc0000000 */
#define CR_WorkingBufferMask    0x07

#define HWSYMC_3D_2D_Start                         0x00000000
#define HWSYMC_3D_2D_End                           0x10000000 
#define HWSYMC_3D_2D_End_and_wait_3D_Idle          0x20000000 
#define HWSYMC_3D_2D_End_and_wait_2D_Idle          0x30000000 
#define HWSYMC_3D_2D_comad_stream_kinds_HQV0       0x00000000 
#define HWSYMC_3D_2D_comad_stream_kinds_HQV1       0x08000000 

#define HWSYMC_DVD_VIDEO_Start                     0x00000000
#define HWSYMC_DVD_VIDEO_End                       0x10000000 
#define HWSYMC_DVD_VIDEO_End_and_wait_DVD_idle     0x20000000 
#define HWSYMC_DVD_VIDEO_End_and_wait_HQV_idle     0x30000000 
#define HWSYMC_DVD_VIDEO_comad_stream_kinds_HQV0   0x00000000 
#define HWSYMC_DVD_VIDEO_comad_stream_kinds_HQV1   0x08000000 

#define REG_VQ_STATUS_CME           0x00000504

/* V_COMPOSE_MODE               0x298 */
#define VAL_DISABLE_LCD_VERTICAL_SCALING_CME    0x00000010
#define VAL_DISABLE_LCD_HORIZONTAL_SCALING_CME  0x00000020
#define VAL_V1_COMMAND_ALWAYS_LOAD_CME          0x20000000  /* Video1 register always loaded */
#define VAL_V3_COMMAND_ALWAYS_LOAD_CME          0x08000000  /* Video3 register always loaded */
#define VAL_V1HDTV_CME                          0x01000000  /* Only V1 supports interpolation */
#define VAL_V3HDTV_CME                          0x02000000  /* Only V3 supports interpolation */


/* V1/V3_ZOOM_CONTROL            0x24C,0x2BC */
#define MASK_VIDEO_ZOOM_FACTOR_H    0xFFFF0000
#define MASK_VIDEO_ZOOM_FACTOR_V    0x0000FFFF

/* V1/V3/LCD_COLOR_KEY           0x220,0x280,0x264 */
#define VAL_VIDEO_COLOR_KEY_MASK    0x00FFFFFF

/* REG_HQV_TILE_CSC_CTL_CME      0x3DC */
#define MASK_TILE_CSC_CME           0x0FFFF800
#define MASK_HQV_IMAGE_SIZE_CME     0x000007ff

/* HQV_SRC_FETCH_LINE    0x3e0 */
#define MASK_HQV_SRC_FETCH          0x1FFF0000
#define VAL_HQV_SRC_FETCH_31        0x001F0000

/* HQV_DST_STARTADDR0    0X3EC */
#define MASK_HQV_DST_ADDR           0x1FFFFFFF

/* dwFunSel,wait function definition */
#define HM_WAIT_FIRE                0x00000001
#define HM_WAIT_SUBFLIP             0x00000003
#define HM_WAIT_HQV_DONE            0x00000004
#define HW_WAIT_HQV_FIFOEMPTY       0x00000006
#define HW_WAIT_HQV_FINISH          0x00000007
#define HM_WAIT_3D_IDLE             0x00000008
#define HM_WAIT_VQ_EMPTY            0x0000000A

#define HM_WAIT_VIRTUAL_QUEUE       0x00010000
#define HM_WAIT_FIRE_VQ             0x00010001
#define HM_WAIT_SUBFLIP_VQ          0x00010003
#define HM_WAIT_HQV_DONE_VQ         0x00010004
#define HW_WAIT_HQV_FIFOEMPTY_VQ    0x00010006
#define HW_WAIT_HQV_FINISH_VQ       0x00010007
#define HM_WAIT_3D_IDLE_VQ          0x00010008
#define HM_WAIT_VQ_EMPTY_VQ         0x0001000A

#define HW_ENABLE_VIDEO_VQ      0x00000001
#define HVCMDQstL_Header        (0x60 << 24 )
#define HVCMDQendL_Header       (0x61 << 24 )
#define HVCMDQstendH_Header     (0x62 << 24 )
#define HVCMDQLen_Header        (0x63 << 24 )
#define HVCMDQSetting_Header    (0x64 << 24 )


#define VID_THROUGH_CR_OFFSET   0x00002000
#define REG_HQV1_INDEX          0x00001000
#define VAL_VQ_NOT_EMPTY        0x20000000

#define CHROMA_KEY_LOW          0x00FFFFFF
#define CHROMA_KEY_HIGH         0x00FFFFFF

#define HQV_NONE                0x00000000
#define HQV_0                   0x00000001
#define HQV_1                   0x00000002

/* V1 V3 identity */
#define VIDEO_NONE              0x00000000
#define VIDEO_1                 0x00000001
#define VIDEO_3                 0x00000002

#endif /* _VIA_H */

