/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*************************************************************************
 *
 *  File:       via_exa.h
 *  Content:    The declare of exa functions
 *
 ************************************************************************/
#ifndef	 _VIA_EXA_H
#define	 _VIA_EXA_H 1

#include "miline.h"
#include "via_driver.h"
#include "via_regs.h"
#include "via_eng_regs.h"
#include "via_rotate.h" /* add by STChen, for rotate feature.*/
#include "agpctl.h"
#include "exa.h"
#include "via_3d.h"
#include "Xarch.h"
#include "macros.h"
#include "xaarop.h"

#ifdef X_HAVE_XAAGETROP
#define VIAACCELPATTERNROP(vRop) (XAAGetPatternROP(vRop) << 24)
#define VIAACCELCOPYROP(vRop) (XAAGetCopyROP(vRop) << 24)
#else
#define VIAACCELPATTERNROP(vRop) (XAAPatternROP[vRop] << 24)
#define VIAACCELCOPYROP(vRop) (XAACopyROP[vRop] << 24)
#endif

ExaDriverPtr viaInitExa(ScreenPtr pScreen);

int viaAccelMarkSync(ScreenPtr pScreen);

void viaAccelWaitMarker(ScreenPtr pScreen, int marker);

void viaExa3DInit(ScreenPtr pScreen);
void viaExa2DInit(ScreenPtr pScreen);
void viaInit2DState(ViaTwodContext *td);
void viaInit2DState_H5(ViaTwodContext *td);
void viaInit2DState_H6(ViaTwodContext *td);

static void viaAccelSolidHelper(ViaCommandBuffer * cb, int x, int y, int w, int h,
                    unsigned fbBase, CARD32 mode, unsigned pitch,
                    CARD32 fg, CARD32 cmd);

void viaAccelSync(ScrnInfoPtr pScrn);

static Bool viaExaPrepareCopy(PixmapPtr pSrcPixmap, PixmapPtr pDstPixmap, int xdir,
                  int ydir, int alu, Pixel planeMask);

static void viaExaCopy(PixmapPtr pDstPixmap, int srcX, int srcY, int dstX, int dstY,
           int width, int height);

static void viaExaDoneSolidCopy(PixmapPtr pPixmap);

Bool viaAccelSetMode(int bpp, ViaTwodContext * tdc);

static Bool viaAccelPlaneMaskHelper(ViaTwodContext * tdc, CARD32 planeMask);

static void viaAccelTransparentHelper(ViaTwodContext * tdc, ViaCommandBuffer * cb,
                          CARD32 keyControl, CARD32 transColor,
                          Bool usePlaneMask);

/*
 * Emit a copy blit operation to the command buffer.
 */
static void viaAccelCopyHelper(ViaCommandBuffer * cb, int xs, int ys, int xd, int yd,
                   int w, int h, unsigned srcFbBase, unsigned dstFbBase,
                   CARD32 mode, unsigned srcPitch, unsigned dstPitch,
                   CARD32 cmd);
void viaExaSetupFuncTable(ExaDriverPtr pExa,ScreenPtr pScreen);
	
static Bool viaExaPrepareSolid(PixmapPtr pPixmap, int alu, Pixel planeMask, Pixel fg);

static void viaExaSolid(PixmapPtr pPixmap, int x1, int y1, int x2, int y2);

static Bool viaExaCheckComposite(int op, PicturePtr pSrcPicture, \
                     PicturePtr pMaskPicture, PicturePtr pDstPicture);

static Bool viaExaPrepareComposite(int op, PicturePtr pSrcPicture, \
                       PicturePtr pMaskPicture, PicturePtr pDstPicture,
                       PixmapPtr pSrc, PixmapPtr pMask, PixmapPtr pDst);

static void viaExaComposite(PixmapPtr pDst, int srcX, int srcY, \
						int maskX, int maskY, int dstX, \
						int dstY, int width, int height);

void EXAInitialize3DEngine(ScrnInfoPtr pScrn);

Bool viaIsOffscreen(VIAPtr pVia, PixmapPtr pPix);

Bool viaExaIsOffscreen(PixmapPtr pPix);

Bool viaExpandablePixel(int format);

Bool viaCheckUpload(ScrnInfoPtr pScrn, Via3DState * v3d);

static CARD32 viaBitExpandHelper(CARD32 pixel, CARD32 bits);

void viaPixelARGB8888(unsigned format, void *pixelP, CARD32 * argb8888);

static Bool viaExaTexUploadToScreen(PixmapPtr pDst, int x, int y, int w, int h, char *src,
                        int src_pitch);
void via_ExaMoveDwords(CARD32* dest,CARD32* src,int dwords );

#endif

