/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*************************************************************************
 *
 *  File:       via_exa_h6.h
 *  Content:    The declare of exa functions
 *
 ************************************************************************/
#ifndef	 _VIA_EXA_H6_H
#define	 _VIA_EXA_H6_H 1

#include "miline.h"
#include "via_driver.h"
#include "via_regs.h"
#include "via_eng_regs.h"
#include "via_rotate.h" /* add by STChen, for rotate feature.*/
#include "agpctl.h"
#include "exa.h"
#include "via_3d.h"
#include "Xarch.h"
#include "xaarop.h"


#ifdef X_HAVE_XAAGETROP
#define VIAACCELPATTERNROP(vRop) (XAAGetPatternROP(vRop) << 24)
#define VIAACCELCOPYROP(vRop) (XAAGetCopyROP(vRop) << 24)
#else
#define VIAACCELPATTERNROP(vRop) (XAAPatternROP[vRop] << 24)
#define VIAACCELCOPYROP(vRop) (XAACopyROP[vRop] << 24)
#endif

void viaAccelWaitMarker_H6 (ScreenPtr pScreen, int marker);

void viaAccelSync_H6 (ScrnInfoPtr pScrn);

int viaAccelMarkSync_H6 (ScreenPtr pScreen);

static void viaAccelSolidHelper_H6 (ViaCommandBuffer * cb, int x, int y, int w, int h,
                    unsigned fbBase, CARD32 mode, unsigned pitch,
                    CARD32 fg, CARD32 cmd);

Bool viaExaPrepareCopy_H6 (PixmapPtr pSrcPixmap, PixmapPtr pDstPixmap, int xdir,
                  int ydir, int alu, Pixel planeMask);

static void viaAccelTransparentHelper_H6 (ViaTwodContext * tdc, ViaCommandBuffer * cb,
                          CARD32 keyControl, CARD32 transColor, Bool usePlaneMask);

void viaExaCopy_H6 (PixmapPtr pDstPixmap, int srcX, int srcY, int dstX, int dstY,
           			int width, int height);

static void viaAccelCopyHelper_H6 (ViaCommandBuffer * cb, int xs, int ys, int xd, int yd,
                   int w, int h, unsigned srcFbBase, unsigned dstFbBase,
                   CARD32 mode, unsigned srcPitch, unsigned dstPitch,
                   CARD32 cmd);
void viaExaDoneSolidCopy_H6(PixmapPtr pPixmap);

Bool viaExaPrepareSolid_H6(PixmapPtr pPixmap, int alu, Pixel planeMask, Pixel fg);

void viaExaSolid_H6(PixmapPtr pPixmap, int x1, int y1, int x2, int y2);

static Bool viaAccelSetMode_H6(int bpp, ViaTwodContext * tdc);

static Bool viaAccelPlaneMaskHelper_H6(ViaTwodContext * tdc, CARD32 planeMask);

Bool viaExaTexUploadToScreen_H6(PixmapPtr pDst, int x, int y, int w, int h, char *src,
                        int src_pitch);
#endif
