/*
 * Copyright 1998-2009 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2009 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#ifndef _VIA_INCLUDE_H_
#define _VIA_INCLUDE_H_

#ifdef HAVE_CONFIG_H            
#include "config_via.h"
#else 
#include "via_subversion.h"
#endif

/*General include file needed by driver*/
#ifndef XF86_VERSION_NUMERIC 
#include "xorgVersion.h"
#define  XF86_VERSION_NUMERIC  XORG_VERSION_NUMERIC
#define  XF86_VERSION_CURRENT XORG_VERSION_CURRENT
#endif
#include "xf86.h"	/*XF86_VERSION_NUMERIC is included in this file*/
#if XORG_VERSION_CURRENT <= XF86_VERSION_NUMERIC(2,0,0,0,0) && XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(1,4,99,0,0)
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#include "xf86str.h"	/* for Bool */
#else
#include "xf86_ansic.h"
#endif
#include "xf86Resources.h"
#include "xf86_OSproc.h"
#include "compiler.h"
/*IN DRIVER3,our driver only surpport version after Xorg 7.0,
   XORG_VERSION_CURRENT,equal to Xorgversion When 7.0,7.1,7.2,
   it differ from Xorgversion start form 7.3.
   IN DRIVER3,Driver only need to differ on XORG_VERSION_CURRENT
   Look Downward Form,and get version info
*/
/*. History                 XORG_VERSION_CURRENT         support or not                 cond in driver         */
/*1. Bf Xorg 7.0          No                                  	    not                                       no                  */
/*2. Xorg 7.0-7.2       (7,(0/1/2),0,0,0)              	    yes                                     refer cdtion1     */
/*3. AfXorg 7.3          (1,(3/4/5),X,X,X)              	    yes                                     refer cdtion2     */
/* suggest cdtion1: if(XORG_VERSION_CURRENT >= XF86_VERSION_NUMERIC(7,0,0,0,0)*/
/* suggest cdtion2: if((XORG_VERSION_CURRENT <=XF86_VERSION_NUMERIC(2,0,0,0,0))&&
					(XORG_VERSION_CURRENT >=XF86_VERSION_NUMERIC(1,3,0,0,0) ) )*/
/*STEP2*/
/*More need added after Xorg1.5.99.1,like Ubuntu9.04*/
/*xf86Version.h Doesn't exist any more,redefine and added some changed */
/* suggest cdtion3: if((XORG_VERSION_CURRENT <=XF86_VERSION_NUMERIC(2,0,0,0,0))&&
					(XORG_VERSION_CURRENT >=XF86_VERSION_NUMERIC(1,5,99,0,0) ) )*/
#endif /*_VIA_INCLUDE_H_*/

