/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_LCD_H_
#define _VIA_LCD_H_ 1

#define LCD_POWER_SEQUENCE_TD0  200
#define LCD_POWER_SEQUENCE_TD1  25
#define LCD_POWER_SEQUENCE_TD2  0
#define LCD_POWER_SEQUENCE_TD3  250

typedef struct _LcdPanelMatrix {
	CARD32 PanelSizeIndex;
	CARD32 Width;
	CARD32 Height;
}LcdPanelMatrix,*LcdPanelMatrixPtr;

static LcdPanelMatrix ViaSupportPanel[] = {
	/*PanelSizeIndex, 			Width, 		Height*/
    {VIA_480X640,      	480,    	640},
    {VIA_640X480,          	640,    	480},
	{VIA_800X480,				800,		480},
    {VIA_800X600,          	800,    	600},
	{VIA_1024X600, 			1024,		600},
    {VIA_1024X768,         	1024,    	768},
    {VIA_1280X768,         	1280,    	768},
	{VIA_1280X800, 			1280,		800},
    {VIA_1280X1024,        	1280,    	1024},
	{VIA_1360X768,			1360,		768},
	{VIA_1366X768,			1366,		768},
    {VIA_1400X1050,        	1400,    	1050},
    {VIA_1440X900,         	1440,    	900},
	{VIA_1600X1200,			1600,		1200},
};
#define NUM_SUPPORT_PANEL ARRAY_SIZE(ViaSupportPanel)

Bool VIADelay_Nmsec(VIABIOSInfoPtr pBIOSInfo, CARD32 dwCounter);
void VIALoadLCDScaling(VIABIOSInfoPtr pBIOSInfo, int set_hres, int set_vres, int panel_hres, int panel_vres);
void VIALoadLCDPatchRegs(VIABIOSInfoPtr pBIOSInfo, int set_iga);
void VIA_load_lcd_p880_patch_tbl(VIABIOSInfoPtr pBIOSInfo);
void VIASetLCDOutputPath(VIABIOSInfoPtr pBIOSInfo, int set_iga, int output_interface);
int VIAGetModeIndexByPanelSize(int PanelSizeID);
void VIA_fill_lcd_format(Bool bIsDualEdge, Bool bIsDithering);
Bool VIALVDSIdentify_VT1631(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo, CARD32 PortNum);
void VIAEnableLCD(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void VIADisableLCD(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
unsigned char VIAGetDeviceDetectLCD(VIABIOSInfoPtr pBIOSInfo);
void VIALCDSetMode(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void VIAInitLCDDIPort(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo,Bool lcd2_flag);
Bool VIALVDSIdentify(VIABIOSInfoPtr pBIOSInfo);
Bool VIASetLCDPanelInfo(VIABIOSInfoPtr pBIOSInfo, int panel_id);
Bool VIAIsPanelSizeValid(CARD32 width, CARD32 height);
void VIAPreInit_LVDS(VIABIOSInfoPtr pBIOSInfo);
void VIALCDPatchSkew(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void VIALoadScalingFactorForP4M900(VIABIOSInfoPtr pBIOSInfo, int set_hres, int set_vres, int panel_hres, int panel_vres);
void VIACheckDIPortOfIntegratedLVDS(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo, Bool lcd2_flag);
void VIASWPowerSequenceON(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void VIASWPowerSequenceOFF(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
struct display_timing lcd_centering_timging(struct display_timing mode_crt_reg, struct display_timing panel_crt_reg);
void load_crtc_shadow_timing(VIABIOSInfoPtr pBIOSInfo, struct display_timing mode_timing, struct display_timing panel_timing);
void VIALVDSIdentify_IntegratedLVDS(VIABIOSInfoPtr pBIOSInfo);
void TTLLCDPowerSequenceOn(VIABIOSInfoPtr pBIOSInfo);
void TTLLCDPowerSequenceOff(VIABIOSInfoPtr pBIOSInfo);
void VIAPowerOnLVDSChannel(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void VIAPowerOffLVDSChannel(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void EnableIntegratedLVDS(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void DisableIntegratedLVDS(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);
void VIASetPowerSequence(VIABIOSInfoPtr pBIOSInfo, LVDSSETTINGINFOPTR pLVDSSettingInfo);


#endif  /* _VIA_LCD_H_ */


