/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_LCDTBL_H_
#define _VIA_LCDTBL_H_ 1

#include "via_lcd.h"


/* ++++++ P880 ++++++ */
/*   Panel 1600x1200  */
static struct io_reg P880_LCD_RES_6X4_16X12[]  = {
  {VIACR,CR50,0xFF,0x73},{VIACR,CR55,0x0F,0x08},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x73},{VIACR,CR54,0x38,0x00},{VIACR,CR5D,0x40,0x40}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0x5A},{VIACR,CR71,0x08,0x00},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0x5E},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xD6},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0x7D},{VIASR,SR45,0xFF,0x8C},{VIASR,SR46,0xFF,0x02}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_6X4_16X12 ARRAY_SIZE(P880_LCD_RES_6X4_16X12)

static struct io_reg P880_LCD_RES_7X4_16X12[]  = {
  {VIACR,CR50,0xFF,0x67},{VIACR,CR55,0x0F,0x08},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x67},{VIACR,CR54,0x38,0x00},{VIACR,CR5D,0x40,0x40}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0x74},{VIACR,CR71,0x08,0x00},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0x78},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xF5},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0x78},{VIASR,SR45,0xFF,0x8C},{VIASR,SR46,0xFF,0x01}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_7X4_16X12 ARRAY_SIZE(P880_LCD_RES_7X4_16X12)

static struct io_reg P880_LCD_RES_8X6_16X12[]  = {
  {VIACR,CR50,0xFF,0x65},{VIACR,CR55,0x0F,0x08},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x65},{VIACR,CR54,0x38,0x00},{VIACR,CR5D,0x40,0x40}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0x7F},{VIACR,CR71,0x08,0x00},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0x83},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xE1},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0x6D},{VIASR,SR45,0xFF,0x88},{VIASR,SR46,0xFF,0x03}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_8X6_16X12 ARRAY_SIZE(P880_LCD_RES_8X6_16X12)

static struct io_reg P880_LCD_RES_10X7_16X12[]  = {
  {VIACR,CR50,0xFF,0x65},{VIACR,CR55,0x0F,0x08},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x65},{VIACR,CR54,0x38,0x00},{VIACR,CR5D,0x40,0x40}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0xAB},{VIACR,CR71,0x08,0x00},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0xAF},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xF0},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0x92},{VIASR,SR45,0xFF,0x88},{VIASR,SR46,0xFF,0x03}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_10X7_16X12 ARRAY_SIZE(P880_LCD_RES_10X7_16X12)

static struct io_reg P880_LCD_RES_12X10_16X12[]  = {
  {VIACR,CR50,0xFF,0x7D},{VIACR,CR55,0x0F,0x08},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x7D},{VIACR,CR54,0x38,0x00},{VIACR,CR5D,0x40,0x40}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0xD0},{VIACR,CR71,0x08,0x00},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0xD4},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xFA},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0xF6},{VIASR,SR45,0xFF,0x88},{VIASR,SR46,0xFF,0x05}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_12X10_16X12 ARRAY_SIZE(P880_LCD_RES_12X10_16X12)

/*   Panel 1400x1050   */
static struct io_reg P880_LCD_RES_6X4_14X10[]    = {                    /* 640x480                          */
  {VIACR,CR50,0xFF,0x9D},{VIACR,CR55,0x0F,0x56},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x9D},{VIACR,CR54,0x38,0x75},{VIACR,CR5D,0x40,0x24}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0x5F},{VIACR,CR71,0x08,0x44},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0x63},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xB4},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0xC6},{VIASR,SR45,0xFF,0x8C},{VIASR,SR46,0xFF,0x05}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_6X4_14X10 ARRAY_SIZE(P880_LCD_RES_6X4_14X10)

static struct io_reg P880_LCD_RES_8X6_14X10[]    = {                    /* 800x600                          */
  {VIACR,CR50,0xFF,0x9D},{VIACR,CR55,0x0F,0x56},                        /* IGA2 Horizontal Total            */
  {VIACR,CR53,0xFF,0x9D},{VIACR,CR54,0x38,0x75},{VIACR,CR5D,0x40,0x24}, /* IGA2 Horizontal Blank End        */
  {VIACR,CR6D,0xFF,0x7F},{VIACR,CR71,0x08,0x44},                        /* IGA2 Horizontal Total Shadow     */
  {VIACR,CR6E,0xFF,0x83},                                               /* IGA2 Horizontal Blank End Shadow */
  {VIACR,CR66,0xFF,0xBE},{VIACR,CR67,0x03,0x00},                        /* IGA2 Offset                      */
  {VIASR,SR44,0xFF,0x06},{VIASR,SR45,0xFF,0x8D},{VIASR,SR46,0xFF,0x05}  /* VCLK                             */
};
#define NUM_TOTAL_P880_LCD_RES_8X6_14X10 ARRAY_SIZE(P880_LCD_RES_8X6_14X10)


static struct _lcd_scaling_factor lcd_scaling_factor = {
    /* LCD Horizontal Scaling Factor Register */
    {LCD_HOR_SCALING_FACTOR_REG_NUM, {{CR9F,0,1}, {CR77,0,7}, {CR79,4,5}}},
    /* LCD Vertical Scaling Factor Register */
    {LCD_VER_SCALING_FACTOR_REG_NUM, {{CR79,3,3}, {CR78,0,7}, {CR79,6,7}}}
};

#endif  /* _VIA_LCDTBL_H_ */
