 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

 
/* 
 * I N C L U D E S 
 */
#include "debug.h"
#include "via_drm.h"

#ifdef HAVE_CONFIG_H
#include "config_via.h"
#endif
#include "via_memmgr.h"
#include "via_driver.h"

extern Bool via_module_loaded; 
extern drm_context_t samm_ctx_hdl;
unsigned long   Video_Count = 0;

/* 
 * F U N C T I O N S
 */
int viaPCIEMemAlloc(ScrnInfoPtr pScrn, ViaMemPtr mem,unsigned long size)
{
    /*
	 * Use Screen0 as the params for Drm memory managment ioctl interface.
	 */
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);
    int ret;
        
#ifdef XF86DRI
    if (pVia->directRenderingEnabled){
        mem->drm.context = DRIGetContext(pScrn0->pScreen);
        mem->drm.size = size;
        mem->drm.type = AGP;
        ret = drmCommandWriteRead(pVia->drmFD, DRM_VIA_ALLOCMEM,
                                      &mem->drm, sizeof(drm_via_mem_t));

        if (ret ==0 && (size == mem->drm.size)) {  
            mem->base = mem->drm.offset;
            mem->pool = 2;
            return Success;
        }
    }
#endif

    mem->pool = 0;
    return BadAlloc;
}


void viaPCIEMemFree(ScrnInfoPtr pScrn, ViaMemPtr mem)
{
    /*
     * Use Screen0 as the params for Drm memory managment ioctl interface.
     */
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);

    mem->base = 0;
    
    switch (mem->pool) {
        case 0:
            return;

        case 2:
#ifdef XF86DRI
            if (drmCommandWrite(pVia->drmFD, DRM_VIA_FREEMEM,
                                &mem->drm, sizeof(drm_via_mem_t)) < 0){
                return;
            }
#endif
            mem->pool = 0;
            return;
    }
}


void PrintFBMem(PVIDDATA pVidData)
{
    OffMemRange *used,*unused;
    ViaOffScrnPtr lpMemLayOut = &(pVidData->MemLayOut);

    if(pVidData->AddrUnused0){
        lpMemLayOut->unused = &(pVidData->MemLayOutBufPool[pVidData->AddrUnused0 - 1]);
    }else{
        lpMemLayOut->unused = NULL;
    }

    if(pVidData->AddrUsed0){
        lpMemLayOut->used = &(pVidData->MemLayOutBufPool[pVidData->AddrUsed0 - 1]);
    }else{
        lpMemLayOut->used = NULL;
    }

    unused = lpMemLayOut->unused;
    used   = lpMemLayOut->used;

    DBG_DD(("\n"));
    DBG_DD((" Used   ID, StartAddr,  EndAddr,     size,     type,     this,     next\n"));
    while (used != NULL){
        DBG_DD((" %08lx,  %08lx, %08lx, %08lx, %08x, %p, %p \n",
                  used->ID, used->StartAddr, used->EndAddr,used->size, used->type, used, used->nextarray));
        
        if(used->nextarray == 0){
            break;
        }
        used = nextq(used);
    }

    DBG_DD(("\n"));
    DBG_DD((" Unused ID, StartAddr,  EndAddr,     size,     type,     this,     next\n"));
    while (unused != NULL)
    {
        DBG_DD(("  %08lx,  %08lx, %08lx, %08lx, %08x, %p, %p \n",
                  unused->ID,unused->StartAddr, unused->EndAddr,unused->size, unused->type,
                  unused, unused->nextarray));
        
        if(unused->nextarray == 0){
            break;
        }
        unused = nextq(unused);
    }
}


void MergeL(OffMemRange * left , unsigned long size)
{
    left->EndAddr  = endq(left)  + size;
    left->size     = sizeq(left) + size;
}

void MergeR(OffMemRange * right, unsigned long Addr,unsigned long size)
{
    right->StartAddr = Addr;
    right->size      = sizeq(right) + size;
}

void MergeLR(OffMemRange *left, OffMemRange *right, unsigned long S_Addr,unsigned long size)
{
    left->size = sizeq(left) + sizeq(right) + size;
    left->EndAddr  = endq(right);
    left->nextarray = right->nextarray;
}


OffMemRange * allocSurface(PVIDDATA pVidData, int *size ,int alignment)
{
    int new_size ;
    unsigned long old_addr;
    OffMemRange *fq,*sq,*bq=NULL;
    Bool isFind = FALSE ;
    ViaOffScrnPtr lpMemLayOut = &(pVidData->MemLayOut);
    int nextnullptr=0;

    DBG_DD(("Enter Function : %s\n",__FUNCTION__)); 

    new_size = *size;
    if(pVidData->AddrUnused0){
        lpMemLayOut->unused = &(pVidData->MemLayOutBufPool[pVidData->AddrUnused0 - 1]);
    }else{
        lpMemLayOut->unused = NULL;
    }

    if(pVidData->AddrUsed0){
        lpMemLayOut->used = &(pVidData->MemLayOutBufPool[pVidData->AddrUsed0 - 1]);
    }else{
        lpMemLayOut->used = NULL;
    }
    
    if( lpMemLayOut->unused == NULL && lpMemLayOut->used == NULL ){
        viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
        nextnullptr = 0;
        /* FIXME: never check the boundary of the Array! */
        while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr){
            nextnullptr++;
        }
        pVidData->AddrUnused0 = nextnullptr + 1;
        pVidData->AddrUsed0   = 0;
        lpMemLayOut->unused = &(pVidData->MemLayOutBufPool[nextnullptr]);
        memset(lpMemLayOut->unused, 0, sizeof(OffMemRange));
        lpMemLayOut->unused->StartAddr = ALIGN_TO(viaGfxInfo->vheapbase, 256);
        lpMemLayOut->unused->EndAddr   = (ALIGN_TO(viaGfxInfo->vheapend, 256) -1);
        lpMemLayOut->unused->size      = lpMemLayOut->unused->EndAddr - lpMemLayOut->unused->StartAddr + 1;
        lpMemLayOut->unused->nextarray = 0;
        lpMemLayOut->used              = NULL;
        PrintFBMem(pVidData);
    }
    
    fq = lpMemLayOut->unused;
    bq = fq;
    while ( fq ){
        /* we must find the smaller-suitable memory for allocation */
        if ( (endq(fq) - startq(fq) + 1 ) >= new_size ){
            isFind = TRUE;
            break;
        }
        bq = fq ;
        fq = nextq(fq) ;
    }

    if (!isFind){
        DBG_DD(("  No surface available\n"));
        return NULL ;
    }else{
        old_addr = startq(fq);
        fq->StartAddr = startq(fq) + new_size ;
        fq->size      = sizeq(fq) - new_size;

        /* No memory left in this queue */
        if (startq(fq) == endq(fq) + 1){
            if ( fq == lpMemLayOut->unused ){
                pVidData->AddrUnused0 = fq->nextarray;
                lpMemLayOut->unused = nextq(fq);
                deleteq(fq);
            }else{
                bq->nextarray = fq->nextarray;
                deleteq(fq);
            }
        }

        if (lpMemLayOut->used == NULL ){
            nextnullptr = 0;
            /* FIXME: never check the boundary of the Array! */
            while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr){
                nextnullptr++;
            }
            pVidData->AddrUsed0 = nextnullptr + 1;
            lpMemLayOut->used = &(pVidData->MemLayOutBufPool[nextnullptr]);
            lpMemLayOut->used->StartAddr = old_addr;
            lpMemLayOut->used->EndAddr   = old_addr + new_size - 1;
            lpMemLayOut->used->size      = new_size;
            lpMemLayOut->used->nextarray = 0;
            DBG_DD(("  First Used \n"));
            return (lpMemLayOut->used);
        }

        sq = lpMemLayOut->used ;

        while (sq->nextarray != 0){
            sq = nextq(sq);
        }
        nextnullptr = 0;

        /* FIXME: never check the boundary of the Array! */
        while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr){
            nextnullptr++;
        }
        sq->nextarray = nextnullptr + 1;
        sq = nextq(sq);
        sq->nextarray = 0;
        sq->StartAddr = old_addr;
        sq->EndAddr   = old_addr + new_size - 1;
        sq->size      = new_size;
        return (sq);
    }
}

Bool freeSurface(PVIDDATA pVidData, unsigned long S_Addr,int size,unsigned char ctype)
{
    Bool isFind;
    OffMemRange *this_free,*fq,*bq;
    OffMemRange *rightq=NULL,*leftq=NULL;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    Bool fm = FALSE, bm = FALSE, bRightest=FALSE;
    Bool bLeftest = FALSE;/*left(lower addr)-->right(higher addr)*/
    ViaOffScrnPtr lpMemLayOut = &(pVidData->MemLayOut);

    int nextnullptr=0;
    
    if(pVidData->AddrUnused0){
        lpMemLayOut->unused = &(pVidData->MemLayOutBufPool[pVidData->AddrUnused0 - 1]);
    }else{
        lpMemLayOut->unused = NULL;
    }

    if(pVidData->AddrUsed0){
        lpMemLayOut->used = &(pVidData->MemLayOutBufPool[pVidData->AddrUsed0 - 1]);
    }else{
        lpMemLayOut->used = NULL;
    }

    DBG_DD(("Enter Function : %s\n",__FUNCTION__)); 

    isFind = FALSE;
    this_free = lpMemLayOut->used;
    fq = lpMemLayOut->unused;
    bq = NULL;

    bq = this_free;
    /* Find the queue to be deleted */
    while (this_free != NULL){
        
        /*if (this_free->StartAddr == S_Addr && size ==this_free->size && this_free->type == ctype)*/
        if (startq(this_free) == S_Addr && size ==sizeq(this_free) && typeq(this_free) == ctype){
            isFind = TRUE;
            break;
        }else{
            bq = this_free;
            this_free = nextq(this_free);
        }
    }


    if ( !isFind ){ 
        DBG_DD(("  Warnning! Surface to be freed not found. \n"));
        return isFind ;
    }

    /* bq is the first queue in the link list */
    if (bq == this_free && isFind){
        lpMemLayOut->used = nextq(bq) ;
        pVidData->AddrUsed0 = bq->nextarray;
        deleteq(this_free);
    }else if(bq != this_free && isFind){
        bq->nextarray = this_free->nextarray;
        deleteq(this_free);
    }

    /* add the free memory block to unused queue,first we find the
       "correct" queue to insert */

    bq = fq; /* where fq is lpMemLayOut->unused */

    while( fq!=NULL ){
        if(fq->nextarray){
            if ( (endq(fq)  == (S_Addr - 1)) && (pVidData->MemLayOutBufPool[fq->nextarray -1].StartAddr == (S_Addr + size)) ) {
                bm = TRUE ;
                fm = TRUE ;
                leftq = fq;
                rightq = nextq(fq);
                break;
            }
        }
        /* fq -> this_free */
        if (endq(fq)  == (S_Addr - 1) ) {
            bm = TRUE ;
            leftq = fq;
            break;
        }

        /* this_free -> fq */
        if ( startq(fq) == (S_Addr + size) ){
            fm = TRUE ;
            rightq = fq;
            break;
        }

        bq=fq;
        if (fq->nextarray == 0){
            break;
        }
        fq = nextq(fq);
    }

    if ( fm && bm ){
        DBG_DD((" MergeLR\n"));
        MergeLR(leftq, rightq, S_Addr, size);
        deleteq(rightq);
    }
    else if ( fm ){
        DBG_DD((" MergeR\n"));
        MergeR(rightq ,S_Addr, size);
    }
    else if ( bm ){
        DBG_DD((" MergeL\n"));
        MergeL(leftq ,size);
    }

    /* Merged and return */
    if ( fm || bm ){
        fq=lpMemLayOut->unused;
       
        if(startq(fq) == ALIGN_TO(viaGfxInfo->vheapbase, 256)            \
            && endq(fq) == (ALIGN_TO(viaGfxInfo->vheapend, 256) -1)) {
            pVidData->AddrUsed0=0;
            pVidData->AddrUnused0=0;
            memset(pVidData->MemLayOutBufPool,0,sizeof(pVidData->MemLayOutBufPool));
        }
        return isFind ;
    }

    /* sort it when insert unused queue */
    fq = lpMemLayOut->unused;
    bq = nextq(fq);

    /* fq -> NULL */
    if ( bq == NULL ){
        OffMemRange * this_add;
        nextnullptr = 0;
        /* FIXME: never check the boundary of the Array! */
        while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr){
            nextnullptr++;
        }
        this_add = &(pVidData->MemLayOutBufPool[nextnullptr]);
        this_add->StartAddr = S_Addr;
        this_add->EndAddr   = S_Addr + size -1;
        this_add->type      = ctype;
        this_add->size      = size;

        if ( startq(fq) > S_Addr ) {
            lpMemLayOut->unused = this_add;
            this_add->nextarray = pVidData->AddrUnused0;            
            pVidData->AddrUnused0 = nextnullptr + 1;
        }else{
            fq->nextarray    = nextnullptr + 1;
            this_add->nextarray = 0;
        }
        return isFind;
    }
    /* fq -> bq */
    else {
        while (fq != NULL && bq != NULL)
        {
            if ( (startq(fq) < S_Addr) && (startq(bq) > S_Addr) ){
                break;
            }else if((startq(fq) > S_Addr)){
                bLeftest = TRUE;
                break;
            }else {
                fq = nextq(fq);
                bq = nextq(bq);
            }
        }
    }

    if ( bq == NULL ){
       bRightest = TRUE;
    }

    if (lpMemLayOut->unused == NULL){
        nextnullptr = 0;
        /* FIXME: never check the boundary of the Array! */
        while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr)
            nextnullptr++;
        lpMemLayOut->unused = &(pVidData->MemLayOutBufPool[nextnullptr]);
        pVidData->AddrUnused0 = nextnullptr + 1;
        bq= lpMemLayOut->unused;
        /*bq->next = NULL;*/
        bq->nextarray = 0;
    }
    else /* fq -> bq and bq = NULL*/
    { 
        if ( bRightest ){
        nextnullptr = 0;
        /* FIXME: never check the boundary of the Array! */
        while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr)
            nextnullptr++;
        bq = &(pVidData->MemLayOutBufPool[nextnullptr]);
            /*bq->next = NULL;*/
            bq->nextarray= 0;
            /*fq->next = bq;*/
            fq->nextarray = nextnullptr+1;
            bq->EndAddr = S_Addr+size-1;
            bq->StartAddr = S_Addr;
            bq->size = size;
        }
        else if(bLeftest)
        {/*S_Addr is at the lowest address*/
            OffMemRange * this_add;
            nextnullptr = 0;
            /* FIXME: never check the boundary of the Array! */
            while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr){
                nextnullptr++;
            }
            this_add = &(pVidData->MemLayOutBufPool[nextnullptr]);
            this_add->StartAddr = S_Addr;
            this_add->EndAddr   = S_Addr + size -1;
            this_add->type      = ctype;
            this_add->size      = size;
            this_add->nextarray = pVidData->AddrUnused0;            
            lpMemLayOut->unused = this_add;
            pVidData->AddrUnused0 = nextnullptr + 1;
        }
        else /* fq -> bq */
        { 
            OffMemRange * cq;
            nextnullptr = 0;
            /* FIXME: never check the boundary of the Array! */
            while(pVidData->MemLayOutBufPool[nextnullptr].StartAddr){
                nextnullptr++;
            }
            cq = &(pVidData->MemLayOutBufPool[nextnullptr]);
            cq->nextarray = fq->nextarray;            
            fq->nextarray = nextnullptr+1;
            cq->EndAddr = S_Addr+size-1;
            cq->StartAddr = S_Addr;
            cq->size = size;
        }
    }

    return isFind ;
}


int mgr_vid_ioctl(PVIDDATA pVidData, unsigned int cmd, char *arg)
{
    DBG_DD((" IOCTL : cmd = %08x \n",cmd));
    switch (cmd){
        case VIAMGR_ALLOC_VIDEO:
        {
            ViaMMReq MMReq;
            int req_size;
            OffMemRange *offset;
            int aligment;

            memcpy(&MMReq ,(ViaMMReq *)arg,sizeof(ViaMMReq));

            if (MMReq.checkID != VIA_MID){
                DBG_DD((" fail ID code.\n"));
                return MEM_ERROR;
            }

            DBG_DD((" Alloc type = %08x\n",MMReq.type));
            req_size = MMReq.size;
            aligment = MMReq.alignment;
            
            if( (offset = allocSurface(pVidData, &req_size, aligment)) == NULL)
                return(MEM_ERROR);

            switch (MMReq.type){
                case VIDMGR_TYPE_VIDEO :
                    offset->ID = Video_Count;
                    Video_Count ++;
                    break;
                default :
                    DBG_DD((" Invalid buffer type! \n"));
                    return(MEM_ERROR);
            }

            offset->type = MMReq.type;
            offset->priority = MMReq.priority;
            offset->capability = MMReq.capability;
            MMReq.offset = offset->StartAddr;
            MMReq.ID     = offset->ID;
            memcpy((ViaMMReq *)arg,&MMReq,sizeof(ViaMMReq));

            PrintFBMem(pVidData);
            return MEM_OK;
        }

        case VIAMGR_FREE_VIDEO:
        {
            ViaMMReq fm ;

            memcpy(&fm ,(ViaMMReq *)arg,sizeof(ViaMMReq));
            if (fm.checkID != VIA_MID){
                DBG_DD((" fail ID code.\n"));
                return(MEM_ERROR);
            }
            DBG_DD((" VIAMGR_FREE type = %08x ,size = %lx\n",fm.type,fm.size));

            if(!freeSurface(pVidData, fm.offset,(int)fm.size,fm.type))
            {
                return(MEM_ERROR);
            }

            switch (fm.type) 
            {
                case VIDMGR_TYPE_VIDEO :
                    Video_Count --;
                    break;
                default :
                    DBG_DD((" Invalid buffer type! \n"));
                    return(MEM_ERROR);
            }

            PrintFBMem(pVidData);
            return MEM_OK;
        }

        default :
            DBG_DD(("  Invalid ioctl cmd! \n"));
            return(MEM_ERROR);
    } /* end of switch */

    return MEM_OK;
}



int viaVideoMemAlloc(ScrnInfoPtr pScrn, ViaMemPtr mem,unsigned long size)
{
	/* For xf86Linear memory managment case, we always use primary 
	 * screen video heap.        
	 * Use Screen0 as the params for xf86AllocateOffscreenLinear().
	 */
        ScrnInfoPtr pScrn0 = xf86Screens[0];
        VIAPtr pVia = VIAPTR(pScrn0);        
        PVIDDATA pVidData = pVia->pVidData;
        int ret;        
        ViaMMReq *pVideoSurface = NULL;
        
#ifdef XF86DRI
        if (pVia->directRenderingEnabled 
#ifdef DRM_SAMM_VIA
            || pVia->drmSammEnabled
#endif
            ) 
        {
#ifdef DRM_SAMM_VIA
            if (pVia->pBIOSInfo->SAMM) 
                mem->drm.context = samm_ctx_hdl;
            else 
#endif
                mem->drm.context = DRIGetContext(pScrn0->pScreen);

            mem->drm.size = size;
            mem->drm.type = VIDEO;
            ret = drmCommandWriteRead(pVia->drmFD, DRM_VIA_ALLOCMEM,
                                          &mem->drm, sizeof(drm_via_mem_t));

            if (ret ==0 && (size == mem->drm.size))
            {  
                mem->base = mem->drm.offset;
                mem->pool = 2;
                return Success;
            }
        }
#endif

#ifdef VIA_HAVE_EXA
        if (pVia->useEXA && !pVia->NoAccel) 
        { 
            mem->exa = exaOffscreenAlloc(pScrn0->pScreen, size,
                                     256, TRUE, NULL, NULL);
            if (mem->exa == NULL)
            {
                return BadAlloc;
            }

            mem->base = mem->exa->offset;
        }
        else
#endif
        {
            pVideoSurface = &pVidData->memRequest;
            
            pVideoSurface->checkID = VIA_MID;
            pVideoSurface->size    = ALIGN_TO(size, 256);
            pVideoSurface->alignment = 256;
            pVideoSurface->type    = VIDMGR_TYPE_VIDEO;
            if ( MEM_OK != mgr_vid_ioctl(pVidData, VIAMGR_ALLOC_VIDEO, (char *)(pVideoSurface) ) )
            {
                DBG_DD((" can't allocate memory use Video surface management\n"));
                return 0;
            }
            /* The return offset will be alignment to 256 by default */
            mem->base = pVideoSurface->offset;
            mem->size = pVideoSurface->size;        
        }
        
        mem->pool = 1;
        return Success;
}


void viaVideoMemFree(ScrnInfoPtr pScrn, ViaMemPtr mem)
{
    /* For xf86Linear memory managment case, we always use primary 
     * screen video heap.        
     * Use Screen0 as the params for xf86FreeOffscreenLinear().
     */
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);      
    PVIDDATA pVidData = pVia->pVidData;
    ViaMMReq *pVideoMMReq = NULL;

    
    switch (mem->pool) {
        case 0:
            return;

        case 1:
        {
#ifdef VIA_HAVE_EXA
            if (pVia->useEXA && !pVia->NoAccel) 
            {
                exaOffscreenFree(pScrn0->pScreen, mem->exa);
                mem->linear = NULL;
                mem->pool = 0;
                mem->base = 0;
                return;
            }
#endif
        }


        pVideoMMReq = &pVidData->memRequest;

        if (mem->base != 0)
        {
            pVideoMMReq->checkID = VIA_MID;
            pVideoMMReq->type    = VIDMGR_TYPE_VIDEO;
            pVideoMMReq->offset = mem->base;
            pVideoMMReq->size = mem->size;
            if ( MEM_OK != mgr_vid_ioctl(pVidData, VIAMGR_FREE_VIDEO, (char *)(pVideoMMReq) ) )
            {
                DBG_DD((" Memory Free fail !\n"));
                return;
            }
            pVideoMMReq->offset = 0; 
            mem->base = 0;
            mem->pool = 0;
         }  
       
        return;

        case 2:
#ifdef XF86DRI
            if (drmCommandWrite(pVia->drmFD, DRM_VIA_FREEMEM,
                                &mem->drm, sizeof(drm_via_mem_t)) < 0)
            {
                return;
            }
#endif
            mem->pool = 0;
            mem->base = 0;
            return;
    }
}

void VIAInitLinear(ScreenPtr pScreen)
{
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    VIAPtr pVia = VIAPTR(pScrn);

#ifdef VIA_HAVE_EXA
    if (pVia->useEXA && !pVia->NoAccel)
        return;
    else
#endif
    {
        unsigned long offset = 0; 
        long size = 0;

        offset = (pVia->FBFreeStart + pVia->Bpp - 1) / pVia->Bpp;

        if(via_module_loaded) {    /*For DDmepg on XAA noDRI path*/
       	    size = VIA_XV_XAA_NODRI_SIZE / pVia->Bpp; 
            pVia->FBFreeStart += VIA_XV_XAA_NODRI_SIZE;
        }
		else {
            size = pVia->FBFreeEnd / pVia->Bpp - offset;
        }

        /* The value of FBFreeStart/FreeEnd are based on pScrn->fbOffset, so it must add the 
           base value pScrn->fbOffset for the 2nd Screen for calling xf86InitFBManagerLinear. 
         */
        if(pVia->IsSecondary)
            offset += pScrn->fbOffset;
        
        if (size > 0)
            xf86InitFBManagerLinear(pScreen, offset, size);
    }
}

/* Allocate a chunk of the free framebuffer. Return 0 on fail. */
unsigned int viaFBAlloctor(ScrnInfoPtr pScrn, int size, int order, const char *name)
{
    VIAPtr pVia = VIAPTR(pScrn);
    unsigned int addr = 0;

    if( (pVia->FBFreeEnd - pVia->FBFreeStart) < size) {
        xf86DrvMsg( pScrn->scrnIndex, X_ERROR,
            "FB: Failed allocating %s (%d KB)\n", name, size/1024 );
        return 0;
    }

    if(order == SEQUENCE) {
        addr = pVia->FBFreeStart;
        pVia->FBFreeStart += size;
    }
    else if(order == INVERT_SEQ) {
        pVia->FBFreeEnd -= size;
        addr = pVia->FBFreeEnd;
    }
    DEBUG(xf86DrvMsg( pScrn->scrnIndex, X_INFO,
                    "viaFBAlloctor: allocating %s (%d KB), FBFreeStart = 0x%x, FBFreeEnd = 0x%x\n",
                    name, size/1024, pVia->FBFreeStart, pVia->FBFreeEnd));

    return addr;
}

