/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
/* kernel internal memory management */

#ifndef __LINUX_MEM_H
#define __LINUX_MEM_H

#ifdef XF86DRI
#include "via_drm.h"
#endif

#ifdef VIA_HAVE_EXA
#include "exa.h"
#endif

#include "xf86fbman.h"
#include "xf86.h"   /* For ScrnInfoPtr*/


#define VIA_MID  0x00004567 

/* memory type */
#define VIDMGR_TYPE_2D          0x11
#define VIDMGR_TYPE_3D          0x12
#define VIDMGR_TYPE_VIDEO       0x13

#define VIAMGR_ALLOC_VIDEO      0x00004006
#define VIAMGR_FREE_VIDEO       0x00004009

/* memory return value  */
#define MEM_OK       0
#define MEM_ERROR   -1

/* memory macro functions */
#define nextq(x)    (x->nextarray?(&(pVidData->MemLayOutBufPool[x->nextarray-1])):NULL)
#define sizeq(x)    x->size
#define endq(x)     x->EndAddr
#define startq(x)   x->StartAddr
#define deleteq(x) (x->StartAddr)=(unsigned long )NULL
#define typeq(x)    x->type

struct offrange
{
    unsigned long   StartAddr;
    unsigned long   EndAddr;
    unsigned long   size;
    unsigned char   type;
    unsigned long   ID;
    unsigned char   priority;
    unsigned char   capability;
    unsigned char   status;
    char            nextarray;
    /*struct offrange *next;*/
};
typedef struct offrange OffMemRange ;


typedef struct
{
    OffMemRange *unused;
    OffMemRange *used;
} ViaOffScrnRec, *ViaOffScrnPtr;


/* user-app use */

typedef struct { 
    unsigned long       size;
    unsigned long       offset;
    unsigned long       alignment;    
    unsigned long       checkID;
    unsigned long       ID;
    unsigned char       type;
    unsigned char       priority;
    unsigned char       capability;
    unsigned char       num;
} ViaMMReq;

/* Used for Texture video video memory management standalone */
typedef struct __ViaMemRec{
    unsigned long base;   /* Offset into fb */
    unsigned long size;
    int pool;			  /* Pool we drew from,0:nobody 1:xf86 linear 2:DRM */

#ifdef XF86DRI
    drm_via_mem_t drm;    /* DRM management object */
#endif

#ifdef VIA_HAVE_EXA
    ExaOffscreenArea *exa;  /*EXA management info ptr*/
#endif

    FBLinearPtr linear;	    /* X linear pool info ptr */
} ViaMemRec, *ViaMemPtr; 


int viaVideoMemAlloc(ScrnInfoPtr pScrn, ViaMemPtr mem,unsigned long size);
void viaVideoMemFree(ScrnInfoPtr pScrn, ViaMemPtr mem);
void VIAInitLinear(ScreenPtr pScreen);
int viaPCIEMemAlloc(ScrnInfoPtr pScrn, ViaMemPtr mem,unsigned long size);
void viaPCIEMemFree(ScrnInfoPtr pScrn, ViaMemPtr mem);

#define SEQUENCE    0
#define INVERT_SEQ  1
unsigned int viaFBAlloctor( ScrnInfoPtr pScrn, int size, int order, const char *name);

#endif /* end of LINUX_MEM_H */
