 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

/*************************************************************************
 *
 *  File:       via_mergedfb.c
 *  Content:    XFree86 4.0 for VIA/S3G UniChrome
 *
 ************************************************************************/

#include "xf86_OSproc.h"
#include "extnsionst.h"  	/* required */
#include "panoramiXproto.h"  	/* required */
#include "dixstruct.h"

#include "via_driver.h"
#include "via_mergedfb.h"
#include "xf86.h"
#include "xf86Priv.h"
#include "xf86Resources.h"
#include "vbe.h"


/* psuedo xinerama support */
static unsigned char 	VIAXineramaReqCode = 0;
int 			VIAXineramaPixWidth = 0;
int 			VIAXineramaPixHeight = 0;
int 			VIAXineramaNumScreens = 0;
VIAXineramaData	*VIAXineramadataPtr = NULL;
static int 		VIAXineramaGeneration;
Bool 		VIAnoPanoramiXExtension = TRUE;
extern Bool 	       noPanoramiXExtension; /* add for driver compiling on X11R7(FC5)*/

int VIAProcXineramaQueryVersion(ClientPtr client);
int VIAProcXineramaGetState(ClientPtr client);
int VIAProcXineramaGetScreenCount(ClientPtr client);
int VIAProcXineramaGetScreenSize(ClientPtr client);
int VIAProcXineramaIsActive(ClientPtr client);
int VIAProcXineramaQueryScreens(ClientPtr client);
int VIASProcXineramaDispatch(ClientPtr client);



/* Pseudo-Xinerama extension for MergedFB mode */
void
VIAUpdateXineramaScreenInfo(ScrnInfoPtr pScrn1)
{
    VIAPtr pVia = VIAPTR(pScrn1);
    VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    int scrn1scrnnum = 0, scrn2scrnnum = 1;
    int x1=0, x2=0, y1=0, y2=0, h1=0, h2=0, w1=0, w2=0;
    DisplayModePtr currentMode, firstMode;
    Bool infochanged = FALSE;

    if(!pBIOSInfo->MergedFB) return;

    if(VIAnoPanoramiXExtension) return;

    if(!VIAXineramadataPtr) return;

    /* Attention: Usage of RandR may lead into virtual X and Y values
     * actually smaller than our MetaModes! To avoid this, we calculate
     * the maxScrn fields here (and not somewhere else, like in CopyNLink)
     */

    if((pBIOSInfo->VIAXineramaVX != pScrn1->virtualX) || (pBIOSInfo->VIAXineramaVY != pScrn1->virtualY)) {
        if(!(pScrn1->modes)) {
            xf86DrvMsg(pScrn1->scrnIndex, X_ERROR,
           	   "Internal error: VIAUpdateXineramaScreenInfo(): pScrn->modes is NULL\n");
    	    return;
        }

        pBIOSInfo->maxScrn1_X1 =pBIOSInfo->maxScrn1_X2 = 0;
        pBIOSInfo->maxScrn1_Y1 = pBIOSInfo->maxScrn1_Y2 = 0;
        pBIOSInfo->maxScrn2_X1 = pBIOSInfo->maxScrn2_X2 = 0;
        pBIOSInfo->maxScrn2_Y1 = pBIOSInfo->maxScrn2_Y2 = 0;
           
        currentMode = firstMode = pScrn1->modes;

        do {
            DisplayModePtr p = currentMode->next;
            DisplayModePtr i =  firstMode;
            DisplayModePtr j =  firstMode;
            VIAScrn2Rel srel = pBIOSInfo->Scrn2Position;

            if((i->HDisplay <= pScrn1->virtualX) && (j->HDisplay <= pScrn1->virtualX) &&
             (i->VDisplay <= pScrn1->virtualY) && (j->VDisplay <= pScrn1->virtualY)) {
                if(srel != viaClone) {
                    if(pBIOSInfo->maxScrn1_X1 <= i->HDisplay) {
                        pBIOSInfo->maxScrn1_X1 = i->HDisplay;      /* Largest scrn1 mode */
                        if(pBIOSInfo->maxScrn1_X2 < j->HDisplay) {
                            pBIOSInfo->maxScrn1_X2 = j->HDisplay;   /* Largest X of scrn2 mode displayed with largest scrn1 mode */
                        }
                    }
                    if(pBIOSInfo->maxScrn2_X2 <= j->HDisplay) {
                        pBIOSInfo->maxScrn2_X2 = j->HDisplay;      /* Largest scrn2 mode */
                        if(pBIOSInfo->maxScrn2_X1 < i->HDisplay) {
                            pBIOSInfo->maxScrn2_X1 = i->HDisplay;   /* Largest X of scrn1 mode displayed with largest scrn2 mode */
                        }
                    }
                    if(pBIOSInfo->maxScrn1_Y1 <= i->VDisplay) {
                        pBIOSInfo->maxScrn1_Y1 = i->VDisplay;
                        if(pBIOSInfo->maxScrn1_Y2 < j->VDisplay) {
                            pBIOSInfo->maxScrn1_Y2 = j->VDisplay;
                        }
                    }
                    if(pBIOSInfo->maxScrn2_Y2 <= j->VDisplay) {
                        pBIOSInfo->maxScrn2_Y2 = j->VDisplay;
                        if(pBIOSInfo->maxScrn2_Y1 < i->VDisplay) {
                            pBIOSInfo->maxScrn2_Y1 = i->VDisplay;
                        }
                    }
                } 
            }
            currentMode = p;
        } while((currentMode) && (currentMode != firstMode));

        pBIOSInfo->VIAXineramaVX = pScrn1->virtualX;
        pBIOSInfo->VIAXineramaVY = pScrn1->virtualY;
        infochanged = TRUE;
    }

   
    switch(pBIOSInfo->Scrn2Position) {
    case viaLeftOf:
      /* x1 = min(pBIOSInfo->maxScrn1_X2, pScrn1->virtualX - pBIOSInfo->maxScrn1_X1);	
	 
       if(x1 < 0) x1 = 0;
       y1 = 0;									
       w1 = pScrn1->virtualX - x1;						
       h1 = pScrn1->virtualY;							
       x2 = 0;									
       y2 = 0;									
       w2 = max(pBIOSInfo->maxScrn2_X2, pScrn1->virtualX - pBIOSInfo->maxScrn2_X1); 	
       if(w2 > pScrn1->virtualX) w2 = pScrn1->virtualX;
       h2 = pScrn1->virtualY; 							
       break;*/
    case viaRightOf:
       x1 = 0;									
       y1 = 0;									
       w1 = max(pBIOSInfo->maxScrn1_X1, pScrn1->virtualX - pBIOSInfo->maxScrn1_X2);		
       if(w1 > pScrn1->virtualX) w1 = pScrn1->virtualX;
       h1 = pScrn1->virtualY;							       x2 = min(pBIOSInfo->maxScrn2_X1, pScrn1->virtualX - pBIOSInfo->maxScrn2_X2);		
       if(x2 < 0) x2 = 0;
       y2 = 0;									
       w2 = pScrn1->virtualX - x2;						
       h2 = pScrn1->virtualY;							
       break;
    case viaAbove:
/*       x1 = 0;									
       y1 = min(pBIOSInfo->maxScrn1_Y2, pScrn1->virtualY - pBIOSInfo->maxScrn1_Y1);		

       if(y1 < 0) y1 = 0;
       w1 = pScrn1->virtualX;							
       h1 = pScrn1->virtualY - y1;						
       x2 = 0;									       y2 = 0;								
       w2 = pScrn1->virtualX;							
       h2 = max(pBIOSInfo->maxScrn2_Y2, pScrn1->virtualY - pBIOSInfo->maxScrn2_Y1);		
       if(h2 > pScrn1->virtualY) h2 = pScrn1->virtualY;
       break;*/
    case viaBelow:
       x1 = 0;									
       y1 = 0;									
       w1 = pScrn1->virtualX;							
       h1 = max(pBIOSInfo->maxScrn1_Y1, pScrn1->virtualY - pBIOSInfo->maxScrn1_Y2);	
       if(h1 > pScrn1->virtualY) h1 = pScrn1->virtualY;
       x2 = 0;									
       y2 = min(pBIOSInfo->maxScrn2_Y1, pScrn1->virtualY - pBIOSInfo->maxScrn2_Y2);	 

       if(y2 < 0) y2 = 0;
       w2 = pScrn1->virtualX;							
       h2 = pScrn1->virtualY - y2;						
       break;
    default:
       xf86DrvMsg(pScrn1->scrnIndex, X_ERROR,
       	  "Internal error: UpdateXineramaInfo(): unsupported Scrn2Position (%d)\n",
	 pBIOSInfo->Scrn2Position);
    }/*get two screen's boudary*/
    VIAXineramadataPtr[scrn1scrnnum].x = x1;
    VIAXineramadataPtr[scrn1scrnnum].y = y1;
    VIAXineramadataPtr[scrn1scrnnum].width = w1;
    VIAXineramadataPtr[scrn1scrnnum].height = h1;
    VIAXineramadataPtr[scrn2scrnnum].x = x2;
    VIAXineramadataPtr[scrn2scrnnum].y = y2;
    VIAXineramadataPtr[scrn2scrnnum].width = w2;
    VIAXineramadataPtr[scrn2scrnnum].height = h2;

    if(infochanged) {
       DEBUG(xf86DrvMsg(pScrn1->scrnIndex, X_INFO,
          "Pseudo-Xinerama: scrn1 (Screen %d) (%d,%d)-(%d,%d)\n",
          scrn1scrnnum, x1, y1, w1+x1-1, h1+y1-1));
       DEBUG(xf86DrvMsg(pScrn1->scrnIndex, X_INFO,
          "Pseudo-Xinerama: scrn2 (Screen %d) (%d,%d)-(%d,%d)\n",
          scrn2scrnnum, x2, y2, w2+x2-1, h2+y2-1));
    }

}

/* Proc */

int
VIAProcXineramaQueryVersion(ClientPtr client)
{
    xPanoramiXQueryVersionReply	  rep;
    register int		  n;

    REQUEST_SIZE_MATCH(xPanoramiXQueryVersionReq);
    rep.type = X_Reply;
    rep.length = 0;
    rep.sequenceNumber = client->sequence;
    rep.majorVersion = VIA_XINERAMA_MAJOR_VERSION;
    rep.minorVersion = VIA_XINERAMA_MINOR_VERSION;
    if(client->swapped) {
        swaps(&rep.sequenceNumber, n);
        swapl(&rep.length, n);
        swaps(&rep.majorVersion, n);
        swaps(&rep.minorVersion, n);
    }
    WriteToClient(client, sizeof(xPanoramiXQueryVersionReply), (char *)&rep);
    return (client->noClientException);
}

int
VIAProcXineramaGetState(ClientPtr client)
{
    REQUEST(xPanoramiXGetStateReq);
    WindowPtr			pWin;
    xPanoramiXGetStateReply	rep;
    register int		n;

    REQUEST_SIZE_MATCH(xPanoramiXGetStateReq);
    pWin = LookupWindow(stuff->window, client);
    if(!pWin) return BadWindow;

    rep.type = X_Reply;
    rep.length = 0;
    rep.sequenceNumber = client->sequence;
    rep.state = !VIAnoPanoramiXExtension;
    if(client->swapped) {
       swaps (&rep.sequenceNumber, n);
       swapl (&rep.length, n);
       swaps (&rep.state, n);
    }
    WriteToClient(client, sizeof(xPanoramiXGetStateReply), (char *)&rep);
    return client->noClientException;
}

int
VIAProcXineramaGetScreenCount(ClientPtr client)
{
    REQUEST(xPanoramiXGetScreenCountReq);
    WindowPtr				pWin;
    xPanoramiXGetScreenCountReply	rep;
    register int			n;

    REQUEST_SIZE_MATCH(xPanoramiXGetScreenCountReq);
    pWin = LookupWindow(stuff->window, client);
    if(!pWin) return BadWindow;

    rep.type = X_Reply;
    rep.length = 0;
    rep.sequenceNumber = client->sequence;
    rep.ScreenCount = VIAXineramaNumScreens;
    if(client->swapped) {
       swaps(&rep.sequenceNumber, n);
       swapl(&rep.length, n);
       swaps(&rep.ScreenCount, n);
    }
    WriteToClient(client, sizeof(xPanoramiXGetScreenCountReply), (char *)&rep);
    return client->noClientException;
}

int
VIAProcXineramaGetScreenSize(ClientPtr client)
{
    REQUEST(xPanoramiXGetScreenSizeReq);
    WindowPtr				pWin;
    xPanoramiXGetScreenSizeReply	rep;
    register int			n;

    REQUEST_SIZE_MATCH(xPanoramiXGetScreenSizeReq);
    pWin = LookupWindow (stuff->window, client);
    if(!pWin)  return BadWindow;

    rep.type = X_Reply;
    rep.length = 0;
    rep.sequenceNumber = client->sequence;
    rep.width  = VIAXineramadataPtr[stuff->screen].width;
    rep.height = VIAXineramadataPtr[stuff->screen].height;
    if(client->swapped) {
       swaps(&rep.sequenceNumber, n);
       swapl(&rep.length, n);
       swaps(&rep.width, n);
       swaps(&rep.height, n);
    }
    WriteToClient(client, sizeof(xPanoramiXGetScreenSizeReply), (char *)&rep);
    return client->noClientException;
}

int
VIAProcXineramaIsActive(ClientPtr client)
{
    xXineramaIsActiveReply	rep;

    REQUEST_SIZE_MATCH(xXineramaIsActiveReq);

    rep.type = X_Reply;
    rep.length = 0;
    rep.sequenceNumber = client->sequence;
    rep.state = !VIAnoPanoramiXExtension;
    if(client->swapped) {
	register int n;
	swaps(&rep.sequenceNumber, n);
	swapl(&rep.length, n);
	swapl(&rep.state, n);
    }
    WriteToClient(client, sizeof(xXineramaIsActiveReply), (char *) &rep);
    return client->noClientException;
}

int
VIAProcXineramaQueryScreens(ClientPtr client)
{
    xXineramaQueryScreensReply	rep;

    REQUEST_SIZE_MATCH(xXineramaQueryScreensReq);

    rep.type = X_Reply;
    rep.sequenceNumber = client->sequence;
    rep.number = (VIAnoPanoramiXExtension) ? 0 : VIAXineramaNumScreens;
    rep.length = rep.number * sz_XineramaScreenInfo >> 2;
    if(client->swapped) {
       register int n;
       swaps(&rep.sequenceNumber, n);
       swapl(&rep.length, n);
       swapl(&rep.number, n);
    }
    WriteToClient(client, sizeof(xXineramaQueryScreensReply), (char *)&rep);

    if(!VIAnoPanoramiXExtension) {
       xXineramaScreenInfo scratch;
       int i;

       for(i = 0; i < VIAXineramaNumScreens; i++) {
	  scratch.x_org  = VIAXineramadataPtr[i].x;
	  scratch.y_org  = VIAXineramadataPtr[i].y;
	  scratch.width  = VIAXineramadataPtr[i].width;
	  scratch.height = VIAXineramadataPtr[i].height;
	  if(client->swapped) {
	     register int n;
	     swaps(&scratch.x_org, n);
	     swaps(&scratch.y_org, n);
	     swaps(&scratch.width, n);
    	     swaps(&scratch.height, n);
	  }
	  WriteToClient(client, sz_XineramaScreenInfo, (char *)&scratch);
       }
    }

    return client->noClientException;
}

static int
VIAProcXineramaDispatch(ClientPtr client)
{
    REQUEST(xReq);
    switch (stuff->data)
    {
	case X_PanoramiXQueryVersion:
	     return VIAProcXineramaQueryVersion(client);
	case X_PanoramiXGetState:
	     return VIAProcXineramaGetState(client);
	case X_PanoramiXGetScreenCount:
	     return VIAProcXineramaGetScreenCount(client);
	case X_PanoramiXGetScreenSize:
	     return VIAProcXineramaGetScreenSize(client);
	case X_XineramaIsActive:
	     return VIAProcXineramaIsActive(client);
	case X_XineramaQueryScreens:
	     return VIAProcXineramaQueryScreens(client);
    }
    return BadRequest;
}

/* SProc */

static int
VIASProcXineramaQueryVersion (ClientPtr client)
{
	REQUEST(xPanoramiXQueryVersionReq);
	register int n;
	swaps(&stuff->length,n);
	REQUEST_SIZE_MATCH (xPanoramiXQueryVersionReq);
	return VIAProcXineramaQueryVersion(client);
}

static int
VIASProcXineramaGetState(ClientPtr client)
{
	REQUEST(xPanoramiXGetStateReq);
	register int n;
 	swaps (&stuff->length, n);
	REQUEST_SIZE_MATCH(xPanoramiXGetStateReq);
	return VIAProcXineramaGetState(client);
}

static int
VIASProcXineramaGetScreenCount(ClientPtr client)
{
	REQUEST(xPanoramiXGetScreenCountReq);
	register int n;
	swaps (&stuff->length, n);
	REQUEST_SIZE_MATCH(xPanoramiXGetScreenCountReq);
	return VIAProcXineramaGetScreenCount(client);
}

static int
VIASProcXineramaGetScreenSize(ClientPtr client)
{
	REQUEST(xPanoramiXGetScreenSizeReq);
	register int n;
	swaps (&stuff->length, n);
	REQUEST_SIZE_MATCH(xPanoramiXGetScreenSizeReq);
	return VIAProcXineramaGetScreenSize(client);
}

static int
VIASProcXineramaIsActive(ClientPtr client)
{
	REQUEST(xXineramaIsActiveReq);
	register int n;
	swaps (&stuff->length, n);
	REQUEST_SIZE_MATCH(xXineramaIsActiveReq);
	return VIAProcXineramaIsActive(client);
}

static int
VIASProcXineramaQueryScreens(ClientPtr client)
{
	REQUEST(xXineramaQueryScreensReq);
	register int n;
	swaps (&stuff->length, n);
	REQUEST_SIZE_MATCH(xXineramaQueryScreensReq);
	return VIAProcXineramaQueryScreens(client);
}

int
VIASProcXineramaDispatch(ClientPtr client)
{
    REQUEST(xReq);
    switch (stuff->data) {
	case X_PanoramiXQueryVersion:
	     return VIASProcXineramaQueryVersion(client);
	case X_PanoramiXGetState:
	     return VIASProcXineramaGetState(client);
	case X_PanoramiXGetScreenCount:
	     return VIASProcXineramaGetScreenCount(client);
	case X_PanoramiXGetScreenSize:
	     return VIASProcXineramaGetScreenSize(client);
	case X_XineramaIsActive:
	     return VIASProcXineramaIsActive(client);
	case X_XineramaQueryScreens:
	     return VIASProcXineramaQueryScreens(client);
    }
    return BadRequest;
}

static void
VIAXineramaResetProc(ExtensionEntry* extEntry)
{
    if(VIAXineramadataPtr) {
       Xfree(VIAXineramadataPtr);
       VIAXineramadataPtr = NULL;
    }
}

void
VIAXineramaExtensionInit(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
	VIABIOSInfoPtr pBIOSInfo = pVia->pBIOSInfo;
    Bool	success = FALSE;

    if(!(VIAXineramadataPtr)) {

       if(!pBIOSInfo->MergedFB) {
          VIAnoPanoramiXExtension = TRUE;
          return;
       }

#ifdef PANORAMIX
       if(!noPanoramiXExtension) {
          xf86DrvMsg(pScrn->scrnIndex, X_INFO,
       	     "Xinerama active, not initializing VIA Pseudo-Xinerama\n");
          VIAnoPanoramiXExtension = TRUE;
          return;
       }
#endif

       if(VIAnoPanoramiXExtension) {
          xf86DrvMsg(pScrn->scrnIndex, X_INFO,
       	      "VIA Pseudo-Xinerama disabled\n");
          return;
       }

           

       VIAXineramaNumScreens = 2;

       while(VIAXineramaGeneration != serverGeneration) {
/*add X11's Xinerama ,but only use it's window management*/
	 pBIOSInfo->XineramaExtEntry = AddExtension(PANORAMIX_PROTOCOL_NAME, 0,0,
					VIAProcXineramaDispatch,
					VIASProcXineramaDispatch,
					VIAXineramaResetProc,
					StandardMinorOpcode);

	  if(!pBIOSInfo->XineramaExtEntry) break;

	  VIAXineramaReqCode = (unsigned char)pBIOSInfo->XineramaExtEntry->base;

	  if(!(VIAXineramadataPtr = (VIAXineramaData *)
	        xcalloc(VIAXineramaNumScreens, sizeof(VIAXineramaData)))) break;

	  VIAXineramaGeneration = serverGeneration;
	  success = TRUE;
       }

       if(!success) {
          xf86DrvMsg(pScrn->scrnIndex, X_ERROR,
	    	"Failed to initialize VIA Pseudo-Xinerama extension\n");
          VIAnoPanoramiXExtension = TRUE;
          return;
       }

       xf86DrvMsg(pScrn->scrnIndex, X_INFO,
    	  "Initialized VIA Pseudo-Xinerama extension\n");

       pBIOSInfo->VIAXineramaVX = 0;
       pBIOSInfo->VIAXineramaVY = 0;

    }

    VIAUpdateXineramaScreenInfo(pScrn);

}
/* End of PseudoXinerama */








