/*
 * Copyright 1998-2009 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2009 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#ifndef __VIA_OUTPUT_H__
#define __VIA_OUTPUT_H__

typedef struct _subChipVerInfo
{
    CARD8  address;
    CARD8  numOfRevReg;
    CARD8* revOffset;
    CARD8* revId;
    CARD32 subChipName;
}subChipVerInfo, *subChipVerInfoPtr;


/*TMDS Transmitter*/
static CARD8 vt1632VerReg[SUBCHIP_VT1632_VERSION_REG_NUM] =
{
    SUBCHIP_VT1632_VERSION_LOW_REG,
    SUBCHIP_VT1632_VERSION_HI_REG  
};
static CARD8 vt1632VerId[SUBCHIP_VT1632_VERSION_REG_NUM] =
{
    SUBCHIP_VT1632_VERSION_LOW,
    SUBCHIP_VT1632_VERSION_HI
};
static subChipVerInfo vt1632Info =
{
    SUBCHIP_VT1632_SLAVE_ADDR,
    SUBCHIP_VT1632_VERSION_REG_NUM,
    vt1632VerReg,  
    vt1632VerId,
    SUBCHIP_VT1632    
};

/*LVDS Transmitter*/
static CARD8 vt1636VerReg[SUBCHIP_VT1636_VERSION_REG_NUM] =
{
    SUBCHIP_VT1636_VERSION_LOW_REG,
    SUBCHIP_VT1636_VERSION_HI_REG  
};
static CARD8 vt1636VerId[SUBCHIP_VT1636_VERSION_REG_NUM] =
{
    SUBCHIP_VT1636_VERSION_LOW,
    SUBCHIP_VT1636_VERSION_HI
};
static subChipVerInfo vt1636Info =
{
    SUBCHIP_VT1636_SLAVE_ADDR,
    SUBCHIP_VT1636_VERSION_REG_NUM,
    vt1636VerReg,  
    vt1636VerId,
    SUBCHIP_VT1636    
};

static CARD32 serialPortTable[] =
{
    DISP_SERIALP_2C,
    DISP_SERIALP_31,
    DISP_SERIALP_25,
    DISP_SERIALP_3D,
    DISP_SERIALP_26
};

#define NUM_SERIAL_PORT CMDISP_ARRAYSIZE(serialPortTable)




#define OUTPUT_CRT_NAME       "CRT"
#define OUTPUT_LCD_NAME       "LCD"
#define OUTPUT_LCD2_NAME      "LCD-2"
#define OUTPUT_DVI_NAME       "DVI"
#define OUTPUT_DVI2_NAME      "DVI-2"

typedef struct _ViaOutputInfo
{
    CARD32   serialPort;
    CARD32   ddcPort;
    CARD32   subChipName;
    CARD32   slaveAddress;
    CARD32   diPort;
    CARD32   physicalWidth;
    CARD32   physicalHeight;
    CARD32   type;
    Bool     NoDDCValue;
    Bool     hasHotplug;
}ViaOutputInfo, *ViaOutputInfoPtr;

typedef struct _ViaGfxDPA
{
	CARD8	clkPolarity;		/*Clock Polarity*/
	CARD8	clkAdjust;			/*Clock Adjust*/
	CARD8	clkDrivingSel;		/*DVP0 or DVP1 Clock Driving Selection*/
	CARD8	dataDrivingSel;		/*DVP0 or DVP1 Data Driving Selection*/
	Bool	isClkPolarityUsed;
	Bool	isClkAdjustUsed;
	Bool	isClkDrivingSelUsed;
	Bool	isDataDrivingSelUsed;
}ViaGfxDPA, *ViaGfxDPAPtr;

typedef struct _ViaLvdsDPA
{
	CARD8	Vt1636ClkSelST1;
	CARD8	Vt1636ClkSelST2;
	Bool	isVt1636ClkSelST1Used;
	Bool	isVt1636ClkSelST2Used;
}ViaLvdsDPA, *ViaLvdsDPAPtr;

typedef struct _ViaCrtPrivateInfo
{
    ViaOutputInfo   commonInfo;
}ViaCrtPrivateInfo, *ViaCrtPrivateInfoPtr;

typedef struct _ViaDviPrivateInfo
{
    ViaOutputInfo   commonInfo;
	ViaGfxDPA		userGfxDPA;
}ViaDviPrivateInfo, *ViaDviPrivateInfoPtr;

typedef struct _ViaLcdPrivateInfo
{
	ViaOutputInfo   commonInfo;
	ViaGfxDPA		userGfxDPA;
	ViaLvdsDPA		userLvdsDPA;
	CARD32	panelIndex;
	CARD32	dualChannel;
	CARD32	noDithering;
	CARD32  center;
	CARD32	msb;
	CARD32  fixOnIGA1;
    DisplayModePtr confMode;
}ViaLcdPrivateInfo,*ViaLcdPrivateInfoPtr;


/*****************************************************/
/*                Function declaration               */
/*****************************************************/
void via_output_init(ScrnInfoPtr pScrn);
void viaDIPortPadOff(int DIPort);
void viaSetOutputPath(CARD32 diPort, int igaPath, int chipset);


#endif

