/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include "xf86.h"
 
/* Rotate Degree */
#ifndef VIA_ROTATE_DEGREE
#define VIA_ROTATE_DEGREE
#define VIA_ROTATE_DEGREE_0       0
#define VIA_ROTATE_DEGREE_90      1
#define VIA_ROTATE_DEGREE_180     2
#define VIA_ROTATE_DEGREE_270     4
#define VIA_ROTATE_DEGREE_ALL     (VIA_ROTATE_DEGREE_0|VIA_ROTATE_DEGREE_90\
                                                       |VIA_ROTATE_DEGREE_180|VIA_ROTATE_DEGREE_270)
#define VIA_ROTATE_REFLECT_X      8
#define VIA_ROTATE_REFLECT_Y      16
#define VIA_ROTATE_REFLECT_ALL  (VIA_ROTATE_REFLECT_X|VIA_ROTATE_REFLECT_Y)

#define VIA_TO_RR(x) (((x) & 0x07) ? (x)<<1 : ((x)<<1 | 0x01) )
#define RR_TO_VIA(x) ((x)>>1)
#endif 
#define VIA_ROTATE_TYPE_SW       0
#define VIA_ROTATE_TYPE_HW       1


void EnableCBUrotate(ScrnInfoPtr pScrn);
void DisableCBUrotate(ScrnInfoPtr pScrn);
void Enable2DEngineRotate(ScrnInfoPtr pScrn, CARD32* pGEMode, CARD32* pCommand);
//void Enable2DEngineRotate_M1(ScrnInfoPtr pScrn, CARD32* pGEMode, CARD32* pCommand);
Bool IsSupportDirectAccessWindow(int ChipID);
Bool IsSupport2DRotateEngine(int ChipID);
void ProbeRotateCaps(ScrnInfoPtr pScrn);
void DoConvertCoordinates(int *pX, int *pY, int maxX, int maxY, int rot_degree);
void ConvertCoordinatesOne(ScrnInfoPtr pScrn, int* X1, int* Y1, int w, int h);
void ConvertCoordinatesTwo(ScrnInfoPtr pScrn, int* X1, int* Y1, int* X2, int* Y2, int w, int h);
void ConvertDirection(ScrnInfoPtr pScrn, int xdir, int ydir, CARD32* cmd);
void ConvertSize(ScrnInfoPtr pScrn, int* width, int* height);

/* The following interface is for the uniform 3D texture bliting interface */
/* Using the standard pixmap-matrix transform operation to caculate the transform matrixes */
Bool
viaTransformCompute (int src_x, int src_y, int src_w, int src_h,
            int dst_x, int dst_y, int dst_w, int dst_h,
            unsigned int rotation, int width, int height, 
            PictTransformPtr	transform, 
            PictTransformPtr invTrans,
            PictTransformPtr rrTransform,
            PictTransformPtr rrInvTrans
            );
/* xorg version 1.60 */
#if XORG_VERSION_CURRENT  < (((1) * 10000000) + ((6) * 100000) + ((0) * 1000) + 0)
void PictureTransformBounds (BoxPtr b, PictTransformPtr matrix);
#endif

