/*
 * Copyright 1998-2009 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2009 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#ifndef __SERIAL_H__
#define __SERIAL_H__

#include "via_common.h"

typedef struct _SerialBusRec 
{
    signed int         	HoldTime; 	    /* 1 / bus clock frequency, 5 or 2 usec */
    signed int			BitTimeout;	    /* usec */
    signed int 		    ByteTimeout;	/* usec */
    signed int			AcknTimeout;    /* usec */
    signed int 		    StartTimeout;	/* usec */
    signed int          RiseFallTime;   /* usec */
}SerialBusRec,*SerialBusRecPtr;

#define PORT_INDEX_I2C_31       0x31
#define PORT_INDEX_GPIO_2C      0x2C
#define PORT_INDEX_GPIO_25      0x25
#define PORT_INDEX_I2C_26       0x26
#define PORT_INDEX_GPIO_3D      0x3D


typedef struct _ChipCheckInfoRec
{
    unsigned short  SerialAddress;  /* slave address of the chip */
    unsigned char   index;          /* the ID location */
    unsigned char   *pData;         /* with the filed *length* to identify the chip itself */
    signed int   length;            /* see above */
    signed int   SerialPort;        /* if you know which i2c port the chip locate,  please specify it. 
                                                               Or every port will be detected */ 
}ChipCheckInfoRec, *ChipCheckInfoPtr;


/* serial bus relevant functions */
unsigned int viaSerialWriteByte ( signed int port,  unsigned short slaveAddr,  unsigned char index,  unsigned char byte);
unsigned int viaSerialWriteBytes ( signed int port,  unsigned short slaveAddr,  unsigned char index,  unsigned char * pByte,  unsigned int nWrite);
unsigned int viaSerialReadByte ( signed int port,  unsigned short slaveAddr,  unsigned char index,  unsigned char * pByte);
unsigned int viaSerialReadBytes ( signed int port,  unsigned short slaveAddr,  unsigned char index,  unsigned char * pByte,  signed int nRead);
unsigned int viaSerialWriteByteMask ( unsigned int port,  unsigned short slaveAddr,  unsigned char index,  unsigned char byte,  unsigned char mask);
void    viaSerialUDelay ( signed int usec);



#endif

