 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

#include "via_driver.h"
#include "shadowfb.h"
#include "servermd.h"
#include "via_rotate.h"


void
VIARefreshArea(ScrnInfoPtr pScrn, int num, BoxPtr pbox)
{
    VIAPtr pVia = VIAPTR(pScrn);
    int width, height, Bpp, FBPitch;
    unsigned char *src, *dst;
   
    Bpp = pScrn->bitsPerPixel >> 3;
    FBPitch = BitmapBytePad(pScrn->displayWidth * pScrn->bitsPerPixel);

    while (num--) {
        width = (pbox->x2 - pbox->x1) * Bpp;
        height = pbox->y2 - pbox->y1;
        src = pVia->ShadowPtr + (pbox->y1 * pVia->ShadowPitch) + 
              (pbox->x1 * Bpp);
        dst = pVia->FBBase + (pbox->y1 * FBPitch) + (pbox->x1 * Bpp);

        while (height--) {
            memcpy(dst, src, width);
            dst += FBPitch;
            src += pVia->ShadowPitch;
        }
    
        pbox++;
    }
} 

void
VIARefreshArea_UD(ScrnInfoPtr pScrn, int num, BoxPtr pbox)
{
    VIAPtr pVia = VIAPTR(pScrn);
    int width, height, Bpp, FBPitch;
    unsigned char *src, *dst;
    int i;
   
    Bpp = pScrn->bitsPerPixel >> 3;
    FBPitch = BitmapBytePad(pScrn->displayWidth * pScrn->bitsPerPixel);

    while (num--) {
        width = pbox->x2 - pbox->x1;
        height = pbox->y2 - pbox->y1;
        src = pVia->ShadowPtr + (pbox->y1 * pVia->ShadowPitch) + 
              (pbox->x1 * Bpp);
        dst = pVia->FBBase + ((pScrn->virtualY - 1 - pbox->y1) * FBPitch) + 
			  ((pScrn->virtualX - 1 - pbox->x1) * Bpp);

        switch(pScrn->bitsPerPixel) {
        case 8:
             while (height--) {
                 for(i=0; i<width; i++){
                      *(dst-i)=*(src+i);
                 }    
                 dst -= FBPitch;
                 src += pVia->ShadowPitch;
             }
             break;
            
		case 16:
             while (height--) {
                 for(i=0; i<width; i++){
                      *(CARD16 *)(dst-i*2)=*(CARD16 *)(src+i*2);
                 }    
                 dst -= FBPitch;
                 src += pVia->ShadowPitch;
             }
             break;
            
		case 24:
             while (height--) {
                 for(i=0; i<width*3; i=i+3){
                      *(dst-i)=*(src+i);
                      *(dst-i+1)=*(src+i+1);
                      *(dst-i+2)=*(src+i+2);
                 }    
                 dst -= FBPitch;
                 src += pVia->ShadowPitch;
             }
             break;
           
		case 32:
             while (height--) {
                 for(i=0; i<width; i++){
                      *(CARD32 *)(dst-i*4)=*(CARD32 *)(src+i*4);
                 }    
                 dst -= FBPitch;
                 src += pVia->ShadowPitch;
             }
             break;
                        
		default:
			 break;
        }
        pbox++;
    }
}


void
VIARefreshArea8(ScrnInfoPtr pScrn, int num, BoxPtr pbox)
{
    VIAPtr pVia = VIAPTR(pScrn);
    int count, width, height, y1, y2, dstPitch, srcPitch;
    CARD8 *dstPtr, *srcPtr, *src;
    CARD32 *dst;
    
    if(!pVia->RotateDegree) {
        VIARefreshArea(pScrn, num, pbox);
        return;
    }

    if(pVia->RotateDegree == VIA_ROTATE_DEGREE_180) {
        VIARefreshArea_UD(pScrn, num, pbox);
        return;
    }
    
    dstPitch = pScrn->displayWidth;
    switch (pVia->RotateDegree) {
    case VIA_ROTATE_DEGREE_90:
         srcPitch = - pVia->ShadowPitch;
         break;
            
    case VIA_ROTATE_DEGREE_270:
         srcPitch = pVia->ShadowPitch;
         break;
		 
	default:
         break;
    }

    while (num--) {
        width = pbox->x2 - pbox->x1;
        y1 = pbox->y1 & ~3;
        y2 = (pbox->y2 + 3) & ~3;
        height = (y2 - y1) >> 2;  /* in dwords */

        if (pVia->RotateDegree == VIA_ROTATE_DEGREE_90) {
/* pScrn->virtualX, virtualY swapped in Rotate 90/270 degree 
 * So just use pScrn->virtualY instead of pScrn->virtualX
 * */
            dstPtr = pVia->FBBase + (pbox->x1 * dstPitch) + 
                     pScrn->virtualY - y2;
            srcPtr = pVia->ShadowPtr + ((1 - y2) * srcPitch) + pbox->x1;
        } 
        else {
/* pScrn->virtualX, virtualY swapped in Rotate 90/270 degree 
 * So just use pScrn->virtualY instead of pScrn->virtualX
 */
            dstPtr = pVia->FBBase + 
                     ((pScrn->virtualX - pbox->x2) * dstPitch) + y1;
            srcPtr = pVia->ShadowPtr + (y1 * srcPitch) + pbox->x2 - 1;
        }

        while (width--) {
            src = srcPtr;
            dst = (CARD32*) dstPtr;
            count = height;
            
            while (count--) {
                *(dst++) = src[0] | (src[srcPitch] << 8) | 
                           (src[srcPitch * 2] << 16) | 
                           (src[srcPitch * 3] << 24);
                src += srcPitch * 4;
            }
            
            switch(pVia->RotateDegree) {
            case VIA_ROTATE_DEGREE_90:
                 srcPtr += 1;
                 break;
                    
            case VIA_ROTATE_DEGREE_270:
                 srcPtr += -1;
                 break;

			default:
				 break;
            }
            
            dstPtr += dstPitch;
        }

        pbox++;
    }
} 


void
VIARefreshArea16(ScrnInfoPtr pScrn, int num, BoxPtr pbox)
{
    VIAPtr pVia = VIAPTR(pScrn);
    int count, width, height, y1, y2, dstPitch, srcPitch;
    CARD16 *dstPtr, *srcPtr, *src;
    CARD32 *dst;

    if(!pVia->RotateDegree) {
        VIARefreshArea(pScrn, num, pbox);
        return;
    }

    if(pVia->RotateDegree == VIA_ROTATE_DEGREE_180) {
        VIARefreshArea_UD(pScrn, num, pbox);
        return;
    }
    
    dstPitch = pScrn->displayWidth;
    switch (pVia->RotateDegree) {
    case VIA_ROTATE_DEGREE_90:
         srcPitch = - pVia->ShadowPitch >> 1;
         break;
            
    case VIA_ROTATE_DEGREE_270:
         srcPitch = pVia->ShadowPitch >> 1;
         break;

	default:
		 break;
    }
    
    while(num--) {
        width = pbox->x2 - pbox->x1;
        y1 = pbox->y1 & ~1;
        y2 = (pbox->y2 + 1) & ~1;
        height = (y2 - y1) >> 1;  /* in dwords */

        if (pVia->RotateDegree == VIA_ROTATE_DEGREE_90) {
            dstPtr = (CARD16*)pVia->FBBase + 
                     (pbox->x1 * dstPitch) + pScrn->virtualY - y2;
            srcPtr = (CARD16*)pVia->ShadowPtr + 
                     ((1 - y2) * srcPitch) + pbox->x1;
        } 
        else {
            dstPtr = (CARD16*)pVia->FBBase + 
                     ((pScrn->virtualX - pbox->x2) * dstPitch) + y1;
            srcPtr = (CARD16*)pVia->ShadowPtr + 
                     (y1 * srcPitch) + pbox->x2 - 1;
        }

        while (width--) {
            src = srcPtr;
            dst = (CARD32*)dstPtr;
            count = height;
            
            while (count--) {
                *(dst++) = src[0] | (src[srcPitch] << 16);
                src += srcPitch * 2;
            }

            switch(pVia->RotateDegree) {
            case VIA_ROTATE_DEGREE_90:
                 srcPtr += 1;
                 break;
                    
            case VIA_ROTATE_DEGREE_270:
                 srcPtr += -1;
                 break;

			default:
				 break;
            }
            dstPtr += dstPitch;
        }

        pbox++;
    }
}


void
VIARefreshArea32(ScrnInfoPtr pScrn, int num, BoxPtr pbox)
{
    VIAPtr pVia = VIAPTR(pScrn);
    int count, width, height, dstPitch, srcPitch;
    CARD32 *dstPtr, *srcPtr, *src, *dst;
    
    if(pVia->RotateDegree == VIA_ROTATE_DEGREE_0) {
        VIARefreshArea(pScrn, num, pbox);
        return;
    }

    if(pVia->RotateDegree == VIA_ROTATE_DEGREE_180) {
        VIARefreshArea_UD(pScrn, num, pbox);
        return;
    }

    dstPitch = pScrn->displayWidth;
    
    switch (pVia->RotateDegree) {
    case VIA_ROTATE_DEGREE_90:
         srcPitch = -pVia->ShadowPitch >> 2;
         break;
            
    case VIA_ROTATE_DEGREE_270:
         srcPitch = pVia->ShadowPitch >> 2;
         break;

    default:
		 break;
    }

    while (num--) {
        width = pbox->x2 - pbox->x1;
        height = pbox->y2 - pbox->y1;

        if (pVia->RotateDegree == VIA_ROTATE_DEGREE_90) {
    /* pScrn->virtualX, virtualY swapped in Rotate 90/270 degree*/
            dstPtr = (CARD32*)pVia->FBBase + 
                     (pbox->x1 * dstPitch) + pScrn->virtualY - pbox->y2;
            srcPtr = (CARD32*)pVia->ShadowPtr + 
                     ((1 - pbox->y2) * srcPitch) + pbox->x1;
        } 
        else {
    /* pScrn->virtualX, virtualY swapped in Rotate 90/270 degree*/
            dstPtr = (CARD32*)pVia->FBBase + 
                     ((pScrn->virtualX - pbox->x2) * dstPitch) + pbox->y1;
            srcPtr = (CARD32*)pVia->ShadowPtr + 
                     (pbox->y1 * srcPitch) + pbox->x2 - 1;
        }

        while(width--) {
            src = srcPtr;
            dst = dstPtr;
            count = height;
            
            while(count--) {
                *(dst++) = *src;
                src += srcPitch;
            }

            switch(pVia->RotateDegree) {
            case VIA_ROTATE_DEGREE_90:
                 srcPtr += 1;
                 break;
                    
            case VIA_ROTATE_DEGREE_270:
                 srcPtr += -1;
                 break;

			default:
				 break;
            }
                        
            dstPtr += dstPitch;
        }

        pbox++;
    }
}

