/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _LINUX_VIDEO_H
#define _LINUX_VIDEO_H

#include "xf86.h"           /* For ScrnInfoPtr */
#include "via_video.h"      /* For viaPortPrivPtr*/
#include "via_drm.h"

/* 
 *  Device ID Definition 
 *  3314   P4M800Pro/VN800/CN700
 *  3324   CX700
 *  3336   K8N890/K8M890
 *  3327   P4M890/VN890/CN800
 */
#define VIA_DEVICE_VT3314           0x3344
#define VIA_DEVICE_VT3324           0x3157
#define VIA_DEVICE_VT3336           0x3230
#define VIA_DEVICE_VT3327           0x3343
#define VIA_DEVICE_VT3364           0x3371
#define VIA_DEVICE_VT3353           0x1122 
#define VIA_DEVICE_VT3409           0x5122

/* 
 * Define UniChrome Family Project ID/Revision, for simplify
 * Device ID + Revision combination.                          
 * TODO: Use uni-variable capability flag to replace this.      
 */
#define UNICHROME_VT3314            0x08
#define UNICHROME_VT3324            0x09
#define UNICHROME_VT3336            0x0a
#define UNICHROME_VT3327            0x0b
#define UNICHROME_VT3364            0x0d
#define UNICHROME_VT3324M           0x0e
#define UNICHROME_VT3324M2          0x0f
#define UNICHROME_VT3353            0x10
#define UNICHROME_VT3409            0x11

#define DDPF_FOURCC     0x00000001      /* The pixel format is FOURCC*/
#define DDPF_RGB        0x00000002      /* The pixel format is RGB*/

/*
 * Defination for Video function
 */
typedef unsigned long DWORD;
typedef unsigned int  WORD;

/*
 * Structure defination for Video function
 */
typedef unsigned long (*vidSetCtrlFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetStartAddrFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetFetchFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetSrcPitchFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetDstStartFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetZoomFactorFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetDstWidthandHeightFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetFIFOFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetColorKeyFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetComposeModeFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*vidSetChromaKeyFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

typedef unsigned long (*hqvSetSrcAddrFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetDstAddrFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetAdvanceControlFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetCtrlFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetOffsetFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetSrcDataOffsetFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetSrcFetchFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetSrcPitchFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetDstPitchFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
typedef unsigned long (*hqvSetZoomFactorFuncPtr)(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

typedef struct {
    char* name;
    vidSetCtrlFuncPtr setCtrl;    
    vidSetStartAddrFuncPtr setStartAddr;
    vidSetFetchFuncPtr setFetch;
    vidSetSrcPitchFuncPtr setSrcPitch;
    vidSetDstStartFuncPtr setDstStart;
    vidSetZoomFactorFuncPtr setZoomFactor;
    vidSetDstWidthandHeightFuncPtr setDstWidthandHeight;
    vidSetFIFOFuncPtr setFIFO;
    vidSetColorKeyFuncPtr setColorKey;
    vidSetComposeModeFuncPtr setComposeMode;
    vidSetChromaKeyFuncPtr setChromaKey;
} VIAVidRegFuncRec , *VIAVidRegFuncPtr;

typedef struct {
    char * name;
    hqvSetSrcAddrFuncPtr setSrcAddr;
    hqvSetDstAddrFuncPtr setDstAddr;    
    hqvSetAdvanceControlFuncPtr setAdvanceCtrl;
    hqvSetCtrlFuncPtr setCtrl;    
    hqvSetOffsetFuncPtr setOff;
    hqvSetSrcDataOffsetFuncPtr setSrcDataOff;
    hqvSetSrcFetchFuncPtr setFetch;
    hqvSetSrcPitchFuncPtr setSrcPitch;
    hqvSetDstPitchFuncPtr setDstPitch;
    hqvSetZoomFactorFuncPtr setZoomFactor;
} VIAHqvRegFuncRec, *VIAHqvRegFuncPtr;

/*For Video HW Difference */
#define VID_HWDIFF_TRUE           0x00000001
#define VID_HWDIFF_FALSE          0x00000000

/*Video HW Difference Structure*/
typedef struct _VIDHWDIFFERENCE
{
    unsigned long dwNeedV1Prefetch;             /*V1 pre-fetch function for K8*/
    unsigned long dwNeedV3Prefetch;             /*V3 pre-fetch function for K8*/
    unsigned long dwBypassVerExpandMagnify;     /*HW bypass the expand vertical magnify.*/
                                        		/*SW need to calculate the Y magnify of video by itself.*/
    unsigned long dwBypassHorExpandMagnify;     /*HW bypass the expand horizontal magnify.*/
                                        		/*SW need to calculate the X magnify of video by itself.*/                                                 
    unsigned long dwSupportVideoVQ;             /* HW support Video VQ. only for VT3259 */
    unsigned long dwOnlyOneVideoOverlay;        /* added for only one video engine in device */
    unsigned long dwSupportYUVByPass;           /*Support CRT output YCbCr to TV encoder.*/
}VIDHWDIFFERENCE, * LPVIDHWDIFFERENCE;


typedef struct
{
    Bool    gfx3DScalingEnable;
    int     OrigHActive;
    int     OrigVActive;
    int     RealHActive;
    int     RealVActive;
    int     DISP3DScalIGAPath;

    long    XSIZEOffset;       /* the scaling offset of the size*/
    long    YSIZEOffset;
    
    long    XPOSITIONOffset;
    long    YPOSITIONOffset; 
} HW3D_Scaling_INFO;

typedef struct {
    unsigned long dwWidth;          /* On screen Width                  */
    unsigned long dwHeight;         /* On screen Height                 */
    unsigned long dwSaveWidth;      /* On screen Width for Panning      */
    unsigned long dwSaveHeight;     /* On screen Height for Panning     */
    unsigned long dwCurWidth;       /* Width set by xrandr     */
    unsigned long dwCurHeight;      /* Height set by xrandr     */   
    unsigned long dwBPP;            /* Bits Per Pixel                   */
    unsigned long dwPitch;          /* On screen pitch= width x BPP     */
    unsigned long dwRefreshRate;    /* Refresh rate of the mode         */
    unsigned long TotalVRAM;        /* Total Video RAM in unit of byte  */
    unsigned long VideoHeapBase;    /* Physical Start of video heap     */
    unsigned long VideoHeapEnd;     /* Physical End of video heap       */
    unsigned long dwExpand;    	    /* Is DVI in expand mode ?          */
    unsigned long dwPanning;    	/* Is DVI in Pannig mode ?          */
    unsigned long IsDownScaling;    /* Is down scaling enabled?         */
    unsigned long dwPanelWidth;     /* Panel physical Width             */
    unsigned long dwPanelHeight;    /* Panel physical Height            */
    unsigned long dwActiveDevice;   /* Active Device; ex. CRT or LCD    */
}SCREENINFO, * LPSCREENINFO;

typedef enum{
	VIA_XSERVEROFF = 0,
	VIA_SET_2D_INFO,
	VIA_XSERVERON,
	VIA_GET_VERSION		
}VIASYNCTYPE;

typedef struct {
    int MMIOhandle;
    unsigned long FBhandle;    
    Bool  DRMEnabled;               /* kernel module DRM flag           */
    Bool  Screen1IsLeft;            /* True: Screen1 LeftOf Screen0 ; False: Screen1 RightOf Screen0 */
    Bool  Screen1IsAbove;           /* True: Screen1 Above Screen0 ; False: Screen1 Below Screen0 */
    Bool  SAMM;                     /* True: XServer in SAMM mode  */
    Bool  IsExtend;                 /* True: XServer in RandR Extend Mode */
    int   ExtendStatus;             /* Indicate what type of extend is */
    unsigned long dwDeviceID;       /* The chip device ID */
    unsigned long dwProjectIDRevision;
    unsigned long dwActiveDevice;   /* ActiveDevice; ex. SAMM: CRT+LCD  */
    SCREENINFO  Screen[2];          /* Information for Primary & Secondary Screens*/
    unsigned long ScreenPhysAddr;   /* Physical address of Video Memory */
    unsigned long dwXServerEnabled; /* indicate if XServer On */

    short rotate,duoview;/*Xserver rotation mode 0:no,1:CW,-1:CCW. duoview for DuoView of Xserver*/
    unsigned long IGAPanningStatus; /* initial at FillGraphicInfo() */
    unsigned long Screen_IGA_Map[3]; /* Map Screen to IGA, initial at FillGraphicInfo() */
    int  samm_rotate[3];             /* Temp solution, rotate degree for Samm*/
    Bool IsHWCursorEnabled;          /* Indicate whether the HW cursor is enabled. */
    Bool IsRotationEnabled;          /* Indicate whether the Rotation function is enabled, no matter the rotation is done by SW, HW or RandR. */ 
    HW3D_Scaling_INFO iga1gfx3DScal_info;/*these two structure are used for video to get 3d scaling info from driver*/
    HW3D_Scaling_INFO iga2gfx3DScal_info;
    unsigned long xrandrEnabled;    /*indicate if xrandr on*/
    unsigned long offset_x[2];       /*two iga offset for horizontal direction*/
    unsigned long offset_y[2];       /*two iga offset for vertical direction*/
}NEWVIAGRAPHICINFO, * LPNEWVIAGRAPHICINFO;

typedef struct _VIDEOCONTROL
{
    unsigned long   dwCtlHQVflag;
}VIDEOCONTROL,*PVIDEOCONTROL;


/*
 * definition for engine management
 */
#define ENGINE_TYPE_NUM            2            /*video,HQV*/
#define ENGINE_VIDEO               0
#define ENGINE_HQV                 1

#define HAVE_INVALID               0x00000000
#define HAVE_VIDEO_1               0x00000001
#define HAVE_VIDEO_3               0x00000002
#define HAVE_HQV_0                 0x00000010
#define HAVE_HQV_1                 0x00000020

typedef struct _VIAENGMATRIX 
{
    unsigned long ulEngType;   /* Engine type ID, VID, HQV, MPEG, ...*/
    unsigned long ulEngMask;   /* Engine Capability mask, the ORD of HAVE_xxxx*/
    unsigned long ulEngStatus; /* Engine current available status, V1 is available, or V3 is available...*/
} VIAENGMATRIX,*PVIAENGMMATRIX;

typedef struct _VIAENGMGR
{
    VIAENGMATRIX ViaEngineMatrix[ENGINE_TYPE_NUM];/*video engine resources matrix*/
    Bool EngMatrixInit;
}VIAENGMGR,*PVIAENGMGR;

/* current active device connected on the iga */
typedef union _VIAActiveDevice {
    struct{
        unsigned long crt   :1;
        unsigned long lcd   :1;
        unsigned long dvi   :1;
        unsigned long lcd2  :1;
        unsigned long dvi2  :1;
    };
    unsigned long unit;
}ActiveDeviceRec, *ActiveDevicePtr;


/*---
#define VIA_IGA_PANNING               0x01
#define VIA_IGA_HWSCALING             0x02
#define VIA_IGA_3DSCALING             0x04
#define VIA_IGA_EXPANDED              0x08
---*/

/* current status of  the iga */
typedef union _VIAIGAStatus {
    struct{
        unsigned long panning      :1;
        unsigned long scaling_hw   :1;   /* by IGA, only scaling down */
        unsigned long scaling_3d   :1;    /* by 3D engine */
        unsigned long expanded     :1;    /* by IGA2, only scaling up */
    };
    unsigned long unit;
}IGAStatusRec, *IGAStatusPtr;

/*---
#ifndef VIA_ROTATE_DEGREE
#define VIA_ROTATE_DEGREE
#define VIA_ROTATE_DEGREE_0        0x00
#define VIA_ROTATE_DEGREE_90       0x01
#define VIA_ROTATE_DEGREE_180      0x02
#define VIA_ROTATE_DEGREE_270      0x04
#define VIA_ROTATE_DEGREE_ALL     \
	(VIA_ROTATE_DEGREE_0|VIA_ROTATE_DEGREE_90 |\
	VIA_ROTATE_DEGREE_180|VIA_ROTATE_DEGREE_270)
#define VIA_ROTATE_REFLECT_X       0x08
#define VIA_ROTATE_REFLECT_Y       0x10
#define VIA_ROTATE_REFLECT_ALL  \
	(VIA_ROTATE_REFLECT_X|VIA_ROTATE_REFLECT_Y)
#endif
---*/

/* current rotation status of  the iga */
typedef union _VIAIGARotateReflect {
    struct{
        unsigned long rotate_90    :1;      /* Bit 0: Rotate 90 degree */
        unsigned long rotate_180   :1;      /* Bit 1: Rotate 180 degree */
        unsigned long rotate_270   :1;      /* Bit 2: Rotate 270 degree */
        unsigned long reflect_x    :1;      /* Bit 3: Reflect X axis */
        unsigned long reflect_y    :1;      /* Bit 4: Reflect Y axis */
    };
    unsigned long unit;
}IGARotateReflectRec, *IGARotateReflectPtr;

/* all the related infomation description of the IGA */
typedef struct _VIAIGAInfo {
    Bool actived;                  /* if current iga is actived ? */
    unsigned long visible_width;   /* visible width -> panning aera width */
    unsigned long visible_height;  /* visible height -> panning area height */
    unsigned long desired_width;   /* real mode setting -> width */
    unsigned long desired_height;  /* real mode setting -> height */
    unsigned long crtc_width;      /* crtc's actual output mode timing -> HDisplay*/ 
    unsigned long crtc_height;     /* crtc's actual output mode timing -> VDisplay */
    unsigned long refreshrate;     /* the refresh rate on the iga */
    
    unsigned long start_x;         /* start point X on the iga */
    unsigned long start_y;         /* start point Y on the iga */
    ActiveDeviceRec activeDevice;  /* active devices that connected on the iga */
    IGAStatusRec  igaStatus;       /* panning, expand, hwscaling, 3dscaling status */
    IGARotateReflectRec  igaRRStatus;  /* rotation and reflection status */
    HW3D_Scaling_INFO igagfx3DScaling_info;    /* 3D scaling realted info on the iga */

    unsigned long scrnInuse;  /* Indicate which screen is associated with current iga */
}viaIGAInfoRec, *viaIGAInfoPtr;

#define VIA_SINGLEVIEW  0x00000001
#define VIA_DUOVIEW     0x00000002
#define VIA_SAMM        0x00000004
#define VIA_CLONE       0x00000002
#define VIA_EXTEND      0x00000004

/* the screen attribute description */
typedef union _VIAScreenAttr {
    struct{
        unsigned long singleview        :1;   /* both non-xrandr and xrandr */
        unsigned long duoview       :1;   /* only non-xrandr */
        unsigned long samm          :1;   /* only non-xrandr */
        unsigned long reserverd         :29;
    };
    struct{
        unsigned long singleview        :1;   /* both non-xrandr and xrandr */
        unsigned long clone         :1;   /* only xrandr */
        unsigned long extend        :1;   /* only xrandr */
        unsigned long reserverd         :29;
    };
    unsigned long uint;
}viaScreenAttrRec, *viaScreenAttrPtr;

/* the IGA attribute description */
typedef union _VIAIGAAttr {
    struct{
         /* both non-xrandr and xrandr */
         unsigned long iga2_left        :1;  /* the position relationship of IGA1 and IGA2 */
         unsigned long iga2_above       :1;
         unsigned long iga2_right       :1;
         unsigned long iga2_below       :1;
         /* only xrandr */ 
         unsigned long overlapped       :1;  /*if their display areas are overlapped? */

         unsigned long reserverd        :27;
    };
    unsigned long uint;
}viaIGAAttrRec, *viaIGAAttrPtr;
 
/* all the related information description of the Screen */
typedef struct _VIAScreenInfo {
    unsigned long bpp;          /* it is the bits per pixel of current screen */
    unsigned long rotatetype;     /* [Non_RandR] the rotate type of current screen: HW, SW */
    unsigned long fboffset_rot;   /* [Non_RandR] the offset of IGA on-screen memory */
    /* IGA1: 1, IGA2:2 IGA1+IGA2: 3 */
    unsigned long igaInuse;       /* Indicate which iga is in using by current screen */
}viaScreenInfoRec, *viaScreenInfoPtr;
 

/* the data structure that communicated between XServer/2D& Display and Xv or Ddmpeg video */
typedef struct _VIAGfxInfo{
    unsigned long chipId;             /* the gfx chip device id */
    unsigned long revisionId;         /* the gfx chip revision id */
    drm_handle_t fbhandle;            /* fb handle that DrmAddMap returned */
    drm_handle_t mmiohandle;          /* mmio handle that DrmAddMp returned */
    drm_handle_t agphandle;           /* agp handle that DrmAddMap returned */
    unsigned long fbPhybase;          /* fb physical base for non DRI case mapping. Only for DdMpeg, maybe removed later */
    unsigned long mmioPhybase;        /* mmio physical base for non DRI case mapping. Only for DdMpeg, maybe removed later */

    unsigned long fbSize;             /* fb video memory size for mapping */
    unsigned long mmioSize;
    unsigned long agpSize;
    
    unsigned long vramsize;           /* free video memory size for video memory manager */
    unsigned long vheapbase;          /* free video memory heap start */
    unsigned long vheapend;           /* free video memory heap end */

    unsigned long drmEnabled;         /* if drm is enabled ? */
    unsigned long xrandrEnabled;      /* if XRandR is enabled */
    unsigned long hwIconEnalbed;      /* if hw Icon is enabled */
    unsigned long preferedVideoIga;   /* user control : when duoview mode, only one video engine case */
    unsigned long preferedColorKey;   /* user control: the prefered color key value */

    viaScreenAttrRec screenAttr;      /* the attribute of screen */
    viaScreenInfoRec screenInfo[2];   /* FIXME! Not used current. the screen info of screen 0 and screen 1 */    
    viaIGAAttrRec  igaAttr;           /* the attribute of IGA1 and IGA2 */
    viaIGAInfoRec  igaInfo[2];        /* the iga info of IGA1 and IGA2 */
}viaGfxInfoRec, *viaGfxInfoPtr;

/**************************************************************************
 * Top level video structure*
 **************************************************************************/
typedef struct _VIDDATA
{
    VIDEOCONTROL    VidCtl;
    VIDHWDIFFERENCE VideoHWDifference;
    
    viaGfxInfoPtr   viaGfxInfo;

    VIAENGMGR       ViaEngManager;
        
    int     panning_x[2];       /* The offset value in panning mode */
    int     panning_y[2];       /* 0: for 1st screen, 1: for 2nd screen use */
    unsigned long IGA_Video_Map[3];  /* Indicate which IGA use which Video Engine, V1 or V3, initial at UpdateOverlay() */
    unsigned long Video_Hqv_Map[3];  /* Indicate which Video Engine use which Hqv Engine, HQV0 or HQV1 */

    Bool  dwRejectOverlay;     /* Flag for decide overlay support or not*/
    Bool  ColorSpaceChanged;                 /* The setting value of color space been changed by user    */
    Bool  IsSupportedColorSpaceChange;
    unsigned long ColorSpaceValue1;          /* User set color value from utility , after driver convert */
    unsigned long ColorSpaceValue2;          /* User set color value from utility , after driver convert */
    
    ViaMemRec  vidVQMem;

    ViaMMReq memRequest;

    VIAHqvRegFuncRec hqvRegFunc;
    VIAVidRegFuncRec vidRegFunc;

    OffMemRange     MemLayOutBufPool[27];
    unsigned char   AddrUnused0;
    unsigned char   AddrUsed0;    
    ViaOffScrnRec 	MemLayOut; 

    unsigned long dwVideoVQ_Offset;
    unsigned long dwVideoVQ_Size;
    unsigned long dwVQUseCount;               /* Keep VQ Request Count */       
}VIDDATA,*PVIDDATA;

void vidInitVideoInfo(PVIDDATA pVidData);
unsigned long UpdateOverlay(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, LPDDUPDATEOVERLAY lpUpdate);
unsigned long Flip(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
unsigned long updateOvl(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath, 
    LPDDUPDATEOVERLAY lpUpdate);
unsigned long flipOvl(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath);
#endif

#endif


