 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

#ifndef _VIA_TBL1636_H_
#define _VIA_TBL1636_H_ 1

#include "hw.h"


struct IODATA COMMON_INIT_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x10, 0xC0, 0x00},     /* Set panel power sequence timing */
    {0x0B, 0xFF, 0x40},     /* T1: VDD on - Data on. Each increment is 1 ms. (50ms = 031h)*/
    {0x0C, 0xFF, 0x31},     /* T2: Data on - Backlight on. Each increment is 2 ms. (210ms = 068h) */
    {0x0D, 0xFF, 0x31},     /* T3: Backlight off - Data off. Each increment is 2 ms. (210ms = 068h) */
    {0x0E, 0xFF, 0x68},     /* T4: Data off - VDD off. Each increment is 1 ms. (50ms = 031h) */
    {0x0F, 0xFF, 0x68},     /* T5: VDD off - VDD on. Each increment is 100 ms. (500ms = 04h) */
    {0x09, 0xA0, 0xA0},     /* LVDS output power up */
    {0x10, 0x33, 0x13}      /* turn on back light */
};


struct IODATA DUAL_CHANNEL_ENABLE_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x08,  0xE0, 0xE0}      /* Input Data Mode Select */
};


struct IODATA SINGLE_CHANNEL_ENABLE_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x08,  0xE0, 0x00}      /* Input Data Mode Select */
};

struct IODATA MSB_DATAFORMAT_OUTPUT[] = {
/*  Index, Mask, Value */
    {0x08,0x10,0x10}    
};

struct IODATA LSB_DATAFORMAT_OUTPUT[] = {
/*  Index, Mask, Value */
    {0x08,0x10,0x00}
};

struct IODATA DITHERING_ENABLE_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x0A,  0x70, 0x50}
};


struct IODATA DITHERING_DISABLE_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x0A,  0x70, 0x00}
};


struct IODATA VDD_ON_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x10,  0x20, 0x20}
};


struct IODATA VDD_OFF_TBL_VT1636[] = {
/*  Index, Mask, Value */
    {0x10,  0x20, 0x00}
};


#endif  /* _VIA_TBL1636_H_ */

