/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_TBLDPASETTING_H_
#define _VIA_TBLDPASETTING_H_ 1

#include "hw.h"

#define DPA_CLK_30M       30000000
#define DPA_CLK_50M       50000000
#define DPA_CLK_70M       70000000
#define DPA_CLK_100M      100000000
#define DPA_CLK_150M      150000000


enum {
    DPA_CLK_RANGE_30M,
    DPA_CLK_RANGE_30_50M,
    DPA_CLK_RANGE_50_70M,
    DPA_CLK_RANGE_70_100M,
    DPA_CLK_RANGE_100_150M,
    DPA_CLK_RANGE_150M,
};


/***********************************************************************************/
/*                  GFX DPA Setting Structure                                      */
/***********************************************************************************/
typedef struct _GFX_DPA_VALUE {
    CARD8   DVP0;               /* CR96[3:0] */
    CARD8   DVP0DataDri_S1;     /* SR2A[5]   */
    CARD8   DVP0DataDri_S;      /* SR1B[1]   */
    CARD8   DVP0ClockDri_S1;    /* SR2A[4]   */
    CARD8   DVP0ClockDri_S;     /* SR1E[2]   */
    CARD8   DVP1;               /* CR9B[3:0] */
    CARD8   DVP1Driving;        /* SR65[3:0], Data and Clock driving */
    CARD8   DFPHigh;            /* CR97[3:0] */
    CARD8   DFPLow;             /* CR99[3:0] */    
}GFX_DPA_VALUE, *GFX_DPA_VALUE_PTR;


typedef struct _GFX_DPA_INFO_TABLE {
    CARD32              ClockRangeIndex;
    GFX_DPA_VALUE_PTR   pDPASettingValue;    
}GFX_DPA_INFO_TABLE, *GFX_DPA_INFO_TABLE_PTR;


/***********************************************************************************/
/*                  Transmitter DPA Setting Structure                              */
/***********************************************************************************/

typedef struct _TRANSMITTER_DPA_INFO {
    CARD32   Index;
    CARD32*  pTransmitterDPASetting;
} TRANSMITTER_DPA_INFO, *TRANSMITTER_DPA_INFO_PTR;


typedef struct _TRANSMITTER_DPA_INDEX_TABLE {
    CARD32  ChipSet;            
    TRANSMITTER_DPA_INFO_PTR   pVT1636DPATbl;        
}TRANSMITTER_DPA_INDEX_TABLE, *TRANSMITTER_DPA_INDEX_TABLE_PTR;




/***********************************************************************************/
/*                   GFX DPA Index Table Structure                                 */
/***********************************************************************************/

typedef struct _GFX_DPA_INDEX_TABLE {
    CARD32  ChipSet;            
    GFX_DPA_INFO_TABLE_PTR   pVT1632ADPATbl;
    GFX_DPA_INFO_TABLE_PTR   pVT1636DPATbl;    
    GFX_DPA_INFO_TABLE_PTR   pHardwiredDPATbl;
}GFX_DPA_INDEX_TABLE;


/*******************************************************************************/
/*                      LVDS VT1636 Default DPA Setting                        */
/*******************************************************************************/

/* Note_1:  0xFFFFFF indicate the end of array.*/
/* Note_2:  0xData + Mask + Address            */
/* Example: 0x00   + 0F   + 08 = 0x000F08      */                                      
static CARD32 VT1636_CLK_SEL_ST_DEFAULT[] =        {0x000F08, 0x001F09, 0xFFFFFF}; 


/*******************************************************************************/
/*              Include file of DPA table by chip                              */
/*******************************************************************************/

#include "via_tblDPA_vt3324.h"
#include "via_tblDPA_vt3336.h"
#include "via_tblDPA_vt3327.h"
#include "via_tblDPA_vt3364.h"
#include "via_tblDPA_vt3353.h"

/*******************************************************************************/
/*                          GFX DPA Index Table                                */
/*******************************************************************************/

static GFX_DPA_INDEX_TABLE GFX_DPA_INDEX_TBL[] = {
    {VIA_P4M800PRO,  NULL,   NULL,                    NULL},
    {VIA_CX700,      NULL,   GFX_DPA_VT3324_VT1636,   NULL},
    {VIA_K8M890,     NULL,   GFX_DPA_VT3336_VT1636,   GFX_DPA_VT3336_HardwiredLCD},
    {VIA_P4M890,     NULL,   GFX_DPA_VT3327_VT1636,   GFX_DPA_VT3327_HardwiredLCD},
    {VIA_P4M900,     NULL,   GFX_DPA_VT3364_VT1636,   GFX_DPA_VT3364_HardwiredLCD},
    {VIA_VX800,      NULL,   GFX_DPA_VT3353_VT1636,   NULL},
    {VIA_VX855,      NULL,   GFX_DPA_VT3353_VT1636,   NULL}

};
   
#define NUM_GFX_DPA_TABLE (sizeof(GFX_DPA_INDEX_TBL)/sizeof(*(GFX_DPA_INDEX_TBL)))

/*******************************************************************************/
/*                          Transmitter DPA Index Table                        */
/*******************************************************************************/

static TRANSMITTER_DPA_INDEX_TABLE TRANSMITTER_DPA_INDEX_TBL[] = {
    {VIA_P4M800PRO, NULL},
    {VIA_CX700,     TRANSMITTER_DPA_VT3324_1636TBL},
    {VIA_K8M890,    NULL},
    {VIA_P4M890,    TRANSMITTER_DPA_VT3327_1636TBL},
    {VIA_P4M900,    NULL}
};
   
#define NUM_TRANSMITTER_DPA_TABLE (sizeof(TRANSMITTER_DPA_INDEX_TBL)/sizeof(*(TRANSMITTER_DPA_INDEX_TBL)))


#endif

