/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_TBLDPA_VT3324_H_
#define _VIA_TBLDPA_VT3324_H_ 1

/*******************************************************************************************************/
/*******************************************************************************************************/
/* The following DPA setting is for LVDS and TMDS: */

/*******************************************************************************/
/*                                   VT3324 DPA Setting                       */
/*******************************************************************************/

    /* DVP0,   DVP0DataDriving,  DVP0ClockDriving, DVP1, DVP1Driving, DFPHigh, DFPLow */
static GFX_DPA_VALUE VT3324_DEFAULT_DPA[] = {
    /* CR96,   SR2A[5], SR1B[1], SR2A[4], SR1E[2], CR9B,    SR65,    CR97,    CR99 */
    {  0x00,   0x00,    0x00,    0x00,    0x00,    0x03,    0x00,    0x00,    0x00}};

static GFX_DPA_VALUE VT3324_CLK_100_150M_DPA[] = {
    /* CR96,   SR2A[5], SR1B[1], SR2A[4], SR1E[2], CR9B,    SR65,    CR97,    CR99 */
    {  0x00,   0x00,    0x00,    0x00,    0x00,    0x08,    0x00,    0x00,    0x00}};

static GFX_DPA_VALUE VT3324_CLK_150M_DPA[] = {    
    /* CR96,   SR2A[5], SR1B[1], SR2A[4], SR1E[2], CR9B,    SR65,    CR97,    CR99 */
    {  0x00,   0x00,    0x00,    0x00,    0x00,    0x08,    0x0E,    0x00,    0x00}};


static GFX_DPA_INFO_TABLE GFX_DPA_VT3324_VT1636[] = {
    {DPA_CLK_RANGE_30M,         VT3324_DEFAULT_DPA}, 
    {DPA_CLK_RANGE_30_50M,      VT3324_DEFAULT_DPA},
    {DPA_CLK_RANGE_50_70M,      VT3324_DEFAULT_DPA}, 
    {DPA_CLK_RANGE_70_100M,     VT3324_DEFAULT_DPA},
    {DPA_CLK_RANGE_100_150M,    VT3324_CLK_100_150M_DPA}, 
    {DPA_CLK_RANGE_150M,        VT3324_CLK_150M_DPA}
};


/*******************************************************************************/
/*                      LVDS VT1636 DPA Setting                                */
/*******************************************************************************/

/* Note_1:  0xFFFFFF indicate the end of array.*/
/* Note_2:  0xData + Mask + Address            */
/* Example: 0x00   + 0F   + 08 = 0x000F08      */
static CARD32 VT1636_CLK_SEL_ST_16x12_VT3324[] =   {0x030F08, 0x0B1F09, 0xFFFFFF};
static CARD32 VT1636_CLK_SEL_ST_14x10_VT3324[] =   {0x000F08, 0x011F09, 0xFFFFFF};

static TRANSMITTER_DPA_INFO TRANSMITTER_DPA_VT3324_1636TBL[] = {
    /* Index,        Clock DeSkew Select Stage Setting                    */
    {VIA_640X480,   VT1636_CLK_SEL_ST_DEFAULT},         /* For 640x480   */
    {VIA_800X600,   VT1636_CLK_SEL_ST_DEFAULT},         /* For 800x600   */
    {VIA_1024X768,  VT1636_CLK_SEL_ST_DEFAULT},         /* For 1024x768  */
    {VIA_1280X768,  VT1636_CLK_SEL_ST_DEFAULT},         /* For 1280x768  */
    {VIA_1280X1024, VT1636_CLK_SEL_ST_DEFAULT},         /* For 1280x1024 */
    {VIA_1400X1050, VT1636_CLK_SEL_ST_14x10_VT3324},    /* For 1400x1050 */
    {VIA_1600X1200, VT1636_CLK_SEL_ST_16x12_VT3324},    /* For 1600x1200 */
    {VIA_INVALID, NULL}
};



#endif

