/*
 * Copyright 1998-2009 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2009 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


#ifndef  _VIA_TEXVIDEO_H
#define  _VIA_TEXVIDEO_H 1

#include "via_driver.h"
#include "via_dri.h"

/*===========================================================*/
#define ISPOWER2(x)       !((x)&((x) -1))

#define VIA_HQV_OUT_CLIP                   FALSE

#define TEXVIDEO_SRC_FRAME                 0
#define TEXVIDEO_SRC_EVENFILED             1
#define TEXVIDEO_SRC_ODDFILED              2

#define VIA_HQV0_INDEX                     0
#define VIA_HQV1_INDEX                     0x1000

#define Default_ColorSpaceValue1           0x13000DED
#define Default_ColorSpaceValue2           0x13171000

//YUY2 BT709 --> RGB BT709
//R = 1.875*Y + 1.75*Cr -19
//G = 1.875*Y - 0.25*Cb - 0.5*Cr -19
//B = 1.875*Y + 2.125*Cb -19
#define Default_BT709ColorSpaceValue1           0x13000EED
#define Default_BT709ColorSpaceValue2           0x14121100

//New HQV engine Color format   0x394
//
#define HQV_COLOR_FORMAT_DEFAULT       0x00000000  // For new HQV engine Fix color
#define HQV_COLOR_FORMAT_YUV444        0x00000020

// HQV CSC, tile, gamma, deblocking control   0x3DC
//
#define HQV_IMAGE_SIZE_MASK             0x000007FF
#define HQV_DEBLOCKING_ENABLE           0x08000000
#define HQV_SINGLE_BUFF         0x00000040
#define HQV_TILEMODE_512BITS    0xc0000000
#define HQV_TILEMODE_256BITS    0x80000000
#define HQV_CSC_ENABLE          0x10000000
#define HQV_CSC_RGB32           0x20000000
#define HQV_CSC_RGB16           0x00000000

#define HQV_GAMMA_ENABLE        0x02000000
#define HQV_TILE_INPUT          0x40000000

// HQV Motion Adaptive De-interlace control & Threshold (0x3E4)
// 
#define PULL_DOWN_2_2_ENABLE                        0x80000000
#define PULL_DOWN_23_32_ENABLE                      0x01000000
#define PULL_DOWN_INTER_FIELD_THRESHOLD_16          0x40000000
#define PULL_DOWN_3_2_ENABLE                        0x08000000
#define PULL_DOWN_INTRA_FIELD_THRESHOLD_FACTOR_2    0x06000000
#define PULL_DOWN_FACTOR2_4_8                       0x00040000
#define PULL_DOWN_FACTOR1_2_8                       0x00000000
#define PULL_DOWN_MIN_THRESHOLD_2                   0x00008000
#define HQV_MOTION_DETECTION_ENABLE                 0x00001000
#define HQV_MOTION_THRESHOLD_16                     0x00000800
#define HQV_EDGE_DETECTION_THRESHOLD_16             0x00000010
#define HQV_EDGE_DETECTION_ENABLE                   0x00000001

/* HQV Pull Down Hardware Parameter     0x390 */
/* HW default value */
#define PULL_DOWN_DETECTION_INTER_FIELD_THRESHOLD       0x40000000 
#define INTER_FIELD_THRESHOLD_CALCULATING_FACTOR        0x06000000
#define STATIC_JUDGMENT_NUMBER                          0x00600000
#define INCREMENT_STATIC_RECORD_FIELD_NUMBER            0x00000000
#define PULL_DOWN_FACTOR_2                              0x00010000
#define PULL_DOWN_FACTOR_1                              0x00000000
#define PULL_DOWN_DETECTION_THRESHOLD                   0x00008000
#define MOTION_DETECTION_THRESHOLD                      0x00000600
#define EDGE_DETECTION_THRESHOLD                        0x00000080
#define BLOCK_BOUNDARY_MAX_DIFF                         0x00000008

/* HQV H Scale Control Register 0x3B0 (VT3293/33553/3409) */
#define HQV_H_NEWSCALE_ENABLE 0x80000000
#define HQV_H_NEWSCALE_UP     0x00000000  
#define HQV_H_NEWSCALE_DOWN_DIV4_TO_1       0x10000000 
#define HQV_H_NEWSCALE_DOWN_DIV8_TO_DIV4    0x20000000 
#define HQV_H_NEWSCALE_DOWN_UNDER_DIV8      0x30000000

/* HQV V Scale Control Register 0x3B4 (VT3293/33553/3409) */  
#define HQV_V_NEWSCALE_ENABLE     0x80000000
#define HQV_V_NEWSCALE_UP         0x00000000
#define HQV_V_NEWSCALE_DOWN       0x10000000

/* HQV Scaling Control Register 0x3E8 (VT3259/3324) */
/* #define HQV_H_SCALE_ENABLE      0x00000800 */
#define HQV_H_DOWN_SCALE        0x00001000
#define HQV_H_UP_SCALE          0x00000800
/* #define HQV_V_SCALE_ENABLE      0x08000000 */
#define HQV_V_DOWN_SCALE        0x10000000
#define HQV_V_UP_SCALE          0x08000000


#define VIA_SYNCWAITTIMEOUT 50000      /* Might be a bit conservative */
/*
 *      Macros for Video MMIO
 */
#define TexVInB(port)            *((volatile unsigned char *)(mmioBase + (port)))
#define TexVInW(port)            *((volatile unsigned short *)(mmioBase + (port)))
#define TexVInD(port)            *((volatile CARD32 *)(mmioBase + (port)))
#define TexVOutB(port, data)     *((volatile unsigned char *)(mmioBase + (port))) = (data)
#define TexVOutW(port, data)     *((volatile unsigned short *)(mmioBase + (port))) = (data)
#define TexVOutD(port, data)     *((volatile CARD32 *)(mmioBase + (port))) = (data)

#endif

