/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*
 * I N C L U D E S
 */
#include "Xproto.h"     /* For Xextension */
#include "extnsionst.h" /* For Xextension */
#include "dixstruct.h"  /* For Xextension */
#include "via_driver.h"
#include "via_utility.h"
#include "via_video.h"
#include "via_eng_regs.h"
#include "via_rotate.h"
#include "via_include.h"


/* Extern Functions Prototypes Declaration */
extern Bool VIAEnumModes(VIABIOSInfoPtr pBIOSInfo, int IndexOfTable, VIASUPPORTMODE *pVIASupportMode, Bool *pIsSupported);
extern void VIAEnumRefreshRate(int ModeIndex, int RefreshRateNum, int *pRefreshRate);
extern void VIAHideCursor(ScrnInfoPtr pScrn);
extern void VIAShowCursor(ScrnInfoPtr pScrn);
extern void VIALoadIconImage(ScrnInfoPtr pScrn, CARD32 * src);

extern int gVIAEntityIndex;
extern NEWVIAGRAPHICINFO NEWVIAGraphicInfo;

VIABIOSInfoPtr pBIOSInfo_local;

/* Record screen number. */
int g_ScreenNumber;

extern Bool via_module_loaded;


/* 
    Driver keep a device list but utility keep a different list,
    so we must do a mapping operation from driver to utility.
*/
int MapFunStateForUT(int FunStateForDrv)
{
    int FunStateForUT;

    if (FunStateForDrv & VIA_DEVICE_CRT1)
        FunStateForUT = (FunStateForDrv - VIA_DEVICE_CRT1) | UT_DEVICE_CRT1;
    
    if (FunStateForDrv & VIA_DEVICE_LCD)
        FunStateForUT = (FunStateForDrv - VIA_DEVICE_LCD) | UT_DEVICE_LCD;
    
    if (FunStateForDrv & VIA_DEVICE_DFP)
        FunStateForUT = (FunStateForDrv - VIA_DEVICE_DFP) | UT_DEVICE_DFP;
    
    if (FunStateForDrv & VIA_DEVICE_DFP2)
        FunStateForUT = (FunStateForDrv - VIA_DEVICE_DFP2) | UT_DEVICE_DFP2;

    return FunStateForUT;
}

/* 
    Driver keep a device list but utility keep a different list,
    so we must do a mapping operation from driver to utility.
*/
CARD32 MapDeviceStateForUT(CARD32 DeviceStateForDrv)
{
    CARD32 DeviceStateForUT = 0;

    if (DeviceStateForDrv & VIA_DEVICE_CRT1)
        DeviceStateForUT |= UT_DEVICE_CRT1;

    if (DeviceStateForDrv & VIA_DEVICE_LCD)
        DeviceStateForUT |= UT_DEVICE_LCD;

    if (DeviceStateForDrv & VIA_DEVICE_DFP)
        DeviceStateForUT |= UT_DEVICE_DFP;   

    if (DeviceStateForDrv & VIA_DEVICE_LCD2)
        DeviceStateForUT |= UT_DEVICE_LCD2;

    if (DeviceStateForDrv & VIA_DEVICE_DFP2)
        DeviceStateForUT |= UT_DEVICE_DFP2;

    return DeviceStateForUT;

}


CARD32 MapDeviceStateForDrv(CARD32 DeviceStateForUT)
{
    CARD32 DeviceStateForDrv = 0;

    if (DeviceStateForUT & UT_DEVICE_CRT1)
        DeviceStateForDrv |= VIA_DEVICE_CRT1;

    if (DeviceStateForUT & UT_DEVICE_LCD)
        DeviceStateForDrv |= VIA_DEVICE_LCD;

    if (DeviceStateForUT & UT_DEVICE_DFP)
        DeviceStateForDrv |= VIA_DEVICE_DFP;

    if (DeviceStateForUT & UT_DEVICE_LCD2)
        DeviceStateForDrv |= VIA_DEVICE_LCD2;

    if (DeviceStateForUT & UT_DEVICE_DFP2)
        DeviceStateForDrv |= VIA_DEVICE_DFP2;

    return DeviceStateForDrv;

}



ScrnInfoPtr VIAScreenSelection(ScrnInfoPtr pScrn,
                                   CARD32 dwPrimaryID,
                                   CARD32 dwSecondaryID)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAScreenSelection\n"));

    DevUnion* pPriv = xf86GetEntityPrivate(pScrn->entityList[0], gVIAEntityIndex);
    VIAEntPtr pVIAEnt = pPriv->ptr;
    VIAPtr pVia0 = VIAPTR(pVIAEnt->pPrimaryScrn);    

    /* Both LCD and DVI use this kind of utility function. So when application 
       call this kind of function. we must switch to the driver which device 
       dependent.*/
    if (dwPrimaryID == UT_XV_FUNC_PANEL)
    {        
        if (pVia0->ActiveDevice & VIA_DEVICE_LCD)
        {
            if (pVia0->ActiveDevice & VIA_DEVICE_LCD2){                
                /* If using dual LCD, we always return secondary screen because
                   of IGA2.*/
                return pVIAEnt->pSecondaryScrn;                   
            }
            
            if (pVia0->pBIOSInfo->PrimaryDevice == VIA_DEVICE_LCD){                
                DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                      "LCD in primary.\n"));
                return pVIAEnt->pPrimaryScrn;
            }else{
                DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                      "LCD in secondary.\n"));
                return pVIAEnt->pSecondaryScrn;
            }
        }
        
        if (pVia0->ActiveDevice & VIA_DEVICE_DFP)
        {
            if (pVia0->pBIOSInfo->PrimaryDevice == VIA_DEVICE_DFP){
                DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                      "DVI in primary.\n"));
                return pVIAEnt->pPrimaryScrn;
            }else{
                DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
                      "DVI in secondary.\n"));
                return pVIAEnt->pSecondaryScrn;
            }
        }

    }
    else
    {
        DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "Not Change.\n"));
        return pScrn;
    }
    return pScrn;
}


void VIA_UT_BIOS_GetChipID(ScrnInfoPtr pScrn,
                                  CARD32* pdwChipID)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIA_UT_BIOS_GetChipID\n"));
    VIAPtr pVia = VIAPTR(pScrn);    
    *pdwChipID = pVia->ChipId;
}

void VIA_UT_BIOS_GetVersion(ScrnInfoPtr pScrn,
                                   UTBIOSVERSION* pUTBIOSVERSION)
{
    VIAPtr pVia = VIAPTR(pScrn);

    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIA_UT_BIOS_GetVersion\n"));

    pUTBIOSVERSION->dwVersion = pVia->pChipInfo->biosVerMajorNum;
    pUTBIOSVERSION->dwRevision = pVia->pChipInfo->biosVerMinorNum;
}

void VIA_UT_BIOS_GetDate(ScrnInfoPtr pScrn,
                                UTBIOSDATE* pUTBIOSDATE)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIA_UT_BIOS_GetDate\n"));
    VIAPtr pVia = VIAPTR(pScrn);
    
    if (!pVia->pChipInfo->biosDateYear)
        BIOS_GetBIOSDate(pScrn);

    pUTBIOSDATE->dwYear = (CARD32)pVia->pChipInfo->biosDateYear + 2000;
    pUTBIOSDATE->dwMonth = (CARD32)pVia->pChipInfo->biosDateMonth;
    pUTBIOSDATE->dwDay = (CARD32)pVia->pChipInfo->biosDateDay;
}


void VIA_UT_BIOS_GetVideoMemSizeMB(ScrnInfoPtr pScrn,
                                              CARD32* pdwVideoRam)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, 
          "VIA_UT_BIOS_GetVideoMemSizeMB\n"));
    
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    DevUnion* pPriv;
    VIAEntPtr pVIAEnt;
    pPriv = xf86GetEntityPrivate(pScrn->entityList[0], gVIAEntityIndex);
    pVIAEnt = pPriv->ptr;
    
    *pdwVideoRam = pScrn->videoRam >> 10;
    
    if (pBIOSInfo->SAMM) {
        *pdwVideoRam = (pVIAEnt->pPrimaryScrn->videoRam >> 10) +
                       (pVIAEnt->pSecondaryScrn->videoRam >> 10);
    }
}



Bool VIA_UT_DRIVER_GetFileName(CARD32 dwDriverType,
                                        char* szDriverName)
{
    DEBUG(ErrorF("VIA_UT_DRIVER_GetFileName\n"));
    int ret = 0;    
    
    char DISPLAY_DRIVER_NAME[] = "via_drv.o     \0";
    char VDO_CAPTURE_DRIVER_NAME[] = "via_v4l_drv.o\0";
    char HWOVERLAY_DRIVER_NAME[] = "libddmpeg.a\0";
    char HWMPEG2_DECODER_NAME[] = "libddmpeg.so\0";

#ifdef XORG_VERSION_CURRENT        
    memcpy(DISPLAY_DRIVER_NAME, "via_drv.so    \0", 15);
    memcpy(VDO_CAPTURE_DRIVER_NAME, "via_v4l_drv.so\0", 15);
#endif

    switch(dwDriverType)
    {
        case DISPLAY_DRIVER :            
            memcpy((void *)szDriverName, (void *)DISPLAY_DRIVER_NAME,
                   sizeof(DISPLAY_DRIVER_NAME));                        
            ret = TRUE;
            break;
            
        case VIDEO_CAPTURE_DRIVER :            
            memcpy((void *)szDriverName, (void *)VDO_CAPTURE_DRIVER_NAME,
                   sizeof(VDO_CAPTURE_DRIVER_NAME));
            ret = TRUE;
            break;
            
        case HWOVERLAY_DRIVER :            
            memcpy((void *)szDriverName, (void *)HWOVERLAY_DRIVER_NAME,
                    sizeof(HWOVERLAY_DRIVER_NAME));
            ret = TRUE;
            break;
            
        case HWMPEG2_DECODER :            
            memcpy((void *)szDriverName, (void *)HWMPEG2_DECODER_NAME,
                    sizeof(HWMPEG2_DECODER_NAME));
            ret = TRUE;
            break;
            
        default:
            ret = FALSE;
            break;
    }

    return ret;
}


Bool VIA_UT_DRIVER_GetFileVersion(ScrnInfoPtr pScrn,
                                          CARD32 dwDriverType,
                                          UTDriverVersion* pUTDriverVersion)
{    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "VIA_UT_DRIVER_GetFileVersion\n"));
    
    VIAPtr pVia = VIAPTR(pScrn);
    int ret = 0;
    
    switch(dwDriverType)
    {
        case DISPLAY_DRIVER :            
            pUTDriverVersion->dwMajorNum = VERSION_MAJOR;
            pUTDriverVersion->dwMinorNum = VERSION_MINOR;
            pUTDriverVersion->dwOSNum = VERSION_OS;                            

            /* Driver sub version number, Trunk: 0xff*/
            pUTDriverVersion->dwReversionNum = PATCHLEVEL;

            ret = TRUE;
            break;
            
        case VIDEO_CAPTURE_DRIVER :
        {
            
            unsigned int driver_version;

            if (via_module_loaded){
                 //vvaSyncInfo(&driver_version, VIA_VID_GET_VERSION);
                 vvaSyncInfo(&driver_version, VIA_GET_VERSION);
            }
                
            pUTDriverVersion->dwMajorNum = (driver_version & 0xff000000)>>24;
            pUTDriverVersion->dwMinorNum = (driver_version & 0x00ff0000)>>16;
            pUTDriverVersion->dwOSNum = (driver_version & 0x0000ff00)>>8;
            pUTDriverVersion->dwReversionNum = (driver_version & 0x000000ff);
            ret = TRUE;
            break;
        }
        
        case HWOVERLAY_DRIVER :            
            pUTDriverVersion->dwMajorNum = VERSION_MAJOR;
            pUTDriverVersion->dwMinorNum = VERSION_MINOR;
            pUTDriverVersion->dwOSNum = VERSION_OS;
            pUTDriverVersion->dwReversionNum = PATCHLEVEL;
            ret = TRUE;
            break;
            
        case HWMPEG2_DECODER :            
            pUTDriverVersion->dwMajorNum = VERSION_MAJOR;
            pUTDriverVersion->dwMinorNum = VERSION_MINOR;
            pUTDriverVersion->dwOSNum = VERSION_OS;
            pUTDriverVersion->dwReversionNum = PATCHLEVEL;
            ret = TRUE;
            break;
        default:
            ret = FALSE;
            break;
    }

    return ret;
}


CARD32 VIA_UT_DEVICE_GetPanningState(VIABIOSInfoPtr pBIOSInfo)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetPanningState\n"));
    
    CARD32 PanningState = 0;
    
    if ((pBIOSInfo->ActiveDevice & VIA_DEVICE_CRT1) &&
        (pBIOSInfo->CRTSettingInfo.IsPanning)){
        PanningState |= UT_DEVICE_CRT1;
    }

    if ((pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD) &&
        (pBIOSInfo->LVDSSettingInfo.IsPanning)){
        PanningState |= UT_DEVICE_LCD;
    }

    if ((pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD2) &&
        (pBIOSInfo->LVDSSettingInfo2.IsPanning)){
        PanningState |= UT_DEVICE_LCD2;
    }
    
    if ((pBIOSInfo->ActiveDevice & VIA_DEVICE_DFP) &&
        (pBIOSInfo->TMDSSettingInfo.IsPanning)){
        PanningState |= UT_DEVICE_DFP;
    }

    return PanningState;
}


void VIA_UT_DISPLAY_EnumModes(VIABIOSInfoPtr pBIOSInfo,
                                        CARD32 ModeNum, LPUTDEVMODE lpDevMode)
{
    VIASUPPORTMODE SupportMode;
    int index = 0, count = -1, RefreshRateNum;
    Bool IsSupported;

    while (VIAEnumModes(pBIOSInfo, index, &SupportMode, &IsSupported))
    {
        if (SupportMode.ModeIndex == -1)
        {
            lpDevMode->ModeIndex = M_INVALID;
            lpDevMode->PelsWidth = 0;
            lpDevMode->PelsHeight = 0;
            break;
        }        

        if (IsSupported)
        {
            count++;

            if (count == ModeNum)
            {
                lpDevMode->ModeIndex = SupportMode.ModeIndex;
                lpDevMode->PelsWidth = SupportMode.HActive;
                lpDevMode->PelsHeight = SupportMode.VActive;

                /* Enumerate supported refresh rates: */
                if ((pBIOSInfo->ActiveDevice & VIA_DEVICE_DFP) || 
                    (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD))
                {
                    /* Currently, we only support 60Hz for DVI, LCD . */
                    lpDevMode->RefreshRate[0] = 60;
                    lpDevMode->RefreshRateNum = 1;
                }
                else
                {
                    RefreshRateNum = 0;
                    
                    while (1)
                    {
                        VIAEnumRefreshRate(SupportMode.ModeIndex, 
                                           RefreshRateNum,
                                           &(lpDevMode->RefreshRate[RefreshRateNum]));

                        if (lpDevMode->RefreshRate[RefreshRateNum] == 0)
                            break;

                        RefreshRateNum++;
                    }

                    lpDevMode->RefreshRateNum = RefreshRateNum;
                }
                
                break;
            }
        }

        index++;
    }
}


void VIA_UT_DISPLAY_GetCurrentMode(VIABIOSInfoPtr pBIOSInfo,
                                             LPUTDEVMODE lpDevMode)
{    
    lpDevMode->ModeIndex = VIAGetModeIndex(pBIOSInfo->CrtcHDisplay,
                                           pBIOSInfo->CrtcVDisplay);
    lpDevMode->PelsWidth = pBIOSInfo->CrtcHDisplay;
    lpDevMode->PelsHeight = pBIOSInfo->CrtcVDisplay;
    lpDevMode->RefreshRateNum = 1;
    lpDevMode->RefreshRate[0] =  pBIOSInfo->FoundRefresh;
}

void VIA_UT_DISPLAY_GetRotationCaps(ScrnInfoPtr pScrn,
                                              CARD32 RotateType,
                                              CARD32* pRotationCaps)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, 
          "VIA_UT_DISPLAY_GetRotationCaps\n"));
    
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    *pRotationCaps = UT_ROTATE_NONE;

    switch (RotateType)
    {
        case UT_ROTATE_TYPE_HW:
            if (IsSupportDirectAccessWindow(pBIOSInfo->Chipset)){
                *pRotationCaps = UT_ROTATE_90_DEG | 
                                 UT_ROTATE_180_DEG |
                                 UT_ROTATE_270_DEG;
            }            
            break;
            
        case UT_ROTATE_TYPE_SW:
            *pRotationCaps = UT_ROTATE_90_DEG |
                             UT_ROTATE_180_DEG |
                             UT_ROTATE_270_DEG;
            break;
    }
    
}


void VIA_UT_DISPLAY_GetCurrentRotateDegree(ScrnInfoPtr pScrn,
                                                       CARD32* RotateType,
                                                       CARD32* RotateDegree)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "VIA_UT_DISPLAY_GetCurrentMode\n"));
    
    VIAPtr pVia = VIAPTR(pScrn);

    if (pVia->IsHWRotateEnabled){
        *RotateType = UT_ROTATE_TYPE_HW;                     
        
        switch (pVia->RotateDegree)
        {
            case VIA_ROTATE_DEGREE_90:
                *RotateDegree = UT_ROTATE_90_DEG;
                break;
                
            case VIA_ROTATE_DEGREE_180:
                *RotateDegree = UT_ROTATE_180_DEG;
                break;
                
            case VIA_ROTATE_DEGREE_270:
                *RotateDegree = UT_ROTATE_270_DEG;
                break;
        }        
    }
    else if (pVia->RotateDegree && pVia->shadowFB && pVia->NoAccel)
    {        
        *RotateType = UT_ROTATE_TYPE_SW;
    
        switch (pVia->RotateDegree)
        {
            case VIA_ROTATE_DEGREE_90:
                *RotateDegree = UT_ROTATE_90_DEG;
                break;
                
            case VIA_ROTATE_DEGREE_180:
                *RotateDegree = UT_ROTATE_180_DEG;
                break;
                
            case VIA_ROTATE_DEGREE_270:
                *RotateDegree = UT_ROTATE_270_DEG;
                break;
        } 
    }
    else
    {
        *RotateType = UT_ROTATE_TYPE_NONE;
        *RotateDegree = UT_ROTATE_NONE;
    }
}


Bool VIA_UT_DISPLAY_SetRotateDegree(ScrnInfoPtr pScrn,
                                              CARD32 RotateDegree)
{   
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "VIA_UT_DISPLAY_SetRotateDegree\n"));
    return TRUE;
}


void VIA_UT_DEVICE_GetPanelInfo(VIABIOSInfoPtr pBIOSInfo,
                                        CARD32 dwPanelType,
                                        UTPANELINFO* pPanelInfo)
{
    int dwPanelSize;
    
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetPanelInfo\n"));       

    pPanelInfo->dwType = UT_PANEL_TYPE_TFT;

    /* utility should add parameter for
       distinguish get LCD or DFP info. Before utility change
       query panel info. parameter. we patch this according
       desktop or mobile version. */
    /* Add parameter to distinguish 
       getting LCD or DFP information. */
    switch (dwPanelType)
    {
        case UT_DEVICE_LCD:
            dwPanelSize = pBIOSInfo->LVDSSettingInfo.PanelSizeID;
            pPanelInfo->dwResX = VIA_PANEL_WIDTH(dwPanelSize);
            pPanelInfo->dwResY = VIA_PANEL_HEIGHT(dwPanelSize);
            pPanelInfo->dwDeviceID = UT_DEVICE_LCD;
            break;
            
        case UT_DEVICE_DFP:
            VIAGetModeSizeByIndex(pBIOSInfo->TMDSSettingInfo.DFPSize,
                                  &pPanelInfo->dwResX, &pPanelInfo->dwResY);
            pPanelInfo->dwDeviceID = UT_DEVICE_DFP;            
            break;
              
    }
    
    if (dwPanelSize == 0) {
            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "Unknown Panel Size!\n"));
    }
}


void VIA_UT_DEVICE_GetSupportExpand(VIABIOSInfoPtr pBIOSInfo,
                                               CARD32* pdwSupportState)
{
    int panel_w=0, panel_h=0;
    
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetSupportExpand\n"));
    /* Don't support expansion if LCD uses IGA1. */
    if ((pBIOSInfo->LVDSSettingInfo.ChipID) &&
        ((pBIOSInfo->LVDSSettingInfo.IGAPath != IGA1) ||
         (pBIOSInfo->LVDSSettingInfo2.ChipID)))
    {
        panel_w = VIA_PANEL_WIDTH(pBIOSInfo->LVDSSettingInfo.PanelSizeID);
        panel_h = VIA_PANEL_HEIGHT(pBIOSInfo->LVDSSettingInfo.PanelSizeID);
        *pdwSupportState = (pBIOSInfo->SaveHDisplay < panel_w ||pBIOSInfo->SaveVDisplay < panel_h) ?
                                UT_PANEL_SUPPORT_EXPAND_ON :
                                UT_PANEL_SUPPORT_EXPAND_OFF;
    }
    else
        *pdwSupportState = UT_PANEL_SUPPORT_EXPAND_OFF;
    
}


void VIA_UT_DEVICE_GetExpandState(VIABIOSInfoPtr pBIOSInfo,
                                            CARD32* dwExpandState)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetExpandState\n"));
    
    if (pBIOSInfo->SAMM)
    {
        if (pBIOSInfo->ActiveDevice == VIA_DEVICE_LCD)
        {
            if (pBIOSInfo->LVDSSettingInfo.Center)
                *dwExpandState = UT_STATE_EXPAND_OFF;
            else
                *dwExpandState = UT_STATE_EXPAND_ON;

            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "LCD:VIA_UT_DEVICE_GetExpandState = %d\n",*dwExpandState));
        }
        else if (pBIOSInfo->ActiveDevice == VIA_DEVICE_LCD2)
        {
            if (pBIOSInfo->LVDSSettingInfo2.Center)
                *dwExpandState = UT_STATE_EXPAND_OFF;
            else
                *dwExpandState = UT_STATE_EXPAND_ON;

            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "LCD2:VIA_UT_DEVICE_GetExpandState = %d\n",*dwExpandState));
        }
    }
    else /* Single or Duoview */
    {
        if (pBIOSInfo->ActiveDevice == (VIA_DEVICE_LCD|VIA_DEVICE_LCD2))
        {
            if (pBIOSInfo->LVDSSettingInfo2.Center)
                *dwExpandState = UT_STATE_EXPAND_OFF;
            else
                *dwExpandState = UT_STATE_EXPAND_ON;
            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "LCD2:VIA_UT_DEVICE_GetExpandState = %d\n",*dwExpandState));
        }
        else
        {
            if (pBIOSInfo->LVDSSettingInfo.Center)
                *dwExpandState = UT_STATE_EXPAND_OFF;
            else
                *dwExpandState = UT_STATE_EXPAND_ON;

            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "LCD:VIA_UT_DEVICE_GetExpandState = %d\n",*dwExpandState));            
        }        
    }
}


Bool VIA_UT_DEVICE_SetExpandState(VIABIOSInfoPtr pBIOSInfo,
                                           DisplayModePtr mode,
                                           UTPANELINFO UTPanelInfo)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_SetExpandState\n"));
    
    if (UTPanelInfo.dwExpandState == UT_STATE_EXPAND_OFF)
    {
        if (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD)
            pBIOSInfo->LVDSSettingInfo.Center = TRUE;

        if (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD2)
            pBIOSInfo->LVDSSettingInfo2.Center = TRUE;
        
        pBIOSInfo->s3utility=TRUE;                        
    }
    else if (UTPanelInfo.dwExpandState == UT_STATE_EXPAND_ON)
    {
        if (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD)
            pBIOSInfo->LVDSSettingInfo.Center = FALSE;

        if (pBIOSInfo->ActiveDevice & VIA_DEVICE_LCD2)
            pBIOSInfo->LVDSSettingInfo2.Center = FALSE;
        
        pBIOSInfo->s3utility=TRUE;                                       
    }
    else
        return FALSE;
    
    VIASaveUserSetting(pBIOSInfo);
    VIASwitchMode(pBIOSInfo->scrnIndex, mode, 0);
    
    return TRUE;
}
void VIA_UT_DEVICE_GetPanleMaxViewSizeValue(VIABIOSInfoPtr pBIOSInfo,
                                                        UTXYVALUE* pMaxViewSizeValue,
                                                        CARD32 dwDeviceType)
{
    xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
               "VIA_UT_DEVICE_GetPanleMaxViewSizeValue\n");

   CARD32  dwDevice;
   VIA3DSclSCNParasPtr   pTagert3DScalInfo = NULL;

   /* Convert utility's device ID into driver's device ID. */
   dwDevice = MapDeviceStateForDrv(dwDeviceType);
   
    switch (dwDevice)
    {
        case VIA_DEVICE_DFP:
            pTagert3DScalInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
            break;

        case VIA_DEVICE_LCD:
            pTagert3DScalInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);
            break;
    }

    if (pBIOSInfo->Is3DScalingEnable & dwDevice)
    {
        pMaxViewSizeValue->dwX = pTagert3DScalInfo->XScaleMaximum;
        pMaxViewSizeValue->dwY = pTagert3DScalInfo->YScaleMaximum;
        xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                   "VIA_UT__DEVICE_GetPanleMaxViewSizeValue: MaxX=%lu,MaxY=%lu\n",
                   pMaxViewSizeValue->dwX,pMaxViewSizeValue->dwY);           
    }
    else
    {
        pMaxViewSizeValue->dwX = 0;
        pMaxViewSizeValue->dwY = 0;
    }
}

void VIA_UT_DEVICE_GetPanleViewSizeValue(VIABIOSInfoPtr pBIOSInfo,
                                                    UTXYVALUE* pViewSizeValue,
                                                    CARD32 dwDeviceType)
{
    xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
               "VIA_UT_DEVICE_GetPanleViewSizeValue\n");

    CARD32  dwDevice;
    VIA3DSclSCNParasPtr   pTagert3DScalInfo = NULL;

    /* Convert utility's device ID into driver's device ID. */
    dwDevice = MapDeviceStateForDrv(dwDeviceType);
    
    switch (dwDevice)
    {
         case VIA_DEVICE_DFP:
             pTagert3DScalInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
             break;

         case VIA_DEVICE_LCD:
             pTagert3DScalInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);
             break;
    }

    if (pBIOSInfo->Is3DScalingEnable & dwDevice)
    {
        pViewSizeValue->dwX = pTagert3DScalInfo->XScaleLevel;
        pViewSizeValue->dwY = pTagert3DScalInfo->YScaleLevel;  
        xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, 
                   "GetViewSizeValue: X=%lu,Y=%lu\n",
                   pViewSizeValue->dwX,pViewSizeValue->dwY);   
    }
    else
    {
        pViewSizeValue->dwX = 0;
        pViewSizeValue->dwY = 0;
    } 

}

Bool VIA_UT_DEVICE_SetPanleViewSizeValue(VIABIOSInfoPtr pBIOSInfo,
                                                   UTXYVALUE ViewSizeValue,
                                                   CARD32 dwDeviceType)
{
    CARD32  dwDevice;
    int IGAPath = 0;
    VIA3DSclSCNParasPtr   pTagert3DScalInfo = NULL;
    ScrnInfoPtr pScrn = xf86Screens[pBIOSInfo->scrnIndex];
    VIAPtr      pVia = VIAPTR(pScrn);
    viaGfxInfoPtr viaGfxInfo = pVia->pVidData->viaGfxInfo;
    
     /* Convert utility's device ID into driver's device ID. */
    dwDevice = MapDeviceStateForDrv(dwDeviceType);
     
    switch (dwDevice)
    {
         case VIA_DEVICE_DFP:
             pTagert3DScalInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
             IGAPath = pBIOSInfo->TMDSSettingInfo.IGAPath;
             break;

         case VIA_DEVICE_LCD:
             pTagert3DScalInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);
             IGAPath = pBIOSInfo->LVDSSettingInfo.IGAPath;
             break;
    }

    if (pBIOSInfo->Is3DScalingEnable & dwDevice)
    {
        DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
              "VIA_UT_Panel_SetViewSizeValue:Y=%lu, X=%lu \n",
              ViewSizeValue.dwY, ViewSizeValue.dwX));
         
        if (ViewSizeValue.dwY == 0xFFFF || ViewSizeValue.dwX == 0xFFFF)
        {
            ViewSizeValue.dwX = pTagert3DScalInfo->XScaleDefault;
            ViewSizeValue.dwY = pTagert3DScalInfo->YScaleDefault;
            pTagert3DScalInfo->XScaleLevel = pTagert3DScalInfo->XScaleDefault;
            pTagert3DScalInfo->YScaleLevel = pTagert3DScalInfo->YScaleDefault;
        }
        pTagert3DScalInfo->XScaleLevel = ViewSizeValue.dwX;
        pTagert3DScalInfo->YScaleLevel = ViewSizeValue.dwY;
        pTagert3DScalInfo->XSIZEOffset = (pTagert3DScalInfo->XScaleDefault - pTagert3DScalInfo->XScaleLevel)*pTagert3DScalInfo->XScaleStep;
        pTagert3DScalInfo->YSIZEOffset = (pTagert3DScalInfo->YScaleDefault - pTagert3DScalInfo->YScaleLevel)*pTagert3DScalInfo->YScaleStep;
    
        pTagert3DScalInfo->XSIZENow = pTagert3DScalInfo->XSIZEMax - (pTagert3DScalInfo->XScaleLevel*pTagert3DScalInfo->XScaleStep);
        pTagert3DScalInfo->YSIZENow = pTagert3DScalInfo->YSIZEMax - (pTagert3DScalInfo->YScaleLevel*pTagert3DScalInfo->YScaleStep);        
    
        pTagert3DScalInfo->bNeedBlack3dScalingBorders =TRUE;
        if(!pVia->useRandR && pVia->pScreensPublicInfo->UseHwCursor)
        {
            VIAHideCursor(pScrn);
            hw3d_CursorPositionUpdate(pBIOSInfo);
            VIALoadIconImage(pScrn, (CARD32 *)(pVia->FBBase + pVia->pScreensPublicInfo->CursorInfo.HIBufStart));
            VIAShowCursor(pScrn);
        }

        viaGfxInfo->igaInfo[IGAPath-1].igagfx3DScaling_info.XSIZEOffset = pTagert3DScalInfo->XSIZEOffset; 
        viaGfxInfo->igaInfo[IGAPath-1].igagfx3DScaling_info.YSIZEOffset = pTagert3DScalInfo->YSIZEOffset;        

        if (via_module_loaded)
        {
            TranslateGFXInfo(viaGfxInfo, &NEWVIAGraphicInfo);
            if(FALSE == vvaSyncInfo(&NEWVIAGraphicInfo, VIA_SET_2D_INFO))
            {
                return FALSE;
            }               
        }

        VIAAdjustFrame(pScrn->scrnIndex, pScrn->frameX0, pScrn->frameY0, 0);
        /*Need to add the function for DVI/LCD and so on*/          
        VIASaveUserSetting(pBIOSInfo);        
   
    }
    return TRUE;
}

void VIA_UT_DEVICE_GetPanleMaxViewPositionValue(VIABIOSInfoPtr pBIOSInfo,
                                                            UTXYVALUE* pMaxViewPosValue,
                                                            CARD32 dwDeviceType)
{
    CARD32  dwDevice;
    VIA3DSclSCNParasPtr   pTagert3DScalInfo = NULL;
     /* Convert utility's device ID into driver's device ID. */
    dwDevice = MapDeviceStateForDrv(dwDeviceType);
    switch (dwDevice)
    {
         case VIA_DEVICE_DFP:
             pTagert3DScalInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
             break;
             
         case VIA_DEVICE_LCD:
             pTagert3DScalInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);	
             break;
    }

    xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
               "VIA_UT__DEVICE_GetPanleMaxViewSizeValue\n");
    
    if (pBIOSInfo->Is3DScalingEnable & dwDevice)
    {
        pMaxViewPosValue->dwX = pTagert3DScalInfo->XPOSITIONMaximum;
        pMaxViewPosValue->dwY = pTagert3DScalInfo->YPOSITIONMaximum;
        xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, 
                   "VIA_UT__DEVICE_GetPanleMaxViewSizeValue: MaxX=%lu,MaxY=%lu\n",
                   pMaxViewPosValue->dwX, pMaxViewPosValue->dwY);           
    }
    else
    {
        pMaxViewPosValue->dwX = 0;
        pMaxViewPosValue->dwY = 0;
    }

}


void VIA_UT_DEVICE_GetPanleViewPositionValue(VIABIOSInfoPtr pBIOSInfo,
                                                        UTXYVALUE* pViewPosValue,
                                                        CARD32 dwDeviceType)
{
    xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
               "VIA_UT_DEVICE_GetPanleViewPositionValue\n");

    CARD32  dwDevice;
    VIA3DSclSCNParasPtr   pTagert3DScalInfo = NULL;
     /* Convert utility's device ID into driver's device ID. */
    dwDevice = MapDeviceStateForDrv(dwDeviceType);
    switch (dwDevice)
    {
         case VIA_DEVICE_DFP:
             pTagert3DScalInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
             break;
             
         case VIA_DEVICE_LCD:
             pTagert3DScalInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);
             break;             
    }
    
    if (pBIOSInfo->Is3DScalingEnable & dwDevice)
    {
        if (pViewPosValue->dwX == 0xFFFF && pViewPosValue->dwY == 0xFFFF)
        {
            pViewPosValue->dwX = pTagert3DScalInfo->XPOSITIONDefault;
            pViewPosValue->dwY = pTagert3DScalInfo->YPOSITIONDefault;
        }
        else
        {
            pViewPosValue->dwX = pTagert3DScalInfo->XPOSITIONLevel;
            pViewPosValue->dwY = pTagert3DScalInfo->YPOSITIONLevel;
        }
        xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                   "GetViewSizeValue: X=%lu,Y=%lu\n",
                   pViewPosValue->dwX,pViewPosValue->dwY);   
    }
    else
    {
        pViewPosValue->dwX = 0;
        pViewPosValue->dwY = 0;
    } 

}

Bool VIA_UT_DEVICE_SetPanleViewPositionValue(VIABIOSInfoPtr pBIOSInfo,
                                                        UTXYVALUE ViewPosValue,
                                                        CARD32 dwDeviceType)
{
    CARD32  dwDevice;
    int IGAPath = 0;
    VIA3DSclSCNParasPtr   pTagert3DScalInfo = NULL;
    ScrnInfoPtr pScrn = xf86Screens[pBIOSInfo->scrnIndex];
    VIAPtr      pVia = VIAPTR(pScrn);
    viaGfxInfoPtr viaGfxInfo = pVia->pVidData->viaGfxInfo;
    
     /* Convert utility's device ID into driver's device ID. */
    dwDevice = MapDeviceStateForDrv(dwDeviceType);
    switch (dwDevice)
    {
         case VIA_DEVICE_DFP:
             DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                   "SetPanleViewPositionValue:DVI path \n"));         
             pTagert3DScalInfo = &(pBIOSInfo->TMDSSettingInfo.DVI3DScalInfo);
             IGAPath = pBIOSInfo->TMDSSettingInfo.IGAPath;
             break;

         case VIA_DEVICE_LCD:
             DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                   "SetPanleViewPositionValue:LCD path \n"));         
             pTagert3DScalInfo = &(pBIOSInfo->LVDSSettingInfo.LCD3DScalInfo);
             IGAPath = pBIOSInfo->LVDSSettingInfo.IGAPath;
             break;
    }

    if (pBIOSInfo->Is3DScalingEnable & dwDevice)
    {
        DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
              "VIA_UT_DEVICE_SetPanleViewPositionValue:Y=%d, X=%d \n",
              ViewPosValue.dwY, ViewPosValue.dwX));

        if (ViewPosValue.dwY == 0xFFFF ||
            ViewPosValue.dwX == 0xFFFF)
        {
            ViewPosValue.dwX = pTagert3DScalInfo->XPOSITIONDefault;
            ViewPosValue.dwY = pTagert3DScalInfo->YPOSITIONDefault;
            pTagert3DScalInfo->XPOSITIONLevel = pTagert3DScalInfo->XPOSITIONDefault;
            pTagert3DScalInfo->YPOSITIONLevel = pTagert3DScalInfo->YPOSITIONDefault;
        }
        pTagert3DScalInfo->XPOSITIONLevel = ViewPosValue.dwX;
        pTagert3DScalInfo->YPOSITIONLevel = ViewPosValue.dwY; 
        pTagert3DScalInfo->XPOSITIONOffset= (pTagert3DScalInfo->XPOSITIONLevel - pTagert3DScalInfo->XPOSITIONDefault)*pTagert3DScalInfo->XPOSITIONStep;
        pTagert3DScalInfo->YPOSITIONOffset= (pTagert3DScalInfo->YPOSITIONLevel - pTagert3DScalInfo->YPOSITIONDefault)*pTagert3DScalInfo->YPOSITIONStep;

        pTagert3DScalInfo->XPOSITIONNow =( pTagert3DScalInfo->XPOSITIONLevel - pTagert3DScalInfo->XPOSITIONDefault)*pTagert3DScalInfo->XPOSITIONStep;
        pTagert3DScalInfo->YPOSITIONNow =( pTagert3DScalInfo->YPOSITIONLevel - pTagert3DScalInfo->YPOSITIONDefault)*pTagert3DScalInfo->YPOSITIONStep;
          
        pTagert3DScalInfo->bNeedBlack3dScalingBorders =TRUE;

        if(!pVia->useRandR && pVia->pScreensPublicInfo->UseHwCursor)
        {
            hw3d_CursorPositionUpdate(pBIOSInfo);
        }

        viaGfxInfo->igaInfo[IGAPath-1].igagfx3DScaling_info.XPOSITIONOffset = pTagert3DScalInfo->XPOSITIONOffset; 
        viaGfxInfo->igaInfo[IGAPath-1].igagfx3DScaling_info.YPOSITIONOffset = pTagert3DScalInfo->YPOSITIONOffset;

       if(via_module_loaded) 
       {
            TranslateGFXInfo(viaGfxInfo, &NEWVIAGraphicInfo);    
            if(FALSE == vvaSyncInfo(&NEWVIAGraphicInfo, VIA_SET_2D_INFO))
            {
                return FALSE;
            }               
        }       

        VIAAdjustFrame(pScrn->scrnIndex, pScrn->frameX0, pScrn->frameY0, 0);
        VIASaveUserSetting(pBIOSInfo);        
    }
    return TRUE;
}


void VIA_UT_DEVICE_GetSupportState(VIABIOSInfoPtr pBIOSInfo,
                                            CARD32*  pdwSupportState)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetSupportState\n"));
    
    unsigned int dwSupportState = UT_DEVICE_CRT1;
    
    if (pBIOSInfo->TMDSSettingInfo.ChipID)
        dwSupportState |= UT_DEVICE_DFP;  
    
    if (pBIOSInfo->LVDSSettingInfo.ChipID)
        dwSupportState |= UT_DEVICE_LCD;

    if (pBIOSInfo->LVDSSettingInfo2.ChipID)
        dwSupportState |= UT_DEVICE_LCD2;

    *pdwSupportState = dwSupportState;
    
}


void VIA_UT_DEVICE_GetConnectState(VIABIOSInfoPtr pBIOSInfo,
                                                         CARD32* pdwConnectState)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "VIA_UT_DEVICE_GetConnectState\n"));
    
    unsigned int dwConnectState = VIAGetDeviceDetect(pBIOSInfo);

    /* Map the device state for utility. */
    dwConnectState = MapDeviceStateForUT(dwConnectState);
    
    *pdwConnectState = dwConnectState;

}


void VIA_UT_DEVICE_GetActiveState(ScrnInfoPtr pScrn,
                                          CARD32* pdwActiveDevice)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, 
          "VIA_UT_DEVICE_GetActiveState\n"));
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    unsigned int dwActiveState = 0;        
    
    if (pBIOSInfo->SAMM)
    {
        DevUnion* pPriv = xf86GetEntityPrivate(pScrn->entityList[0], gVIAEntityIndex);
        VIAEntPtr pVIAEnt = pPriv->ptr;
        VIAPtr pVia1 = VIAPTR(pVIAEnt->pSecondaryScrn);
        VIAPtr pVia0 = VIAPTR(pVIAEnt->pPrimaryScrn);
        
        dwActiveState = (CARD32)pVia->ActiveDevice;
        
        /* Map the device state for utility. */
        dwActiveState = MapDeviceStateForUT(dwActiveState);
        
    }
    else
    {
        dwActiveState = (CARD32)pBIOSInfo->ActiveDevice;
        
        /* Map the device state for utility. */
        dwActiveState = MapDeviceStateForUT(dwActiveState);
    }

    *pdwActiveDevice = dwActiveState;
}


void VIA_UT_DEVICE_SetActiveState(VIABIOSInfoPtr pBIOSInfo,
                                          DisplayModePtr mode,
                                          CARD32 dwActiveDevice)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_SetActiveState = 0x%x\n", dwActiveDevice));      

    /* Convert utility's device ID into driver's device ID. */
    pBIOSInfo->ActiveDevice = MapDeviceStateForDrv(dwActiveDevice);

    /*update the information for .VIARC*/
    pBIOSInfo->ActualActiveDevice = pBIOSInfo->ActiveDevice;
    
    /* Avoid device switch in panning mode or expansion */
    pBIOSInfo->scaleY = FALSE;

    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "1SetActiveState = 0x%x\n", pBIOSInfo->ActiveDevice));

    VIASwitchMode(pBIOSInfo->scrnIndex, mode, 0);
    VIASaveUserSetting(pBIOSInfo);

    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "2SetActiveState = 0x%x\n", pBIOSInfo->ActiveDevice));
}


void VIA_UT_DEVICE_GetPrimaryDevice(VIABIOSInfoPtr pBIOSInfo,
                                          CARD32* pdwDevicePrimary)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetPrimaryDevice\n"));
    
    *pdwDevicePrimary = pBIOSInfo->PrimaryDevice;
}

void VIA_UT_DEVICE_GetSAMMState(VIABIOSInfoPtr pBIOSInfo,
                                          CARD32* pdwSAMMState)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetSAMMState\n"));
    
    if (pBIOSInfo->SAMM)
        *pdwSAMMState = UT_STATE_SAMM_ON;
    else
        *pdwSAMMState = UT_STATE_SAMM_OFF;
}


void VIA_UT_DEVICE_GetSupportSAMMState(VIABIOSInfoPtr pBIOSInfo,
                                                   CARD32* pdwSAMMState)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_GetSupportSAMMState\n"));
    
        *pdwSAMMState = UT_DEVICE_SUPPORT_SAMM_STATE_ON;
}


Bool VIA_UT_DEVICE_SetV3OnIGAStatus(ScrnInfoPtr pScrn,
                                               CARD32 dwIGAPath)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "VIA_UT_DEVICE_SetV3OnIGAStatus\n"));
    
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    PVIDDATA        pVidData = pVia->pVidData;
    
    static DDUPDATEOVERLAY updateOvlRec;
    LPOVERLAYRECORD pupdateOvlRec;
    int ret = 0;
    int i = 0;
    unsigned long pPivScrnIndex = 0;
    viaGfxInfoPtr viaGfxInfo = pVia->pVidData->viaGfxInfo;

    if (dwIGAPath == UT_STATE_DuoView_IGA1)
    {
        if(viaGfxInfo->screenAttr.duoview && 
          ((pBIOSInfo->Chipset ==VIA_K8M890) ||
           (pBIOSInfo->Chipset ==VIA_P4M890) ||
           (pBIOSInfo->Chipset == VIA_P4M800PRO) ||
           (pBIOSInfo->Chipset == VIA_P4M900)))
            viaGfxInfo->preferedVideoIga = IGA1;
                
        ret = TRUE;
    }
    else if (dwIGAPath == UT_STATE_DuoView_IGA2)
    {
        if(viaGfxInfo->screenAttr.duoview && 
        ((pBIOSInfo->Chipset ==VIA_K8M890) ||
        (pBIOSInfo->Chipset ==VIA_P4M890) ||
        (pBIOSInfo->Chipset == VIA_P4M800PRO) ||
        (pBIOSInfo->Chipset == VIA_P4M900)))
            viaGfxInfo->preferedVideoIga = IGA2;
        ret = TRUE;
    }
    else
    {
        ret = FALSE;
    }

    if (via_module_loaded)
    {
        TranslateGFXInfo(viaGfxInfo, &NEWVIAGraphicInfo); 
	    if(FALSE == vvaSyncInfo(&NEWVIAGraphicInfo, VIA_SET_2D_INFO))
	    {
		    return FALSE;
	    }	  			

        vvaUpdateOverlay(pScrn->scrnIndex, 0, 0);
    }
          
    for (i = 0; i < XV_PORT_NUM_OVERLAY; i++) {        
        if (pVia->pPriv[i] != NULL) {
            if (pVia->pPriv[i]->videoFlag & VIDEO_ACTIVE) {                                            
                pupdateOvlRec = &pVia->pPriv[i]->ovlInfo[pVia->pPriv[i]->curIGA-1];
           
                updateOvlRec.rSrc = pupdateOvlRec->dwOriSrcRect;
                updateOvlRec.rDest = pupdateOvlRec->dwOriDestRect;
                updateOvlRec.dwFlags |= (DDOVER_SHOW | DDOVER_KEYDEST);
                UpdateOverlay(pScrn,pVia->pPriv[i], &updateOvlRec);
            }                
        }
    }

    return ret;
}


void VIA_UT_DEVICE_GetV3OnIGAStatus(ScrnInfoPtr pScrn,
                                               CARD32* pdwStatus)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIA_UT_DEVICE_SetV3OnIGAStatus\n"));
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    if(pVia->pVidData->viaGfxInfo->screenAttr.duoview && 
       ((pBIOSInfo->Chipset == VIA_K8M890)  ||
       (pBIOSInfo->Chipset == VIA_P4M890)  ||
       (pBIOSInfo->Chipset == VIA_P4M800PRO) ||
       (pBIOSInfo->Chipset == VIA_P4M900)))
    {
        if (pVia->pVidData->viaGfxInfo->preferedVideoIga==IGA2) {
            *pdwStatus = 0x01;
        } else {
            *pdwStatus = 0x00;
        }
    }
}

void VIA_UT_DEVICE_GetDuoViewStatus(ScrnInfoPtr pScrn,
                                               CARD32* pdwState)
{
    VIAPtr pVia = VIAPTR(pScrn);

    if (pVia->pVidData->viaGfxInfo->screenAttr.duoview)
        *pdwState = UT_STATE_DuoView_ON;
    else
        *pdwState = UT_STATE_DuoView_OFF;
}


void VIA_UT_GAMMA_GetDeviceSupportState(ScrnInfoPtr pScrn,
                                                    CARD32* pdwSupportState)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "VIA_UT_GAMMA_GetDeviceSupportState\n"));
    
    if (pScrn->bitsPerPixel == 8)
        *pdwSupportState = UT_DEVICE_NONE;
    else
        *pdwSupportState = UT_DEVICE_CRT1 | UT_DEVICE_DFP |
                           UT_DEVICE_LCD;
}


void VIA_UT_GAMMA_GetLookUpTable(VIABIOSInfoPtr pBIOSInfo,
                                            CARD32* pGammaLUT)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
          "VIA_UT_GAMMA_GetLookUpTable\n"));

    int i =0;
    
    for (i=0; i<256; i++)
    {
        pGammaLUT[i] = ((CARD32)pBIOSInfo->colors[i].red) << 16;
        pGammaLUT[i] |= ((CARD32)pBIOSInfo->colors[i].green) << 8;
        pGammaLUT[i] |= (CARD32)pBIOSInfo->colors[i].blue;
    }
}


Bool VIA_UT_GAMMA_SetLookUpTable(ScrnInfoPtr pScrn,
                                            CARD32* pGammaLUT)
{
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO,
          "VIA_UT_GAMMA_SetLookUpTable\n"));
    
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    
    int i = 0;
    int ret = 0;
    
    if(pGammaLUT[0] == 0xFFFFFFFF)   /* Set default gamma value */
    {
        for (i=0; i<256; i++)
        {
            pBIOSInfo->colors[i].red = i;
            pBIOSInfo->colors[i].green = i;
            pBIOSInfo->colors[i].blue = i;
        }
    }
    else
    {
        for (i=0; i<256; i++)
        {
            pBIOSInfo->colors[i].red = (unsigned short)(pGammaLUT[i] >> 16);
            pBIOSInfo->colors[i].green = (unsigned short)(pGammaLUT[i] >> 8) & 0x00FF;
            pBIOSInfo->colors[i].blue = (unsigned short)(pGammaLUT[i] & 0x000000FF);
        }
    }
    if (VIARestoreGamma(pScrn, pBIOSInfo->colors))
    {                   
        ret = TRUE;
    }
    else
    {
        ret = FALSE;
    }
    
    return ret;
}


void VIA_UT_GAMMA_GetDefaultLookUpTable(VIABIOSInfoPtr pBIOSInfo,
                                                    CARD32* pGammaLUT)
{
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, 
          "VIA_UT_GAMMA_GetDefaultLookUpTable\n"));
    int i = 0;
    
    for (i=0; i<256; i++)
    {
        pGammaLUT[i] = (CARD32)i << 16;
        pGammaLUT[i] |= (CARD32)i << 8;
        pGammaLUT[i] |= (CARD32)i;
    }
}


Bool VIALoadGammaSetting(VIABIOSInfoPtr pBIOSInfo)
{
    FILE	*VIARC = NULL;
    char 	filename[40], *home = NULL;
    Bool	ret = FALSE;
    int retval, size;   
    unsigned int i;

    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "VIALoadGammaSetting\n"));
    home="/etc/X11";
    if (home)
    {
        filename[0] = '\0';
        strcpy(filename, home);
        strcat(filename, "/.VIAGAMMARC");
        
        if ((VIARC = fopen(filename, "r")) == NULL)
        {
            xf86Msg(X_WARNING,
                    "No Gamma setting file exist, Create new ones\n");
            if ((VIARC = fopen(filename, "a")) == NULL)
            {
                xf86Msg(X_ERROR, "Create .VIAGAMMARC failure!\n");
                return FALSE;
            }
            for (i=0; i<256; i++)
            {
                pBIOSInfo->colors[i].red = i;
                pBIOSInfo->colors[i].green = i;
                pBIOSInfo->colors[i].blue = i;
            }
        }
        else
        {
            /* Gamma record in driver is different with gamma record in utility.
               So I remove resolution save setting to solve asynchronous problem. 
            */
            /* File maybe exist but it is empty. So we must load a default value first. */
            for (i=0; i<256; i++)
            {
                pBIOSInfo->colors[i].red = i;
                pBIOSInfo->colors[i].green = i;
                pBIOSInfo->colors[i].blue = i;
            }
            
            /* If file is not empty then load previous setting */
            fseek(VIARC, 0, SEEK_END); /* seek to end of file */
            size = ftell(VIARC); /* get current file pointer */
            fseek(VIARC, 0, SEEK_SET); /* seek back to beginning of file */
            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "size: %d\n", size));
    
            if(size != 0)
            {
                while(!feof(VIARC))
                {                              
                    for (i=0; i<256; i++)
                    {
                        retval = fscanf(VIARC, "%hu", &pBIOSInfo->colors[i].red);
                        retval = fscanf(VIARC, "%hu", &pBIOSInfo->colors[i].green);
                        retval = fscanf(VIARC, "%hu", &pBIOSInfo->colors[i].blue);
                    }
                }
                ret = TRUE;                                        
            }
            
            fclose(VIARC);
        }
    }
    return ret;
}


Bool VIASaveUserSetting(VIABIOSInfoPtr  pBIOSInfo)
{    
    FILE *VIARC=NULL, *VIAtmp=NULL;
    char filename[40], tmpname[40], buffer[200], *home = NULL;
    int  HDisplay, VDisplay, bitsPerPixel, ActiveDevice;
    Bool found = FALSE, ret = FALSE;
    Bool IsCenter;
    int  OldCenter;
    TMDSSETTINGINFOPTR     pTmpTMDSSettingInfo = &(pBIOSInfo->TMDSSettingInfo) ;
    LVDSSETTINGINFOPTR     pTmpLVDSSettingInfo = &(pBIOSInfo->LVDSSettingInfo) ;	
    
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "VIASaveUserSetting\n"));    
    
    if (pBIOSInfo->ActiveDevice == VIA_DEVICE_LCD2)
    {
        IsCenter = pBIOSInfo->LVDSSettingInfo2.Center;
    }
    else
    {
        IsCenter = pBIOSInfo->LVDSSettingInfo.Center;
    }

    home="/etc/X11";
    if (home)
    {
        filename[0] = '\0';
        strcpy(filename, home);
        strcat(filename, "/.VIARC");
        if ((VIARC = fopen(filename, "r")) == NULL)
        {
            xf86Msg(X_DEFAULT, "Open user setting file failed.\n");
            if ((VIARC = fopen(filename, "a")) == NULL)
            {
                DEBUG(xf86Msg(X_ERROR, "Create .VIARC failure!\n"));
                return FALSE;
            }
        }

        /* save user setting to temp file */
        strcpy(tmpname, home);
        strcat(tmpname, "/.VIAtmp");
        VIAtmp = fopen(tmpname, "w+");
        /* looking for old setting by resolution & color depth index */
        while (fgets(buffer, 50, VIARC) != NULL)
        {
            sscanf(buffer,"%d %d %d %d %d",
                   &HDisplay,
                   &VDisplay,
                   &bitsPerPixel,
                   &ActiveDevice,
                   &OldCenter);
            
            if (HDisplay == pBIOSInfo->SaveHDisplay &&
                VDisplay == pBIOSInfo->SaveVDisplay &&
                bitsPerPixel == pBIOSInfo->bitsPerPixel)
            {
                
                fprintf(VIAtmp, "%d %d %d %lu %d %lu %lu %lu %lu %lu %lu %lu %lu\n",
                pBIOSInfo->SaveHDisplay,
                pBIOSInfo->SaveVDisplay,
                pBIOSInfo->bitsPerPixel,
                pBIOSInfo->ActualActiveDevice,
                IsCenter,
                pTmpTMDSSettingInfo->DVI3DScalInfo.XScaleLevel,
                pTmpTMDSSettingInfo->DVI3DScalInfo.YScaleLevel,
                pTmpTMDSSettingInfo->DVI3DScalInfo.XPOSITIONLevel,
                pTmpTMDSSettingInfo->DVI3DScalInfo.YPOSITIONLevel,
                pTmpLVDSSettingInfo->LCD3DScalInfo.XScaleLevel,
                pTmpLVDSSettingInfo->LCD3DScalInfo.YScaleLevel,
                pTmpLVDSSettingInfo->LCD3DScalInfo.XPOSITIONLevel,
                pTmpLVDSSettingInfo->LCD3DScalInfo.YPOSITIONLevel);
				
                
                found = TRUE;
            }
            else
            {                
                fputs(buffer, VIAtmp);
            }
        }

        if (!found)
        {            
            fprintf(VIAtmp, "%d %d %d %lu %d %lu %lu %lu %lu %lu %lu %lu %lu\n",
                    pBIOSInfo->SaveHDisplay,
                    pBIOSInfo->SaveVDisplay,
                    pBIOSInfo->bitsPerPixel,
                    pBIOSInfo->ActualActiveDevice,
                    IsCenter,
                    pTmpTMDSSettingInfo->DVI3DScalInfo.XScaleLevel,
                    pTmpTMDSSettingInfo->DVI3DScalInfo.YScaleLevel,
                    pTmpTMDSSettingInfo->DVI3DScalInfo.XPOSITIONLevel,
                    pTmpTMDSSettingInfo->DVI3DScalInfo.YPOSITIONLevel,
                    pTmpLVDSSettingInfo->LCD3DScalInfo.XScaleLevel,
                    pTmpLVDSSettingInfo->LCD3DScalInfo.YScaleLevel,
                    pTmpLVDSSettingInfo->LCD3DScalInfo.XPOSITIONLevel,
                    pTmpLVDSSettingInfo->LCD3DScalInfo.YPOSITIONLevel);
			
        }
        DEBUG(xf86Msg(X_INFO, "pBIOSInfo->ActualActiveDevice is %x, pBIOSInfo->ActiveDevice is %x\n", pBIOSInfo->ActualActiveDevice, pBIOSInfo->ActiveDevice));
        fclose(VIARC);
        fclose(VIAtmp);
        if(remove(filename) != -1)              /* remove old setting file */
        {
            if(rename(tmpname, filename) == 0)
            {
                ret = TRUE;
            }
        }
        
    }
    return ret;
}


void VIALoadUserSetting(VIABIOSInfoPtr pBIOSInfo)
{
    FILE *VIARC=NULL;
    char filename[40], buffer[50], *home = NULL;
    int  HDisplay, VDisplay, bitsPerPixel, ActiveDevice, tmp;
    Bool Center;    
    TMDSSETTINGINFOPTR     pTmpTMDSSettingInfo = &(pBIOSInfo->TMDSSettingInfo);
    LVDSSETTINGINFOPTR     pTmpLVDSSettingInfo = &(pBIOSInfo->LVDSSettingInfo);	
    pBIOSInfo->TMDSSettingInfo.IsPreSetting=FALSE;
    pBIOSInfo->LVDSSettingInfo.IsPreSetting=FALSE;	
    
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "VIALoadUserSetting\n"));
    DEBUG(xf86Msg(X_INFO, "pBIOSInfo->HDisplay = %d, pBIOSInfo->VDisplay = %d\n"
                    , pBIOSInfo->HDisplay, pBIOSInfo->VDisplay));
    home="/etc/X11";
    if (home)
    {
        filename[0] = '\0';
        strcpy(filename, home);
        strcat(filename, "/.VIARC");
        if ((VIARC = fopen(filename, "r")) == NULL)
        {
            DEBUG(xf86Msg(X_WARNING, "No user setting file exist, Create new ones\n"));
            if ((VIARC = fopen(filename, "a")) == NULL)
            {
                DEBUG(xf86Msg(X_ERROR, "Create .VIARC failure!\n"));
                return;
            }
        }
        else
        {
            
            while (fgets(buffer, 50, VIARC) != NULL)
            {
                sscanf(buffer,"%d %d %d", &HDisplay, &VDisplay, &bitsPerPixel);
                
                if (HDisplay == pBIOSInfo->SaveHDisplay &&
                    VDisplay == pBIOSInfo->SaveVDisplay &&
                    bitsPerPixel == pBIOSInfo->bitsPerPixel)
                {
                    sscanf(buffer,"%d %d %d %d %d %lu %lu %lu %lu %lu %lu %lu %lu",
                            &tmp, &tmp, &tmp, &ActiveDevice, &Center, 
                            &(pTmpTMDSSettingInfo->XScalingLevel), 
                            &(pTmpTMDSSettingInfo->YScalingLevel), 
                            &(pTmpTMDSSettingInfo->XScalPosLevel), 
                            &(pTmpTMDSSettingInfo->YScalPosLevel),
                            &(pTmpLVDSSettingInfo->XScalingLevel), 
                            &(pTmpLVDSSettingInfo->YScalingLevel), 
                            &(pTmpLVDSSettingInfo->XScalPosLevel), 
                            &(pTmpLVDSSettingInfo->YScalPosLevel));					

                            
                    pBIOSInfo->TMDSSettingInfo.IsPreSetting=TRUE;                            
                    pBIOSInfo->LVDSSettingInfo.IsPreSetting=TRUE;
					
                    /* No need to get active device in SAMM case.  */
                    if (pBIOSInfo->FirstInit && !pBIOSInfo->SAMM)
                    {
                        pBIOSInfo->ActiveDevice = ActiveDevice & pBIOSInfo->ConnectedDevice;
                    }
                    
                    if (!(pBIOSInfo->SAMM))
                    {
                        pBIOSInfo->ActualActiveDevice  = pBIOSInfo->ActiveDevice;
                    }
                                        
                    pBIOSInfo->LVDSSettingInfo.Center = Center;
                    pBIOSInfo->LVDSSettingInfo2.Center = Center;                    
                    
                    DEBUG(xf86Msg(X_INFO, "Found user active device setting!!\n"));
                    DEBUG(xf86Msg(X_INFO, "Utility: Active Device = 0x%x!!\n", pBIOSInfo->ActiveDevice));
                    break;
                }
            }
        }
        fclose(VIARC);
    }
}


void VIALoadUserDuoViewVideoOutputDeviceSetting(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;
    PVIDDATA        pVidData = pVia->pVidData; 
    FILE *VIADuoView=NULL;
    char filename[40], buffer[2], *home = NULL;
    int  nGetV3OnIGAState;
    viaGfxInfoPtr viaGfxInfo = pVia->pVidData->viaGfxInfo;
    
    DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO, "VIALoadUserDuoViewVideoOutputDeviceSetting\n"));
    home="/etc/X11";
    if (home)
    {
        filename[0] = '\0';
        strcpy(filename, home);
        strcat(filename, "/.VIADuoView");
        if ((VIADuoView = fopen(filename, "r")) == NULL)
        {
            DEBUG(xf86Msg(X_WARNING, "No user DuoView setting file exist, Create new ones\n"));
            if ((VIADuoView = fopen(filename, "a")) == NULL)
            {
                DEBUG(xf86Msg(X_ERROR, "Create .VIADuoView failure!\n"));
                return;
            }
        }
        else
        {
            while (fgets(buffer, 2, VIADuoView) != NULL)
            {
                sscanf(buffer,"%d", &nGetV3OnIGAState);
                if (nGetV3OnIGAState == UT_STATE_DuoView_IGA1)
                {
                    if(viaGfxInfo->screenAttr.duoview && 
                      ((pBIOSInfo->Chipset ==VIA_K8M890) ||
                      (pBIOSInfo->Chipset ==VIA_P4M890) ||
                      (pBIOSInfo->Chipset == VIA_P4M800PRO) ||
                      (pBIOSInfo->Chipset == VIA_P4M900)))
                        viaGfxInfo->preferedVideoIga = IGA1;
                }
                else if (nGetV3OnIGAState == UT_STATE_DuoView_IGA2)
                {
                    if(viaGfxInfo->screenAttr.duoview && 
                      ((pBIOSInfo->Chipset ==VIA_K8M890) ||
                      (pBIOSInfo->Chipset ==VIA_P4M890) ||
                      (pBIOSInfo->Chipset == VIA_P4M800PRO) ||
                      (pBIOSInfo->Chipset == VIA_P4M900)))
                        viaGfxInfo->preferedVideoIga = IGA2;
                }
            }

            if (via_module_loaded)
            {
                TranslateGFXInfo(viaGfxInfo, &NEWVIAGraphicInfo); 
                if(FALSE == vvaSyncInfo(&NEWVIAGraphicInfo, VIA_SET_2D_INFO))
                {
                    return ;
                }               
            }
        }

        fclose(VIADuoView);
    }
}

/* Remove restart flag file for utility */
void UTRemoveRestartFlag(VIABIOSInfoPtr pBIOSInfo)
{
    char filename[40], *home = NULL;

    filename[0] = '\0';
    home="/etc/X11";
    if (home)
    {
        filename[0] = '\0';
        strcpy(filename, home);
        strcat(filename, "/.XWindowNeedtobeRestart");
        if (remove(filename) == -1)
            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "Restart flag file not exist!\n"));
        else
            DEBUG(xf86DrvMsg(pBIOSInfo->scrnIndex, X_INFO,
                  "Restart flag file has been remove!\n"));
    }
}



/*
    Query the VIAGFX_API version.
*/
static int ProcVIAGFXQueryVersion (ClientPtr client)
{        
    xVIAGFXQueryVersionReply rep;
    register int n;

    REQUEST_SIZE_MATCH(xVIAGFXQueryVersionReq);
    rep.type = X_Reply;
    rep.length = 0;
    rep.sequenceNumber = client->sequence;
    rep.majorVersion = 2;
    rep.minorVersion = 0;
    
    if(client->swapped)
    {
        swaps(&rep.sequenceNumber, n);
        swapl(&rep.length, n);
        swaps(&rep.majorVersion, n);
        swaps(&rep.minorVersion, n);
    }
    
    WriteToClient(client, sizeof(xVIAGFXQueryVersionReply), (char *)&rep);
    return (client->noClientException);
}


/*
*   Receive and process the request from AP.
*/
static int ProcVIAGFXCommand(ClientPtr client)
{        
    REQUEST(xVIAGFXCommandReq);
    xVIAGFXCommandReply rep;
    ExtensionEntry   *myext;    
    register int     n;
    int          i;    
    
    REQUEST_SIZE_MATCH(xVIAGFXCommandReq);

    /* copy the request to reply. */
    memcpy(&rep, stuff, sizeof(xVIAGFXCommandReply));

    /* Get pointer to ExtensionEntry */
    if(!(myext = CheckExtension(VIAGFX_PROTOCOL_NAME))) return BadMatch;       

    /* Process the request. */
    VIAGFXUtilityProc(&rep);
    
    rep.type = X_Reply;
    rep.length = (sizeof(xVIAGFXCommandReply) - sizeof(xGenericReply)) >> 2;
    rep.sequenceNumber = client->sequence;    
    
    if(client->swapped)
    {
       swaps(&rep.sequenceNumber, n);
       swapl(&rep.length, n);       
       swapl(&rep.command, n);
       swapl(&rep.primary_id, n);
       swapl(&rep.secondary_id, n);
       swapl(&rep.result_header, n);
       
       for(i = 0; i < VIAGFX_PARM_NUM; i++)
       {
          swapl(&rep.parm[i], n);
          swapl(&rep.result[i], n);
       }
    }
    
    WriteToClient(client, sizeof(xVIAGFXCommandReply), (char *)&rep);
    return client->noClientException;
}

static void VIAGFXResetProc(ExtensionEntry* extEntry)
{    
    if(extEntry->extPrivate)
    {
       xfree(extEntry->extPrivate);
       extEntry->extPrivate = NULL;
    }
}

static int ProcVIAGFXDispatch(ClientPtr client)
{    
    REQUEST(xReq);
    switch(stuff->data)
    {
        case X_VIAGFXQueryVersion:
            return ProcVIAGFXQueryVersion(client);
        case X_VIAGFXCommand:
            return ProcVIAGFXCommand(client);
    }
    
    return BadRequest;
}

void VIADisplayExtensionInit(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;  
    
    ExtensionEntry *extEntry;
    xVIAGFXScreenTable *VIAGFXScrnTbl;

    g_ScreenNumber = pScrn->scrnIndex;    
    
    if(!(extEntry = CheckExtension(VIAGFX_PROTOCOL_NAME))) 
    { 
        if(!(VIAGFXScrnTbl = xcalloc(sizeof(xVIAGFXScreenTable), 1)))
            return;
        
        if (!(extEntry = AddExtension(VIAGFX_PROTOCOL_NAME, 0, 0,
                                     ProcVIAGFXDispatch,
                                     ProcVIAGFXDispatch,
                                     VIAGFXResetProc,
                                     StandardMinorOpcode)))
        {
            xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "Failed to add VIAGFX extension\n");
            return;
        }
        
        extEntry->extPrivate = (pointer)VIAGFXScrnTbl;               
    }
    else
    {
        if(!(VIAGFXScrnTbl = (xVIAGFXScreenTable *)extEntry->extPrivate))
        {
            xf86DrvMsg(pScrn->scrnIndex, X_ERROR, "Internal error: Found VIAGFX extension with NULL-private!\n");
            return;
        }        
    }
    
    VIAGFXScrnTbl->HandleVIAGFXCommand[pScrn->scrnIndex] = VIAGFXUtilityProc;
    pBIOSInfo->DisplayExtEntry = extEntry;
}


void VIADisplayExtUnregister(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;  
    ExtensionEntry  *VIAGFXExt;
    xVIAGFXScreenTable *VIAGFXScreenTbl;
    
    if(!pBIOSInfo->DisplayExtEntry) return;

    if((VIAGFXExt = CheckExtension(VIAGFX_PROTOCOL_NAME)))
    {
        if((VIAGFXScreenTbl = (xVIAGFXScreenTable *)VIAGFXExt->extPrivate)) {
         VIAGFXScreenTbl->HandleVIAGFXCommand[pScrn->scrnIndex] = NULL;
      }
    }
}

int VIAGFXUtilityProc(xVIAGFXCommandReply* rep)
{
    ScrnInfoPtr pScrn = xf86Screens[g_ScreenNumber];
    VIAPtr  pVia = VIAPTR(pScrn);
    
    /* 
        In SAMM case, a driver controls a screen.
        In the past, we have to move application's window to switch to correct driver.
        So I add following step to detect which driver we should use to avoid this problem.
    */
    if (pVia->pBIOSInfo->SAMM)
    {        
        pScrn = VIAScreenSelection(pScrn, rep->primary_id, rep->secondary_id);
        pVia = VIAPTR(pScrn);
    }
    
    VIABIOSInfoPtr  pBIOSInfo = pVia->pBIOSInfo;

    /* variables for escape function. */
    CARD32      i;
    char      szDriverName[16];
    CARD32      dwSupportState = 0;
    CARD32      dwConnectState = 0;
    CARD32      dwCurrentState = 0;
    CARD32      dwMaxValue = 0;
    CARD32      dwCurrentValue = 0;
    CARD32      dwChipID = 0;
    CARD32      dwVideoRam = 0;
    CARD32      dwGammaLUT[256];
    CARD32      dwRotateDegree = 0;
    CARD32      dwRotateType = 0;
    UTXYVALUE   MaxViewSizeValue, ViewSizeValue, MaxViewPosValue, ViewPosValue;
    UTPANELINFO         UTPanelInfo;
    UTBIOSVERSION       UTBIOSVersion;
    UTBIOSDATE          UTBIOSDate;
    UTDriverVersion     UTDriverVer;
    UTDEVMODE           DevMode;
/*    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "VIAGFXUtilityProc\n"));    
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "rep->primary_id = %x\n", rep->primary_id));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "rep->secondary_id = %x\n", rep->secondary_id));    
*/    

    if (rep->primary_id == UT_XV_FUNC_BIOS)
    {
        switch (rep->secondary_id)
        {
            case UT_XV_FUNC_BIOS_GetChipID :                    
                VIA_UT_BIOS_GetChipID(pScrn, &dwChipID);
                rep->result[0] = dwChipID;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_BIOS_GetVersion :                    
                VIA_UT_BIOS_GetVersion(pScrn, &UTBIOSVersion);
                rep->result[0] = UTBIOSVersion.dwVersion;
                rep->result[1] = UTBIOSVersion.dwRevision;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_BIOS_GetDate :
                VIA_UT_BIOS_GetDate(pScrn, &UTBIOSDate);
                rep->result[0] = UTBIOSDate.dwYear;
                rep->result[1] = UTBIOSDate.dwMonth;
                rep->result[2] = UTBIOSDate.dwDay;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_BIOS_GetVideoMemSizeMB :
                VIA_UT_BIOS_GetVideoMemSizeMB(pScrn, &dwVideoRam);
                rep->result[0] = dwVideoRam;
                rep->result_header = TRUE;
                break;
                
        }
    }
    else if (rep->primary_id == UT_XV_FUNC_DRIVER)
    {
        switch(rep->secondary_id)
        {
            case UT_XV_FUNC_DRIVER_GetFileName :                
                if (VIA_UT_DRIVER_GetFileName(rep->parm[0], szDriverName))
                {                                                            
                    memcpy((void *)rep->result, (void *)szDriverName, sizeof(szDriverName));                    
                    rep->result_header = TRUE;
                }
                else
                {
                    rep->result_header = FALSE;
                }                    
                break;
                
            case UT_XV_FUNC_DRIVER_GetFileVersion :                
                if (VIA_UT_DRIVER_GetFileVersion(pScrn, rep->parm[0], &UTDriverVer))
                {                    
                    rep->result[0] = UTDriverVer.dwMajorNum;
                    rep->result[1] = UTDriverVer.dwMinorNum;
                    rep->result[2] = UTDriverVer.dwOSNum;
                    rep->result[3] = UTDriverVer.dwReversionNum;
                    rep->result_header = TRUE;
                }
                else
                {
                    rep->result_header = FALSE;
                }                                        
                break;
             case UT_XV_FUNC_DRIVER_VIASync : 
                if(pVia->pBIOSInfo->Is3DScalingEnable & DISP_3D_SCALING_ENABLE)
                {
                    if(pVia->pBIOSInfo->IsStableStatus)
                    {
 //                       VIADISP3DScalingImageProcessing(pVia);
                    }
                }             
                rep->result_header = TRUE;
                break;             
            case UT_XV_FUNC_DRIVER_GetFuncState:
                if(pVia->DISP3DScalingCaps & DISPLAY_3D_SCALING_SUPPORT)
                {
                    rep->result[0] = MapFunStateForUT(pVia->DISP3DScalingCaps);
                }
                else
                {
                    rep->result[0] = NO_3DSCALING;
                }
                rep->result_header = TRUE;
                break;
        }
    }
    else if (rep->primary_id == UT_XV_FUNC_DEVICE)
    {
        switch (rep->secondary_id)
        {                            
            case UT_XV_FUNC_DEVICE_GetSupportState :
                VIA_UT_DEVICE_GetSupportState(pBIOSInfo, &dwSupportState);
                rep->result[0] = dwSupportState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_GetConnectState:                    
                VIA_UT_DEVICE_GetConnectState(pBIOSInfo, &dwConnectState);
                rep->result[0] = dwConnectState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_GetActiveState:
                VIA_UT_DEVICE_GetActiveState(pScrn, &dwCurrentState);
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_SetActiveState:
                VIA_UT_DEVICE_SetActiveState(pBIOSInfo, pScrn->currentMode, rep->parm[0]);
                rep->result_header = TRUE;
                break;                           
                
            case UT_XV_FUNC_DEVICE_GetSAMMState :                    
                VIA_UT_DEVICE_GetSAMMState(pBIOSInfo, &dwCurrentState); 
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_GetSupportSAMMState :                    
                VIA_UT_DEVICE_GetSupportSAMMState(pBIOSInfo, &dwSupportState);
                rep->result[0] = dwSupportState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_SetV3OnIGAStatus :                    
                if (VIA_UT_DEVICE_SetV3OnIGAStatus(pScrn, rep->parm[0]))
                {
                    rep->result_header = TRUE;
                }
                else
                {
                    rep->result_header = FALSE;
                }
                break;
                
            case UT_XV_FUNC_DEVICE_GetV3OnIGAStatus :                                            
                VIA_UT_DEVICE_GetV3OnIGAStatus(pScrn, &dwCurrentState);
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;

            case UT_XV_FUNC_DEVICE_GetDuoViewStatus :                    
                VIA_UT_DEVICE_GetDuoViewStatus(pScrn, &dwCurrentState);
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;

            case UT_XV_FUNC_DEVICE_GetPanningState:
                dwCurrentState = VIA_UT_DEVICE_GetPanningState(pBIOSInfo);
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;
            case UT_XV_FUNC_DEVICE_GetPrimaryDevice:
                VIA_UT_DEVICE_GetPrimaryDevice(pBIOSInfo, &dwCurrentState);
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;
        }
    }
    else if (rep->primary_id == UT_XV_FUNC_PANEL)
    {
        switch (rep->secondary_id)
        {                   
            case UT_XV_FUNC_DEVICE_GetPanelInfo:                        
                VIA_UT_DEVICE_GetPanelInfo(pBIOSInfo, rep->parm[0], &UTPanelInfo);
                rep->result[0] = UTPanelInfo.dwType;
                rep->result[1] = UTPanelInfo.dwResX;
                rep->result[2] = UTPanelInfo.dwResY;
                rep->result[3] = UTPanelInfo.dwDeviceID;
                rep->result[4] = UTPanelInfo.dwExpandState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_GetSupportExpand:                    
                VIA_UT_DEVICE_GetSupportExpand(pBIOSInfo, &dwSupportState);
                rep->result[0] = dwSupportState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_GetExpandState:
                VIA_UT_DEVICE_GetExpandState(pBIOSInfo, &dwCurrentState);
                rep->result[0] = dwCurrentState;
                rep->result_header = TRUE;
                break;
                
            case UT_XV_FUNC_DEVICE_SetExpandState:
                UTPanelInfo.dwType = rep->parm[0];
                UTPanelInfo.dwResX = rep->parm[1];
                UTPanelInfo.dwResY = rep->parm[2];
                UTPanelInfo.dwDeviceID = rep->parm[3];
                UTPanelInfo.dwExpandState = rep->parm[4];
                if(VIA_UT_DEVICE_SetExpandState(pBIOSInfo, pScrn->currentMode, UTPanelInfo))
                {
                    rep->result_header = TRUE;
                }
                else
                {
                    rep->result_header = FALSE;
                }
                break;
            case UT_XV_FUNC_DEVICE_GetPanleMaxViewSizeValue:                
                VIA_UT_DEVICE_GetPanleMaxViewSizeValue(pBIOSInfo, &MaxViewSizeValue, rep->parm[0]);
                rep->result[0] = MaxViewSizeValue.dwX;
                rep->result[1] = MaxViewSizeValue.dwY;
                rep->result_header = TRUE;
                 break;
            case UT_XV_FUNC_DEVICE_GetPanleViewSizeValue:
                VIA_UT_DEVICE_GetPanleViewSizeValue(pBIOSInfo, &ViewSizeValue, rep->parm[0]);
                rep->result[0] = ViewSizeValue.dwX;
                rep->result[1] = ViewSizeValue.dwY;
                rep->result_header = TRUE;                
                break;
            case UT_XV_FUNC_DEVICE_SetPanleViewSizeValue:
                ViewSizeValue.dwX = rep->parm[0];
                ViewSizeValue.dwY = rep->parm[1];
                VIA_UT_DEVICE_SetPanleViewSizeValue(pBIOSInfo, ViewSizeValue, rep->parm[2]); 
                rep->result_header = TRUE;            
                break;
            case UT_XV_FUNC_DEVICE_GetPanleMaxViewPositionValue:
                VIA_UT_DEVICE_GetPanleMaxViewPositionValue(pBIOSInfo, &MaxViewPosValue, rep->parm[0]);
                rep->result[0] = MaxViewPosValue.dwX;
                rep->result[1] = MaxViewPosValue.dwY;
                rep->result_header = TRUE;            
                break;
            case UT_XV_FUNC_DEVICE_GetPanleViewPositionValue: 
                VIA_UT_DEVICE_GetPanleViewPositionValue(pBIOSInfo, &ViewPosValue, rep->parm[0]);
                rep->result[0] = ViewPosValue.dwX;
                rep->result[1] = ViewPosValue.dwY;
                rep->result_header = TRUE;            
                break;
            case UT_XV_FUNC_DEVICE_SetPanleViewPositionValue:
                ViewPosValue.dwX = rep->parm[0];
                ViewPosValue.dwY = rep->parm[1];
                if (VIA_UT_DEVICE_SetPanleViewPositionValue(pBIOSInfo, ViewPosValue, rep->parm[2] ))            
                    rep->result_header = TRUE;            
                else            
                    rep->result_header = FALSE;            
                break;            
        }
    }
    else if (rep->primary_id == UT_XV_FUNC_GAMMA)
    {
        switch (rep->secondary_id)
        {
            case UT_ESC_FUNC_GAMMA_GetDeviceSupportState:
                VIA_UT_GAMMA_GetDeviceSupportState(pScrn, &dwSupportState);
                rep->result[0] = dwSupportState;
                rep->result_header = TRUE;
                break;
                
            case UT_ESC_FUNC_GAMMA_GetLookUpTable:
                VIA_UT_GAMMA_GetLookUpTable(pBIOSInfo, dwGammaLUT);
                for (i=0; i<256; i++)
                {
                    rep->result[i] = dwGammaLUT[i];
                }
                rep->result_header = TRUE;
                break;
                
            case UT_ESC_FUNC_GAMMA_SetLookUpTable:
                for (i=0; i<256; i++)
                {
                    dwGammaLUT[i] = rep->parm[i];
                }
                
                if (VIA_UT_GAMMA_SetLookUpTable(pScrn, dwGammaLUT))
                {
                    rep->result_header = TRUE;
                }
                else
                {
                    rep->result_header = FALSE;
                }
                break;
                
            case UT_ESC_FUNC_GAMMA_GetDefaultLookUpTable:
                VIA_UT_GAMMA_GetDefaultLookUpTable(pBIOSInfo, dwGammaLUT);
                for (i=0; i<256; i++)
                {
                    rep->result[i] = dwGammaLUT[i];
                }
                rep->result_header = TRUE;
                break;
        }
    }
    else if (rep->primary_id == UT_XV_FUNC_DISPLAY)
    {
        switch (rep->secondary_id)
        {
            case UT_XV_FUNC_DISPLAY_EnumModes:
                VIA_UT_DISPLAY_EnumModes(pBIOSInfo, rep->parm[0], &DevMode);
                rep->result[0] = DevMode.ModeIndex;
                rep->result[1] = DevMode.PelsWidth;
                rep->result[2] = DevMode.PelsHeight;
                rep->result[3] = DevMode.RefreshRateNum;
                
                for (i = 0; i < DevMode.RefreshRateNum; i++)
                {
                    rep->result[i+4] = DevMode.RefreshRate[i];
                }
                rep->result_header = TRUE; 
                
                break;
                
            case UT_XV_FUNC_DISPLAY_GetCurrentMode:
                VIA_UT_DISPLAY_GetCurrentMode(pBIOSInfo, &DevMode);
                rep->result[0] = DevMode.ModeIndex;
                rep->result[1] = DevMode.PelsWidth;
                rep->result[2] = DevMode.PelsHeight;
                rep->result[3] = DevMode.RefreshRateNum;
                
                for (i = 0; i < DevMode.RefreshRateNum; i++)
                {
                    rep->result[i+4] = DevMode.RefreshRate[i];
                }
                rep->result_header = TRUE;
                
                break;    

             case UT_XV_FUNC_DISPLAY_GetCurrentRotateDegree:
                VIA_UT_DISPLAY_GetCurrentRotateDegree(pScrn, &dwRotateType, &dwRotateDegree);
                rep->result[0] = dwRotateType;
                rep->result[1] = dwRotateDegree;
                rep->result_header = TRUE;
                break;

             case UT_XV_FUNC_DISPLAY_GetRotateCaps:
                VIA_UT_DISPLAY_GetRotationCaps(pScrn, rep->parm[0], &dwSupportState);
                rep->result[0] = dwSupportState;
                rep->result_header = TRUE;
                break;

             case UT_XV_FUNC_DISPLAY_SetRotateDegree:
                VIA_UT_DISPLAY_SetRotateDegree(pScrn, rep->parm[1]);                
                rep->result_header = TRUE;
                break;
        }
    }
    
    return Success;
}


