/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_UTILITY_H_
#define _VIA_UTILITY_H_ 1

/*
 * Define for Utility functions using XvPutImage.
 */

/*******************************************************************
 *  Primary ID                                                     *
 *******************************************************************/
#define UT_XV_FUNC_BIOS         0x11   /* Primary ID */
#define UT_XV_FUNC_DRIVER       0x12
#define UT_XV_FUNC_DEVICE       0x13
#define UT_XV_FUNC_PANEL        0x14
#define UT_XV_FUNC_GAMMA        0x16
#define UT_XV_FUNC_DISPLAY      0x18

/*******************************************************************
 *  Secondary ID                                                   *
 *******************************************************************/
#define UT_XV_FUNC_BIOS_GetChipID           0x01    /* Get Chip ID */
#define UT_XV_FUNC_BIOS_GetVersion          0x02    /* Get the version of the BIOS */
#define UT_XV_FUNC_BIOS_GetDate             0x03    /* Get the date (year, month, day) of the BIOS. */
#define UT_XV_FUNC_BIOS_GetVideoMemSizeMB   0x04    /* Get the video memory size, in MB */

#define UT_XV_FUNC_DRIVER_GetFileName       0x01
#define UT_XV_FUNC_DRIVER_GetFileVersion    0x02
#define UT_XV_FUNC_DRIVER_VIASync           0x03
#define UT_XV_FUNC_DRIVER_GetFuncState             0x04


#define UT_XV_FUNC_DEVICE_GetSupportState       1
#define UT_XV_FUNC_DEVICE_GetConnectState       2
#define UT_XV_FUNC_DEVICE_GetActiveState        3
#define UT_XV_FUNC_DEVICE_SetActiveState        4
#define UT_XV_FUNC_DEVICE_GetSAMMState          5
#define UT_XV_FUNC_DEVICE_GetRoateState         6
#define UT_XV_FUNC_DEVICE_SetRoateState         7
#define UT_XV_FUNC_DEVICE_GetSupportSAMMState   8
#define UT_XV_FUNC_DEVICE_SetV3OnIGAStatus      9
#define UT_XV_FUNC_DEVICE_GetV3OnIGAStatus      10
#define UT_XV_FUNC_DEVICE_GetDuoViewStatus      11
#define UT_XV_FUNC_DEVICE_GetPanningState       12
#define UT_XV_FUNC_DEVICE_GetPrimaryDevice      13 

#define UT_XV_FUNC_DEVICE_SetTargetPanel    1
#define UT_XV_FUNC_DEVICE_GetPanelInfo      2
#define UT_XV_FUNC_DEVICE_GetExpandState    3
#define UT_XV_FUNC_DEVICE_SetExpandState    4
#define UT_XV_FUNC_DEVICE_GetSupportExpand  5
#define UT_XV_FUNC_DEVICE_GetPanleMaxViewSizeValue        6
#define UT_XV_FUNC_DEVICE_GetPanleViewSizeValue               7
#define UT_XV_FUNC_DEVICE_SetPanleViewSizeValue                8
#define UT_XV_FUNC_DEVICE_GetPanleMaxViewPositionValue  9
#define UT_XV_FUNC_DEVICE_GetPanleViewPositionValue         10
#define UT_XV_FUNC_DEVICE_SetPanleViewPositionValue          11


#define UT_ESC_FUNC_GAMMA_GetDeviceSupportState     1
#define UT_ESC_FUNC_GAMMA_GetLookUpTable            2
#define UT_ESC_FUNC_GAMMA_SetLookUpTable            3
#define UT_ESC_FUNC_GAMMA_GetDefaultLookUpTable     4

#define UT_XV_FUNC_DISPLAY_EnumModes                1
#define UT_XV_FUNC_DISPLAY_GetCurrentMode           2
#define UT_XV_FUNC_DISPLAY_GetRotateCaps            3
#define UT_XV_FUNC_DISPLAY_GetCurrentRotateDegree   4
#define UT_XV_FUNC_DISPLAY_SetRotateDegree          5

/*******************************************************************
 *  Input & Output Data                                            *
 *******************************************************************/
#define DISPLAY_DRIVER                  1
#define VIDEO_CAPTURE_DRIVER            2
#define HWOVERLAY_DRIVER                3
#define HWMPEG2_DECODER                 4

#define UT_DEVICE_NONE                  0x000
#define UT_DEVICE_CRT1                  0x001
#define UT_DEVICE_LCD                   0x002
#define UT_DEVICE_DFP                   0x008
#define UT_DEVICE_LCD2                  0x080
#define UT_DEVICE_DFP2                  0x100



#define UT_STATE_SAMM_OFF               0       /* Not in SAMM mode. */
#define UT_STATE_SAMM_ON                1       /* In SAMM mode. */
#define UT_STATE_DuoView_OFF            0       /* Not in Duoview mode. */
#define UT_STATE_DuoView_ON             1       /* In Duoview mode. */
#define UT_STATE_DuoView_IGA1           0       /* In Duoview mode(7205,320432053314),video on IGA1 */
#define UT_STATE_DuoView_IGA2           1       /* In Duoview mode(7205,320432053314),video on IGA2 */

#define UT_ROTATE_TYPE_NONE             0       /* Not rotation */
#define UT_ROTATE_TYPE_SW               1       /* Use software rotation */
#define UT_ROTATE_TYPE_HW               2       /* Use hardware rotation */

#define UT_ROTATE_NONE                  0x0       /* Normal. */
#define UT_ROTATE_90_DEG                0x1       /* Rotate 90 deg. clockwise. */
#define UT_ROTATE_180_DEG               0x2       /* Rotate 180 deg. clockwise. */
#define UT_ROTATE_270_DEG               0x4       /* Rotate 270 deg. clockwise. */

#define UT_PANEL_TYPE_STN               0       /* STN. */
#define UT_PANEL_TYPE_TFT               1       /* TFT. */

#define UT_STATE_EXPAND_OFF             0       /* Not expanded; centered. */
#define UT_STATE_EXPAND_ON              1       /* Expanded. */

#define UT_PANEL_SUPPORT_EXPAND_OFF     0
#define UT_PANEL_SUPPORT_EXPAND_ON      1

/*3d scaling state*/
#define  NO_3DSCALING  0//3dscaling not enabled


#define UT_STATE_OFF                    0
#define UT_STATE_ON                     1
#define UT_STATE_DEFAULT                0xFFFF
#define UT_DEVICE_SUPPORT_SAMM_STATE_OFF    0
#define UT_DEVICE_SUPPORT_SAMM_STATE_ON     1

/* For XVDeviceControl */
#define XV_DC_OFF               0x10000
#define XV_DC_ON                0x20000


typedef struct _UTBIOSVERSION
{
    CARD32 dwVersion;    /* The version. */
    CARD32 dwRevision;   /* The revision. */
} UTBIOSVERSION;

typedef struct _UTBIOSDATE
{
    CARD32 dwYear;   /* Year, like 2001. */
    CARD32 dwMonth;  /* Month, like 5, 12. */
    CARD32 dwDay;    /* Day, like 7, 30. */
} UTBIOSDATE;

typedef struct _UTDriverVersion
{
    CARD32 dwMajorNum;
    CARD32 dwMinorNum;
    CARD32 dwOSNum;
    CARD32 dwReversionNum;
} UTDriverVersion;

typedef struct _UTXYVALUE
{
    CARD32 dwX;
    CARD32 dwY;
} UTXYVALUE;

typedef struct _UTDEVICEINFO
{
    CARD32 dwDeviceType;
    CARD32 dwResX;
    CARD32 dwResY;
    CARD32 dwColorDepth;
} UTDEVICEINFO;

typedef struct _UTPANELINFO
{
    CARD32 dwType;  /* Panel type */
    CARD32 dwResX;  /* X Resolution of the panel. */
    CARD32 dwResY;  /* Y Resolution of the panel. */
    CARD32 dwDeviceID; /* Panel could be on LCD, LCD2, DVI, DVI2 */
    CARD32 dwExpandState;   /* Expand state */
} UTPANELINFO;


typedef struct _UTGAMMAINFO
{
    UTDEVICEINFO    DeviceInfo;         /* E.g., if we want the table of CRT1, we should set */
    CARD32          LookUpTable[256];   /* the dwDeviceType as UT_DEVICE_CRT1.               */
} UTGAMMAINFO;


/* For Display modes: */
typedef struct _UTDEVMODE
{
    int ModeIndex;          /* Specify the index of mode. */
    int PelsWidth;          /* Specify the width, in pixels. */
    int PelsHeight;         /* Specify the height, in pixels. */
    int RefreshRateNum;     /* Specify the number of supported refresh rates. */
    int RefreshRate[10];    /* Specify supported refresh rates for this mode. */
} UTDEVMODE, *LPUTDEVMODE;


/* Functions protype */
Bool VIASaveUserSetting(VIABIOSInfoPtr  pBIOSInfo);

/* For display Xextension */
#define VIAGFX_PROTOCOL_NAME   "VIAGFX_API"

#define VIAGFX_PARM_NUM         256

#define X_VIAGFXQueryVersion   0
#define X_VIAGFXCommand        1

typedef struct {
    BYTE    type;           /* X_Reply */
    BOOL    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    CARD16  majorVersion B16;   
    CARD16  minorVersion B16;   
    CARD32  pad2 B32;
    CARD32  pad3 B32;
    CARD32  pad4 B32;
    CARD32  pad5 B32;
    CARD32  pad6 B32;
} xVIAGFXQueryVersionReply;


typedef struct _VIAGFXQueryVersion {
    CARD8   reqType;
    CARD8   VIAGFXReqType;
    CARD16  length B16;
} xVIAGFXQueryVersionReq;


typedef struct {
    CARD8   reqType;
    CARD8   VIAGFXReqType;
    CARD16  length B16;
    CARD32  pad1 B32;
    CARD32  primary_id;
    CARD32  secondary_id;
    CARD32  command;
    CARD32  parm[VIAGFX_PARM_NUM];
    CARD32  result_header;
    CARD32  result[VIAGFX_PARM_NUM];    
} xVIAGFXCommandReq;
#define sz_xVIAGFXCommandReq       sizeof(xVIAGFXCommandReq)


typedef struct {
    BYTE    type;           /* X_Reply */
    BOOL    pad1;
    CARD16  sequenceNumber B16;
    CARD32  length B32;
    CARD32  primary_id;
    CARD32  secondary_id;
    CARD32  command;
    CARD32  parm[VIAGFX_PARM_NUM];
    CARD32  result_header;
    CARD32  result[VIAGFX_PARM_NUM];    
} xVIAGFXCommandReply;
#define sz_xVIAGFXCommandReply     sizeof(xVIAGFXCommandReply)

typedef struct {
    int      (*HandleVIAGFXCommand[2])(xVIAGFXCommandReply *);
} xVIAGFXScreenTable;

int VIAGFXUtilityProc(xVIAGFXCommandReply* rep);



#endif  /* _VIA_UTILITY_H_ */
