 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

 
/*
 * I N C L U D E S
 */
#include "Xv.h"
#include "dixstruct.h"
#include "pixman.h"
#include "xf86_OSproc.h"
#include "via_include.h"
#include "compiler.h"
#include "xf86PciInfo.h"
#include "xf86Pci.h"
#include "xf86fbman.h"
#include "regionstr.h"
#include "via_driver.h"
#include "via_video.h"
#include "via_eng_reg_fops.h"

#include "debug.h"      /* for DBG_DD */
#include "via_eng_regs.h"
#include "fourcc.h"
#include "xf86.h"
#include "xf86xv.h"
#include "xaa.h"
#include "xaalocal.h"
#include "xf86Resources.h"


/*
 * D E F I N E
 */
#define  XV_IMAGE          0
#define MAKE_ATOM(a) MakeAtom(a, sizeof(a) - 1, TRUE)

#define MAXWIDTH 2048
#define MAXHEIGHT 2048
#ifndef REGION_NULL
#define REGION_NULL(_pScreen,_pReg)\
	REGION_INIT(_pScreen,_pReg,NullBox,1)
#endif

#ifndef REGION_EQUAL
#define  REGION_EQUAL(_pScreen, _pReg1, _pReg2)\
	 miRegionEqual(_pReg1,_pReg2)	
#endif
#ifdef XvExtension

/* FUNCTION DECLARATION */
static int viaSetupImageVideoG(ScreenPtr, XF86VideoAdaptorPtr *);
static int viaSetupImageVideoTextureG(ScreenPtr, XF86VideoAdaptorPtr *);
static void viaStopVideoG(ScrnInfoPtr, pointer, Bool);
static int viaSetPortAttributeG(ScrnInfoPtr, Atom, INT32, pointer);
static int viaGetPortAttributeG(ScrnInfoPtr, Atom ,INT32 *, pointer);
static void viaQueryBestSizeG(ScrnInfoPtr, Bool,
        short, short, short, short, unsigned int *, unsigned int *, pointer);

int viaPutImageG( ScrnInfoPtr,
        short, short, short, short, short, short, short, short,
        int, unsigned char*, short, short, Bool, RegionPtr, pointer, DrawablePtr );
extern int viaPutImageTexturedG( ScrnInfoPtr,
        short, short, short, short, short, short, short, short,
        int, unsigned char*, short, short, Bool, RegionPtr, pointer, DrawablePtr);
static int viaReputImageG( ScrnInfoPtr,
        short, short, RegionPtr, pointer, DrawablePtr );

unsigned long viaCreateXvSurface(ScrnInfoPtr , viaPortPrivPtr , unsigned long , unsigned long , unsigned long );
void viaDestroyXvSurface(ScrnInfoPtr, viaPortPrivPtr);
unsigned long  viaDestroyOverlaySurface(ScrnInfoPtr ,viaPortPrivPtr ,unsigned long );

static int viaQueryImageAttributesG(ScrnInfoPtr, int, unsigned short *, unsigned short *,  int *, int *);
void StopOVerlay(ScrnInfoPtr ,viaPortPrivPtr );


/* GLOBALS */
static Atom xvBrightness, xvContrast, xvColorKey,xvHue,xvSaturation
            , xvOverlayStatus, xv_autopaint_colorkey;

/* EXTERN GLOBALS*/

/* STRUCTS */

/* client libraries expect an encoding */
static XF86VideoEncodingRec DummyEncoding[1] =
{
  { XV_IMAGE        , "XV_IMAGE",MAXWIDTH, MAXHEIGHT,{1, 1}}
};

#define NUM_FORMATS_G 9

static XF86VideoFormatRec FormatsG[NUM_FORMATS_G] =
{
  { 8, TrueColor }, /* Dithered */
  { 8, PseudoColor }, /* Using .. */
  { 8, StaticColor },
  { 8, GrayScale },
  { 8, StaticGray }, /* .. TexelLUT */
  {16, TrueColor},
  {24, TrueColor},
  {16, DirectColor},
  {24, DirectColor}
};

#define NUM_ATTRIBUTES_G 7

static XF86AttributeRec AttributesG[NUM_ATTRIBUTES_G] =
{
   {XvSettable | XvGettable, 0, 10000, "XV_BRIGHTNESS"},
   {XvSettable | XvGettable, 0, 20000, "XV_CONTRAST"},
   {XvSettable | XvGettable, 0, 20000, "XV_SATURATION"},
   {XvSettable | XvGettable, -180, 180,"XV_HUE"},
   {XvGettable,0,1,"XV_OVERLAYSTATUS"},
   {XvSettable | XvGettable, 0, (1 << 24) - 1, "XV_COLORKEY"},
   {XvSettable | XvGettable,0,1,"XV_AUTOPAINT_COLORKEY"}
};

#define NUM_ATTRIBUTES_G_CLEAX 7

static XF86AttributeRec AttributesG_CLEAX[NUM_ATTRIBUTES_G_CLEAX] =
{
   {XvSettable | XvGettable, 0, (1 << 24) - 1, "XV_COLORKEY"},
   {XvSettable | XvGettable,0,255,"XV_MUTE"},
   {XvSettable | XvGettable,0,255,"XV_VOLUME"},
   {XvSettable | XvGettable,0, 255,"XV_ENCODING"},
   {XvSettable,0,-1,"XV_FREQ"},
   {XvSettable,0,2,"XV_AUDIOCTRL"},
   {XvSettable | XvGettable,0,1,"XV_AUTOPAINT_COLORKEY"}
   
};

#define NUM_IMAGES_G 4

static XF86ImageRec ImagesG[NUM_IMAGES_G] =
{
    XVIMAGE_YUY2,
    XVIMAGE_YV12,
    XVIMAGE_I420,
    XVIMAGE_VDPAU      
};

/*
 *  F U N C T I O N
 */
void viaResetVideo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile video_via_regs *viaVidEng = NULL;

    DBG_DD((" via_video.c : viaResetVideo: \n"));
    viaVidEng = (volatile video_via_regs *)pVia->VidMapBase;

    viaVidEng->video1_ctl = 0;
    viaVidEng->video3_ctl = 0;
    viaVidEng->compose    = 0x80000000;
    viaVidEng->compose    = 0x40000000;
}

void viaSaveVideo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile video_via_regs  *viaVidEng = NULL;
    video_via_regs  *localVidEng = &pVia->VidEngSaved;;

    DBG_DD((" via_video.c : viaSaveVideo : \n"));
    viaVidEng = (volatile video_via_regs *)pVia->VidMapBase;
    memcpy((void*)localVidEng,(void *)viaVidEng,sizeof(video_via_regs));
    
    if (pVia->ChipId!=PCI_CHIP_VT3314)
        viaVidEng->compose   |= V1_COMMAND_FIRE;   /*fire V1*/
    viaVidEng->compose   |= V3_COMMAND_FIRE;
    
   DEBUG( xf86DrvMsg(pScrn->scrnIndex, X_INFO, "video1 CSC(%lx,%lx)\n",
            localVidEng->video1_CSC1, localVidEng->video1_CSC2));
   DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "video1 addr0:%lx,addr1:%lx\n",
            localVidEng->video1y_addr0 , localVidEng->video1y_addr1));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "video3 CSC(%lx,%lx)\n",
            localVidEng->video3_CSC1, localVidEng->video3_CSC2));
    DEBUG(xf86DrvMsg(pScrn->scrnIndex, X_INFO, "video3 addr0:%lx,addr1:%lx\n",
            localVidEng->video3_addr0 , localVidEng->video3_addr1));
}

void viaRestoreVideo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile video_via_regs  *viaVidEng = NULL;
    video_via_regs  *localVidEng = &pVia->VidEngSaved;;

    DBG_DD((" via_video.c : viaRestoreVideo : \n"));

    viaVidEng = (volatile video_via_regs *)pVia->VidMapBase;
    /*flush restored video engines' setting to VidMapBase*/
    viaVidEng = (volatile video_via_regs *)pVia->VidMapBase;
    viaVidEng->alphawin_hvstart = localVidEng->alphawin_hvstart;
    viaVidEng->alphawin_size   = localVidEng->alphawin_size;
    viaVidEng->alphawin_ctl    = localVidEng->alphawin_ctl;
    viaVidEng->alphafb_stride  = localVidEng->alphafb_stride;
    viaVidEng->color_key       = localVidEng->color_key;
    viaVidEng->alphafb_addr    = localVidEng->alphafb_addr;
    viaVidEng->chroma_low      = localVidEng->chroma_low;
    viaVidEng->chroma_up       = localVidEng->chroma_up;

    if (pVia->ChipId != PCI_CHIP_VT3314)
    {
        /*VT3314 only has V3*/
        viaVidEng->video1_ctl      = localVidEng->video1_ctl;
        viaVidEng->video1_fetch    = localVidEng->video1_fetch;
        viaVidEng->video1y_addr1   = localVidEng->video1y_addr1;
        viaVidEng->video1_stride   = localVidEng->video1_stride;
        viaVidEng->video1_hvstart  = localVidEng->video1_hvstart;
        viaVidEng->video1_size     = localVidEng->video1_size;
        viaVidEng->video1y_addr2   = localVidEng->video1y_addr2;
        viaVidEng->video1_zoom     = localVidEng->video1_zoom;
        viaVidEng->video1_mictl    = localVidEng->video1_mictl;
        viaVidEng->video1y_addr0   = localVidEng->video1y_addr0;
        viaVidEng->video1_fifo     = localVidEng->video1_fifo;
        viaVidEng->video1y_addr3   = localVidEng->video1y_addr3;
        viaVidEng->v1_source_w_h   = localVidEng->v1_source_w_h ;
        viaVidEng->video1_CSC1     = localVidEng->video1_CSC1;
        viaVidEng->video1_CSC2     = localVidEng->video1_CSC2;
    }
    viaVidEng->snd_color_key   = localVidEng->snd_color_key;
    viaVidEng->v3alpha_prefifo = localVidEng->v3alpha_prefifo;
    viaVidEng->v3alpha_fifo    = localVidEng->v3alpha_fifo;
    viaVidEng->video3_CSC2     = localVidEng->video3_CSC2;
    viaVidEng->video3_CSC2     = localVidEng->video3_CSC2;
    viaVidEng->v3_source_width = localVidEng->v3_source_width;
    viaVidEng->video3_ctl      = localVidEng->video3_ctl;
    viaVidEng->video3_addr0    = localVidEng->video3_addr0;
    viaVidEng->video3_addr1    = localVidEng->video3_addr1;
    viaVidEng->video3_stride   = localVidEng->video3_stride;
    viaVidEng->video3_hvstart  = localVidEng->video3_hvstart;
    viaVidEng->video3_size     = localVidEng->video3_size;
    viaVidEng->v3alpha_fetch   = localVidEng->v3alpha_fetch;
    viaVidEng->video3_zoom     = localVidEng->video3_zoom;
    viaVidEng->video3_mictl    = localVidEng->video3_mictl;
    viaVidEng->video3_CSC1     = localVidEng->video3_CSC1;
    viaVidEng->video3_CSC2     = localVidEng->video3_CSC2;    
    viaVidEng->compose         = localVidEng->compose;
    
    if (pVia->ChipId != PCI_CHIP_VT3314)
        viaVidEng->compose   |= V1_COMMAND_FIRE;  /*fire V3*/
    viaVidEng->compose   |= V3_COMMAND_FIRE;
}

void viaSaveHqv(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile hqv_via_regs  *viaHqvEng = NULL;
    hqv_via_regs  *localHqvEng0 = &pVia->HqvSaved[0];
    hqv_via_regs  *localHqvEng1 = &pVia->HqvSaved[1];

    DBG_DD((" via_video.c : viaSaveHqv : \n"));
    
    viaHqvEng=(volatile hqv_via_regs *)(pVia->VidMapBase + 0x1c0); 
    memcpy((void*)localHqvEng0,(void *)viaHqvEng, sizeof(hqv_via_regs));
    xf86DrvMsg(pScrn->scrnIndex, X_INFO,"Hqv0Saved.hqv_ctl:%lx\n", localHqvEng0->hqv_ctl );
    
    if (pVia->ChipId!=PCI_CHIP_VT3314)
    {
        viaHqvEng=(volatile hqv_via_regs *)(pVia->VidMapBase + 0x1000 + 0x1c0); 
        memcpy((void*)localHqvEng1, (void *)viaHqvEng, sizeof(hqv_via_regs));
        xf86DrvMsg(pScrn->scrnIndex, X_INFO,"Hqv1Saved.hqv_ctl:%lx\n", localHqvEng1->hqv_ctl );
    }
}

void viaRestoreHqv(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile hqv_via_regs  *viaHqvEng = NULL;
    hqv_via_regs  *localHqvEng0 = &pVia->HqvSaved[0];
    hqv_via_regs  *localHqvEng1 = &pVia->HqvSaved[1];

    viaHqvEng=(volatile hqv_via_regs *)(pVia->VidMapBase + 0x1c0); 

    /*flush all HQV0 settings to start address 0x3c0*/
    memcpy((void *)viaHqvEng,(void*)localHqvEng0, sizeof(hqv_via_regs));
    xf86DrvMsg(pScrn->scrnIndex, X_INFO,"Hqv0 hqv_ctl:%lx\n",viaHqvEng->hqv_ctl );
    if (pVia->ChipId!=PCI_CHIP_VT3314)
    {
        viaHqvEng=(volatile hqv_via_regs *)(pVia->VidMapBase + 0x1c0 + 0x1000);
        memcpy((void *)viaHqvEng,(void*)localHqvEng1, sizeof(hqv_via_regs));
        
        xf86DrvMsg(pScrn->scrnIndex, X_INFO,"Hqv1 hqv_ctl:%lx\n",viaHqvEng->hqv_ctl );
    }
    
}

void viaExitVideo(ScrnInfoPtr pScrn)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile video_via_regs  *viaVidEng = NULL;
    DBG_DD((" via_video.c : viaExitVideo : \n"));
    
    /*destroy XV reserved memory structure here.*/
    
    viaVidEng = (volatile video_via_regs *)pVia->VidMapBase;
    viaVidEng->video1_ctl = 0;
    viaVidEng->video3_ctl = 0;
    viaVidEng->compose    = V1_COMMAND_FIRE;
    viaVidEng->compose    = V3_COMMAND_FIRE;
}

static char *XvAdaptorName[XV_ADAPT_NUM] = {
    "XV_SWOV",
    "XV_TEXTURE"
};

static char * XVOVERLAYPORTNAME[XV_PORT_NUM_OVERLAY] =
{
   "XV_SWOV0",
   "XV_SWOV1"
};

static char * XVTEXVIDEOPORTNAME[XV_PORT_NUM_TEXTURE] =
{
   "XV_TEXTURE0",
   "XV_TEXTURE1",
   "XV_TEXTURE2",
   "XV_TEXTURE3",
   "XV_TEXTURE4",
   "XV_TEXTURE5",
   "XV_TEXTURE6",
   "XV_TEXTURE7",
   "XV_TEXTURE8",
   "XV_TEXTURE9",
   "XV_TEXTURE10",
   "XV_TEXTURE11",
   "XV_TEXTURE12",
   "XV_TEXTURE13",
   "XV_TEXTURE14",
   "XV_TEXTURE15"
};

static XF86VideoAdaptorPtr viaAdaptPtr[XV_ADAPT_NUM];
static viaPortPrivRec *gviaPortPriv[XV_ADAPT_NUM];
static unsigned numAdaptPort[XV_ADAPT_NUM] = { XV_PORT_NUM_OVERLAY, XV_PORT_NUM_TEXTURE};

void viaInitVideo(ScreenPtr pScreen)
{
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    VIAPtr  pVia = VIAPTR(pScrn);
    XF86VideoAdaptorPtr *adaptors, *allAdaptors = NULL;
    XF86VideoAdaptorPtr newAdaptors[XV_ADAPT_NUM] = {NULL, NULL};
    int num_newAdaptors = 0;
    
    int num_adaptors;

    DBG_DD((" via_video.c : viaInitVideo : \n"));
    DBG_DD((" via_video.c : Screen[%d]\n", pScrn->scrnIndex));

    num_adaptors = xf86XVListGenericAdaptors(pScrn, &adaptors);
    DBG_DD((" via_video.c : num_adaptors : %d\n",num_adaptors));

    num_newAdaptors = viaSetupImageVideoG(pScreen, &newAdaptors[0]);
    num_newAdaptors += viaSetupImageVideoTextureG(pScreen, &newAdaptors[num_newAdaptors]);

    if(num_newAdaptors)
    {
        if(!num_adaptors)
        {
            num_adaptors = num_newAdaptors;
            allAdaptors = xalloc((num_newAdaptors) * sizeof(XF86VideoAdaptorPtr));
            memcpy(allAdaptors, newAdaptors, num_newAdaptors * sizeof(XF86VideoAdaptorPtr)); 
        }
        else
        {
            DBG_DD((" via_video.c : viaInitVideo : Warning !!! MDS not supported yet !\n"));
            allAdaptors = xalloc((num_adaptors + num_newAdaptors) * sizeof(XF86VideoAdaptorPtr));
            if(allAdaptors)
            {
                memcpy(allAdaptors, adaptors, num_adaptors * sizeof(XF86VideoAdaptorPtr));
                memcpy(allAdaptors + num_adaptors, newAdaptors, num_newAdaptors * sizeof(XF86VideoAdaptorPtr));
                num_adaptors += num_newAdaptors;
            }
        }
    }

    if(num_adaptors)
        xf86XVScreenInit(pScreen, allAdaptors, num_adaptors);

    if(allAdaptors)
        xfree(allAdaptors);
}


static int viaSetupImageVideoG(ScreenPtr pScreen, XF86VideoAdaptorPtr *adaptorPtr)
{
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo; 
    DevUnion  * pdevUnion;
    int i;

    int num_overlay_ports = numAdaptPort[XV_ADAPT_OVERLAY];


    DBG_DD((" via_video.c : viaSetupImageVideoOverlayG: \n"));
    DBG_DD((" via_video.c : Screen[%d]\n", pScrn->scrnIndex));

    xvBrightness      = MAKE_ATOM("XV_BRIGHTNESS");
    xvContrast        = MAKE_ATOM("XV_CONTRAST");
    xvSaturation      = MAKE_ATOM("XV_SATURATION");
    xvHue             = MAKE_ATOM("XV_HUE");
    xvOverlayStatus   = MAKE_ATOM("XV_OVERLAYSTATUS");
    xvColorKey        = MAKE_ATOM("XV_COLORKEY");
    xv_autopaint_colorkey = MAKE_ATOM("XV_AUTOPAINT_COLORKEY");

    if(!(viaAdaptPtr[XV_ADAPT_OVERLAY] = xf86XVAllocateVideoAdaptorRec(pScrn)))
        return 0;

    if(gviaPortPriv[XV_ADAPT_OVERLAY] == NULL){
        gviaPortPriv[XV_ADAPT_OVERLAY] =  (viaPortPrivPtr)xcalloc(num_overlay_ports, sizeof(viaPortPrivRec));
    }
    
    pdevUnion = (DevUnion  *)xcalloc(num_overlay_ports, sizeof(DevUnion));

    viaAdaptPtr[XV_ADAPT_OVERLAY]->type = XvInputMask | XvWindowMask | XvImageMask | XvVideoMask | XvStillMask;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->flags = VIDEO_OVERLAID_IMAGES | VIDEO_CLIP_TO_VIEWPORT;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->name = XvAdaptorName[XV_ADAPT_OVERLAY];
    viaAdaptPtr[XV_ADAPT_OVERLAY]->nEncodings = 1;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->pEncodings = DummyEncoding;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->nFormats = sizeof(FormatsG) / sizeof(FormatsG[0]);
    viaAdaptPtr[XV_ADAPT_OVERLAY]->pFormats = FormatsG;

    viaAdaptPtr[XV_ADAPT_OVERLAY]->nPorts = num_overlay_ports;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->pPortPrivates = pdevUnion;

    viaAdaptPtr[XV_ADAPT_OVERLAY]->nAttributes = NUM_ATTRIBUTES_G;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->pAttributes = AttributesG;

    viaAdaptPtr[XV_ADAPT_OVERLAY]->nImages = NUM_IMAGES_G;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->pImages = ImagesG;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->PutVideo = NULL;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->PutStill = NULL;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->GetVideo = NULL;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->GetStill = NULL;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->StopVideo = viaStopVideoG;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->SetPortAttribute = viaSetPortAttributeG;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->GetPortAttribute = viaGetPortAttributeG;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->QueryBestSize = viaQueryBestSizeG;
    viaAdaptPtr[XV_ADAPT_OVERLAY]->PutImage = viaPutImageG;

    /* On FC7, gnome, fvwm, blackbox, SAMM, xv path, move video window X crash, KDE OK.
     *adaptPtr[i]->ReputImage= viaReputImageG;
     */
    viaAdaptPtr[XV_ADAPT_OVERLAY]->ReputImage= 0;        
    viaAdaptPtr[XV_ADAPT_OVERLAY]->QueryImageAttributes = viaQueryImageAttributesG;

    for( i = 0; i < num_overlay_ports; i ++)
    {
        (pdevUnion + i)->ptr = (pointer) (gviaPortPriv[XV_ADAPT_OVERLAY] + i);
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->xv_adaptnum = XV_ADAPT_OVERLAY;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->xv_portnum = i;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->xv_portname = XVOVERLAYPORTNAME[i];
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->textured = FALSE;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->framenum = 0;

        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->colorKey= (viaGfxInfo->preferedColorKey - i);
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->brightness = 5000;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->saturation = 10000;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->contrast = 10000;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->hue = 0;
        (gviaPortPriv[XV_ADAPT_OVERLAY] + i)->autopaint_colorkey = TRUE;

        REGION_NULL(pScreen, &(gviaPortPriv[XV_ADAPT_OVERLAY] + i)->clip);       
    }

    viaResetVideo(pScrn);

    *adaptorPtr = viaAdaptPtr[XV_ADAPT_OVERLAY];
    return 1;

}

static int viaSetupImageVideoTextureG(ScreenPtr pScreen, XF86VideoAdaptorPtr *adaptorPtr)
{
    ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
    VIAPtr  pVia = VIAPTR(pScrn);
    DevUnion  *     pdevUnion;
    int i;

    int num_texture_ports = numAdaptPort[XV_ADAPT_TEXTURE];


    DBG_DD((" via_video.c : viaSetupImageVideoTextureG: \n"));
    DBG_DD((" via_video.c : Screen[%d]\n", pScrn->scrnIndex));

    xvBrightness      = MAKE_ATOM("XV_BRIGHTNESS");
    xvContrast        = MAKE_ATOM("XV_CONTRAST");
    xvSaturation      = MAKE_ATOM("XV_SATURATION");
    xvHue             = MAKE_ATOM("XV_HUE");

    if(!(viaAdaptPtr[XV_ADAPT_TEXTURE] = xf86XVAllocateVideoAdaptorRec(pScrn)))
        return 0;

    if(gviaPortPriv[XV_ADAPT_TEXTURE] == NULL){
        gviaPortPriv[XV_ADAPT_TEXTURE] =  (viaPortPrivPtr)xcalloc(num_texture_ports, sizeof(viaPortPrivRec));
    }

    pdevUnion = (DevUnion  *)xcalloc(num_texture_ports, sizeof(DevUnion));

    viaAdaptPtr[XV_ADAPT_TEXTURE]->type = XvInputMask | XvWindowMask | XvImageMask;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->flags = VIDEO_OVERLAID_IMAGES | VIDEO_CLIP_TO_VIEWPORT;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->name = XvAdaptorName[XV_ADAPT_TEXTURE];
    viaAdaptPtr[XV_ADAPT_TEXTURE]->nEncodings = 1;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->pEncodings = DummyEncoding;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->nFormats = sizeof(FormatsG) / sizeof(FormatsG[0]);
    viaAdaptPtr[XV_ADAPT_TEXTURE]->pFormats = FormatsG;

    viaAdaptPtr[XV_ADAPT_TEXTURE]->nPorts = num_texture_ports;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->pPortPrivates = pdevUnion;

    viaAdaptPtr[XV_ADAPT_TEXTURE]->nAttributes = NUM_ATTRIBUTES_G;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->pAttributes = AttributesG;

    viaAdaptPtr[XV_ADAPT_TEXTURE]->nImages = NUM_IMAGES_G;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->pImages = ImagesG;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->PutVideo = NULL;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->PutStill = NULL;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->GetVideo = NULL;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->GetStill = NULL;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->StopVideo = viaStopVideoG;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->SetPortAttribute = viaSetPortAttributeG;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->GetPortAttribute = viaGetPortAttributeG;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->QueryBestSize = viaQueryBestSizeG;
    viaAdaptPtr[XV_ADAPT_TEXTURE]->PutImage = viaPutImageTexturedG;

    viaAdaptPtr[XV_ADAPT_TEXTURE]->ReputImage= 0;        
    viaAdaptPtr[XV_ADAPT_TEXTURE]->QueryImageAttributes = viaQueryImageAttributesG;

    for( i = 0; i < num_texture_ports; i ++)
    {
        (pdevUnion + i)->ptr = (pointer) (gviaPortPriv[XV_ADAPT_TEXTURE] + i);
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->xv_adaptnum = XV_ADAPT_TEXTURE;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->xv_portnum = i;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->xv_portname = XVTEXVIDEOPORTNAME[i];
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->textured = TRUE;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->framenum = 0;
        
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->colorKey= 0;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->brightness = 5000;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->saturation = 10000;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->contrast = 10000;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->hue = 0;
        (gviaPortPriv[XV_ADAPT_TEXTURE] + i)->autopaint_colorkey = FALSE;
        
	 REGION_NULL(pScreen, &(gviaPortPriv[XV_ADAPT_TEXTURE] + i)->clip);
    }

    *adaptorPtr = viaAdaptPtr[XV_ADAPT_TEXTURE];
    return 1;

}

void  StopOVerlay(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    static DDUPDATEOVERLAY updateOvlRec;

    DBG_DD(("Enter Function : %s\n",__FUNCTION__)); 
    
    if (pPriv->videoFlag & VIDEO_ACTIVE){        
        updateOvlRec.dwFlags = DDOVER_HIDE;

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
        int iga;
        viaOvlDisplayPathPtr ovlPath;

        for(iga = IGA2; iga >= IGA1; iga >>=1)
        {
            ovlPath = pPriv->ovlDisplayPath[iga -1];
            if(ovlPath) {
                /* update overlay */
                updateOvl(pScrn, pPriv, ovlPath, &updateOvlRec);
            }
        }
#else
        if (UpdateOverlay(pScrn, pPriv, &updateOvlRec) == -1){
            DBG_DD((" updateoverlay fail. \n"));
        }
#endif

    }
}


static void
viaStopVideoG(ScrnInfoPtr pScrn, pointer data, Bool exit)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    viaPortPrivPtr pPriv = (viaPortPrivPtr)data;
    PVIDDATA pVidData = pVia->pVidData;

    /* Handle textured video path */
    if (pPriv->textured ||pPriv->redirected)
    {
        if(exit) {
            viaDestroyXvSurface(pScrn, pPriv);
        }
        /* Xv texture video returned here; Overlay redirectd must fall through */
        if(pPriv->textured) {
            return;
        }
    }
        
    DBG_DD((" via_video.c : viaStopVideoG: exit=%d\n", exit));

    switch ( pPriv->xv_portnum )
    {       
        case XV_SWOV_PORTID:
        case XV_SWOV_PORTID2:
            REGION_EMPTY(pScrn->pScreen, &pPriv->clip);
            if(exit)
            {
                if(!pPriv->redirected) {
                    StopOVerlay(pScrn,pPriv);
                }

            #ifdef VIA_DEFINE_OVERLAY_DISPLAY_PATH
                viaDestroyXvSurface(pScrn, pPriv);
                viaDestroyOvlDisplayPath(pScrn, pPriv);
            #else
                viaDestroyOverlaySurface(pScrn, pPriv, pPriv->curIGA);
            #endif
                
                pPriv->framenum = 0; 
                pPriv->redirected = FALSE;
                pPriv->vidOnTop = FALSE;
                BACKUP_PARAMETERS(pPriv, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, FALSE, NULL);

                /* reset the slot of pPriv Rec to NULL */
                pVia->pPriv[pPriv->xv_portnum] = NULL;
            }
            else
            {
                //StopOVerlay(pScrn, pPriv);
            }
            break;
        default:
            DBG_DD((" via_video.c : viaStopVideoG: Shall not happen! \n"));
            break;
    } 

}

static int
viaSetPortAttributeG(
    ScrnInfoPtr pScrn,
    Atom attribute,
    INT32 value,
    pointer data)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    volatile video_via_regs  *viaVidEng = NULL;
    viaPortPrivPtr pPriv = (viaPortPrivPtr)data;
    PVIDDATA pVidData = pVia->pVidData;
   	
    viaVidEng = (volatile video_via_regs *)pVia->VidMapBase;

    DBG_DD((" via_video.c : viaSetPortAttributeG : \n"));
    DBG_DD((" via_video.c : Screen[%d]\n", pScrn->scrnIndex));

    pVidData->dwRejectOverlay = FALSE;
    DBG_DD((" via_video.c : Don't need dwRejectOverlay()\n")); 

    /* Color Key */
    if(attribute == xvColorKey)
    {
        DBG_DD(("  xvColorKey = %08lx\n",value));

        if (pScrn->bitsPerPixel == 16)
        {
            value &= 0xFFFF;
        }
        else if (pScrn->bitsPerPixel == 8)
        {
            value &= 0xFF;
        }

        pPriv->colorKey = value;

        viaVidEng->color_key = value;
        viaVidEng->snd_color_key = value;
        REGION_EMPTY(pScrn->pScreen, &pPriv->clip);
    }

    /* Overlay Color Control */
    else if (attribute == xvContrast)
    {
        DBG_DD(("     xvContrast = %08ld\n",value));
        pPriv->contrast = value;
        vidSetVideoColor(pVia, pPriv->hue, pPriv->saturation, pPriv->brightness, pPriv->contrast);
    }
    else if (attribute == xvSaturation)
    {
        DBG_DD(("     xvSaturation = %08ld\n",value));
        pPriv->saturation = value;
        vidSetVideoColor(pVia, pPriv->hue, pPriv->saturation, pPriv->brightness, pPriv->contrast);
    }
    else if (attribute == xvHue)
    {
        DBG_DD(("     xvHue = %08ld\n",value));
        pPriv->hue = value;
        vidSetVideoColor(pVia, pPriv->hue, pPriv->saturation, pPriv->brightness, pPriv->contrast);
    }
    else if (attribute == xvBrightness)
    {
        DBG_DD(("     xvBrightness = %08ld\n",value));
        pPriv->brightness = value;
        vidSetVideoColor(pVia, pPriv->hue, pPriv->saturation, pPriv->brightness, pPriv->contrast);
    }
    else if (attribute == xv_autopaint_colorkey )
    {
        DBG_DD((" via_video.c : viaSetPortAttributeG : xv_autopaint_colorkey=%lx\n", value));
        pPriv->autopaint_colorkey = value;
    }
    else
    {
        DBG_DD((" via_video.c : viaSetPortAttributeG : is not supported the attribute\n"));
        return BadMatch;
    }

    return Success;
}

static int
viaGetPortAttributeG(
    ScrnInfoPtr pScrn,
    Atom attribute,
    INT32 *value,
    pointer data)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    viaPortPrivPtr pPriv = (viaPortPrivPtr)data;
    PVIDDATA pVidData = pVia->pVidData;

    DBG_DD((" via_video.c : viaGetPortAttributeG : port %d\n",pPriv->xv_portnum));
    DBG_DD((" via_video.c : Screen[%d]\n", pScrn->scrnIndex));

/*    *value = 0;*/
    pVidData->IsSupportedColorSpaceChange = TRUE;

    if (attribute == xvColorKey )
    {
        *value =(INT32) pPriv->colorKey;
        DBG_DD((" via_video.c :    ColorKey 0x%lx\n",pPriv->colorKey));
    }
    /* Color Control */
    else if (attribute == xvContrast)
    {
        *value = pPriv->contrast;
        DBG_DD(("    xvContrast = %08ld\n", *value));
    }
    else if (attribute == xvSaturation)
    {
        *value = pPriv->saturation;
        DBG_DD(("    xvSaturation = %08ld\n", *value));
    }
    else if (attribute == xvHue)
    {
        *value = pPriv->hue;
        DBG_DD(("    xvHue = %08ld\n", *value));
    }
    else if (attribute == xvBrightness)
    {
        *value = pPriv->brightness;
        DBG_DD(("    xvBrightness = %08ld\n", *value));
    }
    else if(attribute == xvOverlayStatus)
    {
        if ( (VIDInD(V1_CONTROL) & VAL_VIDEO_ENABLE_CME) ||
             (VIDInD(V3_CONTROL) & VAL_VIDEO_ENABLE_CME) )
        {
            *value = 1;
            DBG_DD((" via_video.c : XV Overlay Enable.\n"));
        }
        else
        {
            *value = 0;
            DBG_DD((" via_video.c : XV Overlay Disable.\n"));
        }
    }
    /* autopaint colorkey */
    else if (attribute == xv_autopaint_colorkey)
    {
        *value = pPriv->autopaint_colorkey;
        DBG_DD((" via_video.c :   xv_autopaint_colorkey= %x\n",pPriv->autopaint_colorkey));
    }
    else
    {
        DBG_DD((" via_video.c : viaGetPortAttributeG : is not supported the attribute\n"));
        return BadMatch;
    }    

    return Success;
}


static void
viaQueryBestSizeG(
    ScrnInfoPtr pScrn,
    Bool motion,
    short vid_w, short vid_h,
    short drw_w, short drw_h,
    unsigned int *p_w, unsigned int *p_h,
    pointer data)
{
    DBG_DD((" via_video.c : viaQueryBestSizeG :\n"));
    *p_w = drw_w;
    *p_h = drw_h;

    if(*p_w > 2048 )
    {
        *p_w = 2048;
    }
}

/*
 *  For FourCC : YV12 case
 */
void CopyDataYUV420(unsigned char *src1, unsigned char *src2, unsigned char *src3,
    unsigned char *dst1, unsigned char *dst2,  unsigned char *dst3,
    int srcPitch,  int dstPitch, int h, int w)
{
    int count;

    /* copy Y component to video memory */
    count = h;

    while(count--)
    {
        memcpy(dst1, src1, w);
        src1 += srcPitch;
        dst1 += dstPitch;
    }

    /* UV component is 1/4 of Y */
    w >>= 1;
    h >>= 1;
    srcPitch >>= 1;
    dstPitch >>= 1;

    /* copy V(Cr) component to video memory */
    count = h;

    while(count--)
    {
        memcpy(dst2, src2, w);
        src2 += srcPitch;
        dst2 += dstPitch;
    }

    /* copy U(Cb) component to video memory */
    count = h;

    while(count--)
    {
        memcpy(dst3, src3, w);
        src3 += srcPitch;
        dst3 += dstPitch;
    }
}

/*
 *  For FourCC : YUY2 case
 */
void CopyDataYUV422(
    unsigned char * src,
    unsigned char * dst,
    int srcPitch,
    int dstPitch,
    int h,
    int w )
{
    int count;

    DBG_DD((" via_video.c : CopyDataYUV422() \n"));

    /*  copy YUY2 data to video memory,
     *  do 32 bits alignment.
     */
    count = h;

    while(count--)
    {
        memcpy(dst, src, w);
        src += srcPitch;
        dst += dstPitch;
    }
}


/*  CopyYUV420To422 :
 *  for VT3259 use,
 *  copy image data to frame buffer & transfer
 *  format from YUV420 to YUV422, coz VT3259
 *  HQV input source only support FourCC NV12, YUY2
 *  YUV420 format in memory is Y, V, U 3 planar mode
 *  YUV422 is Y0 U0 Y1 V0
 *            low ....High byte
 */
void CopyYUV420To422(
    unsigned char* src1,    /* Y */
    unsigned char* src2,    /* V */
    unsigned char* src3,    /* U */
    unsigned char* dst1,
    int srcPitch,
    int srcPitch2,
    int dstPitch,
    int h,
    int w )
{
    CARD32 *dst = (CARD32*)dst1;
    int i, j;

    DBG_DD((" via_video.c : CopyYUV420To422() \n"));

    dstPitch >>= 2;
    w >>= 1;

    for(j = 0; j < h; j++)
    {
        for(i = 0; i < w; i++) 
        {
            dst[i] = src1[i << 1] | (src1[(i << 1) + 1] << 16) |
                      (src3[i] << 8) | (src2[i] << 24);
        }
        
        dst += dstPitch;
        src1 += srcPitch;

        if(j & 1)
        {
            src2 += srcPitch2;
            src3 += srcPitch2;
        }
    }
}

/*  CopyI420To422 :
 *  for VT3259 use,
 *  copy image data to frame buffer & transfer
 *  format from I420 to YUY2
 *  I420 format in memory is Y, U, V 3 planar mode
 *  YUV422 is Y0 U0 Y1 V0
 *            low ....High byte
 */
void CopyI420To422(
    unsigned char* src1,    /* Y */
    unsigned char* src2,    /* U */
    unsigned char* src3,    /* V */
    unsigned char* dst1,
    int srcPitch,
    int srcPitch2,
    int dstPitch,
    int h,
    int w )
{
    CARD32 *dst = (CARD32*)dst1;
    int i, j;

    DBG_DD((" via_video.c : CopyI420To422() \n"));

    dstPitch >>= 2;
    w >>= 1;

    for(j = 0; j < h; j++)
    {
        for(i = 0; i < w; i++)
        {
            dst[i] = src1[i << 1] | (src1[(i << 1) + 1] << 16) |
                     (src2[i] << 8) | (src3[i] << 24);
        }
        
        dst += dstPitch;
        src1 += srcPitch;

        if(j & 1) 
        {
            src2 += srcPitch2;
            src3 += srcPitch2;
        }
    }
}

/*CbCr conversion
 *Cr00 Cr02 
 *Cr20 Cr22     ---->       Cb00 Cr00 Cb02 Cr02 
 *Cb00 Cb02     ---->       Cb20 Cr20 Cb20 Cr22 
 *Cb20 Cb22
 */
#define makeuvPack0(u,v) ((u & 0x000000ff)| (v & 0x000000ff)<<8|(u & 0x0000ff00)<<8 |(v & 0x000ff00)<<16)
#define makeuvPack1(u,v) ((u & 0x00ff0000)>>16| (v & 0x00ff0000)>>8|(u & 0xff000000)>>8| (v & 0xff000000))
inline void makeuvPack(unsigned long uv[], unsigned long u, unsigned long v)
{
    uv[0] = makeuvPack0(u, v);
    uv[1] = makeuvPack1(u, v);
}
/*
 *  For FourCC : NV12 case ,new version by zepengtang 
 */
void CopyYUV420ToNV12(
        unsigned char *src1, unsigned char *src2, unsigned char *src3,
        unsigned char *desty,  unsigned char *destuv,
        int srcPitch,  int dstPitch, int h, int w, Bool PCIe_Surface)
{
    int i,j,k;
    Bool uvoptimized = FALSE;
    Bool uvaligned;
    char *tmpDst = NULL;
    int count = 0;
    unsigned long *pU,*pV, *pUV;
    
    /* copy Y component to video memory */
    if (srcPitch==dstPitch)
    {
        memcpy(desty, src1, dstPitch*h);
    }
    else
    {
        for (i=0;i<h;i++)
       {
            memcpy(desty, src1, w);
            src1 += srcPitch;
            desty += dstPitch;
        }
    }

    h>>=1;

    /* PCIe surface dose not need this optimal code */
    if(!PCIe_Surface)
    {
        if(((unsigned long)src2 & 3) == ((unsigned long)src3 & 3))
        {
            while(!(tmpDst =(char *)malloc(dstPitch*(h>>count) + 3)))
            {
                count++;
            }
            
            if(tmpDst != NULL)
            {
                uvoptimized = TRUE;
            }
        }
    }
    
    /* here is for the optimized code for convert YV12 to NV12 */
    if(uvoptimized)
    {
        for (j=0; j<h; j++)
        {
            /* we can process h>>count lines in each block, the subline num is j%(h>>count) in each block */
            pUV= (unsigned long *)(ALIGN_TO((unsigned long)tmpDst,4) + dstPitch*(j%(h>>count)));

            if(((unsigned long)src2 & 3) ||((unsigned long)src3 & 3))
            {
                uvaligned = FALSE;
                *pUV++ = src3[0] |(src2[0] <<8) | (src3[1] <<16)|(src2[1]<<24);
                pV = (unsigned long *)ALIGN_TO((unsigned long)src2,4);
                pU = (unsigned long *)ALIGN_TO((unsigned long)src3,4);
            }
            else
            {
                uvaligned = TRUE;
                pV = (unsigned long *)src2;
                pU = (unsigned long *)src3;
            }

            /*now we construct 64 bit at one time for the  uv buffer*/
            for (i= (uvaligned ? 0:4); i<(uvaligned? (w & ~7):(((w-4)& ~7) +4)); i+=8, pU++, pV++, pUV +=2)
            {
                  makeuvPack(pUV, *pU, *pV);
            }
            
            if((uvaligned? w:(w-4)) & 7)
            {
                ((unsigned long *)pUV)[0] = ((unsigned char *)pU)[0] |(((unsigned char *)pV)[0] <<8) |
                                            (((unsigned char *)pU)[1] <<16)|(((unsigned char *)pV)[1]<<24);
            }

            /* the subline num is the last line in the block, then copy it out */
            if((j%(h>>count)) == ((h>>count) -1))
            {
                memcpy((destuv + (j/(h>>count))*dstPitch*(h>>count)), 
                            (unsigned long *)ALIGN_TO((unsigned long)tmpDst,4), dstPitch*(h>>count));
            }
            src2 += srcPitch>>1;
            src3 += srcPitch>>1;    
        }

        free(tmpDst);
    }
    else
    {
        for(j = 0; j < h; j++)
        {
            for(i = 0,k=0; i <w; i+=4,k+=2)
            {
                *((unsigned long *)(destuv+i)) = src3[k] |(src2[k] <<8) | (src3[k+1] <<16)|(src2[k+1]<<24);
            }

            destuv += dstPitch;
            src2 += srcPitch>>1;
            src3 += srcPitch>>1;        
        }
   }
  
}

static void SetColorSpace(VIAPtr pVia)
{
    PVIDDATA pVidData = pVia->pVidData;

    if (!pVidData->ColorSpaceChanged)
    {
        VIDOutD(ColorSpaceReg_1, ColorSpaceValue_1_3123C0);
        VIDOutD(ColorSpaceReg_2, ColorSpaceValue_2_3123C0);
        VIDOutD(V3_ColorSpaceReg_1, ColorSpaceValue_1_3123C0);
        VIDOutD(V3_ColorSpaceReg_2, ColorSpaceValue_2_3123C0);
    }
    else
    {
        VIDOutD(ColorSpaceReg_1, pVidData->ColorSpaceValue1);
        VIDOutD(ColorSpaceReg_2, pVidData->ColorSpaceValue2);
        VIDOutD(V3_ColorSpaceReg_1, pVidData->ColorSpaceValue1);
        VIDOutD(V3_ColorSpaceReg_2, pVidData->ColorSpaceValue2);
   }
}

int enableVirtualQueue(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    int ret = TRUE;

    pVidData->dwVQUseCount++;

    /* Double check VQ Enable/Disable status */
    if ( (!pVidData->dwVideoVQ_Offset) ){
        pVidData->dwVideoVQ_Size   = 0x00080000;   /* 512K */

        viaVideoMemFree(pScrn,&pVidData->vidVQMem);
        ret = viaVideoMemAlloc(pScrn,  &pVidData->vidVQMem, pVidData->dwVideoVQ_Size);
        
        if((ret == BadAlloc) ||(!pVidData->vidVQMem.pool) || (!pVidData->vidVQMem.base)) {            
            DBG_DD((" Create Video Virtual Queue buffer fail!\n"));
            return FALSE;
        }

        pVidData->dwVideoVQ_Offset = ALIGN_TO(pVidData->vidVQMem.base, 32);

        vidEnableVideoVirtualQueue(pVia, pPriv->videoFlag, pVidData->dwVideoVQ_Offset, pVidData->dwVideoVQ_Size);
    }
}

void disableVirtualQueue(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  

    pVidData->dwVQUseCount--;

    if ( pVidData->dwVQUseCount == 0 ){
        if (pVidData->dwVideoVQ_Offset){
            vfHM(pScrn,pPriv,HM_WAIT_VQ_EMPTY);

            if(pVidData->vidVQMem.pool && pVidData->vidVQMem.base){
                viaVideoMemFree(pScrn,  &pVidData->vidVQMem);
            }
            
            pVidData->dwVideoVQ_Offset = 0;
            vidDisableVideoVirtualQueue(pVia);
        }
    }else{
        DBG_DD(("VQ buffer was in used\n"));
    }

    return;
}


/*
  * The value of eng_value indicate the sub-engine id. (V1 or V3, HQV0 or HQV1, and so on...)
  * HAVE_INVALID indicate not avaliable.
  */
void allocEngine(VIAENGMATRIX *pViaEngineMatrix,unsigned long *eng_value)
{
    unsigned long shift = 0;
    VIAENGMATRIX *pCurrEngMGR = pViaEngineMatrix;

    *eng_value = HAVE_INVALID;
    
    for(; shift <32; shift++)
    {
        if((pCurrEngMGR->ulEngMask & (1<<shift)) & pCurrEngMGR->ulEngStatus)
        {
            *eng_value = 1<<shift;
            pCurrEngMGR->ulEngStatus &= ~(pCurrEngMGR->ulEngMask & *eng_value);
            break;
        }
    }
    
}

void releaseEngine(VIAENGMATRIX *pViaEngineMatrix,unsigned long eng_value)
{
    VIAENGMATRIX *pCurrEngMGR = pViaEngineMatrix;
    
    pCurrEngMGR->ulEngStatus |=pCurrEngMGR->ulEngMask & eng_value;
}

/*
 * Allocate engine and initialize video status flag for engine allocation. 
 * If no engine is availabe or fourcc is not correct, return HAVE_INVALID
 */
unsigned long initEngineStatus(PVIDDATA pVidData, unsigned long *flags)
{
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    unsigned long video_alloc_value = 0;
    unsigned long hqv_alloc_value = 0;
    int counts = 0;
    int i = 0;

    counts = (viaGfxInfo->screenAttr.uint & SCRN_ATTR_DUO_CLONE_VIEW)? 2:1;

    for(i=0; i < counts; i++){
        /*try to allocate video engine*/
        allocEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO],&video_alloc_value);
        if (HAVE_VIDEO_1 == video_alloc_value){
            *flags |= VIDEO_1_INUSE;
            DBG_DD(("Video 1 allocated\n"));
        }else{
            if (HAVE_VIDEO_3 == video_alloc_value){
                *flags |= VIDEO_3_INUSE;
                DBG_DD(("Video 3 allocated\n"));
            }else{
                DBG_DD(("No more available video engine\n "));
                return FALSE;
            }
        }

        /*try to allocate HQV engine*/
        allocEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_HQV], &hqv_alloc_value);
        if (HAVE_HQV_0 == hqv_alloc_value){
           *flags |= HQV_0_INUSE|VIDEO_HQV_INUSE;
           DBG_DD(("HQV 0 allocated\n"));
        }else{                     
            if (HAVE_HQV_1 == hqv_alloc_value){
                *flags |= HQV_1_INUSE|VIDEO_HQV_INUSE; 
                DBG_DD(("HQV 1 allocated\n"));
            }else{   
               DBG_DD(("No more available HQV engine\n ")); 
               return FALSE;
            }
        }       
    }
    
    /*if video VQ enabled*/
    if(lpVideoHWDifference->dwSupportVideoVQ == VID_HWDIFF_TRUE){
        *flags |= VIDEO_VQ_INUSE;
    }
    
#if  VIA_APPLY_XVOVERLAY_AGP
    /* set the following flag for wait in CR function */
    if(viaGfxInfo->drmEnabled && viaGfxInfo->chipId != VIA_DEVICE_VT3314) {
        /* if video go AGP mode, no need to enable Virtual Queue */
        *flags &= ~VIDEO_VQ_INUSE;
        *flags |= VIDEO_AGP_INUSE;
    } 
 #endif
 
    return TRUE;  
}

void freeEngineStatus(PVIDDATA pVidData,viaPortPrivPtr pPriv)
{
    if (pPriv->videoFlag & VIDEO_1_INUSE){    
        releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO], HAVE_VIDEO_1);
        DBG_DD(("Video 1 freed\n"));
        pPriv->videoFlag &= ~VIDEO_1_INUSE;
    }

    if (pPriv->videoFlag & VIDEO_3_INUSE){
        releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO], HAVE_VIDEO_3);
        DBG_DD(("Video 3 freed\n"));
        pPriv->videoFlag &= ~VIDEO_3_INUSE;   
    }
    
    if (pPriv->videoFlag & HQV_0_INUSE){
        releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_HQV], HAVE_HQV_0);
        DBG_DD(("HQV 0 freed\n"));        
        pPriv->videoFlag &= ~HQV_0_INUSE;    
    }

    if (pPriv->videoFlag & HQV_1_INUSE){
        releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_HQV], HAVE_HQV_1);
        DBG_DD(("HQV 1 freed\n"));        
        pPriv->videoFlag &= ~HQV_1_INUSE;   
    }
}

void __inline rgbFillBlack(VIAPtr pVia, int offset, int size)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia0 = VIAPTR(pScrn0);
    unsigned char* FBBase = pVia0->FBBase;
    unsigned char *ptr = (unsigned char*) (FBBase + offset);
    unsigned int ClearValue = 0x0;

    DBG_DD(("  RGBFillBlack()\n"));
    memset(ptr, ClearValue, size);
}

/*
 *  Fill the buffer YUV2 black.
 *   the memory layout looks like
 *   Y00 U00 Y01 V00 Y02 U02 Y03 V02 
 *   Y10 U10 Y11 V10 Y12 U12 Y13 V12 
 *   Y20 U20 Y21 V20 Y22 U22 Y23 V22 
 *   Y30 U30 Y31 V30 Y32 U32 Y33 V32
 * The common conversion formula is:
 * Y = R * 0.299 + G * 0.587 + B * 0.114 
 * U = R * -0.169 + G * -0.332 + B * 0.500 + 128; 
 * V = R* 0.500 + G * -0.419 + B * -0.0813 + 128; 
 */
__inline void yuvFillBlack(VIAPtr pVia, int offset, int size)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia0 = VIAPTR(pScrn0);
    unsigned char* FBBase = pVia0->FBBase;
    unsigned long  *ptr = (unsigned long *) (FBBase + offset);
    unsigned int ClearValue = 0x80008000;/*Y=0,U=V=0x80*/
    int i;

    DBG_DD(("  yuvFillBlack()\n"));
    for (i=0;i<=size/4;i++,ptr++)
        *ptr = ClearValue;
}


__inline void yuvFillBlackPCIE(VIAPtr pVia, int offset, int size)
{
    unsigned long  *ptr= (unsigned long*) (pVia->agpTexMappedAddr + offset);
    unsigned long ClearValue = 0x80008000; /*Y=0,U=V=0x80*/
    int i;

    DBG_DD(("  yuvFillBlackPCIE()\n"));
    DBG_DD(("size:%x\n",size));
    for (i=0;i<=size/4;i++,ptr++)
        *ptr = ClearValue;
    viaFlushPCIECache(pVia, offset, size);
}

/*The NV12 memory layout looks like this
 *   Y00  Y01  Y02  Y03 
 *   Y10  Y11  Y12  Y13
 *   Y20  Y21  Y22  Y23
 *   Y30  Y31  Y32  Y33
 *   U00  V00  U01  V01
 *   U20  V20  U21  V21
 *
 *The YV12 memory layout looks like this
 *   Y00  Y01  Y02  Y03 
 *   Y10  Y11  Y12  Y13
 *   Y20  Y21  Y22  Y23
 *   Y30  Y31  Y32  Y33
 *   U00  U01  U20  U21
 *   V00  V01  V20  V21
 *When clear the 2 surface, we all set Y=0,U=V=0x80.
 */
__inline void nv12FillBlack(VIAPtr pVia, int offset, int size)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia0 = VIAPTR(pScrn0); 
    unsigned char* FBBase = pVia0->FBBase;
    unsigned char *ptr = (unsigned char *) (FBBase + offset);
    /*Y=0,U=V=0x80*/
    DBG_DD(("  NV12FillBlackPCIE()\n"));
    memset((char *)ptr,0x00,size*2/3);
    memset((char*)(ptr+size*2/3),0x80,size/3);
}

__inline void nv12FillBlackPCIE(VIAPtr pVia, int offset, int size)
{
    unsigned char  *ptr= (unsigned char*) (pVia->agpTexMappedAddr + offset);
    int i;
    /*Y=0,U=V=0x80*/
    DBG_DD(("  NV12FillBlackPCIE()\n"));
    memset((char *)ptr,0x00,size*2/3);
    memset((char*)(ptr+size*2/3),0x80,size/3);
    viaFlushPCIECache(pVia, offset, size);
}

static unsigned long AddHQVSurface(ScrnInfoPtr pScrn,viaPortPrivPtr pPriv)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo; 

    unsigned int i, swWidth, swHeight, swPitch, swFourcc, format, formatType, fbsize;
    unsigned int  width, height, pitch, fourcc;
    int ret = TRUE;

    swFourcc = pPriv->pXvSurface->format;
    swWidth = pPriv->pXvSurface->width;
    swHeight = pPriv->pXvSurface->height;
    swPitch = pPriv->pXvSurface->pitch;

    width = swWidth;
    height = swHeight;

    switch (swFourcc) {
        /*If rotate, Format in HQV surface will be YUY2 if 314, RGB16 if not 314, they all 2 bytes one pixel*/
        case FOURCC_YV12:
        case FOURCC_NV12:
            pitch = swPitch*2;
            fbsize = ALIGN_TO(pitch * height,256);
            break;
        case FOURCC_YUY2:
            pitch  = swPitch;
            fbsize = ALIGN_TO(pitch * height,256);
            break;
        default:
            DBG_DD(("  Unknown supported format!\n"));
            return FALSE;
    }

    DBG_DD(("HQVSurface Size:%08x\n",fbsize));
    
    viaVideoMemFree(pScrn,&pPriv->hqvMem[pPriv->curIGA-1]);
    ret = viaVideoMemAlloc(pScrn,  &pPriv->hqvMem[pPriv->curIGA-1], fbsize * XV_HQVSURFACE_NUM);

    if((ret == BadAlloc) ||(!pPriv->hqvMem[pPriv->curIGA-1].pool) || (!pPriv->hqvMem[pPriv->curIGA-1].base)) {
        return FALSE;
    }

    if((pPriv->pHqvSurface[pPriv->curIGA-1] = (ViaXvSurfacePtr)xcalloc(1, sizeof(ViaXvSurfaceRec))) == NULL){
        return FALSE;
    }

    if(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit){        
        if (viaGfxInfo->chipId == VIA_DEVICE_VT3314){
            format = FOURCC_YUY2;
            formatType = DDPF_FOURCC;
        }else{
            format = RGB16;
            formatType = DDPF_RGB;
        }        
    }else{
        format = FOURCC_YUY2;
        formatType = DDPF_FOURCC;
    }   

    if(formatType & DDPF_FOURCC){
        yuvFillBlack(pVia, pPriv->hqvMem[pPriv->curIGA-1].base, fbsize * XV_HQVSURFACE_NUM);
    }else{
        rgbFillBlack(pVia, pPriv->hqvMem[pPriv->curIGA-1].base, fbsize * XV_HQVSURFACE_NUM);
    }   

    pPriv->pHqvSurface[pPriv->curIGA-1]->format = format;
    pPriv->pHqvSurface[pPriv->curIGA-1]->formatType = formatType;
    pPriv->pHqvSurface[pPriv->curIGA-1]->width  = width;
    pPriv->pHqvSurface[pPriv->curIGA-1]->height = height;
    pPriv->pHqvSurface[pPriv->curIGA-1]->pitch = pitch;
    
    for(i=0;i<XV_HQVSURFACE_NUM;i++){
        pPriv->pHqvSurface[pPriv->curIGA-1]->offset[i] = ALIGN_TO(pPriv->hqvMem[pPriv->curIGA-1].base + i* fbsize,256);
        pPriv->pHqvSurface[pPriv->curIGA-1]->vaddr[i] = pVia->FBBase + pPriv->pHqvSurface[pPriv->curIGA-1]->offset[i];

        pPriv->ovlInfo[pPriv->curIGA-1].dwHQVAddr[i] =  pPriv->pHqvSurface[pPriv->curIGA-1]->offset[i];
    }

    pPriv->ovlInfo[pPriv->curIGA-1].dwOriSrcWidth = swWidth;
    pPriv->ovlInfo[pPriv->curIGA-1].dwOriSrcHeight = swHeight;
    pPriv->ovlInfo[pPriv->curIGA-1].dwOriSrcPitch = swPitch;
    
    return TRUE;
}

unsigned long AddROTSurface(ScrnInfoPtr pScrn,viaPortPrivPtr pPriv)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo; 

    unsigned int i, hqvWidth, hqvHeight, hqvPitch, hqvFourcc, fbsize;
    unsigned int  width, height, pitch_w, pitch_h, fourcc;
    int ret = TRUE;

    hqvFourcc = pPriv->pHqvSurface[pPriv->curIGA-1]->format;
    hqvWidth = pPriv->pHqvSurface[pPriv->curIGA-1]->width;
    hqvHeight = pPriv->pHqvSurface[pPriv->curIGA-1]->height;
    hqvPitch = pPriv->pHqvSurface[pPriv->curIGA-1]->pitch;

    /* If rotate, Format in HQV surface will be YUY2 if 314, RGB16 if not 314, they all 2 bytes one pixel
     * After rotate, format will be RGB16, it means format in ROT surface always RGB16
     */
    width = ALIGN_TO(hqvWidth, 32);
    pitch_w  = ALIGN_TO(width<<1, 256);
    height = ALIGN_TO(hqvHeight, 32);
    pitch_h = ALIGN_TO(height<<1, 256);
    fbsize = max(pitch_w* height, pitch_h * width);
    DBG_DD(("RotSurface Size:%08x\n",fbsize));

    viaVideoMemFree(pScrn,&pPriv->rotMem[pPriv->curIGA-1]);
    ret = viaVideoMemAlloc(pScrn,  &pPriv->rotMem[pPriv->curIGA-1], fbsize * XV_ROTSURFACE_NUM);

    if((ret == BadAlloc) ||(!pPriv->rotMem[pPriv->curIGA-1].pool) || (!pPriv->rotMem[pPriv->curIGA-1].base)) {
        return FALSE;
    }

    rgbFillBlack(pVia, pPriv->rotMem[pPriv->curIGA-1].base, fbsize * XV_ROTSURFACE_NUM);

    if((pPriv->pRotSurface[pPriv->curIGA-1] = (ViaXvSurfacePtr)xcalloc(1, sizeof(ViaXvSurfaceRec))) == NULL){
        return FALSE;
    }

    pPriv->pRotSurface[pPriv->curIGA-1]->format = RGB16;
    pPriv->pRotSurface[pPriv->curIGA-1]->formatType = DDPF_RGB;   

    pPriv->pRotSurface[pPriv->curIGA-1]->width  = width;
    pPriv->pRotSurface[pPriv->curIGA-1]->height = height;
    pPriv->pRotSurface[pPriv->curIGA-1]->pitch = 
        (viaGfxInfo->igaInfo[pPriv->curIGA -1].igaRRStatus.rotate_90 ||
         viaGfxInfo->igaInfo[pPriv->curIGA -1].igaRRStatus.rotate_270) ? pitch_h : pitch_w;

    for(i=0;i<XV_ROTSURFACE_NUM;i++){
        pPriv->pRotSurface[pPriv->curIGA-1]->offset[i] = ALIGN_TO(pPriv->rotMem[pPriv->curIGA-1].base + i* fbsize, 256);
        pPriv->pRotSurface[pPriv->curIGA-1]->vaddr[i] = pVia->FBBase + pPriv->pRotSurface[pPriv->curIGA-1]->offset[i];
    }

    pPriv->pRotSurface[pPriv->curIGA-1]->cur_idx = 0;
    
    pPriv->igaRRStatus[pPriv->curIGA-1] = viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit;

    return TRUE;
}

unsigned long viaCreateXvSurface(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, 
    unsigned long id, unsigned long width, unsigned long height)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);

    unsigned long format, formatType, pitch, bufsize;
    int ret;
    Bool isplanar = FALSE;
    int i;

    if(pPriv->pXvSurface) {
        viaDestroyXvSurface(pScrn, pPriv);
    }

    formatType = DDPF_FOURCC;
    switch(pVia->ChipId )
    { 
        case VIA_DEVICE_VT3314:
            if((pPriv->textured || pPriv->redirected) && pPriv->texV3DPath){
                format = FOURCC_YUY2;
            } else {
                format = ((FOURCC_YV12 == id) ? FOURCC_YV12 : FOURCC_YUY2);
            }
            break;
            
        case VIA_DEVICE_VT3324:      
            if((pPriv->textured || pPriv->redirected) && pPriv->texV3DPath){
                format = FOURCC_YUY2;
            } else {
                format = (((FOURCC_YV12 == id) ||
                              (FOURCC_NV12 == id)) ? FOURCC_NV12 : FOURCC_YUY2);
            }
            break;  
            
        default:
            if((pPriv->textured || pPriv->redirected) && pPriv->texV3DPath) {
                format = FOURCC_YUY2;
            } else {
                format = (((FOURCC_YV12 == id) ||
                              (FOURCC_NV12 == id)) ? FOURCC_NV12 : FOURCC_YUY2);
            }
            break;
    }

    switch(format)
    {
        case FOURCC_YV12:
        case FOURCC_NV12:
            isplanar = TRUE;
            /*FIXME!*/
            pitch = ALIGN_TO(width,64)+64;
            bufsize = pitch * height *3 /2;
            break;
        case FOURCC_YUY2:
            isplanar = FALSE;
            /*FIXME*/
            pitch = ALIGN_TO(width<<1,32)+32;
            bufsize = pitch * height;
            break;
    }

    /* Allocate Video Memory for Xv Texture video surface */
    memset(&pPriv->xvMem, 0, sizeof(ViaMemRec));
    
    if(((pVia->ChipId == PCI_CHIP_VT3353)||(pVia->ChipId == PCI_CHIP_VT3409)) &&
      ((pVia->agpTexHandle) && (pVia->agpTexMappedAddr))) {
        ret = viaPCIEMemAlloc(pScrn,  &pPriv->xvMem, bufsize * XV_SURFACE_NUM);
        if(ret == Success) {
            pPriv->xv_refine_using_pcie = TRUE;
        } else {
            pPriv->xv_refine_using_pcie = FALSE;
            memset(&pPriv->xvMem, 0, sizeof(ViaMemRec));
        }
    } else {
        pPriv->xv_refine_using_pcie = FALSE;
    }
    
    if(!pPriv->xv_refine_using_pcie) {
        ret = viaVideoMemAlloc(pScrn,  &pPriv->xvMem, bufsize * XV_SURFACE_NUM);
    }
    
    if((ret == BadAlloc) ||(!pPriv->xvMem.pool) || (!pPriv->xvMem.base)) {
        return FALSE;
    }
    
    if(pPriv->xv_refine_using_pcie) {
        switch (format){
         case FOURCC_NV12:
             for (i=0;i<XV_SURFACE_NUM;i++)
                 nv12FillBlackPCIE(pVia, pPriv->xvMem.base+bufsize*i, bufsize);   
             break;
         case FOURCC_YUY2:        
         default:
             yuvFillBlackPCIE(pVia,pPriv->xvMem.base,bufsize*XV_SURFACE_NUM);     
             break;
        }
    } else {
        switch (format){
         case FOURCC_NV12:
         case FOURCC_YV12:    
             for (i=0;i<XV_SURFACE_NUM;i++)
                 nv12FillBlack(pVia, pPriv->xvMem.base+bufsize*i, bufsize);   
             break;
         case FOURCC_YUY2:    
         default:
             yuvFillBlack(pVia,pPriv->xvMem.base,bufsize*XV_SURFACE_NUM);     
         break;
        }
    }

    if((pPriv->pXvSurface = (ViaXvSurfacePtr)xcalloc(1, sizeof(ViaXvSurfaceRec))) == NULL) {
        return FALSE;
    }

    pPriv->pXvSurface->format = format;
    pPriv->pXvSurface->formatType = formatType;    
    pPriv->pXvSurface->width  = width;
    pPriv->pXvSurface->height = height;
    pPriv->pXvSurface->pitch = pitch;

    for(i = 0; i < XV_SURFACE_NUM; i++)
    {
        pPriv->pXvSurface->offset[i] = pPriv->xvMem.base + i * bufsize;
        if(pPriv->xv_refine_using_pcie) {
            pPriv->pXvSurface->vaddr[i] = pVia->agpTexMappedAddr + pPriv->pXvSurface->offset[i];
            pPriv->pXvSurface->offset[i] += pVia->agpTexBaseOffset;
        } else {                
            pPriv->pXvSurface->vaddr[i] = pVia->FBBase + pPriv->pXvSurface->offset[i];
        }
    }

    pPriv->pXvSurface->cur_idx = 0;
    pPriv->framenum = 0;
    
    return TRUE;

}

void viaDestroyXvSurface(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    if(pPriv->pXvSurface)
    {
        /* Free Video memory allocated for Xv Texture video surface */
        if(pPriv->xvMem.pool && pPriv->xvMem.base)
        {
            if(pPriv->xv_refine_using_pcie) {
                viaPCIEMemFree(pScrn,  &pPriv->xvMem);
                pPriv->xv_refine_using_pcie = FALSE;
            } else {
                viaVideoMemFree(pScrn,  &pPriv->xvMem);
            }
        }
    
        xfree(pPriv->pXvSurface);
        pPriv->pXvSurface = NULL;
    }
}

unsigned long  viaCreateHQVSurface (
    ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,
    int id, short width, short height)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    unsigned long igaIndex = 0;
    unsigned long ret = FALSE;

    if(pPriv->pHqvSurface[pPriv->curIGA-1] != NULL){
        return TRUE;
    }

    ret = AddHQVSurface(pScrn,pPriv);
    if (ret == FALSE){
        DBG_DD(("  HQV Memory allocation failed\n"));
        if (pPriv->videoFlag != HAVE_INVALID){
            freeEngineStatus(pVidData,pPriv);
        }
        return FALSE;
    }
    
    if(!viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.duoview ||
        viaGfxInfo->xrandrEnabled && viaGfxInfo->screenAttr.clone){
        igaIndex = pPriv->curIGA ;
        pPriv->curIGA = (pPriv->curIGA == IGA1) ? IGA2: IGA1;

        ret = AddHQVSurface(pScrn,pPriv);
        if (ret == FALSE){
            DBG_DD(("  HQV Memory allocation failed\n"));
            if (pPriv->videoFlag != HAVE_INVALID){
                freeEngineStatus(pVidData,pPriv);
            }
            return FALSE;
        }      

        pPriv->curIGA = igaIndex;
    }
    
    return TRUE;
}

unsigned long  viaDestroyHQVSurface (
    ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,unsigned long scrnAttr, unsigned long igaIndex)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  

    if(igaIndex == 0){
        return TRUE;
    }

    if(pPriv->pHqvSurface[igaIndex-1]){
        if(pPriv->hqvMem[igaIndex-1].pool && pPriv->hqvMem[igaIndex-1].base){
            viaVideoMemFree(pScrn,  &pPriv->hqvMem[igaIndex-1]);
        }
        free(pPriv->pHqvSurface[igaIndex-1]);
        pPriv->pHqvSurface[igaIndex-1] = NULL;
    }else{
        DBG_DD((" HQV surface is NULL\n"));
    }
  
    if(scrnAttr == SCRN_ATTR_DUO_CLONE_VIEW){
        igaIndex = (igaIndex == IGA1)? IGA2: IGA1;

        if(pPriv->pHqvSurface[igaIndex-1]){
            if(pPriv->hqvMem[igaIndex-1].pool && pPriv->hqvMem[igaIndex-1].base){
                viaVideoMemFree(pScrn,  &pPriv->hqvMem[igaIndex-1]);
            }
            free(pPriv->pHqvSurface[igaIndex-1]);
            pPriv->pHqvSurface[igaIndex-1] = NULL;
        }else{
            DBG_DD((" HQV surface is NULL\n"));
        }
    }        

    return TRUE;
}

unsigned long  viaDestroyROTSurface (
    ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,unsigned long scrnAttr, unsigned long igaIndex)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  

    if(igaIndex == 0){
        return TRUE;
    }

    if(pPriv->pRotSurface[igaIndex-1]){
        if(pPriv->rotMem[igaIndex-1].pool && pPriv->rotMem[igaIndex-1].base){
            viaVideoMemFree(pScrn,  &pPriv->rotMem[igaIndex-1]);
        }
        free(pPriv->pRotSurface[igaIndex-1]);
        pPriv->pRotSurface[igaIndex-1] = NULL;
        pPriv->igaRRStatus[igaIndex-1] = 0;
    }else{
        DBG_DD((" ROT surface is NULL\n"));
    }
    
    if(scrnAttr == SCRN_ATTR_DUO_CLONE_VIEW){
        igaIndex = (igaIndex == IGA1)? IGA2: IGA1;

        if(pPriv->pRotSurface[igaIndex-1]){
            if(pPriv->rotMem[igaIndex-1].pool && pPriv->rotMem[igaIndex-1].base){
                viaVideoMemFree(pScrn,  &pPriv->rotMem[igaIndex-1]);
            }
            free(pPriv->pRotSurface[igaIndex-1]);
            pPriv->pRotSurface[igaIndex-1] = NULL;            
            pPriv->igaRRStatus[igaIndex-1] = 0;
        }else{
            DBG_DD((" ROT surface is NULL\n"));
        }
    }        

    return TRUE;
}

unsigned long  viaDestroyOverlaySurface (
    ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, unsigned long igaIndex)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    unsigned long tmpIgaIndex = 0;
    
    DBG_DD((" Enter Function : %s\n",__FUNCTION__)); 

    /*Release video and HQV engine*/
    freeEngineStatus(pVidData,pPriv);

    viaDestroyXvSurface(pScrn,pPriv);
    viaDestroyHQVSurface(pScrn,pPriv,pPriv->scrnAttr,igaIndex);
    viaDestroyROTSurface(pScrn,pPriv,pPriv->scrnAttr,igaIndex);
   
    memset(&pPriv->ovlInfo[igaIndex-1],0,sizeof(OVERLAYRECORD));

    if(pPriv->scrnAttr == SCRN_ATTR_DUO_CLONE_VIEW){
        igaIndex = (igaIndex == IGA1)? IGA2: IGA1;            
        memset(&pPriv->ovlInfo[igaIndex-1],0,sizeof(OVERLAYRECORD));
    }        

    /* disable VQ should be done before clear the flags
     * otherwise when playing next video right after this one, the system hangs*/
    if (pPriv->videoFlag & VIDEO_VQ_INUSE){
        disableVirtualQueue(pScrn,pPriv);
    }

    if (pPriv->videoFlag & VIDEO_ACTIVE) {
        pPriv->videoFlag = 0;
    }

    pPriv->fourCC = 0;
    pPriv->framenum = 0;

    return TRUE;
}

void viaUploadToXVSurface(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, unsigned long id, char * buf, 
    ViaXvSurfacePtr pXvSurface, unsigned long width, unsigned long height)
{
    VIAPtr pVia = VIAPTR(pScrn);
    unsigned long srcPitch, srcYSize, srcUVSize, dstPitch, dstYSize, dstUVSize;
    unsigned long frameIndex = pPriv->pXvSurface->cur_idx;

    /*  Copy image data from system memory to video memory
     *  TODO: use DRM's DMA feature to accelerate data copy */
    srcPitch = width;
    srcYSize  = width * height;
    srcUVSize = srcYSize >>2;
    dstPitch = pXvSurface->pitch;
    dstYSize  = dstPitch * height;
    dstUVSize = dstYSize >>2;

    switch(id){
        case FOURCC_YV12:
            /*  Because in CreateSurface, we unify fourcc to YUY2,
             *  so we use CopyYUV420To422 instead of CopyDataYUV420 */
            if (pXvSurface->format == FOURCC_YUY2) {
                CopyYUV420To422( buf, buf + srcYSize, buf + srcYSize + srcUVSize,
                                 pXvSurface->vaddr[frameIndex],
                                 srcPitch, srcPitch>>1, dstPitch, height, width);
            }else if (pXvSurface->format == FOURCC_YV12) { 
                CopyDataYUV420(buf, buf + srcYSize, buf + srcYSize + srcUVSize,
                               pXvSurface->vaddr[frameIndex], 
                               pXvSurface->vaddr[frameIndex]+ dstYSize,  
                               pXvSurface->vaddr[frameIndex]+ dstYSize + dstUVSize,
                               srcPitch,  dstPitch, height, width);                       
            }else if (pXvSurface->format == FOURCC_NV12) {
                CopyYUV420ToNV12(buf, buf + srcYSize, buf + srcYSize + srcUVSize,
                                 pXvSurface->vaddr[frameIndex], 
                                 pXvSurface->vaddr[frameIndex]+ dstYSize,  
                                 srcPitch,  dstPitch, height, width, pPriv->xv_refine_using_pcie);
            }       
            break;   
            
        case FOURCC_I420:
            CopyI420To422( buf, buf + srcYSize, buf + srcYSize + srcUVSize,
                           pXvSurface->vaddr[frameIndex],
                           srcPitch, srcPitch>>1, dstPitch, height, width);
            break;
                    
        case FOURCC_YUY2:
        default:
            CopyDataYUV422(buf, pXvSurface->vaddr[frameIndex],
                           srcPitch<<1, dstPitch, height, width<<1);
            break;
    }       

    if(pPriv->xv_refine_using_pcie) {
        switch(pXvSurface->format)
        {
            case FOURCC_YV12:
            case FOURCC_NV12:
                viaFlushPCIECache(pVia, 
                    (pXvSurface->offset[frameIndex]-pVia->agpTexBaseOffset), 
                    (pXvSurface->pitch * pXvSurface->height * 3 /2));        
                break;
            case FOURCC_YUY2:
                viaFlushPCIECache(pVia, 
                    (pXvSurface->offset[frameIndex]-pVia->agpTexBaseOffset), 
                    (pXvSurface->pitch * pXvSurface->height));        
                break;
        }
    }
}

/*Find out which video overlay is now being focused.pPriv is the current port pointer */
static Bool viaCheckVideoOnTop(ScrnInfoPtr pScrn,viaPortPrivPtr pPriv,RegionPtr pDrwReg)
{
    VIAPtr pVia = VIAPTR(pScrn);
    viaPortPrivPtr _pPriv = pVia->pPriv[!pPriv->xv_portnum]; /*the other port*/ 
    Bool intersected;
    unsigned long _inRegion;
    Bool onTop = FALSE;
    RegionPtr _pDrwReg, _pInsRegion;
    BoxPtr pbox;
    
    /* check if both ports have clip region.If only the current port has the clip region,
     * we don't have to check anymore,just return TRUE.That means the other port
     * are not even working yet.*/
    if ( !_pPriv  || &(_pPriv->clip)==NULL){
        return TRUE;
    }
    
    /*reconstruct the other port's drawable region */
    BoxRec _box = { _pPriv->drw_x,\
                    _pPriv->drw_y, \
                    _pPriv->drw_x + _pPriv->drw_w,\
                    _pPriv->drw_y + _pPriv->drw_h \
                             };
    BoxRec _Insbox={0,0,0,0};

    _pDrwReg = REGION_CREATE(pScrn->pScreen,&_box,1);
    _pInsRegion = REGION_CREATE(pScrn->pScreen,&_Insbox,1);
    
    /*get the overlapping region of the two overlay */
    intersected = REGION_INTERSECT(pScrn->pScreen, _pInsRegion, pDrwReg, _pDrwReg);

    /*we have overlapping region.*/
    if  (intersected){           
        pbox = REGION_EXTENTS(pScrn->pScreen, _pInsRegion);

        DBG_DD(("intersected:%d,x1:%d,y1:%d,x2:%d,y2:%d\n",intersected, \
        pbox->x1,pbox->y1,pbox->x2,pbox->y2));

        /*check if the area is in the current port's clip region?*/
         _inRegion = RECT_IN_REGION(pScrn->pScreen,&pPriv->clip, pbox);
        if (_inRegion >rgnOUT) {
            onTop = TRUE;
        }
    }else{    /*no overlapping area*/        
        onTop =TRUE;
    }

    REGION_DESTROY(pScrn->pScreen, _pDrwReg);
    REGION_DESTROY(pScrn->pScreen, _pInsRegion);
   
    return onTop;
}

int viaFixUpOverlayInSAMM(ScrnInfoPtr pScrn, short *drw_x, short *drw_y)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    if( (viaGfxInfo->xrandrEnabled == FALSE && viaGfxInfo->screenAttr.samm)){
        if(viaGfxInfo->igaAttr.iga2_left == TRUE){
            if(viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA1){
                if (*drw_x < 0) {
                    return TRUE;
                } else {
                    *drw_x += viaGfxInfo->igaInfo[IGA2 -1].visible_width;
                }
            }
            
        }else if(viaGfxInfo->igaAttr.iga2_right == TRUE){
            if(viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA2){
                if(*drw_x < 0) {
                    return TRUE;
                } else {
                    *drw_x += viaGfxInfo->igaInfo[IGA1 -1].visible_width;
                }
            }
        }else if(viaGfxInfo->igaAttr.iga2_above == TRUE){
            if(viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA1){
                if(*drw_y < 0) {
                    return TRUE;
                } else {
                    *drw_y += viaGfxInfo->igaInfo[IGA2 -1].visible_height;
                }
            }
        }else if(viaGfxInfo->igaAttr.iga2_below == TRUE){
            if(viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA2){
                if(*drw_y < 0) {
                    return TRUE;
                } else {
                    *drw_y += viaGfxInfo->igaInfo[IGA1 -1].visible_height;
                }
            }
        }
    } 
#else
    if( (viaGfxInfo->xrandrEnabled == FALSE && viaGfxInfo->screenAttr.samm)){
       if(viaGfxInfo->igaAttr.iga2_left == TRUE){
           if((viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA1) && (*drw_x < 0)){
               return TRUE;
           }
       }else if(viaGfxInfo->igaAttr.iga2_right == TRUE){
           if((viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA2) && (*drw_x < 0)){
               return TRUE;
           }
       }else if(viaGfxInfo->igaAttr.iga2_above == TRUE){
           if((viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA1) && (*drw_y < 0)){
               return TRUE;
           }
       }else if(viaGfxInfo->igaAttr.iga2_below == TRUE){
           if((viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse == IGA2) && (*drw_y < 0)){
               return TRUE;
           }
       }
    }
#endif

    return FALSE;
}

void viaFixUpV3OnIGA2Issue(viaGfxInfoPtr viaGfxInfo, viaPortPrivPtr pPriv, unsigned long curIGA)
{
    if(curIGA == IGA2){
        if(viaGfxInfo->chipId != VIA_DEVICE_VT3314){
            if(pPriv->videoFlag & VIDEO_3_INUSE){                  
                pPriv->forceEngReAlloc = TRUE;
                pPriv->patchV3OnIga2 = TRUE;
            }
        }
    }else if(curIGA == IGA1){
        if(viaGfxInfo->chipId != VIA_DEVICE_VT3314){
            if(pPriv->patchV3OnIga2 == TRUE){                
                pPriv->forceEngReAlloc = TRUE;
                pPriv->patchV3OnIga2 = FALSE;
            }
        }
    }    
}

unsigned long viaAllocReallocEngine(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, 
    Bool *forceUpdate, Bool *forceRedraw)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    unsigned long flags = 0;
    unsigned long ret = FALSE;
    
    if(!(pPriv->videoFlag & VIDEO_ACTIVE)){
        /* record the pPriv into pVia for later viaAdjustFrame() or VIARand12RUpdateOverlay() path */
        pVia->pPriv[pPriv->xv_portnum] = pPriv;
        ret = initEngineStatus(pVidData,&flags);
        
        /* init Video status flag*/
        pPriv->videoFlag = flags;           
        DBG_DD((" pPriv->videoFlag = %lx\n",pPriv->videoFlag));
        
        if (ret == FALSE) { 
            freeEngineStatus(pVidData, pPriv);   
            pPriv->redirected = TRUE;
        }else{            
            /* write Color Space Conversion param. */
            SetColorSpace(pVia);
                        
            if (pPriv->videoFlag & VIDEO_VQ_INUSE){
               enableVirtualQueue(pScrn, pPriv);
            }
        }
        
        pPriv->videoFlag |= VIDEO_ACTIVE;
        
    }else if(pPriv->forceEngReAlloc == TRUE){
        if(pPriv->redirected){
            /* case 1 : Texture video  ---> Xv Overlay */
            viaDestroyXvSurface(pScrn, pPriv);
        }else{
            /* case 2:  Xv Overlay ---> Xv Overlay */
            //StopOVerlay(pScrn, pPriv);
            viaDestroyHQVSurface(pScrn, pPriv, pPriv->scrnAttr, pPriv->curIGA);
            viaDestroyROTSurface(pScrn, pPriv, pPriv->scrnAttr, pPriv->curIGA);
            freeEngineStatus(pVidData, pPriv);   
            pPriv->skipDataCopy = TRUE;
        }
        pVia->pPriv[pPriv->xv_portnum] = pPriv;

        if(!pPriv->patchV3OnIga2){
            ret = initEngineStatus(pVidData, &flags);
            pPriv->videoFlag |= flags;
            if (ret == FALSE) {
                if(!pPriv->redirected) {
                    pPriv->redirected = TRUE;
                    viaDestroyXvSurface(pScrn, pPriv);
                }
                freeEngineStatus( pVidData, pPriv);     
            }else{
                *forceUpdate = TRUE;
                if(pPriv->redirected){                    
                    pPriv->redirected = FALSE;
                    *forceRedraw = TRUE;
                }
            }
        }else{
            viaDestroyXvSurface(pScrn, pPriv);
            pPriv->redirected = TRUE;            
        }
        pPriv->forceEngReAlloc = FALSE;
    }

    return ret;
}

int viaDisplayOverlayVideo(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, 
    unsigned long clipChanged, unsigned long forceRedraw, unsigned long forceUpdate)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    DrawablePtr pDraw = pPriv->pDraw;
    PixmapPtr pPixmap = pPriv->pPixmap;
    unsigned long flags = 0;
    
    /* draw color region*/
    if ((clipChanged && pPriv->autopaint_colorkey) || forceRedraw){
        BoxPtr pBox = REGION_EXTENTS(pScrn->pScreen, &pPriv->clip);
        RegionPtr clipBoxes = REGION_CREATE(pScrn->pScreen,pBox,1);
        REGION_COPY(pScrn->pScreen, clipBoxes, &pPriv->clip);
        if (pDraw->type == DRAWABLE_WINDOW) {
            xf86XVFillKeyHelperDrawable(pDraw, pPriv->colorKey, clipBoxes);
            DamageDamageRegion((DrawablePtr)pPixmap, clipBoxes);
        }else{
            xf86XVFillKeyHelper(pScrn->pScreen, pPriv->colorKey, clipBoxes);
        }
        REGION_DESTROY(pScrn->pScreen,clipBoxes);
    }
       
    /* extend the current clip to a bigger rectange.The pPriv->clip reflects 
     * the actual visible region, but we also want the invisible part to be participated in compution
     * So the drawable region is used.*/        
    if(clipChanged){
        BoxRec box= {pPriv->drw_rect.left, pPriv->drw_rect.top, \
            pPriv->drw_rect.right, pPriv->drw_rect.bottom};
        RegionPtr pDrwReg = REGION_CREATE(pScrn->pScreen,&box,1);
        pPriv->vidOnTop = viaCheckVideoOnTop(pScrn,pPriv,pDrwReg);
        REGION_DESTROY(pScrn->pScreen,pDrwReg);
    }

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    if(pPriv->redirected) {
        viaDisplayTexturedVideo(pScrn, pPriv);
    } else {
        pPriv->updateOvlPath = forceUpdate || pPriv->updateOvlPath;
        viaDisplayOvlDisplayPath(pScrn, pPriv);
    }
#else
    if (forceUpdate){
        static DDUPDATEOVERLAY updateOvlRec;

        /* fill video overlay parameter*/
        updateOvlRec.rSrc = pPriv->src_rect;
        updateOvlRec.rDest = pPriv->drw_rect;
        updateOvlRec.dwFlags = DDOVER_SHOW |DDOVER_KEYDEST;
        if (pPriv->vidOnTop){
            updateOvlRec.dwFlags |= DDOVER_ON_TOP;
        }
        
        if (UpdateOverlay(pScrn, pPriv, &updateOvlRec) == -1){
            DBG_DD(("  via_video.c : call updateoverlay fail. \n"));
            return XvBadAlloc;
        }
    }else{
        /* flip */
        Flip(pScrn, pPriv);
    }
#endif

    return Success;
}

int viaPutImageG(
    ScrnInfoPtr pScrn,
    short src_x, short src_y,
    short drw_x, short drw_y,
    short src_w, short src_h,
    short drw_w, short drw_h,
    int id, unsigned char* buf,
    short width, short height,
    Bool sync,
    RegionPtr clipBoxes, pointer data,DrawablePtr pDraw)
{
    ScreenPtr pScreen = pScrn->pScreen;
    VIAPtr  pVia = VIAPTR(pScrn);
    viaPortPrivPtr pPriv = (viaPortPrivPtr)data;
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    unsigned long flags = 0;
    PixmapPtr pPixmap;
#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    short drw_xo = drw_x;   /* save drw_x for backup, maybe changed */
    short drw_yo = drw_y;   /* save drw_y for backup, maybe changed */
#endif
    unsigned long curIGA = IGA_NONE;
    Bool clipChanged = FALSE;
    Bool forceUpdate = FALSE;
    Bool forceRedraw = FALSE;   /* Fall back to Ovleray from texture video*/
    int ret = Success;

    DBG_DD(("Enter Function : %s\n",__FUNCTION__)); 

    if(pPriv->xv_portnum >= XV_PORT_NUM_OVERLAY){
        DBG_DD((" XV Port exceed the maximum\n"));
        return BadAlloc;
    }

    DBG_DD(("    Screen[%d]\n", pScrn->scrnIndex));
    DBG_DD(("    FourCC=0x%08x width=%hd height=%hd sync=%d\n",id,width,height,sync));
    DBG_DD(("    src_x=%hd src_y=%hd src_w=%hd src_h=%hd colorkey=0x%lx\n",src_x, src_y, \
        src_w, src_h, pPriv->colorKey));
    DBG_DD(("    drw_x=%hd drw_y=%hd drw_w=%hd drw_h=%hd\n",drw_x,drw_y,drw_w,drw_h));
    DBG_DD(("    pDraw = %p\n", pDraw));

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    /* Only apply this patch to non-redirected Overlay, notice that the parameter of
       drw_xc and drw_yc may be changed after call */
    if(!pPriv->redirected && 
        viaFixUpOverlayInSAMM(pScrn, &drw_x, &drw_y)) {
        return Success;
    }
#else
    /* To avoid the situation when video across two screen when SAMM, 
     * As it will call twice viaPutImageG with pScrn->scrnIndex=0 and 1*/
    if(viaFixUpOverlayInSAMM(pScrn, &drw_x, &drw_y)) {
        return Success;
    }
#endif

    if (pDraw->type == DRAWABLE_WINDOW) {
        pPixmap = (*pScreen->GetWindowPixmap)((WindowPtr)pDraw);
    } else{
        pPixmap = (PixmapPtr)pDraw;
    }

/* 1. determine current iga, on which video overlay is attached */
#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    viaDetermineOvlDisplayPath(pScrn, pPriv, src_x, src_y, drw_x, drw_y, \
        src_w, src_h, drw_w, drw_h);
#else
    determineCurrentIGAInUse(pScrn, &curIGA, drw_x, drw_y);
    if(curIGA == IGA_NONE){        
        DBG_DD((" current IGA is zero, return\n"));
        return BadAlloc;
    } else {
        viaFixUpV3OnIGA2Issue(viaGfxInfo, pPriv, curIGA);
    }
#endif

    /* If there is bandwidth issue, block the H/W overlay */
    if (pVidData->dwRejectOverlay){
        DBG_DD((" Bandwidth issue, rejected!\n"));
        return BadAlloc;
    }

/* 2. video/hqv engine management */
#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    if(!(pPriv->videoFlag & VIDEO_ACTIVE)) {
        if(viaCreateXvSurface( pScrn, pPriv,id, width, height) != TRUE){
            DBG_DD((" Xv surface memory allocation failure!\n"));
            return BadAlloc;
        }
        ret = viaCreateOvlDisplayPath(pScrn, pPriv);
        
        if(ret == FALSE) {
            viaDestroyXvSurface(pScrn, pPriv);
            pPriv->redirected = TRUE;
        } else {
            /* write Color Space Conversion param. */
            SetColorSpace(pVia);
                        
            if (pPriv->videoFlag & VIDEO_VQ_INUSE){
               enableVirtualQueue(pScrn, pPriv);
            }
        }
        /* Record the pPriv into pVia for later viaAdjustFrame() 
            or VIARand12RUpdateOverlay() path 
        */
        pVia->pPriv[pPriv->xv_portnum] = pPriv;

        pPriv->videoFlag |= VIDEO_ACTIVE;
    } else {
        ret = viaRebuildOvlDisplayPath(pScrn, pPriv);

        if(ret == FALSE) {
            if(!pPriv->redirected) {
                viaDestroyXvSurface(pScrn, pPriv);
                pPriv->redirected = TRUE;
            }
        } else {
            if(pPriv->redirected) {
                viaDestroyXvSurface(pScrn, pPriv);
                pPriv->redirected = FALSE;
            }
        }
    }

    /* The following code is a patch for redirected overlay video, which is the same
       processing flow as texture video.
    */
    if(pPriv->redirected) {
        /* restore the original parameter of drw_x/drw_y for redirected path */
        drw_x = drw_xo;
        drw_y = drw_yo;
        if(!viaClipVideoToViewPort(pScrn, &src_x, &src_y, &src_w, &src_h, \
            &drw_x, &drw_y, &drw_w, &drw_h, width, height, clipBoxes)) {
            return Success;
        }
        if(!viaCheckVideoTargetPixmap(pScrn, pPriv, pPixmap)) {
            return BadAlloc;
        }
    }
#else
    viaAllocReallocEngine(pScrn, pPriv, &forceUpdate, &forceRedraw);

/* 3. redirect to Texture video path in some specific situation */
    if(pPriv->redirected){
        /* refresh the pPriv->scrnAttr and pPriv->curIGA here ! */
        pPriv->scrnAttr = viaGfxInfo->screenAttr.uint;
        pPriv->curIGA = curIGA;
        return viaPutImageTexturedG(pScrn, src_x, src_y, \
                    drw_x, drw_y, src_w, src_h, drw_w, drw_h, id,  buf,\
                    width,  height, sync, clipBoxes, data, pDraw); 
    }
#endif

/* 4. surface management */
#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    if ((pPriv->width != width) || (pPriv->height != height)){
        viaDestroyXvSurface(pScrn, pPriv);
    }

    if(!pPriv->pXvSurface){
        if(viaCreateXvSurface( pScrn, pPriv,id, width, height) != TRUE){
            viaDestroyXvSurface(pScrn, pPriv);
            viaDestroyOvlDisplayPath(pScrn, pPriv);
            DBG_DD((" Xv surface memory allocation failure!\n"));
            return BadAlloc;
        }
    }
#else
    if ((pPriv->width != width) || (pPriv->height != height)){
        viaDestroyXvSurface(pScrn, pPriv);
        viaDestroyHQVSurface(pScrn, pPriv, pPriv->scrnAttr, pPriv->curIGA);
        viaDestroyROTSurface(pScrn, pPriv, pPriv->scrnAttr, pPriv->curIGA);
    }
    if(pPriv->curIGA != curIGA){
        viaDestroyHQVSurface(pScrn, pPriv, pPriv->scrnAttr, pPriv->curIGA);
        viaDestroyROTSurface(pScrn, pPriv, pPriv->scrnAttr, pPriv->curIGA);
    }
    /* refresh the pPriv->scrnAttr and pPriv->curIGA here ! */
    pPriv->scrnAttr = viaGfxInfo->screenAttr.uint;
    pPriv->curIGA = curIGA;

    if(!pPriv->pXvSurface){
        if(viaCreateXvSurface( pScrn, pPriv,id, width, height) != TRUE){
            viaDestroyXvSurface(pScrn, pPriv);
            freeEngineStatus(pVidData, pPriv);
            DBG_DD((" Xv surface memory allocation failure!\n"));
            return BadAlloc;
        }
        pPriv->skipDataCopy = FALSE;
    }
    if( viaCreateHQVSurface( pScrn, pPriv,id, width, height) != TRUE){
        DBG_DD((" HQV surface memory allocation failure!\n"));
        viaDestroyXvSurface(pScrn, pPriv);
        return BadAlloc;
    }    
#endif

/* 5. upload video data to Xv surface */
    pPriv->pXvSurface->cur_idx = pPriv->framenum%XV_SURFACE_NUM;
    pPriv->framenum++;

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    viaUploadToXVSurface(pScrn, pPriv, id, buf, pPriv->pXvSurface, width, height);
#else
    if(pPriv->skipDataCopy) {
        pPriv->skipDataCopy = FALSE;
    } else {
        viaUploadToXVSurface(pScrn, pPriv, id, buf, pPriv->pXvSurface, width, height);
    }
#endif

/* 6. update clip region, and the flags of clipChanged, forceUpdate */
    if (!REGION_EQUAL(pScrn->pScreen, &pPriv->clip, clipBoxes)){
        REGION_COPY(pScrn->pScreen, &pPriv->clip, clipBoxes);
        clipChanged = TRUE;
        /* if rotate status changes, force update overlay */
        forceUpdate = TRUE;
        DBG_DD((" clipchanages\n"));
    }
    
#ifndef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
    /* if rotate status changes, force update overlay */
    if(viaGfxInfo->screenAttr.uint & SCRN_ATTR_DUO_CLONE_VIEW){
        if((pPriv->igaRRStatus[0] != viaGfxInfo->igaInfo[0].igaRRStatus.unit) ||
           (pPriv->igaRRStatus[1] != viaGfxInfo->igaInfo[1].igaRRStatus.unit)) {    
            forceUpdate = TRUE;
        }
    }else{
        if((pPriv->igaRRStatus[pPriv->curIGA-1] != \
            viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit)){
            forceUpdate = TRUE;
        }
    }
#endif

    if ((pPriv->drw_x == drw_x) && (pPriv->drw_y == drw_y) && 
        (pPriv->drw_w == drw_w) && (pPriv->drw_h == drw_h) && 
        (pPriv->src_x == src_x) && (pPriv->src_y == src_y) && 
        (pPriv->src_w == src_w) && (pPriv->src_h == src_h) && 
        (pPriv->videoFlag & VIDEO_ACTIVE)){
        DBG_DD(("If the dest rec & src rect & extendFIFO doesn't change, \
            don't do UpdateOverlay\n"));
    } else {
        forceUpdate = TRUE;
    }
    
/* 7. display Xv overlay video */
    if(!pPriv->textured)
    {
        pPriv->src_rect.left = src_x;
        pPriv->src_rect.top = src_y;
        pPriv->src_rect.right = src_x + src_w;
        pPriv->src_rect.bottom = src_y + src_h;
        
        pPriv->drw_rect.left  = drw_x;
        pPriv->drw_rect.top = drw_y;
        pPriv->drw_rect.right = drw_x + drw_w;
        pPriv->drw_rect.bottom = drw_y + drw_h;

        pPriv->pDraw = pDraw;
        pPriv->pPixmap = pPixmap;
        ret = viaDisplayOverlayVideo(pScrn, pPriv, clipChanged, forceRedraw, forceUpdate);
    }

    BACKUP_PARAMETERS(pPriv, id, src_x, src_y, drw_x, drw_y, \
        src_w, src_h, drw_w, drw_h, width, height, buf, sync, pDraw);

    return ret;
}


static int viaReputImageG( ScrnInfoPtr pScrn, short drw_x, 
    short drw_y,  RegionPtr clipBoxes, 
    pointer data, DrawablePtr pDraw )
{
    viaPortPrivPtr pPriv = (viaPortPrivPtr)data;

    DBG_DD((" via_video.c : viaReputImageG\n"));

    /* 1, it need to re-draw colorkey region when clip */   
    /* 2, clean the data staruct clip record */     
    REGION_EMPTY(pScrn->pScreen, &pPriv->clip);

    return Success;
}

static int viaQueryImageAttributesG( ScrnInfoPtr pScrn,
    int id,  unsigned short *w, unsigned short *h, int *pitches, int *offsets)
{
    int size, tmp;

    DBG_DD((" via_video.c : viaQueryImageAttributesG : FourCC=0x%x\n", id));
    DBG_DD((" via_video.c : Screen[%d]\n", pScrn->scrnIndex));

    if ( (!w) || (!h) )
        return 0;

    if(*w > MAXWIDTH)
    {
        *w = MAXWIDTH;
    }
        
    if(*h > MAXHEIGHT)
    {
        *h = MAXHEIGHT;
    }

    *w = (*w + 1) & ~1;
    if(offsets)
    {
        offsets[0] = 0;
    }

    switch(id)
    {
        case FOURCC_YV12:  /*Planar format : YV12 -4:2:0*/
        case FOURCC_I420:
            *h = (*h + 1) & ~1;
            size = *w;

            if(pitches)
            {
                pitches[0] = size;
            }
            
            size *= *h;
            
            if(offsets)
            {
                offsets[1] = size;
            }
            
            tmp = (*w >> 1);
            
            if(pitches)
            {
                pitches[1] = pitches[2] = tmp;
            }
            
            tmp *= (*h >> 1);
            size += tmp;
            
            if(offsets)
            {
                offsets[2] = size;
            }
            
            size += tmp;
            break;
            
        case FOURCC_AI44:
        case FOURCC_IA44:
            size = *w * *h;
            if (pitches)
            {
                pitches[0] = *w;
            }
            
            if (offsets)
            {
                offsets[0] = 0;
            }
            
            break;
        case FOURCC_VDPAU:
            size = sizeof(viaVdpImageDataRec);
            if (pitches)
                pitches[0] = size;
            break;	
            
        case FOURCC_UYVY:  /*Packed format : UYVY -4:2:2*/
        case FOURCC_YUY2:  /*Packed format : YUY2 -4:2:2*/
        default:
            size = (*w << 1);
            
            if(pitches)
            {
                pitches[0] = size;
            }
            size *= *h;
            break;
    }

    if ( pitches )
    {
        DBG_DD((" pitches[0]=%d, pitches[1]=%d, pitches[2]=%d, ", pitches[0], pitches[1], pitches[2]));
    }

    if ( offsets )
    {
        DBG_DD((" offsets[0]=%d, offsets[1]=%d, offsets[2]=%d, ", offsets[0], offsets[1], offsets[2]));
    }

    DBG_DD((" width=%d, height=%d \n", *w, *h));

    return size;
}

#ifdef  VIA_DEFINE_OVERLAY_DISPLAY_PATH
static unsigned long allocateVideoEngineNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    unsigned long video_alloc_value;
    
    /*try to allocate video engine*/
    allocEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO],&video_alloc_value);
    if (HAVE_VIDEO_1 == video_alloc_value){
        pPriv->videoFlag |= VIDEO_1_INUSE;
        DBG_DD(("Video 1 allocated\n"));
    }else{
        if (HAVE_VIDEO_3 == video_alloc_value){
            pPriv->videoFlag |= VIDEO_3_INUSE;
            DBG_DD(("Video 3 allocated\n"));
        }else{
            DBG_DD(("No more available video engine\n "));
            return FALSE;
        }
    }

    if((ovlPath->iga == IGA2) && (HAVE_VIDEO_3 == video_alloc_value)){
        if (pPriv->videoFlag & VIDEO_3_INUSE){    
            releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO], VIDEO_3_INUSE);
            DBG_DD(("Video 3 freed\n"));
            pPriv->videoFlag &= ~VIDEO_3_INUSE;
        }
        DBG_DD(("No more available video engine\n "));
        return FALSE;
    }
        
    ovlPath->vidEng = video_alloc_value;
    return TRUE;
}

static unsigned long allocateHQVEngineNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    unsigned long hqv_alloc_value;

    /*try to allocate HQV engine*/
    allocEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_HQV], &hqv_alloc_value);
    if (HAVE_HQV_0 == hqv_alloc_value){
       pPriv->videoFlag |= HQV_0_INUSE|VIDEO_HQV_INUSE;
       DBG_DD(("HQV 0 allocated\n"));
    }else{                     
        if (HAVE_HQV_1 == hqv_alloc_value){
            pPriv->videoFlag |= HQV_1_INUSE|VIDEO_HQV_INUSE; 
            DBG_DD(("HQV 1 allocated\n"));
        }else{   
           DBG_DD(("No more available HQV engine\n ")); 
           return FALSE;
        }
    }

    ovlPath->hqvEng = hqv_alloc_value;
    return TRUE;
}

static void releaseVideoEngineNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;

    if(ovlPath->vidEng == HAVE_VIDEO_1) {
        if (pPriv->videoFlag & VIDEO_1_INUSE){    
            releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO], HAVE_VIDEO_1);
            DBG_DD(("Video 1 freed\n"));
            pPriv->videoFlag &= ~VIDEO_1_INUSE;
        }
    }

    if(ovlPath->vidEng == HAVE_VIDEO_3) {
        if (pPriv->videoFlag & VIDEO_3_INUSE){    
            releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_VIDEO], HAVE_VIDEO_3);
            DBG_DD(("Video 1 freed\n"));
            pPriv->videoFlag &= ~VIDEO_3_INUSE;
        }
    }
}
static void releaseHQVEngineNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;

    if(ovlPath->hqvEng == HAVE_HQV_0) {
        if (pPriv->videoFlag & HQV_0_INUSE){
            releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_HQV], HAVE_HQV_0);
            DBG_DD(("HQV 0 freed\n"));        
            pPriv->videoFlag &= ~HQV_0_INUSE;    
        }
    }

    if(ovlPath->hqvEng == HAVE_HQV_1) {
        if (pPriv->videoFlag & HQV_1_INUSE){
            releaseEngine(&pVidData->ViaEngManager.ViaEngineMatrix[ENGINE_HQV], HAVE_HQV_1);
            DBG_DD(("HQV 1 freed\n"));        
            pPriv->videoFlag &= ~HQV_1_INUSE;   
        }
    }
}

static unsigned long createHQVSurfaceNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo; 

    unsigned int i, swWidth, swHeight, swPitch, swFourcc, format, formatType, fbsize;
    unsigned int  width, height, pitch, fourcc;
    int ret = TRUE;

    swFourcc = pPriv->pXvSurface->format;
    swWidth = pPriv->pXvSurface->width;
    swHeight = pPriv->pXvSurface->height;
    swPitch = pPriv->pXvSurface->pitch;

    width = swWidth;
    height = swHeight;

    switch (swFourcc) {
        /*If rotate, Format in HQV surface will be YUY2 if 314, RGB16 if not 314, they all 2 bytes one pixel*/
        case FOURCC_YV12:
        case FOURCC_NV12:
            pitch = swPitch*2;
            fbsize = ALIGN_TO(pitch * height,256);
            break;
        case FOURCC_YUY2:
            pitch  = swPitch;
            fbsize = ALIGN_TO(pitch * height,256);
            break;
        default:
            DBG_DD(("  Unknown supported format!\n"));
            return FALSE;
    }

    DBG_DD(("HQVSurface Size:%08x\n",fbsize));
    
    viaVideoMemFree(pScrn,&ovlPath->hqvMem);
    ret = viaVideoMemAlloc(pScrn,  &ovlPath->hqvMem, fbsize * XV_HQVSURFACE_NUM);

    if((ret == BadAlloc) ||(!ovlPath->hqvMem.pool) || (!ovlPath->hqvMem.base)) {
        return FALSE;
    }

    if((ovlPath->hqvSurf = (ViaXvSurfacePtr)xcalloc(1, sizeof(ViaXvSurfaceRec))) == NULL){
        return FALSE;
    }

    if(viaGfxInfo->igaInfo[ovlPath->iga -1].igaRRStatus.unit){        
        if (viaGfxInfo->chipId == VIA_DEVICE_VT3314){
            format = FOURCC_YUY2;
            formatType = DDPF_FOURCC;
        }else{
            format = RGB16;
            formatType = DDPF_RGB;
        }        
    }else{
        format = FOURCC_YUY2;
        formatType = DDPF_FOURCC;
    }   

    if(formatType & DDPF_FOURCC){
        yuvFillBlack(pVia, ovlPath->hqvMem.base, fbsize * XV_HQVSURFACE_NUM);
    }else{
        rgbFillBlack(pVia, ovlPath->hqvMem.base, fbsize * XV_HQVSURFACE_NUM);
    }   

    ovlPath->hqvSurf->format = format;
    ovlPath->hqvSurf->formatType = formatType;
    ovlPath->hqvSurf->width  = width;
    ovlPath->hqvSurf->height = height;
    ovlPath->hqvSurf->pitch = pitch;
    
    for(i=0;i<XV_HQVSURFACE_NUM;i++){
        ovlPath->hqvSurf->offset[i] = ALIGN_TO(ovlPath->hqvMem.base + i* fbsize,256);
        ovlPath->hqvSurf->vaddr[i] = pVia->FBBase + ovlPath->hqvSurf->offset[i];

        ovlPath->ovlInfo.dwHQVAddr[i] =  ovlPath->hqvSurf->offset[i];
    }

    ovlPath->ovlInfo.dwOriSrcWidth = swWidth;
    ovlPath->ovlInfo.dwOriSrcHeight = swHeight;
    ovlPath->ovlInfo.dwOriSrcPitch = swPitch;
    
    return TRUE;
}

static unsigned long createROTSurfaceNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    ScrnInfoPtr pScrn0 = xf86Screens[0];
    VIAPtr pVia = VIAPTR(pScrn0);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo; 

    unsigned int i, hqvWidth, hqvHeight, hqvPitch, hqvFourcc, fbsize;
    unsigned int  width, height, pitch_w, pitch_h, fourcc;
    int ret = TRUE;

    hqvFourcc = ovlPath->hqvSurf->format;
    hqvWidth = ovlPath->hqvSurf->width;
    hqvHeight = ovlPath->hqvSurf->height;
    hqvPitch = ovlPath->hqvSurf->pitch;

    /* If rotate, Format in HQV surface will be YUY2 if 314, RGB16 if not 314, they all 2 bytes one pixel
     * After rotate, format will be RGB16, it means format in ROT surface always RGB16
     */
    width = ALIGN_TO(hqvWidth, 32);
    pitch_w  = ALIGN_TO(width<<1, 256);
    height = ALIGN_TO(hqvHeight, 32);
    pitch_h = ALIGN_TO(height<<1, 256);
    fbsize = max(pitch_w* height, pitch_h * width);
    DBG_DD(("RotSurface Size:%08x\n",fbsize));

    viaVideoMemFree(pScrn,&ovlPath->rotMem);
    ret = viaVideoMemAlloc(pScrn,  &ovlPath->rotMem, fbsize * XV_ROTSURFACE_NUM);

    if((ret == BadAlloc) ||(!ovlPath->rotMem.pool) || (!ovlPath->rotMem.base)) {
        return FALSE;
    }

    rgbFillBlack(pVia, ovlPath->rotMem.base, fbsize * XV_ROTSURFACE_NUM);

    if((ovlPath->rotSurf = (ViaXvSurfacePtr)xcalloc(1, sizeof(ViaXvSurfaceRec))) == NULL){
        return FALSE;
    }

    ovlPath->rotSurf->format = RGB16;
    ovlPath->rotSurf->formatType = DDPF_RGB;   

    ovlPath->rotSurf->width  = width;
    ovlPath->rotSurf->height = height;
    ovlPath->rotSurf->pitch =
        (viaGfxInfo->igaInfo[ovlPath->iga -1].igaRRStatus.rotate_90 ||
         viaGfxInfo->igaInfo[ovlPath->iga -1].igaRRStatus.rotate_270) ? pitch_h : pitch_w;


    for(i=0;i<XV_ROTSURFACE_NUM;i++){
        ovlPath->rotSurf->offset[i] = ALIGN_TO(ovlPath->rotMem.base + i* fbsize, 256);
        ovlPath->rotSurf->vaddr[i] = pVia->FBBase + ovlPath->rotSurf->offset[i];
    }

    ovlPath->rotSurf->cur_idx = 0;
    ovlPath->igaRRStatus = viaGfxInfo->igaInfo[ovlPath->iga -1].igaRRStatus.unit;

    if (viaGfxInfo->chipId != VIA_DEVICE_VT3314){
        ovlPath->hqvSurf->format = RGB16;
        ovlPath->hqvSurf->formatType= DDPF_RGB;
    }

    return TRUE;
}

static void destroyHQVSurfaceNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, viaOvlDisplayPathPtr ovlPath)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  

    if(ovlPath->hqvSurf){
        if(ovlPath->hqvMem.pool && ovlPath->hqvMem.base){
            viaVideoMemFree(pScrn,  &ovlPath->hqvMem);
        }
        xfree(ovlPath->hqvSurf);
        ovlPath->hqvSurf = NULL;
    }else{
        DBG_DD((" HQV surface is NULL\n"));
    }
}

static void destroyROTSurfaceNew(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,viaOvlDisplayPathPtr ovlPath)
{
    VIAPtr pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  

    if(ovlPath->rotSurf){
        if(ovlPath->rotMem.pool && ovlPath->rotMem.base){
            viaVideoMemFree(pScrn,  &ovlPath->rotMem);
        }
        xfree(ovlPath->rotSurf);
        ovlPath->rotSurf = NULL;
        
        if (viaGfxInfo->chipId != VIA_DEVICE_VT3314){
            ovlPath->hqvSurf->format = FOURCC_YUY2;
            ovlPath->hqvSurf->formatType= DDPF_FOURCC;
        }
    }else{
        DBG_DD((" ROT surface is NULL\n"));
    }
}

static void viaAddOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,  unsigned long iga)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    viaOvlDisplayPathPtr ovlPath;
    Bool retv, reth;
    
    if(!pPriv->ovlDisplayPath[iga -1]) {
        ovlPath = xcalloc(sizeof(viaOvlDisplayPathRec), 1);
        ovlPath->iga = iga;
        retv = allocateVideoEngineNew(pScrn, pPriv, ovlPath);
        reth = allocateHQVEngineNew(pScrn, pPriv, ovlPath);
        
        if((retv == FALSE) || (reth == FALSE)) {
            releaseVideoEngineNew(pScrn, pPriv, ovlPath);
            releaseHQVEngineNew(pScrn, pPriv, ovlPath);  
            xfree(ovlPath);
            pPriv->ovlDisplayPath[iga -1] = NULL;
            return;
        }
        createHQVSurfaceNew(pScrn, pPriv, ovlPath);
        if(viaGfxInfo->igaInfo[iga -1].igaRRStatus.unit) {
            createROTSurfaceNew(pScrn, pPriv, ovlPath);
        }
        pPriv->ovlDisplayPath[iga -1] = ovlPath;
    }
}

static void viaRemoveOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, unsigned long iga)
{
    viaOvlDisplayPathPtr  ovlPath;

    if(pPriv->ovlDisplayPath[iga -1]) {
        ovlPath = pPriv->ovlDisplayPath[iga -1];

        destroyHQVSurfaceNew(pScrn, pPriv, ovlPath);
        if(ovlPath->rotSurf) {
            destroyROTSurfaceNew(pScrn, pPriv, ovlPath);
        }
        releaseVideoEngineNew(pScrn, pPriv, ovlPath);
        releaseHQVEngineNew(pScrn, pPriv, ovlPath);            

        xfree(ovlPath);
        pPriv->ovlDisplayPath[iga -1] = NULL;
    }
}

static void viaCaculateParaOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, unsigned long iga)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    viaOvlDisplayPathPtr  ovlPath;
    BoxPtr displayBox;
    float hor_factor, ver_factor;
    ViaXvRectPtr src, dst, dst_new;
    ViaXvRectRec ovlDummy;

    ovlPath = pPriv->ovlDisplayPath[iga -1];
    
    displayBox = &pPriv->Box_OvlPath[iga -1];
    src = &ovlPath->src;
    dst = &ovlPath->dst;
    dst_new = &ovlDummy;

    src->left = pPriv->Box_XvSrc.x1;
    src->top = pPriv->Box_XvSrc.y1;
    src->right = pPriv->Box_XvSrc.x2;
    src->bottom = pPriv->Box_XvSrc.y2;

    dst->left = pPriv->Box_XvDst.x1;
    dst->top = pPriv->Box_XvDst.y1;
    dst->right = pPriv->Box_XvDst.x2;
    dst->bottom = pPriv->Box_XvDst.y2;
    
    dst_new->left = displayBox->x1;
    dst_new->top = displayBox->y1;
    dst_new->right = displayBox->x2;
    dst_new->bottom = displayBox->y2;

    if((dst_new->left > dst->left) ||
       (dst_new->top > dst->top) ||
       (dst_new->right < dst->right) ||
       (dst_new->bottom < dst->bottom)) {

        hor_factor = (dst->right - dst ->left)/(src->right - src->left);
        ver_factor = (dst ->bottom - dst ->top)/(src->bottom - src->top);

        src->left += (dst_new->left - dst->left)/hor_factor;
        src->top += (dst_new->top - dst->top)/ver_factor;
        src->right -= (dst->right - dst_new->right)/hor_factor;
        src->bottom -= (dst->bottom - dst_new->bottom)/ver_factor;
    }

    dst->left = dst_new->left - pPriv->Box_Iga[iga -1].x1;
    dst->top = dst_new->top - pPriv->Box_Iga[iga -1].y1;
    dst->right = dst_new->right - pPriv->Box_Iga[iga -1].x1;
    dst->bottom = dst_new->bottom - pPriv->Box_Iga[iga -1].y1;
}

unsigned long viaDisplayOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    static DDUPDATEOVERLAY updateOvlRec;
    viaOvlDisplayPathPtr ovlPath;
    unsigned long ret;
    int iga;

    for(iga = IGA2; iga >= IGA1; iga >>=1)
    {
        ovlPath = pPriv->ovlDisplayPath[iga -1];
        
        if(ovlPath) {
            if (pPriv->updateOvlPath){
                /* update overlay */

                updateOvlRec.rSrc = ovlPath->src;
                updateOvlRec.rDest = ovlPath->dst;
                updateOvlRec.dwFlags = DDOVER_SHOW |DDOVER_KEYDEST;
                if (pPriv->vidOnTop){
                    updateOvlRec.dwFlags |= DDOVER_ON_TOP;
                }
                ret = updateOvl(pScrn, pPriv, ovlPath, &updateOvlRec);
                
            } else {            
                /* flip */

                ret = flipOvl(pScrn, pPriv, ovlPath);
            }
        }
    }
    return ret;
}

unsigned long viaDetermineOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,
        short src_x, short src_y, short drw_x, short drw_y, 
        short src_w, short src_h, short drw_w, short drw_h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    BoxPtr Box_XvSrc, Box_XvDst, Box_Iga, Box_OvlPath;
    int iga;

    /* reset the flat of updateOvlPath everytime */
    pPriv->updateOvlPath = FALSE;
    pPriv->redirected = FALSE;

    Box_XvSrc = &pPriv->Box_XvSrc;
    Box_XvSrc->x1 = src_x;
    Box_XvSrc->y1 = src_y;
    Box_XvSrc->x2 = src_x + src_w;
    Box_XvSrc->y2 = src_y + src_h;
    
    Box_XvDst = &pPriv->Box_XvDst;
    Box_XvDst->x1 = drw_x;
    Box_XvDst->y1 = drw_y;
    Box_XvDst->x2 = drw_x + drw_w;
    Box_XvDst->y2 = drw_y + drw_h;
    
    for(iga = IGA2; iga >= IGA1; iga >>=1)
    {
        if(viaGfxInfo->igaInfo[iga -1].actived) {
            Box_Iga = &pPriv->Box_Iga[iga -1];
            Box_OvlPath = &pPriv->Box_OvlPath[iga -1];
            Box_Iga->x1 = viaGfxInfo->igaInfo[iga -1].start_x;
            Box_Iga->y1 = viaGfxInfo->igaInfo[iga -1].start_y;

            if(viaGfxInfo->igaInfo[iga -1].igaRRStatus.rotate_90 ||
                viaGfxInfo->igaInfo[iga -1].igaRRStatus.rotate_270) {
                Box_Iga->x2 = viaGfxInfo->igaInfo[iga -1].start_x + \
                                     viaGfxInfo->igaInfo[iga -1].desired_height;
                Box_Iga->y2 = viaGfxInfo->igaInfo[iga -1].start_y + \
                                     viaGfxInfo->igaInfo[iga -1].desired_width;
            } else {
                Box_Iga->x2 = viaGfxInfo->igaInfo[iga -1].start_x + \
                                     viaGfxInfo->igaInfo[iga -1].desired_width;
                Box_Iga->y2 = viaGfxInfo->igaInfo[iga -1].start_y + \
                                     viaGfxInfo->igaInfo[iga -1].desired_height;
            }
            
            INTERSECT_BOX(Box_XvDst, Box_Iga, Box_OvlPath);
                       
            if(VALIDATE_BOX(Box_OvlPath)){
                pPriv->attachedIga.uint |= iga;
            } else {
                pPriv->attachedIga.uint &= ~iga;
            }
        } else {
            pPriv->attachedIga.uint &= ~iga;
        }
    }

    return TRUE;
}

unsigned long viaCreateOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    LPVIDHWDIFFERENCE lpVideoHWDifference = &pVidData->VideoHWDifference;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long ret = TRUE;
    int iga;

    for(iga = IGA2; iga >= IGA1; iga >>=1)
    {
        if(pPriv->attachedIga.uint & iga) {
            viaAddOvlDisplayPath(pScrn, pPriv, iga);
            pPriv->updateOvlPath = TRUE;
        }

        if(pPriv->attachedIga.uint & iga) {
            if(!pPriv->ovlDisplayPath[iga -1]) {
                ret = FALSE;
                break;
            } else {
                viaCaculateParaOvlDisplayPath(pScrn, pPriv, iga);
            }
        }
    }

    if(ret == FALSE) {
        viaDestroyOvlDisplayPath(pScrn, pPriv);
    } else {        
        /*if video VQ enabled*/
        if(lpVideoHWDifference->dwSupportVideoVQ == VID_HWDIFF_TRUE){
            pPriv->videoFlag |= VIDEO_VQ_INUSE;
        }
        
    #if  VIA_APPLY_XVOVERLAY_AGP
        /* set the following flag for wait in CR function */
        if(viaGfxInfo->drmEnabled && viaGfxInfo->chipId != VIA_DEVICE_VT3314) {
            /* if video go AGP mode, no need to enable Virtual Queue */
            pPriv->videoFlag &= ~VIDEO_VQ_INUSE;
            pPriv->videoFlag |= VIDEO_AGP_INUSE;
        } 
    #endif
    }
    
    return ret;
}

unsigned long viaRebuildOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    viaOvlDisplayPathPtr ovlPath;
    unsigned long fbsize;
    unsigned long ret = TRUE;
    int iga;
    
    for(iga = IGA2; iga >= IGA1; iga >>=1)
    {
       if((pPriv->attachedIga.uint & iga) && !pPriv->ovlDisplayPath[iga -1]) {
            if(iga == IGA2) {
                viaDestroyOvlDisplayPath(pScrn, pPriv);
            }
            viaAddOvlDisplayPath(pScrn, pPriv, iga);
            pPriv->updateOvlPath = TRUE;
        } else if(!(pPriv->attachedIga.uint & iga) && pPriv->ovlDisplayPath[iga -1]) {
            viaRemoveOvlDisplayPath(pScrn, pPriv, iga);
            pPriv->updateOvlPath = TRUE;
        }

        if(pPriv->attachedIga.uint & iga) {
            if(!pPriv->ovlDisplayPath[iga -1]) {
                ret = FALSE;
                break;
            } else {
                ovlPath = pPriv->ovlDisplayPath[iga -1];
                
                if(viaGfxInfo->igaInfo[iga -1].igaRRStatus.unit && !ovlPath->rotSurf) {
                    createROTSurfaceNew(pScrn, pPriv, pPriv->ovlDisplayPath[iga -1]);
                } else if(ovlPath->igaRRStatus != viaGfxInfo->igaInfo[iga -1].igaRRStatus.unit) {
                
                    if(viaGfxInfo->igaInfo[iga -1].igaRRStatus.rotate_90 ||
                       viaGfxInfo->igaInfo[iga -1].igaRRStatus.rotate_270) {
                        ovlPath->rotSurf->pitch = ALIGN_TO(ovlPath->rotSurf->height*2 , 256);
                        fbsize = ovlPath->rotSurf->pitch * ovlPath->rotSurf->width;
                    } else {
                        ovlPath->rotSurf->pitch = ALIGN_TO(ovlPath->rotSurf->width*2 , 256);
                        fbsize = ovlPath->rotSurf->pitch * ovlPath->rotSurf->height;
                    }
                    rgbFillBlack(pVia, ovlPath->rotMem.base, fbsize * XV_ROTSURFACE_NUM);
                } else if (!viaGfxInfo->igaInfo[iga -1].igaRRStatus.unit&& ovlPath->rotSurf) {
                    destroyROTSurfaceNew(pScrn, pPriv, pPriv->ovlDisplayPath[iga -1]);
                }
                
                viaCaculateParaOvlDisplayPath(pScrn, pPriv, iga);
                
                if(ovlPath->igaRRStatus != viaGfxInfo->igaInfo[iga -1].igaRRStatus.unit) {
                    pPriv->updateOvlPath = TRUE;
                    ovlPath->igaRRStatus = viaGfxInfo->igaInfo[iga -1].igaRRStatus.unit;
                }
            }
        }
    }

    /* check if it is redirected to Xv Texture video path */
    if(ret == FALSE) {
        viaDestroyOvlDisplayPath(pScrn, pPriv);
    }

    return ret;
}

unsigned long viaDestroyOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;  
    int iga;

    for(iga = IGA2; iga >= IGA1; iga >>=1)
    {
        if(viaGfxInfo->igaInfo[iga -1].actived) {
            if(pPriv->attachedIga.uint & iga) {
                viaRemoveOvlDisplayPath(pScrn, pPriv, iga);
            }
        }
    }
    /* disable VQ should be done before clear the flags
     * otherwise when playing next video right after this one, the system hangs*/
    if (pPriv->videoFlag & VIDEO_VQ_INUSE){
        disableVirtualQueue(pScrn,pPriv);
    }

    if (pPriv->videoFlag & VIDEO_ACTIVE) {
        pPriv->videoFlag = 0;
    }

    return TRUE;
}
#endif

unsigned long determineCurrentIGAInUse(ScrnInfoPtr pScrn, unsigned long *curIGA, int left, int top )
{
    VIAPtr  pVia = VIAPTR(pScrn);
    PVIDDATA pVidData = pVia->pVidData;  
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;    

    *curIGA = IGA_NONE;
    
    if(viaGfxInfo->xrandrEnabled == TRUE){
        if(viaGfxInfo->screenAttr.singleview == TRUE){
            *curIGA = viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse;
        }else if(viaGfxInfo->screenAttr.clone == TRUE){
            *curIGA = IGA1;
        }else if(viaGfxInfo->screenAttr.extend == TRUE){
            if(viaGfxInfo->igaAttr.iga2_left == TRUE){
                if(left >= (int)viaGfxInfo->igaInfo[1].visible_width){
                    *curIGA = IGA1;
                }else{
                    *curIGA = IGA2;
                }
            }else if(viaGfxInfo->igaAttr.iga2_right == TRUE){
                if(left >= (int)viaGfxInfo->igaInfo[0].visible_width){
                    *curIGA = IGA2;
                }else{
                    *curIGA = IGA1;
                }
            }else if(viaGfxInfo->igaAttr.iga2_above == TRUE){
                if(top >= (int)viaGfxInfo->igaInfo[1].visible_height){
                    *curIGA = IGA1;
                }else{
                    *curIGA = IGA2;
                }
            }else if(viaGfxInfo->igaAttr.iga2_below == TRUE){
                if(top >= (int)viaGfxInfo->igaInfo[0].visible_height){
                    *curIGA = IGA2;
                }else{
                    *curIGA = IGA1;
                }
            }else{
                *curIGA = IGA_NONE;
            }
        }
    }else{
        if(viaGfxInfo->screenAttr.duoview == TRUE){
            *curIGA = IGA1;      
        }else if((viaGfxInfo->screenAttr.singleview == TRUE) || 
                 (viaGfxInfo->screenAttr.samm == TRUE)){
            *curIGA = viaGfxInfo->screenInfo[pScrn->scrnIndex].igaInuse;
        }       
    }

    return TRUE;
}

#else
void viaInitVideo(ScreenPtr pScreen) {}
#endif  /* !XvExtension */
