 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

#ifndef _VIA_VIDEO_H_
#define _VIA_VIDEO_H_ 1
#include "via_memmgr.h"

/*
 * INCLUDES
 */
#define TRUE    1
#define FALSE   0

#define XV_ADAPT_NUM         2
#define XV_ADAPT_OVERLAY     0
#define XV_ADAPT_TEXTURE     1

#define XV_PORT_NUM_OVERLAY  2
#define XV_PORT_NUM_TEXTURE  16
 
#define XV_SWOV_PORTID       0
#define XV_SWOV_PORTID2      1

#define XV_SURFACE_NUM       2  /* used for both Xv Overlay and Texture video */
#define XV_HQVSURFACE_NUM    3
#define XV_ROTSURFACE_NUM    2
#define XV_MAXSURFACE_NUM    3

typedef struct {
    unsigned long cur_idx;
    unsigned long format;    
    unsigned long formatType;
    unsigned long width;
    unsigned long height;
    unsigned long pitch;
    unsigned long offset[XV_MAXSURFACE_NUM];
    unsigned char *vaddr[XV_MAXSURFACE_NUM];
} ViaXvSurfaceRec, *ViaXvSurfacePtr;

/*
 * structure for passing information to UpdateOverlay fn
 */
typedef struct{
     long left;
     long top;
     long right;
     long bottom;
} ViaXvRectRec, *ViaXvRectPtr;

/*
 * structure for HQV register setting
 */
typedef struct {
    unsigned long dwSrcAddr;
    unsigned long dwSrcUVAddr;
    unsigned long dwSrcPitch;
    unsigned long dwDstAddr;
    unsigned long dwDstPitch;
    unsigned long dwMinizoomCtl;
    unsigned long dwHScaleCtl;
    unsigned long dwVScaleCtl;
    unsigned long dwSrcCountWH;
    unsigned long dwSrcOffset;
    unsigned long dwSrcDataOffsetStart;
    unsigned long dwSrcDataOffsetEnd;
    unsigned long dwDstDataOffsetStart;
    unsigned long dwDstDataOffsetEnd;
    unsigned long dwDeinterlaceCtl;
    unsigned long dwCSCTileDeblockingCtl;
    unsigned long dwPullDownParameter;
    unsigned long dwExtendCtlColorFormat;    
    unsigned long dwHQVCtl;
} ViaHqvRegRec, *ViaHqvRegPtr;

/*
 * OVERLAYRECORD structure keep all overlay infromation	
 */
typedef struct
{
    /*Misc informatioin*/
    ViaXvRectRec   dwExpandDestRect;            /* If expand. the RECTL need re-calculate
                                               If no expand, the RECTL = dwOriDestRect. */
    ViaXvRectRec   dwScalingDestRect;             /*if 3d-scale video,recalculation is needed*/
    /*Following parameters take HQV engine as consideration*/
    unsigned long  dwHQVAddr[3];            /* Physical address to HQV surface, HQV Dst addr*/
    unsigned long  dwHQVon;                 /* HQV enable flag, to indicate if it has been initialized*/
                                            /* FIXME! Need to change to another name */
    unsigned long  dwDeinterlaceMode;       /* DDOVER_INTERLEAVED or DDOVER_BOB */

    /*Following parameters take Video engine as consideration*/
    unsigned long   dwOffset;               /* Video engine Src offset or Y offset of plane YUV */
        
    unsigned long   dwChromaKeyOn;          /* Chromakey related info. */
    unsigned long   dwChromaLow;
    unsigned long   dwChromaHigh;
    
    unsigned long   dwColorKeyOn;           /* Colorkey related info. */
    unsigned long   dwKeyLow;
    unsigned long   dwKeyHigh;

    /*Following parameters should take HQV+V as a whole*/
    ViaXvRectRec   dwOriSrcRect;                /* keep updateoverlay source RECTL, set by AP, before calculation */
    ViaXvRectRec   dwOriDestRect;               /* keep updateoverlay destination RECTL, set by AP, before calculation */   
    unsigned long  dwOriSrcWidth;           /* FIXME! The Surface Width,  need to be determined */
    unsigned long  dwOriSrcHeight;          /* FIXME! The surface Height, need to be determined */ 
    unsigned long  dwOriSrcPitch;           /* FIXME! The Surface pitch,  need to be determined */    
 
    ViaXvRectRec   dwOverlaySrcRect;            /* The src coordinate after calculation */
    ViaXvRectRec   dwOverlayDestRect;           /* The dst coordinate after calculation */
    unsigned long  dwWidth;                 /* The src width  after calculation, calculated from dwOverlaySrcRect*/
    unsigned long  dwHeight;                /* The src height after calculation, calculated from dwOverlaySrcRect*/   
    unsigned long  dwOverlayDestWidth;      /* The dst width  after calculation*/
    unsigned long  dwOverlayDestHeight;     /* The dst height after calculation*/
    unsigned long  dwRotDestWidth;      /* The rotated width  after calculation*/
    unsigned long  dwRotDestHeight;     /* The rotated height after calculation*/
    unsigned long dwRotPitch;         /*3D engine's pitch to do rotation*/

    /*FIXME! it really represent the information about Video Engine*/
    unsigned long dwHQVzoomflagH;
    unsigned long dwHQVzoomflagV; 

} OVERLAYRECORD, *LPOVERLAYRECORD;

#ifdef VIA_DEFINE_OVERLAY_DISPLAY_PATH
#define  MAX_OVL_PATH_NUM  2

/* define the xv Overlay display path structure */
typedef struct {
  unsigned long iga;
  unsigned long vidEng;
  unsigned long hqvEng;
  ViaXvRectRec src;
  ViaXvRectRec dst;
  
  /* each Ovl display path specific */
  ViaMemRec hqvMem;
  ViaXvSurfacePtr hqvSurf;
  ViaMemRec rotMem;
  ViaXvSurfacePtr rotSurf;  
  OVERLAYRECORD ovlInfo;
  unsigned long igaRRStatus;
} viaOvlDisplayPathRec, *viaOvlDisplayPathPtr;

typedef union {
    struct {
        unsigned long iga1  :1;
        unsigned long iga2  :1;
        unsigned long reserved   :30;
    };
    unsigned long uint;
} viaOvlAttachedIgaRec, *viaOvlAttachedIgaPtr;
#endif

#define EXTENTCHECK(r1,r2) \
      (!( ((r1)->x2 <= (r2)->x1)  || \
          ((r1)->x1 >= (r2)->x2)  || \
          ((r1)->y2 <= (r2)->y1)  || \
          ((r1)->y1 >= (r2)->y2) ) )

/* true iff (x,y) is in Box */
#define INBOX(r,x,y) \
      ( ((r)->x2 >  x) && \
        ((r)->x1 <= x) && \
        ((r)->y2 >  y) && \
        ((r)->y1 <= y) )

/* true iff Box r1 contains Box r2 */
#define SUBSUMES(r1,r2) \
      ( ((r1)->x1 <= (r2)->x1) && \
        ((r1)->x2 >= (r2)->x2) && \
        ((r1)->y1 <= (r2)->y1) && \
        ((r1)->y2 >= (r2)->y2) )

#define INTERSECT_BOX(pBox1, pBox2, pBox3) \
do {                                                                   \
    if(EXTENTCHECK(pBox1, pBox2)) {      \
            pBox3->x1 = max(pBox1->x1, pBox2->x1);          \
            pBox3->y1 = max(pBox1->y1, pBox2->y1);          \
            pBox3->x2 = min(pBox1->x2, pBox2->x2);           \
            pBox3->y2 = min(pBox1->y2, pBox2->y2);           \
        } else {                                                                       \
            pBox3->x1 = 0;                                                      \
            pBox3->y1 = 0;                                                      \
            pBox3->x2 = 0;                                                      \
            pBox3->y2 = 0;                                                      \
        }                                                                                 \
} while(0)

#define VALIDATE_BOX(pBox)  \
    (!(((pBox)->x2 <= (pBox)->x1) ||\
        ((pBox)->y2 <= (pBox)->y1)))


    
/* Vdpau image structure */
typedef struct _viaVdpImageDataRec{
    unsigned long fourcc;
    unsigned long offset ;
    unsigned long w;
    unsigned long h;
    unsigned long pitch;      
}viaVdpImageDataRec,*viaVdpImageDataPtr;

typedef   union  _3e4_reg {
    unsigned long dwHQVDeinterlaceCtl;      /* Motion adaptive de-interlace control */
    unsigned long dwHQVFilterCtl;           /* HQV horizontal and vertical filter control*/
}REG3E4;

typedef struct _VIDEOHWINFO
{
    unsigned long dwVidCtl;
    unsigned long dwHQVCtl[2];              /*Index represents 0:IGA1 or 1:IGA2*/
    unsigned long dwHQVSPCtl_Pitch;         /* HQV Sub-picture control and stride */
    unsigned long dwHQVDeinterlaceCtl;      /* Motion adaptive de-interlace control */
    REG3E4 reg_3e4;
    unsigned long dwHQVTCGDCtl;             /* Tile,CSC,Gamma,Deblocking control */
    unsigned long dwVOffset;
    unsigned long dwHQVOffset;              /* if use HQV zoom in we use this value */
    unsigned long dwHQVSrcDataOffsetStart;
    unsigned long dwHQVSrcDataOffsetEnd;   
    unsigned long dwHQVDstDataOffsetStart;
    unsigned long dwHQVDstDataOffsetEnd;
    unsigned long dwHQVSrcAddr[3];          /* HQV engine source address0:Y,1:U,2:V */
    unsigned long dwHQVDstAddr[3];			/* HQV Dst Buffer for HQV0 */
    unsigned long dwVSrcAddr[3];            /* VIDEO engine source address */
    unsigned long dwV3SrcAddr[3];           /* VIDEO_3 engine source address */
    unsigned long dwHQVSrcCountWH;          /* HQV source data line count[H] */
                                            /* and fetch count[W] */
    unsigned long dwFetch;                  /* Video engine fetch count */   
    unsigned long dwHQVSrcPitch;            /* HQV engine source stride */
    unsigned long dwHQVDstPitch;            /* HQV engine destination stride */
    unsigned long dwSrcFetch;
    unsigned long dwVDisplayCount;          /* Video engine display count 0x26c,0x27c */
    unsigned long dwVPitch;                 /* Video engine stride */
    unsigned long dwWinStartXY;
    unsigned long dwWinEndXY;
    unsigned long dwCompose;
    unsigned long dwV1FIFO;
    unsigned long dwV3FIFO;
    unsigned long dwV3PreFIFO;
    unsigned long dwminiCtl;
    unsigned long dwzoomCtl;
    unsigned long dwHQVMiniZoomCtl;
    unsigned long dwLCDColorKey;
    unsigned long dwPriDispColorKey;          /*0x220*/
    unsigned long dwSndDispColorKey;          /*0x264*/
    unsigned long dwPriDispSndColorKey;       /*0x280*/
    unsigned long dwChromaKeyLow;
    unsigned long dwChromaKeyHigh;

    /*HQV scale control for VT3293*/
    unsigned long dwHQVScaleCtlH;            
    unsigned long dwHQVScaleCtlV; 
    
    unsigned long dwHQVBgOffset;              /*3409 HQV background offset*/
    unsigned long dwHQVCAC[8];                /*3409 advanced colorspace adjustment  control*/
    unsigned long dwSRFStride;                /*static record framebuffer stride,one colorspace coefficient included*/
    unsigned long dwHQVExtCtrl;               /*3409 hqv extend control*/
   
}VIDEOHWINFO,*LPVIDEOHWINFO;


/*
 *  Xv port specific struct, each port has it's own struct
 */
typedef struct {
    unsigned char  xv_adaptnum;
    unsigned char  xv_portnum;
    char *xv_portname;

    /* used for textured video */    
    Bool  textured;
    Bool  texV3DPath;
    Bool  compositeEnable; /* whether Desktop Composite effect enabled ? */
    DrawablePtr pDraw;
    PixmapPtr pPixmap;
    /* used for textured video */    

    viaVdpImageDataPtr vdp_image_data; /* used for vdpau */

    ViaXvRectRec src_rect;
    ViaXvRectRec drw_rect;
    long  brightness;
    long  saturation;
    long  contrast;
    long  hue;
    RegionRec clip;
    CARD32 colorKey;

    /* store old parameters for viaPutImageG() calling internally */
    short src_x;
    short src_y;
    short src_w;
    short src_h;
    short drw_x;
    short drw_y;
    short drw_w;
    short drw_h;
    short width;
    short height;
    unsigned char* buf;
    Bool sync;
    
    Bool vidOnTop;
    Bool autopaint_colorkey;    
    Bool xv_refine_using_pcie;    /* used for xv performance refine */
    Bool redirected;     /* redirected to texture video */
    Bool patchV3OnIga2;     /*V3 on IGA2, using texture instead of overlay*/
    Bool forceEngReAlloc;
    Bool skipDataCopy;  /* skip the operation of Xv data copy to Xv surface */

    unsigned long fourCC;
    unsigned long hqvEngFlag;
    unsigned long videoFlag;  
    unsigned long scrnAttr;
    unsigned long curIGA;
    unsigned long vidEngUpdate;
    unsigned long hqvEngUpdate;

    ViaMemRec  xvMem;
    ViaXvSurfacePtr  pXvSurface;
    unsigned long framenum;    
    VIDEOHWINFO  vidHWinfo;
    
    /*Index represents 0:IGA1 or 1:IGA2*/
    OVERLAYRECORD ovlInfo[2];       
    ViaMemRec  hqvMem[2];
    ViaXvSurfacePtr  pHqvSurface[2];
    unsigned long igaRRStatus[2];  /* repersent the rotate and reflect status */
    ViaMemRec  rotMem[2];
    ViaXvSurfacePtr  pRotSurface[2];

#ifdef VIA_DEFINE_OVERLAY_DISPLAY_PATH
    Bool updateOvlPath;
    viaOvlAttachedIgaRec attachedIga;
    BoxRec Box_XvSrc, Box_XvDst;
    BoxRec Box_Iga[2];
    BoxRec Box_OvlPath[MAX_OVL_PATH_NUM];
    viaOvlDisplayPathPtr ovlDisplayPath[MAX_OVL_PATH_NUM];
#endif
} viaPortPrivRec, *viaPortPrivPtr;

typedef struct{
    CARD32 interruptflag;         /* 200 */
    CARD32 ramtab;                /* 204 */
    CARD32 alphawin_hvstart;      /* 208 */
    CARD32 alphawin_size;         /* 20c */
    CARD32 alphawin_ctl;          /* 210 */
    CARD32 crt_startaddr;         /* 214 */
    CARD32 crt_startaddr_2;       /* 218 */
    CARD32 alphafb_stride ;       /* 21c */
    CARD32 color_key;             /* 220 */
    CARD32 alphafb_addr;          /* 224 */
    CARD32 chroma_low;            /* 228 */
    CARD32 chroma_up;             /* 22c */
    CARD32 video1_ctl;            /* 230 */
    CARD32 video1_fetch;          /* 234 */
    CARD32 video1y_addr1;         /* 238 */
    CARD32 video1_stride;         /* 23c */
    CARD32 video1_hvstart;        /* 240 */
    CARD32 video1_size;           /* 244 */
    CARD32 video1y_addr2;         /* 248 */
    CARD32 video1_zoom;           /* 24c */
    CARD32 video1_mictl;          /* 250 */
    CARD32 video1y_addr0;         /* 254 */
    CARD32 video1_fifo;           /* 258 */
    CARD32 video1y_addr3;         /* 25c */
    CARD32 hi_control;            /* 260 */
    CARD32 snd_color_key;         /* 264 */
    CARD32 v3alpha_prefifo;       /* 268 */
    CARD32 v1_source_w_h;         /* 26c */
    CARD32 hi_transparent_color;  /* 270 */
    CARD32 v_display_temp;        /* 274 :No use */
    CARD32 v3alpha_fifo;          /* 278 */
    CARD32 v3_source_width;       /* 27c */
    CARD32 dummy1;                /* 280 */
    CARD32 video1_CSC1;           /* 284 */
    CARD32 video1_CSC2;           /* 288 */
    CARD32 video1u_addr0;         /* 28c */
    CARD32 video1_opqctl;         /* 290 */
    CARD32 video3_opqctl;         /* 294 */
    CARD32 compose;               /* 298 */
    CARD32 dummy2;                /* 29c */
    CARD32 video3_ctl;            /* 2a0 */
    CARD32 video3_addr0;          /* 2a4 */
    CARD32 video3_addr1;          /* 2a8 */
    CARD32 video3_stride;         /* 2ac */
    CARD32 video3_hvstart;        /* 2b0 */
    CARD32 video3_size;           /* 2b4 */
    CARD32 v3alpha_fetch;         /* 2b8 */
    CARD32 video3_zoom;           /* 2bc */
    CARD32 video3_mictl;          /* 2c0 */
    CARD32 video3_CSC1;           /* 2c4 */
    CARD32 video3_CSC2;           /* 2c8 */
    CARD32 v3_display_temp;       /* 2cc */
    CARD32 reserved[5];           /* 2d0 */
    CARD32 video1u_addr1;         /* 2e4 */
    CARD32 video1u_addr2;         /* 2e8 */
    CARD32 video1u_addr3;         /* 2ec */
    CARD32 video1v_addr0;         /* 2f0 */
    CARD32 video1v_addr1;         /* 2f4 */
    CARD32 video1v_addr2;         /* 2f8 */
    CARD32 video1v_addr3;         /* 2fc */
}  video_via_regs;

typedef struct
{
    CARD32 subp_ctl;                /*3c0*/
    CARD32 subp_addr;               /*3c4*/
    CARD32 subp_palette;            /*3c8*/
    CARD32 src_data_offset;         /*3cc*/
    CARD32 hqv_ctl;                 /*3d0*/
    CARD32 src_y;                   /*3d4*/
    CARD32 src_u;                   /*3d8*/
    CARD32 misc_ctl;                /*3dc*/
    CARD32 src_linefetch;           /*3e0*/
    CARD32 mad_ctl;                 /*3e4*/
    CARD32 scal_ctl;                /*3e8*/
    CARD32 dst_addr0;               /*3ec*/
    CARD32 dst_addr1;               /*3f0*/
    CARD32 dst_stride;              /*3f4*/
    CARD32 src_stride_flip;         /*3f8*/
    CARD32 dst_addr2;               /*3fc*/
}hqv_via_regs;

/* dwCtlHQVflag, HQV control flag */
#define CTL_HQV_TILEMODE_ENABLE_CME             0x00000001
#define CTL_HQV_TILEMODE_512BITS_CME            0x00000002
#define CTL_HQV_TILEMODE_256BITS_CME            0x00000000
#define CTL_HQV_CSC_ENABLE_CME                  0x00000010
#define CTL_HQV_CSC_RGB32_CME                   0x00000040
#define CTL_HQV_CSC_RGB16_CME                   0x00000020

#define CTL_HQV_CSC_RGB101010_CME2              0x00000080
#define CTL_HQV_SCALING_UP_ENABLE_CME           0x00000100
#define CTL_HQV_DEINTERLACE_ENABLE_CME          0x00001000
#define CTL_HQV_3to2PULLDOWN_ENABLE_CME         0x00002000
#define CTL_HQV_CAPTURE_DEINTERLACE_ENABLE_CME  0x00010000

#define CTL_HQV_OUTPUT_V410_CME2                0x00100000
#define CTL_HQV_OUTPUT_TILE_CME2                0x00200000
#define CTL_HQV_USE_V3_CSC_CME2                 0x00400000
#define CTL_HQV_ALPHAWINDOW_ENABLE_CME          0x10000000
#define CTL_HQV_ALPHAWINDOW_STREAM_CME          0x00000000
#define CTL_HQV_ALPHAWINDOW_GRAPHIC_CME         0x20000000
/* for VT3264 FPGA test */
#define CTL_HQV_SINGLE_BUFFER_CME               0x01000000
#define CTL_HQV_DOUBLE_BUFFER_CME               0x02000000
/* S3Chromo-De-blocking setting */
#define CTL_HQV_TVFIELDSYNC_ENABLE              0x40000000
#define CTL_HQV_TV_ON_ADD_BUS                   0x80000000
/* For Deblocking  */
#define CTL_HQV_DEBLOCKING_ENABLE               0x08000000

/*
 * FOURCC definitions
 */
#define FOURCC_VIA      0x4E4B4C57  /*VIA*/
#define FOURCC_SUBP     0x50425553  /*SUBP*/
#define FOURCC_ALPHA    0x48504C41  /*ALPH*/
#define FOURCC_YUY2     0x32595559  /*YUY2*/
#define FOURCC_YV12     0x32315659  /*YV12*/
#define FOURCC_Y211     0x31313259
#define FOURCC_UYVY     0x59565955
#define FOURCC_YVYU     0x55595659
#define FOURCC_IYUV     0x56555949  
#define FOURCC_I420     0x30323449  /* I420 */
#define FOURCC_NV12     0x3231564E  /* uncompressed overlay surface */

/* for VT3264 */
#define FOURCC_V410     0x30313456   
#define FOURCC_V444     0x34343456

#define FOURCC_VDPAU  0x01020304    /* for vdpau specific */
/*
 * Below, a dummy picture type that is used in XvPutImage for vdpau
 */
#define XVIMAGE_VDPAU \
    {\
        FOURCC_VDPAU, \
        XvYUV, \
        LSBFirst, \
        {   'V', 'I', 'A', 0x00, \
            0x00, 0x00, 0x00, 0x10, 0x80, 0x00, 0x00, 0xAA, 0x00, \
            0x38, 0x9B, 0x71}, \
        12, \
        XvPlanar, \
        1, \
        0, 0, 0, 0, \
        8, 8, 8, \
        1, 2, 2, \
        1, 2, 2, \
        {   'Y', 'V', 'U', \
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, \
        XvTopToBottom \
    } 

/* define the fake FOURCC code for RGB format */
#define FOURCC_RGB555       0x0000000F
#define FOURCC_RGB565       0x00000010
#define FOURCC_XRGB0888     0x00000018
#define FOURCC_ARGB8888     0x00000020
#define RGB_BytePerPixel(format)     (((format + 15) & ~15)/8)

#define RGB15  FOURCC_RGB555
#define RGB16  FOURCC_RGB565
#define RGB24  FOURCC_XRGB0888
#define RGB32  FOURCC_ARGB8888

typedef struct _DDUPDATEOVERLAY
{
    ViaXvRectRec rDest;          /* dest rect */
    ViaXvRectRec rSrc;           /* src rect */
    unsigned long dwFlags;   /* flags */
} DDUPDATEOVERLAY;
typedef DDUPDATEOVERLAY * LPDDUPDATEOVERLAY;

/* Definition for dwFlags */
#define DDOVER_HIDE         0x00000001
#define DDOVER_SHOW         0x00000002
#define DDOVER_KEYDEST      0x00000004
#define DDOVER_ENABLE       0x00000008
#define DDOVER_CLIP         0x00000010
#define DDOVER_ON_SND       0x80000000 	/*Video is on Secondary Screen*/
#define DDOVER_ON_PRI       0x00000000 	/*Video is on Primary Screen*/
#define DDOVER_BOB          0x02000000	/* Use bob-deinterlace mode to show video */
#define DDOVER_INTERLEAVED  0x01000000  /*video is field-based fliped*/
#define DDOVER_ON_TOP       0x08000000  /*switch a video on top of another*/

unsigned long determineCurrentIGAInUse(ScrnInfoPtr pScrn, unsigned long *curIGA, int left, int top );
int viaPutImageG( ScrnInfoPtr,
        short, short, short, short, short, short, short, short,
        int, unsigned char*, short, short, Bool, RegionPtr, pointer, DrawablePtr );

#define BACKUP_PARAMETERS(_pPriv, _id, _src_x, _src_y, _drw_x, _drw_y, _src_w, _src_h, \
    _drw_w, _drw_h, _width, _height, _buf, _sync, _pDraw) \
do {                           \
    _pPriv->fourCC = _id;      \
    _pPriv->src_x = _src_x;    \
    _pPriv->src_y = _src_y;    \
    _pPriv->src_w = _src_w;    \
    _pPriv->src_h = _src_h;    \
    _pPriv->drw_x = _drw_x;    \
    _pPriv->drw_y = _drw_y;    \
    _pPriv->drw_w = _drw_w;    \
    _pPriv->drw_h = _drw_h;    \
    _pPriv->width = _width;    \
    _pPriv->height = _height;  \
    _pPriv->buf = _buf;        \
    _pPriv->sync = _sync;      \
    _pPriv->pDraw = _pDraw;    \
} while(0)

extern unsigned long viaCreateXvSurface(ScrnInfoPtr, viaPortPrivPtr, 
    unsigned long , unsigned long , unsigned long );
extern void viaDestroyXvSurface(ScrnInfoPtr, viaPortPrivPtr);
extern void viaUploadToXVSurface(ScrnInfoPtr , viaPortPrivPtr , 
    unsigned long , char * , ViaXvSurfacePtr , unsigned long , unsigned long );
extern int viaDisplayOverlayVideo(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, \
    unsigned long clipChanged, unsigned long forceRedraw, unsigned long forceUpdate);

extern int viaClipVideoToViewPort(ScrnInfoPtr pScrn, short *src_x, short *src_y, 
    short *src_w, short *src_h, short *drw_x, short *drw_y, short *drw_w, short *drw_h, 
    short width, short height, RegionPtr clipBoxes);
extern Bool viaCheckVideoTargetPixmap(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, \
    PixmapPtr pPixmap);
extern int viaDisplayTexturedVideo(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);

#ifdef VIA_DEFINE_OVERLAY_DISPLAY_PATH
extern unsigned long viaDetermineOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv, 
    short src_x, short src_y, short drw_x, short drw_y,
    short src_w, short src_h, short drw_w, short drw_h);
extern unsigned long viaCreateOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
extern unsigned long viaRebuildOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
extern unsigned long viaDisplayOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
extern unsigned long viaDestroyOvlDisplayPath(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
#endif

#endif  /* _VIA_VIDEO_H_ */
