/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 

/*************************************************************************
 *
 *  File:       via_xaa.c
 *  Content:    2D acceleration function for VIA/S3G UniChrome
 *
 ************************************************************************/

#include "miline.h"
#include "via_driver.h"
#include "via_regs.h"
#include "via_eng_regs.h"
#include "via_rotate.h" /* add by STChen, for rotate feature.*/
#include "agpctl.h"
#include "via_xaa.h"
#include "Xarch.h"
#include "xaalocal.h"
#include "xaarop.h"

#include "via_dmabuffer.h"
#include "via_regs.h"
#ifndef X_HAVE_XAAGETROP
 #define XAAGetPatternROP(rop) XAAPatternROP[rop]
 #define XAAGetCopyROP(rop)    XAACopyROP[rop]
#endif
void viaXaaSetupFuncTable(XAAInfoRecPtr   xaaptr,ScreenPtr pScreen);
#if 1
static void
VIASetClippingRectangle_H6(
    ScrnInfoPtr pScrn,
    int left,   /* X1 */
    int top,    /* Y1 */
    int right,  /* X2 */
    int bottom) /* Y2 */
{
    VIAPtr pVia = VIAPTR(pScrn);    
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    } 
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_CLIPTL_M1, ((top<< 16) |left));
        VIASETREG(VIA_REG_CLIPBR_M1, ((bottom<< 16)|right));
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(3);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_CLIPTL_M1, ((top << 16) | left));
        OUT_RING_QW(VIA_REG_CLIPBR_M1, ((bottom << 16) | right));    
    }
#endif
    tdc->cmd |= VIA_GEC_CLIP_ENABLE;
}


static void
VIASetupForScreenToScreenCopy_H6(
    ScrnInfoPtr pScrn,
    int xdir,
    int ydir,
    int rop,
    unsigned planemask,
    int trans_color)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }
    tdc->cmd = VIA_GEC_BLT | (XAAGetCopyROP(rop) << 24);
    if (pVia->IsHWRotateEnabled)
    {                
        ConvertDirection(pScrn, xdir, ydir, &(tdc->cmd));            
    }
    else        
    {
        if (xdir < 0)
            tdc->cmd |= VIA_GEC_DECX;

        if (ydir < 0)
            tdc->cmd |= VIA_GEC_DECY;    
    }    

    tdc->Savedtrans_color = trans_color;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
    	if (tdc->Savedtrans_color != -1){
            VIASETREG(VIA_REG_SRCCOLORKEY_M1, tdc->Savedtrans_color);
            VIASETREG(VIA_REG_KEYCONTROL_M1, 0x4000);
        }else{
            VIASETREG(VIA_REG_KEYCONTROL_M1, 0x0);
        }
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}


static void
VIASubsequentScreenToScreenCopy_H6(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int w,
    int h)
{    
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
	if (!w || !h)
        return;
    if (pVia->IsHWRotateEnabled)
    {                        
        ConvertSize(pScrn, &w, &h);
        ConvertCoordinatesTwo(pScrn, &x1, &y1, &x2, &y2, w, h);        
    }   

    if (tdc->cmd & VIA_GEC_DECX) {
        x1 += (w - 1);
        x2 += (w - 1);
    }

    if (tdc->cmd & VIA_GEC_DECY) {
        y1 += (h - 1);
        y2 += (h - 1);
    }
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif         
        VIASETREG(VIA_REG_SRCPOS_M1, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DSTPOS_M1, ((y2 << 16) | x2));
        VIASETREG(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
    /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
    	if (tdc->Savedtrans_color != -1)
        {
            BEGIN_HEADER0_2D_H5(10);
            OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
            OUT_RING_QW(VIA_REG_SRCCOLORKEY_M1, tdc->Savedtrans_color);
            OUT_RING_QW(VIA_REG_KEYCONTROL_M1, 0x4000);
        }
        else
        {
            BEGIN_HEADER0_2D_H5(9);
            OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
            OUT_RING_QW(VIA_REG_KEYCONTROL_M1, 0x0);        
        }

        /* Set Src and Dst base address and pitch, pitch is qword */
        /*=* Add fbOffset for IGA2 2D hardware acceleration
         *   function. If IGA1, fbOffset will be zero. *=*/    
        OUT_RING_QW(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_SRCPOS_M1, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_DSTPOS_M1, ((y2 << 16) | x2));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
    }
#endif
}

static void
VIASetupForSolidFill_H6(
    ScrnInfoPtr pScrn,
    int color,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }        

    tdc->cmd = VIA_GEC_BLT | VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    tdc->fgColor = color;    
#ifndef XAAChosePciPath   
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentSolidFillRect_H6(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
    if (pVia->IsHWRotateEnabled)
    {            
        ConvertSize(pScrn, &w, &h);
        ConvertCoordinatesOne(pScrn, &x, &y, w, h);        
    }
#ifndef XAAChosePciPath 
     if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(8);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
    }
#endif
}

static void
VIASetupForMono8x8PatternFill_H6(
    ScrnInfoPtr pScrn,
    int pattern0,
    int pattern1,
    int fg,
    int bg,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }    

    tdc->cmd = VIA_GEC_BLT | VIA_GEC_PAT_REG | VIA_GEC_PAT_MONO | (XAAGetPatternROP(rop) << 24);

    if (bg == -1) {
        /* transparent mono pattern */
        tdc->cmd |= VIA_GEC_MPAT_TRANS;
    }        

    /* Set BPP and Pitch */
    tdc->fgColor= fg;
    tdc->bgColor= bg;
    tdc->pattern0= pattern0;
    tdc->pattern1= pattern1;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();

        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        VIASETREG(VIA_REG_MONOPATBGC_M1, tdc->bgColor);
        VIASETREG(VIA_REG_MONOPAT0_M1, tdc->pattern0);
        VIASETREG(VIA_REG_MONOPAT1_M1, tdc->pattern1);
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentMono8x8PatternFillRect_H6(
    ScrnInfoPtr pScrn,
    int patOffx,
    int patOffy,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
	if (!w || !h)
        return;
    if (pVia->IsHWRotateEnabled)
    {        
        ConvertSize(pScrn, &w, &h);
        ConvertCoordinatesOne(pScrn, &x, &y, w, h);  
    }
    
    tdc->patternAddr = ((patOffy & 0x7)  << 29) | ((patOffx & 0x7) << 26);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_PATADDR_M1, tdc->patternAddr);
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(12);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_PATADDR_M1, tdc->patternAddr);
        OUT_RING_QW(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        OUT_RING_QW(VIA_REG_MONOPATBGC_M1, tdc->bgColor);
        OUT_RING_QW(VIA_REG_MONOPAT0_M1, tdc->pattern0);
        OUT_RING_QW(VIA_REG_MONOPAT1_M1, tdc->pattern1);
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
    }
#endif
}
/* xaa Color8x8 cache bug fixed in cvs tag xf4 3 99 14 */ 
static void
VIASetupForColor8x8PatternFill_H6(
    ScrnInfoPtr pScrn,
    int patternx,
    int patterny,
    int rop,
    unsigned planemask,
    int trans_color)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }

    tdc->cmd = VIA_GEC_BLT | (XAAGetPatternROP(rop) << 24);
    tdc->patternAddr= (patternx * pVia->Bpp + patterny * pVia->Bpl);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif 
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentColor8x8PatternFillRect_H6(
    ScrnInfoPtr pScrn,
    int patOffx,
    int patOffy,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    CARD32  dwPatAddr;
	if (!w || !h)
        return;
    if (pVia->IsHWRotateEnabled)
    {        
        ConvertSize(pScrn, &w, &h);
        ConvertCoordinatesOne(pScrn, &x, &y, w, h);  
    }
    dwPatAddr = (tdc->patternAddr>> 3) |
                ((patOffy & 0x7)  << 29) | ((patOffx & 0x7) << 26);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_PATADDR_M1, dwPatAddr);
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(8);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_PATADDR_M1, dwPatAddr);
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
    }
#endif
}

static void
VIASetupForSolidLine_H6(
    ScrnInfoPtr pScrn,
    int color,
    int rop,
    unsigned int planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }        

    /* we move VIA_GEC_LINE from here to the place firing command */
    tdc->cmd = VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    tdc->fgColor= color;    
#ifndef XAAChosePciPath   
    if(pVia->IsPCI){
#endif
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_MONOPAT0_M1, 0xFF);
        VIASETREG(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentSolidTwoPointLine_H6(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int flags)
{
    int     dx, dy, tmp, error = 1;
    VIAPtr  pVia = VIAPTR(pScrn);
    CARD32  cmd;
    ViaTwodContext *tdc = &pVia->td;
    if (pVia->IsHWRotateEnabled)
    {          
        ConvertCoordinatesTwo(pScrn, &x1, &y1, &x2, &y2, 0, 0);
    } 
    cmd = tdc->cmd | VIA_GEC_LINE;
    dx = x2 - x1;
    if (dx < 0) {
        dx = -dx;
        cmd |= VIA_GEC_DECX;            /* line will be drawn from right */
        error = 0;
    }

    dy = y2 - y1;
    if (dy < 0) {
        dy = -dy;
        cmd |= VIA_GEC_DECY;            /* line will be drawn from bottom */
    }

    if (dy > dx) {
        tmp  = dy;
        dy = dx;
        dx = tmp;                       /* Swap 'dx' and 'dy' */
        cmd |= VIA_GEC_Y_MAJOR;         /* Y major line */
    }

    if (flags & OMIT_LAST) {
        cmd |= VIA_GEC_LASTPIXEL_OFF;
    }
#ifndef XAAChosePciPath   
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_LINE_K1K2_M1, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        VIASETREG(VIA_REG_LINE_XY_M1, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DIMENSION_M1, dx);
        VIASETREG(VIA_REG_LINE_ERROR_M1, (((dy << 1) - dx - error) & 0x3fff));
        VIASETREG(VIA_REG_GECMD_M1, cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(11);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_MONOPAT0_M1, 0xFF);
        OUT_RING_QW(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        OUT_RING_QW(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_LINE_K1K2_M1, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        OUT_RING_QW(VIA_REG_LINE_XY_M1, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, dx);
        OUT_RING_QW(VIA_REG_LINE_ERROR_M1,(((dy << 1) - dx - error) & 0x3fff));
        OUT_RING_QW(VIA_REG_GECMD_M1, cmd);
    }
#endif
}
/* Subsequent XAA solid horizontal and vertical lines */
static void
VIASubsequentSolidHorVertLine_H6(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int len,
    int dir)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    int LineDegree = dir;
    if (pVia->IsHWRotateEnabled)
    {           
        ConvertCoordinatesOne(pScrn, &x, &y, 0, 0);
        switch (pVia->RotateDegree)
        {
            case VIA_ROTATE_DEGREE_90:
                if (LineDegree == DEGREES_0) {
                    LineDegree = DEGREES_270;
                }
                else if (LineDegree == DEGREES_270) {
                    LineDegree = DEGREES_0;
                    x -= len;
                }
                break;
            case VIA_ROTATE_DEGREE_180:
                if (LineDegree == DEGREES_0) {                    
                    x -= len;
                }
                else if (LineDegree == DEGREES_270) {                    
                    y -= len;
                }                
                break;
            case VIA_ROTATE_DEGREE_270:
                if (LineDegree == DEGREES_0) {
                    LineDegree = DEGREES_270;
                    y -= len;
                }
                else if (LineDegree == DEGREES_270) {
                    LineDegree = DEGREES_0;
                }
                break;
        }
    }
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif 
        VIASETREG(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        if (LineDegree == DEGREES_0)
            VIASETREG(VIA_REG_DIMENSION_M1, (len - 1));
        else
            VIASETREG(VIA_REG_DIMENSION_M1, ((len - 1) << 16));
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd| VIA_GEC_BLT);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(9);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_MONOPAT0_M1, 0xFF);
        OUT_RING_QW(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        /* Set Src and Dst base address and pitch, pitch is qword */
        /*=* Add fbOffset for IGA2 2D hardware acceleration
         *   function. If IGA1, fbOffset will be zero. *=*/  
        OUT_RING_QW(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_DSTPOS_M1, ((y << 16) | x));
        if (LineDegree == DEGREES_0)
            OUT_RING_QW(VIA_REG_DIMENSION_M1, (len - 1));
        else
            OUT_RING_QW(VIA_REG_DIMENSION_M1, ((len - 1) << 16));
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd| VIA_GEC_BLT);
    }
#endif
}
static void
VIASetupForDashedLine_H6(
    ScrnInfoPtr pScrn,
    int fg,
    int bg,
    int rop,
    unsigned int planemask,
    int length,
    unsigned char *pattern)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    CARD32  pat = *(CARD32 *)pattern;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode |= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }

    tdc->cmd = VIA_GEC_LINE | VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    if (bg == -1) {
        /* transparent mono pattern */
        tdc->cmd  |= VIA_GEC_MPAT_TRANS;
    }
    tdc->fgColor= fg;
    tdc->bgColor= bg;
    switch (length)
    {
        case  2: pat |= pat <<  2; /* fall through */
        case  4: pat |= pat <<  4; /* fall through */
        case  8: pat |= pat <<  8; /* fall through */
        case 16: pat |= pat << 16;
    }

    tdc->pattern0= pat;
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        VIASETREG(VIA_REG_MONOPATBGC_M1, tdc->bgColor);
        VIASETREG(VIA_REG_MONOPAT0_M1, tdc->pattern0);
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}


static void
VIASubsequentDashedTwoPointLine_H6(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int flags,
    int phase)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    int     dx, dy, tmp, error = 1;
    if (pVia->IsHWRotateEnabled)
    {                
        ConvertCoordinatesTwo(pScrn, &x1, &y1, &x2, &y2, 0, 0);
    } 
    dx = x2 - x1;
    if (dx < 0) {
        dx = -dx;
        tdc->cmd |= VIA_GEC_DECX;            /* line will be drawn from right */
        error = 0;
    }
    dy = y2 - y1;
    if (dy < 0) {
        dy = -dy;
        tdc->cmd |= VIA_GEC_DECY;            /* line will be drawn from bottom */
    }
    if (dy > dx) {
        tmp  = dy;
        dy = dx;
        dx = tmp;                       /* Swap 'dx' and 'dy' */
        tdc->cmd |= VIA_GEC_Y_MAJOR;         /* Y major line */
    }
    if (flags & OMIT_LAST) 
        tdc->cmd |= VIA_GEC_LASTPIXEL_OFF;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif 
        VIASETREG(VIA_REG_LINE_K1K2_M1, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        VIASETREG(VIA_REG_LINE_XY_M1, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DIMENSION_M1, dx);
        VIASETREG(VIA_REG_LINE_ERROR_M1,(((dy << 1) - dx - error) & 0x3fff));
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(12);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_MONOPATFGC_M1, tdc->fgColor);
        OUT_RING_QW(VIA_REG_MONOPATBGC_M1, tdc->bgColor);
        OUT_RING_QW(VIA_REG_MONOPAT0_M1, tdc->pattern0);
        /* Set Src and Dst base address and pitch, pitch is qword */
        /*=* Add fbOffset for IGA2 2D hardware acceleration
         *   function. If IGA1, fbOffset will be zero. *=*/  
        OUT_RING_QW(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1,   ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_LINE_K1K2_M1, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        OUT_RING_QW(VIA_REG_LINE_XY_M1, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, dx);
        OUT_RING_QW(VIA_REG_LINE_ERROR_M1,(((dy << 1) - dx - error) & 0x3fff));
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
        /* Set BPP and Pitch */
    }
#endif
}

static void
VIASetupForCPUToScreenColorExpandFill_H6(
    ScrnInfoPtr pScrn,
    int fg,
    int bg,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode|= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }

    tdc->cmd= VIA_GEC_BLT | VIA_GEC_SRC_SYS | VIA_GEC_SRC_MONO |
          VIA_GEC_MONO_PACK | VIA_GEC_MONO_BYTE |
    	  (XAAGetCopyROP(rop) << 24);

    if (bg == -1) {
        tdc->cmd|= VIA_GEC_MSRC_TRANS;
    }  
    tdc->fgColor= fg;
    tdc->bgColor= bg;
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        VIASETREG(VIA_REG_KEYCONTROL_M1, 0x0);
        VIASETREG(VIA_REG_SRCBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_SRCPOS_M1, 0);
        VIASETREG(VIA_REG_FGCOLOR_M1, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR_M1, tdc->bgColor);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentCPUToScreenColorExpandFill_H6(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h,
    int skipleft)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    unsigned int size;
    XAAInfoRecPtr xaaptr = GET_XAAINFORECPTR_FROM_SCRNINFOPTR(pScrn);
    if (skipleft) {
        VIASetClippingRectangle_H6(pScrn, (x + skipleft), y, (x + w - 1), (y + h -1));        
    }     
    if (pVia->IsHWRotateEnabled)
    {            
        ConvertSize(pScrn, &w, &h);
        ConvertCoordinatesOne(pScrn, &x, &y, w, h);          
    }
    size = ((w + 31) >> 5) * h;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS_M1,((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
        xaaptr->ColorExpandBase = pVia->BltBase;
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;        
        //VIADownClippingRectangle_M1(pScrn);
        BEGIN_HEADER0_2D_H5(11);
        OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
        OUT_RING_QW(VIA_REG_KEYCONTROL_M1, 0x0);
        OUT_RING_QW(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_SRCPOS_M1, 0);
        OUT_RING_QW(VIA_REG_DSTPOS_M1,((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_FGCOLOR_M1, tdc->fgColor);
        OUT_RING_QW(VIA_REG_BGCOLOR_M1, tdc->bgColor);
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
        BEGIN_HEADER_2D_BLT_H5(size,xaaptr->ColorExpandBase);
        (cb)->needFire=TRUE;
    }
#endif
}
static void
VIASetupForImageWrite_H6(
    ScrnInfoPtr pScrn,
    int rop,
    unsigned planemask,
    int trans_color,
    int bpp,
    int depth)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (bpp)
    {
        case 16:
            tdc->mode|= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }
    tdc->cmd = VIA_GEC_BLT | VIA_GEC_SRC_SYS | (XAAGetCopyROP(rop) << 24);
    /* Set BPP and Pitch */
    tdc->Bpp= bpp >> 3;
    tdc->Savedtrans_color= trans_color;
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE_M1, tdc->mode);
        if (tdc->Savedtrans_color != -1)
        {
            VIASETREG(VIA_REG_SRCCOLORKEY_M1, tdc->Savedtrans_color);
            VIASETREG(VIA_REG_KEYCONTROL_M1, 0x4000);
        }
        else
        {
            VIASETREG(VIA_REG_KEYCONTROL_M1, 0x0);
        }
        VIASETREG(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_SRCPOS_M1, 0);
#ifndef XAAChosePciPath 
    }
#endif
}


static void
VIASubsequentImageWriteRect_H6(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h,
    int skipleft)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    unsigned int size;
    XAAInfoRecPtr xaaptr = GET_XAAINFORECPTR_FROM_SCRNINFOPTR(pScrn);
    if (skipleft) {
        VIASetClippingRectangle_H6(pScrn, (x + skipleft), y, (x + w - 1), (y + h -1));
    }
    if (pVia->IsHWRotateEnabled)
    {        
        ConvertSize(pScrn, &w, &h);
        ConvertCoordinatesOne(pScrn, &x, &y, w, h);  
    }
    size = (((w * tdc->Bpp) + 3) >> 2) * h;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS_M1,((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD_M1, tdc->cmd);
        xaaptr->ImageWriteBase = pVia->BltBase;
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        if (tdc->Savedtrans_color != -1)
        {
            BEGIN_HEADER0_2D_H5(10);
            OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
            OUT_RING_QW(VIA_REG_SRCCOLORKEY_M1, tdc->Savedtrans_color);
            OUT_RING_QW(VIA_REG_KEYCONTROL_M1, 0x4000);
        }
        else
        {
            BEGIN_HEADER0_2D_H5(9);
            OUT_RING_QW(VIA_REG_GEMODE_M1, tdc->mode);
            OUT_RING_QW(VIA_REG_KEYCONTROL_M1, 0x0);
        }
        OUT_RING_QW(VIA_REG_SRCBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE_M1,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH_M1, ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_SRCPOS_M1, 0);
        OUT_RING_QW(VIA_REG_DSTPOS_M1,((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION_M1, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_GECMD_M1, tdc->cmd);
        BEGIN_HEADER_2D_BLT_H5(size,xaaptr->ImageWriteBase);
        (cb)->needFire=TRUE;
    }
#endif
}
#endif
#if 1
static void
VIASetClippingRectangle_H5(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode|= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }        
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_CLIPTL, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_CLIPBR, ((y2 << 16) | x2));
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(3);
        OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW(VIA_REG_CLIPTL, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_CLIPBR, ((y2 << 16) | x2));
    }
#endif
    tdc->cmd |= VIA_GEC_CLIP_ENABLE;

}
/* These are the ScreenToScreen bitblt functions. We support all ROPs, all
 * directions.
 *
 */
static void
VIASetupForScreenToScreenCopy_H5(
    ScrnInfoPtr pScrn,
    int xdir,
    int ydir,
    int rop,
    unsigned planemask,
    int trans_color)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd = VIA_GEC_BLT | (XAAGetCopyROP(rop) << 24);

    if (xdir < 0)
        tdc->cmd  |= VIA_GEC_DECX;

    if (ydir < 0)
        tdc->cmd  |= VIA_GEC_DECY;    
	tdc->Savedtrans_color= trans_color;
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
#ifndef XAAChosePciPath     
    if(pVia->IsPCI) {
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
    	if (tdc->Savedtrans_color != -1){
            VIASETREG(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);
            VIASETREG(VIA_REG_KEYCONTROL, 0x4000);
        }else{
            VIASETREG(VIA_REG_KEYCONTROL, 0x0);
        }
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentScreenToScreenCopy_H5(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
    if (tdc->cmd & VIA_GEC_DECX) {
        x1 += (w - 1);
        x2 += (w - 1);
    }

    if (tdc->cmd & VIA_GEC_DECY) {
        y1 += (h - 1);
        y2 += (h - 1);
    }
#ifndef XAAChosePciPath     
    if(pVia->IsPCI) {
#endif  
        VIASETREG(VIA_REG_SRCPOS, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DSTPOS, ((y2 << 16) | x2));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
    /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
    	if (tdc->Savedtrans_color!= -1)
        {
            BEGIN_HEADER0_2D_H5(10);
    		OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
    		OUT_RING_QW(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);        
    		OUT_RING_QW(VIA_REG_KEYCONTROL, 0x4000);     
        }
        else
        {
            BEGIN_HEADER0_2D_H5(9);
    		OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
    		OUT_RING_QW(VIA_REG_KEYCONTROL, 0x0);
        }
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_SRCPOS, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_DSTPOS, ((y2 << 16) | x2));
        OUT_RING_QW(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
/*
 * SetupForSolidFill is also called to set up for lines.
 */
static void
VIASetupForSolidFill_H5(
    ScrnInfoPtr pScrn,
    int color,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode|= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }        
    tdc->cmd = VIA_GEC_BLT | VIA_GEC_FIXCOLOR_PAT | 
          (XAAGetPatternROP(rop) << 24);
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->fgColor = color;    
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentSolidFillRect_H5(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | (x & 0xFFFF)));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(8);
    	OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        OUT_RING_QW(VIA_REG_DSTPOS, ((y << 16) | (x & 0xFFFF)));
        OUT_RING_QW(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_FGCOLOR, tdc->fgColor);
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
/*
 * The meaning of the two pattern paremeters to Setup & Subsequent for
 * Mono8x8Patterns varies depending on the flag bits.  We specify
 * HW_PROGRAMMED_BITS, which means our hardware can handle 8x8 patterns
 * without caching in the frame buffer.  Thus, Setup gets the pattern bits.
 * There is no way with BCI to rotate an 8x8 pattern, so we do NOT specify
 * HW_PROGRAMMED_ORIGIN.  XAA wil rotate it for us and pass the rotated
 * pattern to both Setup and Subsequent.  If we DID specify PROGRAMMED_ORIGIN,
 * then Setup would get the unrotated pattern, and Subsequent gets the
 * origin values.
 */

static void
VIASetupForMono8x8PatternFill_H5(
    ScrnInfoPtr pScrn,
    int pattern0,
    int pattern1,
    int fg,
    int bg,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }    
    tdc->cmd= VIA_GEC_BLT | VIA_GEC_PAT_REG | VIA_GEC_PAT_MONO |
          (XAAGetPatternROP(rop) << 24);
    if (bg == -1) {
        /* transparent mono pattern */
        tdc->cmd|= VIA_GEC_MPAT_TRANS;
    }
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->fgColor= fg;
    tdc->bgColor= bg;
    tdc->pattern0= pattern0;
    tdc->pattern1= pattern1;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR, tdc->bgColor);
        VIASETREG(VIA_REG_MONOPAT0, tdc->pattern0);
        VIASETREG(VIA_REG_MONOPAT1, tdc->pattern1);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentMono8x8PatternFillRect_H5(
    ScrnInfoPtr pScrn,
    int patOffx,
    int patOffy,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
    tdc->patternAddr = ((patOffy & 0x7)  << 29) | ((patOffx & 0x7) << 26);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_PATADDR, tdc->patternAddr);
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(12);
        OUT_RING_QW( VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW( VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        OUT_RING_QW( VIA_REG_DSTBASE, 0x0 + (pScrn->fbOffset >> 3));
        OUT_RING_QW( VIA_REG_PITCH, VIA_PITCH_ENABLE |
              ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        OUT_RING_QW( VIA_REG_DSTPOS, ((y << 16) | x));
        OUT_RING_QW( VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW( VIA_REG_PATADDR, tdc->patternAddr);
        OUT_RING_QW( VIA_REG_FGCOLOR, tdc->fgColor);
        OUT_RING_QW( VIA_REG_BGCOLOR, tdc->bgColor);
        OUT_RING_QW( VIA_REG_MONOPAT0, tdc->pattern0);
        OUT_RING_QW( VIA_REG_MONOPAT1, tdc->pattern1);
        OUT_RING_QW( VIA_REG_GECMD, tdc->cmd);
     }
#endif
}
/* xaa Color8x8 cache bug fixed in cvs tag xf4 3 99 14 */ 
static void
VIASetupForColor8x8PatternFill_H5(
    ScrnInfoPtr pScrn,
    int patternx,
    int patterny,
    int rop,
    unsigned planemask,
    int trans_color)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd= VIA_GEC_BLT | (XAAGetPatternROP(rop) << 24);
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->patternAddr= (patternx * pVia->Bpp + patterny * pVia->Bpl);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentColor8x8PatternFillRect_H5(
    ScrnInfoPtr pScrn,
    int patOffx,
    int patOffy,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    CARD32  dwPatAddr;
	
    if (!w || !h)
        return;
    dwPatAddr = (tdc->patternAddr >> 3) |
                ((patOffy & 0x7)  << 29) | ((patOffx & 0x7) << 26);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_PATADDR, dwPatAddr);
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(8);
        OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_DSTPOS, ((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_PATADDR, dwPatAddr);
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
static void
VIASetupForCPUToScreenColorExpandFill_H5(
    ScrnInfoPtr pScrn,
    int fg,
    int bg,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
	switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }

    tdc->cmd= VIA_GEC_BLT | VIA_GEC_SRC_SYS | VIA_GEC_SRC_MONO |
          VIA_GEC_MONO_PACK | VIA_GEC_MONO_BYTE |
          (XAAGetCopyROP(rop) << 24);
    if (bg == -1) {
        tdc->cmd |= VIA_GEC_MSRC_TRANS;
    }
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->fgColor= fg;
    tdc->bgColor= bg;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_KEYCONTROL, 0x0);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_SRCPOS, 0);
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR, tdc->bgColor);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentCPUToScreenColorExpandFill_H5(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h,
    int skipleft)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    XAAInfoRecPtr xaaptr = GET_XAAINFORECPTR_FROM_SCRNINFOPTR(pScrn);
    unsigned int size;
    if (skipleft) {
        VIASetClippingRectangle_H5(pScrn, (x + skipleft), y, (x + w - 1), (y + h -1));
    }
    size = ((w + 31) >> 5) * h;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS,((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
        xaaptr->ColorExpandBase = pVia->BltBase;
#ifndef XAAChosePciPath 
    }else{   
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(11);
        OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW(VIA_REG_KEYCONTROL, 0x0);
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        OUT_RING_QW(VIA_REG_SRCPOS, 0);
        OUT_RING_QW(VIA_REG_DSTPOS, ((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_FGCOLOR, tdc->fgColor);
        OUT_RING_QW(VIA_REG_BGCOLOR, tdc->bgColor);
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd);
        BEGIN_HEADER_2D_BLT_H5(size,xaaptr->ColorExpandBase);
        (cb)->needFire=TRUE;
    }
#endif
}
static void
VIASetupForImageWrite_H5(
    ScrnInfoPtr pScrn,
    int rop,
    unsigned planemask,
    int trans_color,
    int bpp,
    int depth)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (bpp)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd= VIA_GEC_BLT | VIA_GEC_SRC_SYS | (XAAGetCopyROP(rop) << 24);
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->Bpp= bpp >> 3;
    tdc->Savedtrans_color= trans_color;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        if (tdc->Savedtrans_color != -1)
        {
            VIASETREG(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);
            VIASETREG(VIA_REG_KEYCONTROL, 0x4000);
        }
        else
        {
            VIASETREG(VIA_REG_KEYCONTROL, 0x0);
        }
        VIASETREG(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_SRCPOS, 0);
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentImageWriteRect_H5(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h,
    int skipleft)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    unsigned int size;
    XAAInfoRecPtr xaaptr = GET_XAAINFORECPTR_FROM_SCRNINFOPTR(pScrn);

    if (skipleft) {
        VIASetClippingRectangle_H5(pScrn, (x + skipleft), y, (x + w - 1), (y + h -1));
    }
    size = (((w * tdc->Bpp) + 3) >> 2) * h;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS,((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
        xaaptr->ImageWriteBase = pVia->BltBase;
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        if (tdc->Savedtrans_color != -1) 
        {
            BEGIN_HEADER0_2D_H5(10);
            OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        	OUT_RING_QW(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);
            OUT_RING_QW(VIA_REG_KEYCONTROL, 0x4000);
        }
        else
        {
            BEGIN_HEADER0_2D_H5(9);
            OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        	OUT_RING_QW(VIA_REG_KEYCONTROL, 0x0);

        }
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                      ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                      (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        OUT_RING_QW(VIA_REG_SRCPOS, 0);
        OUT_RING_QW(VIA_REG_DSTPOS, ((y << 16) | x));
        OUT_RING_QW(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd);
        BEGIN_HEADER_2D_BLT_H5(size,xaaptr->ImageWriteBase);
        (cb)->needFire=TRUE;
    }
#endif
}
/* Setup for XAA solid lines. */
static void
VIASetupForSolidLine_H5(
    ScrnInfoPtr pScrn,
    int color,
    int rop,
    unsigned int planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }        
    /* we move VIA_GEC_LINE from here to the place firing command */
    tdc->cmd = VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    tdc->fgColor= color;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_MONOPAT0, 0xFF);
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentSolidTwoPointLine_H5(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int flags)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    CARD32  cmd;
    ViaTwodContext *tdc = &pVia->td;
    int     dx, dy, tmp, error = 1;  
    cmd = tdc->cmd | VIA_GEC_LINE;
    dx = x2 - x1;
    if (dx < 0) {
        dx = -dx;
        cmd |= VIA_GEC_DECX;            /* line will be drawn from right */
        error = 0;
    }
    dy = y2 - y1;
    if (dy < 0) {
        dy = -dy;
        cmd |= VIA_GEC_DECY;            /* line will be drawn from bottom */
    }
    if (dy > dx) {
        tmp  = dy;
        dy = dx;
        dx = tmp;                           /* Swap 'dx' and 'dy' */
        cmd |= VIA_GEC_Y_MAJOR;         /* Y major line */
    }
    if (flags & OMIT_LAST) {
        cmd |= VIA_GEC_LASTPIXEL_OFF;
    }
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        VIASETREG(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DIMENSION, dx);
        VIASETREG(VIA_REG_LINE_ERROR, (((dy << 1) - dx - error) & 0x3fff));
        VIASETREG(VIA_REG_GECMD, cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(11);
        OUT_RING_QW(VIA_REG_GEMODE,  tdc->mode);
        OUT_RING_QW(VIA_REG_MONOPAT0, 0xFF);
        OUT_RING_QW(VIA_REG_FGCOLOR, tdc->fgColor);
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        OUT_RING_QW(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_DIMENSION, dx);
        OUT_RING_QW(VIA_REG_LINE_ERROR, (((dy << 1) - dx - error) & 0x3fff));
        OUT_RING_QW(VIA_REG_GECMD, cmd);
    }
#endif
}

/* Subsequent XAA solid horizontal and vertical lines */
static void
VIASubsequentSolidHorVertLine_H5(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int len,
    int dir)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | x));
        if (dir == DEGREES_0)
            VIASETREG(VIA_REG_DIMENSION, (len - 1));
        else
            VIASETREG(VIA_REG_DIMENSION, ((len - 1) << 16));
        VIASETREG(VIA_REG_GECMD, tdc->cmd| VIA_GEC_BLT);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(9);
        OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW(VIA_REG_MONOPAT0, 0xFF);
        OUT_RING_QW(VIA_REG_FGCOLOR, tdc->fgColor);
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_DSTPOS, ((y << 16) | x));
        if (dir == DEGREES_0) 
            OUT_RING_QW(VIA_REG_DIMENSION, (len - 1));
        else 
            OUT_RING_QW(VIA_REG_DIMENSION, ((len - 1) << 16));
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd| VIA_GEC_BLT);
    }
#endif
}
static void
VIASetupForDashedLine_H5(
    ScrnInfoPtr pScrn,
    int fg,
    int bg,
    int rop,
    unsigned int planemask,
    int length,
    unsigned char *pattern)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    CARD32  pat = *(CARD32 *)pattern;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd= VIA_GEC_LINE | VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    if (bg == -1) {
        tdc->cmd|= VIA_GEC_MPAT_TRANS;
    }
    tdc->fgColor= fg;
    tdc->bgColor= bg;
    switch (length) {
        case  2: pat |= pat <<  2; /* fall through */
        case  4: pat |= pat <<  4; /* fall through */
        case  8: pat |= pat <<  8; /* fall through */
        case 16: pat |= pat << 16;
    }
    tdc->pattern0 = pat;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR, tdc->bgColor);
        VIASETREG(VIA_REG_MONOPAT0, tdc->pattern0);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH,VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentDashedTwoPointLine_H5(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int flags,
    int phase)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    int     dx, dy, tmp, error = 1;  
    dx = x2 - x1;
    if (dx < 0) {
        dx = -dx;
        tdc->cmd |= VIA_GEC_DECX;            /* line will be drawn from right */
        error = 0;
    }
    dy = y2 - y1;
    if (dy < 0) {
        dy = -dy;
        tdc->cmd |= VIA_GEC_DECY;            /* line will be drawn from bottom */
    }
    if (dy > dx) {
        tmp  = dy;
        dy = dx;
        dx = tmp;                       /* Swap 'dx' and 'dy' */
        tdc->cmd |= VIA_GEC_Y_MAJOR;         /* Y major line */
    }
    if (flags & OMIT_LAST) {
        tdc->cmd |= VIA_GEC_LASTPIXEL_OFF;
    }
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        VIASETREG(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DIMENSION, dx);
        VIASETREG(VIA_REG_LINE_ERROR,(((dy << 1) - dx - error) & 0x3fff));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_HEADER0_2D_H5(12);
        OUT_RING_QW(VIA_REG_GEMODE, tdc->mode);
        OUT_RING_QW(VIA_REG_FGCOLOR, tdc->fgColor);
        OUT_RING_QW(VIA_REG_BGCOLOR, tdc->bgColor);
        OUT_RING_QW(VIA_REG_MONOPAT0, tdc->pattern0);
        OUT_RING_QW(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        OUT_RING_QW(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        OUT_RING_QW(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        OUT_RING_QW(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        OUT_RING_QW(VIA_REG_DIMENSION, dx);
        OUT_RING_QW(VIA_REG_LINE_ERROR, (((dy << 1) - dx - error) & 0x3fff) | 0xFF0000);
        OUT_RING_QW(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
#endif 

#if 1
static void
VIASetClippingRectangle(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode|= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }        
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_CLIPTL, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_CLIPBR, ((y2 << 16) | x2));
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(6);/*3x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_CLIPTL, ((y1 << 16) | x1));
        BEGIN_HEAD1_2D(VIA_REG_CLIPBR, ((y2 << 16) | x2));
    }
#endif
    tdc->cmd |= VIA_GEC_CLIP_ENABLE;
}
/* These are the ScreenToScreen bitblt functions. We support all ROPs, all
 * directions.
 *
 */
static void
VIASetupForScreenToScreenCopy(
    ScrnInfoPtr pScrn,
    int xdir,
    int ydir,
    int rop,
    unsigned planemask,
    int trans_color)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd = VIA_GEC_BLT | (XAAGetCopyROP(rop) << 24);

    if (xdir < 0)
        tdc->cmd  |= VIA_GEC_DECX;

    if (ydir < 0)
        tdc->cmd  |= VIA_GEC_DECY;    
	tdc->Savedtrans_color= trans_color;
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
#ifndef XAAChosePciPath     
    if(pVia->IsPCI) {
#endif
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
    	if (tdc->Savedtrans_color != -1){
            VIASETREG(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);
            VIASETREG(VIA_REG_KEYCONTROL, 0x4000);
        }else{
            VIASETREG(VIA_REG_KEYCONTROL, 0x0);
        }
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentScreenToScreenCopy(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
    if (tdc->cmd & VIA_GEC_DECX) {
        x1 += (w - 1);
        x2 += (w - 1);
    }

    if (tdc->cmd & VIA_GEC_DECY) {
        y1 += (h - 1);
        y2 += (h - 1);
    }
#ifndef XAAChosePciPath     
    if(pVia->IsPCI) {
#endif  
        VIASETREG(VIA_REG_SRCPOS, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DSTPOS, ((y2 << 16) | x2));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
    /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
    	if (tdc->Savedtrans_color!= -1)
        {
            BEGIN_RING(20);/*10x2 :For H2 2D(head1),32 add + 32 data */
    		BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
    		BEGIN_HEAD1_2D(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);        
    		BEGIN_HEAD1_2D(VIA_REG_KEYCONTROL, 0x4000);     
        }
        else
        {
            BEGIN_RING(18);/*9x2 :For H2 2D(head1),32 add + 32 data */
    		BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
    		BEGIN_HEAD1_2D(VIA_REG_KEYCONTROL, 0x0);
        }
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        BEGIN_HEAD1_2D(VIA_REG_SRCPOS, ((y1 << 16) | x1));
        BEGIN_HEAD1_2D(VIA_REG_DSTPOS, ((y2 << 16) | x2));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
/*
 * SetupForSolidFill is also called to set up for lines.
 */
static void
VIASetupForSolidFill(
    ScrnInfoPtr pScrn,
    int color,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
        case 16:
            tdc->mode|= VIA_GEM_16bpp;
            break;
        case 32:
            tdc->mode |= VIA_GEM_32bpp;
            break;
        default:
            tdc->mode |= VIA_GEM_8bpp;
            break;
    }        
    tdc->cmd = VIA_GEC_BLT | VIA_GEC_FIXCOLOR_PAT | 
          (XAAGetPatternROP(rop) << 24);
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->fgColor = color;    
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentSolidFillRect(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | (x & 0xFFFF)));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(16);/*8x2 :For H2 2D(head1),32 add + 32 data */
    	BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        BEGIN_HEAD1_2D(VIA_REG_DSTPOS, ((y << 16) | (x & 0xFFFF)));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        BEGIN_HEAD1_2D(VIA_REG_FGCOLOR, tdc->fgColor);
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
/*
 * The meaning of the two pattern paremeters to Setup & Subsequent for
 * Mono8x8Patterns varies depending on the flag bits.  We specify
 * HW_PROGRAMMED_BITS, which means our hardware can handle 8x8 patterns
 * without caching in the frame buffer.  Thus, Setup gets the pattern bits.
 * There is no way with BCI to rotate an 8x8 pattern, so we do NOT specify
 * HW_PROGRAMMED_ORIGIN.  XAA wil rotate it for us and pass the rotated
 * pattern to both Setup and Subsequent.  If we DID specify PROGRAMMED_ORIGIN,
 * then Setup would get the unrotated pattern, and Subsequent gets the
 * origin values.
 */

static void
VIASetupForMono8x8PatternFill(
    ScrnInfoPtr pScrn,
    int pattern0,
    int pattern1,
    int fg,
    int bg,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }    
    tdc->cmd= VIA_GEC_BLT | VIA_GEC_PAT_REG | VIA_GEC_PAT_MONO |
          (XAAGetPatternROP(rop) << 24);
    if (bg == -1) {
        /* transparent mono pattern */
        tdc->cmd|= VIA_GEC_MPAT_TRANS;
    }
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->fgColor= fg;
    tdc->bgColor= bg;
    tdc->pattern0= pattern0;
    tdc->pattern1= pattern1;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR, tdc->bgColor);
        VIASETREG(VIA_REG_MONOPAT0, tdc->pattern0);
        VIASETREG(VIA_REG_MONOPAT1, tdc->pattern1);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentMono8x8PatternFillRect(
    ScrnInfoPtr pScrn,
    int patOffx,
    int patOffy,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    if (!w || !h)
        return;
    tdc->patternAddr = ((patOffy & 0x7)  << 29) | ((patOffx & 0x7) << 26);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif 
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_PATADDR, tdc->patternAddr);
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(24);/*12x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D( VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D( VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D( VIA_REG_DSTBASE, 0x0 + (pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D( VIA_REG_PITCH, VIA_PITCH_ENABLE |
              ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
              (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        BEGIN_HEAD1_2D( VIA_REG_DSTPOS, ((y << 16) | x));
        BEGIN_HEAD1_2D( VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        BEGIN_HEAD1_2D( VIA_REG_PATADDR, tdc->patternAddr);
        BEGIN_HEAD1_2D( VIA_REG_FGCOLOR, tdc->fgColor);
        BEGIN_HEAD1_2D( VIA_REG_BGCOLOR, tdc->bgColor);
        BEGIN_HEAD1_2D( VIA_REG_MONOPAT0, tdc->pattern0);
        BEGIN_HEAD1_2D( VIA_REG_MONOPAT1, tdc->pattern1);
        BEGIN_HEAD1_2D( VIA_REG_GECMD, tdc->cmd);
     }
#endif
}
/* xaa Color8x8 cache bug fixed in cvs tag xf4 3 99 14 */ 
static void
VIASetupForColor8x8PatternFill(
    ScrnInfoPtr pScrn,
    int patternx,
    int patterny,
    int rop,
    unsigned planemask,
    int trans_color)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd= VIA_GEC_BLT | (XAAGetPatternROP(rop) << 24);
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->patternAddr= (patternx * pVia->Bpp + patterny * pVia->Bpl);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentColor8x8PatternFillRect(
    ScrnInfoPtr pScrn,
    int patOffx,
    int patOffy,
    int x,
    int y,
    int w,
    int h)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    CARD32  dwPatAddr;
	
    if (!w || !h)
        return;
    dwPatAddr = (tdc->patternAddr >> 3) |
                ((patOffy & 0x7)  << 29) | ((patOffx & 0x7) << 26);
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_PATADDR, dwPatAddr);
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        /*down AGP buf cmd*/
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(16);/*8x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        BEGIN_HEAD1_2D(VIA_REG_DSTPOS, ((y << 16) | x));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        BEGIN_HEAD1_2D(VIA_REG_PATADDR, dwPatAddr);
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
static void
VIASetupForCPUToScreenColorExpandFill(
    ScrnInfoPtr pScrn,
    int fg,
    int bg,
    int rop,
    unsigned planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
	switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }

    tdc->cmd= VIA_GEC_BLT | VIA_GEC_SRC_SYS | VIA_GEC_SRC_MONO |
          VIA_GEC_MONO_PACK | VIA_GEC_MONO_BYTE |
          (XAAGetCopyROP(rop) << 24);
    if (bg == -1) {
        tdc->cmd |= VIA_GEC_MSRC_TRANS;
    }
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->fgColor= fg;
    tdc->bgColor= bg;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_KEYCONTROL, 0x0);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR, tdc->bgColor);
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentCPUToScreenColorExpandFill(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h,
    int skipleft)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    XAAInfoRecPtr xaaptr = GET_XAAINFORECPTR_FROM_SCRNINFOPTR(pScrn);
    unsigned int size;
    if (skipleft) {
        VIASetClippingRectangle(pScrn, (x + skipleft), y, (x + w - 1), (y + h -1));
    }
    size = ((w + 31) >> 5) * h;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        VIASETREG(VIA_REG_SRCPOS, 0);
        VIASETREG(VIA_REG_DSTPOS,((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
        xaaptr->ColorExpandBase = pVia->BltBase;
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(22);/*11x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_KEYCONTROL, 0x0);
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        BEGIN_HEAD1_2D(VIA_REG_SRCPOS, 0);
        BEGIN_HEAD1_2D(VIA_REG_DSTPOS, ((y << 16) | x));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        BEGIN_HEAD1_2D(VIA_REG_FGCOLOR, tdc->fgColor);
        BEGIN_HEAD1_2D(VIA_REG_BGCOLOR, tdc->bgColor);
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd);
        BEGIN_HEADER_2D_BLT_H2(size,xaaptr->ColorExpandBase);
        (cb)->needFire=TRUE;
    }
#endif
}
static void
VIASetupForImageWrite(
    ScrnInfoPtr pScrn,
    int rop,
    unsigned planemask,
    int trans_color,
    int bpp,
    int depth)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (bpp)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd= VIA_GEC_BLT | VIA_GEC_SRC_SYS | (XAAGetCopyROP(rop) << 24);
    if (pVia->IsHWRotateEnabled) {
        Enable2DEngineRotate(pScrn, &tdc->mode, &tdc->cmd);
	}
    tdc->Bpp= bpp >> 3;
    tdc->Savedtrans_color= trans_color;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        if (tdc->Savedtrans_color != -1)
        {
            VIASETREG(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);
            VIASETREG(VIA_REG_KEYCONTROL, 0x4000);
        }
        else
        {
            VIASETREG(VIA_REG_KEYCONTROL, 0x0);
        }
        VIASETREG(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        VIASETREG(VIA_REG_SRCPOS, 0);
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentImageWriteRect(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int w,
    int h,
    int skipleft)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    unsigned int size;
    XAAInfoRecPtr xaaptr = GET_XAAINFORECPTR_FROM_SCRNINFOPTR(pScrn);

    if (skipleft) {
        VIASetClippingRectangle(pScrn, (x + skipleft), y, (x + w - 1), (y + h -1));
    }
    size = (((w * tdc->Bpp) + 3) >> 2) * h;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_DSTPOS,((y << 16) | x));
        VIASETREG(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
        xaaptr->ImageWriteBase = pVia->BltBase;
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        if (tdc->Savedtrans_color != -1) 
        {
            BEGIN_RING(20);/*10x2 :For H2 2D(head1),32 add + 32 data */
            BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        	BEGIN_HEAD1_2D(VIA_REG_SRCCOLORKEY, tdc->Savedtrans_color);
            BEGIN_HEAD1_2D(VIA_REG_KEYCONTROL, 0x4000);
        }
        else
        {
            BEGIN_RING(18);/*9x2 :For H2 2D(head1),32 add + 32 data */
            BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        	BEGIN_HEAD1_2D(VIA_REG_KEYCONTROL, 0x0);

        }
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                      ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                      (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));

        BEGIN_HEAD1_2D(VIA_REG_SRCPOS, 0);
        BEGIN_HEAD1_2D(VIA_REG_DSTPOS, ((y << 16) | x));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, (((h - 1) << 16) | (w - 1)));
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd);
        BEGIN_HEADER_2D_BLT_H2(size,xaaptr->ImageWriteBase);
        (cb)->needFire=TRUE;
     }
#endif
}
/* Setup for XAA solid lines. */
static void
VIASetupForSolidLine(
    ScrnInfoPtr pScrn,
    int color,
    int rop,
    unsigned int planemask)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }        
    /* we move VIA_GEC_LINE from here to the place firing command */
    tdc->cmd = VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    tdc->fgColor= color;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_MONOPAT0, 0xFF);
        VIASETREG(VIA_REG_FGCOLOR, color);
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3)|
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}

static void
VIASubsequentSolidTwoPointLine(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int flags)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    CARD32  cmd;

    ViaTwodContext *tdc = &pVia->td;
    int     dx, dy, tmp, error = 1;  
    cmd = tdc->cmd | VIA_GEC_LINE;
    dx = x2 - x1;
    if (dx < 0) {
        dx = -dx;
        cmd |= VIA_GEC_DECX;            /* line will be drawn from right */
        error = 0;
    }
    dy = y2 - y1;
    if (dy < 0) {
        dy = -dy;
        cmd |= VIA_GEC_DECY;            /* line will be drawn from bottom */
    }
    if (dy > dx) {
        tmp  = dy;
        dy = dx;
        dx = tmp;                           /* Swap 'dx' and 'dy' */
        cmd |= VIA_GEC_Y_MAJOR;         /* Y major line */
    }
    if (flags & OMIT_LAST) {
        cmd |= VIA_GEC_LASTPIXEL_OFF;
    }
#ifndef XAAChosePciPath     
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        VIASETREG(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DIMENSION, dx);
        VIASETREG(VIA_REG_LINE_ERROR, (((dy << 1) - dx - error) & 0x3fff));
        VIASETREG(VIA_REG_GECMD, cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(22);/*11x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D(VIA_REG_GEMODE,  tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_MONOPAT0, 0xFF);
        BEGIN_HEAD1_2D(VIA_REG_FGCOLOR, tdc->fgColor);
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        BEGIN_HEAD1_2D(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        BEGIN_HEAD1_2D(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, dx);
        BEGIN_HEAD1_2D(VIA_REG_LINE_ERROR, (((dy << 1) - dx - error) & 0x3fff));
        BEGIN_HEAD1_2D(VIA_REG_GECMD, cmd);
    }
#endif
}

/* Subsequent XAA solid horizontal and vertical lines */
static void
VIASubsequentSolidHorVertLine(
    ScrnInfoPtr pScrn,
    int x,
    int y,
    int len,
    int dir)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_DSTPOS, ((y << 16) | x));
        if (dir == DEGREES_0)
            VIASETREG(VIA_REG_DIMENSION, (len - 1));
        else
            VIASETREG(VIA_REG_DIMENSION, ((len - 1) << 16));
        VIASETREG(VIA_REG_GECMD, tdc->cmd| VIA_GEC_BLT);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(18);/*9x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_MONOPAT0, 0xFF);
        BEGIN_HEAD1_2D(VIA_REG_FGCOLOR, tdc->fgColor);
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        BEGIN_HEAD1_2D(VIA_REG_DSTPOS, ((y << 16) | x));
        if (dir == DEGREES_0) 
            BEGIN_HEAD1_2D(VIA_REG_DIMENSION, (len - 1));
        else 
            BEGIN_HEAD1_2D(VIA_REG_DIMENSION, ((len - 1) << 16));
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd| VIA_GEC_BLT);
    }
#endif
}
static void
VIASetupForDashedLine(
    ScrnInfoPtr pScrn,
    int fg,
    int bg,
    int rop,
    unsigned int planemask,
    int length,
    unsigned char *pattern)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    CARD32  pat = *(CARD32 *)pattern;
    tdc->mode=tdc->cmd=0;
    switch (pScrn->bitsPerPixel)
    {
    case 16:
        tdc->mode|= VIA_GEM_16bpp;
        break;
    case 32:
        tdc->mode |= VIA_GEM_32bpp;
        break;
    default:
        tdc->mode |= VIA_GEM_8bpp;
        break;
    }
    tdc->cmd= VIA_GEC_LINE | VIA_GEC_FIXCOLOR_PAT | (XAAGetPatternROP(rop) << 24);
    if (bg == -1) {
        tdc->cmd|= VIA_GEC_MPAT_TRANS;
    }
    tdc->fgColor= fg;
    tdc->bgColor= bg;
    switch (length) {
        case  2: pat |= pat <<  2; /* fall through */
        case  4: pat |= pat <<  4; /* fall through */
        case  8: pat |= pat <<  8; /* fall through */
        case 16: pat |= pat << 16;
    }
    tdc->pattern0 = pat;
#ifndef XAAChosePciPath 
    if(pVia->IsPCI){
#endif  
        WaitIdle();
        VIASETREG(VIA_REG_GEMODE, tdc->mode);
        VIASETREG(VIA_REG_FGCOLOR, tdc->fgColor);
        VIASETREG(VIA_REG_BGCOLOR, tdc->bgColor);
        VIASETREG(VIA_REG_MONOPAT0, tdc->pattern0);
        VIASETREG(VIA_REG_SRCBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_DSTBASE, (pScrn->fbOffset >> 3));
        VIASETREG(VIA_REG_PITCH,VIA_PITCH_ENABLE |
                ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
#ifndef XAAChosePciPath 
    }
#endif
}
static void
VIASubsequentDashedTwoPointLine(
    ScrnInfoPtr pScrn,
    int x1,
    int y1,
    int x2,
    int y2,
    int flags,
    int phase)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    int     dx, dy, tmp, error = 1;  
    dx = x2 - x1;
    if (dx < 0) {
        dx = -dx;
        tdc->cmd |= VIA_GEC_DECX;            /* line will be drawn from right */
        error = 0;
    }
    dy = y2 - y1;
    if (dy < 0) {
        dy = -dy;
        tdc->cmd |= VIA_GEC_DECY;            /* line will be drawn from bottom */
    }
    if (dy > dx) {
        tmp  = dy;
        dy = dx;
        dx = tmp;                       /* Swap 'dx' and 'dy' */
        tdc->cmd |= VIA_GEC_Y_MAJOR;         /* Y major line */
    }
    if (flags & OMIT_LAST) {
        tdc->cmd |= VIA_GEC_LASTPIXEL_OFF;
    }
#ifndef XAAChosePciPath   
    if(pVia->IsPCI){
#endif
        VIASETREG(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        VIASETREG(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        VIASETREG(VIA_REG_DIMENSION, dx);
        VIASETREG(VIA_REG_LINE_ERROR,(((dy << 1) - dx - error) & 0x3fff));
        VIASETREG(VIA_REG_GECMD, tdc->cmd);
#ifndef XAAChosePciPath 
    }else{
        RING_VARS;
        if((cb)->needFire)
            ADVANCE_RING;
        BEGIN_RING(24);/*12x2 :For H2 2D(head1),32 add + 32 data */
        BEGIN_HEAD1_2D(VIA_REG_GEMODE, tdc->mode);
        BEGIN_HEAD1_2D(VIA_REG_FGCOLOR, tdc->fgColor);
        BEGIN_HEAD1_2D(VIA_REG_BGCOLOR, tdc->bgColor);
        BEGIN_HEAD1_2D(VIA_REG_MONOPAT0, tdc->pattern0);
        BEGIN_HEAD1_2D(VIA_REG_SRCBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_DSTBASE,(pScrn->fbOffset >> 3));
        BEGIN_HEAD1_2D(VIA_REG_PITCH, VIA_PITCH_ENABLE |
                  ((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) |
                  (((pScrn->displayWidth * pScrn->bitsPerPixel >> 3) >> 3) << 16));
        BEGIN_HEAD1_2D(VIA_REG_LINE_K1K2, ((((dy << 1) & 0x3fff) << 16)|
                  (((dy - dx) << 1) & 0x3fff)));
        BEGIN_HEAD1_2D(VIA_REG_LINE_XY, ((y1 << 16) | x1));
        BEGIN_HEAD1_2D(VIA_REG_DIMENSION, dx);
        BEGIN_HEAD1_2D(VIA_REG_LINE_ERROR, (((dy << 1) - dx - error) & 0x3fff) | 0xFF0000);
        BEGIN_HEAD1_2D(VIA_REG_GECMD, tdc->cmd);
    }
#endif
}
#endif 
static void VIADisableClipping(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    ViaTwodContext *tdc = &pVia->td;
    tdc->cmd &= ~VIA_GEC_CLIP_ENABLE;
}
/* This callback is required for multihead cards using XAA */
static void VIARestoreAccelState(ScrnInfoPtr pScrn)
{
    /* May need to restore other things.*/

}
/* The sync function for the GE */
void VIAAccelSync(ScrnInfoPtr pScrn)
{
    VIAPtr pVia = VIAPTR(pScrn);
    if(!pVia->IsPCI){
#ifndef XAAChosePciPath 
    RING_VARS;
    ADVANCE_RING;
#endif
    }
    WaitIdle();
}

Bool
VIAInitXAA(ScreenPtr pScreen)
{
    ScrnInfoPtr     pScrn = xf86Screens[pScreen->myNum];
    VIAPtr          pVia = VIAPTR(pScrn);
    XAAInfoRecPtr   xaaptr;
    DevUnion* pPriv;
    VIAEntPtr pVIAEnt;

    /*For High performace,Xaa not using AGP way even Drm module running---(XaaPci+3DAGP)*/
    /* General acceleration flags */
    if (!(xaaptr = pVia->AccelInfoRec = XAACreateInfoRec()))
        return FALSE;

    xaaptr->Flags = PIXMAP_CACHE |
                    OFFSCREEN_PIXMAPS |
                    LINEAR_FRAMEBUFFER |
                    MICROSOFT_ZERO_LINE_BIAS |
                    0;

    if (pScrn->bitsPerPixel == 8)
        xaaptr->CachePixelGranularity = 128;

    xaaptr->Sync = VIAAccelSync;
    /* Clipping */	
    viaXaaSetupFuncTable(xaaptr,pScreen);   
    if(xf86IsEntityShared(pScrn->entityList[0]))
    {
        pPriv = xf86GetEntityPrivate(pScrn->entityList[0],
        gVIAEntityIndex);
        pVIAEnt = pPriv->ptr;
        /*if there are more than one devices sharing this entity, we
        have to assign this call back, otherwise the XAA will be
        disabled */
        if(pVIAEnt->HasSecondary || pVIAEnt->BypassSecondary)
            xaaptr->RestoreAccelState = VIARestoreAccelState;
    }                               
        
    return XAAInit(pScreen, xaaptr);
}

void viaXaaSetupFuncTable(XAAInfoRecPtr   xaaptr,ScreenPtr pScreen)
{
     ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];
     VIAPtr pVia = VIAPTR(pScrn);
	 switch(pVia->Chipset){
        case VIA_VX800:
	    case VIA_VX855:
        {   
            /* Marked the following code temportary.*/
    		/*
            if (!pVia->IsHWRotateEnabled)
            {
                xaaptr->SetClippingRectangle = VIASetClippingRectangle_H6;
                xaaptr->DisableClipping = VIADisableClipping;
                xaaptr->ClippingFlags = HARDWARE_CLIP_SOLID_FILL |
                                        HARDWARE_CLIP_SOLID_LINE |
                                        HARDWARE_CLIP_DASHED_LINE |
                                        HARDWARE_CLIP_SCREEN_TO_SCREEN_COPY |
                                        HARDWARE_CLIP_MONO_8x8_FILL |
                                        HARDWARE_CLIP_COLOR_8x8_FILL |
                                        HARDWARE_CLIP_SCREEN_TO_SCREEN_COLOR_EXPAND |
                                        0;
            }*/

            /* ScreenToScreen copies */
            xaaptr->SetupForScreenToScreenCopy = VIASetupForScreenToScreenCopy_H6;
            xaaptr->SubsequentScreenToScreenCopy = VIASubsequentScreenToScreenCopy_H6;
            xaaptr->ScreenToScreenCopyFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* Solid filled rectangles */
            xaaptr->SetupForSolidFill = VIASetupForSolidFill_H6;
            xaaptr->SubsequentSolidFillRect = VIASubsequentSolidFillRect_H6;
            xaaptr->SolidFillFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* Mono 8x8 pattern fills */
            xaaptr->SetupForMono8x8PatternFill = VIASetupForMono8x8PatternFill_H6;
            xaaptr->SubsequentMono8x8PatternFillRect =
                    VIASubsequentMono8x8PatternFillRect_H6;
            xaaptr->Mono8x8PatternFillFlags = NO_PLANEMASK |
                                              HARDWARE_PATTERN_PROGRAMMED_BITS |
                                              HARDWARE_PATTERN_PROGRAMMED_ORIGIN |
                                              BIT_ORDER_IN_BYTE_MSBFIRST |
                                              0;
            /* Color 8x8 pattern fills */
            xaaptr->SetupForColor8x8PatternFill = VIASetupForColor8x8PatternFill_H6;
            xaaptr->SubsequentColor8x8PatternFillRect =
                    VIASubsequentColor8x8PatternFillRect_H6;
            xaaptr->Color8x8PatternFillFlags = NO_PLANEMASK |
                                            NO_TRANSPARENCY |
                                            HARDWARE_PATTERN_PROGRAMMED_BITS |
                                            HARDWARE_PATTERN_PROGRAMMED_ORIGIN |
                                            0;
            /* Solid lines */
            xaaptr->SetupForSolidLine = VIASetupForSolidLine_H6;
            xaaptr->SubsequentSolidTwoPointLine = VIASubsequentSolidTwoPointLine_H6;        
            xaaptr->SubsequentSolidHorVertLine = VIASubsequentSolidHorVertLine_H6;    
            xaaptr->SolidBresenhamLineErrorTermBits = 14;
            xaaptr->SolidLineFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* dashed line */
            xaaptr->SetupForDashedLine = VIASetupForDashedLine_H6;
            xaaptr->SubsequentDashedTwoPointLine = VIASubsequentDashedTwoPointLine_H6;
            xaaptr->DashPatternMaxLength = 8;
            xaaptr->DashedLineFlags = NO_PLANEMASK |
                                      ROP_NEEDS_SOURCE |
                                      LINE_PATTERN_POWER_OF_2_ONLY |
                                      LINE_PATTERN_MSBFIRST_LSBJUSTIFIED |
                                    0;

            /* CPU to Screen color expansion */
            xaaptr->CPUToScreenColorExpandFillFlags = NO_PLANEMASK |
                                                      CPU_TRANSFER_PAD_DWORD |
                                                      SCANLINE_PAD_DWORD |
                                                      BIT_ORDER_IN_BYTE_MSBFIRST |
                                                      LEFT_EDGE_CLIPPING |
                                                      ROP_NEEDS_SOURCE |
                                                      0;

            xaaptr->SetupForCPUToScreenColorExpandFill =
                    VIASetupForCPUToScreenColorExpandFill_H6;
            xaaptr->SubsequentCPUToScreenColorExpandFill =
                    VIASubsequentCPUToScreenColorExpandFill_H6;

            /* ImageWrite */
            xaaptr->ImageWriteFlags = NO_PLANEMASK |
                                      CPU_TRANSFER_PAD_DWORD |
                                      SCANLINE_PAD_DWORD |
                                      BIT_ORDER_IN_BYTE_MSBFIRST |
                                      LEFT_EDGE_CLIPPING |
                                      ROP_NEEDS_SOURCE |
                                      NO_GXCOPY |
                                      /*SYNC_AFTER_IMAGE_WRITE |*/
                                      0;
            
            xaaptr->SetupForImageWrite = VIASetupForImageWrite_H6;
            xaaptr->SubsequentImageWriteRect = VIASubsequentImageWriteRect_H6;
            xaaptr->ImageWriteBase = pVia->BltBase;
            xaaptr->ImageWriteRange = VIA_MMIO_BLTSIZE;
        }
		break;
        case VIA_K8M890:
        case VIA_P4M890:
        case VIA_P4M900:
        {
            xaaptr->SetClippingRectangle = VIASetClippingRectangle_H5;
            xaaptr->DisableClipping = VIADisableClipping;
            xaaptr->ClippingFlags = HARDWARE_CLIP_SOLID_FILL |
                                    HARDWARE_CLIP_SOLID_LINE |
                                    HARDWARE_CLIP_DASHED_LINE |
                                    HARDWARE_CLIP_SCREEN_TO_SCREEN_COPY |
                                    HARDWARE_CLIP_MONO_8x8_FILL |
                                    HARDWARE_CLIP_COLOR_8x8_FILL |
                                    HARDWARE_CLIP_SCREEN_TO_SCREEN_COLOR_EXPAND |
                                    0;
            /* ScreenToScreen copies */
            xaaptr->SetupForScreenToScreenCopy = VIASetupForScreenToScreenCopy_H5;
            xaaptr->SubsequentScreenToScreenCopy = VIASubsequentScreenToScreenCopy_H5;
            xaaptr->ScreenToScreenCopyFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* Solid filled rectangles */
            xaaptr->SetupForSolidFill = VIASetupForSolidFill_H5;
            xaaptr->SubsequentSolidFillRect = VIASubsequentSolidFillRect_H5;
            xaaptr->SolidFillFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* Mono 8x8 pattern fills */
            xaaptr->SetupForMono8x8PatternFill = VIASetupForMono8x8PatternFill_H5;
            xaaptr->SubsequentMono8x8PatternFillRect =
                    VIASubsequentMono8x8PatternFillRect_H5;
            xaaptr->Mono8x8PatternFillFlags = NO_PLANEMASK |
                                              HARDWARE_PATTERN_PROGRAMMED_BITS |
                                              HARDWARE_PATTERN_PROGRAMMED_ORIGIN |
                                              BIT_ORDER_IN_BYTE_MSBFIRST |
                                              0;

            /* xaa Color8x8 cache bug fixed in cvs tag xf4 3 99 14 */ 
            /* Color 8x8 pattern fills */
            xaaptr->SetupForColor8x8PatternFill = VIASetupForColor8x8PatternFill_H5;
            xaaptr->SubsequentColor8x8PatternFillRect =
                    VIASubsequentColor8x8PatternFillRect_H5;
            xaaptr->Color8x8PatternFillFlags = NO_PLANEMASK |
                                            NO_TRANSPARENCY |
                                            HARDWARE_PATTERN_PROGRAMMED_BITS |
                                            HARDWARE_PATTERN_PROGRAMMED_ORIGIN |
                                            0;
            /* 2D Rotate Engine doesn't support line function. */
            if (!pVia->IsHWRotateEnabled)
            { 
                /* Solid lines */
                xaaptr->SetupForSolidLine = VIASetupForSolidLine_H5;
                xaaptr->SubsequentSolidTwoPointLine = VIASubsequentSolidTwoPointLine_H5;        
                xaaptr->SubsequentSolidHorVertLine = VIASubsequentSolidHorVertLine_H5;    
                xaaptr->SolidBresenhamLineErrorTermBits = 14;
                xaaptr->SolidLineFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

                /* dashed line */
                xaaptr->SetupForDashedLine = VIASetupForDashedLine_H5;
                xaaptr->SubsequentDashedTwoPointLine = VIASubsequentDashedTwoPointLine_H5;
                xaaptr->DashPatternMaxLength = 8;
                xaaptr->DashedLineFlags = NO_PLANEMASK |
                                          ROP_NEEDS_SOURCE |
                                          LINE_PATTERN_POWER_OF_2_ONLY |
                                          LINE_PATTERN_MSBFIRST_LSBJUSTIFIED |
                                          0;
            }

            /* CPU to Screen color expansion */
            xaaptr->CPUToScreenColorExpandFillFlags = NO_PLANEMASK |
                                                      CPU_TRANSFER_PAD_DWORD |
                                                      SCANLINE_PAD_DWORD |
                                                      BIT_ORDER_IN_BYTE_MSBFIRST |
                                                      LEFT_EDGE_CLIPPING |
                                                      ROP_NEEDS_SOURCE |
                                                      0;

            xaaptr->SetupForCPUToScreenColorExpandFill =
                    VIASetupForCPUToScreenColorExpandFill_H5;
            xaaptr->SubsequentCPUToScreenColorExpandFill =
                    VIASubsequentCPUToScreenColorExpandFill_H5;
            xaaptr->ColorExpandBase = pVia->BltBase;
            xaaptr->ColorExpandRange = (64 * 1024);

            /* ImageWrite */
            xaaptr->ImageWriteFlags = NO_PLANEMASK |
                                      CPU_TRANSFER_PAD_DWORD |
                                      SCANLINE_PAD_DWORD |
                                      BIT_ORDER_IN_BYTE_MSBFIRST |
                                      LEFT_EDGE_CLIPPING |
                                      ROP_NEEDS_SOURCE |
                                      NO_GXCOPY |
                                      /*SYNC_AFTER_IMAGE_WRITE |*/
                                      0;
            
            xaaptr->SetupForImageWrite = VIASetupForImageWrite_H5;
            xaaptr->SubsequentImageWriteRect = VIASubsequentImageWriteRect_H5;
            xaaptr->ImageWriteBase = pVia->BltBase;
            xaaptr->ImageWriteRange = (64 * 1024);
        }
        break;
        default:{
            xaaptr->SetClippingRectangle = VIASetClippingRectangle;
            xaaptr->DisableClipping = VIADisableClipping;
            xaaptr->ClippingFlags = HARDWARE_CLIP_SOLID_FILL |
                                    HARDWARE_CLIP_SOLID_LINE |
                                    HARDWARE_CLIP_DASHED_LINE |
                                    HARDWARE_CLIP_SCREEN_TO_SCREEN_COPY |
                                    HARDWARE_CLIP_MONO_8x8_FILL |
                                    HARDWARE_CLIP_COLOR_8x8_FILL |
                                    HARDWARE_CLIP_SCREEN_TO_SCREEN_COLOR_EXPAND |
                                    0;
            /* ScreenToScreen copies */
            xaaptr->SetupForScreenToScreenCopy = VIASetupForScreenToScreenCopy;
            xaaptr->SubsequentScreenToScreenCopy = VIASubsequentScreenToScreenCopy;
            xaaptr->ScreenToScreenCopyFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* Solid filled rectangles */
            xaaptr->SetupForSolidFill = VIASetupForSolidFill;
            xaaptr->SubsequentSolidFillRect = VIASubsequentSolidFillRect;
            xaaptr->SolidFillFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

            /* Mono 8x8 pattern fills */
            xaaptr->SetupForMono8x8PatternFill = VIASetupForMono8x8PatternFill;
            xaaptr->SubsequentMono8x8PatternFillRect =
                    VIASubsequentMono8x8PatternFillRect;
            xaaptr->Mono8x8PatternFillFlags = NO_PLANEMASK |
                                              HARDWARE_PATTERN_PROGRAMMED_BITS |
                                              HARDWARE_PATTERN_PROGRAMMED_ORIGIN |
                                              BIT_ORDER_IN_BYTE_MSBFIRST |
                                              0;

            /* xaa Color8x8 cache bug fixed in cvs tag xf4 3 99 14 */ 
            /* Color 8x8 pattern fills */
            xaaptr->SetupForColor8x8PatternFill = VIASetupForColor8x8PatternFill;
            xaaptr->SubsequentColor8x8PatternFillRect =
                    VIASubsequentColor8x8PatternFillRect;
            xaaptr->Color8x8PatternFillFlags = NO_PLANEMASK |
                                            NO_TRANSPARENCY |
                                            HARDWARE_PATTERN_PROGRAMMED_BITS |
                                            HARDWARE_PATTERN_PROGRAMMED_ORIGIN |
                                            0;
            /* 2D Rotate Engine doesn't support line function. */
            if (!pVia->IsHWRotateEnabled)
            { 
                /* Solid lines */
                xaaptr->SetupForSolidLine = VIASetupForSolidLine;
                xaaptr->SubsequentSolidTwoPointLine = VIASubsequentSolidTwoPointLine;        
                xaaptr->SubsequentSolidHorVertLine = VIASubsequentSolidHorVertLine;    
                xaaptr->SolidBresenhamLineErrorTermBits = 14;
                xaaptr->SolidLineFlags = NO_PLANEMASK | ROP_NEEDS_SOURCE;

                /* dashed line */
                xaaptr->SetupForDashedLine = VIASetupForDashedLine;
                xaaptr->SubsequentDashedTwoPointLine = VIASubsequentDashedTwoPointLine;
                xaaptr->DashPatternMaxLength = 8;
                xaaptr->DashedLineFlags = NO_PLANEMASK |
                                          ROP_NEEDS_SOURCE |
                                          LINE_PATTERN_POWER_OF_2_ONLY |
                                          LINE_PATTERN_MSBFIRST_LSBJUSTIFIED |
                                          0;
            }

            /* CPU to Screen color expansion */
            xaaptr->CPUToScreenColorExpandFillFlags = NO_PLANEMASK |
                                                      CPU_TRANSFER_PAD_DWORD |
                                                      SCANLINE_PAD_DWORD |
                                                      BIT_ORDER_IN_BYTE_MSBFIRST |
                                                      LEFT_EDGE_CLIPPING |
                                                      ROP_NEEDS_SOURCE |
                                                      0;

            xaaptr->SetupForCPUToScreenColorExpandFill =
                    VIASetupForCPUToScreenColorExpandFill;
            xaaptr->SubsequentCPUToScreenColorExpandFill =
                    VIASubsequentCPUToScreenColorExpandFill;
            xaaptr->ColorExpandBase = pVia->BltBase;
            xaaptr->ColorExpandRange = (64 * 1024);

            /* ImageWrite */
            xaaptr->ImageWriteFlags = NO_PLANEMASK |
                                      CPU_TRANSFER_PAD_DWORD |
                                      SCANLINE_PAD_DWORD |
                                      BIT_ORDER_IN_BYTE_MSBFIRST |
                                      LEFT_EDGE_CLIPPING |
                                      ROP_NEEDS_SOURCE |
                                      NO_GXCOPY |
                                      /*SYNC_AFTER_IMAGE_WRITE |*/
                                      0;
            
            xaaptr->SetupForImageWrite = VIASetupForImageWrite;
            xaaptr->SubsequentImageWriteRect = VIASubsequentImageWriteRect;
            xaaptr->ImageWriteBase = pVia->BltBase;
            xaaptr->ImageWriteRange = (64 * 1024);
        }
        break;
	 }

}

