/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*************************************************************************
 *
 *  File:       viamode.h
 *  Content:    migration from frame buffer device driver's function.
 *
 ************************************************************************/

/*special 1280x1024 timing for Wyse_OEM*/
/*#define Wyse_OEM  */

#ifndef __VIAMODE_H__
#define __VIAMODE_H__ 1

/* standard VGA IO port */
#define VIARMisc    0x3CC
#define VIAWMisc    0x3C2
#define VIAStatus   0x3DA
#define VIACR       0x3D4
#define VIASR       0x3C4
#define VIAGR       0x3CE
#define VIAAR       0x3C0

#define StdCR       0x19
#define StdSR       0x04
#define StdGR       0x09
#define StdAR       0x14

#define PatchCR     11

/* Define Return Value */
#define FAIL        -1
#define OK          1

/* Define Color Depth  */
#define MODE_8BPP   1
#define MODE_16BPP  2
#define MODE_32BPP  4

/* PLL Setting value for CLK */
#define CLK_31M     0xC3B5
#define CLK_36M     0xC5E5
#define CLK_49M     0x8653
#define CLK_56M     0x47B7
#define CLK_78M     0x4321

/* Video Mode Index
#define M640x480	0x00
#define M720x480	0x01
#define M720x576	0x02
#define M800x600	0x03
#define M800x480	0x04
#define M848x480	0x05
#define M852x480	0x06
#define M1024x512	0x07
#define M1024x576	0x08
#define M1024x768	0x09
#define M1152x864	0x0A
#define M1280x768	0x0B
#define M1280x800	0x0C
#define M1280x960	0x0D
#define M1280x1024	0x0E
#define M1368x768	0x0F
#define M1440x1050	0x10
#define M1600x1200	0x11
#define M1920x1440	0x12
#define M1280x720	0x13
#define M1920x1080	0x14
#define M1400x1050	0x15
*/
struct io_reg {
    int     port;
    CARD8   index;
    CARD8   mask;
    CARD8   value;
};

struct patch_table {
    int     mode_index;
    int     table_length;
    struct  io_reg *io_reg_table;
};

struct crt_mode_table {
    int     refresh_rate;
    CARD32  clk;
    int     h_sync_polarity;
    int     v_sync_polarity;
    struct  display_timing crtc;
};

struct VPITTable {
    CARD8   Misc;
    CARD8   SR[StdSR];
    CARD8   GR[StdGR];
    CARD8   AR[StdAR];
};

struct VideoModeTable {
    int     ModeIndex;
    struct  crt_mode_table *crtc;
    int     mode_array;
};


 /*  CLE266 : Initialization, Mode Table  */
 /*  xRInitTab   */
/*static struct IOReg CLE266_xRInitTbl[] = {
    {VIASR,0x10,0xFF,0x01},
    {VIASR,0x16,0xFF,0x08},
    {VIASR,0x17,0xFF,0x1F},
    {VIASR,0x18,0xFF,0x4E},
    {VIASR,0x1A,0xFF,0x02},
    {VIASR,0x1F,0xFF,0x00},
    {VIASR,0x20,0xFF,0x00},
    {VIASR,0x21,0xFF,0x00},
    {VIASR,0x22,0xFF,0x1F},
    {VIASR,0x1B,0xFF,0xF0},
    {VIASR,0x1E,0xFF,0xF1},
    {VIASR,0x2D,0xFF,0xFF},
    {VIASR,0x2E,0xFF,0xFF},

    {VIACR,0x36,0xFF,0x01},
    {VIACR,0x6A,0xFF,0x80},
    {VIACR,0x6C,0xFF,0x21},
    {VIACR,0x93,0xFF,0x21},
};*/


/*  xRBitsInitTab   */

/* Video Mode Table for VT3314 chipset*/
/* Common Setting for Video Mode */
static struct io_reg CN700_ModeXregs[] = {
  {VIASR,SR10,0xFF,0x01},
  {VIASR,SR15,0x02,0x02},
  {VIASR,SR16,0xBF,0x08},
  {VIASR,SR17,0xFF,0x1F},
  {VIASR,SR18,0xFF,0x4E},
  {VIASR,SR1A,0xFB,0x82},
  {VIASR,SR1B,0xFF,0xF0},
  {VIASR,SR1F,0xFF,0x00},
  {VIASR,SR1E,0xF7,0x01},
  {VIASR,SR22,0xFF,0x1F},
  {VIASR,SR2E,0xFF,0xFF},
  {VIASR,SR3F,0xFF,0xFF},
  {VIASR,SR40,0xF7,0x00},  
  {VIACR,CR09,0xFF,0x00},         				 /* Initial CR09=0 			    */
  {VIACR,CR11,0x8F,0x00},          				/* IGA1 initial  Vertical end       */
  {VIACR,CR17,0x7F,0x00},          				/* IGA1 CRT Mode control init   */
  {VIASR,CR30,0xFF,0x04},
  {VIACR,CR32,0xFF,0x00},
  {VIACR,CR33,0x7F,0x00},
  {VIACR,CR34,0xFF,0x00},
  {VIACR,CR35,0xFF,0x00},
  {VIACR,CR36,0xFF,0x31},
  {VIACR,CR41,0xFF,0x80},
  {VIACR,CR42,0xFF,0x00},
  {VIACR,CR55,0x80,0x00},
  {VIACR,CR5D,0x80,0x00},                                      /*Horizontal Retrace Start bit[11] should be 0*/
  {VIACR,CR68,0xFF,0x67},                                      /* Default FIFO For IGA2 */ 
  {VIACR,CR69,0xFF,0x00},
  {VIACR,CR6A,0xFD,0x60},
  {VIACR,CR6B,0xFF,0x00},
  {VIACR,CR6C,0xFF,0x00},  
  {VIACR,CR77,0xFF,0x00},                                      /* LCD scaling Factor*/
  {VIACR,CR78,0xFF,0x00},                                      /* LCD scaling Factor */
  {VIACR,CR79,0xFF,0x00},                                      /* LCD scaling Factor*/
  {VIACR,CR9F,0x03,0x00},                                      /* LCD scaling Factor */
  {VIACR,CR7A,0xFF,0x01},                                      /* LCD Scaling Parameter 1*/
  {VIACR,CR7B,0xFF,0x02},                                      /* LCD Scaling Parameter 2*/
  {VIACR,CR7C,0xFF,0x03},                                      /* LCD Scaling Parameter 3 */
  {VIACR,CR7D,0xFF,0x04},                                      /* LCD Scaling Parameter 4*/
  {VIACR,CR7E,0xFF,0x07},                                      /* LCD Scaling Parameter 5*/
  {VIACR,CR7F,0xFF,0x0A},                                      /* LCD Scaling Parameter 6*/
  {VIACR,CR80,0xFF,0x0D},                                      /* LCD Scaling Parameter 7*/
  {VIACR,CR81,0xFF,0x13},                                      /* LCD Scaling Parameter 8*/
  {VIACR,CR82,0xFF,0x16},                                      /* LCD Scaling Parameter 9*/
  {VIACR,CR83,0xFF,0x19},                                      /* LCD Scaling Parameter 10*/
  {VIACR,CR84,0xFF,0x1C},                                      /* LCD Scaling Parameter 11*/
  {VIACR,CR85,0xFF,0x1D},                                      /* LCD Scaling Parameter 12*/
  {VIACR,CR86,0xFF,0x1E},                                      /* LCD Scaling Parameter 13*/
  {VIACR,CR87,0xFF,0x1F},                                      /* LCD Scaling Parameter 14*/
  {VIACR,CR88,0xFF,0x40},                                      /* LCD Panel Type */
  {VIACR,CR89,0xFF,0x00},                                      /* LCD Timing Control 0 */
  {VIACR,CR8A,0xFF,0x88},                                      /* LCD Timing Control 1*/
  {VIACR,CR8B,0xFF,0x5D},                                      /* LCD Power Sequence Control 0*/
  {VIACR,CR8C,0xFF,0x2B},                                      /* LCD Power Sequence Control 1*/
  {VIACR,CR8D,0xFF,0x6F},                                      /* LCD Power Sequence Control 2*/
  {VIACR,CR8E,0xFF,0x2B},                                      /* LCD Power Sequence Control 3*/
  {VIACR,CR8F,0xFF,0x01},                                      /* LCD Power Sequence Control 4*/
  {VIACR,CR90,0xFF,0x01},                                      /* LCD Power Sequence Control 5*/
  {VIACR,CR91,0xFF,0xA0},                                      /* 24/12 bit LVDS Data off*/
  {VIACR,CR96,0xFF,0x00},
  {VIACR,CR97,0xFF,0x00},
  {VIACR,CR99,0xFF,0x00},
  {VIACR,CR9B,0xFF,0x00},
  {VIACR,CR9D,0xFF,0x80},
  {VIACR,CR9E,0xFF,0x80}
};
#define NUM_TOTAL_CN700_ModeXregs ARRAY_SIZE(CN700_ModeXregs)

/* For MAMM */
static struct io_reg CN700_ModeXregs_FOR_MAMM[] = {
    {VIASR,SR19,0xFF,0x7F},
    {VIASR,SR20,0xFF,0x40},
    {VIASR,SR21,0xFF,0x40},
    {VIASR,SR26,0xFF,0x3D},
    {VIASR,SR2D,0xFF,0xFF},    
    {VIASR,SR47,0xFF,0x8a},
    {VIASR,SR48,0xFF,0x04},
    {VIASR,SR49,0xFF,0x03},    
    {VIACR,CR30,0xFF,0x08},
    {VIACR,CR92,0xFF,0x07},    
};
#define NUM_TOTAL_CN700_ModeXregs_FOR_MAMM ARRAY_SIZE(CN700_ModeXregs_FOR_MAMM)

/* For VT3324: Common Setting for Video Mode */
static struct io_reg CX700_ModeXregs[] = {
    {VIASR, SR10, 0xFF, 0x01},
    {VIASR, SR15, 0x02, 0x02},
    {VIASR, SR16, 0xBF, 0x08},
    {VIASR, SR17, 0xFF, 0x1F},
    {VIASR, SR18, 0xFF, 0x4E},
    {VIASR, SR1A, 0xFB, 0x08},
    {VIASR, SR1B, 0xFF, 0xF0},
    {VIASR, SR1E, 0x07, 0x01},
    {VIASR, SR2A, 0xF0, 0x00},
    {VIASR, SR2D, 0xFF, 0xFF},          /* VCK and LCK PLL power on.           */
    {VIACR, CR09, 0xFF, 0x00},          /* Initial CR09=0			    */
    {VIACR, CR11, 0x8F, 0x00},			/* IGA1 initial  Vertical end       */
    {VIACR, CR17, 0x7F, 0x00}, 			/* IGA1 CRT Mode control init   */
    {VIACR, CR0A, 0xFF, 0x1E},          /* Cursor Start                        */
    {VIACR, CR0B, 0xFF, 0x00},          /* Cursor End                          */
    {VIACR, CR0E, 0xFF, 0x00},          /* Cursor Location High                */
    {VIACR, CR0F, 0xFF, 0x00},          /* Cursor Localtion Low                */
    {VIACR, CR32, 0xFF, 0x00},
    {VIACR, CR33, 0x7F, 0x00},
    {VIACR, CR34, 0xFF, 0x00},
    {VIACR, CR35, 0xFF, 0x00},
    {VIACR, CR36, 0x08, 0x00},
    {VIACR, CR69, 0xFF, 0x00},
    {VIACR, CR6A, 0xFD, 0x60},
    {VIACR, CR6B, 0xFF, 0x00},
    {VIACR, CR6C, 0xFF, 0x00},
    {VIACR, CR7A, 0xFF, 0x01},          /* LCD Scaling Parameter 1             */
    {VIACR, CR7B, 0xFF, 0x02},          /* LCD Scaling Parameter 2             */
    {VIACR, CR7C, 0xFF, 0x03},          /* LCD Scaling Parameter 3             */
    {VIACR, CR7D, 0xFF, 0x04},          /* LCD Scaling Parameter 4             */
    {VIACR, CR7E, 0xFF, 0x07},          /* LCD Scaling Parameter 5             */
    {VIACR, CR7F, 0xFF, 0x0A},          /* LCD Scaling Parameter 6             */
    {VIACR, CR80, 0xFF, 0x0D},          /* LCD Scaling Parameter 7             */
    {VIACR, CR81, 0xFF, 0x13},          /* LCD Scaling Parameter 8             */
    {VIACR, CR82, 0xFF, 0x16},          /* LCD Scaling Parameter 9             */
    {VIACR, CR83, 0xFF, 0x19},          /* LCD Scaling Parameter 10            */
    {VIACR, CR84, 0xFF, 0x1C},          /* LCD Scaling Parameter 11            */
    {VIACR, CR85, 0xFF, 0x1D},          /* LCD Scaling Parameter 12            */
    {VIACR, CR86, 0xFF, 0x1E},          /* LCD Scaling Parameter 13            */
    {VIACR, CR87, 0xFF, 0x1F},          /* LCD Scaling Parameter 14            */
    {VIACR, CR88, 0xFF, 0x40},          /* LCD Panel Type                      */
    {VIACR, CR89, 0xFF, 0x00},          /* LCD Timing Control 0                */
    {VIACR, CR8A, 0xFF, 0x88},          /* LCD Timing Control 1                */
    {VIACR, CRD4, 0xFF, 0x81},          /* Second power sequence control       */
    {VIACR, CR91, 0xFF, 0x80},          /* 24/12 bit LVDS Data off             */
    {VIACR, CR96, 0xFF, 0x00},
    {VIACR, CR97, 0xFF, 0x00},
    {VIACR, CR99, 0xFF, 0x00},
    {VIACR, CR9B, 0xFF, 0x00},
    {VIACR, CRD2, 0xFF, 0xFF}           /* TMDS/LVDS control register.         */
};

#define NUM_TOTAL_CX700_ModeXregs ARRAY_SIZE(CX700_ModeXregs)

static struct io_reg VX855_ModeXregs[] = {
    {VIASR, SR10, 0xFF, 0x01},
    {VIASR, SR15, 0x02, 0x02},
    {VIASR, SR16, 0xBF, 0x08},
    {VIASR, SR17, 0xFF, 0x1F},
    {VIASR, SR18, 0xFF, 0x4E},
    {VIASR, SR1A, 0xFB, 0x08},
    {VIASR, SR1B, 0xFF, 0xF0},
    {VIASR, SR1E, 0x07, 0x01},
    {VIASR, SR2A, 0xF0, 0x00},
    {VIASR, SR58, 0xFF, 0x00},
    {VIASR, SR59, 0xFF, 0x00},
    {VIASR, SR2D, 0xFF, 0xFF},          /* VCK and LCK PLL power on.           */
    {VIACR, CR09, 0xFF, 0x00},          /* Initial CR09=0*/
    {VIACR, CR11, 0x8F, 0x00},			/* IGA1 initial  Vertical end       */
    {VIACR, CR17, 0x7F, 0x00}, 			/* IGA1 CRT Mode control init   */
    {VIACR, CR0A, 0xFF, 0x1E},          /* Cursor Start                        */
    {VIACR, CR0B, 0xFF, 0x00},          /* Cursor End                          */
    {VIACR, CR0E, 0xFF, 0x00},          /* Cursor Location High                */
    {VIACR, CR0F, 0xFF, 0x00},          /* Cursor Localtion Low                */
    {VIACR, CR32, 0xFF, 0x00},
    {VIACR, CR33, 0x7F, 0x00},
    {VIACR, CR34, 0xFF, 0x00},
    {VIACR, CR35, 0xFF, 0x00},
    {VIACR, CR36, 0x08, 0x00},
    {VIACR, CR69, 0xFF, 0x00},
    {VIACR, CR6A, 0xFD, 0x60},
    {VIACR, CR6B, 0xFF, 0x00},
    {VIACR, CR6C, 0xFF, 0x00},
    {VIACR, CR7A, 0xFF, 0x01},          /* LCD Scaling Parameter 1             */
    {VIACR, CR7B, 0xFF, 0x02},          /* LCD Scaling Parameter 2             */
    {VIACR, CR7C, 0xFF, 0x03},          /* LCD Scaling Parameter 3             */
    {VIACR, CR7D, 0xFF, 0x04},          /* LCD Scaling Parameter 4             */
    {VIACR, CR7E, 0xFF, 0x07},          /* LCD Scaling Parameter 5             */
    {VIACR, CR7F, 0xFF, 0x0A},          /* LCD Scaling Parameter 6             */
    {VIACR, CR80, 0xFF, 0x0D},          /* LCD Scaling Parameter 7             */
    {VIACR, CR81, 0xFF, 0x13},          /* LCD Scaling Parameter 8             */
    {VIACR, CR82, 0xFF, 0x16},          /* LCD Scaling Parameter 9             */
    {VIACR, CR83, 0xFF, 0x19},          /* LCD Scaling Parameter 10            */
    {VIACR, CR84, 0xFF, 0x1C},          /* LCD Scaling Parameter 11            */
    {VIACR, CR85, 0xFF, 0x1D},          /* LCD Scaling Parameter 12            */
    {VIACR, CR86, 0xFF, 0x1E},          /* LCD Scaling Parameter 13            */
    {VIACR, CR87, 0xFF, 0x1F},          /* LCD Scaling Parameter 14            */
    {VIACR, CR88, 0xFF, 0x40},          /* LCD Panel Type                      */
    {VIACR, CR89, 0xFF, 0x00},          /* LCD Timing Control 0                */
    {VIACR, CR8A, 0xFF, 0x88},          /* LCD Timing Control 1                */
    {VIACR, CRD4, 0xFF, 0x81},          /* Second power sequence control       */
    {VIACR, CR91, 0xFF, 0x80},          /* 24/12 bit LVDS Data off             */
    {VIACR, CR96, 0xFF, 0x00},
    {VIACR, CR97, 0xFF, 0x00},
    {VIACR, CR99, 0xFF, 0x00},
    {VIACR, CR9B, 0xFF, 0x00},
    {VIACR, CRD2, 0xFF, 0xFF}           /* TMDS/LVDS control register.         */
};
#define NUM_TOTAL_VX855_ModeXregs ARRAY_SIZE(VX855_ModeXregs)

/* Mode:1024X768 */
static struct io_reg PM1024x768[] ={
    {VIASR,0x16,0xBF,0x0C},
    {VIASR,0x18,0xFF,0x4C}
};

static struct patch_table res_patch_table[] = {
    { M1024x768, ARRAY_SIZE(PM1024x768), PM1024x768}
};
#define NUM_TOTAL_PATCH_MODE ARRAY_SIZE(res_patch_table)

static struct VPITTable VPIT = {
    /* Msic */
    0xC7,
    /* Sequencer */
    {0x01,0x0F,0x00,0x0E },
    /* Graphic Controller */
    {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0F,0xFF},
    /* Attribute Controller */
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
     0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
     0x01,0x00,0x0F,0x00}
};

/********************/
/* Mode Table       */
/********************/

/* 480x640 */
static struct crt_mode_table CRTM480x640[]  = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */  
  {REFRESH_60, CLK_25_175M, NEGATIVE, POSITIVE,
  {624, 480, 480, 144, 504, 48,  663, 640, 640, 23,  641, 3}}   /* GTF */      
};

/* 640x480 */
static struct crt_mode_table CRTM640x480[]  = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_25_175M, M640X480_R60_HSP, M640X480_R60_VSP,
  {800, 640, 648, 144, 656, 96,  525, 480, 488, 29,  490, 2}},  /* DMT */  
  {REFRESH_75, CLK_31_500M, M640X480_R75_HSP, M640X480_R75_VSP,
  {840, 640, 640, 200, 656, 64,  500, 480, 480, 20,  481, 3}},  /* DMT */
  {REFRESH_85, CLK_36_000M, M640X480_R85_HSP, M640X480_R85_VSP,
  {832, 640, 640, 192, 696, 56,  509, 480, 480, 29,  481, 3}},  /* DMT */
  {REFRESH_100,CLK_43_163M, M640X480_R100_HSP, M640X480_R100_VSP,
  {848, 640, 640, 208, 680, 64,  509, 480, 480, 29,  481, 3}},  /* GTF */
  {REFRESH_120,CLK_52_406M, M640X480_R120_HSP, M640X480_R120_VSP,
  {848, 640, 640, 208, 672, 48,  515, 480, 480, 35,  483, 4}},  /* CVT */
  {REFRESH_160,CLK_73_023M, M640X480_R160_HSP, M640X480_R160_VSP,
  {864, 640, 640, 224, 696, 56,  530, 480, 480, 50,  486, 4}}
};

/* 720x480 (GTF) */
static struct crt_mode_table CRTM720x480[]  = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_26_880M, M720X480_R60_HSP, M720X480_R60_VSP,
  {896, 720, 720, 176, 736, 72,  497, 480, 480, 17,  481, 3}}
};

/* 720x576 (GTF) */
static struct crt_mode_table CRTM720x576[]  = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_32_668M, M720X576_R60_HSP, M720X576_R60_VSP,
  {912, 720, 720, 192, 744, 72,  597, 576, 576, 21,  577, 3}}
};

/* 800x480 (CVT) */
static struct crt_mode_table CRTM800x480[]  = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_29_829M, M800X600_R60_HSP, M800X600_R60_VSP,
  {992, 800, 800, 192, 816, 80,  497, 480, 480, 17,  481, 3}}
};

/* 800x600 */
static struct crt_mode_table CRTM800x600[]  = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_40_000M, M800X600_R60_HSP, M800X600_R60_VSP,
  {1056, 800, 800, 256, 840, 128, 628, 600, 600, 28,  601, 4}}, /* DMT */
  {REFRESH_75, CLK_49_500M, M800X600_R75_HSP, M800X600_R75_VSP,
  {1056, 800, 800, 256, 816, 80,  625, 600, 600, 25,  601, 3}}, /* DMT */
  {REFRESH_85, CLK_56_250M, M800X600_R85_HSP, M800X600_R85_VSP,
  {1048, 800, 800, 248, 832, 64,  631, 600, 600, 31,  601, 3}}, /* DMT */
  {REFRESH_100,CLK_68_179M, M800X600_R100_HSP, M800X600_R100_VSP,
  {1072, 800, 800, 272, 848, 88,  636, 600, 600, 36,  601, 3}}, /* GTF */
  {REFRESH_120,CLK_83_950M, M800X600_R120_HSP, M800X600_R120_VSP,
  {1088, 800, 800, 288, 840, 56,  643, 600, 600, 43,  602, 4}}, /* CVT */
  {REFRESH_160,CLK_115_000M,M800X600_R160_HSP, M800X600_R160_VSP,
  {1088, 800, 800, 288, 864, 80,  662, 600, 600, 62,  603, 4}}  /* CVT */
};


/* 848x480 (CVT) */
static struct crt_mode_table CRTM848x480[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_31_500M, M848X480_R60_HSP, M848X480_R60_VSP,
  {1056, 848, 848, 208, 872, 80,  500, 480, 480, 20,  483, 5}}
};

/* 856x480 (GTF) convert to 852x480 */
static struct crt_mode_table CRTM852x480[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_31_728M, M852X480_R60_HSP, M852X480_R60_VSP,
  {1064, 856, 856, 208, 872, 88,  497, 480, 480, 17,  481, 3}}
};


/* 960x600 (CVT) */
static struct crt_mode_table CRTM960x600[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_46_000M, M960X600_R60_HSP, M960X600_R60_VSP,
  {1232, 960, 960, 272, 1000, 96,  622, 600, 600, 22,  601, 3}}
};

/* 1000x600 (GTF) */
static struct crt_mode_table CRTM1000x600[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_48_000M, M1000X600_R60_HSP, M1000X600_R60_VSP,
  {1288, 1000, 1000,288, 1040,104, 622, 600, 600, 22,  601, 3}}
};


/* 1088x612 (CVT) */
static struct crt_mode_table CRTM1088x612[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_52_977M, M1088X612_R60_HSP, M1088X612_R60_VSP,
  {1392, 1088, 1088,304, 1136,104, 636, 612, 612, 24,  615, 5}}
};

/* 1024x512 (GTF) */
static struct crt_mode_table CRTM1024x512[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_41_291M, M1024X512_R60_HSP, M1024X512_R60_VSP,
  {1296, 1024,1024,272, 1056,104, 531, 512, 512, 19,  513, 3}}
};

/* 1024x600 Carrie[12.07.06]: add mode 1024x600*/
static struct crt_mode_table CRTM1024x600[] = {
  /*r_rate,vclk,hsp,vsp*/
  /*HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE*/
  {REFRESH_60,CLK_48_875M ,M1024X768_R60_HSP, M1024X768_R60_VSP,\
  {1312, 1024, 1024, 288, 1064, 104, 622, 600, 600, 22,  601, 3}},  
};

/* 1024x576 (GTF) */
static struct crt_mode_table CRTM1024x576[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_46_980M, M1024X576_R60_HSP, M1024X576_R60_VSP,
  {1312, 1024,1024,288, 1064,104, 597, 576, 576, 21,  577, 3}}
};

/* 1024x768 */
static struct crt_mode_table CRTM1024x768[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_65_000M, M1024X768_R60_HSP, M1024X768_R60_VSP,
  {1344, 1024, 1024, 320, 1048, 136, 806, 768, 768, 38,  771, 6}},  /* DMT */
  {REFRESH_75, CLK_78_750M, M1024X768_R75_HSP, M1024X768_R75_VSP,
  {1312, 1024, 1024, 288, 1040, 96,  800, 768, 768, 32,  769, 3}},  /* DMT */
  {REFRESH_85, CLK_94_500M, M1024X768_R85_HSP, M1024X768_R85_VSP,
  {1376, 1024, 1024, 352, 1072, 96,  808, 768, 768, 40,  769, 3}},  /* DMT */
  {REFRESH_100,CLK_113_309M,M1024X768_R100_HSP,M1024X768_R100_VSP,
  {1392, 1024, 1024, 368, 1096, 112, 814, 768, 768, 46,  769, 3}},  /* GTF */
  {REFRESH_120,CLK_137_750M,M1024X768_R120_HSP,M1024X768_R120_VSP,
  {1392, 1024, 1024, 368, 1104, 104, 826, 768, 768, 58,  771, 4}}   /* CVT */
};


/* 1024x768 INTERLACE */
static struct crt_mode_table CRTM1024x768_I[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_43, CLK_46_000M, POSITIVE, POSITIVE,
  {1264, 1024, 1024, 240, 1032, 176, 408, 384, 384, 24,  384, 4}},  /* DMT-Interlace */  
};

/* 1152x720 (CVT) */
static struct crt_mode_table CRTM1152x720[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_66_750M, M1152X720_R60_HSP, M1152X720_R60_VSP,
  {1488, 1152,1152, 336, 1208, 112, 748, 720, 720, 28,  723, 6}}
};

/* 1152x864 (DMT) */
static struct crt_mode_table CRTM1152x864[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_81_627M,  M1152X864_R60_HSP, M1152X864_R60_VSP,
  {1520, 1152,1152, 368, 1216, 120, 895, 864, 864, 31,  865, 3}},
  {REFRESH_70, CLK_96_648M,  M1152X864_R70_HSP, M1152X864_R70_VSP,
  {1536, 1152,1152, 384, 1224, 120, 902, 864, 864, 38,  867, 4}},
  {REFRESH_75, CLK_108_000M, M1152X864_R75_HSP, M1152X864_R75_VSP,
  {1600, 1152,1152, 448, 1216, 128, 900, 864, 864, 36,  865, 3}}
};

/* 1152x864 (INTERLACE) */
static struct crt_mode_table CRTM1152x864_I[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_47, CLK_65_000M,             POSITIVE,       POSITIVE,
  {1504, 1152,1152, 352, 1208, 120, 458, 432, 432, 26, 433, 3}}
};

/* 1200x720 (GTF) */
static struct crt_mode_table CRTM1200x720[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_70_159M, M1200X720_R60_HSP, M1200X720_R60_VSP,
  {1568, 1200,1200, 368, 1256, 128, 746, 720, 720, 26,  721, 3}}
};

/* 1280x600 (GTF) */
static struct crt_mode_table CRTM1280x600[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE, VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_61_500M, M1280x600_R60_HSP, M1280x600_R60_VSP,
  {1648, 1280,1280, 368, 1336, 128, 622, 600, 600,  22, 601, 3}}
};

/* 1280x720 */
static struct crt_mode_table CRTM1280x720[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_74_481M, M1280X720_R60_HSP, M1280X720_R60_VSP,
  {1648,1280, 1280, 368, 1392, 40, 750, 720, 720, 30,  725, 5}},
  {REFRESH_50, CLK_60_466M, M1280X720_R50_HSP, M1280X720_R50_VSP,
  {1632,1280, 1280, 352, 1328, 128, 741, 720, 720, 21,  721, 3}}
};

/* 1280x768 (GTF) */
static struct crt_mode_table CRTM1280x768[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_79_466M, M1280X768_R60_HSP, M1280X768_R60_VSP,
  {1664,1280, 1280, 384, 1344, 128, 798, 768, 768, 30,  771, 7}},
  {REFRESH_50, CLK_65_178M, M1280X768_R50_HSP, M1280X768_R50_VSP,
  {1648,1280, 1280, 368, 1336, 128, 791, 768, 768, 23,  769, 3}}
};

/* 1280x960 (DMT) */
static struct crt_mode_table CRTM1280x960[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_108_000M, M1280X960_R60_HSP, M1280X960_R60_VSP,
  {1800,1280, 1280, 520, 1376, 112, 1000,960, 960, 40,  961, 3}}  
};


/* 1280x800 (CVT) */
static struct crt_mode_table CRTM1280x800[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_83_527M, M1280X800_R60_HSP, M1280X800_R60_VSP,
  {1680,1280, 1280, 400, 1344, 136, 828, 800, 800, 28,  801, 3}}
};

/* 1280x854 (CVT) */
static struct crt_mode_table CRTM1280x854[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */  
  {REFRESH_60, CLK_89_489M, M1280X854_R60_HSP, M1280X854_R60_VSP,
  {1680,1280, 1280, 400, 1352, 128, 887, 854, 854, 33,  857, 10}}
};

/* 1280x1024 (DMT) */
static struct crt_mode_table CRTM1280x1024[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_108_000M, M1280X1024_R60_HSP, M1280X1024_R60_VSP,
#ifdef Wyse_OEM  
  {1706,1280, 1280, 426, 1328, 112, 1060,1024,1024,36,  1024,4}},
#else
  {1688,1280, 1280, 408, 1328, 112, 1066,1024,1024,42,  1025,3}},
#endif 
  {REFRESH_75, CLK_135_000M, M1280X1024_R75_HSP, M1280X1024_R75_VSP,
  {1688,1280, 1280, 408, 1296, 144, 1066,1024,1024,42,  1025,3}},
  {REFRESH_85, CLK_157_500M, M1280X1024_R85_HSP, M1280X1024_R85_VSP,
  {1728,1280, 1280, 448, 1344, 160, 1072,1024,1024,48,  1025,3}}
};

/* 1280x1024 (INTERLACE) */
static struct crt_mode_table CRTM1280x1024_I[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_43, CLK_78_750M, POSITIVE, POSITIVE,
  {1680,1280, 1280, 400,1344, 136, 539, 512, 512,27,  513,3}},
};


/* 1366x768 (GTF) */
static struct crt_mode_table CRTM1366x768[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_84_537M, M1368X768_R60_HSP, M1368X768_R60_VSP,
  {1800,1368, 1368, 432, 1440, 144, 795, 768, 768, 27,  769, 3}},
  {REFRESH_50, CLK_69_924M, M1368X768_R50_HSP, M1368X768_R50_VSP,
  {1768,1368, 1368, 400, 1424, 144, 791, 768, 768, 23,  769, 3}},
  {REFRESH_75, CLK_110_125M, M1368X768_R60_HSP, M1368X768_R60_VSP,
  {1832,1368, 1368, 464, 1456, 144, 802, 768, 768, 34,  769, 3}}
};

/* 1368x768 (CVT), same as 1366x768 */
static struct crt_mode_table CRTM1368x768[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_84_537M, M1368X768_R60_HSP, M1368X768_R60_VSP,
  {1800,1368, 1368, 432, 1440, 144, 795, 768, 768, 27,  769, 3}}
};

/* 1360x768 (CVT) */
static struct crt_mode_table CRTM1360x768[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_85_909M, M1360X768_R60_HSP, M1360X768_R60_VSP,
  {1792,1360, 1360, 432, 1424, 112, 795, 768, 768, 27, 771, 6}}
};

/* 1360x768 (CVT Reduce Blanking) */
static struct crt_mode_table CRTM1360x768_RB[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_72_000M, POSITIVE, NEGATIVE,
  {1520,1360, 1360, 160, 1408, 32, 790, 768, 768, 22, 771,5}}
};

/* 1400x1050 (CVT) */
static struct crt_mode_table CRTM1400x1050[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_121_750M, M1400X1050_R60_HSP, M1400X1050_R60_VSP,
  {1864,1400, 1400, 464, 1488, 144, 1089,1050, 1050,  39, 1053, 4}},
  {REFRESH_75,      CLK_156_000M,        NEGATIVE,        POSITIVE,
  {1896,1400, 1400, 496, 1504, 144, 1099,1050, 1050,  49, 1053, 4}}
};

/* 1400x1050 (CVT Reduce Blanking) */
static struct crt_mode_table CRTM1400x1050_RB[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_101_000M, POSITIVE, NEGATIVE,
  {1560,1400, 1400, 160, 1448, 32, 1080,1050, 1050,  30, 1053, 4}}
};

/* 1440x900 (CVT) */
static struct crt_mode_table CRTM1440x900[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_106_500M, M1440X900_R60_HSP, M1440X900_R60_VSP,
  {1904,1440, 1440, 464, 1520, 152, 934, 900, 900, 34, 903,6}},
  {REFRESH_75, CLK_136_700M,            NEGATIVE,       POSITIVE,
  {1936,1440, 1440, 496, 1536, 152, 942, 900, 900, 42, 903,6}},
  {REFRESH_85, CLK_156_867M,            NEGATIVE,       POSITIVE,
  {1952,1440, 1440, 512, 1544, 152, 948, 900, 900, 48, 903,6}}
};

/* 1440x900 (CVT Reduce Blanking) */
static struct crt_mode_table CRTM1440x900_RB[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60, CLK_88_750M, POSITIVE, NEGATIVE,
  {1600,1440, 1440, 160, 1488, 32, 926, 900, 900, 26, 903,6}}
};

/* 1440x1050 (GTF) */
static struct crt_mode_table CRTM1440x1050[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_126_266M, M1440X1050_R60_HSP, M1440X1050_R60_VSP,
  {1936,1440, 1440, 496, 1536, 152, 1087,1050,1050,37,  1051,3}}
};

/* 1600x900 (CVT) */
static struct crt_mode_table CRTM1600x900[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_118_840M, M1600X900_R60_HSP, M1600X900_R60_VSP,
  {2112, 1600, 1600,512, 1688,168, 934, 900, 900, 34,  903, 5}}
};

/* 1600x900 (CVT Reduce Blanking) */
static struct crt_mode_table CRTM1600x900_RB[] = {
  /* r_rate,        vclk,           hsp,        vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,      CLK_97_750M,   POSITIVE,   NEGATIVE,
  {1760, 1600, 1600,160, 1648,32, 926, 900, 900, 26,  903, 5}}
};


/* 1600x1024 (GTF) */
static struct crt_mode_table CRTM1600x1024[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_136_700M, M1600X1024_R60_HSP, M1600X1024_R60_VSP,
  {2144,1600, 1600, 544, 1704, 168, 1060,1024, 1024,  36, 1025, 3}}
};

/* 1600x1200 (DMT) */
static struct crt_mode_table CRTM1600x1200[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_162_000M, M1600X1200_R60_HSP, M1600X1200_R60_VSP,
  {2160,1600, 1600, 560, 1664, 192, 1250,1200,1200,50,  1201,3}},
  {REFRESH_75,CLK_202_500M, M1600X1200_R75_HSP, M1600X1200_R75_VSP,
  {2160,1600, 1600, 560, 1664, 192, 1250,1200,1200,50,  1201,3}},
  {REFRESH_85,CLK_229_500M, M1600X1200_R85_HSP, M1600X1200_R85_VSP,
  {2160,1600, 1600, 560, 1664, 192, 1250,1200,1200,50,  1201,3}}
};

/* 1600x1200 (INTERLACE) */
static struct crt_mode_table CRTM1600x1200_I[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_43,CLK_112_000M, M1600X1200_R60_HSP, M1600X1200_R60_VSP,
  {2112,1600, 1600, 512, 1688, 168, 632,600,600,32,  601,3}},
};

/* 1680x1050 (CVT) */   
static struct crt_mode_table CRTM1680x1050[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE,    VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_146_760M, M1680x1050_R60_HSP, M1680x1050_R60_VSP,
  {2240,1680, 1680, 560, 1784, 176, 1089, 1050, 1050,  39, 1053, 6}},
  {REFRESH_75,      CLK_187_000M,       NEGATIVE,       POSITIVE,
  {2272,1680, 1680, 592, 1800, 176, 1099, 1050, 1050,  49, 1053, 6}}
};

/* 1680x1050 (CVT Reduce Blanking) */   
static struct crt_mode_table CRTM1680x1050_RB[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE,    VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_119_000M, POSITIVE, NEGATIVE,
  {1840,1680, 1680, 160, 1728, 32, 1080, 1050, 1050,  30, 1053, 6}}
};


/* 1792x1344 (DMT) */
static struct crt_mode_table CRTM1792x1344[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_204_000M, M1792x1344_R60_HSP, M1792x1344_R60_VSP,
  {2448,1792, 1792, 656, 1920, 200, 1394,1344, 1344,  50, 1345, 3}}
};

/* 1856x1392 (DMT) */
static struct crt_mode_table CRTM1856x1392[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_218_500M, M1856x1392_R60_HSP, M1856x1392_R60_VSP,
  {2528,1856, 1856, 672, 1952, 224, 1439,1392, 1392, 47,  1393, 3}}
};

/* 1920x1080 (CVT) */
static struct crt_mode_table CRTM1920x1080[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  /*{REFRESH_60,CLK_172_798M, M1920X1080_R60_HSP, M1920X1080_R60_VSP,
  {2576,1920, 1920, 656, 2048,200, 1120,1080,1080,40, 1083, 5}}*/
  {REFRESH_60,CLK_148_500M, M1920X1080_R60_HSP, M1920X1080_R60_VSP,
  {2200,1920, 1920, 280, 2008, 44, 1125,1080,1080,45, 1084, 5}}  
};

/* 1920x1080 (CVT with Reduce Blanking) */
static struct crt_mode_table CRTM1920x1080_RB[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_138_400M, M1920X1080_RB_R60_HSP, M1920X1080_RB_R60_VSP,
  {2080,1920, 1920, 160, 1968, 32, 1111,1080,1080,31, 1083, 5}}
};

/* 1920x1080 (CEA INTERLACE) */
static struct crt_mode_table CRTM1920x1080_I[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,      CLK_74_481M,        POSITIVE,        POSITIVE,
  {2200,1920, 1920, 280,2008,  44,562, 540,  540,  22, 542,   5}},
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_50,      CLK_74_481M,        POSITIVE,        POSITIVE,
  {2640,1920, 1920, 720,2448,  44,562, 540,  540,  22, 542,   5}}
};

/* 1920x1200 (CVT) */
static struct crt_mode_table CRTM1920x1200[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_193_295M, M1920X1200_R60_HSP, M1920X1200_R60_VSP,
  {2592,1920, 1920, 672, 2056, 200, 1245,1200,1200,45, 1203, 6}}
};

/* 1920x1200 (CVT with Reduce Blanking) */
static struct crt_mode_table CRTM1920x1200_RB[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_153_920M, M1920X1200_RB_R60_HSP, M1920X1200_RB_R60_VSP,
  {2080,1920, 1920, 160, 1968, 32, 1235,1200,1200,35, 1203, 6}}
};

/* 1920x1440 (DMT) */
static struct crt_mode_table CRTM1920x1440[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE */
  {REFRESH_60,CLK_234_000M, M1920X1440_R60_HSP, M1920X1440_R60_VSP,
  {2600,1920, 1920, 680, 2048, 208, 1500,1440,1440,60,  1441,3}},
  {REFRESH_75,CLK_297_500M, M1920X1440_R75_HSP, M1920X1440_R75_VSP,
  {2640,1920, 1920, 720, 2064, 224, 1500,1440,1440,60,  1441,3}},
  {REFRESH_85,CLK_339_500M, M1920X1440_R85_HSP, M1920X1440_R85_VSP,
  {2640,1920, 1920, 720, 2072, 208, 1514,1440,1440,74,  1443,4}}    /* CVT */
};

/* 2048x1536 (CVT) */
static struct crt_mode_table CRTM2048x1536[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_267_250M, M2048x1536_R60_HSP, M2048x1536_R60_VSP,
  {2800,2048, 2048, 752, 2200, 224, 1589,1536, 1536,  53, 1537, 3}},
  {REFRESH_75,CLK_340_772M, M2048X1536_R75_HSP, M2048X1536_R75_VSP,
  {2832,2048, 2048, 784, 2216, 224, 1603,1536, 1536,  67, 1537, 3}}
};

/* 720x400 (CVT) */
static struct crt_mode_table CRTM720x400[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_90,CLK_36_000M, M720X400_R90_HSP, M720X400_R90_VSP,
  {900,720, 720, 180, 738, 108, 449, 400, 400, 49, 421, 2}}
};

/* 832x624 (CVT) */
static struct crt_mode_table CRTM832x624[] = {
  /* r_rate,          vclk,              hsp,             vsp   */
  /* HT,  HA,  HBS, HBE,  HSS, HSE,   VT,  VA,  VBS, VBE,  VSS, VSE */
  {REFRESH_60,CLK_41_291M, M832X624_R60_HSP, M832X624_R60_VSP,
  {1056, 832, 832, 224, 864, 80, 649, 624, 624, 25, 627, 4}}
};

static struct VideoModeTable VIARoutineModes[]= {
    /* Display : 480x640 */
   { M480x640,  CRTM480x640, ARRAY_SIZE(CRTM480x640)},
   
   /* Display : 640x480 */
   { M640x480,  CRTM640x480, ARRAY_SIZE(CRTM640x480)},

   /* Display : 720x480 (GTF)*/
   { M720x480,  CRTM720x480, ARRAY_SIZE(CRTM720x480)},

   /* Display : 720x576 (GTF)*/
   { M720x576,  CRTM720x576, ARRAY_SIZE(CRTM720x576)},

   /* Display : 800x600 */
   { M800x600,  CRTM800x600, ARRAY_SIZE(CRTM800x600)},

   /* Display : 800x480 (CVT)*/
   { M800x480,  CRTM800x480, ARRAY_SIZE(CRTM800x480)},

   /* Display : 848x480 (CVT)*/
   { M848x480,  CRTM848x480, ARRAY_SIZE(CRTM848x480)},

   /* Display : 852x480 (GTF)*/
   { M852x480,  CRTM852x480, ARRAY_SIZE(CRTM852x480)},

   /* Display : 960x600 (CVT)*/
   { M960x600, CRTM960x600, ARRAY_SIZE(CRTM960x600)},

   /* Display : 1000x600 (GTF)*/
   { M1000x600, CRTM1000x600, ARRAY_SIZE(CRTM1000x600)},
   
   /* Display : 1024x512 (GTF)*/
   { M1024x512, CRTM1024x512, ARRAY_SIZE(CRTM1024x512)},

   /* Display : 1024x576 (GTF)*/
   { M1024x576, CRTM1024x576, ARRAY_SIZE(CRTM1024x576)},

   /* Display : 1024x600 */
   { M1024x600, CRTM1024x600, ARRAY_SIZE(CRTM1024x600)},
   
   /* Display : 1024x768 */
   { M1024x768, CRTM1024x768, ARRAY_SIZE(CRTM1024x768)},   

   /* Display : 1024x768 INTERLACE */
   { M1024x768_I, CRTM1024x768_I, ARRAY_SIZE(CRTM1024x768_I)}, 

   /* Display : 1088x612 (CVT)*/
   { M1088x612, CRTM1088x612, ARRAY_SIZE(CRTM1088x612)},
   
   /* Display : 1152x720 (CVT)*/
   { M1152x720, CRTM1152x720, ARRAY_SIZE(CRTM1152x720)},
   
   /* Display : 1152x864 (DMT)*/
   { M1152x864, CRTM1152x864, ARRAY_SIZE(CRTM1152x864)},

   /* Display : 1152x864 INTERLACE */
   { M1152x864_I, CRTM1152x864_I, ARRAY_SIZE(CRTM1152x864_I)},

   /* Display : 1200x720 (GTF)*/
   { M1200x720, CRTM1200x720, ARRAY_SIZE(CRTM1200x720)},
   
   /* Display : 1280x600 (GTF)*/
   { M1280x600, CRTM1280x600, ARRAY_SIZE(CRTM1280x600)},

   /* Display : 1280x720 (GTF)*/
   { M1280x720, CRTM1280x720, ARRAY_SIZE(CRTM1280x720)},

   /* Display : 1280x768 (GTF)*/
   { M1280x768, CRTM1280x768, ARRAY_SIZE(CRTM1280x768)},

   /* Display : 1280x800 (CVT)*/
   { M1280x800, CRTM1280x800, ARRAY_SIZE(CRTM1280x800)},

   /* Display : 1280x960 (DMT)*/
   { M1280x960, CRTM1280x960, ARRAY_SIZE(CRTM1280x960)},

   /* Display : 1280x1024 */
   { M1280x1024,CRTM1280x1024,ARRAY_SIZE(CRTM1280x1024)},

   /* Display : 1280x1024 INTERLACE */
   { M1280x1024_I,CRTM1280x1024_I,ARRAY_SIZE(CRTM1280x1024_I)},

   /* Display : 1368x768 (GTF)*/
   /*{ M1368x768,CRTM1368x768,ARRAY_SIZE(CRTM1368x768)},*/

   /* Display : 1366x768 (GTF)*/
   { M1366x768,CRTM1366x768,ARRAY_SIZE(CRTM1366x768)},

   /* Display : 1360x768 (CVT)*/
   { M1360x768,CRTM1360x768,ARRAY_SIZE(CRTM1360x768)},

   /* Display : 1360x768 (CVT Reduce Blanking)*/
   { M1360x768_RB,CRTM1360x768_RB,ARRAY_SIZE(CRTM1360x768_RB)},

   /* Display : 1440x900 (CVT)*/
   { M1440x900, CRTM1440x900, ARRAY_SIZE(CRTM1440x900)},

   /* Display : 1440x900 (CVT Reduce Blanking)*/
   { M1440x900_RB, CRTM1440x900_RB, ARRAY_SIZE(CRTM1440x900_RB)},

   /* Display : 1400x1050 (CVT)*/
   { M1400x1050, CRTM1400x1050, ARRAY_SIZE(CRTM1400x1050)},

   /* Display : 1400x1050 (CVT Reduce Blanking)*/
   { M1400x1050_RB, CRTM1400x1050_RB, ARRAY_SIZE(CRTM1400x1050_RB)},
   
   /* Display : 1440x1050 (GTF)*/
   { M1440x1050, CRTM1440x1050, ARRAY_SIZE(CRTM1440x1050)},

   /* Display : 1600x900 (CVT)*/
   { M1600x900, CRTM1600x900, ARRAY_SIZE(CRTM1600x900)},

   /* Display : 1600x900 (CVT Reduce Blanking)*/
   { M1600x900_RB, CRTM1600x900_RB, ARRAY_SIZE(CRTM1600x900_RB)},
   
   /* Display : 1600x1024 (GTF)*/
   { M1600x1024, CRTM1600x1024, ARRAY_SIZE(CRTM1600x1024)},
   
   /* Display : 1600x1200 */
   { M1600x1200,CRTM1600x1200,ARRAY_SIZE(CRTM1600x1200)},

   /* Display : 1600x1200 INTERLACE */
   { M1600x1200_I, CRTM1600x1200_I,ARRAY_SIZE(CRTM1600x1200_I)},
    
   /* Display : 1680x1050 (CVT) */ 
   { M1680x1050,CRTM1680x1050,ARRAY_SIZE(CRTM1680x1050)},

   /* Display : 1680x1050 (CVT Reduce Blanking) */ 
   { M1680x1050_RB,CRTM1680x1050_RB,ARRAY_SIZE(CRTM1680x1050_RB)},

   /* Display : 1792x1344 (DMT)*/
   { M1792x1344, CRTM1792x1344, ARRAY_SIZE(CRTM1792x1344)},

   /* Display : 1856x1392 (DMT)*/
   { M1856x1392, CRTM1856x1392, ARRAY_SIZE(CRTM1856x1392)},     

   /* Display : 1920x1080 (CVT)*/
   { M1920x1080, CRTM1920x1080, ARRAY_SIZE(CRTM1920x1080)},

   /* Display : 1920x1080, for DELL 2405FPW Monitor. */
   { M1920x1080_RB, CRTM1920x1080_RB, ARRAY_SIZE(CRTM1920x1080_RB)},

   /* Display : 1920x1080 */
   { M1920x1080_I, CRTM1920x1080_I, ARRAY_SIZE(CRTM1920x1080_I)},

   /* Display : 1920x1200 (CVT)*/
   { M1920x1200, CRTM1920x1200, ARRAY_SIZE(CRTM1920x1200)},

   /* Display : 1920x1200, for DELL 2405FPW Monitor. */
   { M1920x1200_RB, CRTM1920x1200_RB, ARRAY_SIZE(CRTM1920x1200_RB)},

   /* Display : 1920x1440 (DMT) */
   { M1920x1440,CRTM1920x1440,ARRAY_SIZE(CRTM1920x1440)},   
   
   /* Display : 2048x1536 (CVT)*/
   { M2048x1536, CRTM2048x1536, ARRAY_SIZE(CRTM2048x1536)},

   /* Display : 720x400 (CVT) */
   { M720x400, CRTM720x400, ARRAY_SIZE(CRTM720x400)},

   /* Display : 832x624 (CVT) */
   { M832x624, CRTM832x624, ARRAY_SIZE(CRTM832x624)}
 
};

#define NUM_TOTAL_MODETABLE ARRAY_SIZE(VIARoutineModes)


/****************************************************************************/
/*                              LCD Mode Table                              */
/* Note.1: On some LCD panel, we found that it can't receive the normal     */
/* timing. We must use a special timing to apply on it. But this maybe      */
/* not good for CRT. So we decide to make the LCD timing table independent. */
/*                                                                          */
/****************************************************************************/

/* 480x640 (Special) */
static struct crt_mode_table LCD_M480x640[]  = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_22_000M,        NEGATIVE,         POSITIVE,
    /* HT,   HA,    HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    { 520,  480,    480,   40,  504,   8,  648,   640,  640,   8,   644,  2}}  
};

/* 640x480 (DMT) */
static struct crt_mode_table LCD_M640x480[]  = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_25_175M,        NEGATIVE,         NEGATIVE,
    /* HT,   HA,    HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    { 800,  640,    640,  160,  656,  96,  525,   480,  480,  45,   490,   2}}  
    /* 
    The LCD can't accept the VESA's 640x480 timing, because The VESA's 640x480 timing has border 
    and LCD doesn't have. Modify hbs and hbe to eliminate the border. */
};


/* 800x480 */
static struct crt_mode_table LCD_M800x480[]  = {
    /*   r_rate,         vclk,             hsp,              vsp             */ 
    {REFRESH_60,  CLK_27_000M,        POSITIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    { 900,   800,   800,  100,  807,  80,  500,   480,  480,  20,   481,   12}}
};


/* 800x600 (DMT)*/
static struct crt_mode_table LCD_M800x600[]  = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_40_000M,        POSITIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1056,   800,   800,  256,  840, 128,  628,   600,  600,  28,   601,   4}} 
};


/* 1024x600 add by Carrie[12.07.06]*/ 
static struct crt_mode_table LCD_M1024x600[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_48_875M,        NEGATIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1312,  1024,  1024,  288, 1064, 104,  622,   600,  600,  22,   601,   3}}  
};


/* 1024x768 (CVT Reduce) */
static struct crt_mode_table LCD_M1024x768[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_56_250M,        POSITIVE,         NEGATIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1184,  1024,  1024,  160, 1072,  32,  790,   768,  768,  22,   771,   4}}
};


/* 1280x768 (GTF) */
static struct crt_mode_table LCD_M1280x768[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_68_369M,        NEGATIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1440,  1280,  1280,  160, 1327,  56,  790,   768,  768,  22,   770,   6}}
};


/* 1280x800 (CVT Reduce) */
static struct crt_mode_table LCD_M1280x800[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_72_000M,        POSITIVE,         NEGATIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1440,  1280,  1280,  160, 1328,  32,  823,   800,  800,  23,   803,   6}}
};


/* 1280x1024 (DMT) */
static struct crt_mode_table LCD_M1280x1024[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */
    {REFRESH_60, CLK_108_000M,        POSITIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
#ifdef Wyse_OEM  
    {1706,  1280,  1280,  426, 1328, 112, 1060,  1024, 1024,  36,  1024,   4}}
#else
    {1688,  1280,  1280,  408, 1328, 112, 1066,  1024, 1024,  42,  1025,   3}}
#endif 
};


/* 1366x768 (GTF) */
static struct crt_mode_table LCD_M1366x768[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60,  CLK_85_860M,        NEGATIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1800,  1368,  1368,  432, 1440, 144,  795,   768,  768,  27,   769,   3}}
};


/* 1360x768 (CVT) */
static struct crt_mode_table LCD_M1360x768[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */ 
    {REFRESH_60,  CLK_84_750M,        POSITIVE,         POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1776,  1360,  1360,  416, 1432, 136,  798,   768,  768,  30,   771,   5}}
};

/* 1400x1050 (CVT Reduce) */
static struct crt_mode_table LCD_M1400x1050[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60, CLK_101_000M,        POSITIVE,         NEGATIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1560,  1400,  1400,  160, 1448,  32, 1080,  1050, 1050,  30,  1053,   4}}
};


/* 1600x1200 (CVT Reduce) */
static struct crt_mode_table LCD_M1600x1200[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60, CLK_130_250M,        POSITIVE,         NEGATIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1760,  1600,  1600,  160, 1648,  32, 1235,  1200, 1200,  35,  1203,   4}}
};

/* 1440x900 */
static struct crt_mode_table LCD_M1440x900[] = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60, CLK_88_750M,        POSITIVE,         NEGATIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {1760,  1440,  1440,  320, 1495,  105, 912,  900, 900,  12,  901,   2}}
};

/* 800x480 (GTF) General case*/
static struct crt_mode_table LCD_M800x480_GEN[]  = {
    /*   r_rate,         vclk,             hsp,              vsp             */  
    {REFRESH_60, CLK_29_581M,        POSITIVE,          POSITIVE,
    /* HT,    HA,   HBS,  HBE,  HSS, HSE,   VT,    VA,  VBS, VBE,   VSS, VSE */
    {992,  800,  800,  192,  816,  80,  497,  480,  480,  17,  481,  3}}
};



static struct VideoModeTable LCDModes[]= {   
   { M480x640,      LCD_M480x640,       ARRAY_SIZE(LCD_M480x640)},
   { M640x480,      LCD_M640x480,       ARRAY_SIZE(LCD_M640x480)},
   { M800x480,      LCD_M800x480,       ARRAY_SIZE(LCD_M800x480)}, 
   { M800x600,      LCD_M800x600,       ARRAY_SIZE(LCD_M800x600)},           
   { M1024x600,     LCD_M1024x600,      ARRAY_SIZE(LCD_M1024x600)},      
   { M1024x768,     LCD_M1024x768,      ARRAY_SIZE(LCD_M1024x768)},            
   { M1280x768,     LCD_M1280x768,      ARRAY_SIZE(LCD_M1280x768)},  
   { M1280x800,     LCD_M1280x800,      ARRAY_SIZE(LCD_M1280x800)}, 
   { M1280x1024,    LCD_M1280x1024,     ARRAY_SIZE(LCD_M1280x1024)},
   { M1366x768,     LCD_M1366x768,      ARRAY_SIZE(LCD_M1366x768)},   
   { M1360x768,     LCD_M1360x768,      ARRAY_SIZE(LCD_M1360x768)},           
   { M1400x1050,    LCD_M1400x1050,     ARRAY_SIZE(LCD_M1400x1050)},            
   { M1600x1200,    LCD_M1600x1200,     ARRAY_SIZE(LCD_M1600x1200)},   
   { M1440x900,     LCD_M1440x900,      ARRAY_SIZE(LCD_M1440x900)},   
   { M800x480_GEN,  LCD_M800x480_GEN,   ARRAY_SIZE(LCD_M800x480_GEN)}, 
};

#define NUM_TOTAL_LCD_MODETABLE ARRAY_SIZE(LCDModes)

#endif  /* __VIAMODE_H__ */

