/*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*
 * INCLUDES 
 */
#include "debug.h"              /* for DBG_DD */
#include "via_eng_regs.h"
#include "via_driver.h"
#include "via_rotate.h" /* for rotate feature.*/
#include "h1hwreg.h"
#include "via_drm.h"
#include "agpctl.h"
#include "via_video.h"
#include "via_eng_reg_fops.h"

extern unsigned long vfCMHQVR(unsigned long dwIndex, ScrnInfoPtr pScrn, viaPortPrivPtr pPriv);
extern void vfHM(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv,unsigned long dwFunSel);

/*use 3D engines to rotate an  area to the direction as specified by rotDirect */
static  void viaHWRotation(VIAPtr pVia,unsigned long dst,unsigned long src,
        unsigned long dstPitch, unsigned long srcPitch, unsigned long srcHeight,unsigned long srcWidth,
        unsigned long dstHeight, unsigned long dstWidth,int rotDirect)
{
    ScrnInfoPtr pScrn = xf86Screens[(pVia->IsSecondary)? 1 : 0];
    viaTexture3DBltSrcRec texBltSrc;
    viaTexture3DBltDstRec texBltDst;
    viaTexture3DBltRotationRec texBltRotation;
    PVIDDATA pVidData = pVia->pVidData;
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
        
    DBG_DD(("%s\n",__FUNCTION__));          

    memset(&texBltSrc, 0x00, sizeof(texBltSrc));
    memset(&texBltDst, 0x00, sizeof(texBltDst));
    memset(&texBltRotation, 0x00, sizeof(texBltRotation));
    
    if(pVia->ChipId== VIA_DEVICE_VT3314)
        texBltSrc.format = PIXMAN_yuy2;
    else
        texBltSrc.format = PICT_r5g6b5;

    texBltDst.format =  PICT_r5g6b5;

    /* The dstWidth and dstHeight is swapped before in 90/270 case, so we must recorve it here. */
    if(rotDirect & (VIA_ROTATE_DEGREE_90 |VIA_ROTATE_DEGREE_270))
    {
        EXCHANGE(dstWidth, dstHeight);
    }
    texBltDst.offset = dst;
    texBltDst.pitch = dstPitch;
    texBltDst.x = 0;
    texBltDst.y = 0;
    texBltDst.w = dstWidth;
    texBltDst.h = dstHeight;

    texBltSrc.offset = src;
    texBltSrc.pitch = srcPitch;
    texBltSrc.x = 0;
    texBltSrc.y = 0;
    texBltSrc.w = srcWidth;
    texBltSrc.h = srcHeight;
    texBltSrc.surfwidth = srcWidth;
    texBltSrc.surfheight = srcHeight;
    texBltSrc.filter = ((texBltSrc.w == texBltDst.w) && (texBltSrc.h == texBltDst.h)) ?
                             via_FilterNearest: via_FilterBilinear;
    texBltSrc.memLoc = LOC_SL;

    texBltRotation.rotate = VIA_TO_RR(rotDirect);
    texBltRotation.width = dstWidth;
    texBltRotation.height = dstHeight;
    
    viaAccelTexture3DBlt(pScrn, &texBltSrc, &texBltDst, &texBltRotation, NULL);
}

/* rotate a video to the direction as specified */
void viaHWVideoRotation(ScrnInfoPtr pScrn, viaPortPrivPtr pPriv)
{
    VIAPtr  pVia = VIAPTR(pScrn);
    unsigned long hqvBufIdx,srcPitch;
    PVIDDATA pVidData = pVia->pVidData;
    LPOVERLAYRECORD lpOverlayRecord=&pPriv->ovlInfo[pPriv->curIGA-1]; 
    viaGfxInfoPtr viaGfxInfo = pVidData->viaGfxInfo;
    unsigned long srcWidth, srcHeight;   
    unsigned long *pVideoFlag = &pPriv->videoFlag;
    DBG_DD(("%s\n",__FUNCTION__));
    
    if (((*pVideoFlag & VIDEO_1_SHOW)==0) && ((*pVideoFlag & VIDEO_3_SHOW)==0))
    {
        return;
    }

   switch(viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit&VIA_ROTATE_DEGREE_ALL)
   {
        case VIA_ROTATE_DEGREE_90:
        case VIA_ROTATE_DEGREE_270:
            srcWidth = lpOverlayRecord->dwRotDestHeight;
            srcHeight = lpOverlayRecord->dwRotDestWidth;
            break;
        case VIA_ROTATE_DEGREE_180:
        default:/*VIA_ROTATE_DEGREE_0*/
            srcWidth = lpOverlayRecord->dwRotDestWidth;
            srcHeight = lpOverlayRecord->dwRotDestHeight;
            break;

   }

    srcPitch=pPriv->pHqvSurface[pPriv->curIGA-1]->pitch; 

   DBG_DD(("dstHeight:%ld,dstWidth:%ld,srcHeight:%ld,srcWidth:%ld\n",\
                lpOverlayRecord->dwRotDestHeight,lpOverlayRecord->dwRotDestWidth,srcHeight,srcWidth));
   DBG_DD(("dstpitch= %ld srcPitch =%ld\n",lpOverlayRecord->dwRotPitch, srcPitch));   
   
   hqvBufIdx = vfCMHQVR(HQV_CONTROL,pScrn, pPriv);

    switch(hqvBufIdx&0x6)
    {
        case 0:/*working on buf 0*/
            DBG_DD(("Rotate Src on HQV[0]\n"));
            viaHWRotation(pVia,pPriv->pRotSurface[pPriv->curIGA-1]->offset[pPriv->pRotSurface[pPriv->curIGA-1]->cur_idx] ,
                     lpOverlayRecord->dwHQVAddr[2],lpOverlayRecord->dwRotPitch, srcPitch,
                     srcHeight,srcWidth,lpOverlayRecord->dwRotDestHeight,lpOverlayRecord->dwRotDestWidth,
                     viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit); 
            break;
        case 2:/*working on buf 1*/
            DBG_DD(("Rotate Src on HQV[1]\n"));
            viaHWRotation(pVia,pPriv->pRotSurface[pPriv->curIGA-1]->offset[pPriv->pRotSurface[pPriv->curIGA-1]->cur_idx] ,
                     lpOverlayRecord->dwHQVAddr[0],lpOverlayRecord->dwRotPitch, srcPitch,
                     srcHeight,srcWidth,lpOverlayRecord->dwRotDestHeight,lpOverlayRecord->dwRotDestWidth,
                     viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit); 
            break;
        case 4:/*working on buf 2*/
            DBG_DD(("Rotate Src on HQV[2]\n"));
            viaHWRotation(pVia,pPriv->pRotSurface[pPriv->curIGA-1]->offset[pPriv->pRotSurface[pPriv->curIGA-1]->cur_idx] ,
                    lpOverlayRecord->dwHQVAddr[1],lpOverlayRecord->dwRotPitch, srcPitch,
                    srcHeight,srcWidth,lpOverlayRecord->dwRotDestHeight,lpOverlayRecord->dwRotDestWidth,
                    viaGfxInfo->igaInfo[pPriv->curIGA-1].igaRRStatus.unit);   
            break;
        default:
            break;
    }/*switch*/
        
    /* wait 3D engine idle because image jitter is quite noticeable when playing HD video */
     vfHM(pScrn, pPriv,HM_WAIT_3D_IDLE);       

}

