 /*
 * Copyright 1998-2008 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2008 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) OR COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __XF86DRI_VIA_H__
#define __XF86DRI_VIA_H__ 1

typedef struct {
    unsigned long sarea_priv_offset;
    unsigned long fb_offset;
    unsigned long mmio_offset;
    unsigned long agpAddr;
 /*agp flush drm*/
 		unsigned long agp_offset;
} drmVIAInit;

typedef struct {
    unsigned int offset;
    unsigned int size;
/*For AMD64*/
#ifndef __x86_64__
    unsigned int index;
#else
    unsigned long index;
#endif
} drmVIAAGPBuf;

typedef struct {
    unsigned int offset;
    unsigned int size;
    drm_handle_t index;
    unsigned long *address;
} drmVIADMABuf;

extern int drmVIAAgpInit(int fd, int offset, int size);
extern int drmVIAFBInit(int fd, int offset, int size);
extern int drmVIAInitMAP(int fd, drmVIAInit *info);
extern int drmVIAAllocateDMA(int fd, drmVIADMABuf *buf);
extern int drmVIAReleaseDMA(int fd, drmVIADMABuf *buf);

/*for support h5s1(vt3336/vt3364)*/
typedef struct {
    enum {
        S3G_INIT    = 0x01,
        S3G_CLEANUP = 0x02
    } func;

    int chip_agp;    
    int chip_index;
    int chip_sub_index;

    int usec_timeout;
    
    unsigned int   sarea_priv_offset;
    
    unsigned int   fb_cpp;
    unsigned int   front_offset;
    unsigned int   back_offset;
    unsigned int   depth_offset;

    unsigned int   mmio_handle;
    unsigned int   dma_handle;
    unsigned int   fb_handle;
    unsigned int   front_handle;
    unsigned int   back_handle;
    unsigned int   depth_handle;

    unsigned int   fb_tex_offset;
    unsigned int   fb_tex_size;

    unsigned int   agp_tex_size;    
    unsigned int   agp_tex_handle;

    unsigned int   shadow_size;
    unsigned int   shadow_handle;

    unsigned int   garttable_size;
    unsigned int   garttable_offset;

    unsigned long  available_fb_size;
    unsigned long  fb_base_address;

    unsigned int   DMA_size;
    unsigned long  DMA_phys_address;

    /*for set AGP buffer type*/
    enum 
    {
        AGP_RING_BUFFER,
        AGP_DOUBLE_BUFFER,
        AGP_DISABLED
    }agp_type;
    /*add 2d host blt map*/
    unsigned int hostBlt_handle;
} drm_s3g_init_t;
 
#endif  /* __XF86DRI_VIA_H__ */
