#!/bin/sh

# Copyright (c) 2008 Fabien Tassin <fta@sofaraway.org>
# Description: Create a build-system for xulrunner applications
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

############################################################################

DIRS="config build toolkit/mozapps/installer"
FILES="configure.in aclocal.m4 allmakefiles.sh toolkit/xre/make-platformini.py nsprpub/config/make-system-wrappers.pl"

NAME="build-system"

SRCDIR=mozilla
if [ ! -d $SRCDIR ] ; then
  if [ -d build-tree/mozilla ] ; then
    SRCDIR=build-tree/mozilla
  else
    echo "Error: can't find mozilla dir"
    exit 1
  fi
fi

rm -rf $NAME debian/$NAME.tar.gz
mkdir -p $NAME
tar -C $SRCDIR -cf - $DIRS $FILES | tar -C $NAME -xf -
cat - > $NAME/Makefile.in <<EOF
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Mozilla.
#
# The Initial Developer of the Original Code is
# the Mozilla Foundation <http://www.mozilla.org/>.
# Portions created by the Initial Developer are Copyright (C) 2007
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Fabien Tassin <fta@sofaraway.org>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

DEPTH           = .
topsrcdir       = @top_srcdir@
srcdir          = @srcdir@
VPATH           = @srcdir@

include \$(DEPTH)/config/autoconf.mk

include \$(topsrcdir)/config/config.mk

default alldep all::
	\$(RM) -rf _tests

TIERS += base

#
# tier "base" - basic setup
#
tier_base_dirs = \\
	config \\
	build \\
	\$(NULL)

include \$(topsrcdir)/\$(MOZ_BUILD_APP)/build.mk

GARBAGE_DIRS += dist _javagen _profile _tests staticlib
DIST_GARBAGE = config.cache config.log config.status config-defs.h \\
   dependencies.beos config/autoconf.mk config/myrules.mk config/myconfig.mk \\
   unallmakefiles mozilla-config.h \\
   netwerk/necko-config.h xpcom/xpcom-config.h xpcom/xpcom-private.h \\
   \$(topsrcdir)/.mozconfig.mk \$(topsrcdir)/.mozconfig.out

# Build pseudo-external modules first when export is explicitly called
export::
	\$(MAKE) -C config export
	\$(MAKE) tier_nspr

include \$(topsrcdir)/config/rules.mk

distclean::
	cat unallmakefiles | \$(XARGS) rm -f
	rm -f unallmakefiles \$(DIST_GARBAGE)
EOF

tar -C $NAME -zcvf debian/$NAME.tar.gz .
rm -rf $NAME
