/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace.format;

import ancestris.modules.editors.geoplace.format.PlaceFormatConverterPanel;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GedcomPlacesConverter {
    private final String PLACETAG = "PLAC";
    private final Gedcom gedcom;
    private final int fromFormatLength;
    private final String[] toPlaceFormat;
    private final String[] map;
    private int nbOfDifferentFoundPlaces = 0;
    private int nbOfDifferentChangedPlaces = 0;
    private int nbOfFoundPlaces = 0;
    private int nbOfChangedPlaces = 0;
    private int nbOfEmptyPlaces = 0;
    private Exception error = null;
    private final Set<String> listOfCorrectPlaces = new TreeSet<String>();
    private final Set<String> listOfIncorrectPlaces = new TreeSet<String>();

    public GedcomPlacesConverter(Gedcom gedcom, String fromFormat, String toFormat, String conversionMap) {
        this.gedcom = gedcom;
        this.fromFormatLength = PropertyPlace.getFormat((String)fromFormat).length;
        this.toPlaceFormat = PropertyPlace.getFormat((String)toFormat);
        this.map = PropertyPlace.getFormat((String)conversionMap);
    }

    public boolean convert() {
        this.nbOfDifferentFoundPlaces = 0;
        this.nbOfDifferentChangedPlaces = 0;
        this.nbOfFoundPlaces = 0;
        this.nbOfChangedPlaces = 0;
        this.nbOfEmptyPlaces = 0;
        String[] newPlace = new String[this.toPlaceFormat.length];
        List allPlaces = this.gedcom.getPropertiesByClass(PropertyPlace.class);
        TreeSet<String> allUniquePlaces = new TreeSet<String>();
        for (Property place : allPlaces) {
            allUniquePlaces.add(place.getValue());
        }
        this.nbOfFoundPlaces = allPlaces.size();
        this.nbOfDifferentFoundPlaces = allUniquePlaces.size();
        for (Property place : allPlaces) {
            int j;
            int i;
            String key = place.getValue();
            if (key.isEmpty()) {
                ++this.nbOfEmptyPlaces;
                continue;
            }
            String[] currentJurisdictions = PropertyPlace.getFormat((String)key);
            if (currentJurisdictions.length != this.fromFormatLength) {
                this.listOfIncorrectPlaces.add(key);
            } else {
                this.listOfCorrectPlaces.add(key);
            }
            boolean[] unusedJurisdictions = new boolean[currentJurisdictions.length];
            for (i = 0; i < currentJurisdictions.length; ++i) {
                unusedJurisdictions[i] = !currentJurisdictions[i].isEmpty();
            }
            for (i = 0; i < newPlace.length; ++i) {
                if (this.map[i].isEmpty() || (j = Integer.valueOf(this.map[i]).intValue()) < 0 || j > currentJurisdictions.length - 1) continue;
                unusedJurisdictions[j] = false;
            }
            for (i = 0; i < newPlace.length; ++i) {
                if (!this.map[i].isEmpty()) {
                    j = Integer.valueOf(this.map[i]);
                    if (j < 0 || j > currentJurisdictions.length - 1) {
                        newPlace[i] = key;
                        continue;
                    }
                    newPlace[i] = currentJurisdictions[j];
                    unusedJurisdictions[j] = false;
                    continue;
                }
                boolean found = false;
                for (int j2 = 0; j2 < unusedJurisdictions.length; ++j2) {
                    if (!unusedJurisdictions[j2]) continue;
                    newPlace[i] = currentJurisdictions[j2];
                    unusedJurisdictions[j2] = false;
                    found = true;
                    break;
                }
                if (found) continue;
                newPlace[i] = "";
            }
            try {
                place.setValue(this.getDisplayOfPlace(newPlace));
                ++this.nbOfChangedPlaces;
            }
            catch (Exception e) {
                String msg = new Exception(e).getLocalizedMessage();
                this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Exception") + " " + msg + "!");
                Exceptions.printStackTrace((Throwable)e);
                return false;
            }
        }
        this.nbOfDifferentChangedPlaces = this.listOfCorrectPlaces.size();
        if (this.listOfIncorrectPlaces.size() > 0) {
            this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_WrongFormat"));
            return false;
        }
        return true;
    }

    public boolean isWithError() {
        return this.error != null;
    }

    public String[] getIncorrectPlaces() {
        if (this.listOfIncorrectPlaces == null) {
            return null;
        }
        return this.listOfIncorrectPlaces.toArray(new String[this.listOfIncorrectPlaces.size()]);
    }

    private String getDisplayOfPlace(String[] newPlace) {
        Object ret = "";
        String sep = ",";
        for (int i = 0; i < newPlace.length; ++i) {
            if (i == newPlace.length - 1) {
                sep = "";
            }
            ret = (String)ret + newPlace[i] + sep;
        }
        return ret;
    }

    public int getNbOfDifferentFoundPlaces() {
        return this.nbOfDifferentFoundPlaces;
    }

    public int getNbOfDifferentChangedPlaces() {
        return this.nbOfDifferentChangedPlaces;
    }

    public int getNbOfFoundPlaces() {
        return this.nbOfFoundPlaces;
    }

    public int getNbOfChangedPlaces() {
        return this.nbOfChangedPlaces;
    }

    public int getNbOfEmptyPlaces() {
        return this.nbOfEmptyPlaces;
    }

    public Exception getError() {
        if (this.error == null) {
            this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Unknown"));
        }
        return this.error;
    }
}

