/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom.privacy.standard;

import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.gedcom.privacy.standard.Options;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.UnitOfWork;
import genj.gedcom.time.Delta;
import genj.io.Filter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class PrivacyPolicyImpl
extends PrivacyPolicy
implements Filter {
    private static final Logger LOG = Logger.getLogger("ancestris.gedcom.privacy.standard");
    private final Set<Entity> privateYearsEntities = new HashSet<Entity>();
    private final Set<Entity> aliveEntities = new HashSet<Entity>();
    private static final PrivacyPolicy PUBLIC = new PrivacyPolicyImpl(){

        @Override
        public boolean isPrivate(Property prop) {
            return false;
        }
    };
    private static final PrivacyPolicy PRIVATE = new PrivacyPolicyImpl(){

        @Override
        public boolean isPrivate(Property prop) {
            return true;
        }
    };
    private static boolean isBusy = false;

    public PrivacyPolicy getAllPublic() {
        return PUBLIC;
    }

    public PrivacyPolicy getAllPrivate() {
        return PRIVATE;
    }

    public String getPrivateMask() {
        return Options.getInstance().getPrivateMask();
    }

    public void openPreferences() {
        OptionsDisplayer.getDefault().open("OptionFormat/Privacy");
    }

    public boolean isPrivate(Property prop) {
        if (Options.getInstance().deadIsPublic() && this.isInfoOfDeceased(prop)) {
            return false;
        }
        if (Options.getInstance().getPrivateYears() > 0 && this.isWithinPrivateYears(prop)) {
            return true;
        }
        if (Options.getInstance().aliveIsPrivate() && this.isInfoOfAlive(prop)) {
            return true;
        }
        return Options.getInstance().getPrivateTag(prop) != null && this.hasTagMarkingPrivate(prop);
    }

    private boolean isWithinPrivateYears(Property prop) {
        if (prop == null) {
            return false;
        }
        Entity ent = prop.getEntity();
        if (this.privateYearsEntities.contains(ent)) {
            return true;
        }
        if (ent instanceof Indi || ent instanceof Fam) {
            if (this.hasPrivateYearsDate((Property)ent)) {
                this.privateYearsEntities.add(ent);
                return true;
            }
        } else {
            List<Entity> list = this.getRelatedPeople(ent, new ArrayList<Entity>());
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (this.privateYearsEntities.contains(entity)) {
                        return true;
                    }
                    if (!this.hasPrivateYearsDate((Property)entity)) continue;
                    this.privateYearsEntities.add(entity);
                    this.privateYearsEntities.add(ent);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInfoOfAlive(Property prop) {
        if (prop == null) {
            return false;
        }
        Entity ent = prop.getEntity();
        if (this.aliveEntities.contains(ent)) {
            return true;
        }
        if (ent instanceof Indi) {
            Indi indi = (Indi)ent;
            if (this.isAlive(indi)) {
                this.aliveEntities.add(ent);
                return true;
            }
        } else {
            if (ent instanceof Fam) {
                Fam fam = (Fam)ent;
                Indi husband = fam.getHusband();
                if (husband != null && this.isAlive(husband)) {
                    this.aliveEntities.add((Entity)husband);
                    this.aliveEntities.add(ent);
                    return true;
                }
                Indi wife = fam.getWife();
                if (wife != null && this.isAlive(wife)) {
                    this.aliveEntities.add((Entity)wife);
                    this.aliveEntities.add(ent);
                    return true;
                }
                return false;
            }
            List<Entity> list = this.getRelatedPeople(ent, new ArrayList<Entity>());
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (this.aliveEntities.contains(entity)) {
                        return true;
                    }
                    if (entity instanceof Indi && this.isAlive((Indi)entity)) {
                        this.aliveEntities.add(entity);
                        this.aliveEntities.add(ent);
                        return true;
                    }
                    if (!(entity instanceof Fam)) continue;
                    Fam fam = (Fam)entity;
                    Indi husband = fam.getHusband();
                    if (husband != null && this.isAlive(husband)) {
                        this.aliveEntities.add((Entity)husband);
                        this.aliveEntities.add(ent);
                        return true;
                    }
                    Indi wife = fam.getWife();
                    if (wife == null || !this.isAlive(wife)) continue;
                    this.aliveEntities.add((Entity)wife);
                    this.aliveEntities.add(ent);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasTagMarkingPrivate(Property prop) {
        if (PrivacyPolicyImpl.checkLegacy(prop)) {
            return true;
        }
        if (prop.getProperty(Options.getInstance().getPrivateTag(prop)) != null) {
            return true;
        }
        if ((prop = prop.getParent()) != null) {
            return this.hasTagMarkingPrivate(prop);
        }
        return false;
    }

    public void setTagMarkingPrivate(Property property) {
        try {
            property.addProperty(Options.getInstance().getPrivateTag(property), Options.getInstance().getPrivateValue(), 0);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void delTagMarkingPrivate(Property parent) {
        Property deletee = parent.getProperty(Options.getInstance().getPrivateTag(parent));
        if (deletee != null) {
            parent.delProperty(deletee);
        }
    }

    private boolean isInfoOfDeceased(Property prop) {
        Entity e = prop.getEntity();
        if (e instanceof Indi) {
            return ((Indi)e).isDeceased();
        }
        if (e instanceof Fam) {
            Indi husband = ((Fam)e).getHusband();
            if (husband != null && !husband.isDeceased()) {
                return false;
            }
            Indi wife = ((Fam)e).getWife();
            return wife != null && wife.isDeceased();
        }
        return false;
    }

    private boolean hasPrivateYearsDate(Property prop) {
        List dateProps = prop.getProperties(PropertyDate.class);
        for (PropertyDate propertyDate : dateProps) {
            if (!this.isDatePrivate(propertyDate)) continue;
            return true;
        }
        return false;
    }

    private boolean isDatePrivate(PropertyDate date) {
        if (date == null) {
            return false;
        }
        Delta anniversary = date.getAnniversary();
        return anniversary != null && anniversary.getYears() < Options.getInstance().getPrivateYears();
    }

    private boolean isAlive(Indi indi) {
        PropertyDate bdate = indi.getBirthDate();
        PropertyDate ddate = indi.getDeathDate();
        if (bdate == null) {
            return false;
        }
        Delta anniversary = bdate.getAnniversary();
        return ddate == null && anniversary != null && anniversary.getYears() < Options.getInstance().getYearsIndiCanBeAlive();
    }

    private List<Entity> getRelatedPeople(Entity ent, List<Entity> seen) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (PropertyXRef propertyXRef : ent.getProperties(PropertyXRef.class)) {
            Entity target = propertyXRef.getTargetEntity().orElse(null);
            if (target == null || seen.contains(target)) continue;
            seen.add(target);
            if (target instanceof Indi || target instanceof Fam) {
                list.add(target);
            }
            if (!(target instanceof Source) && !(target instanceof Note)) continue;
            list.addAll(this.getRelatedPeople(target, seen));
        }
        return list;
    }

    public String getFilterName() {
        return NbBundle.getMessage(PrivacyPolicyImpl.class, (String)"PrivacyFilterName");
    }

    public String getSelectionName() {
        return "";
    }

    public boolean veto(Property property) {
        return this.isPrivate(property);
    }

    public boolean veto(Entity entity) {
        return this.isPrivate((Property)entity);
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return true;
    }

    public void clear() {
        this.privateYearsEntities.clear();
        this.aliveEntities.clear();
    }

    public int getIndividualsCount() {
        return 0;
    }

    private static boolean checkLegacy(final Property prop) {
        if (prop.getProperty(Options.getInstance().getUserPrivateTag()) == null) {
            return false;
        }
        if (Options.getInstance().getPrivateTag(prop).equals(Options.getInstance().getUserPrivateTag())) {
            return false;
        }
        if (isBusy) {
            return true;
        }
        isBusy = true;
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                String question;
                String title = NbBundle.getMessage(PrivacyPolicyImpl.class, (String)"PrivacyTagEvolution_TITL");
                Object o = DialogManager.create((String)title, (String)(question = NbBundle.getMessage(PrivacyPolicyImpl.class, (String)"PrivacyTagEvolution_QUEST"))).setMessageType(3).setOptionType(0).show();
                if (o == DialogManager.YES_OPTION) {
                    int n = PrivacyPolicyImpl.renameLegacyPrivacyTag(prop);
                    String result = NbBundle.getMessage(PrivacyPolicyImpl.class, (String)"PrivacyTagEvolution_RSLT", (Object)n);
                    DialogManager.create((String)title, (String)result).setMessageType(1).setOptionType(10).show();
                }
                isBusy = false;
            }
        });
        return true;
    }

    private static int renameLegacyPrivacyTag(Property prop) {
        final String oldTag = Options.getInstance().getUserPrivateTag();
        Gedcom gedcom = prop.getGedcom();
        final ArrayList legacyProperties = new ArrayList();
        for (Entity ent : gedcom.getEntities()) {
            legacyProperties.addAll(ent.getAllProperties(oldTag));
        }
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    int ret = 0;
                    String actionStr = "";
                    if (legacyProperties.size() > 0) {
                        LOG.info("--------------------------------------------------");
                        LOG.info("Starting the evolution of obsolete privacy tags...");
                    }
                    for (Property legacyProperty : legacyProperties) {
                        ++ret;
                        actionStr = "Removed";
                        Property parent = legacyProperty.getParent();
                        String newTag = Options.getInstance().getPrivateTag(parent);
                        if (newTag.equals(oldTag)) {
                            actionStr = "Skipped";
                            LOG.info(actionStr + " tag" + oldTag + " for entity " + legacyProperty.getEntity() + " and for property " + parent + "  [" + ret + "]");
                            continue;
                        }
                        if (parent.getProperty(newTag) == null) {
                            try {
                                parent.addProperty(Options.getInstance().getPrivateTag(parent), Options.getInstance().getPrivateValue(), 0);
                                actionStr = "Changed";
                            }
                            catch (GedcomException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        LOG.info(actionStr + " tag" + oldTag + " for entity " + legacyProperty.getEntity() + " and for property " + parent + "  [" + ret + "]");
                        parent.delProperty(legacyProperty);
                    }
                    if (legacyProperties.size() > 0) {
                        LOG.info("Completed the evolution of obsolete privacy tags.");
                        LOG.info("-------------------------------------------------");
                    }
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return legacyProperties.size();
    }
}

