require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_FS_H)) {
    eval 'sub _LINUX_FS_H () {1;}' unless defined(&_LINUX_FS_H);
    require 'linux/limits.ph';
    require 'linux/ioctl.ph';
    require 'linux/types.ph';
    undef(&NR_OPEN) if defined(&NR_OPEN);
    eval 'sub INR_OPEN_CUR () {1024;}' unless defined(&INR_OPEN_CUR);
    eval 'sub INR_OPEN_MAX () {4096;}' unless defined(&INR_OPEN_MAX);
    eval 'sub BLOCK_SIZE_BITS () {10;}' unless defined(&BLOCK_SIZE_BITS);
    eval 'sub BLOCK_SIZE () {(1<< &BLOCK_SIZE_BITS);}' unless defined(&BLOCK_SIZE);
    eval 'sub SEEK_SET () {0;}' unless defined(&SEEK_SET);
    eval 'sub SEEK_CUR () {1;}' unless defined(&SEEK_CUR);
    eval 'sub SEEK_END () {2;}' unless defined(&SEEK_END);
    eval 'sub SEEK_DATA () {3;}' unless defined(&SEEK_DATA);
    eval 'sub SEEK_HOLE () {4;}' unless defined(&SEEK_HOLE);
    eval 'sub SEEK_MAX () { &SEEK_HOLE;}' unless defined(&SEEK_MAX);
    eval 'sub RENAME_NOREPLACE () {(1<< 0);}' unless defined(&RENAME_NOREPLACE);
    eval 'sub RENAME_EXCHANGE () {(1<< 1);}' unless defined(&RENAME_EXCHANGE);
    eval 'sub RENAME_WHITEOUT () {(1<< 2);}' unless defined(&RENAME_WHITEOUT);
    eval 'sub FILE_DEDUPE_RANGE_SAME () {0;}' unless defined(&FILE_DEDUPE_RANGE_SAME);
    eval 'sub FILE_DEDUPE_RANGE_DIFFERS () {1;}' unless defined(&FILE_DEDUPE_RANGE_DIFFERS);
    eval 'sub NR_FILE () {8192;}' unless defined(&NR_FILE);
    eval 'sub MS_RDONLY () {1;}' unless defined(&MS_RDONLY);
    eval 'sub MS_NOSUID () {2;}' unless defined(&MS_NOSUID);
    eval 'sub MS_NODEV () {4;}' unless defined(&MS_NODEV);
    eval 'sub MS_NOEXEC () {8;}' unless defined(&MS_NOEXEC);
    eval 'sub MS_SYNCHRONOUS () {16;}' unless defined(&MS_SYNCHRONOUS);
    eval 'sub MS_REMOUNT () {32;}' unless defined(&MS_REMOUNT);
    eval 'sub MS_MANDLOCK () {64;}' unless defined(&MS_MANDLOCK);
    eval 'sub MS_DIRSYNC () {128;}' unless defined(&MS_DIRSYNC);
    eval 'sub MS_NOATIME () {1024;}' unless defined(&MS_NOATIME);
    eval 'sub MS_NODIRATIME () {2048;}' unless defined(&MS_NODIRATIME);
    eval 'sub MS_BIND () {4096;}' unless defined(&MS_BIND);
    eval 'sub MS_MOVE () {8192;}' unless defined(&MS_MOVE);
    eval 'sub MS_REC () {16384;}' unless defined(&MS_REC);
    eval 'sub MS_VERBOSE () {32768;}' unless defined(&MS_VERBOSE);
    eval 'sub MS_SILENT () {32768;}' unless defined(&MS_SILENT);
    eval 'sub MS_POSIXACL () {(1<<16);}' unless defined(&MS_POSIXACL);
    eval 'sub MS_UNBINDABLE () {(1<<17);}' unless defined(&MS_UNBINDABLE);
    eval 'sub MS_PRIVATE () {(1<<18);}' unless defined(&MS_PRIVATE);
    eval 'sub MS_SLAVE () {(1<<19);}' unless defined(&MS_SLAVE);
    eval 'sub MS_SHARED () {(1<<20);}' unless defined(&MS_SHARED);
    eval 'sub MS_RELATIME () {(1<<21);}' unless defined(&MS_RELATIME);
    eval 'sub MS_KERNMOUNT () {(1<<22);}' unless defined(&MS_KERNMOUNT);
    eval 'sub MS_I_VERSION () {(1<<23);}' unless defined(&MS_I_VERSION);
    eval 'sub MS_STRICTATIME () {(1<<24);}' unless defined(&MS_STRICTATIME);
    eval 'sub MS_LAZYTIME () {(1<<25);}' unless defined(&MS_LAZYTIME);
    eval 'sub MS_SUBMOUNT () {(1<<26);}' unless defined(&MS_SUBMOUNT);
    eval 'sub MS_NOREMOTELOCK () {(1<<27);}' unless defined(&MS_NOREMOTELOCK);
    eval 'sub MS_NOSEC () {(1<<28);}' unless defined(&MS_NOSEC);
    eval 'sub MS_BORN () {(1<<29);}' unless defined(&MS_BORN);
    eval 'sub MS_ACTIVE () {(1<<30);}' unless defined(&MS_ACTIVE);
    eval 'sub MS_NOUSER () {(1<<31);}' unless defined(&MS_NOUSER);
    eval 'sub MS_RMT_MASK () {( &MS_RDONLY| &MS_SYNCHRONOUS| &MS_MANDLOCK| &MS_I_VERSION|  &MS_LAZYTIME);}' unless defined(&MS_RMT_MASK);
    eval 'sub MS_MGC_VAL () {0xc0ed0000;}' unless defined(&MS_MGC_VAL);
    eval 'sub MS_MGC_MSK () {0xffff0000;}' unless defined(&MS_MGC_MSK);
    eval 'sub FS_XFLAG_REALTIME () {0x1;}' unless defined(&FS_XFLAG_REALTIME);
    eval 'sub FS_XFLAG_PREALLOC () {0x2;}' unless defined(&FS_XFLAG_PREALLOC);
    eval 'sub FS_XFLAG_IMMUTABLE () {0x8;}' unless defined(&FS_XFLAG_IMMUTABLE);
    eval 'sub FS_XFLAG_APPEND () {0x10;}' unless defined(&FS_XFLAG_APPEND);
    eval 'sub FS_XFLAG_SYNC () {0x20;}' unless defined(&FS_XFLAG_SYNC);
    eval 'sub FS_XFLAG_NOATIME () {0x40;}' unless defined(&FS_XFLAG_NOATIME);
    eval 'sub FS_XFLAG_NODUMP () {0x80;}' unless defined(&FS_XFLAG_NODUMP);
    eval 'sub FS_XFLAG_RTINHERIT () {0x100;}' unless defined(&FS_XFLAG_RTINHERIT);
    eval 'sub FS_XFLAG_PROJINHERIT () {0x200;}' unless defined(&FS_XFLAG_PROJINHERIT);
    eval 'sub FS_XFLAG_NOSYMLINKS () {0x400;}' unless defined(&FS_XFLAG_NOSYMLINKS);
    eval 'sub FS_XFLAG_EXTSIZE () {0x800;}' unless defined(&FS_XFLAG_EXTSIZE);
    eval 'sub FS_XFLAG_EXTSZINHERIT () {0x1000;}' unless defined(&FS_XFLAG_EXTSZINHERIT);
    eval 'sub FS_XFLAG_NODEFRAG () {0x2000;}' unless defined(&FS_XFLAG_NODEFRAG);
    eval 'sub FS_XFLAG_FILESTREAM () {0x4000;}' unless defined(&FS_XFLAG_FILESTREAM);
    eval 'sub FS_XFLAG_DAX () {0x8000;}' unless defined(&FS_XFLAG_DAX);
    eval 'sub FS_XFLAG_COWEXTSIZE () {0x10000;}' unless defined(&FS_XFLAG_COWEXTSIZE);
    eval 'sub FS_XFLAG_HASATTR () {0x80000000;}' unless defined(&FS_XFLAG_HASATTR);
    eval 'sub BLKROSET () { &_IO(0x12,93);}' unless defined(&BLKROSET);
    eval 'sub BLKROGET () { &_IO(0x12,94);}' unless defined(&BLKROGET);
    eval 'sub BLKRRPART () { &_IO(0x12,95);}' unless defined(&BLKRRPART);
    eval 'sub BLKGETSIZE () { &_IO(0x12,96);}' unless defined(&BLKGETSIZE);
    eval 'sub BLKFLSBUF () { &_IO(0x12,97);}' unless defined(&BLKFLSBUF);
    eval 'sub BLKRASET () { &_IO(0x12,98);}' unless defined(&BLKRASET);
    eval 'sub BLKRAGET () { &_IO(0x12,99);}' unless defined(&BLKRAGET);
    eval 'sub BLKFRASET () { &_IO(0x12,100);}' unless defined(&BLKFRASET);
    eval 'sub BLKFRAGET () { &_IO(0x12,101);}' unless defined(&BLKFRAGET);
    eval 'sub BLKSECTSET () { &_IO(0x12,102);}' unless defined(&BLKSECTSET);
    eval 'sub BLKSECTGET () { &_IO(0x12,103);}' unless defined(&BLKSECTGET);
    eval 'sub BLKSSZGET () { &_IO(0x12,104);}' unless defined(&BLKSSZGET);
    if(0) {
	eval 'sub BLKPG () { &_IO(0x12,105);}' unless defined(&BLKPG);
	eval 'sub BLKELVGET () { &_IOR(0x12,106,\'size_t\');}' unless defined(&BLKELVGET);
	eval 'sub BLKELVSET () { &_IOW(0x12,107,\'size_t\');}' unless defined(&BLKELVSET);
    }
    eval 'sub BLKBSZGET () { &_IOR(0x12,112,\'size_t\');}' unless defined(&BLKBSZGET);
    eval 'sub BLKBSZSET () { &_IOW(0x12,113,\'size_t\');}' unless defined(&BLKBSZSET);
    eval 'sub BLKGETSIZE64 () { &_IOR(0x12,114,\'size_t\');}' unless defined(&BLKGETSIZE64);
    eval 'sub BLKTRACESETUP () { &_IOWR(0x12,115,\'struct blk_user_trace_setup\');}' unless defined(&BLKTRACESETUP);
    eval 'sub BLKTRACESTART () { &_IO(0x12,116);}' unless defined(&BLKTRACESTART);
    eval 'sub BLKTRACESTOP () { &_IO(0x12,117);}' unless defined(&BLKTRACESTOP);
    eval 'sub BLKTRACETEARDOWN () { &_IO(0x12,118);}' unless defined(&BLKTRACETEARDOWN);
    eval 'sub BLKDISCARD () { &_IO(0x12,119);}' unless defined(&BLKDISCARD);
    eval 'sub BLKIOMIN () { &_IO(0x12,120);}' unless defined(&BLKIOMIN);
    eval 'sub BLKIOOPT () { &_IO(0x12,121);}' unless defined(&BLKIOOPT);
    eval 'sub BLKALIGNOFF () { &_IO(0x12,122);}' unless defined(&BLKALIGNOFF);
    eval 'sub BLKPBSZGET () { &_IO(0x12,123);}' unless defined(&BLKPBSZGET);
    eval 'sub BLKDISCARDZEROES () { &_IO(0x12,124);}' unless defined(&BLKDISCARDZEROES);
    eval 'sub BLKSECDISCARD () { &_IO(0x12,125);}' unless defined(&BLKSECDISCARD);
    eval 'sub BLKROTATIONAL () { &_IO(0x12,126);}' unless defined(&BLKROTATIONAL);
    eval 'sub BLKZEROOUT () { &_IO(0x12,127);}' unless defined(&BLKZEROOUT);
    eval 'sub BMAP_IOCTL () {1;}' unless defined(&BMAP_IOCTL);
    eval 'sub FIBMAP () { &_IO(0x,1);}' unless defined(&FIBMAP);
    eval 'sub FIGETBSZ () { &_IO(0x,2);}' unless defined(&FIGETBSZ);
    eval 'sub FIFREEZE () { &_IOWR(ord(\'X\'), 119, \'int\');}' unless defined(&FIFREEZE);
    eval 'sub FITHAW () { &_IOWR(ord(\'X\'), 120, \'int\');}' unless defined(&FITHAW);
    eval 'sub FITRIM () { &_IOWR(ord(\'X\'), 121, \'struct fstrim_range\');}' unless defined(&FITRIM);
    eval 'sub FICLONE () { &_IOW(0x94, 9, \'int\');}' unless defined(&FICLONE);
    eval 'sub FICLONERANGE () { &_IOW(0x94, 13, \'struct file_clone_range\');}' unless defined(&FICLONERANGE);
    eval 'sub FIDEDUPERANGE () { &_IOWR(0x94, 54, \'struct file_dedupe_range\');}' unless defined(&FIDEDUPERANGE);
    eval 'sub FS_IOC_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'long\');}' unless defined(&FS_IOC_GETFLAGS);
    eval 'sub FS_IOC_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'long\');}' unless defined(&FS_IOC_SETFLAGS);
    eval 'sub FS_IOC_GETVERSION () { &_IOR(ord(\'v\'), 1, \'long\');}' unless defined(&FS_IOC_GETVERSION);
    eval 'sub FS_IOC_SETVERSION () { &_IOW(ord(\'v\'), 2, \'long\');}' unless defined(&FS_IOC_SETVERSION);
    eval 'sub FS_IOC_FIEMAP () { &_IOWR(ord(\'f\'), 11, \'struct fiemap\');}' unless defined(&FS_IOC_FIEMAP);
    eval 'sub FS_IOC32_GETFLAGS () { &_IOR(ord(\'f\'), 1, \'int\');}' unless defined(&FS_IOC32_GETFLAGS);
    eval 'sub FS_IOC32_SETFLAGS () { &_IOW(ord(\'f\'), 2, \'int\');}' unless defined(&FS_IOC32_SETFLAGS);
    eval 'sub FS_IOC32_GETVERSION () { &_IOR(ord(\'v\'), 1, \'int\');}' unless defined(&FS_IOC32_GETVERSION);
    eval 'sub FS_IOC32_SETVERSION () { &_IOW(ord(\'v\'), 2, \'int\');}' unless defined(&FS_IOC32_SETVERSION);
    eval 'sub FS_IOC_FSGETXATTR () { &_IOR (ord(\'X\'), 31, \'struct fsxattr\');}' unless defined(&FS_IOC_FSGETXATTR);
    eval 'sub FS_IOC_FSSETXATTR () { &_IOW (ord(\'X\'), 32, \'struct fsxattr\');}' unless defined(&FS_IOC_FSSETXATTR);
    eval 'sub FS_KEY_DESCRIPTOR_SIZE () {8;}' unless defined(&FS_KEY_DESCRIPTOR_SIZE);
    eval 'sub FS_POLICY_FLAGS_PAD_4 () {0x;}' unless defined(&FS_POLICY_FLAGS_PAD_4);
    eval 'sub FS_POLICY_FLAGS_PAD_8 () {0x1;}' unless defined(&FS_POLICY_FLAGS_PAD_8);
    eval 'sub FS_POLICY_FLAGS_PAD_16 () {0x2;}' unless defined(&FS_POLICY_FLAGS_PAD_16);
    eval 'sub FS_POLICY_FLAGS_PAD_32 () {0x3;}' unless defined(&FS_POLICY_FLAGS_PAD_32);
    eval 'sub FS_POLICY_FLAGS_PAD_MASK () {0x3;}' unless defined(&FS_POLICY_FLAGS_PAD_MASK);
    eval 'sub FS_POLICY_FLAGS_VALID () {0x3;}' unless defined(&FS_POLICY_FLAGS_VALID);
    eval 'sub FS_ENCRYPTION_MODE_INVALID () {0;}' unless defined(&FS_ENCRYPTION_MODE_INVALID);
    eval 'sub FS_ENCRYPTION_MODE_AES_256_XTS () {1;}' unless defined(&FS_ENCRYPTION_MODE_AES_256_XTS);
    eval 'sub FS_ENCRYPTION_MODE_AES_256_GCM () {2;}' unless defined(&FS_ENCRYPTION_MODE_AES_256_GCM);
    eval 'sub FS_ENCRYPTION_MODE_AES_256_CBC () {3;}' unless defined(&FS_ENCRYPTION_MODE_AES_256_CBC);
    eval 'sub FS_ENCRYPTION_MODE_AES_256_CTS () {4;}' unless defined(&FS_ENCRYPTION_MODE_AES_256_CTS);
    eval 'sub FS_ENCRYPTION_MODE_AES_128_CBC () {5;}' unless defined(&FS_ENCRYPTION_MODE_AES_128_CBC);
    eval 'sub FS_ENCRYPTION_MODE_AES_128_CTS () {6;}' unless defined(&FS_ENCRYPTION_MODE_AES_128_CTS);
    eval 'sub FS_IOC_SET_ENCRYPTION_POLICY () { &_IOR(ord(\'f\'), 19, \'struct fscrypt_policy\');}' unless defined(&FS_IOC_SET_ENCRYPTION_POLICY);
    eval 'sub FS_IOC_GET_ENCRYPTION_PWSALT () { &_IOW(ord(\'f\'), 20,  $__u8[16]);}' unless defined(&FS_IOC_GET_ENCRYPTION_PWSALT);
    eval 'sub FS_IOC_GET_ENCRYPTION_POLICY () { &_IOW(ord(\'f\'), 21, \'struct fscrypt_policy\');}' unless defined(&FS_IOC_GET_ENCRYPTION_POLICY);
    eval 'sub FS_KEY_DESC_PREFIX () {"fscrypt:";}' unless defined(&FS_KEY_DESC_PREFIX);
    eval 'sub FS_KEY_DESC_PREFIX_SIZE () {8;}' unless defined(&FS_KEY_DESC_PREFIX_SIZE);
    eval 'sub FS_MAX_KEY_SIZE () {64;}' unless defined(&FS_MAX_KEY_SIZE);
    eval 'sub FS_SECRM_FL () {0x1;}' unless defined(&FS_SECRM_FL);
    eval 'sub FS_UNRM_FL () {0x2;}' unless defined(&FS_UNRM_FL);
    eval 'sub FS_COMPR_FL () {0x4;}' unless defined(&FS_COMPR_FL);
    eval 'sub FS_SYNC_FL () {0x8;}' unless defined(&FS_SYNC_FL);
    eval 'sub FS_IMMUTABLE_FL () {0x10;}' unless defined(&FS_IMMUTABLE_FL);
    eval 'sub FS_APPEND_FL () {0x20;}' unless defined(&FS_APPEND_FL);
    eval 'sub FS_NODUMP_FL () {0x40;}' unless defined(&FS_NODUMP_FL);
    eval 'sub FS_NOATIME_FL () {0x80;}' unless defined(&FS_NOATIME_FL);
    eval 'sub FS_DIRTY_FL () {0x100;}' unless defined(&FS_DIRTY_FL);
    eval 'sub FS_COMPRBLK_FL () {0x200;}' unless defined(&FS_COMPRBLK_FL);
    eval 'sub FS_NOCOMP_FL () {0x400;}' unless defined(&FS_NOCOMP_FL);
    eval 'sub FS_ENCRYPT_FL () {0x800;}' unless defined(&FS_ENCRYPT_FL);
    eval 'sub FS_BTREE_FL () {0x1000;}' unless defined(&FS_BTREE_FL);
    eval 'sub FS_INDEX_FL () {0x1000;}' unless defined(&FS_INDEX_FL);
    eval 'sub FS_IMAGIC_FL () {0x2000;}' unless defined(&FS_IMAGIC_FL);
    eval 'sub FS_JOURNAL_DATA_FL () {0x4000;}' unless defined(&FS_JOURNAL_DATA_FL);
    eval 'sub FS_NOTAIL_FL () {0x8000;}' unless defined(&FS_NOTAIL_FL);
    eval 'sub FS_DIRSYNC_FL () {0x10000;}' unless defined(&FS_DIRSYNC_FL);
    eval 'sub FS_TOPDIR_FL () {0x20000;}' unless defined(&FS_TOPDIR_FL);
    eval 'sub FS_HUGE_FILE_FL () {0x40000;}' unless defined(&FS_HUGE_FILE_FL);
    eval 'sub FS_EXTENT_FL () {0x80000;}' unless defined(&FS_EXTENT_FL);
    eval 'sub FS_EA_INODE_FL () {0x200000;}' unless defined(&FS_EA_INODE_FL);
    eval 'sub FS_EOFBLOCKS_FL () {0x400000;}' unless defined(&FS_EOFBLOCKS_FL);
    eval 'sub FS_NOCOW_FL () {0x800000;}' unless defined(&FS_NOCOW_FL);
    eval 'sub FS_INLINE_DATA_FL () {0x10000000;}' unless defined(&FS_INLINE_DATA_FL);
    eval 'sub FS_PROJINHERIT_FL () {0x20000000;}' unless defined(&FS_PROJINHERIT_FL);
    eval 'sub FS_RESERVED_FL () {0x80000000;}' unless defined(&FS_RESERVED_FL);
    eval 'sub FS_FL_USER_VISIBLE () {0x3dfff;}' unless defined(&FS_FL_USER_VISIBLE);
    eval 'sub FS_FL_USER_MODIFIABLE () {0x380ff;}' unless defined(&FS_FL_USER_MODIFIABLE);
    eval 'sub SYNC_FILE_RANGE_WAIT_BEFORE () {1;}' unless defined(&SYNC_FILE_RANGE_WAIT_BEFORE);
    eval 'sub SYNC_FILE_RANGE_WRITE () {2;}' unless defined(&SYNC_FILE_RANGE_WRITE);
    eval 'sub SYNC_FILE_RANGE_WAIT_AFTER () {4;}' unless defined(&SYNC_FILE_RANGE_WAIT_AFTER);
    eval 'sub RWF_HIPRI () {(( &__kernel_rwf_t)0x1);}' unless defined(&RWF_HIPRI);
    eval 'sub RWF_DSYNC () {(( &__kernel_rwf_t)0x2);}' unless defined(&RWF_DSYNC);
    eval 'sub RWF_SYNC () {(( &__kernel_rwf_t)0x4);}' unless defined(&RWF_SYNC);
    eval 'sub RWF_NOWAIT () {(( &__kernel_rwf_t)0x8);}' unless defined(&RWF_NOWAIT);
    eval 'sub RWF_SUPPORTED () {( &RWF_HIPRI |  &RWF_DSYNC |  &RWF_SYNC |  &RWF_NOWAIT);}' unless defined(&RWF_SUPPORTED);
}
1;
