require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_ETHTOOL_H)) {
    eval 'sub _LINUX_ETHTOOL_H () {1;}' unless defined(&_LINUX_ETHTOOL_H);
    require 'linux/kernel.ph';
    require 'linux/types.ph';
    require 'linux/if_ether.ph';
    require 'limits.ph';
    eval 'sub ethtool_cmd_speed_set {
        my($ep,$speed) = @_;
	    eval q({  ($ep->{speed}) = ( &__u16)($speed & 0xffff);  ($ep->{speed_hi}) = ( &__u16)($speed >> 16); });
    }' unless defined(&ethtool_cmd_speed_set);
    eval 'sub ethtool_cmd_speed {
        my($ep) = @_;
	    eval q({ ( ($ep->{speed_hi}) << 16) |  ($ep->{speed}); });
    }' unless defined(&ethtool_cmd_speed);
    eval 'sub ETH_MDIO_SUPPORTS_C22 () {1;}' unless defined(&ETH_MDIO_SUPPORTS_C22);
    eval 'sub ETH_MDIO_SUPPORTS_C45 () {2;}' unless defined(&ETH_MDIO_SUPPORTS_C45);
    eval 'sub ETHTOOL_FWVERS_LEN () {32;}' unless defined(&ETHTOOL_FWVERS_LEN);
    eval 'sub ETHTOOL_BUSINFO_LEN () {32;}' unless defined(&ETHTOOL_BUSINFO_LEN);
    eval 'sub ETHTOOL_EROMVERS_LEN () {32;}' unless defined(&ETHTOOL_EROMVERS_LEN);
    eval 'sub SOPASS_MAX () {6;}' unless defined(&SOPASS_MAX);
    eval 'sub PFC_STORM_PREVENTION_AUTO () {0xffff;}' unless defined(&PFC_STORM_PREVENTION_AUTO);
    eval 'sub PFC_STORM_PREVENTION_DISABLE () {0;}' unless defined(&PFC_STORM_PREVENTION_DISABLE);
    eval("sub ETHTOOL_ID_UNSPEC () { 0; }") unless defined(&ETHTOOL_ID_UNSPEC);
    eval("sub ETHTOOL_RX_COPYBREAK () { 1; }") unless defined(&ETHTOOL_RX_COPYBREAK);
    eval("sub ETHTOOL_TX_COPYBREAK () { 2; }") unless defined(&ETHTOOL_TX_COPYBREAK);
    eval("sub ETHTOOL_PFC_PREVENTION_TOUT () { 3; }") unless defined(&ETHTOOL_PFC_PREVENTION_TOUT);
    eval("sub __ETHTOOL_TUNABLE_COUNT () { 4; }") unless defined(&__ETHTOOL_TUNABLE_COUNT);
    eval("sub ETHTOOL_TUNABLE_UNSPEC () { 0; }") unless defined(&ETHTOOL_TUNABLE_UNSPEC);
    eval("sub ETHTOOL_TUNABLE_U8 () { 1; }") unless defined(&ETHTOOL_TUNABLE_U8);
    eval("sub ETHTOOL_TUNABLE_U16 () { 2; }") unless defined(&ETHTOOL_TUNABLE_U16);
    eval("sub ETHTOOL_TUNABLE_U32 () { 3; }") unless defined(&ETHTOOL_TUNABLE_U32);
    eval("sub ETHTOOL_TUNABLE_U64 () { 4; }") unless defined(&ETHTOOL_TUNABLE_U64);
    eval("sub ETHTOOL_TUNABLE_STRING () { 5; }") unless defined(&ETHTOOL_TUNABLE_STRING);
    eval("sub ETHTOOL_TUNABLE_S8 () { 6; }") unless defined(&ETHTOOL_TUNABLE_S8);
    eval("sub ETHTOOL_TUNABLE_S16 () { 7; }") unless defined(&ETHTOOL_TUNABLE_S16);
    eval("sub ETHTOOL_TUNABLE_S32 () { 8; }") unless defined(&ETHTOOL_TUNABLE_S32);
    eval("sub ETHTOOL_TUNABLE_S64 () { 9; }") unless defined(&ETHTOOL_TUNABLE_S64);
    eval 'sub DOWNSHIFT_DEV_DEFAULT_COUNT () {0xff;}' unless defined(&DOWNSHIFT_DEV_DEFAULT_COUNT);
    eval 'sub DOWNSHIFT_DEV_DISABLE () {0;}' unless defined(&DOWNSHIFT_DEV_DISABLE);
    eval 'sub ETHTOOL_PHY_FAST_LINK_DOWN_ON () {0;}' unless defined(&ETHTOOL_PHY_FAST_LINK_DOWN_ON);
    eval 'sub ETHTOOL_PHY_FAST_LINK_DOWN_OFF () {0xff;}' unless defined(&ETHTOOL_PHY_FAST_LINK_DOWN_OFF);
    eval("sub ETHTOOL_PHY_ID_UNSPEC () { 0; }") unless defined(&ETHTOOL_PHY_ID_UNSPEC);
    eval("sub ETHTOOL_PHY_DOWNSHIFT () { 1; }") unless defined(&ETHTOOL_PHY_DOWNSHIFT);
    eval("sub ETHTOOL_PHY_FAST_LINK_DOWN () { 2; }") unless defined(&ETHTOOL_PHY_FAST_LINK_DOWN);
    eval("sub __ETHTOOL_PHY_TUNABLE_COUNT () { 3; }") unless defined(&__ETHTOOL_PHY_TUNABLE_COUNT);
    eval 'sub ETH_GSTRING_LEN () {32;}' unless defined(&ETH_GSTRING_LEN);
    eval("sub ETH_SS_TEST () { 0; }") unless defined(&ETH_SS_TEST);
    eval("sub ETH_SS_STATS () { 1; }") unless defined(&ETH_SS_STATS);
    eval("sub ETH_SS_PRIV_FLAGS () { 2; }") unless defined(&ETH_SS_PRIV_FLAGS);
    eval("sub ETH_SS_NTUPLE_FILTERS () { 3; }") unless defined(&ETH_SS_NTUPLE_FILTERS);
    eval("sub ETH_SS_FEATURES () { 4; }") unless defined(&ETH_SS_FEATURES);
    eval("sub ETH_SS_RSS_HASH_FUNCS () { 5; }") unless defined(&ETH_SS_RSS_HASH_FUNCS);
    eval("sub ETH_SS_TUNABLES () { 6; }") unless defined(&ETH_SS_TUNABLES);
    eval("sub ETH_SS_PHY_STATS () { 7; }") unless defined(&ETH_SS_PHY_STATS);
    eval("sub ETH_SS_PHY_TUNABLES () { 8; }") unless defined(&ETH_SS_PHY_TUNABLES);
    eval("sub ETH_TEST_FL_OFFLINE () { (1<<0); }") unless defined(&ETH_TEST_FL_OFFLINE);
    eval("sub ETH_TEST_FL_FAILED () { (1<<1); }") unless defined(&ETH_TEST_FL_FAILED);
    eval("sub ETH_TEST_FL_EXTERNAL_LB () { (1<<2); }") unless defined(&ETH_TEST_FL_EXTERNAL_LB);
    eval("sub ETH_TEST_FL_EXTERNAL_LB_DONE () { (1<<3); }") unless defined(&ETH_TEST_FL_EXTERNAL_LB_DONE);
    eval("sub ETH_FLAG_TXVLAN () { (1<<7); }") unless defined(&ETH_FLAG_TXVLAN);
    eval("sub ETH_FLAG_RXVLAN () { (1<<8); }") unless defined(&ETH_FLAG_RXVLAN);
    eval("sub ETH_FLAG_LRO () { (1<<15); }") unless defined(&ETH_FLAG_LRO);
    eval("sub ETH_FLAG_NTUPLE () { (1<<27); }") unless defined(&ETH_FLAG_NTUPLE);
    eval("sub ETH_FLAG_RXHASH () { (1<<28); }") unless defined(&ETH_FLAG_RXHASH);
    eval 'sub ETH_RX_NFC_IP4 () {1;}' unless defined(&ETH_RX_NFC_IP4);
    eval 'sub ETHTOOL_RX_FLOW_SPEC_RING () {0xffffffff;}' unless defined(&ETHTOOL_RX_FLOW_SPEC_RING);
    eval 'sub ETHTOOL_RX_FLOW_SPEC_RING_VF () {1095216660480;}' unless defined(&ETHTOOL_RX_FLOW_SPEC_RING_VF);
    eval 'sub ETHTOOL_RX_FLOW_SPEC_RING_VF_OFF () {32;}' unless defined(&ETHTOOL_RX_FLOW_SPEC_RING_VF_OFF);
    eval 'sub ethtool_get_flow_spec_ring {
        my($ring_cookie) = @_;
	    eval q({  &ETHTOOL_RX_FLOW_SPEC_RING & $ring_cookie; });
    }' unless defined(&ethtool_get_flow_spec_ring);
    eval 'sub ethtool_get_flow_spec_ring_vf {
        my($ring_cookie) = @_;
	    eval q({ ( &ETHTOOL_RX_FLOW_SPEC_RING_VF & $ring_cookie) >>  &ETHTOOL_RX_FLOW_SPEC_RING_VF_OFF; });
    }' unless defined(&ethtool_get_flow_spec_ring_vf);
    eval 'sub ETH_RXFH_CONTEXT_ALLOC () {0xffffffff;}' unless defined(&ETH_RXFH_CONTEXT_ALLOC);
    eval 'sub ETH_RXFH_INDIR_NO_CHANGE () {0xffffffff;}' unless defined(&ETH_RXFH_INDIR_NO_CHANGE);
    eval 'sub ETHTOOL_RXNTUPLE_ACTION_DROP () {(-1);}' unless defined(&ETHTOOL_RXNTUPLE_ACTION_DROP);
    eval 'sub ETHTOOL_RXNTUPLE_ACTION_CLEAR () {(-2);}' unless defined(&ETHTOOL_RXNTUPLE_ACTION_CLEAR);
    eval 'sub ETHTOOL_FLASH_MAX_FILENAME () {128;}' unless defined(&ETHTOOL_FLASH_MAX_FILENAME);
    eval("sub ETHTOOL_FLASH_ALL_REGIONS () { 0; }") unless defined(&ETHTOOL_FLASH_ALL_REGIONS);
    eval 'sub ETH_FW_DUMP_DISABLE () {0;}' unless defined(&ETH_FW_DUMP_DISABLE);
    eval("sub ETHTOOL_F_UNSUPPORTED__BIT () { 0; }") unless defined(&ETHTOOL_F_UNSUPPORTED__BIT);
    eval("sub ETHTOOL_F_WISH__BIT () { 1; }") unless defined(&ETHTOOL_F_WISH__BIT);
    eval("sub ETHTOOL_F_COMPAT__BIT () { 2; }") unless defined(&ETHTOOL_F_COMPAT__BIT);
    eval 'sub ETHTOOL_F_UNSUPPORTED () {(1<<  &ETHTOOL_F_UNSUPPORTED__BIT);}' unless defined(&ETHTOOL_F_UNSUPPORTED);
    eval 'sub ETHTOOL_F_WISH () {(1<<  &ETHTOOL_F_WISH__BIT);}' unless defined(&ETHTOOL_F_WISH);
    eval 'sub ETHTOOL_F_COMPAT () {(1<<  &ETHTOOL_F_COMPAT__BIT);}' unless defined(&ETHTOOL_F_COMPAT);
    eval 'sub MAX_NUM_QUEUE () {4096;}' unless defined(&MAX_NUM_QUEUE);
    eval("sub ETHTOOL_FEC_NONE_BIT () { 0; }") unless defined(&ETHTOOL_FEC_NONE_BIT);
    eval("sub ETHTOOL_FEC_AUTO_BIT () { 1; }") unless defined(&ETHTOOL_FEC_AUTO_BIT);
    eval("sub ETHTOOL_FEC_OFF_BIT () { 2; }") unless defined(&ETHTOOL_FEC_OFF_BIT);
    eval("sub ETHTOOL_FEC_RS_BIT () { 3; }") unless defined(&ETHTOOL_FEC_RS_BIT);
    eval("sub ETHTOOL_FEC_BASER_BIT () { 4; }") unless defined(&ETHTOOL_FEC_BASER_BIT);
    eval 'sub ETHTOOL_FEC_NONE () {(1<<  &ETHTOOL_FEC_NONE_BIT);}' unless defined(&ETHTOOL_FEC_NONE);
    eval 'sub ETHTOOL_FEC_AUTO () {(1<<  &ETHTOOL_FEC_AUTO_BIT);}' unless defined(&ETHTOOL_FEC_AUTO);
    eval 'sub ETHTOOL_FEC_OFF () {(1<<  &ETHTOOL_FEC_OFF_BIT);}' unless defined(&ETHTOOL_FEC_OFF);
    eval 'sub ETHTOOL_FEC_RS () {(1<<  &ETHTOOL_FEC_RS_BIT);}' unless defined(&ETHTOOL_FEC_RS);
    eval 'sub ETHTOOL_FEC_BASER () {(1<<  &ETHTOOL_FEC_BASER_BIT);}' unless defined(&ETHTOOL_FEC_BASER);
    eval 'sub ETHTOOL_GSET () {0x1;}' unless defined(&ETHTOOL_GSET);
    eval 'sub ETHTOOL_SSET () {0x2;}' unless defined(&ETHTOOL_SSET);
    eval 'sub ETHTOOL_GDRVINFO () {0x3;}' unless defined(&ETHTOOL_GDRVINFO);
    eval 'sub ETHTOOL_GREGS () {0x4;}' unless defined(&ETHTOOL_GREGS);
    eval 'sub ETHTOOL_GWOL () {0x5;}' unless defined(&ETHTOOL_GWOL);
    eval 'sub ETHTOOL_SWOL () {0x6;}' unless defined(&ETHTOOL_SWOL);
    eval 'sub ETHTOOL_GMSGLVL () {0x7;}' unless defined(&ETHTOOL_GMSGLVL);
    eval 'sub ETHTOOL_SMSGLVL () {0x8;}' unless defined(&ETHTOOL_SMSGLVL);
    eval 'sub ETHTOOL_NWAY_RST () {0x9;}' unless defined(&ETHTOOL_NWAY_RST);
    eval 'sub ETHTOOL_GLINK () {0xa;}' unless defined(&ETHTOOL_GLINK);
    eval 'sub ETHTOOL_GEEPROM () {0xb;}' unless defined(&ETHTOOL_GEEPROM);
    eval 'sub ETHTOOL_SEEPROM () {0xc;}' unless defined(&ETHTOOL_SEEPROM);
    eval 'sub ETHTOOL_GCOALESCE () {0xe;}' unless defined(&ETHTOOL_GCOALESCE);
    eval 'sub ETHTOOL_SCOALESCE () {0xf;}' unless defined(&ETHTOOL_SCOALESCE);
    eval 'sub ETHTOOL_GRINGPARAM () {0x10;}' unless defined(&ETHTOOL_GRINGPARAM);
    eval 'sub ETHTOOL_SRINGPARAM () {0x11;}' unless defined(&ETHTOOL_SRINGPARAM);
    eval 'sub ETHTOOL_GPAUSEPARAM () {0x12;}' unless defined(&ETHTOOL_GPAUSEPARAM);
    eval 'sub ETHTOOL_SPAUSEPARAM () {0x13;}' unless defined(&ETHTOOL_SPAUSEPARAM);
    eval 'sub ETHTOOL_GRXCSUM () {0x14;}' unless defined(&ETHTOOL_GRXCSUM);
    eval 'sub ETHTOOL_SRXCSUM () {0x15;}' unless defined(&ETHTOOL_SRXCSUM);
    eval 'sub ETHTOOL_GTXCSUM () {0x16;}' unless defined(&ETHTOOL_GTXCSUM);
    eval 'sub ETHTOOL_STXCSUM () {0x17;}' unless defined(&ETHTOOL_STXCSUM);
    eval 'sub ETHTOOL_GSG () {0x18;}' unless defined(&ETHTOOL_GSG);
    eval 'sub ETHTOOL_SSG () {0x19;}' unless defined(&ETHTOOL_SSG);
    eval 'sub ETHTOOL_TEST () {0x1a;}' unless defined(&ETHTOOL_TEST);
    eval 'sub ETHTOOL_GSTRINGS () {0x1b;}' unless defined(&ETHTOOL_GSTRINGS);
    eval 'sub ETHTOOL_PHYS_ID () {0x1c;}' unless defined(&ETHTOOL_PHYS_ID);
    eval 'sub ETHTOOL_GSTATS () {0x1d;}' unless defined(&ETHTOOL_GSTATS);
    eval 'sub ETHTOOL_GTSO () {0x1e;}' unless defined(&ETHTOOL_GTSO);
    eval 'sub ETHTOOL_STSO () {0x1f;}' unless defined(&ETHTOOL_STSO);
    eval 'sub ETHTOOL_GPERMADDR () {0x20;}' unless defined(&ETHTOOL_GPERMADDR);
    eval 'sub ETHTOOL_GUFO () {0x21;}' unless defined(&ETHTOOL_GUFO);
    eval 'sub ETHTOOL_SUFO () {0x22;}' unless defined(&ETHTOOL_SUFO);
    eval 'sub ETHTOOL_GGSO () {0x23;}' unless defined(&ETHTOOL_GGSO);
    eval 'sub ETHTOOL_SGSO () {0x24;}' unless defined(&ETHTOOL_SGSO);
    eval 'sub ETHTOOL_GFLAGS () {0x25;}' unless defined(&ETHTOOL_GFLAGS);
    eval 'sub ETHTOOL_SFLAGS () {0x26;}' unless defined(&ETHTOOL_SFLAGS);
    eval 'sub ETHTOOL_GPFLAGS () {0x27;}' unless defined(&ETHTOOL_GPFLAGS);
    eval 'sub ETHTOOL_SPFLAGS () {0x28;}' unless defined(&ETHTOOL_SPFLAGS);
    eval 'sub ETHTOOL_GRXFH () {0x29;}' unless defined(&ETHTOOL_GRXFH);
    eval 'sub ETHTOOL_SRXFH () {0x2a;}' unless defined(&ETHTOOL_SRXFH);
    eval 'sub ETHTOOL_GGRO () {0x2b;}' unless defined(&ETHTOOL_GGRO);
    eval 'sub ETHTOOL_SGRO () {0x2c;}' unless defined(&ETHTOOL_SGRO);
    eval 'sub ETHTOOL_GRXRINGS () {0x2d;}' unless defined(&ETHTOOL_GRXRINGS);
    eval 'sub ETHTOOL_GRXCLSRLCNT () {0x2e;}' unless defined(&ETHTOOL_GRXCLSRLCNT);
    eval 'sub ETHTOOL_GRXCLSRULE () {0x2f;}' unless defined(&ETHTOOL_GRXCLSRULE);
    eval 'sub ETHTOOL_GRXCLSRLALL () {0x30;}' unless defined(&ETHTOOL_GRXCLSRLALL);
    eval 'sub ETHTOOL_SRXCLSRLDEL () {0x31;}' unless defined(&ETHTOOL_SRXCLSRLDEL);
    eval 'sub ETHTOOL_SRXCLSRLINS () {0x32;}' unless defined(&ETHTOOL_SRXCLSRLINS);
    eval 'sub ETHTOOL_FLASHDEV () {0x33;}' unless defined(&ETHTOOL_FLASHDEV);
    eval 'sub ETHTOOL_RESET () {0x34;}' unless defined(&ETHTOOL_RESET);
    eval 'sub ETHTOOL_SRXNTUPLE () {0x35;}' unless defined(&ETHTOOL_SRXNTUPLE);
    eval 'sub ETHTOOL_GRXNTUPLE () {0x36;}' unless defined(&ETHTOOL_GRXNTUPLE);
    eval 'sub ETHTOOL_GSSET_INFO () {0x37;}' unless defined(&ETHTOOL_GSSET_INFO);
    eval 'sub ETHTOOL_GRXFHINDIR () {0x38;}' unless defined(&ETHTOOL_GRXFHINDIR);
    eval 'sub ETHTOOL_SRXFHINDIR () {0x39;}' unless defined(&ETHTOOL_SRXFHINDIR);
    eval 'sub ETHTOOL_GFEATURES () {0x3a;}' unless defined(&ETHTOOL_GFEATURES);
    eval 'sub ETHTOOL_SFEATURES () {0x3b;}' unless defined(&ETHTOOL_SFEATURES);
    eval 'sub ETHTOOL_GCHANNELS () {0x3c;}' unless defined(&ETHTOOL_GCHANNELS);
    eval 'sub ETHTOOL_SCHANNELS () {0x3d;}' unless defined(&ETHTOOL_SCHANNELS);
    eval 'sub ETHTOOL_SET_DUMP () {0x3e;}' unless defined(&ETHTOOL_SET_DUMP);
    eval 'sub ETHTOOL_GET_DUMP_FLAG () {0x3f;}' unless defined(&ETHTOOL_GET_DUMP_FLAG);
    eval 'sub ETHTOOL_GET_DUMP_DATA () {0x40;}' unless defined(&ETHTOOL_GET_DUMP_DATA);
    eval 'sub ETHTOOL_GET_TS_INFO () {0x41;}' unless defined(&ETHTOOL_GET_TS_INFO);
    eval 'sub ETHTOOL_GMODULEINFO () {0x42;}' unless defined(&ETHTOOL_GMODULEINFO);
    eval 'sub ETHTOOL_GMODULEEEPROM () {0x43;}' unless defined(&ETHTOOL_GMODULEEEPROM);
    eval 'sub ETHTOOL_GEEE () {0x44;}' unless defined(&ETHTOOL_GEEE);
    eval 'sub ETHTOOL_SEEE () {0x45;}' unless defined(&ETHTOOL_SEEE);
    eval 'sub ETHTOOL_GRSSH () {0x46;}' unless defined(&ETHTOOL_GRSSH);
    eval 'sub ETHTOOL_SRSSH () {0x47;}' unless defined(&ETHTOOL_SRSSH);
    eval 'sub ETHTOOL_GTUNABLE () {0x48;}' unless defined(&ETHTOOL_GTUNABLE);
    eval 'sub ETHTOOL_STUNABLE () {0x49;}' unless defined(&ETHTOOL_STUNABLE);
    eval 'sub ETHTOOL_GPHYSTATS () {0x4a;}' unless defined(&ETHTOOL_GPHYSTATS);
    eval 'sub ETHTOOL_PERQUEUE () {0x4b;}' unless defined(&ETHTOOL_PERQUEUE);
    eval 'sub ETHTOOL_GLINKSETTINGS () {0x4c;}' unless defined(&ETHTOOL_GLINKSETTINGS);
    eval 'sub ETHTOOL_SLINKSETTINGS () {0x4d;}' unless defined(&ETHTOOL_SLINKSETTINGS);
    eval 'sub ETHTOOL_PHY_GTUNABLE () {0x4e;}' unless defined(&ETHTOOL_PHY_GTUNABLE);
    eval 'sub ETHTOOL_PHY_STUNABLE () {0x4f;}' unless defined(&ETHTOOL_PHY_STUNABLE);
    eval 'sub ETHTOOL_GFECPARAM () {0x50;}' unless defined(&ETHTOOL_GFECPARAM);
    eval 'sub ETHTOOL_SFECPARAM () {0x51;}' unless defined(&ETHTOOL_SFECPARAM);
    eval 'sub SPARC_ETH_GSET () { &ETHTOOL_GSET;}' unless defined(&SPARC_ETH_GSET);
    eval 'sub SPARC_ETH_SSET () { &ETHTOOL_SSET;}' unless defined(&SPARC_ETH_SSET);
    eval("sub ETHTOOL_LINK_MODE_10baseT_Half_BIT () { 0; }") unless defined(&ETHTOOL_LINK_MODE_10baseT_Half_BIT);
    eval("sub ETHTOOL_LINK_MODE_10baseT_Full_BIT () { 1; }") unless defined(&ETHTOOL_LINK_MODE_10baseT_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100baseT_Half_BIT () { 2; }") unless defined(&ETHTOOL_LINK_MODE_100baseT_Half_BIT);
    eval("sub ETHTOOL_LINK_MODE_100baseT_Full_BIT () { 3; }") unless defined(&ETHTOOL_LINK_MODE_100baseT_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_1000baseT_Half_BIT () { 4; }") unless defined(&ETHTOOL_LINK_MODE_1000baseT_Half_BIT);
    eval("sub ETHTOOL_LINK_MODE_1000baseT_Full_BIT () { 5; }") unless defined(&ETHTOOL_LINK_MODE_1000baseT_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_Autoneg_BIT () { 6; }") unless defined(&ETHTOOL_LINK_MODE_Autoneg_BIT);
    eval("sub ETHTOOL_LINK_MODE_TP_BIT () { 7; }") unless defined(&ETHTOOL_LINK_MODE_TP_BIT);
    eval("sub ETHTOOL_LINK_MODE_AUI_BIT () { 8; }") unless defined(&ETHTOOL_LINK_MODE_AUI_BIT);
    eval("sub ETHTOOL_LINK_MODE_MII_BIT () { 9; }") unless defined(&ETHTOOL_LINK_MODE_MII_BIT);
    eval("sub ETHTOOL_LINK_MODE_FIBRE_BIT () { 10; }") unless defined(&ETHTOOL_LINK_MODE_FIBRE_BIT);
    eval("sub ETHTOOL_LINK_MODE_BNC_BIT () { 11; }") unless defined(&ETHTOOL_LINK_MODE_BNC_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseT_Full_BIT () { 12; }") unless defined(&ETHTOOL_LINK_MODE_10000baseT_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_Pause_BIT () { 13; }") unless defined(&ETHTOOL_LINK_MODE_Pause_BIT);
    eval("sub ETHTOOL_LINK_MODE_Asym_Pause_BIT () { 14; }") unless defined(&ETHTOOL_LINK_MODE_Asym_Pause_BIT);
    eval("sub ETHTOOL_LINK_MODE_2500baseX_Full_BIT () { 15; }") unless defined(&ETHTOOL_LINK_MODE_2500baseX_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_Backplane_BIT () { 16; }") unless defined(&ETHTOOL_LINK_MODE_Backplane_BIT);
    eval("sub ETHTOOL_LINK_MODE_1000baseKX_Full_BIT () { 17; }") unless defined(&ETHTOOL_LINK_MODE_1000baseKX_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT () { 18; }") unless defined(&ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseKR_Full_BIT () { 19; }") unless defined(&ETHTOOL_LINK_MODE_10000baseKR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseR_FEC_BIT () { 20; }") unless defined(&ETHTOOL_LINK_MODE_10000baseR_FEC_BIT);
    eval("sub ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT () { 21; }") unless defined(&ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT () { 22; }") unless defined(&ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT () { 23; }") unless defined(&ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT () { 24; }") unless defined(&ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT () { 25; }") unless defined(&ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT () { 26; }") unless defined(&ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT () { 27; }") unless defined(&ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT () { 28; }") unless defined(&ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT () { 29; }") unless defined(&ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT () { 30; }") unless defined(&ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_25000baseCR_Full_BIT () { 31; }") unless defined(&ETHTOOL_LINK_MODE_25000baseCR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_25000baseKR_Full_BIT () { 32; }") unless defined(&ETHTOOL_LINK_MODE_25000baseKR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_25000baseSR_Full_BIT () { 33; }") unless defined(&ETHTOOL_LINK_MODE_25000baseSR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT () { 34; }") unless defined(&ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT () { 35; }") unless defined(&ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT () { 36; }") unless defined(&ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT () { 37; }") unless defined(&ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT () { 38; }") unless defined(&ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT () { 39; }") unless defined(&ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT () { 40; }") unless defined(&ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_1000baseX_Full_BIT () { 41; }") unless defined(&ETHTOOL_LINK_MODE_1000baseX_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseCR_Full_BIT () { 42; }") unless defined(&ETHTOOL_LINK_MODE_10000baseCR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseSR_Full_BIT () { 43; }") unless defined(&ETHTOOL_LINK_MODE_10000baseSR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseLR_Full_BIT () { 44; }") unless defined(&ETHTOOL_LINK_MODE_10000baseLR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT () { 45; }") unless defined(&ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_10000baseER_Full_BIT () { 46; }") unless defined(&ETHTOOL_LINK_MODE_10000baseER_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_2500baseT_Full_BIT () { 47; }") unless defined(&ETHTOOL_LINK_MODE_2500baseT_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_5000baseT_Full_BIT () { 48; }") unless defined(&ETHTOOL_LINK_MODE_5000baseT_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_FEC_NONE_BIT () { 49; }") unless defined(&ETHTOOL_LINK_MODE_FEC_NONE_BIT);
    eval("sub ETHTOOL_LINK_MODE_FEC_RS_BIT () { 50; }") unless defined(&ETHTOOL_LINK_MODE_FEC_RS_BIT);
    eval("sub ETHTOOL_LINK_MODE_FEC_BASER_BIT () { 51; }") unless defined(&ETHTOOL_LINK_MODE_FEC_BASER_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseKR_Full_BIT () { 52; }") unless defined(&ETHTOOL_LINK_MODE_50000baseKR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseSR_Full_BIT () { 53; }") unless defined(&ETHTOOL_LINK_MODE_50000baseSR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseCR_Full_BIT () { 54; }") unless defined(&ETHTOOL_LINK_MODE_50000baseCR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT () { 55; }") unless defined(&ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_50000baseDR_Full_BIT () { 56; }") unless defined(&ETHTOOL_LINK_MODE_50000baseDR_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT () { 57; }") unless defined(&ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT () { 58; }") unless defined(&ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT () { 59; }") unless defined(&ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT () { 60; }") unless defined(&ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT () { 61; }") unless defined(&ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT () { 62; }") unless defined(&ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT () { 63; }") unless defined(&ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT () { 64; }") unless defined(&ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT () { 65; }") unless defined(&ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT () { 66; }") unless defined(&ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_100baseT1_Full_BIT () { 67; }") unless defined(&ETHTOOL_LINK_MODE_100baseT1_Full_BIT);
    eval("sub ETHTOOL_LINK_MODE_1000baseT1_Full_BIT () { 68; }") unless defined(&ETHTOOL_LINK_MODE_1000baseT1_Full_BIT);
    eval("sub __ETHTOOL_LINK_MODE_MASK_NBITS () { 69; }") unless defined(&__ETHTOOL_LINK_MODE_MASK_NBITS);
    eval 'sub __ETHTOOL_LINK_MODE_LEGACY_MASK {
        my($base_name) = @_;
	    eval q((1 << ( &ETHTOOL_LINK_MODE_  $base_name   &_BIT)));
    }' unless defined(&__ETHTOOL_LINK_MODE_LEGACY_MASK);
    eval 'sub SUPPORTED_10baseT_Half () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10 &baseT_Half);}' unless defined(&SUPPORTED_10baseT_Half);
    eval 'sub SUPPORTED_10baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10 &baseT_Full);}' unless defined(&SUPPORTED_10baseT_Full);
    eval 'sub SUPPORTED_100baseT_Half () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(100 &baseT_Half);}' unless defined(&SUPPORTED_100baseT_Half);
    eval 'sub SUPPORTED_100baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(100 &baseT_Full);}' unless defined(&SUPPORTED_100baseT_Full);
    eval 'sub SUPPORTED_1000baseT_Half () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(1000 &baseT_Half);}' unless defined(&SUPPORTED_1000baseT_Half);
    eval 'sub SUPPORTED_1000baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(1000 &baseT_Full);}' unless defined(&SUPPORTED_1000baseT_Full);
    eval 'sub SUPPORTED_Autoneg () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Autoneg);}' unless defined(&SUPPORTED_Autoneg);
    eval 'sub SUPPORTED_TP () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &TP);}' unless defined(&SUPPORTED_TP);
    eval 'sub SUPPORTED_AUI () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &AUI);}' unless defined(&SUPPORTED_AUI);
    eval 'sub SUPPORTED_MII () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &MII);}' unless defined(&SUPPORTED_MII);
    eval 'sub SUPPORTED_FIBRE () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &FIBRE);}' unless defined(&SUPPORTED_FIBRE);
    eval 'sub SUPPORTED_BNC () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &BNC);}' unless defined(&SUPPORTED_BNC);
    eval 'sub SUPPORTED_10000baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseT_Full);}' unless defined(&SUPPORTED_10000baseT_Full);
    eval 'sub SUPPORTED_Pause () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Pause);}' unless defined(&SUPPORTED_Pause);
    eval 'sub SUPPORTED_Asym_Pause () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Asym_Pause);}' unless defined(&SUPPORTED_Asym_Pause);
    eval 'sub SUPPORTED_2500baseX_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(2500 &baseX_Full);}' unless defined(&SUPPORTED_2500baseX_Full);
    eval 'sub SUPPORTED_Backplane () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Backplane);}' unless defined(&SUPPORTED_Backplane);
    eval 'sub SUPPORTED_1000baseKX_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(1000 &baseKX_Full);}' unless defined(&SUPPORTED_1000baseKX_Full);
    eval 'sub SUPPORTED_10000baseKX4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseKX4_Full);}' unless defined(&SUPPORTED_10000baseKX4_Full);
    eval 'sub SUPPORTED_10000baseKR_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseKR_Full);}' unless defined(&SUPPORTED_10000baseKR_Full);
    eval 'sub SUPPORTED_10000baseR_FEC () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseR_FEC);}' unless defined(&SUPPORTED_10000baseR_FEC);
    eval 'sub SUPPORTED_20000baseMLD2_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(20000 &baseMLD2_Full);}' unless defined(&SUPPORTED_20000baseMLD2_Full);
    eval 'sub SUPPORTED_20000baseKR2_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(20000 &baseKR2_Full);}' unless defined(&SUPPORTED_20000baseKR2_Full);
    eval 'sub SUPPORTED_40000baseKR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseKR4_Full);}' unless defined(&SUPPORTED_40000baseKR4_Full);
    eval 'sub SUPPORTED_40000baseCR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseCR4_Full);}' unless defined(&SUPPORTED_40000baseCR4_Full);
    eval 'sub SUPPORTED_40000baseSR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseSR4_Full);}' unless defined(&SUPPORTED_40000baseSR4_Full);
    eval 'sub SUPPORTED_40000baseLR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseLR4_Full);}' unless defined(&SUPPORTED_40000baseLR4_Full);
    eval 'sub SUPPORTED_56000baseKR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseKR4_Full);}' unless defined(&SUPPORTED_56000baseKR4_Full);
    eval 'sub SUPPORTED_56000baseCR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseCR4_Full);}' unless defined(&SUPPORTED_56000baseCR4_Full);
    eval 'sub SUPPORTED_56000baseSR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseSR4_Full);}' unless defined(&SUPPORTED_56000baseSR4_Full);
    eval 'sub SUPPORTED_56000baseLR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseLR4_Full);}' unless defined(&SUPPORTED_56000baseLR4_Full);
    eval 'sub ADVERTISED_10baseT_Half () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10 &baseT_Half);}' unless defined(&ADVERTISED_10baseT_Half);
    eval 'sub ADVERTISED_10baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10 &baseT_Full);}' unless defined(&ADVERTISED_10baseT_Full);
    eval 'sub ADVERTISED_100baseT_Half () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(100 &baseT_Half);}' unless defined(&ADVERTISED_100baseT_Half);
    eval 'sub ADVERTISED_100baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(100 &baseT_Full);}' unless defined(&ADVERTISED_100baseT_Full);
    eval 'sub ADVERTISED_1000baseT_Half () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(1000 &baseT_Half);}' unless defined(&ADVERTISED_1000baseT_Half);
    eval 'sub ADVERTISED_1000baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(1000 &baseT_Full);}' unless defined(&ADVERTISED_1000baseT_Full);
    eval 'sub ADVERTISED_Autoneg () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Autoneg);}' unless defined(&ADVERTISED_Autoneg);
    eval 'sub ADVERTISED_TP () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &TP);}' unless defined(&ADVERTISED_TP);
    eval 'sub ADVERTISED_AUI () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &AUI);}' unless defined(&ADVERTISED_AUI);
    eval 'sub ADVERTISED_MII () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &MII);}' unless defined(&ADVERTISED_MII);
    eval 'sub ADVERTISED_FIBRE () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &FIBRE);}' unless defined(&ADVERTISED_FIBRE);
    eval 'sub ADVERTISED_BNC () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &BNC);}' unless defined(&ADVERTISED_BNC);
    eval 'sub ADVERTISED_10000baseT_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseT_Full);}' unless defined(&ADVERTISED_10000baseT_Full);
    eval 'sub ADVERTISED_Pause () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Pause);}' unless defined(&ADVERTISED_Pause);
    eval 'sub ADVERTISED_Asym_Pause () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Asym_Pause);}' unless defined(&ADVERTISED_Asym_Pause);
    eval 'sub ADVERTISED_2500baseX_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(2500 &baseX_Full);}' unless defined(&ADVERTISED_2500baseX_Full);
    eval 'sub ADVERTISED_Backplane () { &__ETHTOOL_LINK_MODE_LEGACY_MASK( &Backplane);}' unless defined(&ADVERTISED_Backplane);
    eval 'sub ADVERTISED_1000baseKX_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(1000 &baseKX_Full);}' unless defined(&ADVERTISED_1000baseKX_Full);
    eval 'sub ADVERTISED_10000baseKX4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseKX4_Full);}' unless defined(&ADVERTISED_10000baseKX4_Full);
    eval 'sub ADVERTISED_10000baseKR_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseKR_Full);}' unless defined(&ADVERTISED_10000baseKR_Full);
    eval 'sub ADVERTISED_10000baseR_FEC () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(10000 &baseR_FEC);}' unless defined(&ADVERTISED_10000baseR_FEC);
    eval 'sub ADVERTISED_20000baseMLD2_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(20000 &baseMLD2_Full);}' unless defined(&ADVERTISED_20000baseMLD2_Full);
    eval 'sub ADVERTISED_20000baseKR2_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(20000 &baseKR2_Full);}' unless defined(&ADVERTISED_20000baseKR2_Full);
    eval 'sub ADVERTISED_40000baseKR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseKR4_Full);}' unless defined(&ADVERTISED_40000baseKR4_Full);
    eval 'sub ADVERTISED_40000baseCR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseCR4_Full);}' unless defined(&ADVERTISED_40000baseCR4_Full);
    eval 'sub ADVERTISED_40000baseSR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseSR4_Full);}' unless defined(&ADVERTISED_40000baseSR4_Full);
    eval 'sub ADVERTISED_40000baseLR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(40000 &baseLR4_Full);}' unless defined(&ADVERTISED_40000baseLR4_Full);
    eval 'sub ADVERTISED_56000baseKR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseKR4_Full);}' unless defined(&ADVERTISED_56000baseKR4_Full);
    eval 'sub ADVERTISED_56000baseCR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseCR4_Full);}' unless defined(&ADVERTISED_56000baseCR4_Full);
    eval 'sub ADVERTISED_56000baseSR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseSR4_Full);}' unless defined(&ADVERTISED_56000baseSR4_Full);
    eval 'sub ADVERTISED_56000baseLR4_Full () { &__ETHTOOL_LINK_MODE_LEGACY_MASK(56000 &baseLR4_Full);}' unless defined(&ADVERTISED_56000baseLR4_Full);
    eval 'sub SPEED_10 () {10;}' unless defined(&SPEED_10);
    eval 'sub SPEED_100 () {100;}' unless defined(&SPEED_100);
    eval 'sub SPEED_1000 () {1000;}' unless defined(&SPEED_1000);
    eval 'sub SPEED_2500 () {2500;}' unless defined(&SPEED_2500);
    eval 'sub SPEED_5000 () {5000;}' unless defined(&SPEED_5000);
    eval 'sub SPEED_10000 () {10000;}' unless defined(&SPEED_10000);
    eval 'sub SPEED_14000 () {14000;}' unless defined(&SPEED_14000);
    eval 'sub SPEED_20000 () {20000;}' unless defined(&SPEED_20000);
    eval 'sub SPEED_25000 () {25000;}' unless defined(&SPEED_25000);
    eval 'sub SPEED_40000 () {40000;}' unless defined(&SPEED_40000);
    eval 'sub SPEED_50000 () {50000;}' unless defined(&SPEED_50000);
    eval 'sub SPEED_56000 () {56000;}' unless defined(&SPEED_56000);
    eval 'sub SPEED_100000 () {100000;}' unless defined(&SPEED_100000);
    eval 'sub SPEED_200000 () {200000;}' unless defined(&SPEED_200000);
    eval 'sub SPEED_UNKNOWN () {-1;}' unless defined(&SPEED_UNKNOWN);
    eval 'sub ethtool_validate_speed {
        my($speed) = @_;
	    eval q({ $speed <=  &INT_MAX || $speed == ( &__u32) &SPEED_UNKNOWN; });
    }' unless defined(&ethtool_validate_speed);
    eval 'sub DUPLEX_HALF () {0x;}' unless defined(&DUPLEX_HALF);
    eval 'sub DUPLEX_FULL () {0x1;}' unless defined(&DUPLEX_FULL);
    eval 'sub DUPLEX_UNKNOWN () {0xff;}' unless defined(&DUPLEX_UNKNOWN);
    eval 'sub ethtool_validate_duplex {
        my($duplex) = @_;
	    eval q({  &switch ($duplex) {  &case  &DUPLEX_HALF:  &case  &DUPLEX_FULL:  &case  &DUPLEX_UNKNOWN: 1; } 0; });
    }' unless defined(&ethtool_validate_duplex);
    eval 'sub PORT_TP () {0x;}' unless defined(&PORT_TP);
    eval 'sub PORT_AUI () {0x1;}' unless defined(&PORT_AUI);
    eval 'sub PORT_MII () {0x2;}' unless defined(&PORT_MII);
    eval 'sub PORT_FIBRE () {0x3;}' unless defined(&PORT_FIBRE);
    eval 'sub PORT_BNC () {0x4;}' unless defined(&PORT_BNC);
    eval 'sub PORT_DA () {0x5;}' unless defined(&PORT_DA);
    eval 'sub PORT_NONE () {0xef;}' unless defined(&PORT_NONE);
    eval 'sub PORT_OTHER () {0xff;}' unless defined(&PORT_OTHER);
    eval 'sub XCVR_INTERNAL () {0x;}' unless defined(&XCVR_INTERNAL);
    eval 'sub XCVR_EXTERNAL () {0x1;}' unless defined(&XCVR_EXTERNAL);
    eval 'sub XCVR_DUMMY1 () {0x2;}' unless defined(&XCVR_DUMMY1);
    eval 'sub XCVR_DUMMY2 () {0x3;}' unless defined(&XCVR_DUMMY2);
    eval 'sub XCVR_DUMMY3 () {0x4;}' unless defined(&XCVR_DUMMY3);
    eval 'sub AUTONEG_DISABLE () {0x;}' unless defined(&AUTONEG_DISABLE);
    eval 'sub AUTONEG_ENABLE () {0x1;}' unless defined(&AUTONEG_ENABLE);
    eval 'sub ETH_TP_MDI_INVALID () {0x;}' unless defined(&ETH_TP_MDI_INVALID);
    eval 'sub ETH_TP_MDI () {0x1;}' unless defined(&ETH_TP_MDI);
    eval 'sub ETH_TP_MDI_X () {0x2;}' unless defined(&ETH_TP_MDI_X);
    eval 'sub ETH_TP_MDI_AUTO () {0x3;}' unless defined(&ETH_TP_MDI_AUTO);
    eval 'sub WAKE_PHY () {(1<< 0);}' unless defined(&WAKE_PHY);
    eval 'sub WAKE_UCAST () {(1<< 1);}' unless defined(&WAKE_UCAST);
    eval 'sub WAKE_MCAST () {(1<< 2);}' unless defined(&WAKE_MCAST);
    eval 'sub WAKE_BCAST () {(1<< 3);}' unless defined(&WAKE_BCAST);
    eval 'sub WAKE_ARP () {(1<< 4);}' unless defined(&WAKE_ARP);
    eval 'sub WAKE_MAGIC () {(1<< 5);}' unless defined(&WAKE_MAGIC);
    eval 'sub WAKE_MAGICSECURE () {(1<< 6);}' unless defined(&WAKE_MAGICSECURE);
    eval 'sub WAKE_FILTER () {(1<< 7);}' unless defined(&WAKE_FILTER);
    eval 'sub TCP_V4_FLOW () {0x1;}' unless defined(&TCP_V4_FLOW);
    eval 'sub UDP_V4_FLOW () {0x2;}' unless defined(&UDP_V4_FLOW);
    eval 'sub SCTP_V4_FLOW () {0x3;}' unless defined(&SCTP_V4_FLOW);
    eval 'sub AH_ESP_V4_FLOW () {0x4;}' unless defined(&AH_ESP_V4_FLOW);
    eval 'sub TCP_V6_FLOW () {0x5;}' unless defined(&TCP_V6_FLOW);
    eval 'sub UDP_V6_FLOW () {0x6;}' unless defined(&UDP_V6_FLOW);
    eval 'sub SCTP_V6_FLOW () {0x7;}' unless defined(&SCTP_V6_FLOW);
    eval 'sub AH_ESP_V6_FLOW () {0x8;}' unless defined(&AH_ESP_V6_FLOW);
    eval 'sub AH_V4_FLOW () {0x9;}' unless defined(&AH_V4_FLOW);
    eval 'sub ESP_V4_FLOW () {0xa;}' unless defined(&ESP_V4_FLOW);
    eval 'sub AH_V6_FLOW () {0xb;}' unless defined(&AH_V6_FLOW);
    eval 'sub ESP_V6_FLOW () {0xc;}' unless defined(&ESP_V6_FLOW);
    eval 'sub IPV4_USER_FLOW () {0xd;}' unless defined(&IPV4_USER_FLOW);
    eval 'sub IP_USER_FLOW () { &IPV4_USER_FLOW;}' unless defined(&IP_USER_FLOW);
    eval 'sub IPV6_USER_FLOW () {0xe;}' unless defined(&IPV6_USER_FLOW);
    eval 'sub IPV4_FLOW () {0x10;}' unless defined(&IPV4_FLOW);
    eval 'sub IPV6_FLOW () {0x11;}' unless defined(&IPV6_FLOW);
    eval 'sub ETHER_FLOW () {0x12;}' unless defined(&ETHER_FLOW);
    eval 'sub FLOW_EXT () {0x80000000;}' unless defined(&FLOW_EXT);
    eval 'sub FLOW_MAC_EXT () {0x40000000;}' unless defined(&FLOW_MAC_EXT);
    eval 'sub FLOW_RSS () {0x20000000;}' unless defined(&FLOW_RSS);
    eval 'sub RXH_L2DA () {(1<< 1);}' unless defined(&RXH_L2DA);
    eval 'sub RXH_VLAN () {(1<< 2);}' unless defined(&RXH_VLAN);
    eval 'sub RXH_L3_PROTO () {(1<< 3);}' unless defined(&RXH_L3_PROTO);
    eval 'sub RXH_IP_SRC () {(1<< 4);}' unless defined(&RXH_IP_SRC);
    eval 'sub RXH_IP_DST () {(1<< 5);}' unless defined(&RXH_IP_DST);
    eval 'sub RXH_L4_B_0_1 () {(1<< 6);}' unless defined(&RXH_L4_B_0_1);
    eval 'sub RXH_L4_B_2_3 () {(1<< 7);}' unless defined(&RXH_L4_B_2_3);
    eval 'sub RXH_DISCARD () {(1<< 31);}' unless defined(&RXH_DISCARD);
    eval 'sub RX_CLS_FLOW_DISC () {1.84467440737096e+19;}' unless defined(&RX_CLS_FLOW_DISC);
    eval 'sub RX_CLS_FLOW_WAKE () {1.84467440737096e+19;}' unless defined(&RX_CLS_FLOW_WAKE);
    eval 'sub RX_CLS_LOC_SPECIAL () {0x80000000;}' unless defined(&RX_CLS_LOC_SPECIAL);
    eval 'sub RX_CLS_LOC_ANY () {0xffffffff;}' unless defined(&RX_CLS_LOC_ANY);
    eval 'sub RX_CLS_LOC_FIRST () {0xfffffffe;}' unless defined(&RX_CLS_LOC_FIRST);
    eval 'sub RX_CLS_LOC_LAST () {0xfffffffd;}' unless defined(&RX_CLS_LOC_LAST);
    eval 'sub ETH_MODULE_SFF_8079 () {0x1;}' unless defined(&ETH_MODULE_SFF_8079);
    eval 'sub ETH_MODULE_SFF_8079_LEN () {256;}' unless defined(&ETH_MODULE_SFF_8079_LEN);
    eval 'sub ETH_MODULE_SFF_8472 () {0x2;}' unless defined(&ETH_MODULE_SFF_8472);
    eval 'sub ETH_MODULE_SFF_8472_LEN () {512;}' unless defined(&ETH_MODULE_SFF_8472_LEN);
    eval 'sub ETH_MODULE_SFF_8636 () {0x3;}' unless defined(&ETH_MODULE_SFF_8636);
    eval 'sub ETH_MODULE_SFF_8636_LEN () {256;}' unless defined(&ETH_MODULE_SFF_8636_LEN);
    eval 'sub ETH_MODULE_SFF_8436 () {0x4;}' unless defined(&ETH_MODULE_SFF_8436);
    eval 'sub ETH_MODULE_SFF_8436_LEN () {256;}' unless defined(&ETH_MODULE_SFF_8436_LEN);
    eval 'sub ETH_MODULE_SFF_8636_MAX_LEN () {640;}' unless defined(&ETH_MODULE_SFF_8636_MAX_LEN);
    eval 'sub ETH_MODULE_SFF_8436_MAX_LEN () {640;}' unless defined(&ETH_MODULE_SFF_8436_MAX_LEN);
    eval("sub ETH_RESET_MGMT () { 1<<0; }") unless defined(&ETH_RESET_MGMT);
    eval("sub ETH_RESET_IRQ () { 1<<1; }") unless defined(&ETH_RESET_IRQ);
    eval("sub ETH_RESET_DMA () { 1<<2; }") unless defined(&ETH_RESET_DMA);
    eval("sub ETH_RESET_FILTER () { 1<<3; }") unless defined(&ETH_RESET_FILTER);
    eval("sub ETH_RESET_OFFLOAD () { 1<<4; }") unless defined(&ETH_RESET_OFFLOAD);
    eval("sub ETH_RESET_MAC () { 1<<5; }") unless defined(&ETH_RESET_MAC);
    eval("sub ETH_RESET_PHY () { 1<<6; }") unless defined(&ETH_RESET_PHY);
    eval("sub ETH_RESET_RAM () { 1<<7; }") unless defined(&ETH_RESET_RAM);
    eval("sub ETH_RESET_AP () { 1<<8; }") unless defined(&ETH_RESET_AP);
    eval("sub ETH_RESET_DEDICATED () { 0x0000ffff; }") unless defined(&ETH_RESET_DEDICATED);
    eval("sub ETH_RESET_ALL () { 0xffffffff; }") unless defined(&ETH_RESET_ALL);
    eval 'sub ETH_RESET_SHARED_SHIFT () {16;}' unless defined(&ETH_RESET_SHARED_SHIFT);
}
1;
