require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SUNRPC_XPRT_H)) {
    eval 'sub _LINUX_SUNRPC_XPRT_H () {1;}' unless defined(&_LINUX_SUNRPC_XPRT_H);
    require 'linux/uio.ph';
    require 'linux/socket.ph';
    require 'linux/in.ph';
    require 'linux/sunrpc/sched.ph';
    eval 'sub MAX_IOVEC () {10;}' unless defined(&MAX_IOVEC);
    eval 'sub RPC_MAXCONG () {16;}' unless defined(&RPC_MAXCONG);
    eval 'sub RPC_MAXREQS () {( &RPC_MAXCONG + 1);}' unless defined(&RPC_MAXREQS);
    eval 'sub RPC_CWNDSCALE () {256;}' unless defined(&RPC_CWNDSCALE);
    eval 'sub RPC_MAXCWND () {( &RPC_MAXCONG *  &RPC_CWNDSCALE);}' unless defined(&RPC_MAXCWND);
    eval 'sub RPC_INITCWND () { &RPC_CWNDSCALE;}' unless defined(&RPC_INITCWND);
    eval 'sub RPCXPRT_CONGESTED {
        my($xprt) = @_;
	    eval q((($xprt)-> &cong >= ($xprt)-> &cwnd));
    }' unless defined(&RPCXPRT_CONGESTED);
    eval 'sub RPC_MAX_UDP_TIMEOUT () {(60* &HZ);}' unless defined(&RPC_MAX_UDP_TIMEOUT);
    eval 'sub RPC_MAX_TCP_TIMEOUT () {(600* &HZ);}' unless defined(&RPC_MAX_TCP_TIMEOUT);
    eval 'sub RPC_CALLHDRSIZE () {6;}' unless defined(&RPC_CALLHDRSIZE);
    eval 'sub RPC_REPHDRSIZE () {4;}' unless defined(&RPC_REPHDRSIZE);
    if(defined(&RPC_PROFILE)) {
    }
    eval 'sub rq_svec () { ($rq_snd_buf->{io_vec});}' unless defined(&rq_svec);
    eval 'sub rq_snr () { ($rq_snd_buf->{io_nr});}' unless defined(&rq_snr);
    eval 'sub rq_slen () { ($rq_snd_buf->{io_len});}' unless defined(&rq_slen);
    eval 'sub rq_rvec () { ($rq_rcv_buf->{io_vec});}' unless defined(&rq_rvec);
    eval 'sub rq_rnr () { ($rq_rcv_buf->{io_nr});}' unless defined(&rq_rnr);
    eval 'sub rq_rlen () { ($rq_rcv_buf->{io_len});}' unless defined(&rq_rlen);
    if(defined(&__KERNEL__)) {
	eval 'sub XPRT_WSPACE () {0;}' unless defined(&XPRT_WSPACE);
	eval 'sub XPRT_CONNECT () {1;}' unless defined(&XPRT_CONNECT);
	eval 'sub xprt_wspace {
	    my($xp) = @_;
    	    eval q(( &test_bit( &XPRT_WSPACE, ($xp)-> &sockstate)));
	}' unless defined(&xprt_wspace);
	eval 'sub xprt_test_and_set_wspace {
	    my($xp) = @_;
    	    eval q(( &test_and_set_bit( &XPRT_WSPACE, ($xp)-> &sockstate)));
	}' unless defined(&xprt_test_and_set_wspace);
	eval 'sub xprt_clear_wspace {
	    my($xp) = @_;
    	    eval q(( &clear_bit( &XPRT_WSPACE, ($xp)-> &sockstate)));
	}' unless defined(&xprt_clear_wspace);
	eval 'sub xprt_connected {
	    my($xp) = @_;
    	    eval q((!($xp)-> &stream ||  &test_bit( &XPRT_CONNECT, ($xp)-> &sockstate)));
	}' unless defined(&xprt_connected);
	eval 'sub xprt_set_connected {
	    my($xp) = @_;
    	    eval q(( &set_bit( &XPRT_CONNECT, ($xp)-> &sockstate)));
	}' unless defined(&xprt_set_connected);
	eval 'sub xprt_test_and_set_connected {
	    my($xp) = @_;
    	    eval q(( &test_and_set_bit( &XPRT_CONNECT, ($xp)-> &sockstate)));
	}' unless defined(&xprt_test_and_set_connected);
	eval 'sub xprt_clear_connected {
	    my($xp) = @_;
    	    eval q(( &clear_bit( &XPRT_CONNECT, ($xp)-> &sockstate)));
	}' unless defined(&xprt_clear_connected);
    }
}
1;
