require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_X86_64_BITOPS_H)) {
    eval 'sub _X86_64_BITOPS_H () {1;}' unless defined(&_X86_64_BITOPS_H);
    require 'asm/alternative.ph';
    eval 'sub ADDR () {(*( &volatile \'long\' *)  &addr);}' unless defined(&ADDR);
    eval 'sub __clear_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__clear_bit);
    eval 'sub smp_mb__before_clear_bit () {
        eval q( &barrier());
    }' unless defined(&smp_mb__before_clear_bit);
    eval 'sub smp_mb__after_clear_bit () {
        eval q( &barrier());
    }' unless defined(&smp_mb__after_clear_bit);
    if(0) {
    }
    eval 'sub constant_test_bit {
        my($nr,$addr) = @_;
	    eval q({ ((1 << ($nr & 31)) & ((( &const  &volatile my $int *) $addr)[$nr >> 5])) != 0; });
    }' unless defined(&constant_test_bit);
    eval 'sub variable_test_bit {
        my($nr,$addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&variable_test_bit);
    eval 'sub test_bit {
        my($nr,$addr) = @_;
	    eval q(( &__builtin_constant_p($nr) ?  &constant_test_bit(($nr),($addr)) :  &variable_test_bit(($nr),($addr))));
    }' unless defined(&test_bit);
    undef(&ADDR) if defined(&ADDR);
    eval 'sub find_first_bit {
        my($addr,$size) = @_;
	    eval q((( &__builtin_constant_p  && <=  &BITS_PER_LONG ? ( &__scanbit(*$addr,($size))) :  &find_first_bit($addr,$size))));
    }' unless defined(&find_first_bit);
    eval 'sub find_next_bit {
        my($addr,$size,$off) = @_;
	    eval q((( &__builtin_constant_p  && <=  &BITS_PER_LONG ? ( + ( &__scanbit((*$addr) >> ($off),($size)-($off)))) :  &find_next_bit($addr,$size,$off))));
    }' unless defined(&find_next_bit);
    eval 'sub find_first_zero_bit {
        my($addr,$size) = @_;
	    eval q((( &__builtin_constant_p  && <=  &BITS_PER_LONG ? ( &__scanbit(~*$addr,($size))) :  &find_first_zero_bit($addr,$size))));
    }' unless defined(&find_first_zero_bit);
    eval 'sub find_next_zero_bit {
        my($addr,$size,$off) = @_;
	    eval q((( &__builtin_constant_p  && <=  &BITS_PER_LONG ? (+( &__scanbit(~(((*$addr)) >> ($off)),($size)-($off)))) :  &find_next_zero_bit($addr,$size,$off))));
    }' unless defined(&find_next_zero_bit);
    eval 'sub set_bit_string {
        my($bitmap,$i,$len) = @_;
	    eval q({ my $end = $i + $len;  &while ($i <  $end) {  &__set_bit($i, $bitmap); $i++; } } );
    }' unless defined(&set_bit_string);
    eval 'sub __clear_bit_string {
        my($bitmap,$i,$len) = @_;
	    eval q({ my $end = $i + $len;  &while ($i <  $end) {  &__clear_bit($i, $bitmap); $i++; } } );
    }' unless defined(&__clear_bit_string);
    if(defined(&__KERNEL__)) {
	require 'asm-generic/bitops/sched.ph';
	require 'asm-generic/bitops/hweight.ph';
    }
    if(defined(&__KERNEL__)) {
	require 'asm-generic/bitops/ext2-non-atomic.ph';
	eval 'sub ext2_set_bit_atomic {
	    my($lock,$nr,$addr) = @_;
    	    eval q( &test_and_set_bit(,$addr));
	}' unless defined(&ext2_set_bit_atomic);
	eval 'sub ext2_clear_bit_atomic {
	    my($lock,$nr,$addr) = @_;
    	    eval q( &test_and_clear_bit(,$addr));
	}' unless defined(&ext2_clear_bit_atomic);
	require 'asm-generic/bitops/minix.ph';
    }
}
1;
