require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX__AIO_H)) {
    eval 'sub __LINUX__AIO_H () {1;}' unless defined(&__LINUX__AIO_H);
    require 'linux/list.ph';
    require 'linux/workqueue.ph';
    require 'linux/aio_abi.ph';
    require 'asm/atomic.ph';
    eval 'sub AIO_MAXSEGS () {4;}' unless defined(&AIO_MAXSEGS);
    eval 'sub AIO_KIOGRP_NR_ATOMIC () {8;}' unless defined(&AIO_KIOGRP_NR_ATOMIC);
    eval 'sub KIOCB_C_CANCELLED () {0x1;}' unless defined(&KIOCB_C_CANCELLED);
    eval 'sub KIOCB_C_COMPLETE () {0x2;}' unless defined(&KIOCB_C_COMPLETE);
    eval 'sub KIOCB_SYNC_KEY () {(~0);}' unless defined(&KIOCB_SYNC_KEY);
    eval 'sub KIF_KICKED () {1;}' unless defined(&KIF_KICKED);
    eval 'sub KIF_CANCELLED () {2;}' unless defined(&KIF_CANCELLED);
    eval 'sub kiocbTryLock {
        my($iocb) = @_;
	    eval q( &test_and_set_bit( &KIF_LOCKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbTryLock);
    eval 'sub kiocbTryKick {
        my($iocb) = @_;
	    eval q( &test_and_set_bit( &KIF_KICKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbTryKick);
    eval 'sub kiocbSetLocked {
        my($iocb) = @_;
	    eval q( &set_bit( &KIF_LOCKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbSetLocked);
    eval 'sub kiocbSetKicked {
        my($iocb) = @_;
	    eval q( &set_bit( &KIF_KICKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbSetKicked);
    eval 'sub kiocbSetCancelled {
        my($iocb) = @_;
	    eval q( &set_bit( &KIF_CANCELLED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbSetCancelled);
    eval 'sub kiocbClearLocked {
        my($iocb) = @_;
	    eval q( &clear_bit( &KIF_LOCKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbClearLocked);
    eval 'sub kiocbClearKicked {
        my($iocb) = @_;
	    eval q( &clear_bit( &KIF_KICKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbClearKicked);
    eval 'sub kiocbClearCancelled {
        my($iocb) = @_;
	    eval q( &clear_bit( &KIF_CANCELLED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbClearCancelled);
    eval 'sub kiocbIsLocked {
        my($iocb) = @_;
	    eval q( &test_bit( &KIF_LOCKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbIsLocked);
    eval 'sub kiocbIsKicked {
        my($iocb) = @_;
	    eval q( &test_bit( &KIF_KICKED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbIsKicked);
    eval 'sub kiocbIsCancelled {
        my($iocb) = @_;
	    eval q( &test_bit( &KIF_CANCELLED, ($iocb)-> &ki_flags));
    }' unless defined(&kiocbIsCancelled);
    eval 'sub is_sync_kiocb {
        my($iocb) = @_;
	    eval q((($iocb)-> &ki_key ==  &KIOCB_SYNC_KEY));
    }' unless defined(&is_sync_kiocb);
    eval 'sub init_sync_kiocb {
        my($x, $filp) = @_;
	    eval q( &do { 1; ($x)-> &ki_flags = 0; ($x)-> &ki_users = 1; ($x)-> &ki_key =  &KIOCB_SYNC_KEY; ($x)-> &ki_filp = ($filp); ($x)-> &ki_ctx =  &NULL; ($x)-> &ki_cancel =  &NULL; ($x)-> &ki_retry =  &NULL; ($x)-> &ki_dtor =  &NULL; ($x)-> ($ki_obj->{tsk}) =  &tsk; ($x)-> &ki_user_data = 0;  &init_wait((($x)-> &ki_wait)); }  &while (0));
    }' unless defined(&init_sync_kiocb);
    eval 'sub AIO_RING_MAGIC () {0xa10a10a1;}' unless defined(&AIO_RING_MAGIC);
    eval 'sub AIO_RING_COMPAT_FEATURES () {1;}' unless defined(&AIO_RING_COMPAT_FEATURES);
    eval 'sub AIO_RING_INCOMPAT_FEATURES () {0;}' unless defined(&AIO_RING_INCOMPAT_FEATURES);
    eval 'sub aio_ring_avail {
        my($info, $ring) = @_;
	    eval q(((($ring)-> &head + ($info)-> &nr - 1- ($ring)-> &tail) % ($info)-> &nr));
    }' unless defined(&aio_ring_avail);
    eval 'sub AIO_RING_PAGES () {8;}' unless defined(&AIO_RING_PAGES);
    eval 'sub get_ioctx {
        my($kioctx) = @_;
	    eval q( &do {  &BUG_ON( &unlikely( &atomic_read(($kioctx)-> &users) <= 0));  &atomic_inc(($kioctx)-> &users); }  &while (0));
    }' unless defined(&get_ioctx);
    eval 'sub put_ioctx {
        my($kioctx) = @_;
	    eval q( &do {  &BUG_ON( &unlikely( &atomic_read(($kioctx)-> &users) <= 0));  &if ( &unlikely( &atomic_dec_and_test(($kioctx)-> &users)))  &__put_ioctx($kioctx); }  &while (0));
    }' unless defined(&put_ioctx);
    eval 'sub in_aio () {
        eval q(! &is_sync_wait( ($current->{io_wait})));
    }' unless defined(&in_aio);
    eval 'sub warn_if_async () {
        eval q( &do {  &if ( &in_aio()) {  &printk( &KERN_ERR \\"%s(%s:%d) called in async context!\\\\n\\",  &__FUNCTION__,  &__FILE__,  &__LINE__);  &dump_stack(); } }  &while (0));
    }' unless defined(&warn_if_async);
    eval 'sub io_wait_to_kiocb {
        my($wait) = @_;
	    eval q( &container_of($wait, 1;
    }' unless defined(&io_wait_to_kiocb);
    eval 'sub is_retried_kiocb {
        my($iocb) = @_;
	    eval q((($iocb)-> &ki_retried > 1));
    }' unless defined(&is_retried_kiocb);
    require 'linux/aio_abi.ph';
    eval 'sub kiocb {
        eval q(* &list_kiocb(1; });
    }' unless defined(&kiocb);
}
1;
