# Copyright 2007 Gentoo Foundation
# Copyright 2007-2008 Roy Marples <roy@marples.name>
# All rights reserved. Released under the 2-clause BSD license.

has_addon()
{
	[ -e "${RC_LIBDIR}/addons/$1.sh" ] || [ -e /lib64/rcscripts/addons/"$1".sh ]
}

_addon_warn()
{
	eindent
	ewarn "${RC_SVCNAME} uses addon code which is now deprecated in OpenRC"
	ewarn "and is not guaranteed to be present in future versions."
	eoutdent
}

import_addon()
{
	if [ -e "${RC_LIBDIR}/addons/$1.sh" ]; then
		_addon_warn
		. "${RC_LIBDIR}/addons/$1.sh"
	elif [ -e /lib64/rcscripts/addons/"$1".sh ]; then
		_addon_warn
		. /lib64/rcscripts/addons/"$1".sh
	else
		return 1
	fi
}

start_addon()
{
	( import_addon "$1-start" )
}

stop_addon()
{
	( import_addon "$1-stop" )
}

net_fs_list="afs cifs coda davfs fuse gfs ncpfs nfs nfs4 ocfs2 shfs smbfs"
is_net_fs()
{
	[ -z "$1" ] && return 1

	# Check OS specific flags to see if we're local or net mounted
	mountinfo --quiet --netdev "$1"  && return 0
	mountinfo --quiet --nonetdev "$1" && return 1

	# Fall back on fs types
	local t=$(mountinfo --fstype "$1")
	for x in ${net_fs_list}; do
		[ "${x}" = "${t}" ] && return 0
	done
	return 1
}

is_union_fs()
{
	[ ! -x /sbin/unionctl ] && return 1
	unionctl "$1" --list >/dev/null 2>&1
}

get_bootparam()
{
	local match="$1"
	[ -z "${match}" -o ! -r /proc/cmdline ] && return 1

	set -- $(cat /proc/cmdline)
	while [ -n "$1" ]; do
		[ "$1" = "${match}" ] && return 0
		case "$1" in
			gentoo=*)
				local params="${1##*=}"
				local IFS=, x=
				for x in ${params}; do
					[ "${x}" = "${match}" ] && return 0
				done
				;;
		esac
		shift
	done

	return 1
}

# Add our sbin to $PATH
case "${PATH}" in
	"${RC_LIBDIR}"/sbin|"${RC_LIBDIR}"/sbin:*);;
	*) export PATH="${RC_LIBDIR}/sbin:${PATH}";;
esac
