# elog/mod_save_summary.py - elog dispatch module
# Copyright 2006-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id: mod_save_summary.py 9273 2008-02-05 08:21:06Z genone $

import os, time
from portage.data import portage_uid, portage_gid
from portage.util import ensure_dirs, apply_permissions

def process(mysettings, key, logentries, fulltext):
	if mysettings["PORT_LOGDIR"] != "":
		elogdir = os.path.join(mysettings["PORT_LOGDIR"], "elog")
	else:
		elogdir = os.path.join(os.sep, "var", "log", "portage", "elog")
	ensure_dirs(elogdir, uid=portage_uid, gid=portage_gid, mode=02770)

	# TODO: Locking
	elogfilename = elogdir+"/summary.log"
	elogfile = open(elogfilename, "a")
	apply_permissions(elogfilename, mode=060, mask=0)
	elogfile.write(">>> Messages generated by process %d on %s for package %s:\n\n" % \
			(os.getpid(), time.strftime("%Y-%m-%d %H:%M:%S %Z", time.localtime(time.time())), key))
	elogfile.write(fulltext)
	elogfile.write("\n")
	elogfile.close()

	return elogfilename
