#!/bin/bash

# Copyright (c) 2005, 2007 Gentoo Foundation.
# $Id$
# This file is part of the 'eselect' tools framework.
#
# eselect is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# eselect is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# eselect; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA  02111-1307  USA

paludis_command() {
    echo ${PALUDIS_COMMAND:-paludis}
}

# paludis_best-version PRIVATE
# Run paludis --best-version with safe filename as set by configure
paludis_best-version() {
    $(paludis_command) --best-version $* 2> /dev/null
}

# paludis-envvar PRIVATE
# Run paludis --environment-variable with safe filename as set by configure
paludis_envvar() {
    $(paludis_command) --environment-variable $* 2> /dev/null
}

# paludis_has-version PRIVATE
# Run paludis --has-version with safe filename as set by configure
paludis_has-version() {
    $(paludis_command) --has-version $* 2> /dev/null
}

# vim: set sw=4 et sts=4 tw=80 :
