/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.common.types.Streamable;
import com.metamatrix.core.jdbc.SQLXML;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import javax.xml.transform.Source;

public class XMLType
implements Streamable,
SQLXML {
    transient SQLXML srcXML;
    String referenceStreamId;
    String persistenceStreamId;

    public XMLType() {
    }

    public XMLType(SQLXML xml) {
        if (xml == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("XMLValue.isNUll"));
        }
        this.srcXML = xml;
    }

    public String getReferenceStreamId() {
        return this.referenceStreamId;
    }

    public void setReferenceStreamId(String id) {
        this.referenceStreamId = id;
    }

    public String getPersistenceStreamId() {
        return this.persistenceStreamId;
    }

    public void setPersistenceStreamId(String id) {
        this.persistenceStreamId = id;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkReference();
        return this.srcXML.getBinaryStream();
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkReference();
        return this.srcXML.getCharacterStream();
    }

    public Source getSource(Class sourceClass) throws SQLException {
        this.checkReference();
        return this.srcXML.getSource(sourceClass);
    }

    public String getString() throws SQLException {
        this.checkReference();
        return this.srcXML.getString();
    }

    public OutputStream setBinaryStream() throws SQLException {
        this.checkReference();
        return this.srcXML.setBinaryStream();
    }

    public Writer setCharacterStream() throws SQLException {
        this.checkReference();
        return this.srcXML.setCharacterStream();
    }

    public void setString(String value) throws SQLException {
        this.checkReference();
        this.srcXML.setString(value);
    }

    public boolean equals(Object o) {
        this.checkReference();
        return this.srcXML.equals(o);
    }

    public String toString() {
        this.checkReference();
        return this.srcXML.toString();
    }

    private void checkReference() {
        if (this.srcXML == null) {
            throw new InvalidReferenceException(CommonPlugin.Util.getString("XMLValue.InvalidReference"));
        }
    }
}

